package Acme::CPANAuthors::CPAN::Streaks::MonthlyNewDistributions::Current;

use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-06-01'; # DATE
our $DIST = 'Acme-CPANAuthorsBundle-CPAN-Streaks'; # DIST
our $VERSION = '20240601.0'; # VERSION

use Acme::CPANAuthors::Register (
    'PERLANCAR' => '',
    'SKIM' => '',
    'DJERIUS' => '',
    'BRIANDFOY' => '',
    'GBROWN' => '',
    'GDT' => '',
    'LNATION' => '',
    'TIMKA' => '',
    'TYRRMINAL' => '',
    'BPS' => '',
    'DERIV' => '',
    'EHUELS' => '',
    'EXODIST' => '',
    'HAARG' => '',
    'HANJE' => '',
    'JDEGUEST' => '',
    'LHRST' => '',
    'MARKOV' => '',
    'MBALLARIN' => '',
    'MVSJES' => '',
    'NAUTOFON' => '',
    'OLIVER' => '',
    'OVID' => '',
    'PLICEASE' => '',
    'QGARNIER' => '',
    'RJBS' => '',
    'SVW' => '',
    'TEODESIAN' => '',
    'TONYC' => '',
    'YOSHIMASA' => '',
);


1;
# ABSTRACT: Authors with ongoing monthly new distributions streak (release a new distribution every month)

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANAuthors::CPAN::Streaks::MonthlyNewDistributions::Current - Authors with ongoing monthly new distributions streak (release a new distribution every month)

=head1 VERSION

This document describes version 20240601.0 of Acme::CPANAuthors::CPAN::Streaks::MonthlyNewDistributions::Current (from Perl distribution Acme-CPANAuthorsBundle-CPAN-Streaks), released on 2024-06-01.

=head1 SYNOPSIS

=head1 DESCRIPTION

Current standings (as of 2024-06-01, produced by L<cpan-streaks>):

  +-----------+-----+------------+-------------+
  | author    | len | start_date | status      |
  +-----------+-----+------------+-------------+
  | PERLANCAR | 119 | 2014-08    | ongoing     |
  | SKIM      |  15 | 2023-03    | might-break |
  | DJERIUS   |   6 | 2023-12    | might-break |
  | BRIANDFOY |   4 | 2024-02    | might-break |
  | GBROWN    |   2 | 2024-04    | might-break |
  | GDT       |   2 | 2024-04    | might-break |
  | LNATION   |   2 | 2024-04    | might-break |
  | TIMKA     |   2 | 2024-04    | might-break |
  | TYRRMINAL |   2 | 2024-04    | might-break |
  | BPS       |   1 | 2024-05    | might-break |
  | DERIV     |   1 | 2024-05    | might-break |
  | EHUELS    |   1 | 2024-05    | might-break |
  | EXODIST   |   1 | 2024-05    | might-break |
  | HAARG     |   1 | 2024-05    | might-break |
  | HANJE     |   1 | 2024-05    | might-break |
  | JDEGUEST  |   1 | 2024-05    | might-break |
  | LHRST     |   1 | 2024-05    | might-break |
  | MARKOV    |   1 | 2024-05    | might-break |
  | MBALLARIN |   1 | 2024-05    | might-break |
  | MVSJES    |   1 | 2024-05    | might-break |
  | NAUTOFON  |   1 | 2024-05    | might-break |
  | OLIVER    |   1 | 2024-05    | might-break |
  | OVID      |   1 | 2024-05    | might-break |
  | PLICEASE  |   1 | 2024-05    | might-break |
  | QGARNIER  |   1 | 2024-05    | might-break |
  | RJBS      |   1 | 2024-05    | might-break |
  | SVW       |   1 | 2024-05    | might-break |
  | TEODESIAN |   1 | 2024-05    | might-break |
  | TONYC     |   1 | 2024-05    | might-break |
  | YOSHIMASA |   1 | 2024-05    | might-break |
  +-----------+-----+------------+-------------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SEE ALSO

L<Acme::CPANAuthors>

CPAN Regulars Boards, L<http://cpan.io/board/once-a/>, which as of this writing,
has some input data missing and thus produces some incorrect results.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024, 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANAuthorsBundle-CPAN-Streaks>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
