package Win32::Pipe;

# Win32::Pipe.pm
#       +==========================================================+
#       |                                                          |
#       |                     PIPE.PM package                      |
#       |                     ---------------                      |
#       |                                                          |
#       |  Copyright (c) 1996-1998 Dave Roth. All rights reserved. |
#       |   This program is free software; you can redistribute    |
#       | it and/or modify it under the same terms as Perl itself. |
#       |                                                          |
#       +==========================================================+
#
#
#	Use under GNU General Public License or Larry Wall's "Artistic License"
#
#	Check the README.TXT file that comes with this package for details about
#	it's history.
#

$PACKAGE = $Package = "Win32::Pipe";

require DynaLoader;
require Exporter;


@ISA= qw( Exporter DynaLoader );
    # Items to export into callers namespace by default. Note: do not export
    # names by default without a very good reason. Use EXPORT_OK instead.
    # Do not simply export all your public functions/methods/constants.
@EXPORT = qw(

            DEFAULT_WAIT_TIME

            STD_INPUT_HANDLE
            STD_OUTPUT_HANDLE
            STD_ERROR_HANDLE

            PIPE_TYPE_BYTE
            PIPE_TYPE_MESSAGE

            PIPE_READMODE_BYTE
            PIPE_READMODE_MESSAGE

            NMPWAIT_NOWAIT
            NMPWAIT_WAIT_FOREVER
            NMPWAIT_USE_DEFAULT_WAIT

            ERROR_MORE_DATA

            WRITE_DAC
            WRITE_OWNER
            ACCESS_SYSTEM_SECURITY

            ERROR_PIPE_CONNECTED
            ERROR_NO_DATA
            ERROR_PIPE_LISTENING

            PIPE_NOWAIT       
            PIPE_WAIT         
);

$ErrorNum = 0;
$ErrorText = "";

sub new
{
    my ($self, $Pipe);
    my ( $Handle );
    my ( $Type ) = shift @_;
    ($Pipe, $Handle) = Create( @_ );

    if( $Pipe )
    {
        $self = bless {};
        $self->{'m_pPipe'} = $Pipe;
        $self->{'m_hPipe'} = $Handle;
    }
    else
    {
        # If $Pipe == 0 then $Handle is the error
        $ErrorNum = $Handle;
        return undef;
    }
    $self;
}

sub Error{
    my( $Self ) = @_;
    my( $MyError, $MyErrorText, $Temp );
    if( ! ref( $Self ) )
    {
        undef $Temp;
    }
    else
    {
        $Temp = $Self->{'Pipe'};
    }
    ( $MyError, $MyErrorText ) = PipeError( $Temp );
    return wantarray? ($MyError, $MyErrorText):"[$MyError] \"$MyErrorText\"";
}

####
#   Auto-Kill an instance of this module
####
sub DESTROY
{
    my( $Self ) = shift;
    Close( $Self );
}

sub Credit{
}

sub VERSION
{
    print "Checking version...\n";

    if( $Version < $_[0] )
    {
        die "The $PACKAGE extension is version $Version.  You require at least version $_[0].\n";
    }
}

bootstrap $Package;
$VERSION = $Version = eval( $PACKAGE . "::GetVersion();" );

sub AUTOLOAD 
{
    # This AUTOLOAD is used to 'autoload' constants from the constant()
    # XS function.  If a constant is not found then control is passed
    # to the AUTOLOAD in AutoLoader.

    my( $Constant ) = $AUTOLOAD;
    my( $Result, $Value );
    $Constant =~ s/.*:://;

    $Result = Constant( $Constant, $Value );

    if( 0 == $Result )
    {
        # The extension could not resolve the constant...
        $AutoLoader::AUTOLOAD = $AUTOLOAD;
            goto &AutoLoader::AUTOLOAD;
        return;
    }
    elsif( 1 == $Result )
    {
        # $Result == 1 if the constant is valid but not defined
        # that is, the extension knows that the constant exists but for
        # some wild reason it was not compiled with it.
        $pack = 0; 
        ($pack,$file,$line) = caller;
        print "Your vendor has not defined $Package macro $constname, used in $file at line $line.";
    }
    elsif( 2 == $Result )
    {
        # If $Result == 2 then we have a string value
        $Value = "'$Value'";
    }
        # If $Result == 3 then we have a numeric value

    eval "sub $AUTOLOAD { return( $Value ); }";
    goto &$AUTOLOAD;
}


1;
__END__



