# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::JP;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20240607153920;

my $formatters = [
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '00777[01]',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            (?:
              12|
              57|
              99
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              267|
              3(?:
                7[247]|
                9[278]
              )|
              466|
              5(?:
                47|
                58|
                64
              )|
              6(?:
                3[245]|
                48|
                5[4-68]
              )
            )|
            499[2468]|
            5(?:
              769|
              979[2-69]
            )|
            7468|
            8(?:
              3(?:
                8[7-9]|
                96[2457-9]
              )|
              477|
              51[2-9]
            )|
            9(?:
              802|
              9(?:
                1[23]|
                69
              )
            )|
            1(?:
              45|
              58
            )[67]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d)(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '60',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [36]|
            4(?:
              2(?:
                0|
                9[02-69]
              )|
              7(?:
                0[019]|
                1
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              1|
              5(?:
                4[018]|
                5[017]
              )|
              77|
              88|
              9[69]
            )|
            2(?:
              2[127]|
              3[0-269]|
              4[59]|
              5(?:
                [1-3]|
                5[0-69]|
                9(?:
                  17|
                  99
                )
              )|
              6(?:
                2|
                4[016-9]
              )|
              7(?:
                [1-35]|
                8[0189]
              )|
              8(?:
                [16]|
                3[0134]|
                9[0-5]
              )|
              9(?:
                [028]|
                17
              )
            )|
            4(?:
              2(?:
                [13-79]|
                8[014-6]
              )|
              3[0-57]|
              [45]|
              6[248]|
              7[2-47]|
              9[29]
            )|
            5(?:
              2|
              3(?:
                [045]|
                9(?:
                  [0-58]|
                  6[4-9]|
                  7[0-35689]
                )
              )|
              4[0-369]|
              5[29]|
              8[02389]|
              9[0-3]
            )|
            7(?:
              2[02-46-9]|
              34|
              [58]|
              6[0249]|
              7[57]|
              9(?:
                [23]|
                4[0-59]|
                5[01569]|
                6[0167]
              )
            )|
            8(?:
              2(?:
                [1258]|
                4[0-39]|
                9[0169]
              )|
              3(?:
                [29]|
                60|
                7(?:
                  [017-9]|
                  6[6-8]
                )
              )|
              49|
              51|
              6(?:
                [0-24]|
                36[2-57-9]|
                5(?:
                  [0-389]|
                  5[23]
                )|
                6(?:
                  [01]|
                  9[178]
                )|
                7(?:
                  2[2-468]|
                  3[78]
                )|
                9[0145]
              )|
              7[0-468]|
              8[68]
            )|
            9(?:
              4[15]|
              5[138]|
              7[156]|
              8[189]|
              9(?:
                [1289]|
                3(?:
                  31|
                  4[357]
                )|
                4[0178]
              )
            )|
            (?:
              8294|
              96
            )[1-3]|
            2(?:
              57|
              93
            )[015-9]|
            (?:
              223|
              8699
            )[014-9]|
            (?:
              25[0468]|
              422|
              838
            )[01]|
            (?:
              48|
              8292|
              9[23]
            )[1-9]|
            (?:
              47[59]|
              59[89]|
              8(?:
                68|
                9
              )
            )[019]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [14]|
            [289][2-9]|
            5[3-9]|
            7[2-4679]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '0077',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '008',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '[257-9]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{4,5})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{5})(\\d{5,6})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{6})(\\d{6,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'geographic' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'mobile' => '[7-9]0[1-9]\\d{7}',
                'pager' => '20\\d{8}',
                'personal_number' => '60\\d{7}',
                'specialrate' => '(990\\d{6})|(570\\d{6})',
                'toll_free' => '
          00777(?:
            [01]|
            5\\d
          )\\d\\d|
          (?:
            00(?:
              7778|
              882[1245]
            )|
            (?:
              120|
              800\\d
            )\\d\\d
          )\\d{4}|
          00(?:
            37|
            66|
            78
          )\\d{6,13}
        ',
                'voip' => '50[1-9]\\d{7}'
              };
my %areanames = ();
$areanames{en} = {"81531", "Tahara\,\ Aichi",
"812244", "Shiroishi\,\ Miyagi",
"818652", "Kurashiki\,\ Okayama",
"812546", "Murakami\,\ Niigata",
"817356", "Kushimoto\,\ Wakayama",
"814220", "Kokubunji\,\ Tokyo",
"8125488", "Tsugawa\,\ Niigata",
"8112395", "Kuriyama\,\ Hokkaido",
"818397", "Ogori\,\ Yamaguchi",
"818978", "Hakata\,\ Ehime",
"8126178", "Omachi\,\ Nagano",
"81250", "Niitsu\,\ Niigata",
"817737", "Maizuru\,\ Kyoto",
"81983", "Takanabe\,\ Miyazaki",
"811865", "Odate\,\ Akita",
"81864", "Kurashiki\,\ Okayama",
"811563", "Honbetsu\,\ Hokkaido",
"81764", "Toyama\,\ Toyama",
"818972", "Niihama\,\ Ehime",
"817713", "Kameoka\,\ Kyoto",
"812793", "Shibukawa\,\ Gunma",
"819435", "Yame\,\ Fukuoka",
"812574", "Kashiwazaki\,\ Niigata",
"818689", "Okayama\,\ Okayama",
"8126171", "Omachi\,\ Nagano",
"819975", "Naze\,\ Kagoshima",
"819734", "Hita\,\ Oita",
"8175", "Kyoto\,\ Kyoto",
"8186996", "Seto\,\ Okayama",
"811955", "Ninohe\,\ Iwate",
"8125481", "Murakami\,\ Niigata",
"811534", "Nakashibetsu\,\ Hokkaido",
"811236", "Chitose\,\ Hokkaido",
"815745", "Minokamo\,\ Gifu",
"81225", "Ishinomaki\,\ Miyagi",
"817735", "Fukuchiyama\,\ Kyoto",
"818974", "Niihama\,\ Ehime",
"812580", "Tokamachi\,\ Niigata",
"81923", "Fukuoka\,\ Fukuoka",
"811867", "Takanosu\,\ Akita",
"812248", "Ogawara\,\ Miyagi",
"819943", "Kanoya\,\ Kagoshima",
"817940", "Kakogawa\,\ Hyogo",
"812859", "Oyama\,\ Tochigi",
"818693", "Oku\,\ Okayama",
"818654", "Kamogata\,\ Okayama",
"812613", "Omachi\,\ Nagano",
"812242", "Shiroishi\,\ Miyagi",
"812789", "Maebashi\,\ Gunma",
"81162", "Wakkanai\,\ Hokkaido",
"81992", "Kagoshima\,\ Kagoshima",
"817463", "Yoshino\,\ Nara",
"81737", "Yuasa\,\ Wakayama",
"811957", "Iwate\,\ Iwate",
"818463", "Takehara\,\ Hiroshima",
"819738", "Kusu\,\ Oita",
"81563", "Nishio\,\ Aichi",
"818946", "Uwajima\,\ Ehime",
"81463", "Hiratsuka\,\ Kanagawa",
"811532", "Nemuro\,\ Hokkaido",
"817946", "Miki\,\ Hyogo",
"812578", "Muika\,\ Niigata",
"812586", "Nagaoka\,\ Niigata",
"819437", "Tanushimaru\,\ Fukuoka",
"812876", "Kuroiso\,\ Tochigi",
"819732", "Hita\,\ Oita",
"81545", "Fuji\,\ Shizuoka",
"819977", "Setouchi\,\ Kagoshima",
"812572", "Kashiwazaki\,\ Niigata",
"811545", "Kushiro\,\ Hokkaido",
"811939", "Miyako\,\ Iwate",
"817485", "Yokaichi\,\ Shiga",
"818595", "Yonago\,\ Tottori",
"815734", "Ena\,\ Gifu",
"812659", "Ina\,\ Nagano",
"818893", "Sakawa\,\ Kochi",
"818206", "Yanai\,\ Yamaguchi",
"815983", "Matsusaka\,\ Mie",
"815394", "Hamamatsu\,\ Shizuoka",
"812562", "Sanjo\,\ Niigata",
"819967", "Izumi\,\ Kagoshima",
"812676", "Saku\,\ Nagano",
"815763", "Gero\,\ Gifu",
"817964", "Toyooka\,\ Hyogo",
"812386", "Nagai\,\ Yamagata",
"812372", "Murayama\,\ Yamagata",
"811587", "Nakayubetsu\,\ Hokkaido",
"819598", "Fukue\,\ Nagasaki",
"811877", "Omagari\,\ Akita",
"819936", "Kaseda\,\ Kagoshima",
"81857", "Tottori\,\ Tottori",
"819787", "Kunisaki\,\ Oita",
"81875", "Kan\'onji\,\ Kagawa",
"812235", "Sendai\,\ Miyagi",
"81583", "Gifu\,\ Gifu",
"81888", "Kochi\,\ Kochi",
"81182", "Yokote\,\ Akita",
"81775", "Otsu\,\ Shiga",
"812378", "Sagae\,\ Yamagata",
"811332", "Tobetsu\,\ Hokkaido",
"812997", "Itako\,\ Ibaraki",
"812956", "Hitachi\-Omiya\,\ Ibaraki",
"812837", "Sano\,\ Tochigi",
"819592", "Oseto\,\ Nagasaki",
"81963", "Kumamoto\,\ Kumamoto",
"812564", "Sanjo\,\ Niigata",
"815738", "Nakatsugawa\,\ Gifu",
"818369", "Ube\,\ Yamaguchi",
"81592", "Tsu\,\ Mie",
"819826", "Hyuga\,\ Miyazaki",
"812648", "Nagano\,\ Nagano",
"811363", "Kutchan\,\ Hokkaido",
"819747", "Taketa\,\ Oita",
"81492", "Kawagoe\,\ Saitama",
"8186994", "Seto\,\ Okayama",
"815392", "Hamamatsu\,\ Shizuoka",
"819965", "Satsumasendai\,\ Kagoshima",
"818293", "Hatsukaichi\,\ Hiroshima",
"818806", "Sukumo\,\ Kochi",
"81551", "Nirasaki\,\ Yamanashi",
"815732", "Ena\,\ Gifu",
"811547", "Shiranuka\,\ Hokkaido",
"818249", "Higashi\-ku\,\ Hiroshima",
"817487", "Minakuchi\,\ Shiga",
"814701", "Kamogawa\,\ Chiba",
"81243", "Nihonmatsu\,\ Fukushima",
"818556", "Gotsu\,\ Shimane",
"815398", "Hamamatsu\,\ Shizuoka",
"8153968", "Hamamatsu\,\ Shizuoka",
"815977", "Kumano\,\ Mie",
"8186698", "Kurashiki\,\ Okayama",
"8164", "Osaka\,\ Osaka",
"812237", "Sendai\,\ Miyagi",
"81423", "Kokubunji\,\ Tokyo",
"819785", "Bungotakada\,\ Oita",
"819553", "Imari\,\ Saga",
"8186691", "Kurashiki\,\ Okayama",
"8188095", "Tosashimizu\,\ Kochi",
"817915", "Aioi\,\ Hyogo",
"819803", "Nago\,\ Okinawa",
"81828", "Hiroshima\,\ Hiroshima",
"812995", "Ishioka\,\ Ibaraki",
"817968", "Hamasaka\,\ Hyogo",
"812835", "Sano\,\ Tochigi",
"8126172", "Omachi\,\ Nagano",
"81728", "Neyagawa\,\ Osaka",
"812374", "Murayama\,\ Yamagata",
"8198295", "Hyuga\,\ Miyazaki",
"815999", "Tsu\,\ Mie",
"8125482", "Murakami\,\ Niigata",
"811585", "Engaru\,\ Hokkaido",
"811753", "Mutsu\,\ Aomori",
"811875", "Kakunodate\,\ Akita",
"817962", "Toyooka\,\ Hyogo",
"8198298", "Hyuga\,\ Miyazaki",
"812649", "Nagano\,\ Nagano",
"818242", "Higashi\-ku\,\ Hiroshima",
"8112392", "Yubari\,\ Hokkaido",
"812654", "Iida\,\ Nagano",
"818368", "Ube\,\ Yamaguchi",
"812693", "Nakano\,\ Nagano",
"817368", "Iwade\,\ Wakayama",
"817613", "Komatsu\,\ Ishikawa",
"818844", "Anan\,\ Tokushima",
"817723", "Miyazu\,\ Kyoto",
"8199345", "Kagoshima\,\ Kagoshima",
"811853", "Oga\,\ Akita",
"811934", "Kamaishi\,\ Iwate",
"811555", "Obihiro\,\ Hokkaido",
"818362", "Ube\,\ Yamaguchi",
"818248", "Shobara\,\ Hiroshima",
"8188098", "Tosashimizu\,\ Kochi",
"819575", "Isahaya\,\ Nagasaki",
"818666", "Ibara\,\ Okayama",
"81725", "Izumi\,\ Osaka",
"81825", "Hiroshima\,\ Hiroshima",
"818490", "Onomichi\,\ Hiroshima",
"817457", "Yamatotakada\,\ Nara",
"819663", "Hitoyoshi\,\ Kumamoto",
"817496", "Nagahama\,\ Shiga",
"818660", "Seto\,\ Okayama",
"81432", "Chiba\,\ Chiba",
"812416", "Tajima\,\ Fukushima",
"81948", "Iizuka\,\ Fukuoka",
"815992", "Toba\,\ Mie",
"817706", "Obama\,\ Fukui",
"817969", "Hamasaka\,\ Hyogo",
"811526", "Abashiri\,\ Hokkaido",
"81532", "Toyohashi\,\ Aichi",
"814771", "Ichikawa\,\ Chiba",
"8153965", "Hamamatsu\,\ Shizuoka",
"818586", "Kurayoshi\,\ Tottori",
"81179", "Sannohe\,\ Aomori",
"815998", "Ago\,\ Mie",
"819726", "Usuki\,\ Oita",
"81774", "Uji\,\ Kyoto",
"8198291", "Nobeoka\,\ Miyazaki",
"814998", "Ogasawara\,\ Tokyo",
"81268", "Ueda\,\ Nagano",
"81885", "Komatsushima\,\ Tokushima",
"81778", "Takefu\,\ Fukui",
"811938", "Miyako\,\ Iwate",
"819577", "Shimabara\,\ Nagasaki",
"81878", "Takamatsu\,\ Kagawa",
"81172", "Hirosaki\,\ Aomori",
"818364", "Ube\,\ Yamaguchi",
"812658", "Ina\,\ Nagano",
"81473", "Ichikawa\,\ Chiba",
"811932", "Kamaishi\,\ Iwate",
"81439", "Kisarazu\,\ Chiba",
"818546", "Kakeya\,\ Shimane",
"812652", "Iida\,\ Nagano",
"818244", "Miyoshi\,\ Hiroshima",
"818842", "Anan\,\ Tokushima",
"81952", "Saga\,\ Saga",
"81944", "Setaka\,\ Fukuoka",
"81896", "Iyomishima\,\ Ehime",
"819599", "Oseto\,\ Nagasaki",
"819543", "Takeo\,\ Saga",
"817455", "Yamatotakada\,\ Nara",
"815994", "Ago\,\ Mie",
"81743", "Nara\,\ Nara",
"81548", "Haibara\,\ Shizuoka",
"812556", "Itoigawa\,\ Niigata",
"81932", "Kitakyushu\,\ Fukuoka",
"812782", "Numata\,\ Gunma",
"811357", "Iwanai\,\ Hokkaido",
"81797", "Nishinomiya\,\ Hyogo",
"811396", "Esashi\,\ Hokkaido",
"81559", "Numazu\,\ Shizuoka",
"812487", "Sukagawa\,\ Fukushima",
"812852", "Oyama\,\ Tochigi",
"81765", "Uozu\,\ Toyama",
"81284", "Ashikaga\,\ Tochigi",
"811736", "Goshogawara\,\ Aomori",
"811987", "Tono\,\ Iwate",
"819687", "Tamana\,\ Kumamoto",
"812788", "Maebashi\,\ Gunma",
"812858", "Mooka\,\ Tochigi",
"818564", "Masuda\,\ Shimane",
"812962", "Shimodate\,\ Ibaraki",
"818684", "Tsuyama\,\ Okayama",
"812744", "Fujioka\,\ Gunma",
"818374", "Nagato\,\ Yamaguchi",
"817684", "Wajima\,\ Ishikawa",
"818835", "Mima\,\ Tokushima",
"8147957", "Yokaichiba\,\ Chiba",
"817995", "Sumoto\,\ Hyogo",
"815755", "Sekigahara\,\ Gifu",
"814703", "Tateyama\,\ Chiba",
"8128798", "Otawara\,\ Tochigi",
"815583", "Shimoda\,\ Shizuoka",
"812968", "Kasama\,\ Ibaraki",
"814287", "Ome\,\ Tokyo",
"817904", "Fukusaki\,\ Hyogo",
"811462", "Urakawa\,\ Hokkaido",
"811945", "Kuji\,\ Iwate",
"814755", "Togane\,\ Chiba",
"812550", "Yasuzuka\,\ Niigata",
"819685", "Tamana\,\ Kumamoto",
"818562", "Masuda\,\ Shimane",
"811973", "Mizusawa\,\ Iwate",
"8112391", "Yubari\,\ Hokkaido",
"812784", "Numata\,\ Gunma",
"815367", "Shitara\,\ Aichi",
"812893", "Utsunomiya\,\ Tochigi",
"812854", "Oyama\,\ Tochigi",
"812933", "Takahagi\,\ Ibaraki",
"818568", "Tsuwano\,\ Shimane",
"817950", "Sanda\,\ Hyogo",
"819232", "Maebaru\,\ Fukuoka",
"812485", "Shirakawa\,\ Fukushima",
"8186997", "Seto\,\ Okayama",
"811653", "Shibetsu\,\ Hokkaido",
"819953", "Okuchi\,\ Kagoshima",
"81236", "Yamagata\,\ Yamagata",
"812473", "Ishikawa\,\ Fukushima",
"818688", "Mimasaka\,\ Okayama",
"812748", "Tomioka\,\ Gunma",
"817997", "Tsuna\,\ Hyogo",
"817902", "Fukusaki\,\ Hyogo",
"817956", "Sanda\,\ Hyogo",
"8126175", "Omachi\,\ Nagano",
"812917", "Mito\,\ Ibaraki",
"814285", "Sagamihara\,\ Kanagawa",
"818378", "Shimonoseki\,\ Yamaguchi",
"811464", "Shizunai\,\ Hokkaido",
"817688", "Noto\,\ Ishikawa",
"818956", "Uwajima\,\ Ehime",
"8183768", "Shimonoseki\,\ Yamaguchi",
"81288", "Imabari\,\ Ehime",
"81591", "Tsu\,\ Mie",
"814757", "Togane\,\ Chiba",
"814796", "Yokaichiba\,\ Chiba",
"811947", "Kuji\,\ Iwate",
"812742", "Fujioka\,\ Gunma",
"818682", "Tsuyama\,\ Okayama",
"817682", "Wajima\,\ Ishikawa",
"818372", "Nagato\,\ Yamaguchi",
"8125485", "Tsugawa\,\ Niigata",
"81552", "Kofu\,\ Yamanashi",
"81544", "Fujinomiya\,\ Shizuoka",
"81939", "Kitakyushu\,\ Fukuoka",
"817676", "Nanao\,\ Ishikawa",
"812964", "Shimodate\,\ Ibaraki",
"818676", "Kuse\,\ Okayama",
"8112398", "Kuriyama\,\ Hokkaido",
"8198292", "Nobeoka\,\ Miyazaki",
"81426", "Hachioji\,\ Tokyo",
"811364", "Kutchan\,\ Hokkaido",
"818478", "Tojo\,\ Hiroshima",
"819746", "Taketa\,\ Oita",
"8199331", "Kagoshima\,\ Kagoshima",
"819827", "Takachiho\,\ Miyazaki",
"812563", "Sanjo\,\ Niigata",
"81178", "Hachinohe\,\ Aomori",
"8153978", "Hamamatsu\,\ Shizuoka",
"81434", "Chiba\,\ Chiba",
"81987", "Nichinan\,\ Miyazaki",
"818205", "Yanai\,\ Yamaguchi",
"812230", "Sendai\,\ Miyagi",
"8182920", "Hatsukaichi\,\ Hiroshima",
"81958", "Nagasaki\,\ Nagasaki",
"818557", "Kawamoto\,\ Shimane",
"818596", "Yonago\,\ Tottori",
"817486", "Minakuchi\,\ Shiga",
"818294", "Hatsukaichi\,\ Hiroshima",
"818892", "Sakawa\,\ Kochi",
"818807", "Sukumo\,\ Kochi",
"815982", "Matsusaka\,\ Mie",
"81534", "Hamamatsu\,\ Shizuoka",
"81949", "Nogata\,\ Fukuoka",
"811546", "Kushiro\,\ Hokkaido",
"815768", "Gero\,\ Gifu",
"81196", "Morioka\,\ Iwate",
"819804", "Nago\,\ Okinawa",
"8186993", "Bizen\,\ Okayama",
"812955", "Hitachi\-Omiya\,\ Ibaraki",
"819554", "Imari\,\ Saga",
"811333", "Tobetsu\,\ Hokkaido",
"8153971", "Hamamatsu\,\ Shizuoka",
"812236", "Sendai\,\ Miyagi",
"819935", "Kaseda\,\ Kagoshima",
"819593", "Oseto\,\ Nagasaki",
"811635", "Hamatonbetsu\,\ Hokkaido",
"815762", "Gero\,\ Gifu",
"811754", "Mutsu\,\ Aomori",
"812385", "Yonezawa\,\ Yamagata",
"81246", "Iwaki\,\ Fukushima",
"812373", "Murayama\,\ Yamagata",
"812675", "Saku\,\ Nagano",
"811455", "Mukawa\,\ Hokkaido",
"813", "Tokyo",
"815959", "Kameyama\,\ Mie",
"818292", "Hiroshima\,\ Hiroshima",
"815733", "Ena\,\ Gifu",
"815984", "Matsusaka\,\ Mie",
"818555", "Gotsu\,\ Shimane",
"818894", "Susaki\,\ Kochi",
"812830", "Utsunomiya\,\ Tochigi",
"818474", "Fuchu\,\ Hiroshima",
"81927", "Fukuoka\,\ Fukuoka",
"819966", "Izumi\,\ Kagoshima",
"81586", "Ichinomiya\,\ Aichi",
"818298", "Hatsukaichi\,\ Hiroshima",
"81125", "Takikawa\,\ Hokkaido",
"811362", "Kutchan\,\ Hokkaido",
"819825", "Hyuga\,\ Miyazaki",
"81486", "Urawa\,\ Saitama",
"815393", "Hamamatsu\,\ Shizuoka",
"81833", "Kudamatsu\,\ Yamaguchi",
"819558", "Karatsu\,\ Saga",
"81567", "Tsushima\,\ Aichi",
"811876", "Omagari\,\ Akita",
"81538", "Iwata\,\ Shizuoka",
"811586", "Nakayubetsu\,\ Hokkaido",
"815764", "Gero\,\ Gifu",
"811752", "Mutsu\,\ Aomori",
"81438", "Kisarazu\,\ Chiba",
"812387", "Nagai\,\ Yamagata",
"819808", "Yaeyama\ District\,\ Okinawa",
"81942", "Kurume\,\ Fukuoka",
"81467", "Fujisawa\,\ Kanagawa",
"817963", "Toyooka\,\ Hyogo",
"812677", "Saku\,\ Nagano",
"8152", "Nagoya\,\ Aichi",
"812836", "Sano\,\ Tochigi",
"819552", "Imari\,\ Saga",
"8186552", "Kurashiki\,\ Okayama",
"81174", "Kanita\,\ Aomori",
"812957", "Daigo\,\ Ibaraki",
"81495", "Honjo\,\ Saitama",
"812996", "Itako\,\ Ibaraki",
"81262", "Nagano\,\ Nagano",
"819802", "Minamidaito\,\ Okinawa",
"81779", "Ono\,\ Gifu",
"81740", "Imazu\,\ Shiga",
"819937", "Kaseda\,\ Kagoshima",
"819786", "Kitsuki\,\ Oita",
"819679", "Takamori\,\ Kumamoto",
"81566", "Kariya\,\ Aichi",
"811866", "Takanosu\,\ Akita",
"81466", "Fujisawa\,\ Kanagawa",
"81721", "Tondabayashi\,\ Osaka",
"818973", "Niihama\,\ Ehime",
"811562", "Honbetsu\,\ Hokkaido",
"814297", "Hanno\,\ Saitama",
"818694", "Okayama\,\ Okayama",
"812939", "Mito\,\ Ibaraki",
"812614", "Omachi\,\ Nagano",
"812899", "Kanuma\,\ Tochigi",
"817355", "Shingu\,\ Fukuoka",
"812545", "Murakami\,\ Niigata",
"819944", "Kanoya\,\ Kagoshima",
"811644", "Rumoi\,\ Hokkaido",
"815746", "Minokamo\,\ Gifu",
"817947", "Miki\,\ Hyogo",
"8186999", "Seto\,\ Okayama",
"812798", "Naganohara\,\ Gunma",
"81282", "Tochigi\,\ Tochigi",
"817718", "Sonobe\,\ Kyoto",
"811235", "Yubari\,\ Hokkaido",
"818947", "Uwajima\,\ Ehime",
"817464", "Yoshino\,\ Nara",
"81926", "Fukuoka\,\ Fukuoka",
"811956", "Iwate\,\ Iwate",
"811378", "Imakane\,\ Hokkaido",
"818464", "Takehara\,\ Hiroshima",
"817712", "Kameoka\,\ Kyoto",
"812792", "Shibukawa\,\ Gunma",
"819976", "Naze\,\ Kagoshima",
"81853", "Izumo\,\ Shimane",
"81587", "Ichinomiya\,\ Aichi",
"812877", "Kuroiso\,\ Tochigi",
"81487", "Urawa\,\ Saitama",
"81549", "Shizuoka\,\ Shizuoka",
"81934", "Kitakyushu\,\ Fukuoka",
"812587", "Nagaoka\,\ Niigata",
"811372", "Shikabe\,\ Hokkaido",
"81938", "Kitakyushu\,\ Fukuoka",
"817357", "Kushimoto\,\ Wakayama",
"812547", "Murakami\,\ Niigata",
"81542", "Shizuoka\,\ Shizuoka",
"81554", "Otsuki\,\ Yamanashi",
"818692", "Oku\,\ Okayama",
"81143", "Muroran\,\ Hokkaido",
"812243", "Shiroishi\,\ Miyagi",
"812612", "Omachi\,\ Nagano",
"819948", "Shibushi\,\ Kagoshima",
"8169", "Osaka\,\ Osaka",
"811564", "Kamishihoro\,\ Hokkaido",
"814772", "Ichikawa\,\ Chiba",
"818698", "Bizen\,\ Okayama",
"817736", "Maizuru\,\ Kyoto",
"812618", "Omachi\,\ Nagano",
"817468", "Kamikitayama\,\ Nara",
"81427", "Sagamihara\,\ Kanagawa",
"811374", "Mori\,\ Hokkaido",
"819733", "Hita\,\ Oita",
"812794", "Shibukawa\,\ Gunma",
"812875", "Otawara\,\ Tochigi",
"817714", "Kameoka\,\ Kyoto",
"8153972", "Hamamatsu\,\ Shizuoka",
"812573", "Kashiwazaki\,\ Niigata",
"812585", "Nagaoka\,\ Niigata",
"817945", "Kakogawa\,\ Hyogo",
"818462", "Takehara\,\ Hiroshima",
"818945", "Yawatahama\,\ Ehime",
"814709", "Kamogawa\,\ Chiba",
"81986", "Miyakonojo\,\ Miyazaki",
"811237", "Kuriyama\,\ Hokkaido",
"81222", "Sendai\,\ Miyagi",
"811533", "Nemuro\,\ Hokkaido",
"811735", "Goshogawara\,\ Aomori",
"811974", "Mizusawa\,\ Iwate",
"819954", "Kajiki\,\ Kagoshima",
"811654", "Nayoro\,\ Hokkaido",
"812474", "Ishikawa\,\ Fukushima",
"811395", "Esashi\,\ Hokkaido",
"812894", "Utsunomiya\,\ Tochigi",
"812619", "Omachi\,\ Nagano",
"812555", "Itoigawa\,\ Niigata",
"812783", "Numata\,\ Gunma",
"812934", "Takahagi\,\ Ibaraki",
"815366", "Shitara\,\ Aichi",
"812853", "Oyama\,\ Tochigi",
"81420", "Tokorozawa\,\ Saitama",
"8182943", "Hiroshima\,\ Hiroshima",
"815582", "Shimoda\,\ Shizuoka",
"814756", "Togane\,\ Chiba",
"814702", "Tateyama\,\ Chiba",
"811946", "Kuji\,\ Iwate",
"814797", "Yokaichiba\,\ Chiba",
"8147950", "Yokaichiba\,\ Chiba",
"81862", "Okayama\,\ Okayama",
"81998", "Kagoshima\,\ Kagoshima",
"818957", "Misho\,\ Ehime",
"811463", "Urakawa\,\ Hokkaido",
"817996", "Tsuna\,\ Hyogo",
"818836", "Mima\,\ Tokushima",
"81762", "Kanazawa\,\ Ishikawa",
"818677", "Niimi\,\ Okayama",
"81935", "Kitakyushu\,\ Fukuoka",
"818387", "Tamagawa\,\ Yamaguchi",
"812963", "Shimodate\,\ Ibaraki",
"817677", "Nanao\,\ Ishikawa",
"814240", "Kokubunji\,\ Tokyo",
"8163", "Osaka\,\ Osaka",
"81233", "Shinjo\,\ Yamagata",
"812486", "Sukagawa\,\ Fukushima",
"814280", "Tachikawa\,\ Tokyo",
"812892", "Utsunomiya\,\ Tochigi",
"81480", "Kuki\,\ Saitama",
"811978", "Kitakami\,\ Iwate",
"811356", "Iwanai\,\ Hokkaido",
"811397", "Okushiri\,\ Hokkaido",
"81577", "Takayama\,\ Gifu",
"812932", "Takahagi\,\ Ibaraki",
"81555", "Fujiyoshida\,\ Yamanashi",
"819233", "Maebaru\,\ Fukuoka",
"817230", "Neyagawa\,\ Osaka",
"819952", "Okuchi\,\ Kagoshima",
"811652", "Shibetsu\,\ Hokkaido",
"812472", "Ishikawa\,\ Fukushima",
"81272", "Maebashi\,\ Gunma",
"812898", "Kanuma\,\ Tochigi",
"811972", "Mizusawa\,\ Iwate",
"812938", "Mito\,\ Ibaraki",
"818563", "Masuda\,\ Shimane",
"811986", "Tono\,\ Iwate",
"819686", "Tamana\,\ Kumamoto",
"811658", "Kamikawa\,\ Hokkaido",
"812478", "Miharu\,\ Fukushima",
"818675", "Kuse\,\ Okayama",
"818683", "Tsuyama\,\ Okayama",
"812743", "Fujioka\,\ Gunma",
"817675", "Nanao\,\ Ishikawa",
"818385", "Hagi\,\ Yamaguchi",
"817683", "Wajima\,\ Ishikawa",
"818373", "Nagato\,\ Yamaguchi",
"812799", "Naganohara\,\ Gunma",
"814795", "Choshi\,\ Chiba",
"817903", "Fukusaki\,\ Hyogo",
"815584", "Shimoda\,\ Shizuoka",
"818955", "Uwajima\,\ Ehime",
"814704", "Tateyama\,\ Chiba",
"814286", "Sagamihara\,\ Kanagawa",
"817955", "Sanda\,\ Hyogo",
"818363", "Ube\,\ Yamaguchi",
"817618", "Kaga\,\ Ishikawa",
"81184", "Yurihonjo\,\ Akita",
"818665", "Takahashi\,\ Okayama",
"812698", "Iiyama\,\ Nagano",
"819576", "Shimabara\,\ Nagasaki",
"81893", "Ozu\,\ Ehime",
"81281", "Utsunomiya\,\ Tochigi",
"811858", "Noshiro\,\ Akita",
"812571", "Muika\,\ Niigata",
"81793", "Himeji\,\ Hyogo",
"818243", "Higashi\-ku\,\ Hiroshima",
"811556", "Obihiro\,\ Hokkaido",
"81535", "Hamamatsu\,\ Shizuoka",
"818299", "Hiroshima\,\ Hiroshima",
"81460", "Odawara\,\ Kanagawa",
"812692", "Nakano\,\ Nagano",
"817612", "Komatsu\,\ Ishikawa",
"811852", "Oga\,\ Akita",
"817722", "Miyazu\,\ Kyoto",
"818547", "Kakeya\,\ Shimane",
"81822", "Hiroshima\,\ Hiroshima",
"819668", "Minamata\,\ Kumamoto",
"81722", "Sakai\,\ Osaka",
"819544", "Takeo\,\ Saga",
"819725", "Saiki\,\ Oita",
"81476", "Narita\,\ Chiba",
"819809", "Yaeyama\ District\,\ Okinawa",
"819662", "Hitoyoshi\,\ Kumamoto",
"818585", "Kurayoshi\,\ Tottori",
"811525", "Abashiri\,\ Hokkaido",
"815993", "Toba\,\ Mie",
"817705", "Obama\,\ Fukui",
"812415", "Yanaizu\,\ Fukushima",
"817495", "Nagahama\,\ Shiga",
"811933", "Kamaishi\,\ Iwate",
"811854", "Oga\,\ Akita",
"817724", "Miyazu\,\ Kyoto",
"818479", "Tojo\,\ Hiroshima",
"812653", "Iida\,\ Nagano",
"815566", "Minobu\,\ Yamanashi",
"818545", "Kisuki\,\ Shimane",
"818843", "Anan\,\ Tokushima",
"817614", "Komatsu\,\ Ishikawa",
"812694", "Nakano\,\ Nagano",
"818667", "Ibara\,\ Okayama",
"81729", "Yao\,\ Osaka",
"81124", "Ashibetsu\,\ Hokkaido",
"8153975", "Hamamatsu\,\ Shizuoka",
"811527", "Bihoro\,\ Hokkaido",
"81977", "Beppu\,\ Oita",
"818587", "Koge\,\ Tottori",
"815769", "Shokawa\,\ Gifu",
"81253", "Niigata\,\ Niigata",
"819664", "Hitoyoshi\,\ Kumamoto",
"817707", "Obama\,\ Fukui",
"817497", "Nagahama\,\ Shiga",
"817456", "Yamatotakada\,\ Nara",
"8165", "Osaka\,\ Osaka",
"81594", "Kuwana\,\ Mie",
"81494", "Chichibu\,\ Saitama",
"81157", "Kitami\,\ Hokkaido",
"815958", "Kameyama\,\ Mie",
"819727", "Usuki\,\ Oita",
"81188", "Akita\,\ Akita",
"819542", "Takeo\,\ Saga",
"818798", "Tonosho\,\ Kagawa",
"818695", "Seto\,\ Okayama",
"8126170", "Omachi\,\ Nagano",
"814298", "Hanno\,\ Saitama",
"812615", "Omachi\,\ Nagano",
"812559", "Yasuzuka\,\ Niigata",
"8112399", "Kuriyama\,\ Hokkaido",
"817354", "Shingu\,\ Fukuoka",
"812544", "Shibata\,\ Niigata",
"819945", "Kanoya\,\ Kagoshima",
"811645", "Rumoi\,\ Hokkaido",
"81886", "Tokushima\,\ Tokushima",
"812246", "Ogawara\,\ Miyagi",
"814775", "Funabashi\,\ Chiba",
"8125480", "Murakami\,\ Niigata",
"817733", "Fukuchiyama\,\ Kyoto",
"812872", "Otawara\,\ Tochigi",
"812582", "Nagaoka\,\ Niigata",
"811377", "Yakumo\,\ Hokkaido",
"817717", "Sonobe\,\ Kyoto",
"817948", "Miki\,\ Hyogo",
"812576", "Tokamachi\,\ Niigata",
"812797", "Shibukawa\,\ Gunma",
"818948", "Uwajima\,\ Ehime",
"812878", "Nasukarasuyama\,\ Tochigi",
"811234", "Chitose\,\ Hokkaido",
"81433", "Chiba\,\ Chiba",
"812588", "Nagaoka\,\ Niigata",
"81533", "Toyohashi\,\ Aichi",
"817942", "Kakogawa\,\ Hyogo",
"817465", "Yoshino\,\ Nara",
"811536", "Akkeshi\,\ Hokkaido",
"81738", "Gobo\,\ Wakayama",
"818942", "Yawatahama\,\ Ehime",
"81734", "Wakayama\,\ Wakayama",
"814777", "Funabashi\,\ Chiba",
"81277", "Kiryu\,\ Gunma",
"811863", "Kazuno\,\ Akita",
"81834", "Tokuyama\,\ Yamaguchi",
"818976", "Niihama\,\ Ehime",
"81280", "Koga\,\ Ibaraki",
"81726", "Ibaraki\,\ Osaka",
"818656", "Kasaoka\,\ Okayama",
"818697", "Bizen\,\ Okayama",
"81572", "Tajimi\,\ Gifu",
"81561", "Seto\,\ Aichi",
"819947", "Shibushi\,\ Kagoshima",
"811647", "Haboro\,\ Hokkaido",
"812542", "Shibata\,\ Niigata",
"817352", "Shingu\,\ Fukuoka",
"817959", "Sanda\,\ Hyogo",
"817944", "Kakogawa\,\ Hyogo",
"818944", "Yawatahama\,\ Ehime",
"815743", "Minokamo\,\ Gifu",
"811953", "Ninohe\,\ Iwate",
"818467", "Mima\,\ Tokushima",
"811232", "Chitose\,\ Hokkaido",
"8178", "Kobe\,\ Hyogo",
"811375", "Yakumo\,\ Hokkaido",
"812795", "Shibukawa\,\ Gunma",
"819433", "Yame\,\ Fukuoka",
"817715", "Kameoka\,\ Kyoto",
"812874", "Otawara\,\ Tochigi",
"818679", "Niimi\,\ Okayama",
"811238", "Kuriyama\,\ Hokkaido",
"812584", "Nagaoka\,\ Niigata",
"8198293", "Nobeoka\,\ Miyazaki",
"819828", "Takachiho\,\ Miyazaki",
"81979", "Nakatsu\,\ Oita",
"812646", "Nagano\,\ Nagano",
"818204", "Yanai\,\ Yamaguchi",
"8112393", "Yubari\,\ Hokkaido",
"815736", "Nakatsugawa\,\ Gifu",
"81940", "Munakata\,\ Fukuoka",
"81298", "Tsuchiura\,\ Ibaraki",
"818477", "Tojo\,\ Hiroshima",
"818295", "Hatsukaichi\,\ Hiroshima",
"812911", "Hokota\,\ Ibaraki",
"818552", "Hamada\,\ Shimane",
"819822", "Nobeoka\,\ Miyazaki",
"811365", "Kutchan\,\ Hokkaido",
"81235", "Tsuruoka\,\ Yamagata",
"819963", "Satsumasendai\,\ Kagoshima",
"81742", "Nara\,\ Nara",
"818808", "Tosashimizu\,\ Kochi",
"818669", "Soja\,\ Okayama",
"81933", "Kitakyushu\,\ Fukuoka",
"81260", "Anan\,\ Nagano",
"818558", "Kawamoto\,\ Shimane",
"811583", "Monbetsu\,\ Hokkaido",
"812419", "Tajima\,\ Fukushima",
"81276", "Ota\,\ Gunma",
"811873", "Kakunodate\,\ Akita",
"818879", "Muroto\,\ Kochi",
"815767", "Gero\,\ Gifu",
"812384", "Yonezawa\,\ Yamagata",
"812674", "Komoro\,\ Nagano",
"811454", "Mukawa\,\ Hokkaido",
"812993", "Ishioka\,\ Ibaraki",
"81827", "Iwakuni\,\ Yamaguchi",
"819805", "Nago\,\ Okinawa",
"81727", "Ikeda\,\ Osaka",
"812833", "Utsunomiya\,\ Tochigi",
"819783", "Bungotakada\,\ Oita",
"812640", "Nagano\,\ Nagano",
"819555", "Karatsu\,\ Saga",
"819934", "Ibusuki\,\ Kagoshima",
"811634", "Hamatonbetsu\,\ Hokkaido",
"811367", "Suttsu\,\ Hokkaido",
"819743", "Mie\,\ Oita",
"819824", "Nobeoka\,\ Miyazaki",
"812566", "Sanjo\,\ Niigata",
"818593", "Yonago\,\ Tottori",
"815973", "Owase\,\ Mie",
"818554", "Hamada\,\ Shimane",
"815985", "Matsusaka\,\ Mie",
"818895", "Susaki\,\ Kochi",
"818202", "Yanai\,\ Yamaguchi",
"818297", "Hatsukaichi\,\ Hiroshima",
"814281", "Sagamihara\,\ Kanagawa",
"81766", "Takaoka\,\ Toyama",
"811543", "Kushiro\,\ Hokkaido",
"818475", "Fuchu\,\ Hiroshima",
"817483", "Yokaichi\,\ Shiga",
"817475", "Shimonoseki\,\ Yamaguchi",
"81849", "Fukuyama\,\ Hiroshima",
"812388", "Nagai\,\ Yamagata",
"811632", "Teshio\,\ Hokkaido",
"819932", "Ibusuki\,\ Kagoshima",
"812678", "Saku\,\ Nagano",
"812233", "Iwanuma\,\ Miyagi",
"81144", "Tomakomai\,\ Hokkaido",
"819596", "Fukue\,\ Nagasaki",
"819557", "Karatsu\,\ Saga",
"811336", "Ishikari\,\ Hokkaido",
"81553", "Yamanashi\,\ Yamanashi",
"8188099", "Tosashimizu\,\ Kochi",
"81294", "Hitachiota\,\ Ibaraki",
"811757", "Noheji\,\ Aomori",
"812382", "Yonezawa\,\ Yamagata",
"819938", "Kaseda\,\ Kagoshima",
"812560", "Itoigawa\,\ Niigata",
"812672", "Komoro\,\ Nagano",
"811452", "Hayakita\,\ Hokkaido",
"8198299", "Hyuga\,\ Miyazaki",
"815765", "Gero\,\ Gifu",
"81191", "Ichinoseki\,\ Iwate",
"812376", "Sagae\,\ Yamagata",
"811857", "Noshiro\,\ Akita",
"818542", "Yasugi\,\ Shimane",
"81569", "Handa\,\ Aichi",
"811936", "Miyako\,\ Iwate",
"81226", "Kesennuma\,\ Miyagi",
"812697", "Iiyama\,\ Nagano",
"812656", "Ina\,\ Nagano",
"817617", "Kaga\,\ Ishikawa",
"8198290", "Nobeoka\,\ Miyazaki",
"818664", "Takahashi\,\ Okayama",
"81234", "Sakata\,\ Yamagata",
"81877", "Marugame\,\ Kagawa",
"818584", "Kurayoshi\,\ Tottori",
"812679", "Saku\,\ Nagano",
"811524", "Abashiri\,\ Hokkaido",
"812389", "Yonezawa\,\ Yamagata",
"818874", "Aki\,\ Kochi",
"8153969", "Hamamatsu\,\ Shizuoka",
"817704", "Tsuruga\,\ Fukui",
"819667", "Minamata\,\ Kumamoto",
"817453", "Yamatotakada\,\ Nara",
"812414", "Yanaizu\,\ Fukushima",
"81929", "Fukuoka\,\ Fukuoka",
"817494", "Hikone\,\ Shiga",
"819724", "Saiki\,\ Oita",
"81546", "Shizuoka\,\ Shizuoka",
"817366", "Iwade\,\ Wakayama",
"818366", "Ube\,\ Yamaguchi",
"8144", "Kawasaki\,\ Kanagawa",
"818662", "Takahashi\,\ Okayama",
"819573", "Isahaya\,\ Nagasaki",
"817725", "Miyazu\,\ Kyoto",
"811855", "Noshiro\,\ Akita",
"81286", "Utsunomiya\,\ Tochigi",
"818246", "Miyoshi\,\ Hiroshima",
"811553", "Obihiro\,\ Hokkaido",
"818544", "Kisuki\,\ Shimane",
"818559", "Kawamoto\,\ Shimane",
"817615", "Komatsu\,\ Ishikawa",
"812695", "Nakano\,\ Nagano",
"818668", "Ibara\,\ Okayama",
"81922", "Fukuoka\,\ Fukuoka",
"819722", "Saiki\,\ Oita",
"818391", "Ogori\,\ Yamaguchi",
"817498", "Nagahama\,\ Shiga",
"819547", "Kashima\,\ Saga",
"8153976", "Hamamatsu\,\ Shizuoka",
"818588", "Koge\,\ Tottori",
"811528", "Bihoro\,\ Hokkaido",
"818240", "Higashi\-ku\,\ Hiroshima",
"8126173", "Omachi\,\ Nagano",
"819728", "Usuki\,\ Oita",
"81989", "Naha\,\ Okinawa",
"81471", "Kashiwa\,\ Chiba",
"815996", "Ago\,\ Mie",
"817702", "Tsuruga\,\ Fukui",
"817492", "Hikone\,\ Shiga",
"818797", "Tonosho\,\ Kagawa",
"8125483", "Murakami\,\ Niigata",
"812412", "Kitakata\,\ Fukushima",
"811522", "Shari\,\ Hokkaido",
"819665", "Hitoyoshi\,\ Kumamoto",
"818582", "Kurayoshi\,\ Tottori",
"818360", "Ogori\,\ Yamaguchi",
"81947", "Tagawa\,\ Fukuoka",
"818872", "Muroto\,\ Kochi",
"81462", "Atsugi\,\ Kanagawa",
"811353", "Yoichi\,\ Hokkaido",
"81266", "Suwa\,\ Nagano",
"812483", "Shirakawa\,\ Fukushima",
"812475", "Ishikawa\,\ Fukushima",
"819955", "Kajiki\,\ Kagoshima",
"811655", "Nayoro\,\ Hokkaido",
"811394", "Matsumae\,\ Hokkaido",
"81429", "Tokorozawa\,\ Saitama",
"8199343", "Kagoshima\,\ Kagoshima",
"812895", "Utsunomiya\,\ Tochigi",
"812549", "Tsugawa\,\ Niigata",
"812554", "Joetsu\,\ Niigata",
"812935", "Mito\,\ Ibaraki",
"811734", "Goshogawara\,\ Aomori",
"81946", "Amagi\,\ Fukuoka",
"819683", "Yamaga\,\ Kumamoto",
"811983", "Hanamaki\,\ Iwate",
"818680", "Okayama\,\ Okayama",
"811975", "Mizusawa\,\ Iwate",
"817686", "Noto\,\ Ishikawa",
"818376", "Mine\,\ Yamaguchi",
"818958", "Misho\,\ Ehime",
"81183", "Yuzawa\,\ Akita",
"812746", "Tomioka\,\ Gunma",
"81969", "Amakusa\,\ Kumamoto",
"818686", "Tsuyama\,\ Okayama",
"81199", "Morioka\,\ Iwate",
"81582", "Gifu\,\ Gifu",
"814798", "Yokaichiba\,\ Chiba",
"81482", "Kawaguchi\,\ Saitama",
"818382", "Hagi\,\ Yamaguchi",
"817672", "Hakui\,\ Ishikawa",
"818952", "Uwajima\,\ Ehime",
"817952", "Nishiwaki\,\ Hyogo",
"818678", "Niimi\,\ Okayama",
"81270", "Isesaki\,\ Gunma",
"814792", "Choshi\,\ Chiba",
"81249", "Koriyama\,\ Fukushima",
"817678", "Nanao\,\ Ishikawa",
"818388", "Tamagawa\,\ Yamaguchi",
"814283", "Ome\,\ Tokyo",
"811541", "Teshikaga\,\ Hokkaido",
"811732", "Goshogawara\,\ Aomori",
"818262", "Kake\,\ Hiroshima",
"81835", "Hofu\,\ Yamaguchi",
"811977", "Kitakami\,\ Iwate",
"811398", "Kumaishi\,\ Hokkaido",
"81242", "Aizuwakamatsu\,\ Fukushima",
"81798", "Nishinomiya\,\ Hyogo",
"81593", "Yokkaichi\,\ Mie",
"812552", "Joetsu\,\ Niigata",
"81962", "Kumamoto\,\ Kumamoto",
"81192", "Ofunato\,\ Iwate",
"819957", "Kajiki\,\ Kagoshima",
"81898", "Imabari\,\ Ehime",
"812477", "Miharu\,\ Fukushima",
"81547", "Shimada\,\ Shizuoka",
"815363", "Shinshiro\,\ Aichi",
"812897", "Kanuma\,\ Tochigi",
"81489", "Soka\,\ Saitama",
"812856", "Mooka\,\ Tochigi",
"812786", "Numata\,\ Gunma",
"81493", "Higashimatsuyama\,\ Saitama",
"812937", "Mito\,\ Ibaraki",
"811392", "Kikonai\,\ Hokkaido",
"814794", "Choshi\,\ Chiba",
"811943", "Iwaizumi\,\ Iwate",
"814753", "Mobara\,\ Chiba",
"812780", "Maebashi\,\ Gunma",
"817993", "Sumoto\,\ Hyogo",
"814705", "Tateyama\,\ Chiba",
"815753", "Sekigahara\,\ Gifu",
"811466", "Erimo\,\ Hokkaido",
"8126179", "Omachi\,\ Nagano",
"815585", "Shimoda\,\ Shizuoka",
"818954", "Uwajima\,\ Ehime",
"818833", "Kamojima\,\ Tokushima",
"812913", "Hokota\,\ Ibaraki",
"818949", "Uwajima\,\ Ehime",
"8112390", "Yubari\,\ Hokkaido",
"81227", "Sendai\,\ Miyagi",
"817949", "Kakogawa\,\ Hyogo",
"817954", "Nishiwaki\,\ Hyogo",
"8125489", "Tsugawa\,\ Niigata",
"812589", "Nagaoka\,\ Niigata",
"818674", "Kuse\,\ Okayama",
"812879", "Nasukarasuyama\,\ Tochigi",
"818384", "Hagi\,\ Yamaguchi",
"817674", "Hakui\,\ Ishikawa",
"81776", "Fukui\,\ Fukui",
"8153970", "Hamamatsu\,\ Shizuoka",
"819823", "Nobeoka\,\ Miyazaki",
"819962", "Satsumasendai\,\ Kagoshima",
"815395", "Hamamatsu\,\ Shizuoka",
"819744", "Mie\,\ Oita",
"811366", "Suttsu\,\ Hokkaido",
"811544", "Kushiro\,\ Hokkaido",
"811559", "Obihiro\,\ Hokkaido",
"81928", "Fukuoka\,\ Fukuoka",
"818296", "Hiroshima\,\ Hiroshima",
"817484", "Yokaichi\,\ Shiga",
"819968", "Izumi\,\ Kagoshima",
"815735", "Ena\,\ Gifu",
"818594", "Yonago\,\ Tottori",
"818553", "Hamada\,\ Shimane",
"815974", "Owase\,\ Mie",
"812992", "Ishioka\,\ Ibaraki",
"811588", "Okoppe\,\ Hokkaido",
"811337", "Ishikari\,\ Hokkaido",
"812234", "Sendai\,\ Miyagi",
"817912", "Aioi\,\ Hyogo",
"811878", "Omagari\,\ Akita",
"812551", "Joetsu\,\ Niigata",
"812832", "Sano\,\ Tochigi",
"819597", "Fukue\,\ Nagasaki",
"819556", "Karatsu\,\ Saga",
"819782", "Bungotakada\,\ Oita",
"818290", "Hiroshima\,\ Hiroshima",
"81845", "Innoshima\,\ Hiroshima",
"81984", "Kobayashi\,\ Miyazaki",
"812377", "Sagae\,\ Yamagata",
"812998", "Itako\,\ Ibaraki",
"811582", "Monbetsu\,\ Hokkaido",
"81468", "Yokosuka\,\ Kanagawa",
"817965", "Toyooka\,\ Hyogo",
"812838", "Sano\,\ Tochigi",
"81568", "Kasugai\,\ Aichi",
"819788", "Kunisaki\,\ Oita",
"81763", "Fukuno\,\ Toyama",
"81537", "Kakegawa\,\ Shizuoka",
"811756", "Noheji\,\ Aomori",
"81863", "Tamano\,\ Okayama",
"8167", "Osaka\,\ Osaka",
"81564", "Okazaki\,\ Aichi",
"817476", "Shimonoseki\,\ Yamaguchi",
"818592", "Yonago\,\ Tottori",
"818476", "Fuchu\,\ Hiroshima",
"815972", "Owase\,\ Mie",
"81273", "Takasaki\,\ Gunma",
"81988", "Naha\,\ Okinawa",
"818896", "Susaki\,\ Kochi",
"818203", "Yanai\,\ Yamaguchi",
"815986", "Matsusaka\,\ Mie",
"815737", "Nakatsugawa\,\ Gifu",
"811542", "Kushiro\,\ Hokkaido",
"812647", "Nagano\,\ Nagano",
"81975", "Oita\,\ Oita",
"81464", "Atsugi\,\ Kanagawa",
"817482", "Yokaichi\,\ Shiga",
"819742", "Mie\,\ Oita",
"812565", "Sanjo\,\ Niigata",
"81177", "Aomori\,\ Aomori",
"815978", "Kumano\,\ Mie",
"8186697", "Kurashiki\,\ Okayama",
"811548", "Teshikaga\,\ Hokkaido",
"8153967", "Hamamatsu\,\ Shizuoka",
"817488", "Minakuchi\,\ Shiga",
"819964", "Satsumasendai\,\ Kagoshima",
"812383", "Yonezawa\,\ Yamagata",
"812375", "Murayama\,\ Yamagata",
"8188096", "Tosashimizu\,\ Kochi",
"8124197", "Yanaizu\,\ Fukushima",
"815766", "Gero\,\ Gifu",
"811453", "Hayakita\,\ Hokkaido",
"812673", "Komoro\,\ Nagano",
"8182941", "Hiroshima\,\ Hiroshima",
"811584", "Engaru\,\ Hokkaido",
"812238", "Sendai\,\ Miyagi",
"811874", "Kakunodate\,\ Akita",
"81924", "Fukuoka\,\ Fukuoka",
"8112394", "Yubari\,\ Hokkaido",
"8161", "Osaka\,\ Osaka",
"819784", "Bungotakada\,\ Oita",
"819933", "Ibusuki\,\ Kagoshima",
"8198296", "Hyuga\,\ Miyazaki",
"812232", "Iwanuma\,\ Miyagi",
"817914", "Aioi\,\ Hyogo",
"812994", "Ishioka\,\ Ibaraki",
"81936", "Kitakyushu\,\ Fukuoka",
"8145", "Yokohama\,\ Kanagawa",
"8199347", "Kagoshima\,\ Kagoshima",
"812834", "Utsunomiya\,\ Tochigi",
"818398", "Ogori\,\ Yamaguchi",
"818977", "Hakata\,\ Ehime",
"811864", "Odate\,\ Akita",
"8112396", "Kuriyama\,\ Hokkaido",
"814776", "Funabashi\,\ Chiba",
"817732", "Fukuchiyama\,\ Kyoto",
"81259", "Sado\,\ Niigata",
"8125487", "Tsugawa\,\ Niigata",
"8183766", "Shimonoseki\,\ Yamaguchi",
"8198294", "Nobeoka\,\ Miyazaki",
"81584", "Ogaki\,\ Gifu",
"812245", "Ogawara\,\ Miyagi",
"811646", "Haboro\,\ Hokkaido",
"819946", "Kanoya\,\ Kagoshima",
"81937", "Kitakyushu\,\ Fukuoka",
"81484", "Kawaguchi\,\ Saitama",
"812616", "Omachi\,\ Nagano",
"81792", "Himeji\,\ Hyogo",
"81892", "Kumakogen\,\ Ehime",
"818696", "Bizen\,\ Okayama",
"818657", "Kasaoka\,\ Okayama",
"817738", "Maizuru\,\ Kyoto",
"811954", "Ninohe\,\ Iwate",
"818466", "Mima\,\ Tokushima",
"8182942", "Hiroshima\,\ Hiroshima",
"818690", "Okayama\,\ Okayama",
"817466", "Totsukawa\,\ Nara",
"811535", "Akkeshi\,\ Hokkaido",
"8186995", "Seto\,\ Okayama",
"817943", "Kakogawa\,\ Hyogo",
"81956", "Sasebo\,\ Nagasaki",
"819940", "Shibushi\,\ Kagoshima",
"815744", "Minokamo\,\ Gifu",
"818943", "Yawatahama\,\ Ehime",
"81723", "Sakai\,\ Osaka",
"812873", "Otawara\,\ Tochigi",
"819434", "Yame\,\ Fukuoka",
"81176", "Towada\,\ Aomori",
"814770", "Ichikawa\,\ Chiba",
"812575", "Tokamachi\,\ Niigata",
"812583", "Nagaoka\,\ Niigata",
"81823", "Kure\,\ Hiroshima",
"819974", "Yakushima\,\ Kagoshima",
"819735", "Hita\,\ Oita",
"812489", "Sukagawa\,\ Fukushima",
"811868", "Takanosu\,\ Akita",
"8147955", "Yokaichiba\,\ Chiba",
"812247", "Ogawara\,\ Miyagi",
"818655", "Kamogata\,\ Okayama",
"812543", "Shibata\,\ Niigata",
"817353", "Shingu\,\ Fukuoka",
"811862", "Kazuno\,\ Akita",
"818975", "Niihama\,\ Ehime",
"81436", "Ichihara\,\ Chiba",
"817734", "Fukuchiyama\,\ Kyoto",
"81488", "Urawa\,\ Saitama",
"817716", "Sonobe\,\ Kyoto",
"812796", "Shibukawa\,\ Gunma",
"812577", "Muika\,\ Niigata",
"811958", "Iwate\,\ Iwate",
"811376", "Yakumo\,\ Hokkaido",
"819432", "Yame\,\ Fukuoka",
"81557", "Ito\,\ Shizuoka",
"819737", "Kusu\,\ Oita",
"81899", "Matsuyama\,\ Ehime",
"819978", "Tokunoshima\,\ Kagoshima",
"815742", "Minokamo\,\ Gifu",
"811537", "Nakashibetsu\,\ Hokkaido",
"817239", "Neyagawa\,\ Osaka",
"811952", "Ninohe\,\ Iwate",
"814289", "Ome\,\ Tokyo",
"819438", "Tanushimaru\,\ Fukuoka",
"8111", "Sapporo\,\ Hokkaido",
"81244", "Hobara\,\ Fukushima",
"811233", "Chitose\,\ Hokkaido",
"81252", "Niigata\,\ Niigata",
"811976", "Kitakami\,\ Iwate",
"819676", "Takamori\,\ Kumamoto",
"81739", "Tanabe\,\ Wakayama",
"811869", "Odate\,\ Akita",
"81839", "Yamaguchi\,\ Yamaguchi",
"812488", "Sukagawa\,\ Fukushima",
"81134", "Otaru\,\ Hokkaido",
"819682", "Yamaga\,\ Kumamoto",
"818565", "Masuda\,\ Shimane",
"811982", "Hanamaki\,\ Iwate",
"812787", "Numata\,\ Gunma",
"81478", "Sawara\,\ Chiba",
"81550", "Gotenba\,\ Shizuoka",
"811352", "Yoichi\,\ Hokkaido",
"812936", "Mito\,\ Ibaraki",
"812482", "Shirakawa\,\ Fukushima",
"812896", "Kanuma\,\ Tochigi",
"81485", "Kumagaya\,\ Saitama",
"812857", "Mooka\,\ Tochigi",
"81585", "Ibigawa\,\ Gifu",
"818512", "Nishigo\,\ Fukushima",
"811656", "Bifuka\,\ Hokkaido",
"819956", "Kajiki\,\ Kagoshima",
"812476", "Miharu\,\ Fukushima",
"81578", "Kamioka\,\ Akita",
"819688", "Tamana\,\ Kumamoto",
"81126", "Iwamizawa\,\ Hokkaido",
"812914", "Hokota\,\ Ibaraki",
"818834", "Kamojima\,\ Tokushima",
"818953", "Uwajima\,\ Ehime",
"815754", "Sekigahara\,\ Gifu",
"817994", "Sumoto\,\ Hyogo",
"817953", "Nishiwaki\,\ Hyogo",
"812930", "Mito\,\ Ibaraki",
"817905", "Fukusaki\,\ Hyogo",
"814793", "Choshi\,\ Chiba",
"811944", "Iwaizumi\,\ Iwate",
"814754", "Mobara\,\ Chiba",
"812890", "Utsunomiya\,\ Tochigi",
"814282", "Ome\,\ Tokyo",
"81596", "Ise\,\ Mie",
"817238", "Neyagawa\,\ Osaka",
"819979", "Tokunoshima\,\ Kagoshima",
"812745", "Fujioka\,\ Gunma",
"818685", "Tsuyama\,\ Okayama",
"814288", "Ome\,\ Tokyo",
"818383", "Hagi\,\ Yamaguchi",
"812967", "Kasama\,\ Ibaraki",
"817673", "Hakui\,\ Ishikawa",
"818375", "Mine\,\ Yamaguchi",
"817685", "Wajima\,\ Ishikawa",
"812553", "Joetsu\,\ Niigata",
"812785", "Numata\,\ Gunma",
"818514", "Ama\,\ Shimane",
"812855", "Oyama\,\ Tochigi",
"811354", "Yoichi\,\ Hokkaido",
"815362", "Shinshiro\,\ Aichi",
"81425", "Tachikawa\,\ Tokyo",
"814700", "Kamogawa\,\ Chiba",
"811393", "Matsumae\,\ Hokkaido",
"812484", "Shirakawa\,\ Fukushima",
"8153964", "Hamamatsu\,\ Shizuoka",
"811733", "Goshogawara\,\ Aomori",
"811984", "Hanamaki\,\ Iwate",
"819684", "Yamaga\,\ Kumamoto",
"818263", "Kake\,\ Hiroshima",
"8186998", "Seto\,\ Okayama",
"815368", "Shitara\,\ Aichi",
"818567", "Tsuwano\,\ Shimane",
"8183767", "Shimonoseki\,\ Yamaguchi",
"81930", "Yukuhashi\,\ Fukuoka",
"81263", "Matsumoto\,\ Nagano",
"814758", "Togane\,\ Chiba",
"8126176", "Omachi\,\ Nagano",
"8166", "Osaka\,\ Osaka",
"81474", "Funabashi\,\ Chiba",
"81965", "Yatsushiro\,\ Kumamoto",
"818687", "Mimasaka\,\ Okayama",
"812747", "Tomioka\,\ Gunma",
"817998", "Tsuna\,\ Hyogo",
"818377", "Shimonoseki\,\ Yamaguchi",
"817687", "Noto\,\ Ishikawa",
"812965", "Shimodate\,\ Ibaraki",
"8153973", "Hamamatsu\,\ Shizuoka",
"81167", "Furano\,\ Hokkaido",
"81245", "Fukushima\,\ Fukushima",
"81832", "Shimonoseki\,\ Yamaguchi",
"814284", "Tachikawa\,\ Tokyo",
"81138", "Hakodate\,\ Hokkaido",
"815586", "Shimoda\,\ Shizuoka",
"814752", "Mobara\,\ Chiba",
"811942", "Iwaizumi\,\ Iwate",
"811465", "Shizunai\,\ Hokkaido",
"817992", "Sumoto\,\ Hyogo",
"815752", "Sekigahara\,\ Gifu",
"8112397", "Kuriyama\,\ Hokkaido",
"818832", "Kamojima\,\ Tokushima",
"8125486", "Tsugawa\,\ Niigata",
"8126174", "Omachi\,\ Nagano",
"819574", "Isahaya\,\ Nagasaki",
"8198297", "Hyuga\,\ Miyazaki",
"818367", "Ube\,\ Yamaguchi",
"817367", "Iwade\,\ Wakayama",
"815979", "Kumano\,\ Mie",
"8188097", "Tosashimizu\,\ Kochi",
"812655", "Iida\,\ Nagano",
"8124196", "Yanaizu\,\ Fukushima",
"818543", "Yasugi\,\ Shimane",
"81166", "Asahikawa\,\ Hokkaido",
"818247", "Shobara\,\ Hiroshima",
"811935", "Kamaishi\,\ Iwate",
"8125484", "Murakami\,\ Niigata",
"811554", "Obihiro\,\ Hokkaido",
"811549", "Kushiro\,\ Hokkaido",
"81852", "Matsue\,\ Shimane",
"81744", "Yamatotakada\,\ Nara",
"8186992", "Bizen\,\ Okayama",
"8153966", "Hamamatsu\,\ Shizuoka",
"819546", "Kashima\,\ Saga",
"812239", "Sendai\,\ Miyagi",
"8168", "Osaka\,\ Osaka",
"81950", "Hirado\,\ Nagasaki",
"817452", "Yamatotakada\,\ Nara",
"818796", "Tonosho\,\ Kagawa",
"81985", "Miyazaki\,\ Miyazaki",
"815997", "Ago\,\ Mie",
"81465", "Odawara\,\ Kanagawa",
"812696", "Iiyama\,\ Nagano",
"812657", "Ina\,\ Nagano",
"81292", "Mito\,\ Ibaraki",
"817616", "Komatsu\,\ Ishikawa",
"811552", "Obihiro\,\ Hokkaido",
"811937", "Miyako\,\ Iwate",
"818245", "Miyoshi\,\ Hiroshima",
"811856", "Noshiro\,\ Akita",
"819578", "Shimabara\,\ Nagasaki",
"81565", "Toyota\,\ Aichi",
"811558", "Hiroo\,\ Hokkaido",
"81142", "Date\,\ Hokkaido",
"818365", "Ube\,\ Yamaguchi",
"81848", "Onomichi\,\ Hiroshima",
"81543", "Shizuoka\,\ Shizuoka",
"819572", "Isahaya\,\ Nagasaki",
"818663", "Soja\,\ Okayama",
"81925", "Fukuoka\,\ Fukuoka",
"817454", "Yamatotakada\,\ Nara",
"817703", "Tsuruga\,\ Fukui",
"818493", "Onomichi\,\ Hiroshima",
"814291", "Hanno\,\ Saitama",
"817493", "Hikone\,\ Shiga",
"819666", "Minamata\,\ Kumamoto",
"811589", "Okoppe\,\ Hokkaido",
"812413", "Kitakata\,\ Fukushima",
"811523", "Shari\,\ Hokkaido",
"8153979", "Hamamatsu\,\ Shizuoka",
"818583", "Kurayoshi\,\ Tottori",
"815995", "Ago\,\ Mie",
"8162", "Osaka\,\ Osaka",
"818873", "Aki\,\ Kochi",
"812839", "Sano\,\ Tochigi",
"819723", "Saiki\,\ Oita",
"812999", "Itako\,\ Ibaraki",
"8186553", "Kurashiki\,\ Okayama",
"819789", "Kitsuki\,\ Oita",};
$areanames{ja} = {"815733", "恵那",
"818292", "広島",
"818894", "須崎",
"818555", "江津",
"815984", "松阪",
"812643", "木曾福島",
"818474", "府中",
"818298", "廿日市",
"819966", "出水",
"811362", "倶知安",
"819825", "日向",
"811876", "大曲",
"819808", "八重山",
"817963", "豊岡",
"81942", "久留米",
"8152", "名古屋",
"812836", "佐野",
"81262", "長野",
"812996", "潮来",
"819802", "南大東",
"819204", "郷ノ浦",
"81740", "今津",
"81426", "八王子",
"8199331", "鹿児島",
"81987", "日南",
"818205", "柳井",
"8182920", "廿日市",
"817472", "五条",
"818596", "米子",
"812230", "仙台",
"817486", "水口",
"81949", "直方",
"818807", "宿毛",
"815768", "下呂",
"81196", "盛岡",
"812955", "常陸大宮",
"819554", "伊万里",
"811333", "当別",
"819935", "加世田",
"811635", "浜頓別",
"811754", "むつ",
"815762", "下呂",
"812385", "米沢",
"812373", "村山",
"81246", "いわき",
"815959", "亀山",
"812675", "佐久",
"811455", "鵡川",
"817357", "串本",
"818692", "邑久",
"81542", "静岡",
"812243", "白石",
"812612", "大町",
"818698", "備前",
"817736", "舞鶴",
"812618", "大町",
"811374", "森",
"819733", "日田",
"817714", "亀岡",
"812573", "柏崎",
"812585", "長岡",
"814709", "鴨川",
"815589", "修善寺大仁",
"818945", "八幡浜",
"818462", "竹原",
"81222", "仙台",
"814227", "武蔵野三鷹",
"811533", "根室",
"819679", "高森",
"81566", "刈谷",
"81466", "藤沢",
"814297", "飯能",
"81229", "古川",
"818973", "新居浜",
"811562", "本別",
"812939", "水戸",
"812899", "鹿沼",
"812545", "村上",
"819944", "鹿屋",
"811644", "留萌",
"817947", "三木",
"812798", "長野原",
"811235", "夕張",
"81926", "福岡",
"817464", "吉野",
"812792", "渋川",
"81587", "一宮",
"81549", "静岡",
"812877", "黒磯",
"81487", "浦和",
"814280", "立川",
"81480", "久喜",
"811397", "奥尻",
"819233", "前原",
"81272", "前橋",
"818267", "千代田",
"818675", "久世",
"818683", "津山",
"812743", "藤岡",
"818385", "萩",
"818373", "長門",
"815584", "下田",
"818955", "宇和島",
"814704", "館山",
"811735", "五所川原",
"819674", "熊本一の宮",
"811974", "水沢",
"819949", "大根占",
"819954", "加治木",
"811654", "名寄",
"812474", "石川",
"812555", "糸魚川",
"812783", "沼田",
"812894", "宇都宮",
"812934", "高萩",
"815366", "設楽",
"814797", "八日市場",
"81862", "岡山",
"818836", "脇町",
"817957", "丹波柏原",
"817677", "七尾",
"814240", "国分寺",
"817724", "宮津",
"811933", "釜石",
"818479", "東城",
"815566", "身延",
"812653", "飯田",
"818545", "木次",
"817614", "小松",
"812973", "水海道",
"818667", "井原",
"811527", "美幌",
"818877", "嶺北",
"817707", "小浜",
"812417", "会津山口",
"817456", "大和高田",
"818792", "三本松",
"819727", "臼杵",
"818798", "土庄",
"81188", "秋田",
"817363", "和歌山橋本",
"812698", "飯山",
"81184", "本荘",
"812571", "六日町",
"811858", "能代",
"81793", "姫路",
"818243", "東広島",
"812692", "中野",
"811852", "男鹿",
"81822", "広島",
"819668", "水俣",
"819544", "武雄",
"81476", "成田",
"815954", "上野",
"819662", "人吉",
"818585", "倉吉",
"817495", "長浜",
"81225", "石巻",
"817735", "福知山",
"811867", "鷹巣",
"81923", "福岡",
"812248", "大河原",
"817940", "加古川",
"818693", "邑久",
"812859", "小山",
"812613", "大町",
"812242", "白石",
"811957", "岩手",
"819738", "玖珠",
"818463", "竹原",
"81563", "西尾",
"818946", "宇和",
"81463", "平塚",
"811532", "根室",
"815747", "美濃白川",
"812578", "六日町",
"812586", "長岡",
"819437", "田主丸",
"81545", "富士",
"819732", "日田",
"819977", "瀬戸内",
"811538", "根室標津",
"812572", "柏崎",
"818652", "倉敷",
"812546", "村上",
"814220", "国分寺",
"818978", "伯方",
"8112395", "栗山",
"81250", "新津",
"81864", "倉敷",
"811563", "本別",
"818972", "新居浜",
"812793", "渋川",
"8153962", "天竜",
"8186996", "岡山瀬戸",
"8175", "京都",
"8125481", "村上",
"811236", "千歳",
"81963", "熊本",
"812564", "三条",
"815738", "中津川",
"812648", "長野",
"819826", "日向",
"818369", "宇部",
"811363", "倶知安",
"819747", "竹田",
"819965", "川内",
"815732", "恵那",
"811547", "白糠",
"818293", "廿日市",
"812642", "木曾福島",
"81243", "二本松",
"818556", "江津",
"8164", "大阪",
"815977", "熊野",
"812237", "仙台",
"81423", "国分寺",
"8186691", "倉敷",
"819594", "有川",
"812995", "石岡",
"819803", "名護",
"81828", "広島",
"812835", "佐野",
"817968", "浜坂",
"815999", "津",
"8198295", "日向",
"817962", "豊岡",
"811875", "角館",
"817485", "八日市",
"817473", "五条",
"818595", "米子",
"818206", "柳井",
"815394", "浜松",
"815763", "下呂",
"811456", "門別富川",
"812676", "佐久",
"812386", "長井",
"812372", "村山",
"811587", "中湧別",
"811636", "北見枝幸",
"819936", "加世田",
"81875", "観音寺",
"819787", "国東",
"81857", "鳥取",
"81182", "横手",
"817917", "竜野",
"812378", "寒河江",
"811332", "当別",
"812956", "常陸大宮",
"811938", "宮古",
"812972", "水海道",
"819577", "島原",
"81878", "高松",
"818364", "宇部",
"812658", "伊那",
"812569", "巻",
"81473", "市川",
"811932", "釜石",
"812978", "竜ケ崎",
"818546", "掛合",
"815565", "鰍沢青柳",
"812652", "飯田",
"81944", "瀬高",
"811557", "十勝池田",
"819599", "大瀬戸",
"817455", "大和高田",
"814994", "三宅",
"818793", "三本松",
"815994", "阿児",
"8112392", "夕張",
"8198298", "日向",
"818242", "東広島",
"818844", "阿南",
"812693", "中野",
"817368", "岩出",
"8199345", "鹿児島",
"811853", "男鹿",
"818248", "庄原",
"817362", "和歌山橋本",
"815399", "天竜",
"818490", "尾道",
"81825", "広島",
"819663", "人吉",
"817496", "長浜",
"818660", "岡山瀬戸",
"81948", "飯塚",
"818586", "倉吉",
"8188091", "窪川",
"81268", "上田",
"812854", "小山",
"819232", "前原",
"817950", "三田",
"812748", "富岡",
"818688", "美作",
"817997", "津名",
"815757", "郡上八幡",
"818378", "下関",
"811464", "静内",
"818956", "宇和島",
"811947", "久慈",
"814757", "東金",
"812742", "藤岡",
"818682", "津山",
"818372", "長門",
"81544", "富士宮",
"8198292", "延岡",
"812964", "下館",
"818676", "久世",
"8112398", "栗山",
"81548", "榛原",
"812556", "糸魚川",
"812782", "沼田",
"811357", "岩内",
"812487", "須賀川",
"811736", "五所川原",
"819687", "玉名",
"811987", "遠野",
"812788", "前橋",
"818564", "益田",
"817684", "輪島",
"818835", "脇町",
"814287", "青梅",
"81228", "築館",
"817904", "福崎",
"817476", "下市",
"818592", "米子",
"81988", "那覇",
"818203", "柳井",
"817482", "八日市",
"818598", "根雨",
"815397", "浜松",
"8186697", "倉敷",
"817488", "水口",
"8124197", "柳津",
"812383", "米沢",
"812375", "村山",
"811453", "早来",
"815766", "下呂",
"812673", "小諸",
"811584", "遠軽",
"819784", "豊後高田",
"8161", "大阪",
"8198296", "日向",
"819933", "指宿",
"817914", "相生",
"81936", "北九州",
"8145", "横浜",
"812567", "巻",
"819823", "延岡",
"819962", "川内",
"819744", "三重",
"811366", "寿都",
"811559", "帯広",
"811544", "釧路",
"819968", "出水",
"818296", "広島",
"815735", "恵那",
"818553", "浜田",
"812645", "木曾福島",
"815974", "尾鷲",
"812234", "仙台",
"812992", "石岡",
"819597", "福江",
"811878", "大曲",
"812551", "上越",
"812832", "佐野",
"819806", "沖縄宮古",
"812998", "潮来",
"81984", "小林",
"812838", "佐野",
"817965", "豊岡",
"81763", "福野",
"812489", "須賀川",
"8147955", "八日市場",
"818655", "鴨方",
"812543", "新発田",
"818975", "新居浜",
"81436", "市原",
"811566", "十勝清水",
"81488", "浦和",
"812796", "渋川",
"81899", "松山",
"814289", "青梅",
"811233", "千歳",
"81252", "新潟",
"818398", "小郡",
"8188094", "窪川",
"8112396", "栗山",
"811864", "大館",
"8125487", "津川",
"817732", "福知山",
"81259", "佐渡",
"81584", "大垣",
"812245", "大河原",
"81484", "川口",
"812616", "大町",
"818696", "備前",
"817738", "舞鶴",
"81892", "久万",
"8182942", "広島",
"811954", "二戸",
"818466", "木江",
"811535", "厚岸",
"8186995", "岡山瀬戸",
"81956", "佐世保",
"815744", "美濃加茂",
"819940", "志布志",
"818943", "八幡浜",
"81176", "十和田",
"819434", "八女",
"81723", "堺",
"814770", "市川",
"812575", "十日町",
"812583", "長岡",
"819974", "屋久島",
"819735", "日田",
"812553", "上越",
"812785", "沼田",
"815362", "新城",
"811354", "余市",
"814700", "鴨川",
"812484", "白河",
"811733", "五所川原",
"811984", "花巻",
"819684", "山鹿",
"815368", "設楽",
"8186998", "岡山瀬戸",
"818567", "津和野",
"8183767", "下関",
"818838", "阿波池田",
"817687", "能都",
"81832", "下関",
"814284", "立川",
"818832", "鴨島",
"817907", "播磨山崎",
"811869", "大館",
"81839", "山口",
"812857", "真岡",
"81485", "熊谷",
"818512", "西郷",
"81585", "揖斐川",
"81126", "岩見沢",
"818953", "宇和島",
"817994", "洲本",
"815754", "関",
"812930", "水戸",
"812890", "宇都宮",
"814754", "茂原",
"811944", "岩泉",
"817238", "寝屋川",
"81596", "伊勢",
"819979", "徳之島",
"818673", "福渡",
"812745", "藤岡",
"818685", "津山",
"818383", "萩",
"812967", "笠間",
"818375", "美祢",
"81292", "水戸",
"812696", "飯山",
"818847", "牟岐",
"818245", "三次",
"811856", "能代",
"81142", "伊達",
"817365", "和歌山橋本",
"811589", "興部",
"819666", "水俣",
"817493", "彦根",
"818583", "倉吉",
"8186553", "倉敷",
"819789", "杵築",
"819574", "諫早",
"812975", "水海道",
"818367", "宇部",
"812655", "飯田",
"818543", "安来",
"8188097", "土佐清水",
"815979", "熊野",
"81166", "旭川",
"8125484", "村上",
"811935", "釜石",
"811549", "釧路",
"815562", "鰍沢青柳",
"811554", "帯広",
"81852", "松江",
"8186992", "備前",
"81744", "大和高田",
"817458", "大和榛原",
"812239", "仙台",
"8168", "大阪",
"817452", "大和高田",
"818796", "土庄",
"815997", "阿児",
"81985", "宮崎",
"814777", "船橋",
"81277", "桐生",
"81834", "徳山",
"818976", "新居浜",
"818656", "笠岡",
"81726", "茨木",
"811647", "羽幌",
"819947", "志布志",
"812542", "新発田",
"817944", "加古川",
"817959", "三田",
"8188093", "窪川",
"811232", "千歳",
"812874", "大田原",
"812795", "渋川",
"811238", "栗山",
"818695", "岡山瀬戸",
"817354", "新宮",
"812615", "大町",
"81886", "徳島",
"812246", "大河原",
"81220", "迫",
"8125480", "村上",
"817733", "福知山",
"812582", "長岡",
"811377", "八雲",
"812576", "十日町",
"817717", "園部",
"818948", "宇和",
"812588", "長岡",
"81433", "千葉",
"81533", "豊橋",
"811536", "厚岸",
"818942", "八幡浜",
"814224", "武蔵野三鷹",
"818208", "久賀",
"818593", "米子",
"81766", "高岡",
"818202", "柳井",
"818804", "土佐中村",
"817483", "八日市",
"817475", "下市",
"812388", "長井",
"811632", "天塩",
"819932", "指宿",
"812678", "佐久",
"819557", "唐津",
"81144", "苫小牧",
"8188099", "土佐清水",
"811336", "石狩",
"81553", "山梨",
"81294", "常陸太田",
"811757", "野辺地",
"812382", "米沢",
"819938", "加世田",
"811638", "利尻礼文",
"812560", "糸魚川",
"812672", "小諸",
"811452", "早来",
"815765", "下呂",
"812376", "寒河江",
"819828", "高千穂",
"812646", "長野",
"815987", "三瀬谷",
"815736", "中津川",
"81940", "宗像",
"818295", "廿日市",
"818477", "東城",
"81298", "土浦",
"812911", "鉾田",
"81581", "高富",
"818552", "浜田",
"819822", "延岡",
"811365", "倶知安",
"81742", "奈良",
"8153977", "天竜",
"819963", "川内",
"81235", "鶴岡",
"818669", "総社",
"81933", "北九州",
"81260", "阿南町",
"818558", "川本",
"812419", "田島",
"811873", "角館",
"818879", "室戸",
"817966", "八鹿",
"81827", "岩国",
"819805", "名護",
"812993", "石岡",
"812833", "宇都宮",
"817366", "岩出",
"811855", "能代",
"81286", "宇都宮",
"818246", "三次",
"812695", "中野",
"818391", "小郡",
"817498", "長浜",
"819547", "鹿島",
"818588", "郡家",
"815957", "上野",
"81989", "那覇",
"8125483", "村上",
"817492", "彦根",
"819665", "人吉",
"818582", "倉吉",
"818360", "小郡",
"81947", "田川",
"818542", "安来",
"817727", "峰山",
"8188090", "窪川",
"811936", "宮古",
"817617", "加賀",
"815563", "鰍沢青柳",
"812656", "伊那",
"818548", "石見大田",
"818664", "高梁",
"812976", "竜ケ崎",
"81234", "酒田",
"81877", "丸亀",
"811524", "網走",
"818795", "三本松",
"818874", "安芸",
"817453", "大和高田",
"817704", "敦賀",
"812414", "柳津",
"819724", "佐伯",
"811732", "五所川原",
"812558", "新井",
"81835", "防府",
"819677", "矢部",
"811977", "北上",
"811738", "鰺ケ沢",
"812552", "上越",
"81593", "四日市",
"819957", "加治木",
"81898", "今治",
"812477", "三春",
"812897", "鹿沼",
"81489", "草加",
"815363", "新城",
"81547", "島田",
"812786", "沼田",
"812937", "水戸",
"81493", "東松山",
"814794", "銚子",
"812913", "鉾田",
"818833", "鴨島",
"817954", "西脇",
"81227", "仙台",
"817949", "加古川",
"8125489", "津川",
"812879", "烏山",
"817674", "羽咋",
"81776", "福井",
"8153974", "天竜",
"811394", "松前",
"818264", "安芸吉田",
"818376", "美祢",
"818958", "御荘",
"818686", "津山",
"812746", "富岡",
"81582", "岐阜",
"818672", "福渡",
"81482", "川口",
"818382", "萩",
"818952", "宇和島",
"814229", "武蔵野三鷹",
"815587", "修善寺大仁",
"818678", "新見",
"814707", "大原",
"81270", "伊勢崎",
"818388", "田万川",
"818207", "久賀",
"812830", "宇都宮",
"819913", "硫黄島",
"818805", "土佐中村",
"81927", "福岡",
"817474", "五条",
"81586", "一宮",
"81125", "滝川",
"815393", "浜松",
"81486", "浦和",
"819558", "唐津",
"81833", "下松",
"81567", "津島",
"81538", "磐田",
"811586", "中湧別",
"815764", "下呂",
"811752", "むつ",
"812387", "長井",
"81438", "木更津",
"81467", "藤沢",
"812677", "佐久",
"811457", "門別富川",
"819552", "伊万里",
"817916", "竜野",
"8186552", "倉敷",
"812957", "大子",
"81174", "蟹田",
"81495", "本庄",
"81779", "大野",
"819937", "加世田",
"811637", "北見枝幸",
"819786", "杵築",
"818478", "東城",
"811364", "倶知安",
"819746", "竹田",
"819827", "高千穂",
"812563", "三条",
"815988", "三瀬谷",
"81178", "八戸",
"818472", "甲山",
"81434", "千葉",
"81958", "長崎",
"818557", "川本",
"818294", "廿日市",
"815982", "松阪",
"811546", "釧路",
"81534", "浜松",
"818892", "佐川",
"819804", "名護",
"8186993", "備前",
"819593", "大瀬戸",
"812236", "仙台",
"819208", "対馬佐賀",
"813", "東京",
"81938", "北九州",
"819942", "大根占",
"811642", "石狩深川",
"812547", "村上",
"81554", "大月",
"81143", "室蘭",
"8169", "大阪",
"811648", "焼尻",
"819948", "志布志",
"811564", "上士幌",
"814772", "市川",
"817468", "上北山",
"81427", "相模原",
"812875", "大田原",
"812794", "渋川",
"817945", "加古川",
"811237", "栗山",
"81986", "都城",
"811866", "鷹巣",
"81721", "富田林",
"818694", "岡山",
"817355", "新宮",
"812614", "大町",
"817718", "園部",
"815746", "美濃加茂",
"81282", "栃木",
"8186999", "岡山瀬戸",
"818947", "宇和",
"811956", "岩手",
"814225", "武蔵野三鷹",
"818464", "竹原",
"811378", "今金",
"817712", "亀岡",
"819976", "名瀬",
"81853", "出雲",
"81934", "北九州",
"812587", "長岡",
"811372", "鹿部",
"812892", "宇都宮",
"812486", "須賀川",
"819678", "矢部",
"811978", "北上",
"81555", "吉田",
"811356", "岩内",
"812932", "高萩",
"81577", "高山",
"812557", "新井",
"811652", "士別",
"819952", "大口",
"812472", "石川",
"817230", "寝屋川",
"812898", "鹿沼",
"811972", "水沢",
"819672", "熊本一の宮",
"812938", "水戸",
"818563", "益田",
"811737", "鰺ケ沢",
"811986", "遠野",
"819686", "玉名",
"812478", "三春",
"811658", "上川",
"812799", "長野原",
"817675", "七尾",
"817683", "輪島",
"814795", "銚子",
"817903", "福崎",
"814286", "相模原",
"817955", "三田",
"818265", "安芸吉田",
"811395", "江差",
"812619", "大町",
"81420", "所沢",
"812853", "小山",
"815582", "下田",
"8182943", "広島",
"814756", "東金",
"811946", "久慈",
"814702", "館山",
"8147950", "八日市場",
"81240", "磐城富岡",
"818957", "御荘",
"81998", "鹿児島",
"81762", "金沢",
"817996", "津名",
"811463", "浦河",
"815756", "郡上八幡",
"815588", "修善寺大仁",
"814708", "大原",
"818677", "新見",
"81935", "北九州",
"818387", "田万川",
"812963", "下館",
"8163", "大阪",
"81233", "新庄",
"811854", "男鹿",
"812694", "中野",
"818843", "阿南",
"81729", "八尾",
"81124", "芦別",
"818587", "郡家",
"81977", "別府",
"815769", "荘川",
"815952", "上野",
"81253", "新潟",
"819664", "人吉",
"8165", "大阪",
"817497", "長浜",
"81594", "桑名",
"81157", "北見",
"81494", "秩父",
"815958", "亀山",
"819542", "武雄",
"818363", "宇部",
"818665", "高梁",
"817618", "加賀",
"817728", "峰山",
"819576", "島原",
"81893", "大洲",
"81281", "宇都宮",
"811556", "帯広",
"81535", "浜松",
"817612", "小松",
"81460", "小田原",
"818299", "広島",
"818547", "掛合",
"817722", "宮津",
"81722", "堺",
"819725", "佐伯",
"819809", "八重山",
"811525", "網走",
"815993", "鳥羽",
"818794", "三本松",
"818875", "土佐山田",
"817705", "小浜",
"812415", "柳津",
"818974", "新居浜",
"812580", "十日町",
"811643", "石狩深川",
"819943", "鹿屋",
"812789", "前橋",
"818654", "鴨方",
"81737", "湯浅",
"817463", "吉野",
"81162", "稚内",
"81992", "鹿児島",
"817946", "三木",
"812876", "黒磯",
"81531", "田原",
"812244", "白石",
"817356", "串本",
"8125488", "津川",
"818397", "小郡",
"81983", "高鍋",
"817737", "舞鶴",
"811865", "大館",
"81764", "富山",
"819435", "八女",
"817713", "亀岡",
"818689", "岡山",
"812574", "柏崎",
"819975", "名瀬",
"819734", "日田",
"814226", "武蔵野三鷹",
"811955", "二戸",
"811534", "中標津",
"815745", "美濃加茂",
"81592", "津",
"8186994", "岡山瀬戸",
"81492", "川越",
"815392", "浜松",
"818806", "宿毛",
"81551", "韮崎",
"814701", "鴨川",
"818249", "東広島",
"817487", "水口",
"818597", "根雨",
"819912", "中之島",
"8186698", "倉敷",
"815398", "浜松",
"819785", "豊後高田",
"819553", "伊万里",
"8188095", "土佐清水",
"8153961", "天竜",
"817915", "相生",
"81728", "寝屋川",
"812374", "村山",
"8125482", "村上",
"811585", "遠軽",
"811753", "むつ",
"811545", "釧路",
"818473", "甲山",
"811939", "宮古",
"812568", "巻",
"815734", "恵那",
"812644", "木曾福島",
"815983", "松阪",
"818893", "佐川",
"812659", "伊那",
"812979", "竜ケ崎",
"81724", "岸和田貝塚",
"812562", "三条",
"819967", "出水",
"817964", "豊岡",
"811877", "大曲",
"819598", "福江",
"81583", "岐阜",
"812235", "仙台",
"81775", "大津",
"81888", "高知",
"812997", "潮来",
"819592", "大瀬戸",
"812837", "佐野",
"81778", "武生",
"81885", "小松島",
"81172", "弘前",
"818848", "牟岐",
"817364", "和歌山橋本",
"81439", "木更津",
"818244", "三次",
"81952", "佐賀",
"818842", "阿南",
"81896", "伊予三島",
"819543", "武雄",
"815953", "上野",
"812654", "飯田",
"818368", "宇部",
"812649", "長野",
"817613", "小松",
"811934", "釜石",
"817723", "宮津",
"811555", "帯広",
"818362", "宇部",
"8188098", "土佐清水",
"819575", "諫早",
"81725", "和泉",
"818666", "井原",
"812974", "水海道",
"81432", "千葉",
"812416", "田島",
"817457", "大和高田",
"817706", "小浜",
"815992", "鳥羽",
"817969", "浜坂",
"818876", "土佐山田",
"814992", "伊豆大島",
"81532", "豊橋",
"814771", "市川",
"811526", "網走",
"819726", "臼杵",
"81179", "三戸",
"815998", "阿児",
"81774", "宇治",
"8198291", "延岡",
"814998", "小笠原",
"8112391", "夕張",
"819685", "玉名",
"818562", "益田",
"819673", "熊本一の宮",
"811973", "水沢",
"812893", "宇都宮",
"812784", "沼田",
"815367", "設楽",
"812933", "高萩",
"818568", "津和野",
"8186997", "岡山瀬戸",
"812485", "白河",
"819953", "大口",
"81236", "山形",
"811653", "士別",
"812473", "石川",
"818837", "阿波池田",
"812917", "水戸",
"817902", "福崎",
"817956", "三田",
"817688", "能都",
"8183768", "下関",
"814285", "相模原",
"81288", "今市",
"8188092", "窪川",
"814796", "八日市場",
"81591", "津",
"817908", "播磨山崎",
"817682", "輪島",
"817676", "七尾",
"81939", "北九州",
"8125485", "津川",
"81552", "甲府",
"81743", "奈良",
"811396", "江差",
"81797", "西宮",
"81559", "沼津",
"81932", "北九州",
"812852", "小山",
"81284", "足利",
"818266", "千代田",
"81765", "魚津",
"812858", "真岡",
"812962", "下館",
"812579", "小出",
"818684", "津山",
"812744", "藤岡",
"818374", "長門",
"817995", "洲本",
"814703", "館山",
"815755", "関",
"8128798", "大田原",
"815583", "下田",
"8147957", "八日市場",
"812968", "笠間",
"811539", "根室標津",
"811945", "久慈",
"812550", "安塚",
"811462", "浦河",
"814755", "東金",
"81564", "岡崎",
"8167", "大阪",
"818476", "府中",
"815972", "尾鷲",
"81273", "高崎",
"815986", "松阪",
"811542", "釧路",
"815737", "中津川",
"818896", "須崎",
"81464", "厚木",
"812647", "長野",
"81975", "大分",
"819742", "三重",
"812565", "三条",
"81177", "青森",
"815978", "熊野",
"811548", "弟子屈",
"819964", "川内",
"8188096", "土佐清水",
"817967", "八鹿",
"8182941", "広島",
"812238", "仙台",
"8112394", "夕張",
"811874", "角館",
"81924", "福岡",
"817459", "大和榛原",
"819595", "有川",
"812994", "石岡",
"812232", "岩沼",
"8199347", "鹿児島",
"812834", "宇都宮",
"815395", "浜松",
"817484", "八日市",
"818803", "土佐中村",
"81928", "福岡",
"818594", "米子",
"817912", "相生",
"811337", "石狩",
"811588", "興部",
"819556", "唐津",
"819782", "豊後高田",
"81845", "因島",
"818290", "広島",
"812377", "寒河江",
"811582", "紋別",
"81468", "横須賀",
"81568", "春日井",
"819788", "国東",
"81537", "掛川",
"811756", "野辺地",
"81863", "玉野",
"811868", "鷹巣",
"81424", "武蔵野三鷹",
"812247", "大河原",
"817353", "新宮",
"811862", "鹿角",
"817734", "福知山",
"819972", "種子島",
"815748", "美濃白川",
"812577", "六日町",
"81964", "松橋",
"817716", "園部",
"811958", "岩手",
"819432", "八女",
"811376", "八雲",
"81557", "伊東",
"819737", "玖珠",
"819978", "徳之島",
"811537", "中標津",
"815742", "美濃加茂",
"814223", "武蔵野三鷹",
"817239", "寝屋川",
"811952", "二戸",
"819438", "田主丸",
"81244", "原町",
"8111", "札幌",
"818977", "伯方",
"814776", "船橋",
"8198294", "延岡",
"8183766", "下関",
"811646", "羽幌",
"819946", "鹿屋",
"8126177", "長野",
"81792", "姫路",
"81937", "北九州",
"818657", "笠岡",
"818690", "岡山",
"817466", "十津川",
"817943", "加古川",
"812873", "大田原",
"81823", "呉",
"818514", "海士",
"812855", "小山",
"81425", "立川",
"811393", "松前",
"818263", "加計",
"81930", "行橋",
"81263", "松本",
"8166", "大阪",
"814758", "東金",
"818687", "美作",
"812747", "富岡",
"81474", "船橋",
"81965", "八代",
"815758", "郡上八幡",
"817998", "津名",
"818377", "下関",
"812965", "下館",
"81245", "福島",
"81167", "富良野",
"815586", "下田",
"81138", "函館",
"811465", "静内",
"811942", "岩泉",
"814752", "茂原",
"814706", "大原",
"8112397", "栗山",
"815752", "関",
"817992", "洲本",
"8125486", "津川",
"81739", "田辺",
"811976", "北上",
"819676", "高森",
"812488", "須賀川",
"81134", "小樽",
"818565", "益田",
"819682", "山鹿",
"811982", "花巻",
"81478", "佐原",
"812787", "沼田",
"81550", "御殿場",
"812936", "水戸",
"811352", "余市",
"812896", "鹿沼",
"812482", "白河",
"811656", "美深",
"819956", "加治木",
"812476", "三春",
"81578", "神岡",
"819688", "玉名",
"812914", "鉾田",
"818834", "鴨島",
"817953", "西脇",
"817905", "福崎",
"814793", "銚子",
"814282", "青梅",
"817673", "羽咋",
"817685", "輪島",
"814288", "青梅",
"817616", "小松",
"812657", "伊那",
"81465", "小田原",
"811552", "帯広",
"815564", "鰍沢青柳",
"811937", "宮古",
"819578", "島原",
"81565", "豊田",
"817726", "峰山",
"819969", "中甑",
"811558", "広尾",
"818365", "宇部",
"81848", "尾道",
"812977", "竜ケ崎",
"819572", "諫早",
"81543", "静岡",
"818663", "総社",
"817703", "敦賀",
"817454", "大和高田",
"814291", "飯能",
"818493", "尾道",
"81925", "福岡",
"812413", "喜多方",
"811523", "斜里",
"818873", "安芸",
"815995", "阿児",
"8162", "大阪",
"819723", "佐伯",
"812839", "佐野",
"812999", "潮来",
"8198297", "日向",
"817367", "岩出",
"8124196", "柳津",
"818845", "丹生谷",
"818247", "庄原",
"819546", "鹿島",
"81950", "平戸",
"815956", "上野",
"811863", "鹿角",
"81734", "和歌山",
"81280", "古河",
"818697", "備前",
"812617", "大町",
"81572", "多治見",
"81561", "瀬戸",
"817352", "新宮",
"818944", "八幡浜",
"814222", "武蔵野三鷹",
"815743", "美濃加茂",
"811953", "二戸",
"818467", "木江",
"8178", "神戸",
"819973", "種子島",
"814228", "武蔵野三鷹",
"811375", "八雲",
"817715", "亀岡",
"819433", "八女",
"812584", "長岡",
"8198293", "延岡",
"818679", "新見",
"812544", "新発田",
"814298", "飯能",
"812559", "安塚",
"8112399", "栗山",
"811645", "留萌",
"819945", "鹿屋",
"814775", "船橋",
"812570", "小出",
"811567", "十勝清水",
"812872", "大田原",
"817948", "三木",
"812797", "渋川",
"812878", "烏山",
"811551", "十勝池田",
"811234", "千歳",
"817942", "加古川",
"817465", "吉野",
"81738", "御坊",
"819743", "三重",
"811367", "寿都",
"819824", "延岡",
"812566", "三条",
"8153960", "天竜",
"818895", "須崎",
"818549", "石見大田",
"815973", "尾鷲",
"818554", "浜田",
"815985", "松阪",
"814281", "相模原",
"811543", "釧路",
"818475", "府中",
"818297", "廿日市",
"81849", "福山",
"819807", "沖縄宮古",
"819596", "福江",
"812233", "岩沼",
"819205", "厳原",
"8198299", "日向",
"81191", "一関",
"8112393", "夕張",
"818204", "柳井",
"81979", "中津",
"818802", "窪川",
"817960", "八鹿",
"818808", "土佐清水",
"815396", "浜松",
"811583", "紋別",
"81276", "太田",
"815767", "下呂",
"812384", "米沢",
"811454", "鵡川",
"812674", "小諸",
"81727", "池田",
"819783", "豊後高田",
"812640", "長野",
"819555", "唐津",
"819934", "指宿",
"811634", "浜頓別",
"818366", "宇部",
"8144", "川崎",
"818662", "高梁",
"819573", "諫早",
"817725", "宮津",
"811553", "帯広",
"818559", "川本",
"818544", "木次",
"818668", "井原",
"81922", "福岡",
"817615", "小松",
"819722", "佐伯",
"812418", "会津山口",
"811528", "美幌",
"818240", "東広島",
"818878", "嶺北",
"815996", "阿児",
"817702", "敦賀",
"819728", "臼杵",
"81562", "尾張横須賀",
"81471", "柏",
"812412", "喜多方",
"818797", "土庄",
"811522", "斜里",
"818872", "室戸",
"81462", "厚木",
"814996", "八丈島",
"81569", "半田",
"811857", "能代",
"818846", "丹生谷",
"81226", "気仙沼",
"812697", "飯山",
"8198290", "延岡",
"812679", "佐久",
"815955", "上野",
"818584", "倉吉",
"812389", "米沢",
"819667", "水俣",
"817494", "彦根",
"81929", "福岡",
"811639", "利尻礼文",
"81546", "静岡",
"818262", "加計",
"81242", "会津若松",
"811398", "熊石",
"81798", "西宮",
"81962", "熊本",
"81192", "大船渡",
"818268", "千代田",
"812856", "真岡",
"811392", "木古内",
"814753", "茂原",
"811943", "岩泉",
"812780", "前橋",
"818949", "宇和",
"814705", "館山",
"811466", "えりも",
"815753", "関",
"817993", "洲本",
"818954", "宇和島",
"815585", "下田",
"8112390", "夕張",
"818674", "久世",
"812589", "長岡",
"818384", "萩",
"811353", "余市",
"81266", "諏訪",
"8199343", "鹿児島",
"81429", "所沢",
"812483", "白河",
"812475", "石川",
"819955", "加治木",
"811655", "名寄",
"812554", "上越",
"812895", "宇都宮",
"812549", "津川",
"812935", "水戸",
"81946", "甘木",
"811734", "五所川原",
"819683", "山鹿",
"811983", "花巻",
"819675", "熊本一の宮",
"811975", "水沢",
"818680", "岡山",
"81183", "湯沢",
"8153963", "天竜",
"817686", "能都",
"81199", "盛岡",
"81969", "天草",
"817958", "丹波柏原",
"814798", "八日市場",
"817672", "羽咋",
"817906", "播磨山崎",
"817952", "西脇",
"814792", "銚子",
"814283", "青梅",
"811541", "弟子屈",
"81249", "郡山",
"817678", "七尾",};
my $timezones = {
               '' => [
                       'Asia/Tokyo'
                     ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+81|\D)//g;
      my $self = bless({ country_code => '81', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      my $prefix = qr/^(?:(000[259]\d{6})$|(?:(?:003768)0?)|0)/;
      my @matches = $number =~ /$prefix/;
      if (defined $matches[-1]) {
        no warnings 'uninitialized';
        $number =~ s/$prefix/$1/;
      }
      else {
        $number =~ s/$prefix//;
      }
      $self = bless({ country_code => '81', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;