package Acme::CPANAuthors::CPAN::Streaks::WeeklyReleases::Current;

use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-06-01'; # DATE
our $DIST = 'Acme-CPANAuthorsBundle-CPAN-Streaks'; # DIST
our $VERSION = '20240601.0'; # VERSION

use Acme::CPANAuthors::Register (
    'PERLANCAR' => '',
    'KIMOTO' => '',
    'SKIM' => '',
    'ETHER' => '',
    'TYRRMINAL' => '',
    'MATHIAS' => '',
    'ARFREITAS' => '',
    'UTASHIRO' => '',
    'JDEGUEST' => '',
    'LEONT' => '',
    'OLIVER' => '',
    'TIMKA' => '',
    'LNATION' => '',
    'GENE' => '',
    'PLICEASE' => '',
    'MBALLARIN' => '',
    'DERF' => '',
    'DERIV' => '',
    'EHUELS' => '',
    'HAARG' => '',
    'HANJE' => '',
    'NHORNE' => '',
    'BPSCHUCK' => '',
    'DAM' => '',
    'DCANTRELL' => '',
    'BRIANDFOY' => '',
    'DART' => '',
    'LIYAO' => '',
    'NAUTOFON' => '',
    'RJBS' => '',
    'WYANT' => '',
    'ABRAXXA' => '',
    'AKXLIX' => '',
    'ASPOSE' => '',
    'BIGFOOT' => '',
    'BINARY' => '',
    'BINGOS' => '',
    'BLHOTSKY' => '',
    'CAVAC' => '',
    'CHOROBA' => '',
    'CRUX' => '',
    'FASTLY' => '',
    'GLBRUNE' => '',
    'INGY' => '',
    'ISHIGAKI' => '',
    'KUERBIS' => '',
    'MARDEM' => '',
    'MARIOROY' => '',
    'MRUEDA' => '',
    'PREACTION' => '',
    'SREZIC' => '',
    'VDANJEAN' => '',
    'BAYASHI' => '',
    'BPS' => '',
    'CORION' => '',
    'DJERIUS' => '',
    'ETJ' => '',
    'EXODIST' => '',
    'GAHAYES' => '',
    'GBROWN' => '',
    'HMBRAND' => '',
    'JRM' => '',
    'KALDOR' => '',
    'LHRST' => '',
    'LITCHIE' => '',
    'MARKOV' => '',
    'OALDERS' => '',
    'OVID' => '',
    'PJACKLAM' => '',
    'QGARNIER' => '',
    'REEDFISH' => '',
    'RKAPL' => '',
    'RURBAN' => '',
    'SCESANO' => '',
    'SLAFFAN' => '',
    'SPWHITTON' => '',
    'SVW' => '',
    'TANIGUCHI' => '',
    'TINITA' => '',
    'TONYC' => '',
    'TVIGNAUD' => '',
    'WORTHMINE' => '',
    'YOSHIMASA' => '',
);


1;
# ABSTRACT: Authors with ongoing weekly releases streak (do a release every week)

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANAuthors::CPAN::Streaks::WeeklyReleases::Current - Authors with ongoing weekly releases streak (do a release every week)

=head1 VERSION

This document describes version 20240601.0 of Acme::CPANAuthors::CPAN::Streaks::WeeklyReleases::Current (from Perl distribution Acme-CPANAuthorsBundle-CPAN-Streaks), released on 2024-06-01.

=head1 SYNOPSIS

=head1 DESCRIPTION

Current standings (as of 2024-06-01, produced by L<cpan-streaks>):

  +-----------+-----+------------+-------------+
  | author    | len | start_date | status      |
  +-----------+-----+------------+-------------+
  | PERLANCAR | 510 | 2014-08-24 | ongoing     |
  | KIMOTO    |  19 | 2024-01-21 | ongoing     |
  | SKIM      |  19 | 2024-01-21 | ongoing     |
  | ETHER     |  14 | 2024-02-18 | might-break |
  | TYRRMINAL |  10 | 2024-03-24 | ongoing     |
  | MATHIAS   |   8 | 2024-03-31 | might-break |
  | ARFREITAS |   8 | 2024-04-07 | ongoing     |
  | UTASHIRO  |   6 | 2024-04-14 | might-break |
  | JDEGUEST  |   6 | 2024-04-21 | ongoing     |
  | LEONT     |   5 | 2024-04-21 | might-break |
  | OLIVER    |   5 | 2024-04-21 | might-break |
  | TIMKA     |   5 | 2024-04-21 | might-break |
  | LNATION   |   5 | 2024-04-28 | ongoing     |
  | GENE      |   4 | 2024-05-05 | ongoing     |
  | PLICEASE  |   4 | 2024-05-05 | ongoing     |
  | MBALLARIN |   3 | 2024-05-05 | might-break |
  | DERF      |   3 | 2024-05-12 | ongoing     |
  | DERIV     |   3 | 2024-05-12 | ongoing     |
  | EHUELS    |   3 | 2024-05-12 | ongoing     |
  | HAARG     |   3 | 2024-05-12 | ongoing     |
  | HANJE     |   3 | 2024-05-12 | ongoing     |
  | NHORNE    |   3 | 2024-05-12 | ongoing     |
  | BPSCHUCK  |   2 | 2024-05-12 | might-break |
  | DAM       |   2 | 2024-05-12 | might-break |
  | DCANTRELL |   2 | 2024-05-12 | might-break |
  | BRIANDFOY |   2 | 2024-05-19 | ongoing     |
  | DART      |   2 | 2024-05-19 | ongoing     |
  | LIYAO     |   2 | 2024-05-19 | ongoing     |
  | NAUTOFON  |   2 | 2024-05-19 | ongoing     |
  | RJBS      |   2 | 2024-05-19 | ongoing     |
  | WYANT     |   2 | 2024-05-19 | ongoing     |
  | ABRAXXA   |   1 | 2024-05-19 | might-break |
  | AKXLIX    |   1 | 2024-05-19 | might-break |
  | ASPOSE    |   1 | 2024-05-19 | might-break |
  | BIGFOOT   |   1 | 2024-05-19 | might-break |
  | BINARY    |   1 | 2024-05-19 | might-break |
  | BINGOS    |   1 | 2024-05-19 | might-break |
  | BLHOTSKY  |   1 | 2024-05-19 | might-break |
  | CAVAC     |   1 | 2024-05-19 | might-break |
  | CHOROBA   |   1 | 2024-05-19 | might-break |
  | CRUX      |   1 | 2024-05-19 | might-break |
  | FASTLY    |   1 | 2024-05-19 | might-break |
  | GLBRUNE   |   1 | 2024-05-19 | might-break |
  | INGY      |   1 | 2024-05-19 | might-break |
  | ISHIGAKI  |   1 | 2024-05-19 | might-break |
  | KUERBIS   |   1 | 2024-05-19 | might-break |
  | MARDEM    |   1 | 2024-05-19 | might-break |
  | MARIOROY  |   1 | 2024-05-19 | might-break |
  | MRUEDA    |   1 | 2024-05-19 | might-break |
  | PREACTION |   1 | 2024-05-19 | might-break |
  | SREZIC    |   1 | 2024-05-19 | might-break |
  | VDANJEAN  |   1 | 2024-05-19 | might-break |
  | BAYASHI   |   1 | 2024-05-26 | ongoing     |
  | BPS       |   1 | 2024-05-26 | ongoing     |
  | CORION    |   1 | 2024-05-26 | ongoing     |
  | DJERIUS   |   1 | 2024-05-26 | ongoing     |
  | ETJ       |   1 | 2024-05-26 | ongoing     |
  | EXODIST   |   1 | 2024-05-26 | ongoing     |
  | GAHAYES   |   1 | 2024-05-26 | ongoing     |
  | GBROWN    |   1 | 2024-05-26 | ongoing     |
  | HMBRAND   |   1 | 2024-05-26 | ongoing     |
  | JRM       |   1 | 2024-05-26 | ongoing     |
  | KALDOR    |   1 | 2024-05-26 | ongoing     |
  | LHRST     |   1 | 2024-05-26 | ongoing     |
  | LITCHIE   |   1 | 2024-05-26 | ongoing     |
  | MARKOV    |   1 | 2024-05-26 | ongoing     |
  | OALDERS   |   1 | 2024-05-26 | ongoing     |
  | OVID      |   1 | 2024-05-26 | ongoing     |
  | PJACKLAM  |   1 | 2024-05-26 | ongoing     |
  | QGARNIER  |   1 | 2024-05-26 | ongoing     |
  | REEDFISH  |   1 | 2024-05-26 | ongoing     |
  | RKAPL     |   1 | 2024-05-26 | ongoing     |
  | RURBAN    |   1 | 2024-05-26 | ongoing     |
  | SCESANO   |   1 | 2024-05-26 | ongoing     |
  | SLAFFAN   |   1 | 2024-05-26 | ongoing     |
  | SPWHITTON |   1 | 2024-05-26 | ongoing     |
  | SVW       |   1 | 2024-05-26 | ongoing     |
  | TANIGUCHI |   1 | 2024-05-26 | ongoing     |
  | TINITA    |   1 | 2024-05-26 | ongoing     |
  | TONYC     |   1 | 2024-05-26 | ongoing     |
  | TVIGNAUD  |   1 | 2024-05-26 | ongoing     |
  | WORTHMINE |   1 | 2024-05-26 | ongoing     |
  | YOSHIMASA |   1 | 2024-05-26 | ongoing     |
  +-----------+-----+------------+-------------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SEE ALSO

L<Acme::CPANAuthors>

CPAN Regulars Boards, L<http://cpan.io/board/once-a/>, which as of this writing,
has some input data missing and thus produces some incorrect results.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024, 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANAuthorsBundle-CPAN-Streaks>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
