#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Warhammer 40k: Gladius expansions:
# - Tyranids
# - Chaos Space Marines
# - T'au
# - Craftworld Aeldari
# - Adeptus Mechanicus
# - Adepta Sororitas
# - Drukhari
###

script_version=20241212.1

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID='warhammer-40k-gladius'
GAME_NAME='Warhammer 40,000: Gladius'

EXPANSION_ID_TYRANIDS='tyranids'
EXPANSION_NAME_TYRANIDS='Tyranids'

EXPANSION_ID_CHAOS='chaos-space-marines'
EXPANSION_NAME_CHAOS='Chaos Space Marines'

EXPANSION_ID_TAU='tau'
EXPANSION_NAME_TAU='Tʼau'

EXPANSION_ID_AELDARI='craftworld-aeldari'
EXPANSION_NAME_AELDARI='Craftworld Aeldari'

EXPANSION_ID_MECHANICUS='adeptus-mechanicus'
EXPANSION_NAME_MECHANICUS='Adeptus Mechanicus'

EXPANSION_ID_SORORITAS='adepta-sororitas'
EXPANSION_NAME_SORORITAS='Adepta Sororitas'

EXPANSION_ID_DRUKHARI='drukhari'
EXPANSION_NAME_DRUKHARI='Drukhari'

# Archives

## Tyranids

ARCHIVE_BASE_TYRANIDS_21_NAME='warhammer_40_000_gladius_tyranids_1_14_03_77940.sh'
ARCHIVE_BASE_TYRANIDS_21_MD5='08a7490d398a7f36c600a84367b9dfb8'
ARCHIVE_BASE_TYRANIDS_21_SIZE='1086'
ARCHIVE_BASE_TYRANIDS_21_VERSION='1.14.3-gog77940'
ARCHIVE_BASE_TYRANIDS_21_URL='https://www.gog.com/game/warhammer_40000_gladius_tyranids'

ARCHIVE_BASE_TYRANIDS_18_NAME='warhammer_40_000_gladius_tyranids_1_13_03_72014.sh'
ARCHIVE_BASE_TYRANIDS_18_MD5='1126da61c9bdc27a4c9c4cc9444ff87d'
ARCHIVE_BASE_TYRANIDS_18_SIZE='1086'
ARCHIVE_BASE_TYRANIDS_18_VERSION='1.13.3-gog72014'

ARCHIVE_BASE_TYRANIDS_15_NAME='warhammer_40_000_gladius_tyranids_1_12_03_67548.sh'
ARCHIVE_BASE_TYRANIDS_15_MD5='6fd672b4230bceebc496e7ce7aa455b4'
ARCHIVE_BASE_TYRANIDS_15_SIZE='1400'
ARCHIVE_BASE_TYRANIDS_15_VERSION='1.12.3-gog67548'

ARCHIVE_BASE_TYRANIDS_12_NAME='warhammer_40_000_gladius_tyranids_1_11_04_64361.sh'
ARCHIVE_BASE_TYRANIDS_12_MD5='53da0257c7ae0ca6c4b2712a70f8b666'
ARCHIVE_BASE_TYRANIDS_12_SIZE='1400'
ARCHIVE_BASE_TYRANIDS_12_VERSION='1.11.4-gog64361'

ARCHIVE_BASE_TYRANIDS_7_NAME='warhammer_40_000_gladius_tyranids_1_10_01_00_57375.sh'
ARCHIVE_BASE_TYRANIDS_7_MD5='30934475a2b0c8f794234d5e38f504cc'
ARCHIVE_BASE_TYRANIDS_7_SIZE='1400'
ARCHIVE_BASE_TYRANIDS_7_VERSION='1.10.1-gog57375'

ARCHIVE_BASE_TYRANIDS_5_NAME='warhammer_40_000_gladius_tyranids_v1_09_03_00_54377.sh'
ARCHIVE_BASE_TYRANIDS_5_MD5='ac2e7f57d90a405688304573e6332443'
ARCHIVE_BASE_TYRANIDS_5_SIZE='1400'
ARCHIVE_BASE_TYRANIDS_5_VERSION='1.9.3-gog54377'

ARCHIVE_BASE_TYRANIDS_3_NAME='warhammer_40_000_gladius_tyranids_1_08_04_01_49548.sh'
ARCHIVE_BASE_TYRANIDS_3_MD5='a6e5921db60b6a366619354b1eb47d23'
ARCHIVE_BASE_TYRANIDS_3_SIZE='1400'
ARCHIVE_BASE_TYRANIDS_3_VERSION='1.8.4.1-gog49548'

ARCHIVE_BASE_TYRANIDS_0_NAME='warhammer_40_000_gladius_tyranids_1_07_04_44200.sh'
ARCHIVE_BASE_TYRANIDS_0_MD5='c6c04852f1a3128dbfa267c89f1c9626'
ARCHIVE_BASE_TYRANIDS_0_SIZE='1400'
ARCHIVE_BASE_TYRANIDS_0_VERSION='1.7.4-gog44200'

## Chaos Space Marines

ARCHIVE_BASE_CHAOS_20_NAME='warhammer_40_000_gladius_chaos_space_marines_1_14_03_77940.sh'
ARCHIVE_BASE_CHAOS_20_MD5='4d3e181c0156ab28d81e4b8df4c3d1ba'
ARCHIVE_BASE_CHAOS_20_SIZE='1086'
ARCHIVE_BASE_CHAOS_20_VERSION='1.14.3-gog77940'
ARCHIVE_BASE_CHAOS_20_URL='https://www.gog.com/game/warhammer_40000_gladius_chaos_space_marines'

ARCHIVE_BASE_CHAOS_17_NAME='warhammer_40_000_gladius_chaos_space_marines_1_13_03_72014.sh'
ARCHIVE_BASE_CHAOS_17_MD5='a7c63aa885dd1a5b51b2b5a3d55d4e21'
ARCHIVE_BASE_CHAOS_17_SIZE='1086'
ARCHIVE_BASE_CHAOS_17_VERSION='1.13.3-gog72014'

ARCHIVE_BASE_CHAOS_14_NAME='warhammer_40_000_gladius_chaos_space_marines_1_12_03_67548.sh'
ARCHIVE_BASE_CHAOS_14_MD5='5103e5a13f5e04f6a0d4ce2124ae9b8f'
ARCHIVE_BASE_CHAOS_14_SIZE='1400'
ARCHIVE_BASE_CHAOS_14_VERSION='1.12.3-gog67548'

ARCHIVE_BASE_CHAOS_11_NAME='warhammer_40_000_gladius_chaos_space_marines_1_11_04_64361.sh'
ARCHIVE_BASE_CHAOS_11_MD5='2c613e93f92197efb004a4d590f6412e'
ARCHIVE_BASE_CHAOS_11_SIZE='1400'
ARCHIVE_BASE_CHAOS_11_VERSION='1.11.4-gog64361'

ARCHIVE_BASE_CHAOS_6_NAME='warhammer_40_000_gladius_chaos_space_marines_1_10_01_00_57375.sh'
ARCHIVE_BASE_CHAOS_6_MD5='88542a8341638e1d51e2758c9886e2c6'
ARCHIVE_BASE_CHAOS_6_SIZE='1400'
ARCHIVE_BASE_CHAOS_6_VERSION='1.10.1-gog57375'

ARCHIVE_BASE_CHAOS_4_NAME='warhammer_40_000_gladius_chaos_space_marines_v1_09_03_00_54377.sh'
ARCHIVE_BASE_CHAOS_4_MD5='ed2c64df977669d9413648347c883a35'
ARCHIVE_BASE_CHAOS_4_SIZE='1400'
ARCHIVE_BASE_CHAOS_4_VERSION='1.9.3-gog54377'

ARCHIVE_BASE_CHAOS_2_NAME='warhammer_40_000_gladius_chaos_space_marines_1_08_04_01_49548.sh'
ARCHIVE_BASE_CHAOS_2_MD5='37894d5cd89aaa67dc841d2f5023ebf2'
ARCHIVE_BASE_CHAOS_2_SIZE='1400'
ARCHIVE_BASE_CHAOS_2_VERSION='1.8.4.1-gog49548'

## T'au

ARCHIVE_BASE_TAU_17_NAME='warhammer_40_000_gladius_t_au_1_14_03_77940.sh'
ARCHIVE_BASE_TAU_17_MD5='e69fec137633403f9b37fa37d58da209'
ARCHIVE_BASE_TAU_17_SIZE='1086'
ARCHIVE_BASE_TAU_17_VERSION='1.14.3-gog77940'
ARCHIVE_BASE_TAU_17_URL='https://www.gog.com/game/warhammer_40000_gladius_tau'

ARCHIVE_BASE_TAU_14_NAME='warhammer_40_000_gladius_t_au_1_13_03_72014.sh'
ARCHIVE_BASE_TAU_14_MD5='cc6b1b472357aafe1a92906dbac6ce56'
ARCHIVE_BASE_TAU_14_SIZE='1086'
ARCHIVE_BASE_TAU_14_VERSION='1.13.3-gog72014'

ARCHIVE_BASE_TAU_11_NAME='warhammer_40_000_gladius_t_au_1_12_03_67548.sh'
ARCHIVE_BASE_TAU_11_MD5='c0dd6e15c253f1b58a0d596fec8d1531'
ARCHIVE_BASE_TAU_11_SIZE='1396'
ARCHIVE_BASE_TAU_11_VERSION='1.12.3-gog67548'

ARCHIVE_BASE_TAU_8_NAME='warhammer_40_000_gladius_t_au_1_11_04_64361.sh'
ARCHIVE_BASE_TAU_8_MD5='b8d20922d142704e61dbb8dbe83ce2b0'
ARCHIVE_BASE_TAU_8_SIZE='1400'
ARCHIVE_BASE_TAU_8_VERSION='1.11.4-gog64361'

ARCHIVE_BASE_TAU_3_NAME='warhammer_40_000_gladius_t_au_1_10_01_00_57375.sh'
ARCHIVE_BASE_TAU_3_MD5='1f7770a75d1c846aca32f905cd4ce51f'
ARCHIVE_BASE_TAU_3_SIZE='1400'
ARCHIVE_BASE_TAU_3_VERSION='1.10.1-gog57375'

ARCHIVE_BASE_TAU_1_NAME='warhammer_40_000_gladius_t_au_v1_09_03_00_54377.sh'
ARCHIVE_BASE_TAU_1_MD5='22b575c6ce8da35f7d57335662de4747'
ARCHIVE_BASE_TAU_1_SIZE='1400'
ARCHIVE_BASE_TAU_1_VERSION='1.9.3-gog54377'

## Craftworld Aeldari

ARCHIVE_BASE_AELDARI_15_NAME='warhammer_40_000_gladius_craftworld_aeldari_1_14_03_77940.sh'
ARCHIVE_BASE_AELDARI_15_MD5='73a817b4990d66ea7f938d82d0ec4bbf'
ARCHIVE_BASE_AELDARI_15_SIZE='1086'
ARCHIVE_BASE_AELDARI_15_VERSION='1.14.3-gog77940'
ARCHIVE_BASE_AELDARI_15_URL='https://www.gog.com/game/warhammer_40000_gladius_craftworld_aeldari'

ARCHIVE_BASE_AELDARI_12_NAME='warhammer_40_000_gladius_craftworld_aeldari_1_13_03_72014.sh'
ARCHIVE_BASE_AELDARI_12_MD5='18e5d21d0d2b202d746de192cc4370da'
ARCHIVE_BASE_AELDARI_12_SIZE='1086'
ARCHIVE_BASE_AELDARI_12_VERSION='1.13.3-gog72014'

ARCHIVE_BASE_AELDARI_9_NAME='warhammer_40_000_gladius_craftworld_aeldari_1_12_03_67548.sh'
ARCHIVE_BASE_AELDARI_9_MD5='a9ed6a70658299ab82d2934f7b572151'
ARCHIVE_BASE_AELDARI_9_SIZE='1400'
ARCHIVE_BASE_AELDARI_9_VERSION='1.12.3-gog67548'

ARCHIVE_BASE_AELDARI_6_NAME='warhammer_40_000_gladius_craftworld_aeldari_1_11_04_64361.sh'
ARCHIVE_BASE_AELDARI_6_MD5='2c2b76c50ee3d7c29fd24c8aea0fe6e0'
ARCHIVE_BASE_AELDARI_6_SIZE='1400'
ARCHIVE_BASE_AELDARI_6_VERSION='1.11.4-gog64361'

ARCHIVE_BASE_AELDARI_1_NAME='warhammer_40_000_gladius_craftworld_aeldari_1_10_01_00_57375.sh'
ARCHIVE_BASE_AELDARI_1_MD5='b3698a59f99611fb8431a76ea50ef35d'
ARCHIVE_BASE_AELDARI_1_SIZE='1400'
ARCHIVE_BASE_AELDARI_1_VERSION='1.10.1-gog57375'

## Adeptus Mechanicus

ARCHIVE_BASE_MECHANICUS_8_NAME='warhammer_40_000_gladius_adeptus_mechanicus_1_14_03_77940.sh'
ARCHIVE_BASE_MECHANICUS_8_MD5='ea312fa967f14ad4511bc178430aeda1'
ARCHIVE_BASE_MECHANICUS_8_SIZE='1086'
ARCHIVE_BASE_MECHANICUS_8_VERSION='1.14.3-gog77940'
ARCHIVE_BASE_MECHANICUS_8_URL='https://www.gog.com/game/warhammer_40000_gladius_adeptus_mechanicus'

ARCHIVE_BASE_MECHANICUS_5_NAME='warhammer_40_000_gladius_adeptus_mechanicus_1_13_03_72014.sh'
ARCHIVE_BASE_MECHANICUS_5_MD5='7670878de137f0de17cdae93ded39f09'
ARCHIVE_BASE_MECHANICUS_5_SIZE='1086'
ARCHIVE_BASE_MECHANICUS_5_VERSION='1.13.3-gog72014'

ARCHIVE_BASE_MECHANICUS_2_NAME='warhammer_40_000_gladius_adeptus_mechanicus_1_12_03_67548.sh'
ARCHIVE_BASE_MECHANICUS_2_MD5='0be493045812d7ee50c5c7846b60151e'
ARCHIVE_BASE_MECHANICUS_2_SIZE='1400'
ARCHIVE_BASE_MECHANICUS_2_VERSION='1.12.3-gog67548'

## Adepta Sororitas

ARCHIVE_BASE_SORORITAS_7_NAME='warhammer_40_000_gladius_adepta_sororitas_1_14_03_77940.sh'
ARCHIVE_BASE_SORORITAS_7_MD5='2166533e2ed1efc020729e5b174a1721'
ARCHIVE_BASE_SORORITAS_7_SIZE='1086'
ARCHIVE_BASE_SORORITAS_7_VERSION='1.14.3-gog77940'
ARCHIVE_BASE_SORORITAS_7_URL='https://www.gog.com/game/warhammer_40000_gladius_adepta_sororitas'

ARCHIVE_BASE_SORORITAS_4_NAME='warhammer_40_000_gladius_adepta_sororitas_1_13_03_72014.sh'
ARCHIVE_BASE_SORORITAS_4_MD5='6d588bac7b0e51c140f8cbb888b8de61'
ARCHIVE_BASE_SORORITAS_4_SIZE='1086'
ARCHIVE_BASE_SORORITAS_4_VERSION='1.13.3-gog72014'

ARCHIVE_BASE_SORORITAS_1_NAME='warhammer_40_000_gladius_adepta_sororitas_1_12_03_67548.sh'
ARCHIVE_BASE_SORORITAS_1_MD5='1c69d1ce8301b0fb42f10718a4271761'
ARCHIVE_BASE_SORORITAS_1_SIZE='1400'
ARCHIVE_BASE_SORORITAS_1_VERSION='1.12.3-gog67548'

## Drukhari

ARCHIVE_BASE_DRUKHARI_4_NAME='warhammer_40_000_gladius_drukhari_1_14_03_77940.sh'
ARCHIVE_BASE_DRUKHARI_4_MD5='f8ad53fe2b0eba0ff16089e2840fdc40'
ARCHIVE_BASE_DRUKHARI_4_SIZE='1086'
ARCHIVE_BASE_DRUKHARI_4_VERSION='1.14.3-gog77940'
ARCHIVE_BASE_DRUKHARI_4_URL='https://www.gog.com/game/warhammer_40000_gladius_drukhari'

ARCHIVE_BASE_DRUKHARI_1_NAME='warhammer_40_000_gladius_drukhari_1_13_03_72014.sh'
ARCHIVE_BASE_DRUKHARI_1_MD5='9f04c3d2b819a9865f853fcf184df6fe'
ARCHIVE_BASE_DRUKHARI_1_SIZE='1086'
ARCHIVE_BASE_DRUKHARI_1_VERSION='1.13.3-gog72014'


CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_MAIN_FILES='
Data/*.dlc'

PKG_PARENT_ID="$GAME_ID"
PKG_MAIN_DEPENDENCIES_SIBLINGS='
PKG_PARENT'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_default

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
