/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "android-base/hex.h"

#include <gtest/gtest.h>

TEST(hex, empty) {
  ASSERT_EQ("", android::base::HexString(nullptr, 0));
  ASSERT_EQ("", android::base::HexString(reinterpret_cast<void*>(int32_t(0)), 0));
}

TEST(hex, short) {
  const int32_t kShortData = 0xDEADBEEF;
  ASSERT_EQ("ef", android::base::HexString(&kShortData, 1));
  ASSERT_EQ("efbe", android::base::HexString(&kShortData, 2));
  ASSERT_EQ("efbead", android::base::HexString(&kShortData, 3));
  ASSERT_EQ("efbeadde", android::base::HexString(&kShortData, 4));
}

TEST(hex, all) {
  constexpr size_t kSize = 256;
  uint8_t kLongData[kSize];
  for (size_t i = 0; i < kSize; i++) {
    kLongData[i] = i;
  }

  ASSERT_EQ(
      "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232425262728292a2b2c2d"
      "2e2f303132333435363738393a3b3c3d3e3f404142434445464748494a4b4c4d4e4f505152535455565758595a5b"
      "5c5d5e5f606162636465666768696a6b6c6d6e6f707172737475767778797a7b7c7d7e7f80818283848586878889"
      "8a8b8c8d8e8f909192939495969798999a9b9c9d9e9fa0a1a2a3a4a5a6a7a8a9aaabacadaeafb0b1b2b3b4b5b6b7"
      "b8b9babbbcbdbebfc0c1c2c3c4c5c6c7c8c9cacbcccdcecfd0d1d2d3d4d5d6d7d8d9dadbdcdddedfe0e1e2e3e4e5"
      "e6e7e8e9eaebecedeeeff0f1f2f3f4f5f6f7f8f9fafbfcfdfeff",
      android::base::HexString(&kLongData, kSize));
}
