/****************************************************************************
**
** Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
**
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of a Qt Solutions component.
**
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Nokia Corporation and its Subsidiary(-ies) nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
****************************************************************************/


//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists for the convenience
// of Qt Designer.  This header
// file may change from version to version without notice, or even be removed.
//
// We mean it.
//

#ifndef QTPROPERTYBROWSERUTILS_H
#define QTPROPERTYBROWSERUTILS_H

#include <QMap>
#include <QIcon>
#include <QWidget>
#include <QStringList>

#if QT_VERSION >= 0x040400
QT_BEGIN_NAMESPACE
#endif

class QMouseEvent;
class QCheckBox;
class QLineEdit;

/**
 * @ingroup group_sdk_libraries_qtpropertybrowser
 *
 * @brief
 * The description of this class will come soon !
 *
 **/
class QtCursorDatabase {
public:
    QtCursorDatabase();

    QStringList cursorShapeNames() const;
    QMap<int, QIcon> cursorShapeIcons() const;
    QString cursorToShapeName(const QCursor& cursor) const;
    QIcon cursorToShapeIcon(const QCursor& cursor) const;
    int cursorToValue(const QCursor& cursor) const;
#ifndef QT_NO_CURSOR
    QCursor valueToCursor(int value) const;
#endif
private:
    void appendCursor(Qt::CursorShape shape, const QString& name, const QIcon& icon);
    QStringList m_cursorNames;
    QMap<int, QIcon> m_cursorIcons;
    QMap<int, Qt::CursorShape> m_valueToCursorShape;
    QMap<Qt::CursorShape, int> m_cursorShapeToValue;
};

class QtPropertyBrowserUtils {
public:
    static QPixmap brushValuePixmap(const QBrush& b);
    static QIcon brushValueIcon(const QBrush& b);
    static QString colorValueText(const QColor& c);
    static QPixmap fontValuePixmap(const QFont& f);
    static QIcon fontValueIcon(const QFont& f);
    static QString fontValueText(const QFont& f);
};

#if defined(_WIN32)
#ifndef QT_QTPROPERTYBROWSER_EXPORT
#    if defined(COMPILE_QTPROPERTYBROWSER)
#              define QT_QTPROPERTYBROWSER_EXPORT __declspec(dllexport)
#    else
#              define QT_QTPROPERTYBROWSER_EXPORT __declspec(dllimport)
#    endif
#endif // QT_QTPROPERTYBROWSER_EXPORT
#else
#define QT_QTPROPERTYBROWSER_EXPORT
#endif
class QT_QTPROPERTYBROWSER_EXPORT QtBoolEdit : public QWidget {
    Q_OBJECT
public:
    QtBoolEdit(QWidget* parent = nullptr);

    bool textVisible() const {
        return m_textVisible;
    }
    void setTextVisible(bool textVisible);

    Qt::CheckState checkState() const;
    void setCheckState(Qt::CheckState state);

    bool isChecked() const;
    void setChecked(bool c);

    bool blockCheckBoxSignals(bool block);

Q_SIGNALS:
    void toggled(bool);

protected:
    void mousePressEvent(QMouseEvent* event) override;
    void paintEvent(QPaintEvent*) override;

private:
    QCheckBox* m_checkBox;
    bool m_textVisible{true};
};

class QtKeySequenceEdit : public QWidget {
    Q_OBJECT
public:
    QtKeySequenceEdit(QWidget* parent = nullptr);

    QKeySequence keySequence() const;
    bool eventFilter(QObject* o, QEvent* e) override;
public Q_SLOTS:
    void setKeySequence(const QKeySequence& sequence);
Q_SIGNALS:
    void keySequenceChanged(const QKeySequence& sequence);
protected:
    void focusInEvent(QFocusEvent* e) override;
    void focusOutEvent(QFocusEvent* e) override;
    void keyPressEvent(QKeyEvent* e) override;
    void keyReleaseEvent(QKeyEvent* e) override;
    void paintEvent(QPaintEvent*) override;
    bool event(QEvent* e) override;
private slots:
    void slotClearShortcut();
private:
    void handleKeyEvent(QKeyEvent* e);
    int translateModifiers(Qt::KeyboardModifiers state, const QString& text) const;

    int m_num{0};
    QKeySequence m_keySequence;
    QLineEdit* m_lineEdit;
};

#if QT_VERSION >= 0x040400
QT_END_NAMESPACE
#endif

#endif
