# F3D Code of Conduct

## Our Pledge

We as members, contributors, moderators and maintainers pledge to make participation in our
community a harassment-free experience for everyone, regardless of age, body
size, visible or invisible disability, ethnicity, sex characteristics, gender
identity and expression, level of experience, education, socioeconomic status,
nationality, personal appearance, race, caste, color, religion, or sexual
identity and orientation.

We pledge to act and interact in ways that contribute to an open, welcoming,
diverse, inclusive, and healthy community.

## Our Standards

Examples of behavior that contributes to a positive environment for our
community include:

- Demonstrating empathy and kindness toward other people
- Being respectful of differing opinions, viewpoints, and experiences
- Giving and gracefully accepting constructive feedback
- Accepting responsibility and apologizing to those affected by our mistakes,
  and learning from the experience
- Focusing on what is best not just for us as individuals, but for the overall
  community

Examples of unacceptable behavior include:

- The use of sexualized language or imagery, and sexual attention or advances of
  any kind
- Trolling, insulting or derogatory comments, and personal or political attacks
- Public or private harassment
- Publishing others' private information, such as a physical or email address,
  without their explicit permission
- Other conduct which could reasonably be considered inappropriate in a
  professional setting

## Enforcement Responsibilities

Maintainers and moderators are responsible for clarifying and enforcing our standards of
acceptable behavior and will take appropriate and fair corrective action in
response to any behavior that they deem inappropriate, threatening, offensive,
or harmful.

Maintainers and moderators have the responsibility to investigate any potential
code of conduct violation, reported or not, in order to avoid harm to the community.

Maintainers have the right and responsibility to remove, edit, or reject
comments, commits, code, wiki edits, issues, and other contributions that are
not aligned to this Code of Conduct, and will communicate reasons for moderation
decisions when appropriate.

In case of any issues please reach out, either to any moderators or maintainers
on [discord] or at <contact@f3d.app>.

## Scope

This Code of Conduct applies within all community spaces, especially on github and on [discord] but not only,
and also applies when an individual is officially representing the community in public spaces.
Examples of representing our community include using an official email address,
posting via an official social media account, or acting as an appointed
representative at an online or offline event.

## Incident report processing

All incident report will be handled by maintainers and modarators.
First they will immediately reply to the report to confirm receipt.
This reply must be sent within 24 hours, and they should strive to respond much quicker than that.
Then they will recover more data if the report does not contain enough information.

They will then review the incident and determine, to the best of their ability:

- what happened
- whether this event constitutes a code of conduct violation
- who, if anyone, has acted against the code of conduct
- whether this is an ongoing situation, and there is a threat to anyone's physical or moral safety

This information will be collected in writing, and whenever possible the committee's deliberations will be recorded and retained
(i.e. chat transcripts, email discussions, recorded voice conversations, etc).

They should aim to have a resolution agreed upon within one week.
In the event that a resolution can't be determined in that time,
they will respond to the reporter(s) with an update and projected timeline for resolution.

In the event of any conflict of interest a member must immediately notify the other members, and recuse themselves if necessary.

## Enforcement

Instances of abusive, harassing, or otherwise unacceptable behavior may be
reported to the maintainers and moderators responsible for enforcement on our [discord].
All complaints will be reviewed and investigated promptly and fairly.

All maintainers and moderators are obligated to respect the privacy and security
of the reporter of any incident.

## Enforcement Guidelines

Maintainers and moderators will follow these Community Impact Guidelines in determining
the consequences for any action they deem in violation of this Code of Conduct:

### 1. Correction

**Community Impact**: Use of inappropriate language or other behavior deemed
unprofessional or unwelcome in the community.

**Consequence**: A private, written warning from maintainers and moderators, providing
clarity around the nature of the violation and an explanation of why the
behavior was inappropriate. A public apology may be requested.

### 2. Warning

**Community Impact**: A violation through a single incident or series of
actions.

**Consequence**: A warning with consequences for continued behavior. No
interaction with the people involved, including unsolicited interaction with
those enforcing the Code of Conduct, for a specified period of time. This
includes avoiding interactions in community spaces as well as external channels
like social media. Violating these terms may lead to a temporary or permanent
ban.

### 3. Temporary Ban

**Community Impact**: A serious violation of community standards, including
sustained inappropriate behavior.

**Consequence**: A temporary ban from any sort of interaction or public
communication with the community for a specified period of time. No public or
private interaction with the people involved, including unsolicited interaction
with those enforcing the Code of Conduct, is allowed during this period.
Violating these terms may lead to a permanent ban.

### 4. Permanent Ban

**Community Impact**: Demonstrating a pattern of violation of community
standards, including sustained inappropriate behavior, harassment of an
individual, or aggression toward or disparagement of classes of individuals.

**Consequence**: A permanent ban from any sort of public interaction within the
community.

## Attribution

This Code of Conduct is adapted from the [Contributor Covenant][homepage],
version 2.1, available at
[https://www.contributor-covenant.org/version/2/1/code_of_conduct.html][v2.1].

Community Impact Guidelines were inspired by
[Mozilla's code of conduct enforcement ladder][Mozilla CoC].

For answers to common questions about this code of conduct, see the FAQ at
[https://www.contributor-covenant.org/faq][FAQ]. Translations are available at
[https://www.contributor-covenant.org/translations][translations].

Incident report processing was inspired by [Django Code of Conduct - Enforcement Manual][django].

[homepage]: https://www.contributor-covenant.org
[v2.1]: https://www.contributor-covenant.org/version/2/1/code_of_conduct.html
[Mozilla CoC]: https://github.com/mozilla/diversity
[FAQ]: https://www.contributor-covenant.org/faq
[translations]: https://www.contributor-covenant.org/translations
[discord]: https://discord.f3d.app
[django]: https://www.djangoproject.com/conduct/enforcement-manual/
