// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file Calculator.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifndef FAST_DDS_GENERATED__CALCULATOR_HPP
#define FAST_DDS_GENERATED__CALCULATOR_HPP

#include <cstdint>
#include <string>
#include <utility>
#include <fastcdr/cdr/fixed_size_string.hpp>

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(CALCULATOR_SOURCE)
#define CALCULATOR_DllAPI __declspec( dllexport )
#else
#define CALCULATOR_DllAPI __declspec( dllimport )
#endif // CALCULATOR_SOURCE
#else
#define CALCULATOR_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define CALCULATOR_DllAPI
#endif // _WIN32

/*!
 * @brief This class represents the enumeration CalculatorOperationType defined by the user in the IDL file.
 * @ingroup Calculator
 */
enum class CalculatorOperationType : int32_t
{
    ADDITION,
    SUBTRACTION,
    MULTIPLICATION,
    DIVISION
};
/*!
 * @brief This class represents the structure CalculatorRequestType defined by the user in the IDL file.
 * @ingroup Calculator
 */
class CalculatorRequestType
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CalculatorRequestType()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CalculatorRequestType()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CalculatorRequestType that will be copied.
     */
    eProsima_user_DllExport CalculatorRequestType(
            const CalculatorRequestType& x)
    {
                    m_client_id = x.m_client_id;

                    m_operation = x.m_operation;

                    m_x = x.m_x;

                    m_y = x.m_y;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CalculatorRequestType that will be copied.
     */
    eProsima_user_DllExport CalculatorRequestType(
            CalculatorRequestType&& x) noexcept
    {
        m_client_id = std::move(x.m_client_id);
        m_operation = x.m_operation;
        m_x = x.m_x;
        m_y = x.m_y;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CalculatorRequestType that will be copied.
     */
    eProsima_user_DllExport CalculatorRequestType& operator =(
            const CalculatorRequestType& x)
    {

                    m_client_id = x.m_client_id;

                    m_operation = x.m_operation;

                    m_x = x.m_x;

                    m_y = x.m_y;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CalculatorRequestType that will be copied.
     */
    eProsima_user_DllExport CalculatorRequestType& operator =(
            CalculatorRequestType&& x) noexcept
    {

        m_client_id = std::move(x.m_client_id);
        m_operation = x.m_operation;
        m_x = x.m_x;
        m_y = x.m_y;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CalculatorRequestType object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CalculatorRequestType& x) const
    {
        return (m_client_id == x.m_client_id &&
           m_operation == x.m_operation &&
           m_x == x.m_x &&
           m_y == x.m_y);
    }

    /*!
     * @brief Comparison operator.
     * @param x CalculatorRequestType object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CalculatorRequestType& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member client_id
     * @param _client_id New value to be copied in member client_id
     */
    eProsima_user_DllExport void client_id(
            const std::string& _client_id)
    {
        m_client_id = _client_id;
    }

    /*!
     * @brief This function moves the value in member client_id
     * @param _client_id New value to be moved in member client_id
     */
    eProsima_user_DllExport void client_id(
            std::string&& _client_id)
    {
        m_client_id = std::move(_client_id);
    }

    /*!
     * @brief This function returns a constant reference to member client_id
     * @return Constant reference to member client_id
     */
    eProsima_user_DllExport const std::string& client_id() const
    {
        return m_client_id;
    }

    /*!
     * @brief This function returns a reference to member client_id
     * @return Reference to member client_id
     */
    eProsima_user_DllExport std::string& client_id()
    {
        return m_client_id;
    }


    /*!
     * @brief This function sets a value in member operation
     * @param _operation New value for member operation
     */
    eProsima_user_DllExport void operation(
            CalculatorOperationType _operation)
    {
        m_operation = _operation;
    }

    /*!
     * @brief This function returns the value of member operation
     * @return Value of member operation
     */
    eProsima_user_DllExport CalculatorOperationType operation() const
    {
        return m_operation;
    }

    /*!
     * @brief This function returns a reference to member operation
     * @return Reference to member operation
     */
    eProsima_user_DllExport CalculatorOperationType& operation()
    {
        return m_operation;
    }


    /*!
     * @brief This function sets a value in member x
     * @param _x New value for member x
     */
    eProsima_user_DllExport void x(
            int16_t _x)
    {
        m_x = _x;
    }

    /*!
     * @brief This function returns the value of member x
     * @return Value of member x
     */
    eProsima_user_DllExport int16_t x() const
    {
        return m_x;
    }

    /*!
     * @brief This function returns a reference to member x
     * @return Reference to member x
     */
    eProsima_user_DllExport int16_t& x()
    {
        return m_x;
    }


    /*!
     * @brief This function sets a value in member y
     * @param _y New value for member y
     */
    eProsima_user_DllExport void y(
            int16_t _y)
    {
        m_y = _y;
    }

    /*!
     * @brief This function returns the value of member y
     * @return Value of member y
     */
    eProsima_user_DllExport int16_t y() const
    {
        return m_y;
    }

    /*!
     * @brief This function returns a reference to member y
     * @return Reference to member y
     */
    eProsima_user_DllExport int16_t& y()
    {
        return m_y;
    }



private:

    std::string m_client_id;
    CalculatorOperationType m_operation{CalculatorOperationType::ADDITION};
    int16_t m_x{0};
    int16_t m_y{0};

};
/*!
 * @brief This class represents the structure CalculatorReplyType defined by the user in the IDL file.
 * @ingroup Calculator
 */
class CalculatorReplyType
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CalculatorReplyType()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CalculatorReplyType()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CalculatorReplyType that will be copied.
     */
    eProsima_user_DllExport CalculatorReplyType(
            const CalculatorReplyType& x)
    {
                    m_client_id = x.m_client_id;

                    m_result = x.m_result;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CalculatorReplyType that will be copied.
     */
    eProsima_user_DllExport CalculatorReplyType(
            CalculatorReplyType&& x) noexcept
    {
        m_client_id = std::move(x.m_client_id);
        m_result = x.m_result;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CalculatorReplyType that will be copied.
     */
    eProsima_user_DllExport CalculatorReplyType& operator =(
            const CalculatorReplyType& x)
    {

                    m_client_id = x.m_client_id;

                    m_result = x.m_result;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CalculatorReplyType that will be copied.
     */
    eProsima_user_DllExport CalculatorReplyType& operator =(
            CalculatorReplyType&& x) noexcept
    {

        m_client_id = std::move(x.m_client_id);
        m_result = x.m_result;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CalculatorReplyType object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CalculatorReplyType& x) const
    {
        return (m_client_id == x.m_client_id &&
           m_result == x.m_result);
    }

    /*!
     * @brief Comparison operator.
     * @param x CalculatorReplyType object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CalculatorReplyType& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member client_id
     * @param _client_id New value to be copied in member client_id
     */
    eProsima_user_DllExport void client_id(
            const std::string& _client_id)
    {
        m_client_id = _client_id;
    }

    /*!
     * @brief This function moves the value in member client_id
     * @param _client_id New value to be moved in member client_id
     */
    eProsima_user_DllExport void client_id(
            std::string&& _client_id)
    {
        m_client_id = std::move(_client_id);
    }

    /*!
     * @brief This function returns a constant reference to member client_id
     * @return Constant reference to member client_id
     */
    eProsima_user_DllExport const std::string& client_id() const
    {
        return m_client_id;
    }

    /*!
     * @brief This function returns a reference to member client_id
     * @return Reference to member client_id
     */
    eProsima_user_DllExport std::string& client_id()
    {
        return m_client_id;
    }


    /*!
     * @brief This function sets a value in member result
     * @param _result New value for member result
     */
    eProsima_user_DllExport void result(
            int32_t _result)
    {
        m_result = _result;
    }

    /*!
     * @brief This function returns the value of member result
     * @return Value of member result
     */
    eProsima_user_DllExport int32_t result() const
    {
        return m_result;
    }

    /*!
     * @brief This function returns a reference to member result
     * @return Reference to member result
     */
    eProsima_user_DllExport int32_t& result()
    {
        return m_result;
    }



private:

    std::string m_client_id;
    int32_t m_result{0};

};

#endif // _FAST_DDS_GENERATED_CALCULATOR_HPP_


