// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file XtypesTestsTypeBigTypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen.
 */

#include "XtypesTestsTypeBigTypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>

#include "XtypesTestsTypeBig.hpp"

#include "XtypesTestsType1.hpp"
#include "XtypesTestsType2.hpp"
#include "XtypesTestsType3.hpp"

using namespace eprosima::fastdds::dds::xtypes;

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type4_type_identifier(
        TypeIdentifierPair& type_ids_Type4)
{

    ReturnCode_t return_code_Type4 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type4 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type4", type_ids_Type4);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type4)
    {
        StructTypeFlag struct_flags_Type4 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type4 = "Type4";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type4;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type4;
        CompleteTypeDetail detail_Type4 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type4, ann_custom_Type4, type_name_Type4.to_string());
        CompleteStructHeader header_Type4;
        header_Type4 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type4);
        CompleteStructMemberSeq member_seq_Type4;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type4.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type4);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type4, member_content);
        }
        CompleteStructType struct_type_Type4 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type4, header_Type4, member_seq_Type4);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type4, type_name_Type4.to_string(), type_ids_Type4))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type4 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type5_type_identifier(
        TypeIdentifierPair& type_ids_Type5)
{

    ReturnCode_t return_code_Type5 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type5 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type5", type_ids_Type5);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type5)
    {
        StructTypeFlag struct_flags_Type5 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type5 = "Type5";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type5;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type5;
        CompleteTypeDetail detail_Type5 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type5, ann_custom_Type5, type_name_Type5.to_string());
        CompleteStructHeader header_Type5;
        header_Type5 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type5);
        CompleteStructMemberSeq member_seq_Type5;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type5.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type5);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type5, member_content);
        }
        CompleteStructType struct_type_Type5 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type5, header_Type5, member_seq_Type5);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type5, type_name_Type5.to_string(), type_ids_Type5))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type5 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type6_type_identifier(
        TypeIdentifierPair& type_ids_Type6)
{

    ReturnCode_t return_code_Type6 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type6 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type6", type_ids_Type6);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type6)
    {
        StructTypeFlag struct_flags_Type6 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type6 = "Type6";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type6;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type6;
        CompleteTypeDetail detail_Type6 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type6, ann_custom_Type6, type_name_Type6.to_string());
        CompleteStructHeader header_Type6;
        header_Type6 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type6);
        CompleteStructMemberSeq member_seq_Type6;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type6.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type6);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type6, member_content);
        }
        CompleteStructType struct_type_Type6 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type6, header_Type6, member_seq_Type6);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type6, type_name_Type6.to_string(), type_ids_Type6))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type6 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type7_type_identifier(
        TypeIdentifierPair& type_ids_Type7)
{

    ReturnCode_t return_code_Type7 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type7 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type7", type_ids_Type7);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type7)
    {
        StructTypeFlag struct_flags_Type7 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type7 = "Type7";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type7;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type7;
        CompleteTypeDetail detail_Type7 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type7, ann_custom_Type7, type_name_Type7.to_string());
        CompleteStructHeader header_Type7;
        header_Type7 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type7);
        CompleteStructMemberSeq member_seq_Type7;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type7.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type7);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type7, member_content);
        }
        CompleteStructType struct_type_Type7 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type7, header_Type7, member_seq_Type7);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type7, type_name_Type7.to_string(), type_ids_Type7))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type7 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type8_type_identifier(
        TypeIdentifierPair& type_ids_Type8)
{

    ReturnCode_t return_code_Type8 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type8 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type8", type_ids_Type8);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type8)
    {
        StructTypeFlag struct_flags_Type8 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type8 = "Type8";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type8;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type8;
        CompleteTypeDetail detail_Type8 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type8, ann_custom_Type8, type_name_Type8.to_string());
        CompleteStructHeader header_Type8;
        header_Type8 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type8);
        CompleteStructMemberSeq member_seq_Type8;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type8.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type8);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type8, member_content);
        }
        CompleteStructType struct_type_Type8 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type8, header_Type8, member_seq_Type8);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type8, type_name_Type8.to_string(), type_ids_Type8))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type8 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type9_type_identifier(
        TypeIdentifierPair& type_ids_Type9)
{

    ReturnCode_t return_code_Type9 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type9 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type9", type_ids_Type9);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type9)
    {
        StructTypeFlag struct_flags_Type9 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type9 = "Type9";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type9;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type9;
        CompleteTypeDetail detail_Type9 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type9, ann_custom_Type9, type_name_Type9.to_string());
        CompleteStructHeader header_Type9;
        header_Type9 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type9);
        CompleteStructMemberSeq member_seq_Type9;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type9.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type9);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type9, member_content);
        }
        CompleteStructType struct_type_Type9 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type9, header_Type9, member_seq_Type9);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type9, type_name_Type9.to_string(), type_ids_Type9))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type9 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type10_type_identifier(
        TypeIdentifierPair& type_ids_Type10)
{

    ReturnCode_t return_code_Type10 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type10 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type10", type_ids_Type10);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type10)
    {
        StructTypeFlag struct_flags_Type10 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type10 = "Type10";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type10;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type10;
        CompleteTypeDetail detail_Type10 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type10, ann_custom_Type10, type_name_Type10.to_string());
        CompleteStructHeader header_Type10;
        header_Type10 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type10);
        CompleteStructMemberSeq member_seq_Type10;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type10.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type10);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type10, member_content);
        }
        CompleteStructType struct_type_Type10 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type10, header_Type10, member_seq_Type10);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type10, type_name_Type10.to_string(), type_ids_Type10))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type10 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type11_type_identifier(
        TypeIdentifierPair& type_ids_Type11)
{

    ReturnCode_t return_code_Type11 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type11 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type11", type_ids_Type11);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type11)
    {
        StructTypeFlag struct_flags_Type11 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type11 = "Type11";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type11;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type11;
        CompleteTypeDetail detail_Type11 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type11, ann_custom_Type11, type_name_Type11.to_string());
        CompleteStructHeader header_Type11;
        header_Type11 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type11);
        CompleteStructMemberSeq member_seq_Type11;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type11.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type11);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type11, member_content);
        }
        CompleteStructType struct_type_Type11 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type11, header_Type11, member_seq_Type11);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type11, type_name_Type11.to_string(), type_ids_Type11))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type11 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type12_type_identifier(
        TypeIdentifierPair& type_ids_Type12)
{

    ReturnCode_t return_code_Type12 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type12 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type12", type_ids_Type12);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type12)
    {
        StructTypeFlag struct_flags_Type12 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type12 = "Type12";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type12;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type12;
        CompleteTypeDetail detail_Type12 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type12, ann_custom_Type12, type_name_Type12.to_string());
        CompleteStructHeader header_Type12;
        header_Type12 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type12);
        CompleteStructMemberSeq member_seq_Type12;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type12.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type12);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type12, member_content);
        }
        CompleteStructType struct_type_Type12 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type12, header_Type12, member_seq_Type12);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type12, type_name_Type12.to_string(), type_ids_Type12))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type12 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type13_type_identifier(
        TypeIdentifierPair& type_ids_Type13)
{

    ReturnCode_t return_code_Type13 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type13 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type13", type_ids_Type13);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type13)
    {
        StructTypeFlag struct_flags_Type13 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type13 = "Type13";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type13;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type13;
        CompleteTypeDetail detail_Type13 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type13, ann_custom_Type13, type_name_Type13.to_string());
        CompleteStructHeader header_Type13;
        header_Type13 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type13);
        CompleteStructMemberSeq member_seq_Type13;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type13.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type13);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type13, member_content);
        }
        CompleteStructType struct_type_Type13 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type13, header_Type13, member_seq_Type13);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type13, type_name_Type13.to_string(), type_ids_Type13))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type13 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type14_type_identifier(
        TypeIdentifierPair& type_ids_Type14)
{

    ReturnCode_t return_code_Type14 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type14 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type14", type_ids_Type14);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type14)
    {
        StructTypeFlag struct_flags_Type14 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type14 = "Type14";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type14;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type14;
        CompleteTypeDetail detail_Type14 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type14, ann_custom_Type14, type_name_Type14.to_string());
        CompleteStructHeader header_Type14;
        header_Type14 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type14);
        CompleteStructMemberSeq member_seq_Type14;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type14.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type14);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type14, member_content);
        }
        CompleteStructType struct_type_Type14 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type14, header_Type14, member_seq_Type14);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type14, type_name_Type14.to_string(), type_ids_Type14))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type14 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type15_type_identifier(
        TypeIdentifierPair& type_ids_Type15)
{

    ReturnCode_t return_code_Type15 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type15 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type15", type_ids_Type15);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type15)
    {
        StructTypeFlag struct_flags_Type15 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type15 = "Type15";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type15;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type15;
        CompleteTypeDetail detail_Type15 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type15, ann_custom_Type15, type_name_Type15.to_string());
        CompleteStructHeader header_Type15;
        header_Type15 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type15);
        CompleteStructMemberSeq member_seq_Type15;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type15.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type15);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type15, member_content);
        }
        CompleteStructType struct_type_Type15 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type15, header_Type15, member_seq_Type15);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type15, type_name_Type15.to_string(), type_ids_Type15))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type15 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type16_type_identifier(
        TypeIdentifierPair& type_ids_Type16)
{

    ReturnCode_t return_code_Type16 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type16 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type16", type_ids_Type16);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type16)
    {
        StructTypeFlag struct_flags_Type16 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type16 = "Type16";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type16;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type16;
        CompleteTypeDetail detail_Type16 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type16, ann_custom_Type16, type_name_Type16.to_string());
        CompleteStructHeader header_Type16;
        header_Type16 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type16);
        CompleteStructMemberSeq member_seq_Type16;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type16.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type16);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type16, member_content);
        }
        CompleteStructType struct_type_Type16 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type16, header_Type16, member_seq_Type16);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type16, type_name_Type16.to_string(), type_ids_Type16))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type16 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type17_type_identifier(
        TypeIdentifierPair& type_ids_Type17)
{

    ReturnCode_t return_code_Type17 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type17 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type17", type_ids_Type17);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type17)
    {
        StructTypeFlag struct_flags_Type17 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type17 = "Type17";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type17;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type17;
        CompleteTypeDetail detail_Type17 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type17, ann_custom_Type17, type_name_Type17.to_string());
        CompleteStructHeader header_Type17;
        header_Type17 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type17);
        CompleteStructMemberSeq member_seq_Type17;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type17.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type17);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type17, member_content);
        }
        CompleteStructType struct_type_Type17 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type17, header_Type17, member_seq_Type17);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type17, type_name_Type17.to_string(), type_ids_Type17))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type17 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type18_type_identifier(
        TypeIdentifierPair& type_ids_Type18)
{

    ReturnCode_t return_code_Type18 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type18 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type18", type_ids_Type18);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type18)
    {
        StructTypeFlag struct_flags_Type18 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type18 = "Type18";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type18;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type18;
        CompleteTypeDetail detail_Type18 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type18, ann_custom_Type18, type_name_Type18.to_string());
        CompleteStructHeader header_Type18;
        header_Type18 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type18);
        CompleteStructMemberSeq member_seq_Type18;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type18.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type18);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type18, member_content);
        }
        CompleteStructType struct_type_Type18 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type18, header_Type18, member_seq_Type18);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type18, type_name_Type18.to_string(), type_ids_Type18))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type18 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type19_type_identifier(
        TypeIdentifierPair& type_ids_Type19)
{

    ReturnCode_t return_code_Type19 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type19 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type19", type_ids_Type19);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type19)
    {
        StructTypeFlag struct_flags_Type19 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type19 = "Type19";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type19;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type19;
        CompleteTypeDetail detail_Type19 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type19, ann_custom_Type19, type_name_Type19.to_string());
        CompleteStructHeader header_Type19;
        header_Type19 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type19);
        CompleteStructMemberSeq member_seq_Type19;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type19.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type19);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type19, member_content);
        }
        CompleteStructType struct_type_Type19 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type19, header_Type19, member_seq_Type19);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type19, type_name_Type19.to_string(), type_ids_Type19))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type19 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type20_type_identifier(
        TypeIdentifierPair& type_ids_Type20)
{

    ReturnCode_t return_code_Type20 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type20 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type20", type_ids_Type20);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type20)
    {
        StructTypeFlag struct_flags_Type20 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type20 = "Type20";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type20;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type20;
        CompleteTypeDetail detail_Type20 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type20, ann_custom_Type20, type_name_Type20.to_string());
        CompleteStructHeader header_Type20;
        header_Type20 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type20);
        CompleteStructMemberSeq member_seq_Type20;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type20.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type20);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type20, member_content);
        }
        CompleteStructType struct_type_Type20 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type20, header_Type20, member_seq_Type20);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type20, type_name_Type20.to_string(), type_ids_Type20))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type20 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type21_type_identifier(
        TypeIdentifierPair& type_ids_Type21)
{

    ReturnCode_t return_code_Type21 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type21 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type21", type_ids_Type21);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type21)
    {
        StructTypeFlag struct_flags_Type21 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type21 = "Type21";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type21;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type21;
        CompleteTypeDetail detail_Type21 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type21, ann_custom_Type21, type_name_Type21.to_string());
        CompleteStructHeader header_Type21;
        header_Type21 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type21);
        CompleteStructMemberSeq member_seq_Type21;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type21.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type21);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type21, member_content);
        }
        CompleteStructType struct_type_Type21 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type21, header_Type21, member_seq_Type21);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type21, type_name_Type21.to_string(), type_ids_Type21))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type21 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type22_type_identifier(
        TypeIdentifierPair& type_ids_Type22)
{

    ReturnCode_t return_code_Type22 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type22 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type22", type_ids_Type22);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type22)
    {
        StructTypeFlag struct_flags_Type22 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type22 = "Type22";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type22;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type22;
        CompleteTypeDetail detail_Type22 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type22, ann_custom_Type22, type_name_Type22.to_string());
        CompleteStructHeader header_Type22;
        header_Type22 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type22);
        CompleteStructMemberSeq member_seq_Type22;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type22.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type22);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type22, member_content);
        }
        CompleteStructType struct_type_Type22 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type22, header_Type22, member_seq_Type22);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type22, type_name_Type22.to_string(), type_ids_Type22))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type22 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type23_type_identifier(
        TypeIdentifierPair& type_ids_Type23)
{

    ReturnCode_t return_code_Type23 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type23 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type23", type_ids_Type23);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type23)
    {
        StructTypeFlag struct_flags_Type23 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type23 = "Type23";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type23;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type23;
        CompleteTypeDetail detail_Type23 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type23, ann_custom_Type23, type_name_Type23.to_string());
        CompleteStructHeader header_Type23;
        header_Type23 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type23);
        CompleteStructMemberSeq member_seq_Type23;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type23.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type23);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type23, member_content);
        }
        CompleteStructType struct_type_Type23 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type23, header_Type23, member_seq_Type23);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type23, type_name_Type23.to_string(), type_ids_Type23))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type23 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type24_type_identifier(
        TypeIdentifierPair& type_ids_Type24)
{

    ReturnCode_t return_code_Type24 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type24 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type24", type_ids_Type24);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type24)
    {
        StructTypeFlag struct_flags_Type24 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type24 = "Type24";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type24;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type24;
        CompleteTypeDetail detail_Type24 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type24, ann_custom_Type24, type_name_Type24.to_string());
        CompleteStructHeader header_Type24;
        header_Type24 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type24);
        CompleteStructMemberSeq member_seq_Type24;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type24.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type24);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type24, member_content);
        }
        CompleteStructType struct_type_Type24 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type24, header_Type24, member_seq_Type24);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type24, type_name_Type24.to_string(), type_ids_Type24))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type24 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type25_type_identifier(
        TypeIdentifierPair& type_ids_Type25)
{

    ReturnCode_t return_code_Type25 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type25 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type25", type_ids_Type25);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type25)
    {
        StructTypeFlag struct_flags_Type25 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type25 = "Type25";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type25;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type25;
        CompleteTypeDetail detail_Type25 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type25, ann_custom_Type25, type_name_Type25.to_string());
        CompleteStructHeader header_Type25;
        header_Type25 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type25);
        CompleteStructMemberSeq member_seq_Type25;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type25.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type25);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type25, member_content);
        }
        CompleteStructType struct_type_Type25 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type25, header_Type25, member_seq_Type25);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type25, type_name_Type25.to_string(), type_ids_Type25))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type25 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type26_type_identifier(
        TypeIdentifierPair& type_ids_Type26)
{

    ReturnCode_t return_code_Type26 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type26 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type26", type_ids_Type26);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type26)
    {
        StructTypeFlag struct_flags_Type26 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type26 = "Type26";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type26;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type26;
        CompleteTypeDetail detail_Type26 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type26, ann_custom_Type26, type_name_Type26.to_string());
        CompleteStructHeader header_Type26;
        header_Type26 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type26);
        CompleteStructMemberSeq member_seq_Type26;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type26.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type26);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type26, member_content);
        }
        CompleteStructType struct_type_Type26 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type26, header_Type26, member_seq_Type26);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type26, type_name_Type26.to_string(), type_ids_Type26))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type26 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type27_type_identifier(
        TypeIdentifierPair& type_ids_Type27)
{

    ReturnCode_t return_code_Type27 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type27 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type27", type_ids_Type27);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type27)
    {
        StructTypeFlag struct_flags_Type27 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type27 = "Type27";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type27;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type27;
        CompleteTypeDetail detail_Type27 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type27, ann_custom_Type27, type_name_Type27.to_string());
        CompleteStructHeader header_Type27;
        header_Type27 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type27);
        CompleteStructMemberSeq member_seq_Type27;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type27.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type27);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type27, member_content);
        }
        CompleteStructType struct_type_Type27 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type27, header_Type27, member_seq_Type27);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type27, type_name_Type27.to_string(), type_ids_Type27))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type27 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type28_type_identifier(
        TypeIdentifierPair& type_ids_Type28)
{

    ReturnCode_t return_code_Type28 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type28 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type28", type_ids_Type28);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type28)
    {
        StructTypeFlag struct_flags_Type28 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type28 = "Type28";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type28;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type28;
        CompleteTypeDetail detail_Type28 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type28, ann_custom_Type28, type_name_Type28.to_string());
        CompleteStructHeader header_Type28;
        header_Type28 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type28);
        CompleteStructMemberSeq member_seq_Type28;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type28.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type28);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type28, member_content);
        }
        CompleteStructType struct_type_Type28 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type28, header_Type28, member_seq_Type28);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type28, type_name_Type28.to_string(), type_ids_Type28))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type28 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type29_type_identifier(
        TypeIdentifierPair& type_ids_Type29)
{

    ReturnCode_t return_code_Type29 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type29 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type29", type_ids_Type29);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type29)
    {
        StructTypeFlag struct_flags_Type29 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type29 = "Type29";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type29;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type29;
        CompleteTypeDetail detail_Type29 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type29, ann_custom_Type29, type_name_Type29.to_string());
        CompleteStructHeader header_Type29;
        header_Type29 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type29);
        CompleteStructMemberSeq member_seq_Type29;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type29.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type29);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type29, member_content);
        }
        CompleteStructType struct_type_Type29 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type29, header_Type29, member_seq_Type29);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type29, type_name_Type29.to_string(), type_ids_Type29))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type29 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type30_type_identifier(
        TypeIdentifierPair& type_ids_Type30)
{

    ReturnCode_t return_code_Type30 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type30 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type30", type_ids_Type30);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type30)
    {
        StructTypeFlag struct_flags_Type30 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type30 = "Type30";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type30;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type30;
        CompleteTypeDetail detail_Type30 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type30, ann_custom_Type30, type_name_Type30.to_string());
        CompleteStructHeader header_Type30;
        header_Type30 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type30);
        CompleteStructMemberSeq member_seq_Type30;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type30.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type30);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type30, member_content);
        }
        CompleteStructType struct_type_Type30 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type30, header_Type30, member_seq_Type30);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type30, type_name_Type30.to_string(), type_ids_Type30))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type30 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type31_type_identifier(
        TypeIdentifierPair& type_ids_Type31)
{

    ReturnCode_t return_code_Type31 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type31 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type31", type_ids_Type31);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type31)
    {
        StructTypeFlag struct_flags_Type31 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type31 = "Type31";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type31;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type31;
        CompleteTypeDetail detail_Type31 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type31, ann_custom_Type31, type_name_Type31.to_string());
        CompleteStructHeader header_Type31;
        header_Type31 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type31);
        CompleteStructMemberSeq member_seq_Type31;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type31.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type31);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type31, member_content);
        }
        CompleteStructType struct_type_Type31 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type31, header_Type31, member_seq_Type31);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type31, type_name_Type31.to_string(), type_ids_Type31))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type31 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type32_type_identifier(
        TypeIdentifierPair& type_ids_Type32)
{

    ReturnCode_t return_code_Type32 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type32 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type32", type_ids_Type32);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type32)
    {
        StructTypeFlag struct_flags_Type32 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type32 = "Type32";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type32;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type32;
        CompleteTypeDetail detail_Type32 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type32, ann_custom_Type32, type_name_Type32.to_string());
        CompleteStructHeader header_Type32;
        header_Type32 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type32);
        CompleteStructMemberSeq member_seq_Type32;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type32.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type32);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type32, member_content);
        }
        CompleteStructType struct_type_Type32 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type32, header_Type32, member_seq_Type32);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type32, type_name_Type32.to_string(), type_ids_Type32))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type32 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type33_type_identifier(
        TypeIdentifierPair& type_ids_Type33)
{

    ReturnCode_t return_code_Type33 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type33 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type33", type_ids_Type33);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type33)
    {
        StructTypeFlag struct_flags_Type33 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type33 = "Type33";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type33;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type33;
        CompleteTypeDetail detail_Type33 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type33, ann_custom_Type33, type_name_Type33.to_string());
        CompleteStructHeader header_Type33;
        header_Type33 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type33);
        CompleteStructMemberSeq member_seq_Type33;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type33.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type33);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type33, member_content);
        }
        CompleteStructType struct_type_Type33 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type33, header_Type33, member_seq_Type33);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type33, type_name_Type33.to_string(), type_ids_Type33))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type33 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type34_type_identifier(
        TypeIdentifierPair& type_ids_Type34)
{

    ReturnCode_t return_code_Type34 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type34 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type34", type_ids_Type34);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type34)
    {
        StructTypeFlag struct_flags_Type34 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type34 = "Type34";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type34;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type34;
        CompleteTypeDetail detail_Type34 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type34, ann_custom_Type34, type_name_Type34.to_string());
        CompleteStructHeader header_Type34;
        header_Type34 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type34);
        CompleteStructMemberSeq member_seq_Type34;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type34.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type34);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type34, member_content);
        }
        CompleteStructType struct_type_Type34 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type34, header_Type34, member_seq_Type34);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type34, type_name_Type34.to_string(), type_ids_Type34))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type34 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type35_type_identifier(
        TypeIdentifierPair& type_ids_Type35)
{

    ReturnCode_t return_code_Type35 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type35 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type35", type_ids_Type35);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type35)
    {
        StructTypeFlag struct_flags_Type35 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type35 = "Type35";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type35;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type35;
        CompleteTypeDetail detail_Type35 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type35, ann_custom_Type35, type_name_Type35.to_string());
        CompleteStructHeader header_Type35;
        header_Type35 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type35);
        CompleteStructMemberSeq member_seq_Type35;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type35.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type35);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type35, member_content);
        }
        CompleteStructType struct_type_Type35 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type35, header_Type35, member_seq_Type35);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type35, type_name_Type35.to_string(), type_ids_Type35))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type35 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type36_type_identifier(
        TypeIdentifierPair& type_ids_Type36)
{

    ReturnCode_t return_code_Type36 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type36 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type36", type_ids_Type36);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type36)
    {
        StructTypeFlag struct_flags_Type36 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type36 = "Type36";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type36;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type36;
        CompleteTypeDetail detail_Type36 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type36, ann_custom_Type36, type_name_Type36.to_string());
        CompleteStructHeader header_Type36;
        header_Type36 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type36);
        CompleteStructMemberSeq member_seq_Type36;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type36.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type36);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type36, member_content);
        }
        CompleteStructType struct_type_Type36 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type36, header_Type36, member_seq_Type36);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type36, type_name_Type36.to_string(), type_ids_Type36))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type36 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type37_type_identifier(
        TypeIdentifierPair& type_ids_Type37)
{

    ReturnCode_t return_code_Type37 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type37 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type37", type_ids_Type37);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type37)
    {
        StructTypeFlag struct_flags_Type37 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type37 = "Type37";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type37;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type37;
        CompleteTypeDetail detail_Type37 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type37, ann_custom_Type37, type_name_Type37.to_string());
        CompleteStructHeader header_Type37;
        header_Type37 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type37);
        CompleteStructMemberSeq member_seq_Type37;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type37.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type37);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type37, member_content);
        }
        CompleteStructType struct_type_Type37 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type37, header_Type37, member_seq_Type37);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type37, type_name_Type37.to_string(), type_ids_Type37))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type37 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type38_type_identifier(
        TypeIdentifierPair& type_ids_Type38)
{

    ReturnCode_t return_code_Type38 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type38 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type38", type_ids_Type38);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type38)
    {
        StructTypeFlag struct_flags_Type38 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type38 = "Type38";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type38;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type38;
        CompleteTypeDetail detail_Type38 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type38, ann_custom_Type38, type_name_Type38.to_string());
        CompleteStructHeader header_Type38;
        header_Type38 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type38);
        CompleteStructMemberSeq member_seq_Type38;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type38.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type38);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type38, member_content);
        }
        CompleteStructType struct_type_Type38 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type38, header_Type38, member_seq_Type38);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type38, type_name_Type38.to_string(), type_ids_Type38))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type38 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type39_type_identifier(
        TypeIdentifierPair& type_ids_Type39)
{

    ReturnCode_t return_code_Type39 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type39 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type39", type_ids_Type39);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type39)
    {
        StructTypeFlag struct_flags_Type39 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type39 = "Type39";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type39;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type39;
        CompleteTypeDetail detail_Type39 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type39, ann_custom_Type39, type_name_Type39.to_string());
        CompleteStructHeader header_Type39;
        header_Type39 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type39);
        CompleteStructMemberSeq member_seq_Type39;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type39.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type39);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type39, member_content);
        }
        CompleteStructType struct_type_Type39 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type39, header_Type39, member_seq_Type39);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type39, type_name_Type39.to_string(), type_ids_Type39))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type39 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type40_type_identifier(
        TypeIdentifierPair& type_ids_Type40)
{

    ReturnCode_t return_code_Type40 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type40 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type40", type_ids_Type40);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type40)
    {
        StructTypeFlag struct_flags_Type40 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type40 = "Type40";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type40;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type40;
        CompleteTypeDetail detail_Type40 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type40, ann_custom_Type40, type_name_Type40.to_string());
        CompleteStructHeader header_Type40;
        header_Type40 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type40);
        CompleteStructMemberSeq member_seq_Type40;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type40.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type40);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type40, member_content);
        }
        CompleteStructType struct_type_Type40 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type40, header_Type40, member_seq_Type40);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type40, type_name_Type40.to_string(), type_ids_Type40))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type40 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type41_type_identifier(
        TypeIdentifierPair& type_ids_Type41)
{

    ReturnCode_t return_code_Type41 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type41 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type41", type_ids_Type41);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type41)
    {
        StructTypeFlag struct_flags_Type41 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type41 = "Type41";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type41;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type41;
        CompleteTypeDetail detail_Type41 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type41, ann_custom_Type41, type_name_Type41.to_string());
        CompleteStructHeader header_Type41;
        header_Type41 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type41);
        CompleteStructMemberSeq member_seq_Type41;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type41.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type41);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type41, member_content);
        }
        CompleteStructType struct_type_Type41 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type41, header_Type41, member_seq_Type41);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type41, type_name_Type41.to_string(), type_ids_Type41))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type41 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type42_type_identifier(
        TypeIdentifierPair& type_ids_Type42)
{

    ReturnCode_t return_code_Type42 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type42 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type42", type_ids_Type42);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type42)
    {
        StructTypeFlag struct_flags_Type42 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type42 = "Type42";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type42;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type42;
        CompleteTypeDetail detail_Type42 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type42, ann_custom_Type42, type_name_Type42.to_string());
        CompleteStructHeader header_Type42;
        header_Type42 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type42);
        CompleteStructMemberSeq member_seq_Type42;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type42.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type42);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type42, member_content);
        }
        CompleteStructType struct_type_Type42 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type42, header_Type42, member_seq_Type42);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type42, type_name_Type42.to_string(), type_ids_Type42))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type42 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type43_type_identifier(
        TypeIdentifierPair& type_ids_Type43)
{

    ReturnCode_t return_code_Type43 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type43 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type43", type_ids_Type43);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type43)
    {
        StructTypeFlag struct_flags_Type43 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type43 = "Type43";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type43;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type43;
        CompleteTypeDetail detail_Type43 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type43, ann_custom_Type43, type_name_Type43.to_string());
        CompleteStructHeader header_Type43;
        header_Type43 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type43);
        CompleteStructMemberSeq member_seq_Type43;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type43.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type43);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type43, member_content);
        }
        CompleteStructType struct_type_Type43 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type43, header_Type43, member_seq_Type43);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type43, type_name_Type43.to_string(), type_ids_Type43))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type43 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type44_type_identifier(
        TypeIdentifierPair& type_ids_Type44)
{

    ReturnCode_t return_code_Type44 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type44 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type44", type_ids_Type44);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type44)
    {
        StructTypeFlag struct_flags_Type44 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type44 = "Type44";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type44;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type44;
        CompleteTypeDetail detail_Type44 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type44, ann_custom_Type44, type_name_Type44.to_string());
        CompleteStructHeader header_Type44;
        header_Type44 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type44);
        CompleteStructMemberSeq member_seq_Type44;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type44.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type44);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type44, member_content);
        }
        CompleteStructType struct_type_Type44 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type44, header_Type44, member_seq_Type44);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type44, type_name_Type44.to_string(), type_ids_Type44))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type44 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type45_type_identifier(
        TypeIdentifierPair& type_ids_Type45)
{

    ReturnCode_t return_code_Type45 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type45 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type45", type_ids_Type45);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type45)
    {
        StructTypeFlag struct_flags_Type45 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type45 = "Type45";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type45;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type45;
        CompleteTypeDetail detail_Type45 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type45, ann_custom_Type45, type_name_Type45.to_string());
        CompleteStructHeader header_Type45;
        header_Type45 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type45);
        CompleteStructMemberSeq member_seq_Type45;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type45.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type45);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type45, member_content);
        }
        CompleteStructType struct_type_Type45 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type45, header_Type45, member_seq_Type45);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type45, type_name_Type45.to_string(), type_ids_Type45))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type45 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type46_type_identifier(
        TypeIdentifierPair& type_ids_Type46)
{

    ReturnCode_t return_code_Type46 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type46 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type46", type_ids_Type46);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type46)
    {
        StructTypeFlag struct_flags_Type46 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type46 = "Type46";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type46;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type46;
        CompleteTypeDetail detail_Type46 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type46, ann_custom_Type46, type_name_Type46.to_string());
        CompleteStructHeader header_Type46;
        header_Type46 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type46);
        CompleteStructMemberSeq member_seq_Type46;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type46.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type46);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type46, member_content);
        }
        CompleteStructType struct_type_Type46 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type46, header_Type46, member_seq_Type46);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type46, type_name_Type46.to_string(), type_ids_Type46))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type46 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type47_type_identifier(
        TypeIdentifierPair& type_ids_Type47)
{

    ReturnCode_t return_code_Type47 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type47 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type47", type_ids_Type47);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type47)
    {
        StructTypeFlag struct_flags_Type47 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type47 = "Type47";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type47;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type47;
        CompleteTypeDetail detail_Type47 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type47, ann_custom_Type47, type_name_Type47.to_string());
        CompleteStructHeader header_Type47;
        header_Type47 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type47);
        CompleteStructMemberSeq member_seq_Type47;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type47.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type47);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type47, member_content);
        }
        CompleteStructType struct_type_Type47 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type47, header_Type47, member_seq_Type47);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type47, type_name_Type47.to_string(), type_ids_Type47))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type47 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type48_type_identifier(
        TypeIdentifierPair& type_ids_Type48)
{

    ReturnCode_t return_code_Type48 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type48 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type48", type_ids_Type48);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type48)
    {
        StructTypeFlag struct_flags_Type48 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type48 = "Type48";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type48;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type48;
        CompleteTypeDetail detail_Type48 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type48, ann_custom_Type48, type_name_Type48.to_string());
        CompleteStructHeader header_Type48;
        header_Type48 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type48);
        CompleteStructMemberSeq member_seq_Type48;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type48.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type48);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type48, member_content);
        }
        CompleteStructType struct_type_Type48 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type48, header_Type48, member_seq_Type48);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type48, type_name_Type48.to_string(), type_ids_Type48))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type48 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type49_type_identifier(
        TypeIdentifierPair& type_ids_Type49)
{

    ReturnCode_t return_code_Type49 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type49 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type49", type_ids_Type49);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type49)
    {
        StructTypeFlag struct_flags_Type49 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type49 = "Type49";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type49;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type49;
        CompleteTypeDetail detail_Type49 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type49, ann_custom_Type49, type_name_Type49.to_string());
        CompleteStructHeader header_Type49;
        header_Type49 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type49);
        CompleteStructMemberSeq member_seq_Type49;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type49.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type49);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type49, member_content);
        }
        CompleteStructType struct_type_Type49 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type49, header_Type49, member_seq_Type49);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type49, type_name_Type49.to_string(), type_ids_Type49))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type49 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type50_type_identifier(
        TypeIdentifierPair& type_ids_Type50)
{

    ReturnCode_t return_code_Type50 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type50 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type50", type_ids_Type50);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type50)
    {
        StructTypeFlag struct_flags_Type50 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type50 = "Type50";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type50;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type50;
        CompleteTypeDetail detail_Type50 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type50, ann_custom_Type50, type_name_Type50.to_string());
        CompleteStructHeader header_Type50;
        header_Type50 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type50);
        CompleteStructMemberSeq member_seq_Type50;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type50.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type50);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type50, member_content);
        }
        CompleteStructType struct_type_Type50 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type50, header_Type50, member_seq_Type50);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type50, type_name_Type50.to_string(), type_ids_Type50))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type50 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type51_type_identifier(
        TypeIdentifierPair& type_ids_Type51)
{

    ReturnCode_t return_code_Type51 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type51 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type51", type_ids_Type51);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type51)
    {
        StructTypeFlag struct_flags_Type51 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type51 = "Type51";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type51;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type51;
        CompleteTypeDetail detail_Type51 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type51, ann_custom_Type51, type_name_Type51.to_string());
        CompleteStructHeader header_Type51;
        header_Type51 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type51);
        CompleteStructMemberSeq member_seq_Type51;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type51.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type51);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type51, member_content);
        }
        CompleteStructType struct_type_Type51 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type51, header_Type51, member_seq_Type51);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type51, type_name_Type51.to_string(), type_ids_Type51))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type51 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type52_type_identifier(
        TypeIdentifierPair& type_ids_Type52)
{

    ReturnCode_t return_code_Type52 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type52 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type52", type_ids_Type52);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type52)
    {
        StructTypeFlag struct_flags_Type52 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type52 = "Type52";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type52;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type52;
        CompleteTypeDetail detail_Type52 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type52, ann_custom_Type52, type_name_Type52.to_string());
        CompleteStructHeader header_Type52;
        header_Type52 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type52);
        CompleteStructMemberSeq member_seq_Type52;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type52.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type52);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type52, member_content);
        }
        CompleteStructType struct_type_Type52 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type52, header_Type52, member_seq_Type52);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type52, type_name_Type52.to_string(), type_ids_Type52))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type52 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type53_type_identifier(
        TypeIdentifierPair& type_ids_Type53)
{

    ReturnCode_t return_code_Type53 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type53 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type53", type_ids_Type53);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type53)
    {
        StructTypeFlag struct_flags_Type53 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type53 = "Type53";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type53;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type53;
        CompleteTypeDetail detail_Type53 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type53, ann_custom_Type53, type_name_Type53.to_string());
        CompleteStructHeader header_Type53;
        header_Type53 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type53);
        CompleteStructMemberSeq member_seq_Type53;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type53.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type53);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type53, member_content);
        }
        CompleteStructType struct_type_Type53 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type53, header_Type53, member_seq_Type53);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type53, type_name_Type53.to_string(), type_ids_Type53))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type53 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type54_type_identifier(
        TypeIdentifierPair& type_ids_Type54)
{

    ReturnCode_t return_code_Type54 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type54 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type54", type_ids_Type54);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type54)
    {
        StructTypeFlag struct_flags_Type54 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type54 = "Type54";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type54;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type54;
        CompleteTypeDetail detail_Type54 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type54, ann_custom_Type54, type_name_Type54.to_string());
        CompleteStructHeader header_Type54;
        header_Type54 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type54);
        CompleteStructMemberSeq member_seq_Type54;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type54.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type54);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type54, member_content);
        }
        CompleteStructType struct_type_Type54 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type54, header_Type54, member_seq_Type54);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type54, type_name_Type54.to_string(), type_ids_Type54))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type54 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type55_type_identifier(
        TypeIdentifierPair& type_ids_Type55)
{

    ReturnCode_t return_code_Type55 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type55 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type55", type_ids_Type55);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type55)
    {
        StructTypeFlag struct_flags_Type55 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type55 = "Type55";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type55;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type55;
        CompleteTypeDetail detail_Type55 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type55, ann_custom_Type55, type_name_Type55.to_string());
        CompleteStructHeader header_Type55;
        header_Type55 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type55);
        CompleteStructMemberSeq member_seq_Type55;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type55.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type55);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type55, member_content);
        }
        CompleteStructType struct_type_Type55 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type55, header_Type55, member_seq_Type55);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type55, type_name_Type55.to_string(), type_ids_Type55))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type55 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type56_type_identifier(
        TypeIdentifierPair& type_ids_Type56)
{

    ReturnCode_t return_code_Type56 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type56 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type56", type_ids_Type56);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type56)
    {
        StructTypeFlag struct_flags_Type56 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type56 = "Type56";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type56;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type56;
        CompleteTypeDetail detail_Type56 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type56, ann_custom_Type56, type_name_Type56.to_string());
        CompleteStructHeader header_Type56;
        header_Type56 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type56);
        CompleteStructMemberSeq member_seq_Type56;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type56.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type56);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type56, member_content);
        }
        CompleteStructType struct_type_Type56 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type56, header_Type56, member_seq_Type56);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type56, type_name_Type56.to_string(), type_ids_Type56))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type56 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type57_type_identifier(
        TypeIdentifierPair& type_ids_Type57)
{

    ReturnCode_t return_code_Type57 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type57 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type57", type_ids_Type57);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type57)
    {
        StructTypeFlag struct_flags_Type57 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type57 = "Type57";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type57;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type57;
        CompleteTypeDetail detail_Type57 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type57, ann_custom_Type57, type_name_Type57.to_string());
        CompleteStructHeader header_Type57;
        header_Type57 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type57);
        CompleteStructMemberSeq member_seq_Type57;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type57.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type57);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type57, member_content);
        }
        CompleteStructType struct_type_Type57 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type57, header_Type57, member_seq_Type57);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type57, type_name_Type57.to_string(), type_ids_Type57))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type57 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type58_type_identifier(
        TypeIdentifierPair& type_ids_Type58)
{

    ReturnCode_t return_code_Type58 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type58 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type58", type_ids_Type58);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type58)
    {
        StructTypeFlag struct_flags_Type58 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type58 = "Type58";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type58;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type58;
        CompleteTypeDetail detail_Type58 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type58, ann_custom_Type58, type_name_Type58.to_string());
        CompleteStructHeader header_Type58;
        header_Type58 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type58);
        CompleteStructMemberSeq member_seq_Type58;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type58.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type58);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type58, member_content);
        }
        CompleteStructType struct_type_Type58 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type58, header_Type58, member_seq_Type58);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type58, type_name_Type58.to_string(), type_ids_Type58))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type58 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type59_type_identifier(
        TypeIdentifierPair& type_ids_Type59)
{

    ReturnCode_t return_code_Type59 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type59 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type59", type_ids_Type59);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type59)
    {
        StructTypeFlag struct_flags_Type59 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type59 = "Type59";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type59;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type59;
        CompleteTypeDetail detail_Type59 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type59, ann_custom_Type59, type_name_Type59.to_string());
        CompleteStructHeader header_Type59;
        header_Type59 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type59);
        CompleteStructMemberSeq member_seq_Type59;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type59.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type59);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type59, member_content);
        }
        CompleteStructType struct_type_Type59 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type59, header_Type59, member_seq_Type59);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type59, type_name_Type59.to_string(), type_ids_Type59))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type59 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type60_type_identifier(
        TypeIdentifierPair& type_ids_Type60)
{

    ReturnCode_t return_code_Type60 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type60 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type60", type_ids_Type60);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type60)
    {
        StructTypeFlag struct_flags_Type60 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type60 = "Type60";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type60;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type60;
        CompleteTypeDetail detail_Type60 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type60, ann_custom_Type60, type_name_Type60.to_string());
        CompleteStructHeader header_Type60;
        header_Type60 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type60);
        CompleteStructMemberSeq member_seq_Type60;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type60.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type60);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type60, member_content);
        }
        CompleteStructType struct_type_Type60 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type60, header_Type60, member_seq_Type60);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type60, type_name_Type60.to_string(), type_ids_Type60))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type60 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type61_type_identifier(
        TypeIdentifierPair& type_ids_Type61)
{

    ReturnCode_t return_code_Type61 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type61 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type61", type_ids_Type61);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type61)
    {
        StructTypeFlag struct_flags_Type61 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type61 = "Type61";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type61;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type61;
        CompleteTypeDetail detail_Type61 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type61, ann_custom_Type61, type_name_Type61.to_string());
        CompleteStructHeader header_Type61;
        header_Type61 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type61);
        CompleteStructMemberSeq member_seq_Type61;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type61.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type61);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type61, member_content);
        }
        CompleteStructType struct_type_Type61 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type61, header_Type61, member_seq_Type61);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type61, type_name_Type61.to_string(), type_ids_Type61))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type61 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type62_type_identifier(
        TypeIdentifierPair& type_ids_Type62)
{

    ReturnCode_t return_code_Type62 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type62 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type62", type_ids_Type62);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type62)
    {
        StructTypeFlag struct_flags_Type62 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type62 = "Type62";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type62;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type62;
        CompleteTypeDetail detail_Type62 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type62, ann_custom_Type62, type_name_Type62.to_string());
        CompleteStructHeader header_Type62;
        header_Type62 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type62);
        CompleteStructMemberSeq member_seq_Type62;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type62.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type62);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type62, member_content);
        }
        CompleteStructType struct_type_Type62 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type62, header_Type62, member_seq_Type62);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type62, type_name_Type62.to_string(), type_ids_Type62))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type62 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type63_type_identifier(
        TypeIdentifierPair& type_ids_Type63)
{

    ReturnCode_t return_code_Type63 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type63 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type63", type_ids_Type63);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type63)
    {
        StructTypeFlag struct_flags_Type63 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type63 = "Type63";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type63;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type63;
        CompleteTypeDetail detail_Type63 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type63, ann_custom_Type63, type_name_Type63.to_string());
        CompleteStructHeader header_Type63;
        header_Type63 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type63);
        CompleteStructMemberSeq member_seq_Type63;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type63.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type63);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type63, member_content);
        }
        CompleteStructType struct_type_Type63 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type63, header_Type63, member_seq_Type63);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type63, type_name_Type63.to_string(), type_ids_Type63))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type63 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type64_type_identifier(
        TypeIdentifierPair& type_ids_Type64)
{

    ReturnCode_t return_code_Type64 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type64 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type64", type_ids_Type64);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type64)
    {
        StructTypeFlag struct_flags_Type64 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type64 = "Type64";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type64;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type64;
        CompleteTypeDetail detail_Type64 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type64, ann_custom_Type64, type_name_Type64.to_string());
        CompleteStructHeader header_Type64;
        header_Type64 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type64);
        CompleteStructMemberSeq member_seq_Type64;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type64.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type64);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type64, member_content);
        }
        CompleteStructType struct_type_Type64 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type64, header_Type64, member_seq_Type64);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type64, type_name_Type64.to_string(), type_ids_Type64))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type64 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type65_type_identifier(
        TypeIdentifierPair& type_ids_Type65)
{

    ReturnCode_t return_code_Type65 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type65 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type65", type_ids_Type65);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type65)
    {
        StructTypeFlag struct_flags_Type65 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type65 = "Type65";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type65;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type65;
        CompleteTypeDetail detail_Type65 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type65, ann_custom_Type65, type_name_Type65.to_string());
        CompleteStructHeader header_Type65;
        header_Type65 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type65);
        CompleteStructMemberSeq member_seq_Type65;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type65.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type65);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type65, member_content);
        }
        CompleteStructType struct_type_Type65 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type65, header_Type65, member_seq_Type65);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type65, type_name_Type65.to_string(), type_ids_Type65))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type65 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type66_type_identifier(
        TypeIdentifierPair& type_ids_Type66)
{

    ReturnCode_t return_code_Type66 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type66 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type66", type_ids_Type66);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type66)
    {
        StructTypeFlag struct_flags_Type66 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type66 = "Type66";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type66;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type66;
        CompleteTypeDetail detail_Type66 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type66, ann_custom_Type66, type_name_Type66.to_string());
        CompleteStructHeader header_Type66;
        header_Type66 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type66);
        CompleteStructMemberSeq member_seq_Type66;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type66.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type66);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type66, member_content);
        }
        CompleteStructType struct_type_Type66 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type66, header_Type66, member_seq_Type66);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type66, type_name_Type66.to_string(), type_ids_Type66))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type66 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type67_type_identifier(
        TypeIdentifierPair& type_ids_Type67)
{

    ReturnCode_t return_code_Type67 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type67 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type67", type_ids_Type67);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type67)
    {
        StructTypeFlag struct_flags_Type67 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type67 = "Type67";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type67;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type67;
        CompleteTypeDetail detail_Type67 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type67, ann_custom_Type67, type_name_Type67.to_string());
        CompleteStructHeader header_Type67;
        header_Type67 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type67);
        CompleteStructMemberSeq member_seq_Type67;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type67.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type67);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type67, member_content);
        }
        CompleteStructType struct_type_Type67 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type67, header_Type67, member_seq_Type67);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type67, type_name_Type67.to_string(), type_ids_Type67))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type67 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type68_type_identifier(
        TypeIdentifierPair& type_ids_Type68)
{

    ReturnCode_t return_code_Type68 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type68 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type68", type_ids_Type68);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type68)
    {
        StructTypeFlag struct_flags_Type68 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type68 = "Type68";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type68;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type68;
        CompleteTypeDetail detail_Type68 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type68, ann_custom_Type68, type_name_Type68.to_string());
        CompleteStructHeader header_Type68;
        header_Type68 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type68);
        CompleteStructMemberSeq member_seq_Type68;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type68.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type68);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type68, member_content);
        }
        CompleteStructType struct_type_Type68 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type68, header_Type68, member_seq_Type68);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type68, type_name_Type68.to_string(), type_ids_Type68))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type68 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type69_type_identifier(
        TypeIdentifierPair& type_ids_Type69)
{

    ReturnCode_t return_code_Type69 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type69 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type69", type_ids_Type69);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type69)
    {
        StructTypeFlag struct_flags_Type69 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type69 = "Type69";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type69;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type69;
        CompleteTypeDetail detail_Type69 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type69, ann_custom_Type69, type_name_Type69.to_string());
        CompleteStructHeader header_Type69;
        header_Type69 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type69);
        CompleteStructMemberSeq member_seq_Type69;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type69.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type69);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type69, member_content);
        }
        CompleteStructType struct_type_Type69 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type69, header_Type69, member_seq_Type69);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type69, type_name_Type69.to_string(), type_ids_Type69))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type69 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type70_type_identifier(
        TypeIdentifierPair& type_ids_Type70)
{

    ReturnCode_t return_code_Type70 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type70 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type70", type_ids_Type70);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type70)
    {
        StructTypeFlag struct_flags_Type70 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type70 = "Type70";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type70;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type70;
        CompleteTypeDetail detail_Type70 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type70, ann_custom_Type70, type_name_Type70.to_string());
        CompleteStructHeader header_Type70;
        header_Type70 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type70);
        CompleteStructMemberSeq member_seq_Type70;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type70.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type70);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type70, member_content);
        }
        CompleteStructType struct_type_Type70 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type70, header_Type70, member_seq_Type70);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type70, type_name_Type70.to_string(), type_ids_Type70))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type70 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type71_type_identifier(
        TypeIdentifierPair& type_ids_Type71)
{

    ReturnCode_t return_code_Type71 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type71 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type71", type_ids_Type71);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type71)
    {
        StructTypeFlag struct_flags_Type71 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type71 = "Type71";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type71;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type71;
        CompleteTypeDetail detail_Type71 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type71, ann_custom_Type71, type_name_Type71.to_string());
        CompleteStructHeader header_Type71;
        header_Type71 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type71);
        CompleteStructMemberSeq member_seq_Type71;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type71.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type71);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type71, member_content);
        }
        CompleteStructType struct_type_Type71 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type71, header_Type71, member_seq_Type71);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type71, type_name_Type71.to_string(), type_ids_Type71))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type71 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type72_type_identifier(
        TypeIdentifierPair& type_ids_Type72)
{

    ReturnCode_t return_code_Type72 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type72 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type72", type_ids_Type72);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type72)
    {
        StructTypeFlag struct_flags_Type72 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type72 = "Type72";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type72;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type72;
        CompleteTypeDetail detail_Type72 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type72, ann_custom_Type72, type_name_Type72.to_string());
        CompleteStructHeader header_Type72;
        header_Type72 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type72);
        CompleteStructMemberSeq member_seq_Type72;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type72.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type72);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type72, member_content);
        }
        CompleteStructType struct_type_Type72 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type72, header_Type72, member_seq_Type72);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type72, type_name_Type72.to_string(), type_ids_Type72))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type72 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type73_type_identifier(
        TypeIdentifierPair& type_ids_Type73)
{

    ReturnCode_t return_code_Type73 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type73 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type73", type_ids_Type73);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type73)
    {
        StructTypeFlag struct_flags_Type73 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type73 = "Type73";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type73;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type73;
        CompleteTypeDetail detail_Type73 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type73, ann_custom_Type73, type_name_Type73.to_string());
        CompleteStructHeader header_Type73;
        header_Type73 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type73);
        CompleteStructMemberSeq member_seq_Type73;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type73.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type73);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type73, member_content);
        }
        CompleteStructType struct_type_Type73 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type73, header_Type73, member_seq_Type73);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type73, type_name_Type73.to_string(), type_ids_Type73))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type73 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type74_type_identifier(
        TypeIdentifierPair& type_ids_Type74)
{

    ReturnCode_t return_code_Type74 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type74 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type74", type_ids_Type74);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type74)
    {
        StructTypeFlag struct_flags_Type74 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type74 = "Type74";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type74;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type74;
        CompleteTypeDetail detail_Type74 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type74, ann_custom_Type74, type_name_Type74.to_string());
        CompleteStructHeader header_Type74;
        header_Type74 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type74);
        CompleteStructMemberSeq member_seq_Type74;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type74.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type74);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type74, member_content);
        }
        CompleteStructType struct_type_Type74 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type74, header_Type74, member_seq_Type74);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type74, type_name_Type74.to_string(), type_ids_Type74))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type74 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type75_type_identifier(
        TypeIdentifierPair& type_ids_Type75)
{

    ReturnCode_t return_code_Type75 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type75 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type75", type_ids_Type75);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type75)
    {
        StructTypeFlag struct_flags_Type75 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type75 = "Type75";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type75;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type75;
        CompleteTypeDetail detail_Type75 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type75, ann_custom_Type75, type_name_Type75.to_string());
        CompleteStructHeader header_Type75;
        header_Type75 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type75);
        CompleteStructMemberSeq member_seq_Type75;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type75.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type75);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type75, member_content);
        }
        CompleteStructType struct_type_Type75 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type75, header_Type75, member_seq_Type75);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type75, type_name_Type75.to_string(), type_ids_Type75))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type75 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type76_type_identifier(
        TypeIdentifierPair& type_ids_Type76)
{

    ReturnCode_t return_code_Type76 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type76 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type76", type_ids_Type76);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type76)
    {
        StructTypeFlag struct_flags_Type76 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type76 = "Type76";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type76;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type76;
        CompleteTypeDetail detail_Type76 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type76, ann_custom_Type76, type_name_Type76.to_string());
        CompleteStructHeader header_Type76;
        header_Type76 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type76);
        CompleteStructMemberSeq member_seq_Type76;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type76.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type76);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type76, member_content);
        }
        CompleteStructType struct_type_Type76 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type76, header_Type76, member_seq_Type76);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type76, type_name_Type76.to_string(), type_ids_Type76))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type76 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type77_type_identifier(
        TypeIdentifierPair& type_ids_Type77)
{

    ReturnCode_t return_code_Type77 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type77 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type77", type_ids_Type77);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type77)
    {
        StructTypeFlag struct_flags_Type77 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type77 = "Type77";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type77;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type77;
        CompleteTypeDetail detail_Type77 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type77, ann_custom_Type77, type_name_Type77.to_string());
        CompleteStructHeader header_Type77;
        header_Type77 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type77);
        CompleteStructMemberSeq member_seq_Type77;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type77.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type77);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type77, member_content);
        }
        CompleteStructType struct_type_Type77 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type77, header_Type77, member_seq_Type77);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type77, type_name_Type77.to_string(), type_ids_Type77))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type77 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type78_type_identifier(
        TypeIdentifierPair& type_ids_Type78)
{

    ReturnCode_t return_code_Type78 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type78 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type78", type_ids_Type78);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type78)
    {
        StructTypeFlag struct_flags_Type78 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type78 = "Type78";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type78;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type78;
        CompleteTypeDetail detail_Type78 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type78, ann_custom_Type78, type_name_Type78.to_string());
        CompleteStructHeader header_Type78;
        header_Type78 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type78);
        CompleteStructMemberSeq member_seq_Type78;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type78.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type78);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type78, member_content);
        }
        CompleteStructType struct_type_Type78 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type78, header_Type78, member_seq_Type78);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type78, type_name_Type78.to_string(), type_ids_Type78))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type78 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type79_type_identifier(
        TypeIdentifierPair& type_ids_Type79)
{

    ReturnCode_t return_code_Type79 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type79 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type79", type_ids_Type79);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type79)
    {
        StructTypeFlag struct_flags_Type79 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type79 = "Type79";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type79;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type79;
        CompleteTypeDetail detail_Type79 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type79, ann_custom_Type79, type_name_Type79.to_string());
        CompleteStructHeader header_Type79;
        header_Type79 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type79);
        CompleteStructMemberSeq member_seq_Type79;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type79.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type79);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type79, member_content);
        }
        CompleteStructType struct_type_Type79 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type79, header_Type79, member_seq_Type79);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type79, type_name_Type79.to_string(), type_ids_Type79))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type79 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type80_type_identifier(
        TypeIdentifierPair& type_ids_Type80)
{

    ReturnCode_t return_code_Type80 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type80 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type80", type_ids_Type80);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type80)
    {
        StructTypeFlag struct_flags_Type80 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type80 = "Type80";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type80;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type80;
        CompleteTypeDetail detail_Type80 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type80, ann_custom_Type80, type_name_Type80.to_string());
        CompleteStructHeader header_Type80;
        header_Type80 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type80);
        CompleteStructMemberSeq member_seq_Type80;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type80.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type80);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type80, member_content);
        }
        CompleteStructType struct_type_Type80 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type80, header_Type80, member_seq_Type80);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type80, type_name_Type80.to_string(), type_ids_Type80))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type80 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type81_type_identifier(
        TypeIdentifierPair& type_ids_Type81)
{

    ReturnCode_t return_code_Type81 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type81 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type81", type_ids_Type81);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type81)
    {
        StructTypeFlag struct_flags_Type81 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type81 = "Type81";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type81;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type81;
        CompleteTypeDetail detail_Type81 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type81, ann_custom_Type81, type_name_Type81.to_string());
        CompleteStructHeader header_Type81;
        header_Type81 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type81);
        CompleteStructMemberSeq member_seq_Type81;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type81.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type81);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type81, member_content);
        }
        CompleteStructType struct_type_Type81 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type81, header_Type81, member_seq_Type81);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type81, type_name_Type81.to_string(), type_ids_Type81))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type81 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type82_type_identifier(
        TypeIdentifierPair& type_ids_Type82)
{

    ReturnCode_t return_code_Type82 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type82 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type82", type_ids_Type82);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type82)
    {
        StructTypeFlag struct_flags_Type82 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type82 = "Type82";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type82;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type82;
        CompleteTypeDetail detail_Type82 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type82, ann_custom_Type82, type_name_Type82.to_string());
        CompleteStructHeader header_Type82;
        header_Type82 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type82);
        CompleteStructMemberSeq member_seq_Type82;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type82.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type82);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type82, member_content);
        }
        CompleteStructType struct_type_Type82 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type82, header_Type82, member_seq_Type82);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type82, type_name_Type82.to_string(), type_ids_Type82))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type82 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type83_type_identifier(
        TypeIdentifierPair& type_ids_Type83)
{

    ReturnCode_t return_code_Type83 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type83 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type83", type_ids_Type83);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type83)
    {
        StructTypeFlag struct_flags_Type83 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type83 = "Type83";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type83;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type83;
        CompleteTypeDetail detail_Type83 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type83, ann_custom_Type83, type_name_Type83.to_string());
        CompleteStructHeader header_Type83;
        header_Type83 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type83);
        CompleteStructMemberSeq member_seq_Type83;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type83.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type83);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type83, member_content);
        }
        CompleteStructType struct_type_Type83 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type83, header_Type83, member_seq_Type83);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type83, type_name_Type83.to_string(), type_ids_Type83))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type83 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type84_type_identifier(
        TypeIdentifierPair& type_ids_Type84)
{

    ReturnCode_t return_code_Type84 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type84 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type84", type_ids_Type84);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type84)
    {
        StructTypeFlag struct_flags_Type84 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type84 = "Type84";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type84;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type84;
        CompleteTypeDetail detail_Type84 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type84, ann_custom_Type84, type_name_Type84.to_string());
        CompleteStructHeader header_Type84;
        header_Type84 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type84);
        CompleteStructMemberSeq member_seq_Type84;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type84.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type84);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type84, member_content);
        }
        CompleteStructType struct_type_Type84 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type84, header_Type84, member_seq_Type84);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type84, type_name_Type84.to_string(), type_ids_Type84))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type84 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type85_type_identifier(
        TypeIdentifierPair& type_ids_Type85)
{

    ReturnCode_t return_code_Type85 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type85 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type85", type_ids_Type85);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type85)
    {
        StructTypeFlag struct_flags_Type85 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type85 = "Type85";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type85;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type85;
        CompleteTypeDetail detail_Type85 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type85, ann_custom_Type85, type_name_Type85.to_string());
        CompleteStructHeader header_Type85;
        header_Type85 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type85);
        CompleteStructMemberSeq member_seq_Type85;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type85.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type85);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type85, member_content);
        }
        CompleteStructType struct_type_Type85 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type85, header_Type85, member_seq_Type85);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type85, type_name_Type85.to_string(), type_ids_Type85))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type85 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type86_type_identifier(
        TypeIdentifierPair& type_ids_Type86)
{

    ReturnCode_t return_code_Type86 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type86 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type86", type_ids_Type86);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type86)
    {
        StructTypeFlag struct_flags_Type86 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type86 = "Type86";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type86;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type86;
        CompleteTypeDetail detail_Type86 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type86, ann_custom_Type86, type_name_Type86.to_string());
        CompleteStructHeader header_Type86;
        header_Type86 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type86);
        CompleteStructMemberSeq member_seq_Type86;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type86.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type86);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type86, member_content);
        }
        CompleteStructType struct_type_Type86 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type86, header_Type86, member_seq_Type86);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type86, type_name_Type86.to_string(), type_ids_Type86))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type86 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type87_type_identifier(
        TypeIdentifierPair& type_ids_Type87)
{

    ReturnCode_t return_code_Type87 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type87 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type87", type_ids_Type87);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type87)
    {
        StructTypeFlag struct_flags_Type87 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type87 = "Type87";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type87;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type87;
        CompleteTypeDetail detail_Type87 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type87, ann_custom_Type87, type_name_Type87.to_string());
        CompleteStructHeader header_Type87;
        header_Type87 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type87);
        CompleteStructMemberSeq member_seq_Type87;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type87.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type87);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type87, member_content);
        }
        CompleteStructType struct_type_Type87 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type87, header_Type87, member_seq_Type87);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type87, type_name_Type87.to_string(), type_ids_Type87))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type87 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type88_type_identifier(
        TypeIdentifierPair& type_ids_Type88)
{

    ReturnCode_t return_code_Type88 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type88 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type88", type_ids_Type88);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type88)
    {
        StructTypeFlag struct_flags_Type88 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type88 = "Type88";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type88;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type88;
        CompleteTypeDetail detail_Type88 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type88, ann_custom_Type88, type_name_Type88.to_string());
        CompleteStructHeader header_Type88;
        header_Type88 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type88);
        CompleteStructMemberSeq member_seq_Type88;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type88.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type88);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type88, member_content);
        }
        CompleteStructType struct_type_Type88 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type88, header_Type88, member_seq_Type88);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type88, type_name_Type88.to_string(), type_ids_Type88))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type88 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type89_type_identifier(
        TypeIdentifierPair& type_ids_Type89)
{

    ReturnCode_t return_code_Type89 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type89 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type89", type_ids_Type89);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type89)
    {
        StructTypeFlag struct_flags_Type89 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type89 = "Type89";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type89;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type89;
        CompleteTypeDetail detail_Type89 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type89, ann_custom_Type89, type_name_Type89.to_string());
        CompleteStructHeader header_Type89;
        header_Type89 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type89);
        CompleteStructMemberSeq member_seq_Type89;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type89.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type89);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type89, member_content);
        }
        CompleteStructType struct_type_Type89 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type89, header_Type89, member_seq_Type89);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type89, type_name_Type89.to_string(), type_ids_Type89))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type89 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type90_type_identifier(
        TypeIdentifierPair& type_ids_Type90)
{

    ReturnCode_t return_code_Type90 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type90 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type90", type_ids_Type90);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type90)
    {
        StructTypeFlag struct_flags_Type90 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type90 = "Type90";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type90;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type90;
        CompleteTypeDetail detail_Type90 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type90, ann_custom_Type90, type_name_Type90.to_string());
        CompleteStructHeader header_Type90;
        header_Type90 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type90);
        CompleteStructMemberSeq member_seq_Type90;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type90.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type90);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type90, member_content);
        }
        CompleteStructType struct_type_Type90 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type90, header_Type90, member_seq_Type90);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type90, type_name_Type90.to_string(), type_ids_Type90))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type90 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type91_type_identifier(
        TypeIdentifierPair& type_ids_Type91)
{

    ReturnCode_t return_code_Type91 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type91 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type91", type_ids_Type91);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type91)
    {
        StructTypeFlag struct_flags_Type91 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type91 = "Type91";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type91;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type91;
        CompleteTypeDetail detail_Type91 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type91, ann_custom_Type91, type_name_Type91.to_string());
        CompleteStructHeader header_Type91;
        header_Type91 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type91);
        CompleteStructMemberSeq member_seq_Type91;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type91.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type91);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type91, member_content);
        }
        CompleteStructType struct_type_Type91 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type91, header_Type91, member_seq_Type91);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type91, type_name_Type91.to_string(), type_ids_Type91))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type91 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type92_type_identifier(
        TypeIdentifierPair& type_ids_Type92)
{

    ReturnCode_t return_code_Type92 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type92 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type92", type_ids_Type92);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type92)
    {
        StructTypeFlag struct_flags_Type92 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type92 = "Type92";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type92;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type92;
        CompleteTypeDetail detail_Type92 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type92, ann_custom_Type92, type_name_Type92.to_string());
        CompleteStructHeader header_Type92;
        header_Type92 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type92);
        CompleteStructMemberSeq member_seq_Type92;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type92.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type92);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type92, member_content);
        }
        CompleteStructType struct_type_Type92 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type92, header_Type92, member_seq_Type92);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type92, type_name_Type92.to_string(), type_ids_Type92))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type92 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type93_type_identifier(
        TypeIdentifierPair& type_ids_Type93)
{

    ReturnCode_t return_code_Type93 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type93 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type93", type_ids_Type93);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type93)
    {
        StructTypeFlag struct_flags_Type93 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type93 = "Type93";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type93;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type93;
        CompleteTypeDetail detail_Type93 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type93, ann_custom_Type93, type_name_Type93.to_string());
        CompleteStructHeader header_Type93;
        header_Type93 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type93);
        CompleteStructMemberSeq member_seq_Type93;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type93.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type93);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type93, member_content);
        }
        CompleteStructType struct_type_Type93 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type93, header_Type93, member_seq_Type93);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type93, type_name_Type93.to_string(), type_ids_Type93))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type93 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type94_type_identifier(
        TypeIdentifierPair& type_ids_Type94)
{

    ReturnCode_t return_code_Type94 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type94 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type94", type_ids_Type94);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type94)
    {
        StructTypeFlag struct_flags_Type94 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type94 = "Type94";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type94;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type94;
        CompleteTypeDetail detail_Type94 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type94, ann_custom_Type94, type_name_Type94.to_string());
        CompleteStructHeader header_Type94;
        header_Type94 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type94);
        CompleteStructMemberSeq member_seq_Type94;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type94.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type94);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type94, member_content);
        }
        CompleteStructType struct_type_Type94 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type94, header_Type94, member_seq_Type94);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type94, type_name_Type94.to_string(), type_ids_Type94))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type94 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type95_type_identifier(
        TypeIdentifierPair& type_ids_Type95)
{

    ReturnCode_t return_code_Type95 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type95 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type95", type_ids_Type95);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type95)
    {
        StructTypeFlag struct_flags_Type95 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type95 = "Type95";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type95;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type95;
        CompleteTypeDetail detail_Type95 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type95, ann_custom_Type95, type_name_Type95.to_string());
        CompleteStructHeader header_Type95;
        header_Type95 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type95);
        CompleteStructMemberSeq member_seq_Type95;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type95.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type95);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type95, member_content);
        }
        CompleteStructType struct_type_Type95 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type95, header_Type95, member_seq_Type95);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type95, type_name_Type95.to_string(), type_ids_Type95))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type95 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type96_type_identifier(
        TypeIdentifierPair& type_ids_Type96)
{

    ReturnCode_t return_code_Type96 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type96 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type96", type_ids_Type96);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type96)
    {
        StructTypeFlag struct_flags_Type96 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type96 = "Type96";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type96;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type96;
        CompleteTypeDetail detail_Type96 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type96, ann_custom_Type96, type_name_Type96.to_string());
        CompleteStructHeader header_Type96;
        header_Type96 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type96);
        CompleteStructMemberSeq member_seq_Type96;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type96.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type96);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type96, member_content);
        }
        CompleteStructType struct_type_Type96 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type96, header_Type96, member_seq_Type96);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type96, type_name_Type96.to_string(), type_ids_Type96))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type96 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type97_type_identifier(
        TypeIdentifierPair& type_ids_Type97)
{

    ReturnCode_t return_code_Type97 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type97 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type97", type_ids_Type97);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type97)
    {
        StructTypeFlag struct_flags_Type97 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type97 = "Type97";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type97;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type97;
        CompleteTypeDetail detail_Type97 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type97, ann_custom_Type97, type_name_Type97.to_string());
        CompleteStructHeader header_Type97;
        header_Type97 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type97);
        CompleteStructMemberSeq member_seq_Type97;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type97.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type97);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type97, member_content);
        }
        CompleteStructType struct_type_Type97 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type97, header_Type97, member_seq_Type97);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type97, type_name_Type97.to_string(), type_ids_Type97))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type97 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type98_type_identifier(
        TypeIdentifierPair& type_ids_Type98)
{

    ReturnCode_t return_code_Type98 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type98 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type98", type_ids_Type98);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type98)
    {
        StructTypeFlag struct_flags_Type98 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type98 = "Type98";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type98;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type98;
        CompleteTypeDetail detail_Type98 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type98, ann_custom_Type98, type_name_Type98.to_string());
        CompleteStructHeader header_Type98;
        header_Type98 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type98);
        CompleteStructMemberSeq member_seq_Type98;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type98.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type98);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type98, member_content);
        }
        CompleteStructType struct_type_Type98 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type98, header_Type98, member_seq_Type98);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type98, type_name_Type98.to_string(), type_ids_Type98))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type98 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type99_type_identifier(
        TypeIdentifierPair& type_ids_Type99)
{

    ReturnCode_t return_code_Type99 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type99 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type99", type_ids_Type99);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type99)
    {
        StructTypeFlag struct_flags_Type99 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type99 = "Type99";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type99;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type99;
        CompleteTypeDetail detail_Type99 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type99, ann_custom_Type99, type_name_Type99.to_string());
        CompleteStructHeader header_Type99;
        header_Type99 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type99);
        CompleteStructMemberSeq member_seq_Type99;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type99.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type99);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type99, member_content);
        }
        CompleteStructType struct_type_Type99 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type99, header_Type99, member_seq_Type99);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type99, type_name_Type99.to_string(), type_ids_Type99))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type99 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type100_type_identifier(
        TypeIdentifierPair& type_ids_Type100)
{

    ReturnCode_t return_code_Type100 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type100 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type100", type_ids_Type100);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type100)
    {
        StructTypeFlag struct_flags_Type100 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type100 = "Type100";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type100;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type100;
        CompleteTypeDetail detail_Type100 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type100, ann_custom_Type100, type_name_Type100.to_string());
        CompleteStructHeader header_Type100;
        header_Type100 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type100);
        CompleteStructMemberSeq member_seq_Type100;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type100.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type100);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type100, member_content);
        }
        CompleteStructType struct_type_Type100 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type100, header_Type100, member_seq_Type100);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type100, type_name_Type100.to_string(), type_ids_Type100))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type100 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_TypeBig_type_identifier(
        TypeIdentifierPair& type_ids_TypeBig)
{

    ReturnCode_t return_code_TypeBig {eprosima::fastdds::dds::RETCODE_OK};
    return_code_TypeBig =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "TypeBig", type_ids_TypeBig);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_TypeBig)
    {
        StructTypeFlag struct_flags_TypeBig = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_TypeBig = "TypeBig";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_TypeBig;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_TypeBig;
        CompleteTypeDetail detail_TypeBig = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_TypeBig, ann_custom_TypeBig, type_name_TypeBig.to_string());
        CompleteStructHeader header_TypeBig;
        header_TypeBig = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_TypeBig);
        CompleteStructMemberSeq member_seq_TypeBig;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_TypeBig);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_content);
        }
        {
            TypeIdentifierPair type_ids_dep1;
            ReturnCode_t return_code_dep1 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep1 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type1", type_ids_dep1);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep1)
            {
            ::register_Type1_type_identifier(type_ids_dep1);
            }
            StructMemberFlag member_flags_dep1 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep1 = 0x00000001;
            bool common_dep1_ec {false};
            CommonStructMember common_dep1 {TypeObjectUtils::build_common_struct_member(member_id_dep1, member_flags_dep1, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep1, common_dep1_ec))};
            if (!common_dep1_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep1 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep1 = "dep1";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep1;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep1 = TypeObjectUtils::build_complete_member_detail(name_dep1, member_ann_builtin_dep1, ann_custom_TypeBig);
            CompleteStructMember member_dep1 = TypeObjectUtils::build_complete_struct_member(common_dep1, detail_dep1);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep1);
        }
        {
            TypeIdentifierPair type_ids_dep2;
            ReturnCode_t return_code_dep2 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep2 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type2", type_ids_dep2);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep2)
            {
            ::register_Type2_type_identifier(type_ids_dep2);
            }
            StructMemberFlag member_flags_dep2 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep2 = 0x00000002;
            bool common_dep2_ec {false};
            CommonStructMember common_dep2 {TypeObjectUtils::build_common_struct_member(member_id_dep2, member_flags_dep2, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep2, common_dep2_ec))};
            if (!common_dep2_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep2 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep2 = "dep2";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep2;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep2 = TypeObjectUtils::build_complete_member_detail(name_dep2, member_ann_builtin_dep2, ann_custom_TypeBig);
            CompleteStructMember member_dep2 = TypeObjectUtils::build_complete_struct_member(common_dep2, detail_dep2);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep2);
        }
        {
            TypeIdentifierPair type_ids_dep3;
            ReturnCode_t return_code_dep3 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep3 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type3", type_ids_dep3);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep3)
            {
            ::register_Type3_type_identifier(type_ids_dep3);
            }
            StructMemberFlag member_flags_dep3 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep3 = 0x00000003;
            bool common_dep3_ec {false};
            CommonStructMember common_dep3 {TypeObjectUtils::build_common_struct_member(member_id_dep3, member_flags_dep3, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep3, common_dep3_ec))};
            if (!common_dep3_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep3 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep3 = "dep3";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep3;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep3 = TypeObjectUtils::build_complete_member_detail(name_dep3, member_ann_builtin_dep3, ann_custom_TypeBig);
            CompleteStructMember member_dep3 = TypeObjectUtils::build_complete_struct_member(common_dep3, detail_dep3);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep3);
        }
        {
            TypeIdentifierPair type_ids_dep4;
            ReturnCode_t return_code_dep4 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep4 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type4", type_ids_dep4);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep4)
            {
            ::register_Type4_type_identifier(type_ids_dep4);
            }
            StructMemberFlag member_flags_dep4 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep4 = 0x00000004;
            bool common_dep4_ec {false};
            CommonStructMember common_dep4 {TypeObjectUtils::build_common_struct_member(member_id_dep4, member_flags_dep4, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep4, common_dep4_ec))};
            if (!common_dep4_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep4 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep4 = "dep4";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep4;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep4 = TypeObjectUtils::build_complete_member_detail(name_dep4, member_ann_builtin_dep4, ann_custom_TypeBig);
            CompleteStructMember member_dep4 = TypeObjectUtils::build_complete_struct_member(common_dep4, detail_dep4);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep4);
        }
        {
            TypeIdentifierPair type_ids_dep5;
            ReturnCode_t return_code_dep5 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep5 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type5", type_ids_dep5);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep5)
            {
            ::register_Type5_type_identifier(type_ids_dep5);
            }
            StructMemberFlag member_flags_dep5 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep5 = 0x00000005;
            bool common_dep5_ec {false};
            CommonStructMember common_dep5 {TypeObjectUtils::build_common_struct_member(member_id_dep5, member_flags_dep5, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep5, common_dep5_ec))};
            if (!common_dep5_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep5 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep5 = "dep5";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep5;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep5 = TypeObjectUtils::build_complete_member_detail(name_dep5, member_ann_builtin_dep5, ann_custom_TypeBig);
            CompleteStructMember member_dep5 = TypeObjectUtils::build_complete_struct_member(common_dep5, detail_dep5);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep5);
        }
        {
            TypeIdentifierPair type_ids_dep6;
            ReturnCode_t return_code_dep6 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep6 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type6", type_ids_dep6);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep6)
            {
            ::register_Type6_type_identifier(type_ids_dep6);
            }
            StructMemberFlag member_flags_dep6 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep6 = 0x00000006;
            bool common_dep6_ec {false};
            CommonStructMember common_dep6 {TypeObjectUtils::build_common_struct_member(member_id_dep6, member_flags_dep6, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep6, common_dep6_ec))};
            if (!common_dep6_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep6 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep6 = "dep6";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep6;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep6 = TypeObjectUtils::build_complete_member_detail(name_dep6, member_ann_builtin_dep6, ann_custom_TypeBig);
            CompleteStructMember member_dep6 = TypeObjectUtils::build_complete_struct_member(common_dep6, detail_dep6);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep6);
        }
        {
            TypeIdentifierPair type_ids_dep7;
            ReturnCode_t return_code_dep7 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep7 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type7", type_ids_dep7);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep7)
            {
            ::register_Type7_type_identifier(type_ids_dep7);
            }
            StructMemberFlag member_flags_dep7 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep7 = 0x00000007;
            bool common_dep7_ec {false};
            CommonStructMember common_dep7 {TypeObjectUtils::build_common_struct_member(member_id_dep7, member_flags_dep7, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep7, common_dep7_ec))};
            if (!common_dep7_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep7 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep7 = "dep7";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep7;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep7 = TypeObjectUtils::build_complete_member_detail(name_dep7, member_ann_builtin_dep7, ann_custom_TypeBig);
            CompleteStructMember member_dep7 = TypeObjectUtils::build_complete_struct_member(common_dep7, detail_dep7);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep7);
        }
        {
            TypeIdentifierPair type_ids_dep8;
            ReturnCode_t return_code_dep8 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep8 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type8", type_ids_dep8);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep8)
            {
            ::register_Type8_type_identifier(type_ids_dep8);
            }
            StructMemberFlag member_flags_dep8 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep8 = 0x00000008;
            bool common_dep8_ec {false};
            CommonStructMember common_dep8 {TypeObjectUtils::build_common_struct_member(member_id_dep8, member_flags_dep8, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep8, common_dep8_ec))};
            if (!common_dep8_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep8 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep8 = "dep8";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep8;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep8 = TypeObjectUtils::build_complete_member_detail(name_dep8, member_ann_builtin_dep8, ann_custom_TypeBig);
            CompleteStructMember member_dep8 = TypeObjectUtils::build_complete_struct_member(common_dep8, detail_dep8);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep8);
        }
        {
            TypeIdentifierPair type_ids_dep9;
            ReturnCode_t return_code_dep9 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep9 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type9", type_ids_dep9);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep9)
            {
            ::register_Type9_type_identifier(type_ids_dep9);
            }
            StructMemberFlag member_flags_dep9 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep9 = 0x00000009;
            bool common_dep9_ec {false};
            CommonStructMember common_dep9 {TypeObjectUtils::build_common_struct_member(member_id_dep9, member_flags_dep9, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep9, common_dep9_ec))};
            if (!common_dep9_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep9 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep9 = "dep9";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep9;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep9 = TypeObjectUtils::build_complete_member_detail(name_dep9, member_ann_builtin_dep9, ann_custom_TypeBig);
            CompleteStructMember member_dep9 = TypeObjectUtils::build_complete_struct_member(common_dep9, detail_dep9);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep9);
        }
        {
            TypeIdentifierPair type_ids_dep10;
            ReturnCode_t return_code_dep10 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep10 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type10", type_ids_dep10);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep10)
            {
            ::register_Type10_type_identifier(type_ids_dep10);
            }
            StructMemberFlag member_flags_dep10 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep10 = 0x0000000a;
            bool common_dep10_ec {false};
            CommonStructMember common_dep10 {TypeObjectUtils::build_common_struct_member(member_id_dep10, member_flags_dep10, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep10, common_dep10_ec))};
            if (!common_dep10_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep10 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep10 = "dep10";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep10;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep10 = TypeObjectUtils::build_complete_member_detail(name_dep10, member_ann_builtin_dep10, ann_custom_TypeBig);
            CompleteStructMember member_dep10 = TypeObjectUtils::build_complete_struct_member(common_dep10, detail_dep10);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep10);
        }
        {
            TypeIdentifierPair type_ids_dep11;
            ReturnCode_t return_code_dep11 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep11 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type11", type_ids_dep11);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep11)
            {
            ::register_Type11_type_identifier(type_ids_dep11);
            }
            StructMemberFlag member_flags_dep11 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep11 = 0x0000000b;
            bool common_dep11_ec {false};
            CommonStructMember common_dep11 {TypeObjectUtils::build_common_struct_member(member_id_dep11, member_flags_dep11, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep11, common_dep11_ec))};
            if (!common_dep11_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep11 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep11 = "dep11";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep11;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep11 = TypeObjectUtils::build_complete_member_detail(name_dep11, member_ann_builtin_dep11, ann_custom_TypeBig);
            CompleteStructMember member_dep11 = TypeObjectUtils::build_complete_struct_member(common_dep11, detail_dep11);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep11);
        }
        {
            TypeIdentifierPair type_ids_dep12;
            ReturnCode_t return_code_dep12 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep12 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type12", type_ids_dep12);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep12)
            {
            ::register_Type12_type_identifier(type_ids_dep12);
            }
            StructMemberFlag member_flags_dep12 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep12 = 0x0000000c;
            bool common_dep12_ec {false};
            CommonStructMember common_dep12 {TypeObjectUtils::build_common_struct_member(member_id_dep12, member_flags_dep12, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep12, common_dep12_ec))};
            if (!common_dep12_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep12 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep12 = "dep12";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep12;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep12 = TypeObjectUtils::build_complete_member_detail(name_dep12, member_ann_builtin_dep12, ann_custom_TypeBig);
            CompleteStructMember member_dep12 = TypeObjectUtils::build_complete_struct_member(common_dep12, detail_dep12);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep12);
        }
        {
            TypeIdentifierPair type_ids_dep13;
            ReturnCode_t return_code_dep13 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep13 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type13", type_ids_dep13);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep13)
            {
            ::register_Type13_type_identifier(type_ids_dep13);
            }
            StructMemberFlag member_flags_dep13 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep13 = 0x0000000d;
            bool common_dep13_ec {false};
            CommonStructMember common_dep13 {TypeObjectUtils::build_common_struct_member(member_id_dep13, member_flags_dep13, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep13, common_dep13_ec))};
            if (!common_dep13_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep13 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep13 = "dep13";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep13;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep13 = TypeObjectUtils::build_complete_member_detail(name_dep13, member_ann_builtin_dep13, ann_custom_TypeBig);
            CompleteStructMember member_dep13 = TypeObjectUtils::build_complete_struct_member(common_dep13, detail_dep13);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep13);
        }
        {
            TypeIdentifierPair type_ids_dep14;
            ReturnCode_t return_code_dep14 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep14 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type14", type_ids_dep14);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep14)
            {
            ::register_Type14_type_identifier(type_ids_dep14);
            }
            StructMemberFlag member_flags_dep14 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep14 = 0x0000000e;
            bool common_dep14_ec {false};
            CommonStructMember common_dep14 {TypeObjectUtils::build_common_struct_member(member_id_dep14, member_flags_dep14, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep14, common_dep14_ec))};
            if (!common_dep14_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep14 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep14 = "dep14";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep14;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep14 = TypeObjectUtils::build_complete_member_detail(name_dep14, member_ann_builtin_dep14, ann_custom_TypeBig);
            CompleteStructMember member_dep14 = TypeObjectUtils::build_complete_struct_member(common_dep14, detail_dep14);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep14);
        }
        {
            TypeIdentifierPair type_ids_dep15;
            ReturnCode_t return_code_dep15 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep15 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type15", type_ids_dep15);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep15)
            {
            ::register_Type15_type_identifier(type_ids_dep15);
            }
            StructMemberFlag member_flags_dep15 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep15 = 0x0000000f;
            bool common_dep15_ec {false};
            CommonStructMember common_dep15 {TypeObjectUtils::build_common_struct_member(member_id_dep15, member_flags_dep15, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep15, common_dep15_ec))};
            if (!common_dep15_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep15 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep15 = "dep15";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep15;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep15 = TypeObjectUtils::build_complete_member_detail(name_dep15, member_ann_builtin_dep15, ann_custom_TypeBig);
            CompleteStructMember member_dep15 = TypeObjectUtils::build_complete_struct_member(common_dep15, detail_dep15);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep15);
        }
        {
            TypeIdentifierPair type_ids_dep16;
            ReturnCode_t return_code_dep16 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep16 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type16", type_ids_dep16);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep16)
            {
            ::register_Type16_type_identifier(type_ids_dep16);
            }
            StructMemberFlag member_flags_dep16 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep16 = 0x00000010;
            bool common_dep16_ec {false};
            CommonStructMember common_dep16 {TypeObjectUtils::build_common_struct_member(member_id_dep16, member_flags_dep16, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep16, common_dep16_ec))};
            if (!common_dep16_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep16 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep16 = "dep16";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep16;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep16 = TypeObjectUtils::build_complete_member_detail(name_dep16, member_ann_builtin_dep16, ann_custom_TypeBig);
            CompleteStructMember member_dep16 = TypeObjectUtils::build_complete_struct_member(common_dep16, detail_dep16);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep16);
        }
        {
            TypeIdentifierPair type_ids_dep17;
            ReturnCode_t return_code_dep17 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep17 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type17", type_ids_dep17);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep17)
            {
            ::register_Type17_type_identifier(type_ids_dep17);
            }
            StructMemberFlag member_flags_dep17 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep17 = 0x00000011;
            bool common_dep17_ec {false};
            CommonStructMember common_dep17 {TypeObjectUtils::build_common_struct_member(member_id_dep17, member_flags_dep17, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep17, common_dep17_ec))};
            if (!common_dep17_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep17 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep17 = "dep17";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep17;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep17 = TypeObjectUtils::build_complete_member_detail(name_dep17, member_ann_builtin_dep17, ann_custom_TypeBig);
            CompleteStructMember member_dep17 = TypeObjectUtils::build_complete_struct_member(common_dep17, detail_dep17);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep17);
        }
        {
            TypeIdentifierPair type_ids_dep18;
            ReturnCode_t return_code_dep18 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep18 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type18", type_ids_dep18);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep18)
            {
            ::register_Type18_type_identifier(type_ids_dep18);
            }
            StructMemberFlag member_flags_dep18 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep18 = 0x00000012;
            bool common_dep18_ec {false};
            CommonStructMember common_dep18 {TypeObjectUtils::build_common_struct_member(member_id_dep18, member_flags_dep18, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep18, common_dep18_ec))};
            if (!common_dep18_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep18 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep18 = "dep18";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep18;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep18 = TypeObjectUtils::build_complete_member_detail(name_dep18, member_ann_builtin_dep18, ann_custom_TypeBig);
            CompleteStructMember member_dep18 = TypeObjectUtils::build_complete_struct_member(common_dep18, detail_dep18);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep18);
        }
        {
            TypeIdentifierPair type_ids_dep19;
            ReturnCode_t return_code_dep19 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep19 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type19", type_ids_dep19);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep19)
            {
            ::register_Type19_type_identifier(type_ids_dep19);
            }
            StructMemberFlag member_flags_dep19 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep19 = 0x00000013;
            bool common_dep19_ec {false};
            CommonStructMember common_dep19 {TypeObjectUtils::build_common_struct_member(member_id_dep19, member_flags_dep19, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep19, common_dep19_ec))};
            if (!common_dep19_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep19 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep19 = "dep19";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep19;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep19 = TypeObjectUtils::build_complete_member_detail(name_dep19, member_ann_builtin_dep19, ann_custom_TypeBig);
            CompleteStructMember member_dep19 = TypeObjectUtils::build_complete_struct_member(common_dep19, detail_dep19);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep19);
        }
        {
            TypeIdentifierPair type_ids_dep20;
            ReturnCode_t return_code_dep20 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep20 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type20", type_ids_dep20);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep20)
            {
            ::register_Type20_type_identifier(type_ids_dep20);
            }
            StructMemberFlag member_flags_dep20 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep20 = 0x00000014;
            bool common_dep20_ec {false};
            CommonStructMember common_dep20 {TypeObjectUtils::build_common_struct_member(member_id_dep20, member_flags_dep20, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep20, common_dep20_ec))};
            if (!common_dep20_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep20 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep20 = "dep20";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep20;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep20 = TypeObjectUtils::build_complete_member_detail(name_dep20, member_ann_builtin_dep20, ann_custom_TypeBig);
            CompleteStructMember member_dep20 = TypeObjectUtils::build_complete_struct_member(common_dep20, detail_dep20);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep20);
        }
        {
            TypeIdentifierPair type_ids_dep21;
            ReturnCode_t return_code_dep21 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep21 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type21", type_ids_dep21);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep21)
            {
            ::register_Type21_type_identifier(type_ids_dep21);
            }
            StructMemberFlag member_flags_dep21 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep21 = 0x00000015;
            bool common_dep21_ec {false};
            CommonStructMember common_dep21 {TypeObjectUtils::build_common_struct_member(member_id_dep21, member_flags_dep21, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep21, common_dep21_ec))};
            if (!common_dep21_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep21 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep21 = "dep21";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep21;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep21 = TypeObjectUtils::build_complete_member_detail(name_dep21, member_ann_builtin_dep21, ann_custom_TypeBig);
            CompleteStructMember member_dep21 = TypeObjectUtils::build_complete_struct_member(common_dep21, detail_dep21);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep21);
        }
        {
            TypeIdentifierPair type_ids_dep22;
            ReturnCode_t return_code_dep22 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep22 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type22", type_ids_dep22);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep22)
            {
            ::register_Type22_type_identifier(type_ids_dep22);
            }
            StructMemberFlag member_flags_dep22 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep22 = 0x00000016;
            bool common_dep22_ec {false};
            CommonStructMember common_dep22 {TypeObjectUtils::build_common_struct_member(member_id_dep22, member_flags_dep22, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep22, common_dep22_ec))};
            if (!common_dep22_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep22 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep22 = "dep22";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep22;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep22 = TypeObjectUtils::build_complete_member_detail(name_dep22, member_ann_builtin_dep22, ann_custom_TypeBig);
            CompleteStructMember member_dep22 = TypeObjectUtils::build_complete_struct_member(common_dep22, detail_dep22);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep22);
        }
        {
            TypeIdentifierPair type_ids_dep23;
            ReturnCode_t return_code_dep23 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep23 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type23", type_ids_dep23);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep23)
            {
            ::register_Type23_type_identifier(type_ids_dep23);
            }
            StructMemberFlag member_flags_dep23 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep23 = 0x00000017;
            bool common_dep23_ec {false};
            CommonStructMember common_dep23 {TypeObjectUtils::build_common_struct_member(member_id_dep23, member_flags_dep23, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep23, common_dep23_ec))};
            if (!common_dep23_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep23 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep23 = "dep23";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep23;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep23 = TypeObjectUtils::build_complete_member_detail(name_dep23, member_ann_builtin_dep23, ann_custom_TypeBig);
            CompleteStructMember member_dep23 = TypeObjectUtils::build_complete_struct_member(common_dep23, detail_dep23);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep23);
        }
        {
            TypeIdentifierPair type_ids_dep24;
            ReturnCode_t return_code_dep24 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep24 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type24", type_ids_dep24);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep24)
            {
            ::register_Type24_type_identifier(type_ids_dep24);
            }
            StructMemberFlag member_flags_dep24 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep24 = 0x00000018;
            bool common_dep24_ec {false};
            CommonStructMember common_dep24 {TypeObjectUtils::build_common_struct_member(member_id_dep24, member_flags_dep24, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep24, common_dep24_ec))};
            if (!common_dep24_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep24 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep24 = "dep24";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep24;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep24 = TypeObjectUtils::build_complete_member_detail(name_dep24, member_ann_builtin_dep24, ann_custom_TypeBig);
            CompleteStructMember member_dep24 = TypeObjectUtils::build_complete_struct_member(common_dep24, detail_dep24);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep24);
        }
        {
            TypeIdentifierPair type_ids_dep25;
            ReturnCode_t return_code_dep25 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep25 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type25", type_ids_dep25);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep25)
            {
            ::register_Type25_type_identifier(type_ids_dep25);
            }
            StructMemberFlag member_flags_dep25 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep25 = 0x00000019;
            bool common_dep25_ec {false};
            CommonStructMember common_dep25 {TypeObjectUtils::build_common_struct_member(member_id_dep25, member_flags_dep25, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep25, common_dep25_ec))};
            if (!common_dep25_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep25 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep25 = "dep25";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep25;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep25 = TypeObjectUtils::build_complete_member_detail(name_dep25, member_ann_builtin_dep25, ann_custom_TypeBig);
            CompleteStructMember member_dep25 = TypeObjectUtils::build_complete_struct_member(common_dep25, detail_dep25);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep25);
        }
        {
            TypeIdentifierPair type_ids_dep26;
            ReturnCode_t return_code_dep26 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep26 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type26", type_ids_dep26);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep26)
            {
            ::register_Type26_type_identifier(type_ids_dep26);
            }
            StructMemberFlag member_flags_dep26 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep26 = 0x0000001a;
            bool common_dep26_ec {false};
            CommonStructMember common_dep26 {TypeObjectUtils::build_common_struct_member(member_id_dep26, member_flags_dep26, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep26, common_dep26_ec))};
            if (!common_dep26_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep26 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep26 = "dep26";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep26;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep26 = TypeObjectUtils::build_complete_member_detail(name_dep26, member_ann_builtin_dep26, ann_custom_TypeBig);
            CompleteStructMember member_dep26 = TypeObjectUtils::build_complete_struct_member(common_dep26, detail_dep26);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep26);
        }
        {
            TypeIdentifierPair type_ids_dep27;
            ReturnCode_t return_code_dep27 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep27 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type27", type_ids_dep27);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep27)
            {
            ::register_Type27_type_identifier(type_ids_dep27);
            }
            StructMemberFlag member_flags_dep27 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep27 = 0x0000001b;
            bool common_dep27_ec {false};
            CommonStructMember common_dep27 {TypeObjectUtils::build_common_struct_member(member_id_dep27, member_flags_dep27, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep27, common_dep27_ec))};
            if (!common_dep27_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep27 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep27 = "dep27";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep27;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep27 = TypeObjectUtils::build_complete_member_detail(name_dep27, member_ann_builtin_dep27, ann_custom_TypeBig);
            CompleteStructMember member_dep27 = TypeObjectUtils::build_complete_struct_member(common_dep27, detail_dep27);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep27);
        }
        {
            TypeIdentifierPair type_ids_dep28;
            ReturnCode_t return_code_dep28 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep28 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type28", type_ids_dep28);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep28)
            {
            ::register_Type28_type_identifier(type_ids_dep28);
            }
            StructMemberFlag member_flags_dep28 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep28 = 0x0000001c;
            bool common_dep28_ec {false};
            CommonStructMember common_dep28 {TypeObjectUtils::build_common_struct_member(member_id_dep28, member_flags_dep28, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep28, common_dep28_ec))};
            if (!common_dep28_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep28 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep28 = "dep28";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep28;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep28 = TypeObjectUtils::build_complete_member_detail(name_dep28, member_ann_builtin_dep28, ann_custom_TypeBig);
            CompleteStructMember member_dep28 = TypeObjectUtils::build_complete_struct_member(common_dep28, detail_dep28);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep28);
        }
        {
            TypeIdentifierPair type_ids_dep29;
            ReturnCode_t return_code_dep29 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep29 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type29", type_ids_dep29);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep29)
            {
            ::register_Type29_type_identifier(type_ids_dep29);
            }
            StructMemberFlag member_flags_dep29 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep29 = 0x0000001d;
            bool common_dep29_ec {false};
            CommonStructMember common_dep29 {TypeObjectUtils::build_common_struct_member(member_id_dep29, member_flags_dep29, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep29, common_dep29_ec))};
            if (!common_dep29_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep29 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep29 = "dep29";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep29;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep29 = TypeObjectUtils::build_complete_member_detail(name_dep29, member_ann_builtin_dep29, ann_custom_TypeBig);
            CompleteStructMember member_dep29 = TypeObjectUtils::build_complete_struct_member(common_dep29, detail_dep29);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep29);
        }
        {
            TypeIdentifierPair type_ids_dep30;
            ReturnCode_t return_code_dep30 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep30 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type30", type_ids_dep30);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep30)
            {
            ::register_Type30_type_identifier(type_ids_dep30);
            }
            StructMemberFlag member_flags_dep30 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep30 = 0x0000001e;
            bool common_dep30_ec {false};
            CommonStructMember common_dep30 {TypeObjectUtils::build_common_struct_member(member_id_dep30, member_flags_dep30, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep30, common_dep30_ec))};
            if (!common_dep30_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep30 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep30 = "dep30";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep30;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep30 = TypeObjectUtils::build_complete_member_detail(name_dep30, member_ann_builtin_dep30, ann_custom_TypeBig);
            CompleteStructMember member_dep30 = TypeObjectUtils::build_complete_struct_member(common_dep30, detail_dep30);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep30);
        }
        {
            TypeIdentifierPair type_ids_dep31;
            ReturnCode_t return_code_dep31 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep31 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type31", type_ids_dep31);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep31)
            {
            ::register_Type31_type_identifier(type_ids_dep31);
            }
            StructMemberFlag member_flags_dep31 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep31 = 0x0000001f;
            bool common_dep31_ec {false};
            CommonStructMember common_dep31 {TypeObjectUtils::build_common_struct_member(member_id_dep31, member_flags_dep31, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep31, common_dep31_ec))};
            if (!common_dep31_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep31 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep31 = "dep31";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep31;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep31 = TypeObjectUtils::build_complete_member_detail(name_dep31, member_ann_builtin_dep31, ann_custom_TypeBig);
            CompleteStructMember member_dep31 = TypeObjectUtils::build_complete_struct_member(common_dep31, detail_dep31);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep31);
        }
        {
            TypeIdentifierPair type_ids_dep32;
            ReturnCode_t return_code_dep32 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep32 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type32", type_ids_dep32);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep32)
            {
            ::register_Type32_type_identifier(type_ids_dep32);
            }
            StructMemberFlag member_flags_dep32 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep32 = 0x00000020;
            bool common_dep32_ec {false};
            CommonStructMember common_dep32 {TypeObjectUtils::build_common_struct_member(member_id_dep32, member_flags_dep32, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep32, common_dep32_ec))};
            if (!common_dep32_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep32 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep32 = "dep32";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep32;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep32 = TypeObjectUtils::build_complete_member_detail(name_dep32, member_ann_builtin_dep32, ann_custom_TypeBig);
            CompleteStructMember member_dep32 = TypeObjectUtils::build_complete_struct_member(common_dep32, detail_dep32);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep32);
        }
        {
            TypeIdentifierPair type_ids_dep33;
            ReturnCode_t return_code_dep33 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep33 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type33", type_ids_dep33);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep33)
            {
            ::register_Type33_type_identifier(type_ids_dep33);
            }
            StructMemberFlag member_flags_dep33 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep33 = 0x00000021;
            bool common_dep33_ec {false};
            CommonStructMember common_dep33 {TypeObjectUtils::build_common_struct_member(member_id_dep33, member_flags_dep33, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep33, common_dep33_ec))};
            if (!common_dep33_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep33 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep33 = "dep33";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep33;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep33 = TypeObjectUtils::build_complete_member_detail(name_dep33, member_ann_builtin_dep33, ann_custom_TypeBig);
            CompleteStructMember member_dep33 = TypeObjectUtils::build_complete_struct_member(common_dep33, detail_dep33);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep33);
        }
        {
            TypeIdentifierPair type_ids_dep34;
            ReturnCode_t return_code_dep34 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep34 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type34", type_ids_dep34);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep34)
            {
            ::register_Type34_type_identifier(type_ids_dep34);
            }
            StructMemberFlag member_flags_dep34 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep34 = 0x00000022;
            bool common_dep34_ec {false};
            CommonStructMember common_dep34 {TypeObjectUtils::build_common_struct_member(member_id_dep34, member_flags_dep34, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep34, common_dep34_ec))};
            if (!common_dep34_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep34 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep34 = "dep34";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep34;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep34 = TypeObjectUtils::build_complete_member_detail(name_dep34, member_ann_builtin_dep34, ann_custom_TypeBig);
            CompleteStructMember member_dep34 = TypeObjectUtils::build_complete_struct_member(common_dep34, detail_dep34);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep34);
        }
        {
            TypeIdentifierPair type_ids_dep35;
            ReturnCode_t return_code_dep35 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep35 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type35", type_ids_dep35);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep35)
            {
            ::register_Type35_type_identifier(type_ids_dep35);
            }
            StructMemberFlag member_flags_dep35 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep35 = 0x00000023;
            bool common_dep35_ec {false};
            CommonStructMember common_dep35 {TypeObjectUtils::build_common_struct_member(member_id_dep35, member_flags_dep35, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep35, common_dep35_ec))};
            if (!common_dep35_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep35 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep35 = "dep35";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep35;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep35 = TypeObjectUtils::build_complete_member_detail(name_dep35, member_ann_builtin_dep35, ann_custom_TypeBig);
            CompleteStructMember member_dep35 = TypeObjectUtils::build_complete_struct_member(common_dep35, detail_dep35);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep35);
        }
        {
            TypeIdentifierPair type_ids_dep36;
            ReturnCode_t return_code_dep36 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep36 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type36", type_ids_dep36);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep36)
            {
            ::register_Type36_type_identifier(type_ids_dep36);
            }
            StructMemberFlag member_flags_dep36 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep36 = 0x00000024;
            bool common_dep36_ec {false};
            CommonStructMember common_dep36 {TypeObjectUtils::build_common_struct_member(member_id_dep36, member_flags_dep36, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep36, common_dep36_ec))};
            if (!common_dep36_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep36 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep36 = "dep36";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep36;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep36 = TypeObjectUtils::build_complete_member_detail(name_dep36, member_ann_builtin_dep36, ann_custom_TypeBig);
            CompleteStructMember member_dep36 = TypeObjectUtils::build_complete_struct_member(common_dep36, detail_dep36);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep36);
        }
        {
            TypeIdentifierPair type_ids_dep37;
            ReturnCode_t return_code_dep37 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep37 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type37", type_ids_dep37);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep37)
            {
            ::register_Type37_type_identifier(type_ids_dep37);
            }
            StructMemberFlag member_flags_dep37 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep37 = 0x00000025;
            bool common_dep37_ec {false};
            CommonStructMember common_dep37 {TypeObjectUtils::build_common_struct_member(member_id_dep37, member_flags_dep37, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep37, common_dep37_ec))};
            if (!common_dep37_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep37 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep37 = "dep37";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep37;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep37 = TypeObjectUtils::build_complete_member_detail(name_dep37, member_ann_builtin_dep37, ann_custom_TypeBig);
            CompleteStructMember member_dep37 = TypeObjectUtils::build_complete_struct_member(common_dep37, detail_dep37);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep37);
        }
        {
            TypeIdentifierPair type_ids_dep38;
            ReturnCode_t return_code_dep38 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep38 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type38", type_ids_dep38);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep38)
            {
            ::register_Type38_type_identifier(type_ids_dep38);
            }
            StructMemberFlag member_flags_dep38 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep38 = 0x00000026;
            bool common_dep38_ec {false};
            CommonStructMember common_dep38 {TypeObjectUtils::build_common_struct_member(member_id_dep38, member_flags_dep38, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep38, common_dep38_ec))};
            if (!common_dep38_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep38 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep38 = "dep38";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep38;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep38 = TypeObjectUtils::build_complete_member_detail(name_dep38, member_ann_builtin_dep38, ann_custom_TypeBig);
            CompleteStructMember member_dep38 = TypeObjectUtils::build_complete_struct_member(common_dep38, detail_dep38);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep38);
        }
        {
            TypeIdentifierPair type_ids_dep39;
            ReturnCode_t return_code_dep39 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep39 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type39", type_ids_dep39);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep39)
            {
            ::register_Type39_type_identifier(type_ids_dep39);
            }
            StructMemberFlag member_flags_dep39 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep39 = 0x00000027;
            bool common_dep39_ec {false};
            CommonStructMember common_dep39 {TypeObjectUtils::build_common_struct_member(member_id_dep39, member_flags_dep39, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep39, common_dep39_ec))};
            if (!common_dep39_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep39 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep39 = "dep39";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep39;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep39 = TypeObjectUtils::build_complete_member_detail(name_dep39, member_ann_builtin_dep39, ann_custom_TypeBig);
            CompleteStructMember member_dep39 = TypeObjectUtils::build_complete_struct_member(common_dep39, detail_dep39);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep39);
        }
        {
            TypeIdentifierPair type_ids_dep40;
            ReturnCode_t return_code_dep40 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep40 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type40", type_ids_dep40);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep40)
            {
            ::register_Type40_type_identifier(type_ids_dep40);
            }
            StructMemberFlag member_flags_dep40 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep40 = 0x00000028;
            bool common_dep40_ec {false};
            CommonStructMember common_dep40 {TypeObjectUtils::build_common_struct_member(member_id_dep40, member_flags_dep40, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep40, common_dep40_ec))};
            if (!common_dep40_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep40 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep40 = "dep40";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep40;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep40 = TypeObjectUtils::build_complete_member_detail(name_dep40, member_ann_builtin_dep40, ann_custom_TypeBig);
            CompleteStructMember member_dep40 = TypeObjectUtils::build_complete_struct_member(common_dep40, detail_dep40);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep40);
        }
        {
            TypeIdentifierPair type_ids_dep41;
            ReturnCode_t return_code_dep41 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep41 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type41", type_ids_dep41);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep41)
            {
            ::register_Type41_type_identifier(type_ids_dep41);
            }
            StructMemberFlag member_flags_dep41 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep41 = 0x00000029;
            bool common_dep41_ec {false};
            CommonStructMember common_dep41 {TypeObjectUtils::build_common_struct_member(member_id_dep41, member_flags_dep41, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep41, common_dep41_ec))};
            if (!common_dep41_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep41 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep41 = "dep41";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep41;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep41 = TypeObjectUtils::build_complete_member_detail(name_dep41, member_ann_builtin_dep41, ann_custom_TypeBig);
            CompleteStructMember member_dep41 = TypeObjectUtils::build_complete_struct_member(common_dep41, detail_dep41);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep41);
        }
        {
            TypeIdentifierPair type_ids_dep42;
            ReturnCode_t return_code_dep42 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep42 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type42", type_ids_dep42);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep42)
            {
            ::register_Type42_type_identifier(type_ids_dep42);
            }
            StructMemberFlag member_flags_dep42 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep42 = 0x0000002a;
            bool common_dep42_ec {false};
            CommonStructMember common_dep42 {TypeObjectUtils::build_common_struct_member(member_id_dep42, member_flags_dep42, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep42, common_dep42_ec))};
            if (!common_dep42_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep42 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep42 = "dep42";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep42;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep42 = TypeObjectUtils::build_complete_member_detail(name_dep42, member_ann_builtin_dep42, ann_custom_TypeBig);
            CompleteStructMember member_dep42 = TypeObjectUtils::build_complete_struct_member(common_dep42, detail_dep42);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep42);
        }
        {
            TypeIdentifierPair type_ids_dep43;
            ReturnCode_t return_code_dep43 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep43 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type43", type_ids_dep43);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep43)
            {
            ::register_Type43_type_identifier(type_ids_dep43);
            }
            StructMemberFlag member_flags_dep43 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep43 = 0x0000002b;
            bool common_dep43_ec {false};
            CommonStructMember common_dep43 {TypeObjectUtils::build_common_struct_member(member_id_dep43, member_flags_dep43, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep43, common_dep43_ec))};
            if (!common_dep43_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep43 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep43 = "dep43";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep43;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep43 = TypeObjectUtils::build_complete_member_detail(name_dep43, member_ann_builtin_dep43, ann_custom_TypeBig);
            CompleteStructMember member_dep43 = TypeObjectUtils::build_complete_struct_member(common_dep43, detail_dep43);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep43);
        }
        {
            TypeIdentifierPair type_ids_dep44;
            ReturnCode_t return_code_dep44 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep44 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type44", type_ids_dep44);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep44)
            {
            ::register_Type44_type_identifier(type_ids_dep44);
            }
            StructMemberFlag member_flags_dep44 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep44 = 0x0000002c;
            bool common_dep44_ec {false};
            CommonStructMember common_dep44 {TypeObjectUtils::build_common_struct_member(member_id_dep44, member_flags_dep44, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep44, common_dep44_ec))};
            if (!common_dep44_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep44 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep44 = "dep44";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep44;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep44 = TypeObjectUtils::build_complete_member_detail(name_dep44, member_ann_builtin_dep44, ann_custom_TypeBig);
            CompleteStructMember member_dep44 = TypeObjectUtils::build_complete_struct_member(common_dep44, detail_dep44);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep44);
        }
        {
            TypeIdentifierPair type_ids_dep45;
            ReturnCode_t return_code_dep45 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep45 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type45", type_ids_dep45);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep45)
            {
            ::register_Type45_type_identifier(type_ids_dep45);
            }
            StructMemberFlag member_flags_dep45 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep45 = 0x0000002d;
            bool common_dep45_ec {false};
            CommonStructMember common_dep45 {TypeObjectUtils::build_common_struct_member(member_id_dep45, member_flags_dep45, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep45, common_dep45_ec))};
            if (!common_dep45_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep45 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep45 = "dep45";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep45;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep45 = TypeObjectUtils::build_complete_member_detail(name_dep45, member_ann_builtin_dep45, ann_custom_TypeBig);
            CompleteStructMember member_dep45 = TypeObjectUtils::build_complete_struct_member(common_dep45, detail_dep45);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep45);
        }
        {
            TypeIdentifierPair type_ids_dep46;
            ReturnCode_t return_code_dep46 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep46 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type46", type_ids_dep46);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep46)
            {
            ::register_Type46_type_identifier(type_ids_dep46);
            }
            StructMemberFlag member_flags_dep46 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep46 = 0x0000002e;
            bool common_dep46_ec {false};
            CommonStructMember common_dep46 {TypeObjectUtils::build_common_struct_member(member_id_dep46, member_flags_dep46, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep46, common_dep46_ec))};
            if (!common_dep46_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep46 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep46 = "dep46";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep46;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep46 = TypeObjectUtils::build_complete_member_detail(name_dep46, member_ann_builtin_dep46, ann_custom_TypeBig);
            CompleteStructMember member_dep46 = TypeObjectUtils::build_complete_struct_member(common_dep46, detail_dep46);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep46);
        }
        {
            TypeIdentifierPair type_ids_dep47;
            ReturnCode_t return_code_dep47 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep47 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type47", type_ids_dep47);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep47)
            {
            ::register_Type47_type_identifier(type_ids_dep47);
            }
            StructMemberFlag member_flags_dep47 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep47 = 0x0000002f;
            bool common_dep47_ec {false};
            CommonStructMember common_dep47 {TypeObjectUtils::build_common_struct_member(member_id_dep47, member_flags_dep47, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep47, common_dep47_ec))};
            if (!common_dep47_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep47 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep47 = "dep47";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep47;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep47 = TypeObjectUtils::build_complete_member_detail(name_dep47, member_ann_builtin_dep47, ann_custom_TypeBig);
            CompleteStructMember member_dep47 = TypeObjectUtils::build_complete_struct_member(common_dep47, detail_dep47);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep47);
        }
        {
            TypeIdentifierPair type_ids_dep48;
            ReturnCode_t return_code_dep48 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep48 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type48", type_ids_dep48);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep48)
            {
            ::register_Type48_type_identifier(type_ids_dep48);
            }
            StructMemberFlag member_flags_dep48 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep48 = 0x00000030;
            bool common_dep48_ec {false};
            CommonStructMember common_dep48 {TypeObjectUtils::build_common_struct_member(member_id_dep48, member_flags_dep48, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep48, common_dep48_ec))};
            if (!common_dep48_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep48 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep48 = "dep48";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep48;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep48 = TypeObjectUtils::build_complete_member_detail(name_dep48, member_ann_builtin_dep48, ann_custom_TypeBig);
            CompleteStructMember member_dep48 = TypeObjectUtils::build_complete_struct_member(common_dep48, detail_dep48);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep48);
        }
        {
            TypeIdentifierPair type_ids_dep49;
            ReturnCode_t return_code_dep49 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep49 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type49", type_ids_dep49);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep49)
            {
            ::register_Type49_type_identifier(type_ids_dep49);
            }
            StructMemberFlag member_flags_dep49 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep49 = 0x00000031;
            bool common_dep49_ec {false};
            CommonStructMember common_dep49 {TypeObjectUtils::build_common_struct_member(member_id_dep49, member_flags_dep49, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep49, common_dep49_ec))};
            if (!common_dep49_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep49 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep49 = "dep49";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep49;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep49 = TypeObjectUtils::build_complete_member_detail(name_dep49, member_ann_builtin_dep49, ann_custom_TypeBig);
            CompleteStructMember member_dep49 = TypeObjectUtils::build_complete_struct_member(common_dep49, detail_dep49);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep49);
        }
        {
            TypeIdentifierPair type_ids_dep50;
            ReturnCode_t return_code_dep50 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep50 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type50", type_ids_dep50);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep50)
            {
            ::register_Type50_type_identifier(type_ids_dep50);
            }
            StructMemberFlag member_flags_dep50 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep50 = 0x00000032;
            bool common_dep50_ec {false};
            CommonStructMember common_dep50 {TypeObjectUtils::build_common_struct_member(member_id_dep50, member_flags_dep50, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep50, common_dep50_ec))};
            if (!common_dep50_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep50 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep50 = "dep50";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep50;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep50 = TypeObjectUtils::build_complete_member_detail(name_dep50, member_ann_builtin_dep50, ann_custom_TypeBig);
            CompleteStructMember member_dep50 = TypeObjectUtils::build_complete_struct_member(common_dep50, detail_dep50);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep50);
        }
        {
            TypeIdentifierPair type_ids_dep51;
            ReturnCode_t return_code_dep51 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep51 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type51", type_ids_dep51);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep51)
            {
            ::register_Type51_type_identifier(type_ids_dep51);
            }
            StructMemberFlag member_flags_dep51 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep51 = 0x00000033;
            bool common_dep51_ec {false};
            CommonStructMember common_dep51 {TypeObjectUtils::build_common_struct_member(member_id_dep51, member_flags_dep51, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep51, common_dep51_ec))};
            if (!common_dep51_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep51 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep51 = "dep51";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep51;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep51 = TypeObjectUtils::build_complete_member_detail(name_dep51, member_ann_builtin_dep51, ann_custom_TypeBig);
            CompleteStructMember member_dep51 = TypeObjectUtils::build_complete_struct_member(common_dep51, detail_dep51);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep51);
        }
        {
            TypeIdentifierPair type_ids_dep52;
            ReturnCode_t return_code_dep52 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep52 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type52", type_ids_dep52);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep52)
            {
            ::register_Type52_type_identifier(type_ids_dep52);
            }
            StructMemberFlag member_flags_dep52 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep52 = 0x00000034;
            bool common_dep52_ec {false};
            CommonStructMember common_dep52 {TypeObjectUtils::build_common_struct_member(member_id_dep52, member_flags_dep52, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep52, common_dep52_ec))};
            if (!common_dep52_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep52 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep52 = "dep52";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep52;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep52 = TypeObjectUtils::build_complete_member_detail(name_dep52, member_ann_builtin_dep52, ann_custom_TypeBig);
            CompleteStructMember member_dep52 = TypeObjectUtils::build_complete_struct_member(common_dep52, detail_dep52);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep52);
        }
        {
            TypeIdentifierPair type_ids_dep53;
            ReturnCode_t return_code_dep53 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep53 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type53", type_ids_dep53);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep53)
            {
            ::register_Type53_type_identifier(type_ids_dep53);
            }
            StructMemberFlag member_flags_dep53 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep53 = 0x00000035;
            bool common_dep53_ec {false};
            CommonStructMember common_dep53 {TypeObjectUtils::build_common_struct_member(member_id_dep53, member_flags_dep53, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep53, common_dep53_ec))};
            if (!common_dep53_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep53 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep53 = "dep53";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep53;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep53 = TypeObjectUtils::build_complete_member_detail(name_dep53, member_ann_builtin_dep53, ann_custom_TypeBig);
            CompleteStructMember member_dep53 = TypeObjectUtils::build_complete_struct_member(common_dep53, detail_dep53);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep53);
        }
        {
            TypeIdentifierPair type_ids_dep54;
            ReturnCode_t return_code_dep54 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep54 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type54", type_ids_dep54);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep54)
            {
            ::register_Type54_type_identifier(type_ids_dep54);
            }
            StructMemberFlag member_flags_dep54 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep54 = 0x00000036;
            bool common_dep54_ec {false};
            CommonStructMember common_dep54 {TypeObjectUtils::build_common_struct_member(member_id_dep54, member_flags_dep54, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep54, common_dep54_ec))};
            if (!common_dep54_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep54 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep54 = "dep54";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep54;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep54 = TypeObjectUtils::build_complete_member_detail(name_dep54, member_ann_builtin_dep54, ann_custom_TypeBig);
            CompleteStructMember member_dep54 = TypeObjectUtils::build_complete_struct_member(common_dep54, detail_dep54);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep54);
        }
        {
            TypeIdentifierPair type_ids_dep55;
            ReturnCode_t return_code_dep55 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep55 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type55", type_ids_dep55);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep55)
            {
            ::register_Type55_type_identifier(type_ids_dep55);
            }
            StructMemberFlag member_flags_dep55 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep55 = 0x00000037;
            bool common_dep55_ec {false};
            CommonStructMember common_dep55 {TypeObjectUtils::build_common_struct_member(member_id_dep55, member_flags_dep55, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep55, common_dep55_ec))};
            if (!common_dep55_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep55 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep55 = "dep55";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep55;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep55 = TypeObjectUtils::build_complete_member_detail(name_dep55, member_ann_builtin_dep55, ann_custom_TypeBig);
            CompleteStructMember member_dep55 = TypeObjectUtils::build_complete_struct_member(common_dep55, detail_dep55);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep55);
        }
        {
            TypeIdentifierPair type_ids_dep56;
            ReturnCode_t return_code_dep56 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep56 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type56", type_ids_dep56);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep56)
            {
            ::register_Type56_type_identifier(type_ids_dep56);
            }
            StructMemberFlag member_flags_dep56 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep56 = 0x00000038;
            bool common_dep56_ec {false};
            CommonStructMember common_dep56 {TypeObjectUtils::build_common_struct_member(member_id_dep56, member_flags_dep56, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep56, common_dep56_ec))};
            if (!common_dep56_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep56 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep56 = "dep56";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep56;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep56 = TypeObjectUtils::build_complete_member_detail(name_dep56, member_ann_builtin_dep56, ann_custom_TypeBig);
            CompleteStructMember member_dep56 = TypeObjectUtils::build_complete_struct_member(common_dep56, detail_dep56);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep56);
        }
        {
            TypeIdentifierPair type_ids_dep57;
            ReturnCode_t return_code_dep57 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep57 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type57", type_ids_dep57);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep57)
            {
            ::register_Type57_type_identifier(type_ids_dep57);
            }
            StructMemberFlag member_flags_dep57 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep57 = 0x00000039;
            bool common_dep57_ec {false};
            CommonStructMember common_dep57 {TypeObjectUtils::build_common_struct_member(member_id_dep57, member_flags_dep57, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep57, common_dep57_ec))};
            if (!common_dep57_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep57 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep57 = "dep57";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep57;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep57 = TypeObjectUtils::build_complete_member_detail(name_dep57, member_ann_builtin_dep57, ann_custom_TypeBig);
            CompleteStructMember member_dep57 = TypeObjectUtils::build_complete_struct_member(common_dep57, detail_dep57);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep57);
        }
        {
            TypeIdentifierPair type_ids_dep58;
            ReturnCode_t return_code_dep58 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep58 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type58", type_ids_dep58);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep58)
            {
            ::register_Type58_type_identifier(type_ids_dep58);
            }
            StructMemberFlag member_flags_dep58 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep58 = 0x0000003a;
            bool common_dep58_ec {false};
            CommonStructMember common_dep58 {TypeObjectUtils::build_common_struct_member(member_id_dep58, member_flags_dep58, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep58, common_dep58_ec))};
            if (!common_dep58_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep58 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep58 = "dep58";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep58;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep58 = TypeObjectUtils::build_complete_member_detail(name_dep58, member_ann_builtin_dep58, ann_custom_TypeBig);
            CompleteStructMember member_dep58 = TypeObjectUtils::build_complete_struct_member(common_dep58, detail_dep58);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep58);
        }
        {
            TypeIdentifierPair type_ids_dep59;
            ReturnCode_t return_code_dep59 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep59 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type59", type_ids_dep59);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep59)
            {
            ::register_Type59_type_identifier(type_ids_dep59);
            }
            StructMemberFlag member_flags_dep59 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep59 = 0x0000003b;
            bool common_dep59_ec {false};
            CommonStructMember common_dep59 {TypeObjectUtils::build_common_struct_member(member_id_dep59, member_flags_dep59, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep59, common_dep59_ec))};
            if (!common_dep59_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep59 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep59 = "dep59";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep59;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep59 = TypeObjectUtils::build_complete_member_detail(name_dep59, member_ann_builtin_dep59, ann_custom_TypeBig);
            CompleteStructMember member_dep59 = TypeObjectUtils::build_complete_struct_member(common_dep59, detail_dep59);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep59);
        }
        {
            TypeIdentifierPair type_ids_dep60;
            ReturnCode_t return_code_dep60 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep60 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type60", type_ids_dep60);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep60)
            {
            ::register_Type60_type_identifier(type_ids_dep60);
            }
            StructMemberFlag member_flags_dep60 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep60 = 0x0000003c;
            bool common_dep60_ec {false};
            CommonStructMember common_dep60 {TypeObjectUtils::build_common_struct_member(member_id_dep60, member_flags_dep60, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep60, common_dep60_ec))};
            if (!common_dep60_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep60 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep60 = "dep60";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep60;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep60 = TypeObjectUtils::build_complete_member_detail(name_dep60, member_ann_builtin_dep60, ann_custom_TypeBig);
            CompleteStructMember member_dep60 = TypeObjectUtils::build_complete_struct_member(common_dep60, detail_dep60);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep60);
        }
        {
            TypeIdentifierPair type_ids_dep61;
            ReturnCode_t return_code_dep61 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep61 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type61", type_ids_dep61);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep61)
            {
            ::register_Type61_type_identifier(type_ids_dep61);
            }
            StructMemberFlag member_flags_dep61 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep61 = 0x0000003d;
            bool common_dep61_ec {false};
            CommonStructMember common_dep61 {TypeObjectUtils::build_common_struct_member(member_id_dep61, member_flags_dep61, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep61, common_dep61_ec))};
            if (!common_dep61_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep61 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep61 = "dep61";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep61;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep61 = TypeObjectUtils::build_complete_member_detail(name_dep61, member_ann_builtin_dep61, ann_custom_TypeBig);
            CompleteStructMember member_dep61 = TypeObjectUtils::build_complete_struct_member(common_dep61, detail_dep61);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep61);
        }
        {
            TypeIdentifierPair type_ids_dep62;
            ReturnCode_t return_code_dep62 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep62 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type62", type_ids_dep62);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep62)
            {
            ::register_Type62_type_identifier(type_ids_dep62);
            }
            StructMemberFlag member_flags_dep62 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep62 = 0x0000003e;
            bool common_dep62_ec {false};
            CommonStructMember common_dep62 {TypeObjectUtils::build_common_struct_member(member_id_dep62, member_flags_dep62, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep62, common_dep62_ec))};
            if (!common_dep62_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep62 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep62 = "dep62";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep62;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep62 = TypeObjectUtils::build_complete_member_detail(name_dep62, member_ann_builtin_dep62, ann_custom_TypeBig);
            CompleteStructMember member_dep62 = TypeObjectUtils::build_complete_struct_member(common_dep62, detail_dep62);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep62);
        }
        {
            TypeIdentifierPair type_ids_dep63;
            ReturnCode_t return_code_dep63 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep63 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type63", type_ids_dep63);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep63)
            {
            ::register_Type63_type_identifier(type_ids_dep63);
            }
            StructMemberFlag member_flags_dep63 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep63 = 0x0000003f;
            bool common_dep63_ec {false};
            CommonStructMember common_dep63 {TypeObjectUtils::build_common_struct_member(member_id_dep63, member_flags_dep63, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep63, common_dep63_ec))};
            if (!common_dep63_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep63 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep63 = "dep63";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep63;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep63 = TypeObjectUtils::build_complete_member_detail(name_dep63, member_ann_builtin_dep63, ann_custom_TypeBig);
            CompleteStructMember member_dep63 = TypeObjectUtils::build_complete_struct_member(common_dep63, detail_dep63);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep63);
        }
        {
            TypeIdentifierPair type_ids_dep64;
            ReturnCode_t return_code_dep64 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep64 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type64", type_ids_dep64);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep64)
            {
            ::register_Type64_type_identifier(type_ids_dep64);
            }
            StructMemberFlag member_flags_dep64 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep64 = 0x00000040;
            bool common_dep64_ec {false};
            CommonStructMember common_dep64 {TypeObjectUtils::build_common_struct_member(member_id_dep64, member_flags_dep64, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep64, common_dep64_ec))};
            if (!common_dep64_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep64 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep64 = "dep64";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep64;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep64 = TypeObjectUtils::build_complete_member_detail(name_dep64, member_ann_builtin_dep64, ann_custom_TypeBig);
            CompleteStructMember member_dep64 = TypeObjectUtils::build_complete_struct_member(common_dep64, detail_dep64);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep64);
        }
        {
            TypeIdentifierPair type_ids_dep65;
            ReturnCode_t return_code_dep65 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep65 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type65", type_ids_dep65);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep65)
            {
            ::register_Type65_type_identifier(type_ids_dep65);
            }
            StructMemberFlag member_flags_dep65 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep65 = 0x00000041;
            bool common_dep65_ec {false};
            CommonStructMember common_dep65 {TypeObjectUtils::build_common_struct_member(member_id_dep65, member_flags_dep65, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep65, common_dep65_ec))};
            if (!common_dep65_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep65 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep65 = "dep65";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep65;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep65 = TypeObjectUtils::build_complete_member_detail(name_dep65, member_ann_builtin_dep65, ann_custom_TypeBig);
            CompleteStructMember member_dep65 = TypeObjectUtils::build_complete_struct_member(common_dep65, detail_dep65);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep65);
        }
        {
            TypeIdentifierPair type_ids_dep66;
            ReturnCode_t return_code_dep66 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep66 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type66", type_ids_dep66);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep66)
            {
            ::register_Type66_type_identifier(type_ids_dep66);
            }
            StructMemberFlag member_flags_dep66 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep66 = 0x00000042;
            bool common_dep66_ec {false};
            CommonStructMember common_dep66 {TypeObjectUtils::build_common_struct_member(member_id_dep66, member_flags_dep66, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep66, common_dep66_ec))};
            if (!common_dep66_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep66 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep66 = "dep66";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep66;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep66 = TypeObjectUtils::build_complete_member_detail(name_dep66, member_ann_builtin_dep66, ann_custom_TypeBig);
            CompleteStructMember member_dep66 = TypeObjectUtils::build_complete_struct_member(common_dep66, detail_dep66);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep66);
        }
        {
            TypeIdentifierPair type_ids_dep67;
            ReturnCode_t return_code_dep67 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep67 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type67", type_ids_dep67);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep67)
            {
            ::register_Type67_type_identifier(type_ids_dep67);
            }
            StructMemberFlag member_flags_dep67 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep67 = 0x00000043;
            bool common_dep67_ec {false};
            CommonStructMember common_dep67 {TypeObjectUtils::build_common_struct_member(member_id_dep67, member_flags_dep67, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep67, common_dep67_ec))};
            if (!common_dep67_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep67 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep67 = "dep67";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep67;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep67 = TypeObjectUtils::build_complete_member_detail(name_dep67, member_ann_builtin_dep67, ann_custom_TypeBig);
            CompleteStructMember member_dep67 = TypeObjectUtils::build_complete_struct_member(common_dep67, detail_dep67);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep67);
        }
        {
            TypeIdentifierPair type_ids_dep68;
            ReturnCode_t return_code_dep68 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep68 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type68", type_ids_dep68);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep68)
            {
            ::register_Type68_type_identifier(type_ids_dep68);
            }
            StructMemberFlag member_flags_dep68 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep68 = 0x00000044;
            bool common_dep68_ec {false};
            CommonStructMember common_dep68 {TypeObjectUtils::build_common_struct_member(member_id_dep68, member_flags_dep68, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep68, common_dep68_ec))};
            if (!common_dep68_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep68 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep68 = "dep68";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep68;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep68 = TypeObjectUtils::build_complete_member_detail(name_dep68, member_ann_builtin_dep68, ann_custom_TypeBig);
            CompleteStructMember member_dep68 = TypeObjectUtils::build_complete_struct_member(common_dep68, detail_dep68);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep68);
        }
        {
            TypeIdentifierPair type_ids_dep69;
            ReturnCode_t return_code_dep69 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep69 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type69", type_ids_dep69);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep69)
            {
            ::register_Type69_type_identifier(type_ids_dep69);
            }
            StructMemberFlag member_flags_dep69 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep69 = 0x00000045;
            bool common_dep69_ec {false};
            CommonStructMember common_dep69 {TypeObjectUtils::build_common_struct_member(member_id_dep69, member_flags_dep69, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep69, common_dep69_ec))};
            if (!common_dep69_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep69 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep69 = "dep69";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep69;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep69 = TypeObjectUtils::build_complete_member_detail(name_dep69, member_ann_builtin_dep69, ann_custom_TypeBig);
            CompleteStructMember member_dep69 = TypeObjectUtils::build_complete_struct_member(common_dep69, detail_dep69);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep69);
        }
        {
            TypeIdentifierPair type_ids_dep70;
            ReturnCode_t return_code_dep70 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep70 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type70", type_ids_dep70);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep70)
            {
            ::register_Type70_type_identifier(type_ids_dep70);
            }
            StructMemberFlag member_flags_dep70 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep70 = 0x00000046;
            bool common_dep70_ec {false};
            CommonStructMember common_dep70 {TypeObjectUtils::build_common_struct_member(member_id_dep70, member_flags_dep70, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep70, common_dep70_ec))};
            if (!common_dep70_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep70 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep70 = "dep70";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep70;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep70 = TypeObjectUtils::build_complete_member_detail(name_dep70, member_ann_builtin_dep70, ann_custom_TypeBig);
            CompleteStructMember member_dep70 = TypeObjectUtils::build_complete_struct_member(common_dep70, detail_dep70);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep70);
        }
        {
            TypeIdentifierPair type_ids_dep71;
            ReturnCode_t return_code_dep71 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep71 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type71", type_ids_dep71);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep71)
            {
            ::register_Type71_type_identifier(type_ids_dep71);
            }
            StructMemberFlag member_flags_dep71 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep71 = 0x00000047;
            bool common_dep71_ec {false};
            CommonStructMember common_dep71 {TypeObjectUtils::build_common_struct_member(member_id_dep71, member_flags_dep71, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep71, common_dep71_ec))};
            if (!common_dep71_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep71 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep71 = "dep71";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep71;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep71 = TypeObjectUtils::build_complete_member_detail(name_dep71, member_ann_builtin_dep71, ann_custom_TypeBig);
            CompleteStructMember member_dep71 = TypeObjectUtils::build_complete_struct_member(common_dep71, detail_dep71);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep71);
        }
        {
            TypeIdentifierPair type_ids_dep72;
            ReturnCode_t return_code_dep72 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep72 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type72", type_ids_dep72);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep72)
            {
            ::register_Type72_type_identifier(type_ids_dep72);
            }
            StructMemberFlag member_flags_dep72 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep72 = 0x00000048;
            bool common_dep72_ec {false};
            CommonStructMember common_dep72 {TypeObjectUtils::build_common_struct_member(member_id_dep72, member_flags_dep72, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep72, common_dep72_ec))};
            if (!common_dep72_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep72 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep72 = "dep72";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep72;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep72 = TypeObjectUtils::build_complete_member_detail(name_dep72, member_ann_builtin_dep72, ann_custom_TypeBig);
            CompleteStructMember member_dep72 = TypeObjectUtils::build_complete_struct_member(common_dep72, detail_dep72);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep72);
        }
        {
            TypeIdentifierPair type_ids_dep73;
            ReturnCode_t return_code_dep73 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep73 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type73", type_ids_dep73);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep73)
            {
            ::register_Type73_type_identifier(type_ids_dep73);
            }
            StructMemberFlag member_flags_dep73 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep73 = 0x00000049;
            bool common_dep73_ec {false};
            CommonStructMember common_dep73 {TypeObjectUtils::build_common_struct_member(member_id_dep73, member_flags_dep73, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep73, common_dep73_ec))};
            if (!common_dep73_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep73 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep73 = "dep73";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep73;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep73 = TypeObjectUtils::build_complete_member_detail(name_dep73, member_ann_builtin_dep73, ann_custom_TypeBig);
            CompleteStructMember member_dep73 = TypeObjectUtils::build_complete_struct_member(common_dep73, detail_dep73);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep73);
        }
        {
            TypeIdentifierPair type_ids_dep74;
            ReturnCode_t return_code_dep74 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep74 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type74", type_ids_dep74);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep74)
            {
            ::register_Type74_type_identifier(type_ids_dep74);
            }
            StructMemberFlag member_flags_dep74 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep74 = 0x0000004a;
            bool common_dep74_ec {false};
            CommonStructMember common_dep74 {TypeObjectUtils::build_common_struct_member(member_id_dep74, member_flags_dep74, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep74, common_dep74_ec))};
            if (!common_dep74_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep74 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep74 = "dep74";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep74;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep74 = TypeObjectUtils::build_complete_member_detail(name_dep74, member_ann_builtin_dep74, ann_custom_TypeBig);
            CompleteStructMember member_dep74 = TypeObjectUtils::build_complete_struct_member(common_dep74, detail_dep74);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep74);
        }
        {
            TypeIdentifierPair type_ids_dep75;
            ReturnCode_t return_code_dep75 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep75 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type75", type_ids_dep75);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep75)
            {
            ::register_Type75_type_identifier(type_ids_dep75);
            }
            StructMemberFlag member_flags_dep75 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep75 = 0x0000004b;
            bool common_dep75_ec {false};
            CommonStructMember common_dep75 {TypeObjectUtils::build_common_struct_member(member_id_dep75, member_flags_dep75, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep75, common_dep75_ec))};
            if (!common_dep75_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep75 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep75 = "dep75";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep75;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep75 = TypeObjectUtils::build_complete_member_detail(name_dep75, member_ann_builtin_dep75, ann_custom_TypeBig);
            CompleteStructMember member_dep75 = TypeObjectUtils::build_complete_struct_member(common_dep75, detail_dep75);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep75);
        }
        {
            TypeIdentifierPair type_ids_dep76;
            ReturnCode_t return_code_dep76 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep76 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type76", type_ids_dep76);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep76)
            {
            ::register_Type76_type_identifier(type_ids_dep76);
            }
            StructMemberFlag member_flags_dep76 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep76 = 0x0000004c;
            bool common_dep76_ec {false};
            CommonStructMember common_dep76 {TypeObjectUtils::build_common_struct_member(member_id_dep76, member_flags_dep76, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep76, common_dep76_ec))};
            if (!common_dep76_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep76 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep76 = "dep76";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep76;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep76 = TypeObjectUtils::build_complete_member_detail(name_dep76, member_ann_builtin_dep76, ann_custom_TypeBig);
            CompleteStructMember member_dep76 = TypeObjectUtils::build_complete_struct_member(common_dep76, detail_dep76);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep76);
        }
        {
            TypeIdentifierPair type_ids_dep77;
            ReturnCode_t return_code_dep77 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep77 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type77", type_ids_dep77);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep77)
            {
            ::register_Type77_type_identifier(type_ids_dep77);
            }
            StructMemberFlag member_flags_dep77 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep77 = 0x0000004d;
            bool common_dep77_ec {false};
            CommonStructMember common_dep77 {TypeObjectUtils::build_common_struct_member(member_id_dep77, member_flags_dep77, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep77, common_dep77_ec))};
            if (!common_dep77_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep77 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep77 = "dep77";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep77;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep77 = TypeObjectUtils::build_complete_member_detail(name_dep77, member_ann_builtin_dep77, ann_custom_TypeBig);
            CompleteStructMember member_dep77 = TypeObjectUtils::build_complete_struct_member(common_dep77, detail_dep77);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep77);
        }
        {
            TypeIdentifierPair type_ids_dep78;
            ReturnCode_t return_code_dep78 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep78 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type78", type_ids_dep78);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep78)
            {
            ::register_Type78_type_identifier(type_ids_dep78);
            }
            StructMemberFlag member_flags_dep78 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep78 = 0x0000004e;
            bool common_dep78_ec {false};
            CommonStructMember common_dep78 {TypeObjectUtils::build_common_struct_member(member_id_dep78, member_flags_dep78, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep78, common_dep78_ec))};
            if (!common_dep78_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep78 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep78 = "dep78";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep78;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep78 = TypeObjectUtils::build_complete_member_detail(name_dep78, member_ann_builtin_dep78, ann_custom_TypeBig);
            CompleteStructMember member_dep78 = TypeObjectUtils::build_complete_struct_member(common_dep78, detail_dep78);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep78);
        }
        {
            TypeIdentifierPair type_ids_dep79;
            ReturnCode_t return_code_dep79 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep79 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type79", type_ids_dep79);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep79)
            {
            ::register_Type79_type_identifier(type_ids_dep79);
            }
            StructMemberFlag member_flags_dep79 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep79 = 0x0000004f;
            bool common_dep79_ec {false};
            CommonStructMember common_dep79 {TypeObjectUtils::build_common_struct_member(member_id_dep79, member_flags_dep79, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep79, common_dep79_ec))};
            if (!common_dep79_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep79 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep79 = "dep79";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep79;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep79 = TypeObjectUtils::build_complete_member_detail(name_dep79, member_ann_builtin_dep79, ann_custom_TypeBig);
            CompleteStructMember member_dep79 = TypeObjectUtils::build_complete_struct_member(common_dep79, detail_dep79);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep79);
        }
        {
            TypeIdentifierPair type_ids_dep80;
            ReturnCode_t return_code_dep80 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep80 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type80", type_ids_dep80);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep80)
            {
            ::register_Type80_type_identifier(type_ids_dep80);
            }
            StructMemberFlag member_flags_dep80 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep80 = 0x00000050;
            bool common_dep80_ec {false};
            CommonStructMember common_dep80 {TypeObjectUtils::build_common_struct_member(member_id_dep80, member_flags_dep80, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep80, common_dep80_ec))};
            if (!common_dep80_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep80 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep80 = "dep80";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep80;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep80 = TypeObjectUtils::build_complete_member_detail(name_dep80, member_ann_builtin_dep80, ann_custom_TypeBig);
            CompleteStructMember member_dep80 = TypeObjectUtils::build_complete_struct_member(common_dep80, detail_dep80);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep80);
        }
        {
            TypeIdentifierPair type_ids_dep81;
            ReturnCode_t return_code_dep81 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep81 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type81", type_ids_dep81);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep81)
            {
            ::register_Type81_type_identifier(type_ids_dep81);
            }
            StructMemberFlag member_flags_dep81 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep81 = 0x00000051;
            bool common_dep81_ec {false};
            CommonStructMember common_dep81 {TypeObjectUtils::build_common_struct_member(member_id_dep81, member_flags_dep81, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep81, common_dep81_ec))};
            if (!common_dep81_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep81 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep81 = "dep81";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep81;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep81 = TypeObjectUtils::build_complete_member_detail(name_dep81, member_ann_builtin_dep81, ann_custom_TypeBig);
            CompleteStructMember member_dep81 = TypeObjectUtils::build_complete_struct_member(common_dep81, detail_dep81);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep81);
        }
        {
            TypeIdentifierPair type_ids_dep82;
            ReturnCode_t return_code_dep82 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep82 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type82", type_ids_dep82);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep82)
            {
            ::register_Type82_type_identifier(type_ids_dep82);
            }
            StructMemberFlag member_flags_dep82 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep82 = 0x00000052;
            bool common_dep82_ec {false};
            CommonStructMember common_dep82 {TypeObjectUtils::build_common_struct_member(member_id_dep82, member_flags_dep82, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep82, common_dep82_ec))};
            if (!common_dep82_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep82 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep82 = "dep82";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep82;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep82 = TypeObjectUtils::build_complete_member_detail(name_dep82, member_ann_builtin_dep82, ann_custom_TypeBig);
            CompleteStructMember member_dep82 = TypeObjectUtils::build_complete_struct_member(common_dep82, detail_dep82);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep82);
        }
        {
            TypeIdentifierPair type_ids_dep83;
            ReturnCode_t return_code_dep83 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep83 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type83", type_ids_dep83);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep83)
            {
            ::register_Type83_type_identifier(type_ids_dep83);
            }
            StructMemberFlag member_flags_dep83 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep83 = 0x00000053;
            bool common_dep83_ec {false};
            CommonStructMember common_dep83 {TypeObjectUtils::build_common_struct_member(member_id_dep83, member_flags_dep83, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep83, common_dep83_ec))};
            if (!common_dep83_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep83 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep83 = "dep83";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep83;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep83 = TypeObjectUtils::build_complete_member_detail(name_dep83, member_ann_builtin_dep83, ann_custom_TypeBig);
            CompleteStructMember member_dep83 = TypeObjectUtils::build_complete_struct_member(common_dep83, detail_dep83);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep83);
        }
        {
            TypeIdentifierPair type_ids_dep84;
            ReturnCode_t return_code_dep84 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep84 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type84", type_ids_dep84);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep84)
            {
            ::register_Type84_type_identifier(type_ids_dep84);
            }
            StructMemberFlag member_flags_dep84 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep84 = 0x00000054;
            bool common_dep84_ec {false};
            CommonStructMember common_dep84 {TypeObjectUtils::build_common_struct_member(member_id_dep84, member_flags_dep84, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep84, common_dep84_ec))};
            if (!common_dep84_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep84 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep84 = "dep84";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep84;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep84 = TypeObjectUtils::build_complete_member_detail(name_dep84, member_ann_builtin_dep84, ann_custom_TypeBig);
            CompleteStructMember member_dep84 = TypeObjectUtils::build_complete_struct_member(common_dep84, detail_dep84);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep84);
        }
        {
            TypeIdentifierPair type_ids_dep85;
            ReturnCode_t return_code_dep85 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep85 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type85", type_ids_dep85);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep85)
            {
            ::register_Type85_type_identifier(type_ids_dep85);
            }
            StructMemberFlag member_flags_dep85 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep85 = 0x00000055;
            bool common_dep85_ec {false};
            CommonStructMember common_dep85 {TypeObjectUtils::build_common_struct_member(member_id_dep85, member_flags_dep85, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep85, common_dep85_ec))};
            if (!common_dep85_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep85 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep85 = "dep85";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep85;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep85 = TypeObjectUtils::build_complete_member_detail(name_dep85, member_ann_builtin_dep85, ann_custom_TypeBig);
            CompleteStructMember member_dep85 = TypeObjectUtils::build_complete_struct_member(common_dep85, detail_dep85);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep85);
        }
        {
            TypeIdentifierPair type_ids_dep86;
            ReturnCode_t return_code_dep86 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep86 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type86", type_ids_dep86);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep86)
            {
            ::register_Type86_type_identifier(type_ids_dep86);
            }
            StructMemberFlag member_flags_dep86 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep86 = 0x00000056;
            bool common_dep86_ec {false};
            CommonStructMember common_dep86 {TypeObjectUtils::build_common_struct_member(member_id_dep86, member_flags_dep86, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep86, common_dep86_ec))};
            if (!common_dep86_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep86 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep86 = "dep86";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep86;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep86 = TypeObjectUtils::build_complete_member_detail(name_dep86, member_ann_builtin_dep86, ann_custom_TypeBig);
            CompleteStructMember member_dep86 = TypeObjectUtils::build_complete_struct_member(common_dep86, detail_dep86);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep86);
        }
        {
            TypeIdentifierPair type_ids_dep87;
            ReturnCode_t return_code_dep87 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep87 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type87", type_ids_dep87);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep87)
            {
            ::register_Type87_type_identifier(type_ids_dep87);
            }
            StructMemberFlag member_flags_dep87 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep87 = 0x00000057;
            bool common_dep87_ec {false};
            CommonStructMember common_dep87 {TypeObjectUtils::build_common_struct_member(member_id_dep87, member_flags_dep87, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep87, common_dep87_ec))};
            if (!common_dep87_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep87 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep87 = "dep87";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep87;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep87 = TypeObjectUtils::build_complete_member_detail(name_dep87, member_ann_builtin_dep87, ann_custom_TypeBig);
            CompleteStructMember member_dep87 = TypeObjectUtils::build_complete_struct_member(common_dep87, detail_dep87);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep87);
        }
        {
            TypeIdentifierPair type_ids_dep88;
            ReturnCode_t return_code_dep88 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep88 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type88", type_ids_dep88);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep88)
            {
            ::register_Type88_type_identifier(type_ids_dep88);
            }
            StructMemberFlag member_flags_dep88 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep88 = 0x00000058;
            bool common_dep88_ec {false};
            CommonStructMember common_dep88 {TypeObjectUtils::build_common_struct_member(member_id_dep88, member_flags_dep88, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep88, common_dep88_ec))};
            if (!common_dep88_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep88 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep88 = "dep88";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep88;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep88 = TypeObjectUtils::build_complete_member_detail(name_dep88, member_ann_builtin_dep88, ann_custom_TypeBig);
            CompleteStructMember member_dep88 = TypeObjectUtils::build_complete_struct_member(common_dep88, detail_dep88);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep88);
        }
        {
            TypeIdentifierPair type_ids_dep89;
            ReturnCode_t return_code_dep89 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep89 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type89", type_ids_dep89);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep89)
            {
            ::register_Type89_type_identifier(type_ids_dep89);
            }
            StructMemberFlag member_flags_dep89 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep89 = 0x00000059;
            bool common_dep89_ec {false};
            CommonStructMember common_dep89 {TypeObjectUtils::build_common_struct_member(member_id_dep89, member_flags_dep89, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep89, common_dep89_ec))};
            if (!common_dep89_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep89 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep89 = "dep89";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep89;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep89 = TypeObjectUtils::build_complete_member_detail(name_dep89, member_ann_builtin_dep89, ann_custom_TypeBig);
            CompleteStructMember member_dep89 = TypeObjectUtils::build_complete_struct_member(common_dep89, detail_dep89);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep89);
        }
        {
            TypeIdentifierPair type_ids_dep90;
            ReturnCode_t return_code_dep90 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep90 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type90", type_ids_dep90);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep90)
            {
            ::register_Type90_type_identifier(type_ids_dep90);
            }
            StructMemberFlag member_flags_dep90 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep90 = 0x0000005a;
            bool common_dep90_ec {false};
            CommonStructMember common_dep90 {TypeObjectUtils::build_common_struct_member(member_id_dep90, member_flags_dep90, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep90, common_dep90_ec))};
            if (!common_dep90_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep90 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep90 = "dep90";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep90;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep90 = TypeObjectUtils::build_complete_member_detail(name_dep90, member_ann_builtin_dep90, ann_custom_TypeBig);
            CompleteStructMember member_dep90 = TypeObjectUtils::build_complete_struct_member(common_dep90, detail_dep90);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep90);
        }
        {
            TypeIdentifierPair type_ids_dep91;
            ReturnCode_t return_code_dep91 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep91 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type91", type_ids_dep91);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep91)
            {
            ::register_Type91_type_identifier(type_ids_dep91);
            }
            StructMemberFlag member_flags_dep91 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep91 = 0x0000005b;
            bool common_dep91_ec {false};
            CommonStructMember common_dep91 {TypeObjectUtils::build_common_struct_member(member_id_dep91, member_flags_dep91, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep91, common_dep91_ec))};
            if (!common_dep91_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep91 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep91 = "dep91";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep91;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep91 = TypeObjectUtils::build_complete_member_detail(name_dep91, member_ann_builtin_dep91, ann_custom_TypeBig);
            CompleteStructMember member_dep91 = TypeObjectUtils::build_complete_struct_member(common_dep91, detail_dep91);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep91);
        }
        {
            TypeIdentifierPair type_ids_dep92;
            ReturnCode_t return_code_dep92 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep92 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type92", type_ids_dep92);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep92)
            {
            ::register_Type92_type_identifier(type_ids_dep92);
            }
            StructMemberFlag member_flags_dep92 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep92 = 0x0000005c;
            bool common_dep92_ec {false};
            CommonStructMember common_dep92 {TypeObjectUtils::build_common_struct_member(member_id_dep92, member_flags_dep92, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep92, common_dep92_ec))};
            if (!common_dep92_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep92 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep92 = "dep92";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep92;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep92 = TypeObjectUtils::build_complete_member_detail(name_dep92, member_ann_builtin_dep92, ann_custom_TypeBig);
            CompleteStructMember member_dep92 = TypeObjectUtils::build_complete_struct_member(common_dep92, detail_dep92);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep92);
        }
        {
            TypeIdentifierPair type_ids_dep93;
            ReturnCode_t return_code_dep93 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep93 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type93", type_ids_dep93);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep93)
            {
            ::register_Type93_type_identifier(type_ids_dep93);
            }
            StructMemberFlag member_flags_dep93 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep93 = 0x0000005d;
            bool common_dep93_ec {false};
            CommonStructMember common_dep93 {TypeObjectUtils::build_common_struct_member(member_id_dep93, member_flags_dep93, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep93, common_dep93_ec))};
            if (!common_dep93_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep93 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep93 = "dep93";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep93;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep93 = TypeObjectUtils::build_complete_member_detail(name_dep93, member_ann_builtin_dep93, ann_custom_TypeBig);
            CompleteStructMember member_dep93 = TypeObjectUtils::build_complete_struct_member(common_dep93, detail_dep93);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep93);
        }
        {
            TypeIdentifierPair type_ids_dep94;
            ReturnCode_t return_code_dep94 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep94 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type94", type_ids_dep94);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep94)
            {
            ::register_Type94_type_identifier(type_ids_dep94);
            }
            StructMemberFlag member_flags_dep94 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep94 = 0x0000005e;
            bool common_dep94_ec {false};
            CommonStructMember common_dep94 {TypeObjectUtils::build_common_struct_member(member_id_dep94, member_flags_dep94, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep94, common_dep94_ec))};
            if (!common_dep94_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep94 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep94 = "dep94";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep94;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep94 = TypeObjectUtils::build_complete_member_detail(name_dep94, member_ann_builtin_dep94, ann_custom_TypeBig);
            CompleteStructMember member_dep94 = TypeObjectUtils::build_complete_struct_member(common_dep94, detail_dep94);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep94);
        }
        {
            TypeIdentifierPair type_ids_dep95;
            ReturnCode_t return_code_dep95 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep95 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type95", type_ids_dep95);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep95)
            {
            ::register_Type95_type_identifier(type_ids_dep95);
            }
            StructMemberFlag member_flags_dep95 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep95 = 0x0000005f;
            bool common_dep95_ec {false};
            CommonStructMember common_dep95 {TypeObjectUtils::build_common_struct_member(member_id_dep95, member_flags_dep95, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep95, common_dep95_ec))};
            if (!common_dep95_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep95 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep95 = "dep95";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep95;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep95 = TypeObjectUtils::build_complete_member_detail(name_dep95, member_ann_builtin_dep95, ann_custom_TypeBig);
            CompleteStructMember member_dep95 = TypeObjectUtils::build_complete_struct_member(common_dep95, detail_dep95);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep95);
        }
        {
            TypeIdentifierPair type_ids_dep96;
            ReturnCode_t return_code_dep96 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep96 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type96", type_ids_dep96);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep96)
            {
            ::register_Type96_type_identifier(type_ids_dep96);
            }
            StructMemberFlag member_flags_dep96 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep96 = 0x00000060;
            bool common_dep96_ec {false};
            CommonStructMember common_dep96 {TypeObjectUtils::build_common_struct_member(member_id_dep96, member_flags_dep96, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep96, common_dep96_ec))};
            if (!common_dep96_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep96 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep96 = "dep96";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep96;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep96 = TypeObjectUtils::build_complete_member_detail(name_dep96, member_ann_builtin_dep96, ann_custom_TypeBig);
            CompleteStructMember member_dep96 = TypeObjectUtils::build_complete_struct_member(common_dep96, detail_dep96);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep96);
        }
        {
            TypeIdentifierPair type_ids_dep97;
            ReturnCode_t return_code_dep97 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep97 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type97", type_ids_dep97);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep97)
            {
            ::register_Type97_type_identifier(type_ids_dep97);
            }
            StructMemberFlag member_flags_dep97 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep97 = 0x00000061;
            bool common_dep97_ec {false};
            CommonStructMember common_dep97 {TypeObjectUtils::build_common_struct_member(member_id_dep97, member_flags_dep97, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep97, common_dep97_ec))};
            if (!common_dep97_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep97 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep97 = "dep97";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep97;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep97 = TypeObjectUtils::build_complete_member_detail(name_dep97, member_ann_builtin_dep97, ann_custom_TypeBig);
            CompleteStructMember member_dep97 = TypeObjectUtils::build_complete_struct_member(common_dep97, detail_dep97);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep97);
        }
        {
            TypeIdentifierPair type_ids_dep98;
            ReturnCode_t return_code_dep98 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep98 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type98", type_ids_dep98);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep98)
            {
            ::register_Type98_type_identifier(type_ids_dep98);
            }
            StructMemberFlag member_flags_dep98 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep98 = 0x00000062;
            bool common_dep98_ec {false};
            CommonStructMember common_dep98 {TypeObjectUtils::build_common_struct_member(member_id_dep98, member_flags_dep98, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep98, common_dep98_ec))};
            if (!common_dep98_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep98 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep98 = "dep98";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep98;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep98 = TypeObjectUtils::build_complete_member_detail(name_dep98, member_ann_builtin_dep98, ann_custom_TypeBig);
            CompleteStructMember member_dep98 = TypeObjectUtils::build_complete_struct_member(common_dep98, detail_dep98);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep98);
        }
        {
            TypeIdentifierPair type_ids_dep99;
            ReturnCode_t return_code_dep99 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep99 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type99", type_ids_dep99);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep99)
            {
            ::register_Type99_type_identifier(type_ids_dep99);
            }
            StructMemberFlag member_flags_dep99 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep99 = 0x00000063;
            bool common_dep99_ec {false};
            CommonStructMember common_dep99 {TypeObjectUtils::build_common_struct_member(member_id_dep99, member_flags_dep99, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep99, common_dep99_ec))};
            if (!common_dep99_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep99 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep99 = "dep99";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep99;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep99 = TypeObjectUtils::build_complete_member_detail(name_dep99, member_ann_builtin_dep99, ann_custom_TypeBig);
            CompleteStructMember member_dep99 = TypeObjectUtils::build_complete_struct_member(common_dep99, detail_dep99);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep99);
        }
        {
            TypeIdentifierPair type_ids_dep100;
            ReturnCode_t return_code_dep100 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_dep100 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Type100", type_ids_dep100);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_dep100)
            {
            ::register_Type100_type_identifier(type_ids_dep100);
            }
            StructMemberFlag member_flags_dep100 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_dep100 = 0x00000064;
            bool common_dep100_ec {false};
            CommonStructMember common_dep100 {TypeObjectUtils::build_common_struct_member(member_id_dep100, member_flags_dep100, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_dep100, common_dep100_ec))};
            if (!common_dep100_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure dep100 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_dep100 = "dep100";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_dep100;
            ann_custom_TypeBig.reset();
            CompleteMemberDetail detail_dep100 = TypeObjectUtils::build_complete_member_detail(name_dep100, member_ann_builtin_dep100, ann_custom_TypeBig);
            CompleteStructMember member_dep100 = TypeObjectUtils::build_complete_struct_member(common_dep100, detail_dep100);
            TypeObjectUtils::add_complete_struct_member(member_seq_TypeBig, member_dep100);
        }
        CompleteStructType struct_type_TypeBig = TypeObjectUtils::build_complete_struct_type(struct_flags_TypeBig, header_TypeBig, member_seq_TypeBig);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_TypeBig, type_name_TypeBig.to_string(), type_ids_TypeBig))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "TypeBig already registered in TypeObjectRegistry for a different type.");
        }
    }
}

