//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armrecoveryservicesbackup

const (
	moduleName    = "github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/recoveryservices/armrecoveryservicesbackup"
	moduleVersion = "v3.1.0"
)

// AcquireStorageAccountLock - Whether storage account lock is to be acquired for this container or not.
type AcquireStorageAccountLock string

const (
	AcquireStorageAccountLockAcquire    AcquireStorageAccountLock = "Acquire"
	AcquireStorageAccountLockNotAcquire AcquireStorageAccountLock = "NotAcquire"
)

// PossibleAcquireStorageAccountLockValues returns the possible values for the AcquireStorageAccountLock const type.
func PossibleAcquireStorageAccountLockValues() []AcquireStorageAccountLock {
	return []AcquireStorageAccountLock{
		AcquireStorageAccountLockAcquire,
		AcquireStorageAccountLockNotAcquire,
	}
}

// AzureFileShareType - File Share type XSync or XSMB.
type AzureFileShareType string

const (
	AzureFileShareTypeInvalid AzureFileShareType = "Invalid"
	AzureFileShareTypeXSMB    AzureFileShareType = "XSMB"
	AzureFileShareTypeXSync   AzureFileShareType = "XSync"
)

// PossibleAzureFileShareTypeValues returns the possible values for the AzureFileShareType const type.
func PossibleAzureFileShareTypeValues() []AzureFileShareType {
	return []AzureFileShareType{
		AzureFileShareTypeInvalid,
		AzureFileShareTypeXSMB,
		AzureFileShareTypeXSync,
	}
}

// BackupEngineType - Type of the backup engine.
type BackupEngineType string

const (
	BackupEngineTypeAzureBackupServerEngine BackupEngineType = "AzureBackupServerEngine"
	BackupEngineTypeDpmBackupEngine         BackupEngineType = "DpmBackupEngine"
	BackupEngineTypeInvalid                 BackupEngineType = "Invalid"
)

// PossibleBackupEngineTypeValues returns the possible values for the BackupEngineType const type.
func PossibleBackupEngineTypeValues() []BackupEngineType {
	return []BackupEngineType{
		BackupEngineTypeAzureBackupServerEngine,
		BackupEngineTypeDpmBackupEngine,
		BackupEngineTypeInvalid,
	}
}

// BackupItemType - Type of backup items associated with this container.
type BackupItemType string

const (
	BackupItemTypeAzureFileShare    BackupItemType = "AzureFileShare"
	BackupItemTypeAzureSQLDb        BackupItemType = "AzureSqlDb"
	BackupItemTypeClient            BackupItemType = "Client"
	BackupItemTypeExchange          BackupItemType = "Exchange"
	BackupItemTypeFileFolder        BackupItemType = "FileFolder"
	BackupItemTypeGenericDataSource BackupItemType = "GenericDataSource"
	BackupItemTypeInvalid           BackupItemType = "Invalid"
	BackupItemTypeSAPAseDatabase    BackupItemType = "SAPAseDatabase"
	BackupItemTypeSAPHanaDBInstance BackupItemType = "SAPHanaDBInstance"
	BackupItemTypeSAPHanaDatabase   BackupItemType = "SAPHanaDatabase"
	BackupItemTypeSQLDB             BackupItemType = "SQLDB"
	BackupItemTypeSQLDataBase       BackupItemType = "SQLDataBase"
	BackupItemTypeSharepoint        BackupItemType = "Sharepoint"
	BackupItemTypeSystemState       BackupItemType = "SystemState"
	BackupItemTypeVM                BackupItemType = "VM"
	BackupItemTypeVMwareVM          BackupItemType = "VMwareVM"
)

// PossibleBackupItemTypeValues returns the possible values for the BackupItemType const type.
func PossibleBackupItemTypeValues() []BackupItemType {
	return []BackupItemType{
		BackupItemTypeAzureFileShare,
		BackupItemTypeAzureSQLDb,
		BackupItemTypeClient,
		BackupItemTypeExchange,
		BackupItemTypeFileFolder,
		BackupItemTypeGenericDataSource,
		BackupItemTypeInvalid,
		BackupItemTypeSAPAseDatabase,
		BackupItemTypeSAPHanaDBInstance,
		BackupItemTypeSAPHanaDatabase,
		BackupItemTypeSQLDB,
		BackupItemTypeSQLDataBase,
		BackupItemTypeSharepoint,
		BackupItemTypeSystemState,
		BackupItemTypeVM,
		BackupItemTypeVMwareVM,
	}
}

// BackupManagementType - Backup management type to execute the current job.
type BackupManagementType string

const (
	BackupManagementTypeAzureBackupServer BackupManagementType = "AzureBackupServer"
	BackupManagementTypeAzureIaasVM       BackupManagementType = "AzureIaasVM"
	BackupManagementTypeAzureSQL          BackupManagementType = "AzureSql"
	BackupManagementTypeAzureStorage      BackupManagementType = "AzureStorage"
	BackupManagementTypeAzureWorkload     BackupManagementType = "AzureWorkload"
	BackupManagementTypeDPM               BackupManagementType = "DPM"
	BackupManagementTypeDefaultBackup     BackupManagementType = "DefaultBackup"
	BackupManagementTypeInvalid           BackupManagementType = "Invalid"
	BackupManagementTypeMAB               BackupManagementType = "MAB"
)

// PossibleBackupManagementTypeValues returns the possible values for the BackupManagementType const type.
func PossibleBackupManagementTypeValues() []BackupManagementType {
	return []BackupManagementType{
		BackupManagementTypeAzureBackupServer,
		BackupManagementTypeAzureIaasVM,
		BackupManagementTypeAzureSQL,
		BackupManagementTypeAzureStorage,
		BackupManagementTypeAzureWorkload,
		BackupManagementTypeDPM,
		BackupManagementTypeDefaultBackup,
		BackupManagementTypeInvalid,
		BackupManagementTypeMAB,
	}
}

// BackupType - Type of backup, viz. Full, Differential, Log or CopyOnlyFull
type BackupType string

const (
	BackupTypeCopyOnlyFull         BackupType = "CopyOnlyFull"
	BackupTypeDifferential         BackupType = "Differential"
	BackupTypeFull                 BackupType = "Full"
	BackupTypeIncremental          BackupType = "Incremental"
	BackupTypeInvalid              BackupType = "Invalid"
	BackupTypeLog                  BackupType = "Log"
	BackupTypeSnapshotCopyOnlyFull BackupType = "SnapshotCopyOnlyFull"
	BackupTypeSnapshotFull         BackupType = "SnapshotFull"
)

// PossibleBackupTypeValues returns the possible values for the BackupType const type.
func PossibleBackupTypeValues() []BackupType {
	return []BackupType{
		BackupTypeCopyOnlyFull,
		BackupTypeDifferential,
		BackupTypeFull,
		BackupTypeIncremental,
		BackupTypeInvalid,
		BackupTypeLog,
		BackupTypeSnapshotCopyOnlyFull,
		BackupTypeSnapshotFull,
	}
}

// ContainerType - Type of container for filter
type ContainerType string

const (
	ContainerTypeAzureBackupServerContainer ContainerType = "AzureBackupServerContainer"
	ContainerTypeAzureSQLContainer          ContainerType = "AzureSqlContainer"
	ContainerTypeCluster                    ContainerType = "Cluster"
	ContainerTypeDPMContainer               ContainerType = "DPMContainer"
	ContainerTypeGenericContainer           ContainerType = "GenericContainer"
	ContainerTypeHanaHSRContainer           ContainerType = "HanaHSRContainer"
	ContainerTypeIaasVMContainer            ContainerType = "IaasVMContainer"
	ContainerTypeIaasVMServiceContainer     ContainerType = "IaasVMServiceContainer"
	ContainerTypeInvalid                    ContainerType = "Invalid"
	ContainerTypeMABContainer               ContainerType = "MABContainer"
	ContainerTypeSQLAGWorkLoadContainer     ContainerType = "SQLAGWorkLoadContainer"
	ContainerTypeStorageContainer           ContainerType = "StorageContainer"
	ContainerTypeUnknown                    ContainerType = "Unknown"
	ContainerTypeVCenter                    ContainerType = "VCenter"
	ContainerTypeVMAppContainer             ContainerType = "VMAppContainer"
	ContainerTypeWindows                    ContainerType = "Windows"
)

// PossibleContainerTypeValues returns the possible values for the ContainerType const type.
func PossibleContainerTypeValues() []ContainerType {
	return []ContainerType{
		ContainerTypeAzureBackupServerContainer,
		ContainerTypeAzureSQLContainer,
		ContainerTypeCluster,
		ContainerTypeDPMContainer,
		ContainerTypeGenericContainer,
		ContainerTypeHanaHSRContainer,
		ContainerTypeIaasVMContainer,
		ContainerTypeIaasVMServiceContainer,
		ContainerTypeInvalid,
		ContainerTypeMABContainer,
		ContainerTypeSQLAGWorkLoadContainer,
		ContainerTypeStorageContainer,
		ContainerTypeUnknown,
		ContainerTypeVCenter,
		ContainerTypeVMAppContainer,
		ContainerTypeWindows,
	}
}

// CopyOptions - Options to resolve copy conflicts.
type CopyOptions string

const (
	CopyOptionsCreateCopy     CopyOptions = "CreateCopy"
	CopyOptionsFailOnConflict CopyOptions = "FailOnConflict"
	CopyOptionsInvalid        CopyOptions = "Invalid"
	CopyOptionsOverwrite      CopyOptions = "Overwrite"
	CopyOptionsSkip           CopyOptions = "Skip"
)

// PossibleCopyOptionsValues returns the possible values for the CopyOptions const type.
func PossibleCopyOptionsValues() []CopyOptions {
	return []CopyOptions{
		CopyOptionsCreateCopy,
		CopyOptionsFailOnConflict,
		CopyOptionsInvalid,
		CopyOptionsOverwrite,
		CopyOptionsSkip,
	}
}

// CreateMode - Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
type CreateMode string

const (
	CreateModeDefault CreateMode = "Default"
	CreateModeInvalid CreateMode = "Invalid"
	CreateModeRecover CreateMode = "Recover"
)

// PossibleCreateModeValues returns the possible values for the CreateMode const type.
func PossibleCreateModeValues() []CreateMode {
	return []CreateMode{
		CreateModeDefault,
		CreateModeInvalid,
		CreateModeRecover,
	}
}

// DataMoveLevel - DataMove Level
type DataMoveLevel string

const (
	DataMoveLevelContainer DataMoveLevel = "Container"
	DataMoveLevelInvalid   DataMoveLevel = "Invalid"
	DataMoveLevelVault     DataMoveLevel = "Vault"
)

// PossibleDataMoveLevelValues returns the possible values for the DataMoveLevel const type.
func PossibleDataMoveLevelValues() []DataMoveLevel {
	return []DataMoveLevel{
		DataMoveLevelContainer,
		DataMoveLevelInvalid,
		DataMoveLevelVault,
	}
}

// DataSourceType - Type of workload this item represents.
type DataSourceType string

const (
	DataSourceTypeAzureFileShare    DataSourceType = "AzureFileShare"
	DataSourceTypeAzureSQLDb        DataSourceType = "AzureSqlDb"
	DataSourceTypeClient            DataSourceType = "Client"
	DataSourceTypeExchange          DataSourceType = "Exchange"
	DataSourceTypeFileFolder        DataSourceType = "FileFolder"
	DataSourceTypeGenericDataSource DataSourceType = "GenericDataSource"
	DataSourceTypeInvalid           DataSourceType = "Invalid"
	DataSourceTypeSAPAseDatabase    DataSourceType = "SAPAseDatabase"
	DataSourceTypeSAPHanaDBInstance DataSourceType = "SAPHanaDBInstance"
	DataSourceTypeSAPHanaDatabase   DataSourceType = "SAPHanaDatabase"
	DataSourceTypeSQLDB             DataSourceType = "SQLDB"
	DataSourceTypeSQLDataBase       DataSourceType = "SQLDataBase"
	DataSourceTypeSharepoint        DataSourceType = "Sharepoint"
	DataSourceTypeSystemState       DataSourceType = "SystemState"
	DataSourceTypeVM                DataSourceType = "VM"
	DataSourceTypeVMwareVM          DataSourceType = "VMwareVM"
)

// PossibleDataSourceTypeValues returns the possible values for the DataSourceType const type.
func PossibleDataSourceTypeValues() []DataSourceType {
	return []DataSourceType{
		DataSourceTypeAzureFileShare,
		DataSourceTypeAzureSQLDb,
		DataSourceTypeClient,
		DataSourceTypeExchange,
		DataSourceTypeFileFolder,
		DataSourceTypeGenericDataSource,
		DataSourceTypeInvalid,
		DataSourceTypeSAPAseDatabase,
		DataSourceTypeSAPHanaDBInstance,
		DataSourceTypeSAPHanaDatabase,
		DataSourceTypeSQLDB,
		DataSourceTypeSQLDataBase,
		DataSourceTypeSharepoint,
		DataSourceTypeSystemState,
		DataSourceTypeVM,
		DataSourceTypeVMwareVM,
	}
}

type DayOfWeek string

const (
	DayOfWeekFriday    DayOfWeek = "Friday"
	DayOfWeekMonday    DayOfWeek = "Monday"
	DayOfWeekSaturday  DayOfWeek = "Saturday"
	DayOfWeekSunday    DayOfWeek = "Sunday"
	DayOfWeekThursday  DayOfWeek = "Thursday"
	DayOfWeekTuesday   DayOfWeek = "Tuesday"
	DayOfWeekWednesday DayOfWeek = "Wednesday"
)

// PossibleDayOfWeekValues returns the possible values for the DayOfWeek const type.
func PossibleDayOfWeekValues() []DayOfWeek {
	return []DayOfWeek{
		DayOfWeekFriday,
		DayOfWeekMonday,
		DayOfWeekSaturday,
		DayOfWeekSunday,
		DayOfWeekThursday,
		DayOfWeekTuesday,
		DayOfWeekWednesday,
	}
}

// DedupState - Vault Dedup state
type DedupState string

const (
	DedupStateDisabled DedupState = "Disabled"
	DedupStateEnabled  DedupState = "Enabled"
	DedupStateInvalid  DedupState = "Invalid"
)

// PossibleDedupStateValues returns the possible values for the DedupState const type.
func PossibleDedupStateValues() []DedupState {
	return []DedupState{
		DedupStateDisabled,
		DedupStateEnabled,
		DedupStateInvalid,
	}
}

// EncryptionAtRestType - Encryption At Rest Type
type EncryptionAtRestType string

const (
	EncryptionAtRestTypeCustomerManaged  EncryptionAtRestType = "CustomerManaged"
	EncryptionAtRestTypeInvalid          EncryptionAtRestType = "Invalid"
	EncryptionAtRestTypeMicrosoftManaged EncryptionAtRestType = "MicrosoftManaged"
)

// PossibleEncryptionAtRestTypeValues returns the possible values for the EncryptionAtRestType const type.
func PossibleEncryptionAtRestTypeValues() []EncryptionAtRestType {
	return []EncryptionAtRestType{
		EncryptionAtRestTypeCustomerManaged,
		EncryptionAtRestTypeInvalid,
		EncryptionAtRestTypeMicrosoftManaged,
	}
}

// EnhancedSecurityState - Enabled or Disabled.
type EnhancedSecurityState string

const (
	EnhancedSecurityStateDisabled EnhancedSecurityState = "Disabled"
	EnhancedSecurityStateEnabled  EnhancedSecurityState = "Enabled"
	EnhancedSecurityStateInvalid  EnhancedSecurityState = "Invalid"
)

// PossibleEnhancedSecurityStateValues returns the possible values for the EnhancedSecurityState const type.
func PossibleEnhancedSecurityStateValues() []EnhancedSecurityState {
	return []EnhancedSecurityState{
		EnhancedSecurityStateDisabled,
		EnhancedSecurityStateEnabled,
		EnhancedSecurityStateInvalid,
	}
}

// FabricName - Specifies the fabric name - Azure or AD
type FabricName string

const (
	FabricNameAzure   FabricName = "Azure"
	FabricNameInvalid FabricName = "Invalid"
)

// PossibleFabricNameValues returns the possible values for the FabricName const type.
func PossibleFabricNameValues() []FabricName {
	return []FabricName{
		FabricNameAzure,
		FabricNameInvalid,
	}
}

// HTTPStatusCode - HTTP Status Code of the operation.
type HTTPStatusCode string

const (
	HTTPStatusCodeAccepted                     HTTPStatusCode = "Accepted"
	HTTPStatusCodeAmbiguous                    HTTPStatusCode = "Ambiguous"
	HTTPStatusCodeBadGateway                   HTTPStatusCode = "BadGateway"
	HTTPStatusCodeBadRequest                   HTTPStatusCode = "BadRequest"
	HTTPStatusCodeConflict                     HTTPStatusCode = "Conflict"
	HTTPStatusCodeContinue                     HTTPStatusCode = "Continue"
	HTTPStatusCodeCreated                      HTTPStatusCode = "Created"
	HTTPStatusCodeExpectationFailed            HTTPStatusCode = "ExpectationFailed"
	HTTPStatusCodeForbidden                    HTTPStatusCode = "Forbidden"
	HTTPStatusCodeFound                        HTTPStatusCode = "Found"
	HTTPStatusCodeGatewayTimeout               HTTPStatusCode = "GatewayTimeout"
	HTTPStatusCodeGone                         HTTPStatusCode = "Gone"
	HTTPStatusCodeHTTPVersionNotSupported      HTTPStatusCode = "HttpVersionNotSupported"
	HTTPStatusCodeInternalServerError          HTTPStatusCode = "InternalServerError"
	HTTPStatusCodeLengthRequired               HTTPStatusCode = "LengthRequired"
	HTTPStatusCodeMethodNotAllowed             HTTPStatusCode = "MethodNotAllowed"
	HTTPStatusCodeMoved                        HTTPStatusCode = "Moved"
	HTTPStatusCodeMovedPermanently             HTTPStatusCode = "MovedPermanently"
	HTTPStatusCodeMultipleChoices              HTTPStatusCode = "MultipleChoices"
	HTTPStatusCodeNoContent                    HTTPStatusCode = "NoContent"
	HTTPStatusCodeNonAuthoritativeInformation  HTTPStatusCode = "NonAuthoritativeInformation"
	HTTPStatusCodeNotAcceptable                HTTPStatusCode = "NotAcceptable"
	HTTPStatusCodeNotFound                     HTTPStatusCode = "NotFound"
	HTTPStatusCodeNotImplemented               HTTPStatusCode = "NotImplemented"
	HTTPStatusCodeNotModified                  HTTPStatusCode = "NotModified"
	HTTPStatusCodeOK                           HTTPStatusCode = "OK"
	HTTPStatusCodePartialContent               HTTPStatusCode = "PartialContent"
	HTTPStatusCodePaymentRequired              HTTPStatusCode = "PaymentRequired"
	HTTPStatusCodePreconditionFailed           HTTPStatusCode = "PreconditionFailed"
	HTTPStatusCodeProxyAuthenticationRequired  HTTPStatusCode = "ProxyAuthenticationRequired"
	HTTPStatusCodeRedirect                     HTTPStatusCode = "Redirect"
	HTTPStatusCodeRedirectKeepVerb             HTTPStatusCode = "RedirectKeepVerb"
	HTTPStatusCodeRedirectMethod               HTTPStatusCode = "RedirectMethod"
	HTTPStatusCodeRequestEntityTooLarge        HTTPStatusCode = "RequestEntityTooLarge"
	HTTPStatusCodeRequestTimeout               HTTPStatusCode = "RequestTimeout"
	HTTPStatusCodeRequestURITooLong            HTTPStatusCode = "RequestUriTooLong"
	HTTPStatusCodeRequestedRangeNotSatisfiable HTTPStatusCode = "RequestedRangeNotSatisfiable"
	HTTPStatusCodeResetContent                 HTTPStatusCode = "ResetContent"
	HTTPStatusCodeSeeOther                     HTTPStatusCode = "SeeOther"
	HTTPStatusCodeServiceUnavailable           HTTPStatusCode = "ServiceUnavailable"
	HTTPStatusCodeSwitchingProtocols           HTTPStatusCode = "SwitchingProtocols"
	HTTPStatusCodeTemporaryRedirect            HTTPStatusCode = "TemporaryRedirect"
	HTTPStatusCodeUnauthorized                 HTTPStatusCode = "Unauthorized"
	HTTPStatusCodeUnsupportedMediaType         HTTPStatusCode = "UnsupportedMediaType"
	HTTPStatusCodeUnused                       HTTPStatusCode = "Unused"
	HTTPStatusCodeUpgradeRequired              HTTPStatusCode = "UpgradeRequired"
	HTTPStatusCodeUseProxy                     HTTPStatusCode = "UseProxy"
)

// PossibleHTTPStatusCodeValues returns the possible values for the HTTPStatusCode const type.
func PossibleHTTPStatusCodeValues() []HTTPStatusCode {
	return []HTTPStatusCode{
		HTTPStatusCodeAccepted,
		HTTPStatusCodeAmbiguous,
		HTTPStatusCodeBadGateway,
		HTTPStatusCodeBadRequest,
		HTTPStatusCodeConflict,
		HTTPStatusCodeContinue,
		HTTPStatusCodeCreated,
		HTTPStatusCodeExpectationFailed,
		HTTPStatusCodeForbidden,
		HTTPStatusCodeFound,
		HTTPStatusCodeGatewayTimeout,
		HTTPStatusCodeGone,
		HTTPStatusCodeHTTPVersionNotSupported,
		HTTPStatusCodeInternalServerError,
		HTTPStatusCodeLengthRequired,
		HTTPStatusCodeMethodNotAllowed,
		HTTPStatusCodeMoved,
		HTTPStatusCodeMovedPermanently,
		HTTPStatusCodeMultipleChoices,
		HTTPStatusCodeNoContent,
		HTTPStatusCodeNonAuthoritativeInformation,
		HTTPStatusCodeNotAcceptable,
		HTTPStatusCodeNotFound,
		HTTPStatusCodeNotImplemented,
		HTTPStatusCodeNotModified,
		HTTPStatusCodeOK,
		HTTPStatusCodePartialContent,
		HTTPStatusCodePaymentRequired,
		HTTPStatusCodePreconditionFailed,
		HTTPStatusCodeProxyAuthenticationRequired,
		HTTPStatusCodeRedirect,
		HTTPStatusCodeRedirectKeepVerb,
		HTTPStatusCodeRedirectMethod,
		HTTPStatusCodeRequestEntityTooLarge,
		HTTPStatusCodeRequestTimeout,
		HTTPStatusCodeRequestURITooLong,
		HTTPStatusCodeRequestedRangeNotSatisfiable,
		HTTPStatusCodeResetContent,
		HTTPStatusCodeSeeOther,
		HTTPStatusCodeServiceUnavailable,
		HTTPStatusCodeSwitchingProtocols,
		HTTPStatusCodeTemporaryRedirect,
		HTTPStatusCodeUnauthorized,
		HTTPStatusCodeUnsupportedMediaType,
		HTTPStatusCodeUnused,
		HTTPStatusCodeUpgradeRequired,
		HTTPStatusCodeUseProxy,
	}
}

// HealthState - Health State for the backed up item.
type HealthState string

const (
	HealthStateActionRequired  HealthState = "ActionRequired"
	HealthStateActionSuggested HealthState = "ActionSuggested"
	HealthStateInvalid         HealthState = "Invalid"
	HealthStatePassed          HealthState = "Passed"
)

// PossibleHealthStateValues returns the possible values for the HealthState const type.
func PossibleHealthStateValues() []HealthState {
	return []HealthState{
		HealthStateActionRequired,
		HealthStateActionSuggested,
		HealthStateInvalid,
		HealthStatePassed,
	}
}

// HealthStatus - Health status of protected item.
type HealthStatus string

const (
	HealthStatusActionRequired  HealthStatus = "ActionRequired"
	HealthStatusActionSuggested HealthStatus = "ActionSuggested"
	HealthStatusInvalid         HealthStatus = "Invalid"
	HealthStatusPassed          HealthStatus = "Passed"
)

// PossibleHealthStatusValues returns the possible values for the HealthStatus const type.
func PossibleHealthStatusValues() []HealthStatus {
	return []HealthStatus{
		HealthStatusActionRequired,
		HealthStatusActionSuggested,
		HealthStatusInvalid,
		HealthStatusPassed,
	}
}

type IAASVMPolicyType string

const (
	IAASVMPolicyTypeInvalid IAASVMPolicyType = "Invalid"
	IAASVMPolicyTypeV1      IAASVMPolicyType = "V1"
	IAASVMPolicyTypeV2      IAASVMPolicyType = "V2"
)

// PossibleIAASVMPolicyTypeValues returns the possible values for the IAASVMPolicyType const type.
func PossibleIAASVMPolicyTypeValues() []IAASVMPolicyType {
	return []IAASVMPolicyType{
		IAASVMPolicyTypeInvalid,
		IAASVMPolicyTypeV1,
		IAASVMPolicyTypeV2,
	}
}

type InfrastructureEncryptionState string

const (
	InfrastructureEncryptionStateDisabled InfrastructureEncryptionState = "Disabled"
	InfrastructureEncryptionStateEnabled  InfrastructureEncryptionState = "Enabled"
	InfrastructureEncryptionStateInvalid  InfrastructureEncryptionState = "Invalid"
)

// PossibleInfrastructureEncryptionStateValues returns the possible values for the InfrastructureEncryptionState const type.
func PossibleInfrastructureEncryptionStateValues() []InfrastructureEncryptionState {
	return []InfrastructureEncryptionState{
		InfrastructureEncryptionStateDisabled,
		InfrastructureEncryptionStateEnabled,
		InfrastructureEncryptionStateInvalid,
	}
}

// InquiryStatus - Status of protectable item, i.e. InProgress,Succeeded,Failed
type InquiryStatus string

const (
	InquiryStatusFailed  InquiryStatus = "Failed"
	InquiryStatusInvalid InquiryStatus = "Invalid"
	InquiryStatusSuccess InquiryStatus = "Success"
)

// PossibleInquiryStatusValues returns the possible values for the InquiryStatus const type.
func PossibleInquiryStatusValues() []InquiryStatus {
	return []InquiryStatus{
		InquiryStatusFailed,
		InquiryStatusInvalid,
		InquiryStatusSuccess,
	}
}

// IntentItemType - Type of workload this item represents
type IntentItemType string

const (
	IntentItemTypeInvalid                       IntentItemType = "Invalid"
	IntentItemTypeSQLAvailabilityGroupContainer IntentItemType = "SQLAvailabilityGroupContainer"
	IntentItemTypeSQLInstance                   IntentItemType = "SQLInstance"
)

// PossibleIntentItemTypeValues returns the possible values for the IntentItemType const type.
func PossibleIntentItemTypeValues() []IntentItemType {
	return []IntentItemType{
		IntentItemTypeInvalid,
		IntentItemTypeSQLAvailabilityGroupContainer,
		IntentItemTypeSQLInstance,
	}
}

// JobOperationType - Type of operation.
type JobOperationType string

const (
	JobOperationTypeBackup                   JobOperationType = "Backup"
	JobOperationTypeConfigureBackup          JobOperationType = "ConfigureBackup"
	JobOperationTypeCrossRegionRestore       JobOperationType = "CrossRegionRestore"
	JobOperationTypeDeleteBackupData         JobOperationType = "DeleteBackupData"
	JobOperationTypeDisableBackup            JobOperationType = "DisableBackup"
	JobOperationTypeInvalid                  JobOperationType = "Invalid"
	JobOperationTypeRegister                 JobOperationType = "Register"
	JobOperationTypeRestore                  JobOperationType = "Restore"
	JobOperationTypeUnRegister               JobOperationType = "UnRegister"
	JobOperationTypeUndelete                 JobOperationType = "Undelete"
	JobOperationTypeUpdateCustomerManagedKey JobOperationType = "UpdateCustomerManagedKey"
)

// PossibleJobOperationTypeValues returns the possible values for the JobOperationType const type.
func PossibleJobOperationTypeValues() []JobOperationType {
	return []JobOperationType{
		JobOperationTypeBackup,
		JobOperationTypeConfigureBackup,
		JobOperationTypeCrossRegionRestore,
		JobOperationTypeDeleteBackupData,
		JobOperationTypeDisableBackup,
		JobOperationTypeInvalid,
		JobOperationTypeRegister,
		JobOperationTypeRestore,
		JobOperationTypeUnRegister,
		JobOperationTypeUndelete,
		JobOperationTypeUpdateCustomerManagedKey,
	}
}

// JobStatus - Status of the job.
type JobStatus string

const (
	JobStatusCancelled             JobStatus = "Cancelled"
	JobStatusCancelling            JobStatus = "Cancelling"
	JobStatusCompleted             JobStatus = "Completed"
	JobStatusCompletedWithWarnings JobStatus = "CompletedWithWarnings"
	JobStatusFailed                JobStatus = "Failed"
	JobStatusInProgress            JobStatus = "InProgress"
	JobStatusInvalid               JobStatus = "Invalid"
)

// PossibleJobStatusValues returns the possible values for the JobStatus const type.
func PossibleJobStatusValues() []JobStatus {
	return []JobStatus{
		JobStatusCancelled,
		JobStatusCancelling,
		JobStatusCompleted,
		JobStatusCompletedWithWarnings,
		JobStatusFailed,
		JobStatusInProgress,
		JobStatusInvalid,
	}
}

type JobSupportedAction string

const (
	JobSupportedActionCancellable JobSupportedAction = "Cancellable"
	JobSupportedActionInvalid     JobSupportedAction = "Invalid"
	JobSupportedActionRetriable   JobSupportedAction = "Retriable"
)

// PossibleJobSupportedActionValues returns the possible values for the JobSupportedAction const type.
func PossibleJobSupportedActionValues() []JobSupportedAction {
	return []JobSupportedAction{
		JobSupportedActionCancellable,
		JobSupportedActionInvalid,
		JobSupportedActionRetriable,
	}
}

// LastBackupStatus - Last backup operation status. Possible values: Healthy, Unhealthy.
type LastBackupStatus string

const (
	LastBackupStatusHealthy   LastBackupStatus = "Healthy"
	LastBackupStatusIRPending LastBackupStatus = "IRPending"
	LastBackupStatusInvalid   LastBackupStatus = "Invalid"
	LastBackupStatusUnhealthy LastBackupStatus = "Unhealthy"
)

// PossibleLastBackupStatusValues returns the possible values for the LastBackupStatus const type.
func PossibleLastBackupStatusValues() []LastBackupStatus {
	return []LastBackupStatus{
		LastBackupStatusHealthy,
		LastBackupStatusIRPending,
		LastBackupStatusInvalid,
		LastBackupStatusUnhealthy,
	}
}

type LastUpdateStatus string

const (
	LastUpdateStatusFailed              LastUpdateStatus = "Failed"
	LastUpdateStatusFirstInitialization LastUpdateStatus = "FirstInitialization"
	LastUpdateStatusInitialized         LastUpdateStatus = "Initialized"
	LastUpdateStatusInvalid             LastUpdateStatus = "Invalid"
	LastUpdateStatusNotEnabled          LastUpdateStatus = "NotEnabled"
	LastUpdateStatusPartiallyFailed     LastUpdateStatus = "PartiallyFailed"
	LastUpdateStatusPartiallySucceeded  LastUpdateStatus = "PartiallySucceeded"
	LastUpdateStatusSucceeded           LastUpdateStatus = "Succeeded"
)

// PossibleLastUpdateStatusValues returns the possible values for the LastUpdateStatus const type.
func PossibleLastUpdateStatusValues() []LastUpdateStatus {
	return []LastUpdateStatus{
		LastUpdateStatusFailed,
		LastUpdateStatusFirstInitialization,
		LastUpdateStatusInitialized,
		LastUpdateStatusInvalid,
		LastUpdateStatusNotEnabled,
		LastUpdateStatusPartiallyFailed,
		LastUpdateStatusPartiallySucceeded,
		LastUpdateStatusSucceeded,
	}
}

// MabServerType - Server type of MAB container.
type MabServerType string

const (
	MabServerTypeAzureBackupServerContainer MabServerType = "AzureBackupServerContainer"
	MabServerTypeAzureSQLContainer          MabServerType = "AzureSqlContainer"
	MabServerTypeCluster                    MabServerType = "Cluster"
	MabServerTypeDPMContainer               MabServerType = "DPMContainer"
	MabServerTypeGenericContainer           MabServerType = "GenericContainer"
	MabServerTypeIaasVMContainer            MabServerType = "IaasVMContainer"
	MabServerTypeIaasVMServiceContainer     MabServerType = "IaasVMServiceContainer"
	MabServerTypeInvalid                    MabServerType = "Invalid"
	MabServerTypeMABContainer               MabServerType = "MABContainer"
	MabServerTypeSQLAGWorkLoadContainer     MabServerType = "SQLAGWorkLoadContainer"
	MabServerTypeStorageContainer           MabServerType = "StorageContainer"
	MabServerTypeUnknown                    MabServerType = "Unknown"
	MabServerTypeVCenter                    MabServerType = "VCenter"
	MabServerTypeVMAppContainer             MabServerType = "VMAppContainer"
	MabServerTypeWindows                    MabServerType = "Windows"
)

// PossibleMabServerTypeValues returns the possible values for the MabServerType const type.
func PossibleMabServerTypeValues() []MabServerType {
	return []MabServerType{
		MabServerTypeAzureBackupServerContainer,
		MabServerTypeAzureSQLContainer,
		MabServerTypeCluster,
		MabServerTypeDPMContainer,
		MabServerTypeGenericContainer,
		MabServerTypeIaasVMContainer,
		MabServerTypeIaasVMServiceContainer,
		MabServerTypeInvalid,
		MabServerTypeMABContainer,
		MabServerTypeSQLAGWorkLoadContainer,
		MabServerTypeStorageContainer,
		MabServerTypeUnknown,
		MabServerTypeVCenter,
		MabServerTypeVMAppContainer,
		MabServerTypeWindows,
	}
}

type MonthOfYear string

const (
	MonthOfYearApril     MonthOfYear = "April"
	MonthOfYearAugust    MonthOfYear = "August"
	MonthOfYearDecember  MonthOfYear = "December"
	MonthOfYearFebruary  MonthOfYear = "February"
	MonthOfYearInvalid   MonthOfYear = "Invalid"
	MonthOfYearJanuary   MonthOfYear = "January"
	MonthOfYearJuly      MonthOfYear = "July"
	MonthOfYearJune      MonthOfYear = "June"
	MonthOfYearMarch     MonthOfYear = "March"
	MonthOfYearMay       MonthOfYear = "May"
	MonthOfYearNovember  MonthOfYear = "November"
	MonthOfYearOctober   MonthOfYear = "October"
	MonthOfYearSeptember MonthOfYear = "September"
)

// PossibleMonthOfYearValues returns the possible values for the MonthOfYear const type.
func PossibleMonthOfYearValues() []MonthOfYear {
	return []MonthOfYear{
		MonthOfYearApril,
		MonthOfYearAugust,
		MonthOfYearDecember,
		MonthOfYearFebruary,
		MonthOfYearInvalid,
		MonthOfYearJanuary,
		MonthOfYearJuly,
		MonthOfYearJune,
		MonthOfYearMarch,
		MonthOfYearMay,
		MonthOfYearNovember,
		MonthOfYearOctober,
		MonthOfYearSeptember,
	}
}

// OperationStatusValues - Operation status.
type OperationStatusValues string

const (
	OperationStatusValuesCanceled   OperationStatusValues = "Canceled"
	OperationStatusValuesFailed     OperationStatusValues = "Failed"
	OperationStatusValuesInProgress OperationStatusValues = "InProgress"
	OperationStatusValuesInvalid    OperationStatusValues = "Invalid"
	OperationStatusValuesSucceeded  OperationStatusValues = "Succeeded"
)

// PossibleOperationStatusValuesValues returns the possible values for the OperationStatusValues const type.
func PossibleOperationStatusValuesValues() []OperationStatusValues {
	return []OperationStatusValues{
		OperationStatusValuesCanceled,
		OperationStatusValuesFailed,
		OperationStatusValuesInProgress,
		OperationStatusValuesInvalid,
		OperationStatusValuesSucceeded,
	}
}

// OperationType - Re-Do Operation
type OperationType string

const (
	OperationTypeInvalid    OperationType = "Invalid"
	OperationTypeRegister   OperationType = "Register"
	OperationTypeReregister OperationType = "Reregister"
)

// PossibleOperationTypeValues returns the possible values for the OperationType const type.
func PossibleOperationTypeValues() []OperationType {
	return []OperationType{
		OperationTypeInvalid,
		OperationTypeRegister,
		OperationTypeReregister,
	}
}

// OverwriteOptions - Can Overwrite if Target DataBase already exists
type OverwriteOptions string

const (
	OverwriteOptionsFailOnConflict OverwriteOptions = "FailOnConflict"
	OverwriteOptionsInvalid        OverwriteOptions = "Invalid"
	OverwriteOptionsOverwrite      OverwriteOptions = "Overwrite"
)

// PossibleOverwriteOptionsValues returns the possible values for the OverwriteOptions const type.
func PossibleOverwriteOptionsValues() []OverwriteOptions {
	return []OverwriteOptions{
		OverwriteOptionsFailOnConflict,
		OverwriteOptionsInvalid,
		OverwriteOptionsOverwrite,
	}
}

// PolicyType - Type of backup policy type
type PolicyType string

const (
	PolicyTypeCopyOnlyFull         PolicyType = "CopyOnlyFull"
	PolicyTypeDifferential         PolicyType = "Differential"
	PolicyTypeFull                 PolicyType = "Full"
	PolicyTypeIncremental          PolicyType = "Incremental"
	PolicyTypeInvalid              PolicyType = "Invalid"
	PolicyTypeLog                  PolicyType = "Log"
	PolicyTypeSnapshotCopyOnlyFull PolicyType = "SnapshotCopyOnlyFull"
	PolicyTypeSnapshotFull         PolicyType = "SnapshotFull"
)

// PossiblePolicyTypeValues returns the possible values for the PolicyType const type.
func PossiblePolicyTypeValues() []PolicyType {
	return []PolicyType{
		PolicyTypeCopyOnlyFull,
		PolicyTypeDifferential,
		PolicyTypeFull,
		PolicyTypeIncremental,
		PolicyTypeInvalid,
		PolicyTypeLog,
		PolicyTypeSnapshotCopyOnlyFull,
		PolicyTypeSnapshotFull,
	}
}

// PrivateEndpointConnectionStatus - Gets or sets the status
type PrivateEndpointConnectionStatus string

const (
	PrivateEndpointConnectionStatusApproved     PrivateEndpointConnectionStatus = "Approved"
	PrivateEndpointConnectionStatusDisconnected PrivateEndpointConnectionStatus = "Disconnected"
	PrivateEndpointConnectionStatusPending      PrivateEndpointConnectionStatus = "Pending"
	PrivateEndpointConnectionStatusRejected     PrivateEndpointConnectionStatus = "Rejected"
)

// PossiblePrivateEndpointConnectionStatusValues returns the possible values for the PrivateEndpointConnectionStatus const type.
func PossiblePrivateEndpointConnectionStatusValues() []PrivateEndpointConnectionStatus {
	return []PrivateEndpointConnectionStatus{
		PrivateEndpointConnectionStatusApproved,
		PrivateEndpointConnectionStatusDisconnected,
		PrivateEndpointConnectionStatusPending,
		PrivateEndpointConnectionStatusRejected,
	}
}

// ProtectableContainerType - Type of the container. The value of this property for
// 1. Compute Azure VM is Microsoft.Compute/virtualMachines
// 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines
type ProtectableContainerType string

const (
	ProtectableContainerTypeAzureBackupServerContainer             ProtectableContainerType = "AzureBackupServerContainer"
	ProtectableContainerTypeAzureSQLContainer                      ProtectableContainerType = "AzureSqlContainer"
	ProtectableContainerTypeAzureWorkloadContainer                 ProtectableContainerType = "AzureWorkloadContainer"
	ProtectableContainerTypeCluster                                ProtectableContainerType = "Cluster"
	ProtectableContainerTypeDPMContainer                           ProtectableContainerType = "DPMContainer"
	ProtectableContainerTypeGenericContainer                       ProtectableContainerType = "GenericContainer"
	ProtectableContainerTypeIaasVMContainer                        ProtectableContainerType = "IaasVMContainer"
	ProtectableContainerTypeIaasVMServiceContainer                 ProtectableContainerType = "IaasVMServiceContainer"
	ProtectableContainerTypeInvalid                                ProtectableContainerType = "Invalid"
	ProtectableContainerTypeMABContainer                           ProtectableContainerType = "MABContainer"
	ProtectableContainerTypeMicrosoftClassicComputeVirtualMachines ProtectableContainerType = "Microsoft.ClassicCompute/virtualMachines"
	ProtectableContainerTypeMicrosoftComputeVirtualMachines        ProtectableContainerType = "Microsoft.Compute/virtualMachines"
	ProtectableContainerTypeSQLAGWorkLoadContainer                 ProtectableContainerType = "SQLAGWorkLoadContainer"
	ProtectableContainerTypeStorageContainer                       ProtectableContainerType = "StorageContainer"
	ProtectableContainerTypeUnknown                                ProtectableContainerType = "Unknown"
	ProtectableContainerTypeVCenter                                ProtectableContainerType = "VCenter"
	ProtectableContainerTypeVMAppContainer                         ProtectableContainerType = "VMAppContainer"
	ProtectableContainerTypeWindows                                ProtectableContainerType = "Windows"
)

// PossibleProtectableContainerTypeValues returns the possible values for the ProtectableContainerType const type.
func PossibleProtectableContainerTypeValues() []ProtectableContainerType {
	return []ProtectableContainerType{
		ProtectableContainerTypeAzureBackupServerContainer,
		ProtectableContainerTypeAzureSQLContainer,
		ProtectableContainerTypeAzureWorkloadContainer,
		ProtectableContainerTypeCluster,
		ProtectableContainerTypeDPMContainer,
		ProtectableContainerTypeGenericContainer,
		ProtectableContainerTypeIaasVMContainer,
		ProtectableContainerTypeIaasVMServiceContainer,
		ProtectableContainerTypeInvalid,
		ProtectableContainerTypeMABContainer,
		ProtectableContainerTypeMicrosoftClassicComputeVirtualMachines,
		ProtectableContainerTypeMicrosoftComputeVirtualMachines,
		ProtectableContainerTypeSQLAGWorkLoadContainer,
		ProtectableContainerTypeStorageContainer,
		ProtectableContainerTypeUnknown,
		ProtectableContainerTypeVCenter,
		ProtectableContainerTypeVMAppContainer,
		ProtectableContainerTypeWindows,
	}
}

// ProtectedItemHealthStatus - Health status of the backup item, evaluated based on last heartbeat received
type ProtectedItemHealthStatus string

const (
	ProtectedItemHealthStatusHealthy      ProtectedItemHealthStatus = "Healthy"
	ProtectedItemHealthStatusIRPending    ProtectedItemHealthStatus = "IRPending"
	ProtectedItemHealthStatusInvalid      ProtectedItemHealthStatus = "Invalid"
	ProtectedItemHealthStatusNotReachable ProtectedItemHealthStatus = "NotReachable"
	ProtectedItemHealthStatusUnhealthy    ProtectedItemHealthStatus = "Unhealthy"
)

// PossibleProtectedItemHealthStatusValues returns the possible values for the ProtectedItemHealthStatus const type.
func PossibleProtectedItemHealthStatusValues() []ProtectedItemHealthStatus {
	return []ProtectedItemHealthStatus{
		ProtectedItemHealthStatusHealthy,
		ProtectedItemHealthStatusIRPending,
		ProtectedItemHealthStatusInvalid,
		ProtectedItemHealthStatusNotReachable,
		ProtectedItemHealthStatusUnhealthy,
	}
}

// ProtectedItemState - Backup state of the backed up item.
type ProtectedItemState string

const (
	ProtectedItemStateBackupsSuspended  ProtectedItemState = "BackupsSuspended"
	ProtectedItemStateIRPending         ProtectedItemState = "IRPending"
	ProtectedItemStateInvalid           ProtectedItemState = "Invalid"
	ProtectedItemStateProtected         ProtectedItemState = "Protected"
	ProtectedItemStateProtectionError   ProtectedItemState = "ProtectionError"
	ProtectedItemStateProtectionPaused  ProtectedItemState = "ProtectionPaused"
	ProtectedItemStateProtectionStopped ProtectedItemState = "ProtectionStopped"
)

// PossibleProtectedItemStateValues returns the possible values for the ProtectedItemState const type.
func PossibleProtectedItemStateValues() []ProtectedItemState {
	return []ProtectedItemState{
		ProtectedItemStateBackupsSuspended,
		ProtectedItemStateIRPending,
		ProtectedItemStateInvalid,
		ProtectedItemStateProtected,
		ProtectedItemStateProtectionError,
		ProtectedItemStateProtectionPaused,
		ProtectedItemStateProtectionStopped,
	}
}

// ProtectionIntentItemType - backup protectionIntent type.
type ProtectionIntentItemType string

const (
	ProtectionIntentItemTypeAzureResourceItem                          ProtectionIntentItemType = "AzureResourceItem"
	ProtectionIntentItemTypeAzureWorkloadAutoProtectionIntent          ProtectionIntentItemType = "AzureWorkloadAutoProtectionIntent"
	ProtectionIntentItemTypeAzureWorkloadContainerAutoProtectionIntent ProtectionIntentItemType = "AzureWorkloadContainerAutoProtectionIntent"
	ProtectionIntentItemTypeAzureWorkloadSQLAutoProtectionIntent       ProtectionIntentItemType = "AzureWorkloadSQLAutoProtectionIntent"
	ProtectionIntentItemTypeInvalid                                    ProtectionIntentItemType = "Invalid"
	ProtectionIntentItemTypeRecoveryServiceVaultItem                   ProtectionIntentItemType = "RecoveryServiceVaultItem"
)

// PossibleProtectionIntentItemTypeValues returns the possible values for the ProtectionIntentItemType const type.
func PossibleProtectionIntentItemTypeValues() []ProtectionIntentItemType {
	return []ProtectionIntentItemType{
		ProtectionIntentItemTypeAzureResourceItem,
		ProtectionIntentItemTypeAzureWorkloadAutoProtectionIntent,
		ProtectionIntentItemTypeAzureWorkloadContainerAutoProtectionIntent,
		ProtectionIntentItemTypeAzureWorkloadSQLAutoProtectionIntent,
		ProtectionIntentItemTypeInvalid,
		ProtectionIntentItemTypeRecoveryServiceVaultItem,
	}
}

// ProtectionState - Backup state of this backup item.
type ProtectionState string

const (
	ProtectionStateBackupsSuspended  ProtectionState = "BackupsSuspended"
	ProtectionStateIRPending         ProtectionState = "IRPending"
	ProtectionStateInvalid           ProtectionState = "Invalid"
	ProtectionStateProtected         ProtectionState = "Protected"
	ProtectionStateProtectionError   ProtectionState = "ProtectionError"
	ProtectionStateProtectionPaused  ProtectionState = "ProtectionPaused"
	ProtectionStateProtectionStopped ProtectionState = "ProtectionStopped"
)

// PossibleProtectionStateValues returns the possible values for the ProtectionState const type.
func PossibleProtectionStateValues() []ProtectionState {
	return []ProtectionState{
		ProtectionStateBackupsSuspended,
		ProtectionStateIRPending,
		ProtectionStateInvalid,
		ProtectionStateProtected,
		ProtectionStateProtectionError,
		ProtectionStateProtectionPaused,
		ProtectionStateProtectionStopped,
	}
}

// ProtectionStatus - Specifies whether the container is registered or not
type ProtectionStatus string

const (
	ProtectionStatusInvalid          ProtectionStatus = "Invalid"
	ProtectionStatusNotProtected     ProtectionStatus = "NotProtected"
	ProtectionStatusProtected        ProtectionStatus = "Protected"
	ProtectionStatusProtecting       ProtectionStatus = "Protecting"
	ProtectionStatusProtectionFailed ProtectionStatus = "ProtectionFailed"
)

// PossibleProtectionStatusValues returns the possible values for the ProtectionStatus const type.
func PossibleProtectionStatusValues() []ProtectionStatus {
	return []ProtectionStatus{
		ProtectionStatusInvalid,
		ProtectionStatusNotProtected,
		ProtectionStatusProtected,
		ProtectionStatusProtecting,
		ProtectionStatusProtectionFailed,
	}
}

// ProvisioningState - Gets or sets provisioning state of the private endpoint connection
type ProvisioningState string

const (
	ProvisioningStateDeleting  ProvisioningState = "Deleting"
	ProvisioningStateFailed    ProvisioningState = "Failed"
	ProvisioningStatePending   ProvisioningState = "Pending"
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns the possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{
		ProvisioningStateDeleting,
		ProvisioningStateFailed,
		ProvisioningStatePending,
		ProvisioningStateSucceeded,
	}
}

// RecoveryMode - Defines whether the current recovery mode is file restore or database restore
type RecoveryMode string

const (
	RecoveryModeFileRecovery     RecoveryMode = "FileRecovery"
	RecoveryModeInvalid          RecoveryMode = "Invalid"
	RecoveryModeWorkloadRecovery RecoveryMode = "WorkloadRecovery"
)

// PossibleRecoveryModeValues returns the possible values for the RecoveryMode const type.
func PossibleRecoveryModeValues() []RecoveryMode {
	return []RecoveryMode{
		RecoveryModeFileRecovery,
		RecoveryModeInvalid,
		RecoveryModeWorkloadRecovery,
	}
}

// RecoveryPointTierStatus - Recovery point tier status.
type RecoveryPointTierStatus string

const (
	RecoveryPointTierStatusDeleted    RecoveryPointTierStatus = "Deleted"
	RecoveryPointTierStatusDisabled   RecoveryPointTierStatus = "Disabled"
	RecoveryPointTierStatusInvalid    RecoveryPointTierStatus = "Invalid"
	RecoveryPointTierStatusRehydrated RecoveryPointTierStatus = "Rehydrated"
	RecoveryPointTierStatusValid      RecoveryPointTierStatus = "Valid"
)

// PossibleRecoveryPointTierStatusValues returns the possible values for the RecoveryPointTierStatus const type.
func PossibleRecoveryPointTierStatusValues() []RecoveryPointTierStatus {
	return []RecoveryPointTierStatus{
		RecoveryPointTierStatusDeleted,
		RecoveryPointTierStatusDisabled,
		RecoveryPointTierStatusInvalid,
		RecoveryPointTierStatusRehydrated,
		RecoveryPointTierStatusValid,
	}
}

// RecoveryPointTierType - Recovery point tier type.
type RecoveryPointTierType string

const (
	RecoveryPointTierTypeArchivedRP RecoveryPointTierType = "ArchivedRP"
	RecoveryPointTierTypeHardenedRP RecoveryPointTierType = "HardenedRP"
	RecoveryPointTierTypeInstantRP  RecoveryPointTierType = "InstantRP"
	RecoveryPointTierTypeInvalid    RecoveryPointTierType = "Invalid"
)

// PossibleRecoveryPointTierTypeValues returns the possible values for the RecoveryPointTierType const type.
func PossibleRecoveryPointTierTypeValues() []RecoveryPointTierType {
	return []RecoveryPointTierType{
		RecoveryPointTierTypeArchivedRP,
		RecoveryPointTierTypeHardenedRP,
		RecoveryPointTierTypeInstantRP,
		RecoveryPointTierTypeInvalid,
	}
}

// RecoveryType - Type of this recovery.
type RecoveryType string

const (
	RecoveryTypeAlternateLocation RecoveryType = "AlternateLocation"
	RecoveryTypeInvalid           RecoveryType = "Invalid"
	RecoveryTypeOffline           RecoveryType = "Offline"
	RecoveryTypeOriginalLocation  RecoveryType = "OriginalLocation"
	RecoveryTypeRestoreDisks      RecoveryType = "RestoreDisks"
)

// PossibleRecoveryTypeValues returns the possible values for the RecoveryType const type.
func PossibleRecoveryTypeValues() []RecoveryType {
	return []RecoveryType{
		RecoveryTypeAlternateLocation,
		RecoveryTypeInvalid,
		RecoveryTypeOffline,
		RecoveryTypeOriginalLocation,
		RecoveryTypeRestoreDisks,
	}
}

// RehydrationPriority - Rehydration Priority
type RehydrationPriority string

const (
	RehydrationPriorityHigh     RehydrationPriority = "High"
	RehydrationPriorityStandard RehydrationPriority = "Standard"
)

// PossibleRehydrationPriorityValues returns the possible values for the RehydrationPriority const type.
func PossibleRehydrationPriorityValues() []RehydrationPriority {
	return []RehydrationPriority{
		RehydrationPriorityHigh,
		RehydrationPriorityStandard,
	}
}

// ResourceHealthStatus - Resource Health Status
type ResourceHealthStatus string

const (
	ResourceHealthStatusHealthy             ResourceHealthStatus = "Healthy"
	ResourceHealthStatusInvalid             ResourceHealthStatus = "Invalid"
	ResourceHealthStatusPersistentDegraded  ResourceHealthStatus = "PersistentDegraded"
	ResourceHealthStatusPersistentUnhealthy ResourceHealthStatus = "PersistentUnhealthy"
	ResourceHealthStatusTransientDegraded   ResourceHealthStatus = "TransientDegraded"
	ResourceHealthStatusTransientUnhealthy  ResourceHealthStatus = "TransientUnhealthy"
)

// PossibleResourceHealthStatusValues returns the possible values for the ResourceHealthStatus const type.
func PossibleResourceHealthStatusValues() []ResourceHealthStatus {
	return []ResourceHealthStatus{
		ResourceHealthStatusHealthy,
		ResourceHealthStatusInvalid,
		ResourceHealthStatusPersistentDegraded,
		ResourceHealthStatusPersistentUnhealthy,
		ResourceHealthStatusTransientDegraded,
		ResourceHealthStatusTransientUnhealthy,
	}
}

// RestorePointQueryType - RestorePoint type
type RestorePointQueryType string

const (
	RestorePointQueryTypeAll                  RestorePointQueryType = "All"
	RestorePointQueryTypeDifferential         RestorePointQueryType = "Differential"
	RestorePointQueryTypeFull                 RestorePointQueryType = "Full"
	RestorePointQueryTypeFullAndDifferential  RestorePointQueryType = "FullAndDifferential"
	RestorePointQueryTypeIncremental          RestorePointQueryType = "Incremental"
	RestorePointQueryTypeInvalid              RestorePointQueryType = "Invalid"
	RestorePointQueryTypeLog                  RestorePointQueryType = "Log"
	RestorePointQueryTypeSnapshotCopyOnlyFull RestorePointQueryType = "SnapshotCopyOnlyFull"
	RestorePointQueryTypeSnapshotFull         RestorePointQueryType = "SnapshotFull"
)

// PossibleRestorePointQueryTypeValues returns the possible values for the RestorePointQueryType const type.
func PossibleRestorePointQueryTypeValues() []RestorePointQueryType {
	return []RestorePointQueryType{
		RestorePointQueryTypeAll,
		RestorePointQueryTypeDifferential,
		RestorePointQueryTypeFull,
		RestorePointQueryTypeFullAndDifferential,
		RestorePointQueryTypeIncremental,
		RestorePointQueryTypeInvalid,
		RestorePointQueryTypeLog,
		RestorePointQueryTypeSnapshotCopyOnlyFull,
		RestorePointQueryTypeSnapshotFull,
	}
}

// RestorePointType - Type of restore point
type RestorePointType string

const (
	RestorePointTypeDifferential         RestorePointType = "Differential"
	RestorePointTypeFull                 RestorePointType = "Full"
	RestorePointTypeIncremental          RestorePointType = "Incremental"
	RestorePointTypeInvalid              RestorePointType = "Invalid"
	RestorePointTypeLog                  RestorePointType = "Log"
	RestorePointTypeSnapshotCopyOnlyFull RestorePointType = "SnapshotCopyOnlyFull"
	RestorePointTypeSnapshotFull         RestorePointType = "SnapshotFull"
)

// PossibleRestorePointTypeValues returns the possible values for the RestorePointType const type.
func PossibleRestorePointTypeValues() []RestorePointType {
	return []RestorePointType{
		RestorePointTypeDifferential,
		RestorePointTypeFull,
		RestorePointTypeIncremental,
		RestorePointTypeInvalid,
		RestorePointTypeLog,
		RestorePointTypeSnapshotCopyOnlyFull,
		RestorePointTypeSnapshotFull,
	}
}

// RestoreRequestType - Restore Type (FullShareRestore or ItemLevelRestore)
type RestoreRequestType string

const (
	RestoreRequestTypeFullShareRestore RestoreRequestType = "FullShareRestore"
	RestoreRequestTypeInvalid          RestoreRequestType = "Invalid"
	RestoreRequestTypeItemLevelRestore RestoreRequestType = "ItemLevelRestore"
)

// PossibleRestoreRequestTypeValues returns the possible values for the RestoreRequestType const type.
func PossibleRestoreRequestTypeValues() []RestoreRequestType {
	return []RestoreRequestType{
		RestoreRequestTypeFullShareRestore,
		RestoreRequestTypeInvalid,
		RestoreRequestTypeItemLevelRestore,
	}
}

// RetentionDurationType - Retention duration type of retention policy.
type RetentionDurationType string

const (
	RetentionDurationTypeDays    RetentionDurationType = "Days"
	RetentionDurationTypeInvalid RetentionDurationType = "Invalid"
	RetentionDurationTypeMonths  RetentionDurationType = "Months"
	RetentionDurationTypeWeeks   RetentionDurationType = "Weeks"
	RetentionDurationTypeYears   RetentionDurationType = "Years"
)

// PossibleRetentionDurationTypeValues returns the possible values for the RetentionDurationType const type.
func PossibleRetentionDurationTypeValues() []RetentionDurationType {
	return []RetentionDurationType{
		RetentionDurationTypeDays,
		RetentionDurationTypeInvalid,
		RetentionDurationTypeMonths,
		RetentionDurationTypeWeeks,
		RetentionDurationTypeYears,
	}
}

// RetentionScheduleFormat - Retention schedule format type for monthly retention policy.
type RetentionScheduleFormat string

const (
	RetentionScheduleFormatDaily   RetentionScheduleFormat = "Daily"
	RetentionScheduleFormatInvalid RetentionScheduleFormat = "Invalid"
	RetentionScheduleFormatWeekly  RetentionScheduleFormat = "Weekly"
)

// PossibleRetentionScheduleFormatValues returns the possible values for the RetentionScheduleFormat const type.
func PossibleRetentionScheduleFormatValues() []RetentionScheduleFormat {
	return []RetentionScheduleFormat{
		RetentionScheduleFormatDaily,
		RetentionScheduleFormatInvalid,
		RetentionScheduleFormatWeekly,
	}
}

// SQLDataDirectoryType - Type of data directory mapping
type SQLDataDirectoryType string

const (
	SQLDataDirectoryTypeData    SQLDataDirectoryType = "Data"
	SQLDataDirectoryTypeInvalid SQLDataDirectoryType = "Invalid"
	SQLDataDirectoryTypeLog     SQLDataDirectoryType = "Log"
)

// PossibleSQLDataDirectoryTypeValues returns the possible values for the SQLDataDirectoryType const type.
func PossibleSQLDataDirectoryTypeValues() []SQLDataDirectoryType {
	return []SQLDataDirectoryType{
		SQLDataDirectoryTypeData,
		SQLDataDirectoryTypeInvalid,
		SQLDataDirectoryTypeLog,
	}
}

// ScheduleRunType - Frequency of the schedule operation of this policy.
type ScheduleRunType string

const (
	ScheduleRunTypeDaily   ScheduleRunType = "Daily"
	ScheduleRunTypeHourly  ScheduleRunType = "Hourly"
	ScheduleRunTypeInvalid ScheduleRunType = "Invalid"
	ScheduleRunTypeWeekly  ScheduleRunType = "Weekly"
)

// PossibleScheduleRunTypeValues returns the possible values for the ScheduleRunType const type.
func PossibleScheduleRunTypeValues() []ScheduleRunType {
	return []ScheduleRunType{
		ScheduleRunTypeDaily,
		ScheduleRunTypeHourly,
		ScheduleRunTypeInvalid,
		ScheduleRunTypeWeekly,
	}
}

// SoftDeleteFeatureState - Soft Delete feature state
type SoftDeleteFeatureState string

const (
	SoftDeleteFeatureStateAlwaysON SoftDeleteFeatureState = "AlwaysON"
	SoftDeleteFeatureStateDisabled SoftDeleteFeatureState = "Disabled"
	SoftDeleteFeatureStateEnabled  SoftDeleteFeatureState = "Enabled"
	SoftDeleteFeatureStateInvalid  SoftDeleteFeatureState = "Invalid"
)

// PossibleSoftDeleteFeatureStateValues returns the possible values for the SoftDeleteFeatureState const type.
func PossibleSoftDeleteFeatureStateValues() []SoftDeleteFeatureState {
	return []SoftDeleteFeatureState{
		SoftDeleteFeatureStateAlwaysON,
		SoftDeleteFeatureStateDisabled,
		SoftDeleteFeatureStateEnabled,
		SoftDeleteFeatureStateInvalid,
	}
}

// StorageType - Storage type
type StorageType string

const (
	StorageTypeGeoRedundant               StorageType = "GeoRedundant"
	StorageTypeInvalid                    StorageType = "Invalid"
	StorageTypeLocallyRedundant           StorageType = "LocallyRedundant"
	StorageTypeReadAccessGeoZoneRedundant StorageType = "ReadAccessGeoZoneRedundant"
	StorageTypeZoneRedundant              StorageType = "ZoneRedundant"
)

// PossibleStorageTypeValues returns the possible values for the StorageType const type.
func PossibleStorageTypeValues() []StorageType {
	return []StorageType{
		StorageTypeGeoRedundant,
		StorageTypeInvalid,
		StorageTypeLocallyRedundant,
		StorageTypeReadAccessGeoZoneRedundant,
		StorageTypeZoneRedundant,
	}
}

// StorageTypeState - Locked or Unlocked. Once a machine is registered against a resource, the storageTypeState is always
// Locked.
type StorageTypeState string

const (
	StorageTypeStateInvalid  StorageTypeState = "Invalid"
	StorageTypeStateLocked   StorageTypeState = "Locked"
	StorageTypeStateUnlocked StorageTypeState = "Unlocked"
)

// PossibleStorageTypeStateValues returns the possible values for the StorageTypeState const type.
func PossibleStorageTypeStateValues() []StorageTypeState {
	return []StorageTypeState{
		StorageTypeStateInvalid,
		StorageTypeStateLocked,
		StorageTypeStateUnlocked,
	}
}

// SupportStatus - Support status of feature
type SupportStatus string

const (
	SupportStatusDefaultOFF   SupportStatus = "DefaultOFF"
	SupportStatusDefaultON    SupportStatus = "DefaultON"
	SupportStatusInvalid      SupportStatus = "Invalid"
	SupportStatusNotSupported SupportStatus = "NotSupported"
	SupportStatusSupported    SupportStatus = "Supported"
)

// PossibleSupportStatusValues returns the possible values for the SupportStatus const type.
func PossibleSupportStatusValues() []SupportStatus {
	return []SupportStatus{
		SupportStatusDefaultOFF,
		SupportStatusDefaultON,
		SupportStatusInvalid,
		SupportStatusNotSupported,
		SupportStatusSupported,
	}
}

// TargetDiskNetworkAccessOption - Network access settings to be used for restored disks
type TargetDiskNetworkAccessOption string

const (
	TargetDiskNetworkAccessOptionEnablePrivateAccessForAllDisks TargetDiskNetworkAccessOption = "EnablePrivateAccessForAllDisks"
	TargetDiskNetworkAccessOptionEnablePublicAccessForAllDisks  TargetDiskNetworkAccessOption = "EnablePublicAccessForAllDisks"
	TargetDiskNetworkAccessOptionSameAsOnSourceDisks            TargetDiskNetworkAccessOption = "SameAsOnSourceDisks"
)

// PossibleTargetDiskNetworkAccessOptionValues returns the possible values for the TargetDiskNetworkAccessOption const type.
func PossibleTargetDiskNetworkAccessOptionValues() []TargetDiskNetworkAccessOption {
	return []TargetDiskNetworkAccessOption{
		TargetDiskNetworkAccessOptionEnablePrivateAccessForAllDisks,
		TargetDiskNetworkAccessOptionEnablePublicAccessForAllDisks,
		TargetDiskNetworkAccessOptionSameAsOnSourceDisks,
	}
}

// TieringMode - Tiering Mode to control automatic tiering of recovery points. Supported values are:
// 1. TierRecommended: Tier all recovery points recommended to be tiered
// 2. TierAfter: Tier all recovery points after a fixed period, as specified in duration + durationType below.
// 3. DoNotTier: Do not tier any recovery points
type TieringMode string

const (
	TieringModeDoNotTier       TieringMode = "DoNotTier"
	TieringModeInvalid         TieringMode = "Invalid"
	TieringModeTierAfter       TieringMode = "TierAfter"
	TieringModeTierRecommended TieringMode = "TierRecommended"
)

// PossibleTieringModeValues returns the possible values for the TieringMode const type.
func PossibleTieringModeValues() []TieringMode {
	return []TieringMode{
		TieringModeDoNotTier,
		TieringModeInvalid,
		TieringModeTierAfter,
		TieringModeTierRecommended,
	}
}

// Type - Backup management type for this container.
type Type string

const (
	TypeBackupProtectedItemCountSummary       Type = "BackupProtectedItemCountSummary"
	TypeBackupProtectionContainerCountSummary Type = "BackupProtectionContainerCountSummary"
	TypeInvalid                               Type = "Invalid"
)

// PossibleTypeValues returns the possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{
		TypeBackupProtectedItemCountSummary,
		TypeBackupProtectionContainerCountSummary,
		TypeInvalid,
	}
}

// UsagesUnit - Unit of the usage.
type UsagesUnit string

const (
	UsagesUnitBytes          UsagesUnit = "Bytes"
	UsagesUnitBytesPerSecond UsagesUnit = "BytesPerSecond"
	UsagesUnitCount          UsagesUnit = "Count"
	UsagesUnitCountPerSecond UsagesUnit = "CountPerSecond"
	UsagesUnitPercent        UsagesUnit = "Percent"
	UsagesUnitSeconds        UsagesUnit = "Seconds"
)

// PossibleUsagesUnitValues returns the possible values for the UsagesUnit const type.
func PossibleUsagesUnitValues() []UsagesUnit {
	return []UsagesUnit{
		UsagesUnitBytes,
		UsagesUnitBytesPerSecond,
		UsagesUnitCount,
		UsagesUnitCountPerSecond,
		UsagesUnitPercent,
		UsagesUnitSeconds,
	}
}

// ValidationStatus - Validation Status
type ValidationStatus string

const (
	ValidationStatusFailed    ValidationStatus = "Failed"
	ValidationStatusInvalid   ValidationStatus = "Invalid"
	ValidationStatusSucceeded ValidationStatus = "Succeeded"
)

// PossibleValidationStatusValues returns the possible values for the ValidationStatus const type.
func PossibleValidationStatusValues() []ValidationStatus {
	return []ValidationStatus{
		ValidationStatusFailed,
		ValidationStatusInvalid,
		ValidationStatusSucceeded,
	}
}

// VaultSubResourceType - GroupId for the PrivateEndpointConnection - AzureBackup, AzureBackup_secondary or AzureSiteRecovery
type VaultSubResourceType string

const (
	VaultSubResourceTypeAzureBackup          VaultSubResourceType = "AzureBackup"
	VaultSubResourceTypeAzureBackupSecondary VaultSubResourceType = "AzureBackup_secondary"
	VaultSubResourceTypeAzureSiteRecovery    VaultSubResourceType = "AzureSiteRecovery"
)

// PossibleVaultSubResourceTypeValues returns the possible values for the VaultSubResourceType const type.
func PossibleVaultSubResourceTypeValues() []VaultSubResourceType {
	return []VaultSubResourceType{
		VaultSubResourceTypeAzureBackup,
		VaultSubResourceTypeAzureBackupSecondary,
		VaultSubResourceTypeAzureSiteRecovery,
	}
}

type WeekOfMonth string

const (
	WeekOfMonthFirst   WeekOfMonth = "First"
	WeekOfMonthFourth  WeekOfMonth = "Fourth"
	WeekOfMonthInvalid WeekOfMonth = "Invalid"
	WeekOfMonthLast    WeekOfMonth = "Last"
	WeekOfMonthSecond  WeekOfMonth = "Second"
	WeekOfMonthThird   WeekOfMonth = "Third"
)

// PossibleWeekOfMonthValues returns the possible values for the WeekOfMonth const type.
func PossibleWeekOfMonthValues() []WeekOfMonth {
	return []WeekOfMonth{
		WeekOfMonthFirst,
		WeekOfMonthFourth,
		WeekOfMonthInvalid,
		WeekOfMonthLast,
		WeekOfMonthSecond,
		WeekOfMonthThird,
	}
}

// WorkloadItemType - Workload item type of the item for which intent is to be set
type WorkloadItemType string

const (
	WorkloadItemTypeInvalid           WorkloadItemType = "Invalid"
	WorkloadItemTypeSAPAseDatabase    WorkloadItemType = "SAPAseDatabase"
	WorkloadItemTypeSAPAseSystem      WorkloadItemType = "SAPAseSystem"
	WorkloadItemTypeSAPHanaDBInstance WorkloadItemType = "SAPHanaDBInstance"
	WorkloadItemTypeSAPHanaDatabase   WorkloadItemType = "SAPHanaDatabase"
	WorkloadItemTypeSAPHanaSystem     WorkloadItemType = "SAPHanaSystem"
	WorkloadItemTypeSQLDataBase       WorkloadItemType = "SQLDataBase"
	WorkloadItemTypeSQLInstance       WorkloadItemType = "SQLInstance"
)

// PossibleWorkloadItemTypeValues returns the possible values for the WorkloadItemType const type.
func PossibleWorkloadItemTypeValues() []WorkloadItemType {
	return []WorkloadItemType{
		WorkloadItemTypeInvalid,
		WorkloadItemTypeSAPAseDatabase,
		WorkloadItemTypeSAPAseSystem,
		WorkloadItemTypeSAPHanaDBInstance,
		WorkloadItemTypeSAPHanaDatabase,
		WorkloadItemTypeSAPHanaSystem,
		WorkloadItemTypeSQLDataBase,
		WorkloadItemTypeSQLInstance,
	}
}

// WorkloadType - Type of workload for the backup management
type WorkloadType string

const (
	WorkloadTypeAzureFileShare    WorkloadType = "AzureFileShare"
	WorkloadTypeAzureSQLDb        WorkloadType = "AzureSqlDb"
	WorkloadTypeClient            WorkloadType = "Client"
	WorkloadTypeExchange          WorkloadType = "Exchange"
	WorkloadTypeFileFolder        WorkloadType = "FileFolder"
	WorkloadTypeGenericDataSource WorkloadType = "GenericDataSource"
	WorkloadTypeInvalid           WorkloadType = "Invalid"
	WorkloadTypeSAPAseDatabase    WorkloadType = "SAPAseDatabase"
	WorkloadTypeSAPHanaDBInstance WorkloadType = "SAPHanaDBInstance"
	WorkloadTypeSAPHanaDatabase   WorkloadType = "SAPHanaDatabase"
	WorkloadTypeSQLDB             WorkloadType = "SQLDB"
	WorkloadTypeSQLDataBase       WorkloadType = "SQLDataBase"
	WorkloadTypeSharepoint        WorkloadType = "Sharepoint"
	WorkloadTypeSystemState       WorkloadType = "SystemState"
	WorkloadTypeVM                WorkloadType = "VM"
	WorkloadTypeVMwareVM          WorkloadType = "VMwareVM"
)

// PossibleWorkloadTypeValues returns the possible values for the WorkloadType const type.
func PossibleWorkloadTypeValues() []WorkloadType {
	return []WorkloadType{
		WorkloadTypeAzureFileShare,
		WorkloadTypeAzureSQLDb,
		WorkloadTypeClient,
		WorkloadTypeExchange,
		WorkloadTypeFileFolder,
		WorkloadTypeGenericDataSource,
		WorkloadTypeInvalid,
		WorkloadTypeSAPAseDatabase,
		WorkloadTypeSAPHanaDBInstance,
		WorkloadTypeSAPHanaDatabase,
		WorkloadTypeSQLDB,
		WorkloadTypeSQLDataBase,
		WorkloadTypeSharepoint,
		WorkloadTypeSystemState,
		WorkloadTypeVM,
		WorkloadTypeVMwareVM,
	}
}

// XcoolState - Vault x-cool state
type XcoolState string

const (
	XcoolStateDisabled XcoolState = "Disabled"
	XcoolStateEnabled  XcoolState = "Enabled"
	XcoolStateInvalid  XcoolState = "Invalid"
)

// PossibleXcoolStateValues returns the possible values for the XcoolState const type.
func PossibleXcoolStateValues() []XcoolState {
	return []XcoolState{
		XcoolStateDisabled,
		XcoolStateEnabled,
		XcoolStateInvalid,
	}
}
