In the following speed table,
the "bytes" column is the number of message bytes being authenticated.
Numbers in columns after that
are single-core cycles/byte on various microarchitectures
(with overclocking disabled),
so smaller numbers are better.

The "auth q1", "iqm", and "q3" columns are first quartile, interquartile mean, and third quartile
of many cycle-count measurements for message authentication divided by the number of message bytes.
The "verify q1", "iqm", and "q3" columns are for verifying an authenticator.
The "exp auth" and "exp verify" columns
show separate measurements of lib1305
after an experimental pre-configuration `mv skipcompilers/* compilers` step
(which is unsupported: it uses instructions not supported by `valgrind`).

Each cycle count _includes_ cycle-counting overhead.
This overhead is typically around 40 cycles on Intel/AMD CPUs,
accounting for about 4 cycles/byte for 11-byte messages,
or about 0.3 cycles/byte for 139-byte messages.


| μarch | bytes  | auth q1  | iqm  |  q3  | verify q1 | iqm  |  q3  | exp auth q1  | iqm  |  q3  | exp verify q1  | iqm  | q3  
| :---- | -----: | -------: | ---: | ---: | --------: | ---: | ---: | -----------: | ---: | ---: | -------------: | ---: | --: 
| Zen 2 (2019) | 11 | 9.545 | 9.545 | 9.545 | 11.455 | 11.597 | 11.727 | 9.545 | 9.545 | 9.545 | 11.273 | 11.585 | 11.818
|  | 26 | 5.538 | 5.538 | 5.538 | 5.808 | 5.808 | 5.808 | 5.615 | 5.615 | 5.615 | 5.808 | 5.808 | 5.808
|  | 61 | 3.656 | 3.656 | 3.656 | 3.754 | 3.819 | 3.869 | 3.656 | 3.656 | 3.656 | 3.787 | 3.787 | 3.787
|  | 139 | 2.871 | 2.871 | 2.871 | 2.978 | 2.978 | 2.978 | 2.906 | 2.906 | 2.906 | 2.986 | 2.986 | 2.986
|  | 314 | 2.420 | 2.420 | 2.420 | 2.411 | 2.411 | 2.411 | 2.424 | 2.424 | 2.424 | 2.424 | 2.433 | 2.439
|  | 709 | 1.477 | 1.477 | 1.477 | 1.482 | 1.482 | 1.482 | 1.450 | 1.450 | 1.450 | 1.474 | 1.474 | 1.474
|  | 1597 | 1.021 | 1.021 | 1.021 | 1.039 | 1.039 | 1.039 | 1.036 | 1.036 | 1.036 | 1.056 | 1.056 | 1.056
|  | 3595 | 0.843 | 0.843 | 0.843 | 0.860 | 0.860 | 0.860 | 0.845 | 0.845 | 0.845 | 0.855 | 0.855 | 0.855
|  | 8090 | 0.765 | 0.765 | 0.765 | 0.765 | 0.765 | 0.765 | 0.766 | 0.766 | 0.766 | 0.767 | 0.767 | 0.767
|  | 18205 | 0.729 | 0.729 | 0.729 | 0.729 | 0.729 | 0.729 | 0.728 | 0.728 | 0.728 | 0.728 | 0.728 | 0.728
| Skylake (2015) | 11 | 11.273 | 11.375 | 11.455 | 14.091 | 14.159 | 14.182 | 11.364 | 11.494 | 11.545 | 14.273 | 14.278 | 14.364
|  | 26 | 5.615 | 5.627 | 5.654 | 6.731 | 6.769 | 6.846 | 5.615 | 5.627 | 5.654 | 6.731 | 6.800 | 6.846
|  | 61 | 3.574 | 3.701 | 3.836 | 4.148 | 4.202 | 4.254 | 3.500 | 3.621 | 3.893 | 4.115 | 4.192 | 4.246
|  | 139 | 2.878 | 2.920 | 2.957 | 3.147 | 3.167 | 3.205 | 2.820 | 2.874 | 2.924 | 3.122 | 3.140 | 3.169
|  | 314 | 1.718 | 1.738 | 1.753 | 1.828 | 1.837 | 1.849 | 1.670 | 1.683 | 1.691 | 1.814 | 1.827 | 1.834
|  | 709 | 1.195 | 1.210 | 1.227 | 1.244 | 1.254 | 1.262 | 1.193 | 1.206 | 1.216 | 1.244 | 1.250 | 1.259
|  | 1597 | 0.961 | 0.965 | 0.970 | 0.983 | 0.988 | 0.993 | 0.959 | 0.965 | 0.972 | 0.982 | 0.986 | 0.990
|  | 3595 | 0.862 | 0.865 | 0.868 | 0.872 | 0.875 | 0.877 | 0.862 | 0.865 | 0.871 | 0.871 | 0.874 | 0.877
|  | 8090 | 0.819 | 0.820 | 0.823 | 0.821 | 0.824 | 0.827 | 0.816 | 0.820 | 0.822 | 0.821 | 0.822 | 0.824
|  | 18205 | 0.798 | 0.799 | 0.801 | 0.798 | 0.800 | 0.802 | 0.799 | 0.801 | 0.803 | 0.797 | 0.799 | 0.800
| Core 2 (2006) | 11 | 16.545 | 16.545 | 16.545 | 19.182 | 19.261 | 19.364 | 16.545 | 16.545 | 16.545 | 19.273 | 19.273 | 19.273
|  | 26 | 9.500 | 9.500 | 9.500 | 10.654 | 10.654 | 10.654 | 9.769 | 9.769 | 9.769 | 10.808 | 10.808 | 10.808
|  | 61 | 7.902 | 7.902 | 7.902 | 8.525 | 8.590 | 8.656 | 7.902 | 7.902 | 7.902 | 8.525 | 8.598 | 8.656
|  | 139 | 6.763 | 6.790 | 6.813 | 7.122 | 7.128 | 7.144 | 6.813 | 6.849 | 6.878 | 7.086 | 7.128 | 7.173
|  | 314 | 6.156 | 6.169 | 6.178 | 6.194 | 6.198 | 6.201 | 6.121 | 6.146 | 6.178 | 6.191 | 6.195 | 6.197
|  | 709 | 4.276 | 4.300 | 4.323 | 4.360 | 4.362 | 4.362 | 4.289 | 4.304 | 4.323 | 4.358 | 4.360 | 4.361
|  | 1597 | 3.401 | 3.413 | 3.425 | 3.425 | 3.425 | 3.425 | 3.410 | 3.410 | 3.411 | 3.439 | 3.439 | 3.439
|  | 3595 | 3.000 | 3.003 | 3.007 | 3.019 | 3.019 | 3.019 | 3.010 | 3.017 | 3.021 | 3.022 | 3.022 | 3.022
|  | 8090 | 2.833 | 2.835 | 2.836 | 2.836 | 2.839 | 2.841 | 2.838 | 2.841 | 2.842 | 2.848 | 2.848 | 2.848
|  | 18205 | 2.768 | 2.770 | 2.771 | 2.764 | 2.764 | 2.764 | 2.763 | 2.766 | 2.773 | 2.775 | 2.775 | 2.775


Microarchitectures are listed in reverse chronological order of when they were introduced.

In the lib1305 distribution,
`command/lib1305-speed.c` measures lib1305;
`benchmarks/*-*` is the output of `lib1305-speed` on various machines;
and `autogen/md-speed` extracts the table from those measurements.
See the full output files
for differences between multiple measurements and the interquartile mean.
