"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2013 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.

MCS protocol for communication between Chrome client and Mobile Connection
Server .
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class HeartbeatPing(google.protobuf.message.Message):
    """
    Common fields/comments:

    stream_id: no longer sent by server, each side keeps a counter
    last_stream_id_received: sent only if a packet was received since last time
    a last_stream was sent
    status: new bitmask including the 'idle' as bit 0.

    *
    TAG: 0
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAM_ID_FIELD_NUMBER: builtins.int
    LAST_STREAM_ID_RECEIVED_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    stream_id: builtins.int
    last_stream_id_received: builtins.int
    status: builtins.int
    def __init__(
        self,
        *,
        stream_id: builtins.int | None = ...,
        last_stream_id_received: builtins.int | None = ...,
        status: builtins.int | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "last_stream_id_received",
            b"last_stream_id_received",
            "status",
            b"status",
            "stream_id",
            b"stream_id",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "last_stream_id_received",
            b"last_stream_id_received",
            "status",
            b"status",
            "stream_id",
            b"stream_id",
        ],
    ) -> None: ...

global___HeartbeatPing = HeartbeatPing

@typing_extensions.final
class HeartbeatAck(google.protobuf.message.Message):
    """*
    TAG: 1
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAM_ID_FIELD_NUMBER: builtins.int
    LAST_STREAM_ID_RECEIVED_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    stream_id: builtins.int
    last_stream_id_received: builtins.int
    status: builtins.int
    def __init__(
        self,
        *,
        stream_id: builtins.int | None = ...,
        last_stream_id_received: builtins.int | None = ...,
        status: builtins.int | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "last_stream_id_received",
            b"last_stream_id_received",
            "status",
            b"status",
            "stream_id",
            b"stream_id",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "last_stream_id_received",
            b"last_stream_id_received",
            "status",
            b"status",
            "stream_id",
            b"stream_id",
        ],
    ) -> None: ...

global___HeartbeatAck = HeartbeatAck

@typing_extensions.final
class ErrorInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CODE_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    EXTENSION_FIELD_NUMBER: builtins.int
    code: builtins.int
    message: builtins.str
    type: builtins.str
    @property
    def extension(self) -> global___Extension: ...
    def __init__(
        self,
        *,
        code: builtins.int | None = ...,
        message: builtins.str | None = ...,
        type: builtins.str | None = ...,
        extension: global___Extension | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "code",
            b"code",
            "extension",
            b"extension",
            "message",
            b"message",
            "type",
            b"type",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "code",
            b"code",
            "extension",
            b"extension",
            "message",
            b"message",
            "type",
            b"type",
        ],
    ) -> None: ...

global___ErrorInfo = ErrorInfo

@typing_extensions.final
class Setting(google.protobuf.message.Message):
    """MobileSettings class.
    "u:f", "u:b", "u:s" - multi user devices reporting foreground, background
    and stopped users.
    hbping: heatbeat ping interval
    rmq2v: include explicit stream IDs
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    name: builtins.str
    value: builtins.str
    def __init__(
        self,
        *,
        name: builtins.str | None = ...,
        value: builtins.str | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["name", b"name", "value", b"value"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["name", b"name", "value", b"value"]
    ) -> None: ...

global___Setting = Setting

@typing_extensions.final
class HeartbeatStat(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IP_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    INTERVAL_MS_FIELD_NUMBER: builtins.int
    ip: builtins.str
    timeout: builtins.bool
    interval_ms: builtins.int
    def __init__(
        self,
        *,
        ip: builtins.str | None = ...,
        timeout: builtins.bool | None = ...,
        interval_ms: builtins.int | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "interval_ms", b"interval_ms", "ip", b"ip", "timeout", b"timeout"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "interval_ms", b"interval_ms", "ip", b"ip", "timeout", b"timeout"
        ],
    ) -> None: ...

global___HeartbeatStat = HeartbeatStat

@typing_extensions.final
class HeartbeatConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UPLOAD_STAT_FIELD_NUMBER: builtins.int
    IP_FIELD_NUMBER: builtins.int
    INTERVAL_MS_FIELD_NUMBER: builtins.int
    upload_stat: builtins.bool
    ip: builtins.str
    interval_ms: builtins.int
    def __init__(
        self,
        *,
        upload_stat: builtins.bool | None = ...,
        ip: builtins.str | None = ...,
        interval_ms: builtins.int | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "interval_ms", b"interval_ms", "ip", b"ip", "upload_stat", b"upload_stat"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "interval_ms", b"interval_ms", "ip", b"ip", "upload_stat", b"upload_stat"
        ],
    ) -> None: ...

global___HeartbeatConfig = HeartbeatConfig

@typing_extensions.final
class ClientEvent(google.protobuf.message.Message):
    """ClientEvents are used to inform the server of failed and successful
    connections.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Type:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TypeEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
            ClientEvent._Type.ValueType
        ],
        builtins.type,
    ):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNKNOWN: ClientEvent._Type.ValueType  # 0
        DISCARDED_EVENTS: ClientEvent._Type.ValueType  # 1
        """Count of discarded events if the buffer filled up and was trimmed."""
        FAILED_CONNECTION: ClientEvent._Type.ValueType  # 2
        """Failed connection event: the connection failed to be established or we
        had a login error.
        """
        SUCCESSFUL_CONNECTION: ClientEvent._Type.ValueType  # 3
        """Successful connection event: information about the last successful
        connection, including the time at which it was established.
        """

    class Type(_Type, metaclass=_TypeEnumTypeWrapper): ...
    UNKNOWN: ClientEvent.Type.ValueType  # 0
    DISCARDED_EVENTS: ClientEvent.Type.ValueType  # 1
    """Count of discarded events if the buffer filled up and was trimmed."""
    FAILED_CONNECTION: ClientEvent.Type.ValueType  # 2
    """Failed connection event: the connection failed to be established or we
    had a login error.
    """
    SUCCESSFUL_CONNECTION: ClientEvent.Type.ValueType  # 3
    """Successful connection event: information about the last successful
    connection, including the time at which it was established.
    """

    TYPE_FIELD_NUMBER: builtins.int
    NUMBER_DISCARDED_EVENTS_FIELD_NUMBER: builtins.int
    NETWORK_TYPE_FIELD_NUMBER: builtins.int
    TIME_CONNECTION_STARTED_MS_FIELD_NUMBER: builtins.int
    TIME_CONNECTION_ENDED_MS_FIELD_NUMBER: builtins.int
    ERROR_CODE_FIELD_NUMBER: builtins.int
    TIME_CONNECTION_ESTABLISHED_MS_FIELD_NUMBER: builtins.int
    type: global___ClientEvent.Type.ValueType
    """Common fields [1-99]"""
    number_discarded_events: builtins.int
    """Fields for DISCARDED_EVENTS messages [100-199]"""
    network_type: builtins.int
    """Fields for FAILED_CONNECTION and SUCCESSFUL_CONNECTION messages [200-299]
    Network type is a value in net::NetworkChangeNotifier::ConnectionType.
    """
    time_connection_started_ms: builtins.int
    time_connection_ended_ms: builtins.int
    error_code: builtins.int
    """Error code should be a net::Error value."""
    time_connection_established_ms: builtins.int
    """Fields for SUCCESSFUL_CONNECTION messages [300-399]"""
    def __init__(
        self,
        *,
        type: global___ClientEvent.Type.ValueType | None = ...,
        number_discarded_events: builtins.int | None = ...,
        network_type: builtins.int | None = ...,
        time_connection_started_ms: builtins.int | None = ...,
        time_connection_ended_ms: builtins.int | None = ...,
        error_code: builtins.int | None = ...,
        time_connection_established_ms: builtins.int | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "error_code",
            b"error_code",
            "network_type",
            b"network_type",
            "number_discarded_events",
            b"number_discarded_events",
            "time_connection_ended_ms",
            b"time_connection_ended_ms",
            "time_connection_established_ms",
            b"time_connection_established_ms",
            "time_connection_started_ms",
            b"time_connection_started_ms",
            "type",
            b"type",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "error_code",
            b"error_code",
            "network_type",
            b"network_type",
            "number_discarded_events",
            b"number_discarded_events",
            "time_connection_ended_ms",
            b"time_connection_ended_ms",
            "time_connection_established_ms",
            b"time_connection_established_ms",
            "time_connection_started_ms",
            b"time_connection_started_ms",
            "type",
            b"type",
        ],
    ) -> None: ...

global___ClientEvent = ClientEvent

@typing_extensions.final
class LoginRequest(google.protobuf.message.Message):
    """*
    TAG: 2
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _AuthService:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _AuthServiceEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
            LoginRequest._AuthService.ValueType
        ],
        builtins.type,
    ):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        ANDROID_ID: LoginRequest._AuthService.ValueType  # 2

    class AuthService(_AuthService, metaclass=_AuthServiceEnumTypeWrapper): ...
    ANDROID_ID: LoginRequest.AuthService.ValueType  # 2

    ID_FIELD_NUMBER: builtins.int
    DOMAIN_FIELD_NUMBER: builtins.int
    USER_FIELD_NUMBER: builtins.int
    RESOURCE_FIELD_NUMBER: builtins.int
    AUTH_TOKEN_FIELD_NUMBER: builtins.int
    DEVICE_ID_FIELD_NUMBER: builtins.int
    LAST_RMQ_ID_FIELD_NUMBER: builtins.int
    SETTING_FIELD_NUMBER: builtins.int
    RECEIVED_PERSISTENT_ID_FIELD_NUMBER: builtins.int
    ADAPTIVE_HEARTBEAT_FIELD_NUMBER: builtins.int
    HEARTBEAT_STAT_FIELD_NUMBER: builtins.int
    USE_RMQ2_FIELD_NUMBER: builtins.int
    ACCOUNT_ID_FIELD_NUMBER: builtins.int
    AUTH_SERVICE_FIELD_NUMBER: builtins.int
    NETWORK_TYPE_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    CLIENT_EVENT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Must be present ( proto required ), may be empty"""
    domain: builtins.str
    """string.
    mcs.android.com.
    """
    user: builtins.str
    """Decimal android ID"""
    resource: builtins.str
    auth_token: builtins.str
    """Secret"""
    device_id: builtins.str
    """Format is: android-HEX_DEVICE_ID
    The user is the decimal value.
    """
    last_rmq_id: builtins.int
    """RMQ1 - no longer used"""
    @property
    def setting(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___Setting
    ]: ...
    @property
    def received_persistent_id(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """optional int32 compress = 9;"""
    adaptive_heartbeat: builtins.bool
    """Replaced by "rmq2v" setting
    optional bool include_stream_ids = 11;
    """
    @property
    def heartbeat_stat(self) -> global___HeartbeatStat: ...
    use_rmq2: builtins.bool
    """Must be true."""
    account_id: builtins.int
    auth_service: global___LoginRequest.AuthService.ValueType
    """ANDROID_ID = 2"""
    network_type: builtins.int
    status: builtins.int
    @property
    def client_event(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___ClientEvent
    ]:
        """Events recorded on the client after the last successful connection."""
    def __init__(
        self,
        *,
        id: builtins.str | None = ...,
        domain: builtins.str | None = ...,
        user: builtins.str | None = ...,
        resource: builtins.str | None = ...,
        auth_token: builtins.str | None = ...,
        device_id: builtins.str | None = ...,
        last_rmq_id: builtins.int | None = ...,
        setting: collections.abc.Iterable[global___Setting] | None = ...,
        received_persistent_id: collections.abc.Iterable[builtins.str] | None = ...,
        adaptive_heartbeat: builtins.bool | None = ...,
        heartbeat_stat: global___HeartbeatStat | None = ...,
        use_rmq2: builtins.bool | None = ...,
        account_id: builtins.int | None = ...,
        auth_service: global___LoginRequest.AuthService.ValueType | None = ...,
        network_type: builtins.int | None = ...,
        status: builtins.int | None = ...,
        client_event: collections.abc.Iterable[global___ClientEvent] | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "account_id",
            b"account_id",
            "adaptive_heartbeat",
            b"adaptive_heartbeat",
            "auth_service",
            b"auth_service",
            "auth_token",
            b"auth_token",
            "device_id",
            b"device_id",
            "domain",
            b"domain",
            "heartbeat_stat",
            b"heartbeat_stat",
            "id",
            b"id",
            "last_rmq_id",
            b"last_rmq_id",
            "network_type",
            b"network_type",
            "resource",
            b"resource",
            "status",
            b"status",
            "use_rmq2",
            b"use_rmq2",
            "user",
            b"user",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "account_id",
            b"account_id",
            "adaptive_heartbeat",
            b"adaptive_heartbeat",
            "auth_service",
            b"auth_service",
            "auth_token",
            b"auth_token",
            "client_event",
            b"client_event",
            "device_id",
            b"device_id",
            "domain",
            b"domain",
            "heartbeat_stat",
            b"heartbeat_stat",
            "id",
            b"id",
            "last_rmq_id",
            b"last_rmq_id",
            "network_type",
            b"network_type",
            "received_persistent_id",
            b"received_persistent_id",
            "resource",
            b"resource",
            "setting",
            b"setting",
            "status",
            b"status",
            "use_rmq2",
            b"use_rmq2",
            "user",
            b"user",
        ],
    ) -> None: ...

global___LoginRequest = LoginRequest

@typing_extensions.final
class LoginResponse(google.protobuf.message.Message):
    """*
    TAG: 3
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    JID_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    SETTING_FIELD_NUMBER: builtins.int
    STREAM_ID_FIELD_NUMBER: builtins.int
    LAST_STREAM_ID_RECEIVED_FIELD_NUMBER: builtins.int
    HEARTBEAT_CONFIG_FIELD_NUMBER: builtins.int
    SERVER_TIMESTAMP_FIELD_NUMBER: builtins.int
    id: builtins.str
    jid: builtins.str
    """Not used."""
    @property
    def error(self) -> global___ErrorInfo:
        """Null if login was ok."""
    @property
    def setting(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___Setting
    ]: ...
    stream_id: builtins.int
    last_stream_id_received: builtins.int
    """Should be "1" """
    @property
    def heartbeat_config(self) -> global___HeartbeatConfig: ...
    server_timestamp: builtins.int
    """used by the client to synchronize with the server timestamp."""
    def __init__(
        self,
        *,
        id: builtins.str | None = ...,
        jid: builtins.str | None = ...,
        error: global___ErrorInfo | None = ...,
        setting: collections.abc.Iterable[global___Setting] | None = ...,
        stream_id: builtins.int | None = ...,
        last_stream_id_received: builtins.int | None = ...,
        heartbeat_config: global___HeartbeatConfig | None = ...,
        server_timestamp: builtins.int | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "error",
            b"error",
            "heartbeat_config",
            b"heartbeat_config",
            "id",
            b"id",
            "jid",
            b"jid",
            "last_stream_id_received",
            b"last_stream_id_received",
            "server_timestamp",
            b"server_timestamp",
            "stream_id",
            b"stream_id",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "error",
            b"error",
            "heartbeat_config",
            b"heartbeat_config",
            "id",
            b"id",
            "jid",
            b"jid",
            "last_stream_id_received",
            b"last_stream_id_received",
            "server_timestamp",
            b"server_timestamp",
            "setting",
            b"setting",
            "stream_id",
            b"stream_id",
        ],
    ) -> None: ...

global___LoginResponse = LoginResponse

@typing_extensions.final
class StreamErrorStanza(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYPE_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    type: builtins.str
    text: builtins.str
    def __init__(
        self,
        *,
        type: builtins.str | None = ...,
        text: builtins.str | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["text", b"text", "type", b"type"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["text", b"text", "type", b"type"]
    ) -> None: ...

global___StreamErrorStanza = StreamErrorStanza

@typing_extensions.final
class Close(google.protobuf.message.Message):
    """*
    TAG: 4
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___Close = Close

@typing_extensions.final
class Extension(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    id: builtins.int
    """12: SelectiveAck
    13: StreamAck
    """
    data: builtins.bytes
    def __init__(
        self,
        *,
        id: builtins.int | None = ...,
        data: builtins.bytes | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["data", b"data", "id", b"id"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["data", b"data", "id", b"id"]
    ) -> None: ...

global___Extension = Extension

@typing_extensions.final
class IqStanza(google.protobuf.message.Message):
    """*
    TAG: 7
    IqRequest must contain a single extension.  IqResponse may contain 0 or 1
    extensions.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _IqType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _IqTypeEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
            IqStanza._IqType.ValueType
        ],
        builtins.type,
    ):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        GET: IqStanza._IqType.ValueType  # 0
        SET: IqStanza._IqType.ValueType  # 1
        RESULT: IqStanza._IqType.ValueType  # 2
        IQ_ERROR: IqStanza._IqType.ValueType  # 3

    class IqType(_IqType, metaclass=_IqTypeEnumTypeWrapper): ...
    GET: IqStanza.IqType.ValueType  # 0
    SET: IqStanza.IqType.ValueType  # 1
    RESULT: IqStanza.IqType.ValueType  # 2
    IQ_ERROR: IqStanza.IqType.ValueType  # 3

    RMQ_ID_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    FROM_FIELD_NUMBER: builtins.int
    TO_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    EXTENSION_FIELD_NUMBER: builtins.int
    PERSISTENT_ID_FIELD_NUMBER: builtins.int
    STREAM_ID_FIELD_NUMBER: builtins.int
    LAST_STREAM_ID_RECEIVED_FIELD_NUMBER: builtins.int
    ACCOUNT_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    rmq_id: builtins.int
    type: global___IqStanza.IqType.ValueType
    id: builtins.str
    to: builtins.str
    @property
    def error(self) -> global___ErrorInfo: ...
    @property
    def extension(self) -> global___Extension:
        """Only field used in the 38+ protocol (besides common last_stream_id_received, status, rmq_id)"""
    persistent_id: builtins.str
    stream_id: builtins.int
    last_stream_id_received: builtins.int
    account_id: builtins.int
    status: builtins.int
    def __init__(
        self,
        *,
        rmq_id: builtins.int | None = ...,
        type: global___IqStanza.IqType.ValueType | None = ...,
        id: builtins.str | None = ...,
        to: builtins.str | None = ...,
        error: global___ErrorInfo | None = ...,
        extension: global___Extension | None = ...,
        persistent_id: builtins.str | None = ...,
        stream_id: builtins.int | None = ...,
        last_stream_id_received: builtins.int | None = ...,
        account_id: builtins.int | None = ...,
        status: builtins.int | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "account_id",
            b"account_id",
            "error",
            b"error",
            "extension",
            b"extension",
            "from",
            b"from",
            "id",
            b"id",
            "last_stream_id_received",
            b"last_stream_id_received",
            "persistent_id",
            b"persistent_id",
            "rmq_id",
            b"rmq_id",
            "status",
            b"status",
            "stream_id",
            b"stream_id",
            "to",
            b"to",
            "type",
            b"type",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "account_id",
            b"account_id",
            "error",
            b"error",
            "extension",
            b"extension",
            "from",
            b"from",
            "id",
            b"id",
            "last_stream_id_received",
            b"last_stream_id_received",
            "persistent_id",
            b"persistent_id",
            "rmq_id",
            b"rmq_id",
            "status",
            b"status",
            "stream_id",
            b"stream_id",
            "to",
            b"to",
            "type",
            b"type",
        ],
    ) -> None: ...

global___IqStanza = IqStanza

@typing_extensions.final
class AppData(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    key: builtins.str
    value: builtins.str
    def __init__(
        self,
        *,
        key: builtins.str | None = ...,
        value: builtins.str | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]
    ) -> None: ...

global___AppData = AppData

@typing_extensions.final
class DataMessageStanza(google.protobuf.message.Message):
    """*
    TAG: 8
    Not used.
    optional int64 rmq_id = 1;
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    FROM_FIELD_NUMBER: builtins.int
    TO_FIELD_NUMBER: builtins.int
    CATEGORY_FIELD_NUMBER: builtins.int
    TOKEN_FIELD_NUMBER: builtins.int
    APP_DATA_FIELD_NUMBER: builtins.int
    FROM_TRUSTED_SERVER_FIELD_NUMBER: builtins.int
    PERSISTENT_ID_FIELD_NUMBER: builtins.int
    STREAM_ID_FIELD_NUMBER: builtins.int
    LAST_STREAM_ID_RECEIVED_FIELD_NUMBER: builtins.int
    REG_ID_FIELD_NUMBER: builtins.int
    DEVICE_USER_ID_FIELD_NUMBER: builtins.int
    TTL_FIELD_NUMBER: builtins.int
    SENT_FIELD_NUMBER: builtins.int
    QUEUED_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    RAW_DATA_FIELD_NUMBER: builtins.int
    IMMEDIATE_ACK_FIELD_NUMBER: builtins.int
    id: builtins.str
    """This is the message ID, set by client, DMP.9 (message_id)"""
    to: builtins.str
    """Part of DMRequest - also the key in DataMessageProto."""
    category: builtins.str
    """Package name. DMP.2"""
    token: builtins.str
    """The collapsed key, DMP.3"""
    @property
    def app_data(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___AppData
    ]:
        """User data + GOOGLE. prefixed special entries, DMP.4"""
    from_trusted_server: builtins.bool
    """Not used."""
    persistent_id: builtins.str
    """Part of the ACK protocol, returned in DataMessageResponse on server side.
    It's part of the key of DMP.
    """
    stream_id: builtins.int
    """In-stream ack. Increments on each message sent - a bit redundant
    Not used in DMP/DMR.
    """
    last_stream_id_received: builtins.int
    reg_id: builtins.str
    """Not used.
    optional string permission = 12;

    Sent by the device shortly after registration.
    """
    device_user_id: builtins.int
    """Not used.
    optional string pkg_signature = 14;
    Not used.
    optional string client_id = 15;

    serial number of the target user, DMP.8
    It is the 'serial number' according to user manager.
    """
    ttl: builtins.int
    """Time to live, in seconds."""
    sent: builtins.int
    """Timestamp ( according to client ) when message was sent by app, in seconds"""
    queued: builtins.int
    """How long has the message been queued before the flush, in seconds.
    This is needed to account for the time difference between server and
    client: server should adjust 'sent' based on its 'receive' time.
    """
    status: builtins.int
    raw_data: builtins.bytes
    """Optional field containing the binary payload of the message."""
    immediate_ack: builtins.bool
    """Not used.
    How long the message was delayed before it was sent, in seconds.
    optional int32 actual_delay = 23;

    If set the server requests immediate ack. Used for important messages and
    for testing.
    """
    def __init__(
        self,
        *,
        id: builtins.str | None = ...,
        to: builtins.str | None = ...,
        category: builtins.str | None = ...,
        token: builtins.str | None = ...,
        app_data: collections.abc.Iterable[global___AppData] | None = ...,
        from_trusted_server: builtins.bool | None = ...,
        persistent_id: builtins.str | None = ...,
        stream_id: builtins.int | None = ...,
        last_stream_id_received: builtins.int | None = ...,
        reg_id: builtins.str | None = ...,
        device_user_id: builtins.int | None = ...,
        ttl: builtins.int | None = ...,
        sent: builtins.int | None = ...,
        queued: builtins.int | None = ...,
        status: builtins.int | None = ...,
        raw_data: builtins.bytes | None = ...,
        immediate_ack: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "category",
            b"category",
            "device_user_id",
            b"device_user_id",
            "from",
            b"from",
            "from_trusted_server",
            b"from_trusted_server",
            "id",
            b"id",
            "immediate_ack",
            b"immediate_ack",
            "last_stream_id_received",
            b"last_stream_id_received",
            "persistent_id",
            b"persistent_id",
            "queued",
            b"queued",
            "raw_data",
            b"raw_data",
            "reg_id",
            b"reg_id",
            "sent",
            b"sent",
            "status",
            b"status",
            "stream_id",
            b"stream_id",
            "to",
            b"to",
            "token",
            b"token",
            "ttl",
            b"ttl",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "app_data",
            b"app_data",
            "category",
            b"category",
            "device_user_id",
            b"device_user_id",
            "from",
            b"from",
            "from_trusted_server",
            b"from_trusted_server",
            "id",
            b"id",
            "immediate_ack",
            b"immediate_ack",
            "last_stream_id_received",
            b"last_stream_id_received",
            "persistent_id",
            b"persistent_id",
            "queued",
            b"queued",
            "raw_data",
            b"raw_data",
            "reg_id",
            b"reg_id",
            "sent",
            b"sent",
            "status",
            b"status",
            "stream_id",
            b"stream_id",
            "to",
            b"to",
            "token",
            b"token",
            "ttl",
            b"ttl",
        ],
    ) -> None: ...

global___DataMessageStanza = DataMessageStanza

@typing_extensions.final
class StreamAck(google.protobuf.message.Message):
    """*
    Included in IQ with ID 13, sent from client or server after 10 unconfirmed
    messages.
    No last_streamid_received required.  This is included within an IqStanza,
    which includes the last_stream_id_received.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___StreamAck = StreamAck

@typing_extensions.final
class SelectiveAck(google.protobuf.message.Message):
    """*
    Included in IQ sent after LoginResponse from server with ID 12.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    @property
    def id(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[
        builtins.str
    ]: ...
    def __init__(
        self,
        *,
        id: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["id", b"id"]
    ) -> None: ...

global___SelectiveAck = SelectiveAck
