<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Symfony\Component\Form\Extension\Validator\Type;

use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\OptionsResolver\Options;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\GroupSequence;

/**
 * Encapsulates common logic of {@link FormTypeValidatorExtension} and
 * {@link SubmitTypeValidatorExtension}.
 *
 * @author Bernhard Schussek <bschussek@gmail.com>
 */
abstract class BaseValidatorExtension extends AbstractTypeExtension
{
    public function configureOptions(OptionsResolver $resolver): void
    {
        // Make sure that validation groups end up as null, closure or array
        $validationGroupsNormalizer = static function (Options $options, $groups) {
            if (false === $groups) {
                return [];
            }

            if (!$groups) {
                return null;
            }

            if (\is_callable($groups)) {
                return $groups;
            }

            if ($groups instanceof GroupSequence) {
                return $groups;
            }

            return (array) $groups;
        };

        $resolver->setDefaults([
            'validation_groups' => null,
        ]);

        $resolver->setNormalizer('validation_groups', $validationGroupsNormalizer);
    }
}
