/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/**
 * This file is generated by browser/components/asrouter/bin/import-rollouts.js
 * Run the following from the repository root to regenerate it:
 * ./mach npm run import-rollouts --prefix=browser/components/asrouter
 */

export const NimbusRolloutMessageProvider = {
  getMessages() {
    return [
      {
        // Nimbus slug: multiple-profile-switching-feature-v1-rollout:treatment-a-multi-profiles (message 1 of 2)
        // Version range: 140+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/multiple-profile-switching-feature-v1-rollout/summary#treatment-a-multi-profiles
        id: "NEW_SELECTABLE_PROFILE_SPOTLIGHT",
        groups: ["cfr"],
        content: {
          modal: "tab",
          screens: [
            {
              id: "SCREEN_1",
              content: {
                logo: {
                  height: "264px",
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/a9e9b418-aa90-467a-a4d7-17d9ea4bc34e.svg",
                },
                title: {
                  fontSize: "24px",
                  string_id: "multi-profile-spotlight-title",
                  fontWeight: 500,
                },
                subtitle: {
                  fontSize: "15px",
                  string_id: "multi-profile-spotlight-body",
                  fontWeight: 400,
                  marginInline: "40px",
                  paddingBlock: "8px",
                },
                dismiss_button: {
                  action: {
                    dismiss: true,
                  },
                },
                primary_button: {
                  label: {
                    string_id: "multi-profile-spotlight-cta",
                  },
                  action: {
                    type: "CREATE_NEW_SELECTABLE_PROFILE",
                    navigate: true,
                  },
                },
              },
            },
          ],
          template: "multistage",
          transitions: true,
        },
        trigger: {
          id: "defaultBrowserCheck",
        },
        priority: 2,
        template: "spotlight",
        frequency: {
          lifetime: 1,
        },
        targeting:
          "canCreateSelectableProfiles && !hasSelectableProfiles && !willShowDefaultPrompt && !activeNotifications && previousSessionEnd",
      },
      {
        // Nimbus slug: multiple-profile-switching-feature-v1-rollout:treatment-a-multi-profiles (message 2 of 2)
        // Version range: 140+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/multiple-profile-switching-feature-v1-rollout/summary#treatment-a-multi-profiles
        id: "NEW_PROFILE_FEATURE_CALLOUT",
        groups: ["cfr"],
        content: {
          id: "NEW_PROFILE_FEATURE_CALLOUT",
          screens: [
            {
              id: "NEW_PROFILE_FEATURE_CALLOUT_SCREEN_1",
              anchors: [
                {
                  selector: "#PanelUI-menu-button",
                  panel_position: {
                    anchor_attachment: "leftcenter",
                    callout_attachment: "topright",
                  },
                },
              ],
              content: {
                logo: {
                  width: "352px",
                  height: "248px",
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/a9e9b418-aa90-467a-a4d7-17d9ea4bc34e.svg",
                },
                title: {
                  string_id: "multi-profile-callout-title",
                  marginInline: "16px",
                },
                width: "400px",
                height: "420px",
                padding: 16,
                position: "callout",
                subtitle: {
                  string_id: "multi-profile-callout-subtitle",
                  marginInline: "16px",
                },
                dismiss_button: {
                  size: "small",
                  action: {
                    dismiss: true,
                  },
                  marginBlock: "20px 0",
                  marginInline: "0 26px",
                },
                submenu_button: {
                  submenu: [
                    {
                      id: "block_recommendation",
                      type: "action",
                      label: {
                        string_id: "split-dismiss-button-dont-show-option",
                      },
                      action: {
                        data: {
                          id: "NEW_PROFILE_FEATURE_CALLOUT",
                        },
                        type: "BLOCK_MESSAGE",
                        dismiss: true,
                      },
                    },
                    {
                      id: "show_fewer_recommendations",
                      type: "action",
                      label: {
                        string_id: "split-dismiss-button-show-fewer-option",
                      },
                      action: {
                        data: {
                          actions: [
                            {
                              data: {
                                pref: {
                                  name: "messaging-system-action.show-fewer-cfr-recommendations",
                                  value: true,
                                },
                              },
                              type: "SET_PREF",
                            },
                            {
                              data: {
                                id: "NEW_PROFILE_FEATURE_CALLOUT",
                              },
                              type: "BLOCK_MESSAGE",
                            },
                          ],
                        },
                        type: "MULTI_ACTION",
                        dismiss: true,
                      },
                    },
                    {
                      type: "separator",
                    },
                    {
                      id: "manage_settings",
                      type: "action",
                      label: {
                        string_id:
                          "split-dismiss-button-manage-settings-option",
                      },
                      action: {
                        data: {
                          args: "preferences#general-cfrfeatures",
                          where: "tab",
                        },
                        type: "OPEN_ABOUT_PAGE",
                        dismiss: true,
                      },
                    },
                  ],
                  attached_to: "additional_button",
                },
                secondary_button: {
                  label: {
                    string_id: "multi-profile-callout-cta",
                  },
                  style: "primary",
                  action: {
                    type: "CREATE_NEW_SELECTABLE_PROFILE",
                    navigate: true,
                  },
                },
                additional_button: {
                  label: {
                    string_id: "fx-view-discoverability-secondary-button-label",
                  },
                  style: "secondary",
                  action: {
                    dismiss: true,
                  },
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: false,
        },
        trigger: {
          id: "defaultBrowserCheck",
        },
        priority: 2,
        template: "feature_callout",
        frequency: {
          custom: [
            {
              cap: 1,
              period: 604800000,
            },
          ],
          lifetime: 3,
        },
        targeting:
          "messageImpressions.NEW_SELECTABLE_PROFILE_SPOTLIGHT[messageImpressions.NEW_SELECTABLE_PROFILE_SPOTLIGHT | length - 1] < currentDate|date - 604800000 && !hasSelectableProfiles && !willShowDefaultPrompt && !activeNotifications && source == 'newtab' && previousSessionEnd",
      },
      {
        // Nimbus slug: account-adoption-app-menu-rollout:treatment-a
        // Version range: 141+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/account-adoption-app-menu-rollout/summary#treatment-a
        id: "DEVICE_MIGRATION_FXA_CTA_EXP1",
        groups: [],
        content: {
          layout: "row",
          imageURL:
            "chrome://browser/content/asrouter/assets/fox-with-devices.svg",
          imageWidth: 100,
          closeAction: {
            data: {
              id: "DEVICE_MIGRATION_FXA_CTA_EXP1",
            },
            type: "BLOCK_MESSAGE",
          },
          messageType: "fxa_cta",
          primaryText: {
            string_id: "fxa-menu-message-sync-devices-primary-text",
          },
          primaryAction: {
            data: {
              where: "tab",
              autoClose: false,
              extraParams: {
                utm_medium: "product",
                utm_source: "firefox-desktop",
                utm_content: "exp1-sync-devices",
                utm_campaign: "backup-pxi-exp",
              },
            },
            type: "FXA_SIGNIN_FLOW",
          },
          secondaryText: {
            string_id: "fxa-menu-message-sync-devices-secondary-text",
          },
          primaryActionText: {
            string_id: "fxa-menu-message-sign-up-button",
          },
          imageVerticalBottomOffset: -16,
          containerVerticalBottomOffset: 8,
        },
        trigger: {
          id: "menuOpened",
        },
        template: "menu_message",
        targeting: "source == 'pxi_menu'",
      },
      {
        // Nimbus slug: 2025-1st-run-new-tab-microsurvey-r-s-existing-users-us-ca-de-gb:treatment-a
        // Version range: 138+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/2025-1st-run-new-tab-microsurvey-r-s-existing-users-us-ca-de-gb/summary#treatment-a
        id: "NEWTAB_CSAT_SURVEY_2025_1",
        content: {
          id: "NEWTAB_CSAT_SURVEY_2025_1",
          screens: [
            {
              id: "NEWTAB_CSAT_SURVEY_1",
              anchors: [
                {
                  selector: "hbox#browser",
                  hide_arrow: true,
                  absolute_position: {
                    right: "20px",
                    bottom: "20px",
                  },
                },
              ],
              content: {
                tiles: {
                  data: [
                    {
                      id: "radio-not-relevant",
                      icon: {
                        style: {
                          width: "14px",
                          height: "14px",
                          marginInline: "0 0.5em",
                        },
                      },
                      type: "radio",
                      group: "radios",
                      label: {
                        raw: {
                          $l10n: {
                            id: "radio-not-relevant-label",
                            text: "Not at all relevant",
                            comment:
                              "Answer choice indicating that the New Tab Page is not relevant at all to the user",
                          },
                        },
                      },
                      action: {
                        data: {
                          pref: {
                            name: "messaging-system-action.newtab-csat-relevance",
                            value: "not-relevant",
                          },
                        },
                        type: "SET_PREF",
                      },
                      defaultValue: false,
                    },
                    {
                      id: "radio-slightly-relevant",
                      icon: {
                        style: {
                          width: "14px",
                          height: "14px",
                          marginInline: "0 0.5em",
                        },
                      },
                      type: "radio",
                      group: "radios",
                      label: {
                        raw: {
                          $l10n: {
                            id: "radio-slightly-relevant-label",
                            text: "Slightly relevant",
                            comment:
                              "Answer choice indicating that the New Tab Page is only slightly relevant to the user",
                          },
                        },
                      },
                      action: {
                        data: {
                          pref: {
                            name: "messaging-system-action.newtab-csat-relevance",
                            value: "slightly-relevant",
                          },
                        },
                        type: "SET_PREF",
                      },
                      defaultValue: false,
                    },
                    {
                      id: "radio-relevant",
                      icon: {
                        style: {
                          width: "14px",
                          height: "14px",
                          marginInline: "0 0.5em",
                        },
                      },
                      type: "radio",
                      group: "radios",
                      label: {
                        raw: {
                          $l10n: {
                            id: "radio-relevant-label",
                            text: "Relevant",
                            comment:
                              "Answer choice indicating that the New Tab Page is relevant to the user",
                          },
                        },
                      },
                      action: {
                        data: {
                          pref: {
                            name: "messaging-system-action.newtab-csat-relevance",
                            value: "relevant",
                          },
                        },
                        type: "SET_PREF",
                      },
                      defaultValue: false,
                    },
                    {
                      id: "radio-fairly-relevant",
                      icon: {
                        style: {
                          width: "14px",
                          height: "14px",
                          marginInline: "0 0.5em",
                        },
                      },
                      type: "radio",
                      group: "radios",
                      label: {
                        raw: {
                          $l10n: {
                            id: "radio-fairly-relevant-label",
                            text: "Fairly relevant",
                            comment:
                              "Answer choice indicating that the New Tab Page is fairly relevant to the user",
                          },
                        },
                      },
                      action: {
                        data: {
                          pref: {
                            name: "messaging-system-action.newtab-csat-relevance",
                            value: "fairly-relevant",
                          },
                        },
                        type: "SET_PREF",
                      },
                      defaultValue: false,
                    },
                    {
                      id: "radio-very-relevant",
                      icon: {
                        style: {
                          width: "14px",
                          height: "14px",
                          marginInline: "0 0.5em",
                        },
                      },
                      type: "radio",
                      group: "radios",
                      label: {
                        raw: {
                          $l10n: {
                            id: "radio-very-relevant-label",
                            text: "Very relevant",
                            comment:
                              "Answer choice indicating that the New Tab Page is very relevant to the user",
                          },
                        },
                      },
                      action: {
                        data: {
                          pref: {
                            name: "messaging-system-action.newtab-csat-relevance",
                            value: "very-relevant",
                          },
                        },
                        type: "SET_PREF",
                      },
                      defaultValue: false,
                    },
                    {
                      id: "radio-no-opinion",
                      icon: {
                        style: {
                          width: "14px",
                          height: "14px",
                          marginInline: "0 0.5em",
                        },
                      },
                      type: "radio",
                      group: "radios",
                      label: {
                        raw: {
                          $l10n: {
                            id: "radio-no-opinion-label",
                            text: "No opinion",
                            comment:
                              "Answer choice indicating that the user has no opinion about how relevant the New Tab Page is",
                          },
                        },
                      },
                      action: {
                        data: {
                          pref: {
                            name: "messaging-system-action.newtab-csat-relevance",
                            value: "no-opinion",
                          },
                        },
                        type: "SET_PREF",
                      },
                      defaultValue: false,
                    },
                  ],
                  type: "multiselect",
                  style: {
                    alignItems: "flex-start",
                    flexDirection: "column",
                  },
                },
                title: {
                  raw: {
                    $l10n: {
                      id: "question-title",
                      text: "Help Firefox improve this page",
                      comment:
                        "The title of a popup asking the user to give feedback by answering a short survey",
                    },
                  },
                  whiteSpace: "nowrap",
                  marginInline: "0 42px",
                },
                width: "min-content",
                layout: "survey",
                padding: "16",
                position: "callout",
                subtitle: {
                  raw: {
                    $l10n: {
                      id: "relevance-question",
                      text: "How relevant are the contents of this Firefox page to you?",
                      comment: "Survey question about relevance",
                    },
                  },
                },
                title_logo: {
                  imageURL: "chrome://branding/content/about-logo.png",
                  alignment: "top",
                },
                dismiss_button: {
                  size: "small",
                  action: {
                    data: {
                      actions: [
                        {
                          data: {
                            id: "NEWTAB_CSAT_SURVEY_2025_1",
                          },
                          type: "BLOCK_MESSAGE",
                        },
                        {
                          data: {
                            pref: {
                              name: "browser.newtab.feature-tour",
                            },
                          },
                          type: "SET_PREF",
                        },
                      ],
                    },
                    type: "MULTI_ACTION",
                    dismiss: true,
                  },
                  marginBlock: "12px 0",
                  marginInline: "0 12px",
                },
                secondary_button: {
                  label: {
                    raw: {
                      $l10n: {
                        id: "advance-button-label",
                        text: "Next",
                        comment:
                          "Label for the button that submits the user's response to question 1 and advances to question 2",
                      },
                    },
                  },
                  style: "primary",
                  action: {
                    data: {
                      actions: [
                        {
                          data: {
                            pref: {
                              name: "browser.newtab.feature-tour",
                              value:
                                '{"screen":"NEWTAB_CSAT_SURVEY_2","complete":false}',
                            },
                          },
                          type: "SET_PREF",
                        },
                      ],
                    },
                    type: "MULTI_ACTION",
                    collectSelect: true,
                  },
                  disabled: "hasActiveMultiSelect",
                },
                additional_button: {
                  label: {
                    raw: {
                      $l10n: {
                        id: "privacy-link-label",
                        text: "Privacy notice",
                        comment: "Text for the privacy notice link",
                      },
                    },
                  },
                  style: "link",
                  action: {
                    data: {
                      args: "https://www.mozilla.org/privacy/firefox/",
                      where: "tabshifted",
                    },
                    type: "OPEN_URL",
                  },
                  alignment: "space-between",
                },
              },
              force_hide_steps_indicator: true,
            },
            {
              id: "NEWTAB_CSAT_SURVEY_2",
              anchors: [
                {
                  selector: "hbox#browser",
                  hide_arrow: true,
                  absolute_position: {
                    right: "20px",
                    bottom: "20px",
                  },
                },
              ],
              content: {
                tiles: {
                  data: [
                    {
                      id: "radio-very-dissatisfied",
                      icon: {
                        style: {
                          width: "14px",
                          height: "14px",
                          marginInline: "0 0.5em",
                        },
                      },
                      type: "radio",
                      group: "radios",
                      label: {
                        raw: {
                          $l10n: {
                            id: "radio-very-dissatisfied-label",
                            text: "Very Dissatisfied",
                            comment:
                              "Answer choice indicating the least satisfaction with the New Tab Page",
                          },
                        },
                      },
                      action: {
                        data: {
                          pref: {
                            name: "messaging-system-action.newtab-csat-satisfaction",
                            value: "very-dissatisfied",
                          },
                        },
                        type: "SET_PREF",
                      },
                      defaultValue: false,
                    },
                    {
                      id: "radio-dissatisfied",
                      icon: {
                        style: {
                          width: "14px",
                          height: "14px",
                          marginInline: "0 0.5em",
                        },
                      },
                      type: "radio",
                      group: "radios",
                      label: {
                        raw: {
                          $l10n: {
                            id: "radio-dissatisfied-label",
                            text: "Dissatisfied",
                            comment:
                              "Answer choice indicating little satisfaction with the New Tab Page",
                          },
                        },
                      },
                      action: {
                        data: {
                          pref: {
                            name: "messaging-system-action.newtab-csat-satisfaction",
                            value: "dissatisfied",
                          },
                        },
                        type: "SET_PREF",
                      },
                      defaultValue: false,
                    },
                    {
                      id: "radio-neutral",
                      icon: {
                        style: {
                          width: "14px",
                          height: "14px",
                          marginInline: "0 0.5em",
                        },
                      },
                      type: "radio",
                      group: "radios",
                      label: {
                        raw: {
                          $l10n: {
                            id: "radio-neutral-label",
                            text: "Neutral",
                            comment:
                              "Answer choice indicating no strong feelings either way about the New Tab Page",
                          },
                        },
                      },
                      action: {
                        data: {
                          pref: {
                            name: "messaging-system-action.newtab-csat-satisfaction",
                            value: "neutral",
                          },
                        },
                        type: "SET_PREF",
                      },
                      defaultValue: false,
                    },
                    {
                      id: "radio-satisfied",
                      icon: {
                        style: {
                          width: "14px",
                          height: "14px",
                          marginInline: "0 0.5em",
                        },
                      },
                      type: "radio",
                      group: "radios",
                      label: {
                        raw: {
                          $l10n: {
                            id: "radio-satisfied-label",
                            text: "Satisfied",
                            comment:
                              "Answer choice indicating moderate satisfaction with the New Tab Page",
                          },
                        },
                      },
                      action: {
                        data: {
                          pref: {
                            name: "messaging-system-action.newtab-csat-satisfaction",
                            value: "satisfied",
                          },
                        },
                        type: "SET_PREF",
                      },
                      defaultValue: false,
                    },
                    {
                      id: "radio-very-satisfied",
                      icon: {
                        style: {
                          width: "14px",
                          height: "14px",
                          marginInline: "0 0.5em",
                        },
                      },
                      type: "radio",
                      group: "radios",
                      label: {
                        raw: {
                          $l10n: {
                            id: "radio-very-satisfied-label",
                            text: "Very Satisfied",
                            comment:
                              "Answer choice indicating the highest satisfaction with the New Tab Page",
                          },
                        },
                      },
                      action: {
                        data: {
                          pref: {
                            name: "messaging-system-action.newtab-csat-satisfaction",
                            value: "very-satisfied",
                          },
                        },
                        type: "SET_PREF",
                      },
                      defaultValue: false,
                    },
                    {
                      id: "radio-dont-use",
                      icon: {
                        style: {
                          width: "14px",
                          height: "14px",
                          marginInline: "0 0.5em",
                        },
                      },
                      type: "radio",
                      group: "radios",
                      label: {
                        raw: {
                          $l10n: {
                            id: "radio-dont-use-label",
                            text: "I don’t use it",
                            comment:
                              "Answer choice indicating that the user does not use the New Tab Page",
                          },
                        },
                      },
                      action: {
                        data: {
                          pref: {
                            name: "messaging-system-action.newtab-csat-satisfaction",
                            value: "dont-use",
                          },
                        },
                        type: "SET_PREF",
                      },
                      defaultValue: false,
                    },
                  ],
                  type: "multiselect",
                  style: {
                    alignItems: "flex-start",
                    flexDirection: "column",
                  },
                },
                title: {
                  raw: {
                    $l10n: {
                      id: "question-title",
                      text: "Help Firefox improve this page",
                      comment:
                        "The title of a popup asking the user to give feedback by answering a short survey",
                    },
                  },
                  whiteSpace: "nowrap",
                  marginInline: "0 42px",
                },
                width: "min-content",
                layout: "survey",
                padding: "16",
                position: "callout",
                subtitle: {
                  raw: {
                    $l10n: {
                      id: "satisfaction-question",
                      text: "How satisfied are you with this Firefox page?",
                      comment: "Survey question about satisfaction",
                    },
                  },
                },
                title_logo: {
                  imageURL: "chrome://branding/content/about-logo.png",
                  alignment: "top",
                },
                dismiss_button: {
                  size: "small",
                  action: {
                    data: {
                      actions: [
                        {
                          data: {
                            id: "NEWTAB_CSAT_SURVEY_2025_1",
                          },
                          type: "BLOCK_MESSAGE",
                        },
                        {
                          data: {
                            pref: {
                              name: "browser.newtab.feature-tour",
                            },
                          },
                          type: "SET_PREF",
                        },
                      ],
                    },
                    type: "MULTI_ACTION",
                    dismiss: true,
                  },
                  marginBlock: "12px 0",
                  marginInline: "0 12px",
                },
                secondary_button: {
                  label: {
                    raw: {
                      $l10n: {
                        id: "submit-button-label",
                        text: "Submit",
                        comment:
                          "Label for the button that submits the user's response to question 2 and finishes the survey",
                      },
                    },
                  },
                  style: "primary",
                  action: {
                    data: {
                      actions: [
                        {
                          data: {
                            pref: {
                              name: "browser.newtab.feature-tour",
                              value:
                                '{"screen":"NEWTAB_CSAT_SURVEY_3","complete":false}',
                            },
                          },
                          type: "SET_PREF",
                        },
                      ],
                    },
                    type: "MULTI_ACTION",
                    collectSelect: true,
                  },
                  disabled: "hasActiveMultiSelect",
                },
                additional_button: {
                  label: {
                    raw: {
                      $l10n: {
                        id: "privacy-link-label",
                        text: "Terms of use",
                        comment: "Text for the privacy notice link",
                      },
                    },
                  },
                  style: "link",
                  action: {
                    data: {
                      args: "https://www.mozilla.org/privacy/firefox/",
                      where: "tabshifted",
                    },
                    type: "OPEN_URL",
                  },
                  alignment: "space-between",
                },
              },
              force_hide_steps_indicator: true,
            },
            {
              id: "NEWTAB_CSAT_SURVEY_3",
              anchors: [
                {
                  selector: "hbox#browser",
                  hide_arrow: true,
                  absolute_position: {
                    right: "20px",
                    bottom: "20px",
                  },
                },
              ],
              content: {
                title: {
                  raw: {
                    $l10n: {
                      id: "thanks-toast-title",
                      text: "Thanks for your feedback!",
                      comment:
                        "Text displayed in a thank-you toast notification that appears briefly after the user submits their survey response",
                    },
                  },
                  whiteSpace: "nowrap",
                  marginInline: "0 42px",
                },
                width: "min-content",
                layout: "inline",
                position: "callout",
                title_logo: {
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/706c7a85-cf23-442e-8a92-7ebc7f537375.svg",
                  alignment: "top",
                },
                dismiss_button: {
                  action: {
                    data: {
                      pref: {
                        name: "browser.newtab.feature-tour",
                      },
                    },
                    type: "SET_PREF",
                    dismiss: true,
                  },
                },
                page_event_listeners: [
                  {
                    action: {
                      dismiss: true,
                    },
                    params: {
                      type: "timeout",
                      options: {
                        once: true,
                        interval: 5000,
                      },
                    },
                  },
                  {
                    action: {
                      data: {
                        id: "NEWTAB_CSAT_SURVEY_2025_1",
                      },
                      type: "BLOCK_MESSAGE",
                    },
                    params: {
                      type: "tourend",
                      options: {
                        once: true,
                      },
                    },
                  },
                ],
              },
              force_hide_steps_indicator: true,
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: false,
          tour_pref_name: "browser.newtab.feature-tour",
          disableHistoryUpdates: true,
          tour_pref_default_value:
            '{"screen":"NEWTAB_CSAT_SURVEY_1","complete":false}',
        },
        trigger: {
          id: "newtabFeatureCalloutCheck",
        },
        template: "feature_callout",
        targeting:
          "!isMajorUpgrade && !activeNotifications && userPrefs.cfrFeatures && previousSessionEnd",
      },
      {
        // Nimbus slug: account-spotlight-modal-global-rollout-v3:rollout
        // Version range: 133+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/account-spotlight-modal-global-rollout-v3/summary#rollout
        id: "DEVICE_MIGRATION_BACKUP_AND_SYNC_SPOTLIGHT",
        groups: ["eco"],
        content: {
          id: "DEVICE_MIGRATION_BACKUP_AND_SYNC_SPOTLIGHT",
          modal: "tab",
          screens: [
            {
              id: "DEVICE_MIGRATION_BACKUP_AND_SYNC_SPOTLIGHT_SYNC",
              content: {
                logo: {
                  height: "185px",
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/2f2e0abe-5fb7-4fcd-bf9e-2a7f24b2af0d.png",
                },
                title: {
                  fontSize: "24px",
                  string_id: "device-migration-fxa-spotlight-sync-header",
                  fontWeight: 590,
                  paddingBlock: "4px 0",
                  letterSpacing: 0,
                  paddingInline: "24px",
                },
                subtitle: {
                  fontSize: "15px",
                  string_id: "device-migration-fxa-spotlight-sync-body",
                  lineHeight: "1.4",
                  marginBlock: "8px 16px",
                  letterSpacing: 0,
                  paddingInline: "24px",
                },
                dismiss_button: {
                  action: {
                    navigate: true,
                  },
                },
                primary_button: {
                  label: {
                    string_id:
                      "device-migration-fxa-spotlight-sync-primary-button",
                    marginBlock: "4px 0",
                    paddingBlock: "0",
                    paddingInline: "16px",
                  },
                  action: {
                    data: {
                      entrypoint: "device-migration-spotlight-rollout-v3",
                      extraParams: {
                        utm_medium: "firefox-desktop",
                        utm_source: "spotlight-sync-and-backup",
                        utm_content: "sync",
                        utm_campaign: "migration",
                      },
                    },
                    type: "FXA_SIGNIN_FLOW",
                    navigate: true,
                  },
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: true,
        },
        trigger: {
          id: "defaultBrowserCheck",
        },
        template: "spotlight",
        frequency: {
          lifetime: 1,
        },
        targeting:
          "source == 'newtab' && !usesFirefoxSync && !hasActiveEnterprisePolicies",
      },
      {
        // Nimbus slug: onboarding-set-up-checklist-windows-rollout-july:treatment-branch (message 1 of 3)
        // Version range: 141+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/onboarding-set-up-checklist-windows-rollout-july/summary#treatment-branch
        id: "FINISH_SETUP_CHECKLIST",
        content: {
          id: "FINISH_SETUP_CHECKLIST",
          screens: [
            {
              id: "FINISH_SETUP_CHECKLIST",
              anchors: [
                {
                  selector: "#fxms-bmb-button",
                  panel_position: {
                    offset_y: 4,
                    anchor_attachment: "bottomcenter",
                    callout_attachment: "topright",
                  },
                  no_open_on_anchor: true,
                },
                {
                  selector: "#FINISH_SETUP_BUTTON",
                  panel_position: {
                    offset_y: 4,
                    anchor_attachment: "bottomcenter",
                    callout_attachment: "topright",
                  },
                  no_open_on_anchor: true,
                },
              ],
              content: {
                tiles: {
                  data: [
                    {
                      id: "action-checklist-set-to-default",
                      label: {
                        string_id: "onboarding-checklist-set-default",
                      },
                      action: {
                        type: "SET_DEFAULT_BROWSER",
                      },
                      targeting: "isDefaultBrowserUncached",
                    },
                    {
                      id: "action-checklist-pin-to-taskbar",
                      label: {
                        string_id: "onboarding-checklist-pin",
                      },
                      action: {
                        data: {
                          actions: [
                            {
                              type: "PIN_FIREFOX_TO_TASKBAR",
                            },
                            {
                              type: "PIN_FIREFOX_TO_START_MENU",
                            },
                          ],
                        },
                        type: "MULTI_ACTION",
                      },
                      targeting: "!doesAppNeedPinUncached",
                    },
                    {
                      id: "action-checklist-import-data",
                      label: {
                        string_id: "onboarding-checklist-import",
                      },
                      action: {
                        type: "SHOW_MIGRATION_WIZARD",
                      },
                      targeting:
                        "hasMigratedBookmarks || hasMigratedCSVPasswords || hasMigratedHistory || hasMigratedPasswords",
                      showExternalLinkIcon: true,
                    },
                    {
                      id: "action-checklist-explore-extensions",
                      label: {
                        string_id: "onboarding-checklist-extension",
                      },
                      action: {
                        data: {
                          actions: [
                            {
                              data: {
                                pref: {
                                  name: "messaging-system-action.hasOpenedExtensions",
                                  value: "true",
                                },
                              },
                              type: "SET_PREF",
                            },
                            {
                              data: {
                                args: "https://addons.mozilla.org/en-US/firefox/collections/4757633/b4d5649fb087446aa05add5f0258c3/?page=1&collection_sort=-popularity",
                                where: "current",
                              },
                              type: "OPEN_URL",
                            },
                          ],
                        },
                        type: "MULTI_ACTION",
                      },
                      targeting:
                        "'messaging-system-action.hasOpenedExtensions'|preferenceValue",
                      showExternalLinkIcon: true,
                    },
                    {
                      id: "action-checklist-sign-in",
                      label: {
                        string_id: "onboarding-checklist-sign-up",
                      },
                      action: {
                        data: {
                          entrypoint: "fx-onboarding-checklist",
                          extraParams: {
                            utm_medium: "firefox-desktop",
                            utm_source: "fx-new-device-sync",
                            utm_content: "migration-onboarding",
                            utm_campaign: "migration",
                          },
                        },
                        type: "FXA_SIGNIN_FLOW",
                      },
                      targeting: "isFxASignedIn",
                      showExternalLinkIcon: true,
                    },
                  ],
                  type: "action_checklist",
                },
                title: {
                  fontSize: "16px",
                  string_id: "onboarding-checklist-title",
                  fontWeight: "600",
                  marginInline: "3px 40px",
                },
                position: "callout",
                title_logo: {
                  imageURL: "chrome://branding/content/about-logo.png",
                  alignment: "top",
                },
                dismiss_button: {
                  action: {
                    data: {
                      actions: [
                        {
                          data: {
                            pref: {
                              name: "easyChecklist.open",
                              value: false,
                            },
                          },
                          type: "SET_PREF",
                        },
                      ],
                    },
                    type: "MULTI_ACTION",
                    dismiss: true,
                  },
                },
                page_event_listeners: [
                  {
                    action: {
                      data: {
                        pref: {
                          name: "messaging-system-action.easyChecklist.open",
                          value: "false",
                        },
                      },
                      type: "SET_PREF",
                    },
                    params: {
                      type: "tourend",
                    },
                  },
                ],
                action_checklist_subtitle: {
                  string_id: "onboarding-checklist-subtitle",
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: false,
          disableHistoryUpdates: true,
        },
        trigger: {
          id: "preferenceObserver",
          params: ["messaging-system-action.easyChecklist.open"],
        },
        priority: 3,
        template: "feature_callout",
        targeting:
          "'messaging-system-action.easyChecklist.open' | preferenceValue == true",
      },
      {
        // Nimbus slug: onboarding-set-up-checklist-windows-rollout-july:treatment-branch (message 2 of 3)
        // Version range: 141+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/onboarding-set-up-checklist-windows-rollout-july/summary#treatment-branch
        id: "FINISH_SETUP_CHECKLIST",
        content: {
          id: "FINISH_SETUP_CHECKLIST",
          screens: [
            {
              id: "FINISH_SETUP_CHECKLIST",
              anchors: [
                {
                  selector: "#fxms-bmb-button",
                  panel_position: {
                    offset_y: 4,
                    anchor_attachment: "bottomcenter",
                    callout_attachment: "topright",
                  },
                  no_open_on_anchor: true,
                },
                {
                  selector: "#FINISH_SETUP_BUTTON",
                  panel_position: {
                    offset_y: 4,
                    anchor_attachment: "bottomcenter",
                    callout_attachment: "topright",
                  },
                  no_open_on_anchor: true,
                },
                {
                  selector: "#PersonalToolbar",
                  hide_arrow: true,
                  panel_position: {
                    offset_x: -24,
                    offset_y: 24,
                    anchor_attachment: "bottomright",
                    callout_attachment: "topright",
                  },
                  no_open_on_anchor: true,
                },
              ],
              content: {
                tiles: {
                  data: [
                    {
                      id: "action-checklist-set-to-default",
                      label: {
                        string_id: "onboarding-checklist-set-default",
                      },
                      action: {
                        type: "SET_DEFAULT_BROWSER",
                      },
                      targeting: "isDefaultBrowserUncached",
                    },
                    {
                      id: "action-checklist-pin-to-taskbar",
                      label: {
                        string_id: "onboarding-checklist-pin",
                      },
                      action: {
                        data: {
                          actions: [
                            {
                              type: "PIN_FIREFOX_TO_TASKBAR",
                            },
                            {
                              type: "PIN_FIREFOX_TO_START_MENU",
                            },
                          ],
                        },
                        type: "MULTI_ACTION",
                      },
                      targeting: "!doesAppNeedPinUncached",
                    },
                    {
                      id: "action-checklist-import-data",
                      label: {
                        string_id: "onboarding-checklist-import",
                      },
                      action: {
                        type: "SHOW_MIGRATION_WIZARD",
                      },
                      targeting:
                        "hasMigratedBookmarks || hasMigratedCSVPasswords || hasMigratedHistory || hasMigratedPasswords",
                      showExternalLinkIcon: true,
                    },
                    {
                      id: "action-checklist-explore-extensions",
                      label: {
                        string_id: "onboarding-checklist-extension",
                      },
                      action: {
                        data: {
                          actions: [
                            {
                              data: {
                                pref: {
                                  name: "messaging-system-action.hasOpenedExtensions",
                                  value: "true",
                                },
                              },
                              type: "SET_PREF",
                            },
                            {
                              data: {
                                args: "https://addons.mozilla.org/en-US/firefox/collections/4757633/b4d5649fb087446aa05add5f0258c3/?page=1&collection_sort=-popularity",
                                where: "current",
                              },
                              type: "OPEN_URL",
                            },
                          ],
                        },
                        type: "MULTI_ACTION",
                      },
                      targeting:
                        "'messaging-system-action.hasOpenedExtensions'|preferenceValue",
                      showExternalLinkIcon: true,
                    },
                    {
                      id: "action-checklist-sign-in",
                      label: {
                        string_id: "onboarding-checklist-sign-up",
                      },
                      action: {
                        data: {
                          entrypoint: "fx-onboarding-checklist",
                          extraParams: {
                            utm_medium: "firefox-desktop",
                            utm_source: "fx-new-device-sync",
                            utm_content: "migration-onboarding",
                            utm_campaign: "migration",
                          },
                        },
                        type: "FXA_SIGNIN_FLOW",
                      },
                      targeting: "isFxASignedIn",
                      showExternalLinkIcon: true,
                    },
                  ],
                  type: "action_checklist",
                },
                title: {
                  fontSize: "16px",
                  string_id: "onboarding-checklist-title",
                  fontWeight: "600",
                  marginInline: "3px 40px",
                },
                position: "callout",
                title_logo: {
                  imageURL: "chrome://branding/content/about-logo.png",
                  alignment: "top",
                },
                dismiss_button: {
                  action: {
                    data: {
                      actions: [
                        {
                          data: {
                            pref: {
                              name: "easyChecklist.open",
                              value: false,
                            },
                          },
                          type: "SET_PREF",
                        },
                      ],
                    },
                    type: "MULTI_ACTION",
                    dismiss: true,
                  },
                },
                page_event_listeners: [
                  {
                    action: {
                      data: {
                        pref: {
                          name: "messaging-system-action.easyChecklist.open",
                          value: "false",
                        },
                      },
                      type: "SET_PREF",
                    },
                    params: {
                      type: "tourend",
                    },
                  },
                ],
                action_checklist_subtitle: {
                  string_id: "onboarding-checklist-subtitle",
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: false,
          disableHistoryUpdates: true,
        },
        trigger: {
          id: "messagesLoaded",
        },
        priority: 3,
        template: "feature_callout",
        targeting:
          "'messaging-system-action.easyChecklist.open' | preferenceValue == true",
      },
      {
        // Nimbus slug: onboarding-set-up-checklist-windows-rollout-july:treatment-branch (message 3 of 3)
        // Version range: 141+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/onboarding-set-up-checklist-windows-rollout-july/summary#treatment-branch
        id: "FINISH_SETUP_CHECKLIST_AUTO_OPEN",
        content: {
          id: "FINISH_SETUP_CHECKLIST",
          screens: [
            {
              id: "FINISH_SETUP_CHECKLIST",
              anchors: [
                {
                  selector: "#fxms-bmb-button",
                  panel_position: {
                    offset_y: 4,
                    anchor_attachment: "bottomcenter",
                    callout_attachment: "topright",
                  },
                  no_open_on_anchor: true,
                },
                {
                  selector: "#FINISH_SETUP_BUTTON",
                  panel_position: {
                    offset_y: 4,
                    anchor_attachment: "bottomcenter",
                    callout_attachment: "topright",
                  },
                  no_open_on_anchor: true,
                },
              ],
              content: {
                tiles: {
                  data: [
                    {
                      id: "action-checklist-set-to-default",
                      label: {
                        string_id: "onboarding-checklist-set-default",
                      },
                      action: {
                        type: "SET_DEFAULT_BROWSER",
                      },
                      targeting: "isDefaultBrowserUncached",
                    },
                    {
                      id: "action-checklist-pin-to-taskbar",
                      label: {
                        string_id: "onboarding-checklist-pin",
                      },
                      action: {
                        data: {
                          actions: [
                            {
                              type: "PIN_FIREFOX_TO_TASKBAR",
                            },
                            {
                              type: "PIN_FIREFOX_TO_START_MENU",
                            },
                          ],
                        },
                        type: "MULTI_ACTION",
                      },
                      targeting: "!doesAppNeedPinUncached",
                    },
                    {
                      id: "action-checklist-import-data",
                      label: {
                        string_id: "onboarding-checklist-import",
                      },
                      action: {
                        type: "SHOW_MIGRATION_WIZARD",
                      },
                      targeting:
                        "hasMigratedBookmarks || hasMigratedCSVPasswords || hasMigratedHistory || hasMigratedPasswords",
                      showExternalLinkIcon: true,
                    },
                    {
                      id: "action-checklist-explore-extensions",
                      label: {
                        string_id: "onboarding-checklist-extension",
                      },
                      action: {
                        data: {
                          actions: [
                            {
                              data: {
                                pref: {
                                  name: "messaging-system-action.hasOpenedExtensions",
                                  value: "true",
                                },
                              },
                              type: "SET_PREF",
                            },
                            {
                              data: {
                                args: "https://addons.mozilla.org/en-US/firefox/collections/4757633/b4d5649fb087446aa05add5f0258c3/?page=1&collection_sort=-popularity",
                                where: "current",
                              },
                              type: "OPEN_URL",
                            },
                          ],
                        },
                        type: "MULTI_ACTION",
                      },
                      targeting:
                        "'messaging-system-action.hasOpenedExtensions'|preferenceValue",
                      showExternalLinkIcon: true,
                    },
                    {
                      id: "action-checklist-sign-in",
                      label: {
                        string_id: "onboarding-checklist-sign-up",
                      },
                      action: {
                        data: {
                          entrypoint: "fx-onboarding-checklist",
                          extraParams: {
                            utm_medium: "firefox-desktop",
                            utm_source: "fx-new-device-sync",
                            utm_content: "migration-onboarding",
                            utm_campaign: "migration",
                          },
                        },
                        type: "FXA_SIGNIN_FLOW",
                      },
                      targeting: "isFxASignedIn",
                      showExternalLinkIcon: true,
                    },
                  ],
                  type: "action_checklist",
                },
                title: {
                  fontSize: "16px",
                  string_id: "onboarding-checklist-title",
                  fontWeight: "600",
                  marginInline: "3px 40px",
                },
                position: "callout",
                title_logo: {
                  imageURL: "chrome://branding/content/about-logo.png",
                  alignment: "top",
                },
                dismiss_button: {
                  action: {
                    data: {
                      actions: [
                        {
                          data: {
                            pref: {
                              name: "easyChecklist.open",
                              value: false,
                            },
                          },
                          type: "SET_PREF",
                        },
                      ],
                    },
                    type: "MULTI_ACTION",
                    dismiss: true,
                  },
                },
                page_event_listeners: [
                  {
                    action: {
                      data: {
                        pref: {
                          name: "messaging-system-action.easyChecklist.open",
                          value: "false",
                        },
                      },
                      type: "SET_PREF",
                    },
                    params: {
                      type: "tourend",
                    },
                  },
                ],
                action_checklist_subtitle: {
                  string_id: "onboarding-checklist-subtitle",
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: false,
          disableHistoryUpdates: true,
        },
        trigger: {
          id: "nthTabClosed",
        },
        priority: 3,
        template: "feature_callout",
        frequency: {
          custom: [
            {
              cap: 1,
              period: 86400000,
            },
          ],
          lifetime: 3,
        },
        targeting:
          "!hasActiveEnterprisePolicies && (tabsClosedCount == 4 || tabsClosedCount == 12 || tabsClosedCount == 24) && (!isDefaultBrowserUncached || doesAppNeedPinUncached || (!hasMigratedBookmarks || !hasMigratedCSVPasswords || !hasMigratedHistory || !hasMigratedPasswords) || !'messaging-system-action.hasOpenedExtensions'|preferenceValue || !isFxASignedIn)",
      },
      {
        // Nimbus slug: onboarding-set-up-checklist-windows-rollout-july:treatment-branch
        // Version range: 141+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/onboarding-set-up-checklist-windows-rollout-july/summary#treatment-branch
        id: "FINISH_SETUP_BUTTON",
        groups: [],
        weight: 100,
        content: {
          logo: {
            imageURL: "chrome://branding/content/about-logo.png",
          },
          label: {
            string_id: "onboarding-aw-finish-setup-button",
          },
          action: {
            data: {
              pref: {
                name: "easyChecklist.open",
                value: true,
              },
            },
            type: "SET_PREF",
          },
        },
        trigger: {
          id: "defaultBrowserCheck",
        },
        priority: 1,
        template: "bookmarks_bar_button",
        targeting: "!hasActiveEnterprisePolicies",
      },
      {
        // Nimbus slug: account-adoption-callout-passwords-global-rollout:treatment-e
        // Version range: 141+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/account-adoption-callout-passwords-global-rollout/summary#treatment-e
        id: "FXA_ACCOUNT_ADOPTION_PASSWORDS",
        groups: ["cfr"],
        content: {
          id: "FXA_ACCOUNT_ADOPTION_PASSWORDS",
          screens: [
            {
              id: "FXA_ACCOUNT_ADOPTION_PASSWORDS_E",
              anchors: [
                {
                  selector: "#fxa-toolbar-menu-button",
                  arrow_width: "15.5563",
                  panel_position: {
                    anchor_attachment: "bottomcenter",
                    callout_attachment: "topright",
                    panel_position_string: "bottomcenter topright",
                  },
                  no_open_on_anchor: true,
                },
              ],
              content: {
                logo: {
                  width: "104px",
                  height: "94px",
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/ccb352db-36d2-4084-8bba-d382ab7baf77.svg",
                  alignment: "top",
                  marginBlock: "0 -4px",
                  marginInline: "0 14px",
                },
                title: {
                  string_id: "fxa-adoption-passwords-title",
                },
                width: "300px",
                position: "callout",
                subtitle: {
                  string_id: "fxa-adoption-passwords-subtitle",
                },
                submenu_button: {
                  submenu: [
                    {
                      id: "block_recommendation",
                      type: "action",
                      label: {
                        string_id: "split-dismiss-button-dont-show-option",
                      },
                      action: {
                        data: {
                          id: "FXA_ACCOUNT_ADOPTION_PASSWORDS",
                        },
                        type: "BLOCK_MESSAGE",
                        dismiss: true,
                      },
                    },
                    {
                      id: "show_fewer_recommendations",
                      type: "action",
                      label: {
                        string_id: "split-dismiss-button-show-fewer-option",
                      },
                      action: {
                        data: {
                          actions: [
                            {
                              data: {
                                pref: {
                                  name: "messaging-system-action.fxa-adoption-passwords",
                                  value: true,
                                },
                              },
                              type: "SET_PREF",
                            },
                            {
                              data: {
                                id: "FXA_ACCOUNT_ADOPTION_PASSWORDS",
                              },
                              type: "BLOCK_MESSAGE",
                            },
                          ],
                        },
                        type: "MULTI_ACTION",
                        dismiss: true,
                      },
                    },
                    {
                      type: "separator",
                    },
                    {
                      id: "manage_settings",
                      type: "action",
                      label: {
                        string_id:
                          "split-dismiss-button-manage-settings-option",
                      },
                      action: {
                        data: {
                          args: "preferences#general-cfrfeatures",
                          where: "tab",
                        },
                        type: "OPEN_ABOUT_PAGE",
                        dismiss: true,
                      },
                    },
                  ],
                  attached_to: "additional_button",
                },
                secondary_button: {
                  label: {
                    string_id: "fxa-adoption-passwords-primary-button-label",
                  },
                  style: "primary",
                  action: {
                    data: {
                      entrypoint: "callout-password",
                      extraParams: {
                        utm_medium: "firefox-desktop",
                        utm_source: "callout",
                        utm_content: "password-sync-global-rollout",
                        utm_campaign: "save-password-callout-global-rollout",
                      },
                    },
                    type: "FXA_SIGNIN_FLOW",
                    navigate: true,
                  },
                },
                additional_button: {
                  label: {
                    string_id: "fx-view-discoverability-secondary-button-label",
                  },
                  style: "secondary",
                  action: {
                    dismiss: true,
                  },
                },
                page_event_listeners: [
                  {
                    action: {
                      dismiss: true,
                    },
                    params: {
                      type: "click",
                      selectors: "#fxa-toolbar-menu-button",
                    },
                  },
                ],
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: false,
        },
        trigger: {
          id: "newSavedLogin",
        },
        priority: 1,
        template: "feature_callout",
        frequency: {
          custom: [
            {
              cap: 1,
              period: 1209600000,
            },
          ],
          lifetime: 2,
        },
        targeting:
          "(currentDate|date - profileAgeCreated|date) / 86400000 >= 7 && !isFxASignedIn && type == 'save' && !isMajorUpgrade && !willShowDefaultPrompt && !activeNotifications && previousSessionEnd && 'browser.newtabpage.activity-stream.asrouter.userprefs.cfr.features' | preferenceValue == true",
      },
      {
        // Nimbus slug: 1-callout-contextual-chatbot-suggestion-treatment-a-tab-switching-copy-rollout:treatment-a-tab-switching-copy
        // Version range: 139+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/1-callout-contextual-chatbot-suggestion-treatment-a-tab-switching-copy-rollout/summary#treatment-a-tab-switching-copy
        id: "SIDEBAR-CHATBOT-SINGLE",
        groups: ["cfr"],
        content: {
          id: "SIDEBAR-CHATBOT-SINGLE",
          screens: [
            {
              id: "SIDEBAR-CHATBOT_1",
              anchors: [
                {
                  selector: ".tab-icon-stack[selected]",
                  panel_position: {
                    offset_x: -3,
                    offset_y: 9,
                    anchor_attachment: "bottomcenter",
                    callout_attachment: "topleft",
                  },
                },
              ],
              content: {
                logo: {
                  height: "200px",
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/e73326e4-3b5a-42e3-a61a-6d78f2fafbff.svg",
                  darkModeImageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/a2a2516e-a756-4f8b-9826-6a6359e75096.svg",
                },
                title: {
                  string_id: "genai-chatbot-contextual-title",
                },
                width: "352px",
                padding: 16,
                position: "callout",
                subtitle: {
                  string_id: "genai-chatbot-contextual-subtitle",
                },
                dismiss_button: {
                  size: "small",
                  action: {
                    dismiss: true,
                  },
                  marginBlock: "20px 0",
                  marginInline: "0 20px",
                },
                secondary_button: {
                  label: {
                    string_id: "genai-chatbot-contextual-button",
                  },
                  style: "primary",
                  action: {
                    data: {
                      actions: [
                        {
                          data: {
                            pref: {
                              name: "sidebar.revamp",
                              value: true,
                            },
                          },
                          type: "SET_PREF",
                        },
                        {
                          data: "viewGenaiChatSidebar",
                          type: "OPEN_SIDEBAR",
                        },
                      ],
                    },
                    type: "MULTI_ACTION",
                    dismiss: true,
                  },
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: false,
          disableHistoryUpdates: true,
        },
        trigger: {
          id: "openURL",
          params: [
            "chat.mistral.ai",
            "chatgpt.com",
            "claude.ai",
            "gemini.google.com",
            "mistral.ai",
          ],
          patterns: ["*://huggingface.co/chat/*"],
        },
        template: "feature_callout",
        frequency: {
          custom: [
            {
              cap: 1,
              period: 604800000,
            },
          ],
          lifetime: 2,
        },
        targeting:
          "'browser.ml.chat.enabled'|preferenceValue && 'browser.ml.chat.provider'|preferenceValue == ''",
      },
      {
        // Nimbus slug: vertical-tabs-feature-callout-experiment-v20-treatment-a-rollout:treatment-a
        // Version range: 138+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/vertical-tabs-feature-callout-experiment-v20-treatment-a-rollout/summary#treatment-a
        id: "VERTICAL_TABS_INTRO_138",
        groups: [],
        content: {
          id: "VERTICAL_TABS_INTRO_138",
          screens: [
            {
              id: "VERTICAL_TABS_INTRO_138",
              anchors: [
                {
                  selector: "#urlbar-container ~ #sidebar-button",
                  panel_position: {
                    anchor_attachment: "rightcenter",
                    callout_attachment: "topright",
                  },
                },
                {
                  selector: "#sidebar-button",
                  panel_position: {
                    anchor_attachment: "rightcenter",
                    callout_attachment: "topleft",
                  },
                },
              ],
              content: {
                title: {
                  string_id: "vertical-tabs-callout-1-title",
                  marginInline: "4px 4px",
                },
                width: "324px",
                padding: 16,
                position: "callout",
                subtitle: {
                  string_id: "vertical-tabs-callout-1-subtitle",
                  marginInline: "4px 4px",
                },
                dismiss_button: {
                  size: "small",
                  action: {
                    dismiss: true,
                  },
                  marginBlock: "14px 0",
                  marginInline: "0 14px",
                },
                primary_button: {
                  label: {
                    string_id: "vertical-tabs-callout-1-cta-button",
                  },
                  action: {
                    data: {
                      actions: [
                        {
                          data: "viewCustomizeSidebar",
                          type: "OPEN_SIDEBAR",
                        },
                        {
                          data: {
                            pref: {
                              name: "messaging-system-action.vertical-callout-sidebar-customize-1",
                            },
                          },
                          type: "SET_PREF",
                        },
                      ],
                    },
                    type: "MULTI_ACTION",
                    dismiss: true,
                  },
                },
                page_event_listeners: [
                  {
                    action: {
                      dismiss: true,
                    },
                    params: {
                      type: "click",
                      selectors: "#sidebar-button",
                    },
                  },
                ],
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: false,
          disableHistoryUpdates: true,
        },
        trigger: {
          id: "nthTabOpened",
        },
        template: "feature_callout",
        frequency: {
          lifetime: 1,
        },
        targeting:
          "!'sidebar.verticalTabs'|preferenceValue && currentTabsOpen >= 8",
      },
      {
        // Nimbus slug: upgraded-sidebar-138-broad-rollout:rollout-treatment
        // Version range: 138+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/upgraded-sidebar-138-broad-rollout/summary#rollout-treatment
        id: "SIDEBAR_INTRO_138",
        groups: ["cfr"],
        content: {
          id: "SIDEBAR_INTRO_138",
          screens: [
            {
              id: "SIDEBAR_INTRO_138_2",
              anchors: [
                {
                  selector: "#urlbar-container ~ #sidebar-button",
                  panel_position: {
                    anchor_attachment: "rightcenter",
                    callout_attachment: "topright",
                  },
                },
                {
                  selector: "#sidebar-button",
                  panel_position: {
                    anchor_attachment: "rightcenter",
                    callout_attachment: "topleft",
                  },
                },
              ],
              content: {
                title: {
                  string_id: "sidebar-customization-callout-2-title",
                  marginInline: "4px 4px",
                },
                width: "324px",
                padding: 16,
                position: "callout",
                subtitle: {
                  string_id: "sidebar-customization-callout-2-subtitle",
                  marginInline: "4px 4px",
                },
                dismiss_button: {
                  size: "small",
                  action: {
                    dismiss: true,
                  },
                  marginBlock: "14px 0",
                  marginInline: "0 14px",
                },
                primary_button: {
                  label: {
                    string_id: "sidebar-customization-callout-callout-button",
                  },
                  action: {
                    data: {
                      actions: [
                        {
                          data: "viewCustomizeSidebar",
                          type: "OPEN_SIDEBAR",
                        },
                        {
                          data: {
                            pref: {
                              name: "messaging-system-action.sidebar-customize-138",
                            },
                          },
                          type: "SET_PREF",
                        },
                      ],
                    },
                    type: "MULTI_ACTION",
                    dismiss: true,
                  },
                },
                page_event_listeners: [
                  {
                    action: {
                      dismiss: true,
                    },
                    params: {
                      type: "click",
                      selectors: "#sidebar-button",
                    },
                  },
                ],
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: false,
          disableHistoryUpdates: true,
        },
        trigger: {
          id: "openURL",
          patterns: ["*://*/*"],
        },
        template: "feature_callout",
        frequency: {
          lifetime: 1,
        },
        targeting: "true",
      },
      {
        // Nimbus slug: unified-search-button-callout-rollout-v1:control (message 1 of 4)
        // Version range: 138+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/unified-search-button-callout-rollout-v1/summary#control
        id: "UNIFIED_SEARCH_CALLOUT_WITH_SCREENSHOT",
        groups: ["cfr"],
        content: {
          id: "UNIFIED_SEARCH_CALLOUT_WITH_SCREENSHOT",
          screens: [
            {
              id: "UNIFIED_SEARCH_CALLOUT_WITH_SCREENSHOT_USB",
              anchors: [
                {
                  selector: ".urlbar-input-container",
                  arrow_width: "26.9",
                  panel_position: {
                    offset_x: 16,
                    anchor_attachment: "bottomleft",
                    callout_attachment: "topleft",
                  },
                },
              ],
              content: {
                logo: {
                  height: "168px",
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/bec3b8d9-a658-4877-b96e-70f7bc6e3e42.svg",
                },
                title: {
                  string_id: "unified-search-callout-title",
                  paddingInline: "0 20px",
                },
                width: "333px",
                padding: 16,
                position: "callout",
                subtitle: {
                  string_id: "unified-search-callout-subtitle",
                  marginBlock: "-12px 0",
                  paddingInline: "42px 20px",
                },
                title_logo: {
                  width: "32px",
                  height: "34px",
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/2ff87710-8c83-41cd-a2b4-99d0c7ec67f1.svg",
                  alignment: "top",
                  marginBlock: "4px 0",
                  marginInline: "8px 18px",
                },
                primary_button: {
                  label: {
                    string_id: "unified-search-callout-primary-label",
                  },
                  action: {
                    data: {
                      pref: {
                        name: "messaging-system-action.unifiedsearch.feature-tour-1",
                        value:
                          '{"screen":"UNIFIED_SEARCH_CALLOUT_WITH_SCREENSHOT_ENGINE","complete": false}',
                      },
                    },
                    type: "SET_PREF",
                  },
                },
                secondary_button: {
                  label: {
                    string_id: "unified-search-callout-secondary-label",
                  },
                  action: {
                    dismiss: true,
                  },
                },
              },
            },
            {
              id: "UNIFIED_SEARCH_CALLOUT_WITH_SCREENSHOT_ENGINE",
              anchors: [
                {
                  selector: ".urlbar-input-container",
                  arrow_width: "26.9",
                  panel_position: {
                    offset_x: 16,
                    anchor_attachment: "bottomleft",
                    callout_attachment: "topleft",
                  },
                },
              ],
              content: {
                logo: {
                  height: "168px",
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/97b96045-1e85-439a-b8ba-e32fc6ad8886.svg",
                },
                title: {
                  string_id: "unified-search-engines-callout-title",
                  paddingInline: "0 20px",
                },
                width: "332px",
                padding: 16,
                position: "callout",
                subtitle: {
                  string_id: "unified-search-engines-callout-subtitle",
                  marginBlock: "-12px 0",
                  paddingInline: "42px 30px",
                },
                title_logo: {
                  width: "32px",
                  height: "34px",
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/2ff87710-8c83-41cd-a2b4-99d0c7ec67f1.svg",
                  alignment: "top",
                  marginBlock: "4px 0",
                  marginInline: "8px 18px",
                },
                primary_button: {
                  label: {
                    string_id: "unified-search-engines-callout-primary-label",
                  },
                  action: {
                    dismiss: true,
                  },
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: true,
          tour_pref_name:
            "messaging-system-action.unifiedsearch.feature-tour-1",
          tour_pref_default_value:
            '{"screen":"UNIFIED_SEARCH_CALLOUT_WITH_SCREENSHOT_USB","complete":false}',
        },
        trigger: {
          id: "defaultBrowserCheck",
        },
        template: "feature_callout",
        frequency: {
          lifetime: 1,
        },
        targeting:
          "('browser.urlbar.scotchBonnet.enableOverride' | preferenceValue) && localeLanguageCode == 'en' && source == 'newtab' && !willShowDefaultPrompt && ((currentDate|date - profileAgeCreated|date) / 86400000 > 28)",
      },
      {
        // Nimbus slug: unified-search-button-callout-rollout-v1:control (message 2 of 4)
        // Version range: 138+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/unified-search-button-callout-rollout-v1/summary#control
        id: "UNIFIED_SEARCH_CALLOUT_WITHOUT_SCREENSHOT",
        groups: ["cfr"],
        content: {
          id: "UNIFIED_SEARCH_CALLOUT_WITHOUT_SCREENSHOT",
          screens: [
            {
              id: "UNIFIED_SEARCH_CALLOUT_WITHOUT_SCREENSHOT_USB",
              anchors: [
                {
                  selector: ".urlbar-input-container",
                  arrow_width: "26.9",
                  panel_position: {
                    offset_x: 16,
                    anchor_attachment: "bottomleft",
                    callout_attachment: "topleft",
                  },
                },
              ],
              content: {
                logo: null,
                title: {
                  string_id: "unified-search-callout-title",
                  paddingInline: "0 20px",
                },
                width: "333px",
                padding: 16,
                position: "callout",
                subtitle: {
                  string_id: "unified-search-callout-subtitle",
                  marginBlock: "-12px 0",
                  paddingInline: "42px 20px",
                },
                title_logo: {
                  width: "32px",
                  height: "34px",
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/2ff87710-8c83-41cd-a2b4-99d0c7ec67f1.svg",
                  alignment: "top",
                  marginBlock: "4px 0",
                  marginInline: "8px 18px",
                },
                primary_button: {
                  label: {
                    string_id: "unified-search-callout-primary-label",
                  },
                  action: {
                    data: {
                      pref: {
                        name: "messaging-system-action.unifiedsearch.feature-tour-2",
                        value:
                          '{"screen":"UNIFIED_SEARCH_CALLOUT_WITHOUT_SCREENSHOT_ENGINE","complete": false}',
                      },
                    },
                    type: "SET_PREF",
                  },
                },
                secondary_button: {
                  label: {
                    string_id: "unified-search-callout-secondary-label",
                  },
                  action: {
                    dismiss: true,
                  },
                },
              },
            },
            {
              id: "UNIFIED_SEARCH_CALLOUT_WITHOUT_SCREENSHOT_ENGINE",
              anchors: [
                {
                  selector: ".urlbar-input-container",
                  arrow_width: "26.9",
                  panel_position: {
                    offset_x: 16,
                    anchor_attachment: "bottomleft",
                    callout_attachment: "topleft",
                  },
                },
              ],
              content: {
                logo: null,
                title: {
                  string_id: "unified-search-engines-callout-title",
                  paddingInline: "0 20px",
                },
                width: "332px",
                padding: 16,
                position: "callout",
                subtitle: {
                  string_id: "unified-search-engines-callout-subtitle",
                  marginBlock: "-12px -8px",
                  paddingInline: "42px 20px",
                },
                title_logo: {
                  width: "32px",
                  height: "34px",
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/2ff87710-8c83-41cd-a2b4-99d0c7ec67f1.svg",
                  alignment: "top",
                  marginBlock: "4px 0",
                  marginInline: "8px 18px",
                },
                primary_button: {
                  label: {
                    string_id: "unified-search-engines-callout-primary-label",
                  },
                  action: {
                    dismiss: true,
                  },
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: true,
          tour_pref_name:
            "messaging-system-action.unifiedsearch.feature-tour-2",
          tour_pref_default_value:
            '{"screen":"UNIFIED_SEARCH_CALLOUT_WITHOUT_SCREENSHOT_USB","complete": false}',
        },
        trigger: {
          id: "defaultBrowserCheck",
        },
        template: "feature_callout",
        frequency: {
          lifetime: 1,
        },
        targeting:
          "('browser.urlbar.scotchBonnet.enableOverride' | preferenceValue) && localeLanguageCode != 'en' && source == 'newtab' && !willShowDefaultPrompt && ((currentDate|date - profileAgeCreated|date) / 86400000 > 28)",
      },
      {
        // Nimbus slug: unified-search-button-callout-rollout-v1:control (message 3 of 4)
        // Version range: 138+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/unified-search-button-callout-rollout-v1/summary#control
        id: "ACTIONS_CALLOUT_WITH_SCREENSHOT",
        groups: ["cfr"],
        content: {
          id: "ACTIONS_CALLOUT",
          screens: [
            {
              id: "ACTIONS_CALLOUT_WITH_SCREENSHOT",
              anchors: [
                {
                  selector: ".urlbar-input-container",
                  arrow_width: "26.9",
                  panel_position: {
                    offset_x: 16,
                    anchor_attachment: "bottomleft",
                    callout_attachment: "topleft",
                  },
                },
              ],
              content: {
                logo: {
                  height: "168px",
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/bde7e406-f576-4154-ba9c-b5f472b6f4c8.svg",
                },
                title: {
                  string_id: "actions-callout-title",
                  paddingInline: "0 20px",
                },
                width: "333px",
                padding: 16,
                position: "callout",
                subtitle: {
                  string_id: "actions-callout-subtitle",
                  marginBlock: "0 10px",
                  paddingInline: "42px 20px",
                },
                title_logo: {
                  width: "32px",
                  height: "34px",
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/2ff87710-8c83-41cd-a2b4-99d0c7ec67f1.svg",
                  alignment: "top",
                  marginBlock: "4px 0",
                  marginInline: "8px 18px",
                },
                dismiss_button: {
                  size: "small",
                  action: {
                    dismiss: true,
                  },
                  marginBlock: "20px 0",
                  marginInline: "0 20px",
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: false,
        },
        trigger: {
          id: "defaultBrowserCheck",
        },
        template: "feature_callout",
        frequency: {
          lifetime: 1,
        },
        targeting:
          "('browser.urlbar.scotchBonnet.enableOverride' | preferenceValue) && localeLanguageCode == 'en' && source == 'newtab' && !willShowDefaultPrompt && ((currentDate|date - profileAgeCreated|date) / 86400000 > 28) && (messageImpressions.UNIFIED_SEARCH_CALLOUT_WITH_SCREENSHOT[messageImpressions.UNIFIED_SEARCH_CALLOUT_WITH_SCREENSHOT | length - 1] < currentDate|date - 172800000)",
      },
      {
        // Nimbus slug: unified-search-button-callout-rollout-v1:control (message 4 of 4)
        // Version range: 138+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/unified-search-button-callout-rollout-v1/summary#control
        id: "ACTIONS_CALLOUT_WITHOUT_SCREENSHOT",
        groups: ["cfr"],
        content: {
          id: "ACTIONS_CALLOUT",
          screens: [
            {
              id: "ACTIONS_CALLOUT_WITHOUT_SCREENSHOT",
              anchors: [
                {
                  selector: ".urlbar-input-container",
                  arrow_width: "26.9",
                  panel_position: {
                    offset_x: 16,
                    anchor_attachment: "bottomleft",
                    callout_attachment: "topleft",
                  },
                },
              ],
              content: {
                logo: null,
                title: {
                  string_id: "actions-callout-title",
                  paddingInline: "0 40px",
                },
                width: "333px",
                padding: 16,
                position: "callout",
                subtitle: {
                  string_id: "actions-callout-subtitle",
                  marginBlock: "-4px 4px",
                  paddingInline: "42px 20px",
                },
                title_logo: {
                  width: "32px",
                  height: "34px",
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/2ff87710-8c83-41cd-a2b4-99d0c7ec67f1.svg",
                  alignment: "top",
                  marginBlock: "4px 0",
                  marginInline: "8px 18px",
                },
                dismiss_button: {
                  size: "small",
                  action: {
                    dismiss: true,
                  },
                  marginBlock: "20px 0",
                  marginInline: "0 20px",
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: false,
        },
        trigger: {
          id: "defaultBrowserCheck",
        },
        template: "feature_callout",
        frequency: {
          lifetime: 1,
        },
        targeting:
          "('browser.urlbar.scotchBonnet.enableOverride' | preferenceValue) && localeLanguageCode != 'en' && source == 'newtab' && !willShowDefaultPrompt && ((currentDate|date - profileAgeCreated|date) / 86400000 > 28) && (messageImpressions.UNIFIED_SEARCH_CALLOUT_WITHOUT_SCREENSHOT[messageImpressions.UNIFIED_SEARCH_CALLOUT_WITHOUT_SCREENSHOT | length - 1] < currentDate|date - 172800000)",
      },
      {
        // Nimbus slug: tab-groups-promotional-onboarding:onboarding (message 1 of 2)
        // Version range: 138+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/tab-groups-promotional-onboarding/summary#onboarding
        id: "TAB_GROUP_ONBOARDING_CALLOUT",
        groups: ["cfr"],
        content: {
          id: "TAB_GROUP_ONBOARDING_CALLOUT",
          screens: [
            {
              id: "TAB_GROUP_ONBOARDING_CALLOUT_HORIZONTAL",
              anchors: [
                {
                  selector:
                    "#tabbrowser-tabs:not([overflow]) .tab-content[selected]:not([pinned])",
                  panel_position: {
                    anchor_attachment: "bottomcenter",
                    callout_attachment: "topright",
                  },
                },
                {
                  selector: "#tabbrowser-tabs",
                  panel_position: {
                    anchor_attachment: "bottomcenter",
                    callout_attachment: "topright",
                  },
                },
              ],
              content: {
                logo: {
                  width: "300px",
                  height: "172px",
                  imageURL:
                    "chrome://browser/content/asrouter/assets/tabgroups/hort-animated-light.svg",
                  darkModeImageURL:
                    "chrome://browser/content/asrouter/assets/tabgroups/hort-animated-dark.svg",
                  reducedMotionImageURL:
                    "chrome://browser/content/asrouter/assets/tabgroups/hort-static-light.svg",
                  darkModeReducedMotionImageURL:
                    "chrome://browser/content/asrouter/assets/tabgroups/hort-static-dark.svg",
                },
                title: {
                  string_id: "tab-groups-onboarding-feature-callout-title",
                },
                width: "333px",
                padding: 16,
                position: "callout",
                subtitle: {
                  string_id: "tab-groups-onboarding-feature-callout-subtitle",
                },
                dismiss_button: {
                  size: "small",
                  action: {
                    dismiss: true,
                  },
                  background: true,
                  marginBlock: "20px 0",
                  marginInline: "0 20px",
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: false,
        },
        trigger: {
          id: "nthTabClosed",
        },
        template: "feature_callout",
        frequency: {
          lifetime: 1,
        },
        targeting:
          "tabsClosedCount >= 1 && currentTabsOpen >= 8 && ('browser.tabs.groups.enabled' | preferenceValue) && (!'sidebar.verticalTabs' | preferenceValue) && currentTabGroups == 0 && savedTabGroups == 0 && !activeNotifications",
        skip_in_tests:
          "not tested in automation and might pop up unexpectedly during review checker tests",
      },
      {
        // Nimbus slug: tab-groups-promotional-onboarding:onboarding (message 2 of 2)
        // Version range: 138+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/tab-groups-promotional-onboarding/summary#onboarding
        id: "TAB_GROUP_ONBOARDING_CALLOUT",
        groups: ["cfr"],
        content: {
          id: "TAB_GROUP_ONBOARDING_CALLOUT",
          screens: [
            {
              id: "TAB_GROUP_ONBOARDING_CALLOUT_VERTICAL",
              anchors: [
                {
                  selector:
                    "#tabbrowser-tabs:not([overflow]) .tab-content[selected]:not([pinned])",
                  panel_position: {
                    anchor_attachment: "rightcenter",
                    callout_attachment: "topleft",
                  },
                },
                {
                  selector: "#tabbrowser-tabs",
                  panel_position: {
                    anchor_attachment: "rightcenter",
                    callout_attachment: "topleft",
                  },
                },
              ],
              content: {
                logo: {
                  width: "300px",
                  height: "172px",
                  imageURL:
                    "chrome://browser/content/asrouter/assets/tabgroups/vert-animated-light.svg",
                  darkModeImageURL:
                    "chrome://browser/content/asrouter/assets/tabgroups/vert-animated-dark.svg",
                  reducedMotionImageURL:
                    "chrome://browser/content/asrouter/assets/tabgroups/vert-static-light.svg",
                  darkModeReducedMotionImageURL:
                    "chrome://browser/content/asrouter/assets/tabgroups/vert-static-dark.svg",
                },
                title: {
                  string_id: "tab-groups-onboarding-feature-callout-title",
                },
                width: "333px",
                padding: 16,
                position: "callout",
                subtitle: {
                  string_id: "tab-groups-onboarding-feature-callout-subtitle",
                },
                dismiss_button: {
                  size: "small",
                  action: {
                    dismiss: true,
                  },
                  background: true,
                  marginBlock: "20px 0",
                  marginInline: "0 20px",
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: false,
        },
        trigger: {
          id: "nthTabClosed",
        },
        template: "feature_callout",
        frequency: {
          lifetime: 1,
        },
        targeting:
          "tabsClosedCount >= 1 && currentTabsOpen >= 8 && ('browser.tabs.groups.enabled' | preferenceValue) && ('sidebar.revamp' | preferenceValue) && ('sidebar.verticalTabs' | preferenceValue) && currentTabGroups == 0 && savedTabGroups == 0 && !activeNotifications",
        skip_in_tests:
          "not tested in automation and might pop up unexpectedly during review checker tests",
      },
      {
        // Nimbus slug: login-status-advisory-callout-rollout:treatment-a
        // Version range: 135+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/login-status-advisory-callout-rollout/summary#treatment-a
        id: "LOGIN_STATUS_ADVISORY",
        groups: ["cfr"],
        content: {
          id: "LOGIN_STATUS_ADVISORY",
          screens: [
            {
              id: "LOGIN_STATUS_ADVISORY_A",
              anchors: [
                {
                  selector: "#fxa-toolbar-menu-button",
                  arrow_width: "19.79899",
                  panel_position: {
                    anchor_attachment: "bottomcenter",
                    callout_attachment: "topright",
                    panel_position_string: "bottomcenter topright",
                  },
                  no_open_on_anchor: true,
                },
              ],
              content: {
                title: {
                  raw: {
                    $l10n: {
                      id: "login-status-advisory-title-a",
                      text: "You’re signed out. Click the Account icon to sign in.",
                      comment:
                        "The 'account icon' is the toolbar button with a 'profile' icon of a human head/shoulders. It's for dealing with your Mozilla account. When hovering the icon, the tooltip says 'Account'",
                    },
                  },
                  fontSize: "0.6875em",
                  fontWeight: "normal",
                  lineHeight: "1",
                  marginBlock: "10px",
                  marginInline: "16px",
                  letterSpacing: "0",
                },
                width: "fit-content",
                padding: "0",
                autohide: true,
                position: "callout",
                page_event_listeners: [
                  {
                    action: {
                      dismiss: true,
                    },
                    params: {
                      type: "tourend",
                      options: {
                        once: true,
                      },
                    },
                  },
                ],
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: false,
          disableHistoryUpdates: true,
        },
        trigger: {
          id: "defaultBrowserCheck",
        },
        template: "feature_callout",
        frequency: {
          custom: [
            {
              cap: 1,
              period: 604800000,
            },
          ],
          lifetime: 3,
        },
        targeting:
          "source == 'startup' && previousSessionEnd && !willShowDefaultPrompt && !activeNotifications && !isFxASignedIn && (currentDate|date - profileAgeCreated|date) / 86400000 >= 7",
      },
      {
        // Nimbus slug: mozilla-vpn-in-private-browsing-treatment-d-rollout-en-only:treatment-d
        // Version range: 128+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/mozilla-vpn-in-private-browsing-treatment-d-rollout-en-only/summary#treatment-d
        id: "mozilla-vpn-in-private-browsing:treatment-d",
        groups: [],
        content: {
          infoBody:
            "fluent:about-private-browsing-info-description-private-window",
          infoIcon: "",
          infoTitle: "",
          promoTitle:
            "VPNs aren’t all the same. Some simply aren’t secure. Some log your activity. But Mozilla VPN is different — it’s open source and backed by a company with a track record of putting people and their privacy first.",
          infoEnabled: true,
          promoButton: {
            action: {
              data: {
                args: "https://www.mozilla.org/products/vpn/?utm_medium=product&utm_campaign=evergreen&utm_source=firefox-desktop&utm_content=why-mozilla-vpn&entrypoint_experiment=mozilla-vpn-in-private-browsing&entrypoint_variation=treatment-d",
              },
              type: "OPEN_URL",
            },
          },
          promoHeader: "Why Mozilla VPN?",
          infoLinkText: "fluent:about-private-browsing-learn-more-link",
          promoEnabled: true,
          promoLinkText: "Check out Mozilla VPN",
          promoLinkType: "button",
          promoImageLarge: "chrome://browser/content/assets/moz-vpn.svg",
          infoTitleEnabled: false,
          promoSectionStyle: "below-search",
          promoTitleEnabled: true,
        },
        priority: 5,
        template: "pb_newtab",
        frequency: {
          custom: [
            {
              cap: 3,
              period: 604800000,
            },
          ],
          lifetime: 12,
        },
        targeting:
          "!hasActiveEnterprisePolicies && (('e6eb0d1e856335fc' in attachedFxAOAuthClients|mapToProperty('id')) ? (attachedFxAOAuthClients[.id == 'e6eb0d1e856335fc'].lastAccessedDaysAgo > 29) : true)",
      },
      {
        // Nimbus slug: pdf-annotations-highlight-treatment-b-rollout:treatment-b (message 1 of 2)
        // Version range: 131+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/pdf-annotations-highlight-treatment-b-rollout/summary#treatment-b
        id: "PDF_ANNOTATIONS_HIGHLIGHT",
        content: {
          id: "PDF_ANNOTATIONS_HIGHLIGHT",
          screens: [
            {
              id: "PDF_ANNOTATIONS_HIGHLIGHT_SET_DEFAULT_ROLLOUT_SCREEN_1",
              anchors: [
                {
                  selector: "hbox#browser",
                  hide_arrow: true,
                  absolute_position: {
                    top: "45px",
                    right: "13px",
                  },
                },
              ],
              content: {
                logo: {
                  height: "190px",
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/ce5a14ef-ed44-4c16-9aaf-eb99f58bcb4f.svg",
                },
                title: {
                  raw: {
                    $l10n: {
                      id: "screen-1-header",
                      text: "Now you can highlight your PDFs!",
                      comment: "",
                    },
                  },
                },
                width: "333.3333px",
                padding: 16,
                position: "callout",
                subtitle: {
                  raw: {
                    $l10n: {
                      id: "screen-1-variant-2-subtitle",
                      text: "With our new highlighter tool, you can read and edit PDFs in one place.",
                      comment:
                        "This string appears below an image of a document with important parts highlighted.",
                    },
                  },
                  marginBlock: "-8px 0",
                  marginInline: "22px",
                },
                title_logo: {
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/5c4047e1-77cc-4094-8693-6474562afc1b.svg",
                  alignment: "top",
                },
                submenu_button: {
                  style: "secondary",
                  submenu: [
                    {
                      id: "item1",
                      type: "action",
                      label: {
                        raw: {
                          $l10n: {
                            id: "feature-tour-submenu-item-1",
                            text: "Don’t show this recommendation again",
                            comment: "",
                          },
                        },
                      },
                      action: {
                        data: {
                          id: "PDF_ANNOTATIONS_HIGHLIGHT",
                        },
                        type: "BLOCK_MESSAGE",
                        dismiss: true,
                      },
                    },
                    {
                      id: "item2",
                      type: "action",
                      label: {
                        raw: {
                          $l10n: {
                            id: "feature-tour-submenu-item-2",
                            text: "Show fewer recommendations",
                            comment: "",
                          },
                        },
                      },
                      action: {
                        data: {
                          actions: [
                            {
                              data: {
                                pref: {
                                  name: "messaging-system-action.show-fewer-pdf-recommendations",
                                  value: true,
                                },
                              },
                              type: "SET_PREF",
                            },
                            {
                              data: {
                                id: "PDF_ANNOTATIONS_HIGHLIGHT",
                              },
                              type: "BLOCK_MESSAGE",
                            },
                          ],
                        },
                        type: "MULTI_ACTION",
                        dismiss: true,
                      },
                    },
                    {
                      type: "separator",
                    },
                    {
                      id: "item3",
                      type: "action",
                      label: {
                        raw: {
                          $l10n: {
                            id: "feature-tour-submenu-item-3",
                            text: "Manage settings",
                            comment: "",
                          },
                        },
                      },
                      action: {
                        data: {
                          args: "preferences#general-cfrfeatures",
                          where: "tab",
                        },
                        type: "OPEN_ABOUT_PAGE",
                        dismiss: true,
                      },
                    },
                  ],
                  attached_to: "additional_button",
                },
                secondary_button: {
                  label: {
                    raw: {
                      $l10n: {
                        id: "feature-tour-next-button",
                        text: "Next",
                        comment: "",
                      },
                    },
                  },
                  style: "primary",
                  action: {
                    data: {
                      pref: {
                        name: "messaging-system-action.pdfjsannotation.feature-tour-2",
                        value:
                          '{"screen":"PDF_ANNOTATIONS_HIGHLIGHT_SET_DEFAULT_ROLLOUT_SCREEN_2","complete":false}',
                      },
                    },
                    type: "SET_PREF",
                  },
                },
                additional_button: {
                  label: {
                    raw: {
                      $l10n: {
                        id: "feature-tour-dismiss-button",
                        text: "Dismiss",
                        comment: "",
                      },
                    },
                  },
                  style: "secondary",
                  action: {
                    data: {
                      actions: [
                        {
                          data: {
                            id: "PDF_ANNOTATIONS_HIGHLIGHT",
                          },
                          type: "BLOCK_MESSAGE",
                        },
                        {
                          data: {
                            pref: {
                              name: "messaging-system-action.pdfjsannotation.feature-tour-2",
                            },
                          },
                          type: "SET_PREF",
                        },
                      ],
                    },
                    type: "MULTI_ACTION",
                    dismiss: true,
                  },
                },
              },
            },
            {
              id: "PDF_ANNOTATIONS_HIGHLIGHT_SET_DEFAULT_ROLLOUT_SCREEN_2",
              anchors: [
                {
                  selector: "hbox#browser",
                  hide_arrow: true,
                  absolute_position: {
                    top: "45px",
                    right: "13px",
                  },
                },
              ],
              content: {
                title: {
                  raw: {
                    $l10n: {
                      id: "screen-2-header",
                      text: "Make Firefox your default PDF editor?",
                      comment: "",
                    },
                  },
                },
                width: "max(340px, 43ex)",
                padding: 16,
                position: "callout",
                subtitle: {
                  raw: {
                    $l10n: {
                      id: "screen-2-subtitle",
                      text: "You’ll have access to our tools every time you open a PDF.",
                      comment: "",
                    },
                  },
                  marginBlock: "-8px 0",
                  marginInline: "28px 0",
                },
                title_logo: {
                  width: "24px",
                  height: "24px",
                  imageURL: "chrome://branding/content/icon32.png",
                  alignment: "top",
                  marginInline: "0 12px",
                },
                primary_button: {
                  label: {
                    raw: {
                      $l10n: {
                        id: "feature-tour-dismiss-button",
                        text: "Dismiss",
                        comment: "",
                      },
                    },
                    marginInline: "36px 0",
                  },
                  style: "secondary",
                  action: {
                    data: {
                      actions: [
                        {
                          data: {
                            id: "PDF_ANNOTATIONS_HIGHLIGHT",
                          },
                          type: "BLOCK_MESSAGE",
                        },
                        {
                          data: {
                            pref: {
                              name: "messaging-system-action.pdfjsannotation.feature-tour-2",
                            },
                          },
                          type: "SET_PREF",
                        },
                      ],
                    },
                    type: "MULTI_ACTION",
                    dismiss: true,
                  },
                },
                secondary_button: {
                  label: {
                    raw: {
                      $l10n: {
                        id: "feature-tour-set-default-button",
                        text: "Set as default",
                        comment: "",
                      },
                    },
                  },
                  style: "primary",
                  action: {
                    data: {
                      actions: [
                        {
                          type: "SET_DEFAULT_PDF_HANDLER",
                        },
                        {
                          data: {
                            id: "PDF_ANNOTATIONS_HIGHLIGHT",
                          },
                          type: "BLOCK_MESSAGE",
                        },
                        {
                          data: {
                            pref: {
                              name: "messaging-system-action.pdfjsannotation.feature-tour-2",
                            },
                          },
                          type: "SET_PREF",
                        },
                      ],
                    },
                    type: "MULTI_ACTION",
                  },
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: false,
          tour_pref_name:
            "messaging-system-action.pdfjsannotation.feature-tour-2",
          disableHistoryUpdates: true,
          tour_pref_default_value:
            '{"screen":"PDF_ANNOTATIONS_HIGHLIGHT_SET_DEFAULT_ROLLOUT_SCREEN_1","complete":false}',
        },
        trigger: {
          id: "pdfJsFeatureCalloutCheck",
        },
        priority: 2,
        template: "feature_callout",
        targeting:
          "userPrefs.cfrFeatures && os.isWindows && os.windowsVersion >= 10 && !hasActiveEnterprisePolicies && !(isDefaultHandler || {}).pdf && (!(defaultPDFHandler || {}).registered || (defaultPDFHandler || {}).knownBrowser)",
      },
      {
        // Nimbus slug: pdf-annotations-highlight-treatment-b-rollout:treatment-b (message 2 of 2)
        // Version range: 131+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/pdf-annotations-highlight-treatment-b-rollout/summary#treatment-b
        id: "PDF_ANNOTATIONS_HIGHLIGHT",
        content: {
          id: "PDF_ANNOTATIONS_HIGHLIGHT",
          screens: [
            {
              id: "PDF_ANNOTATIONS_HIGHLIGHT_WAS_DEFAULT_ROLLOUT_SCREEN_1",
              anchors: [
                {
                  selector: "hbox#browser",
                  hide_arrow: true,
                  absolute_position: {
                    top: "45px",
                    right: "13px",
                  },
                },
              ],
              content: {
                logo: {
                  height: "190px",
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/ce5a14ef-ed44-4c16-9aaf-eb99f58bcb4f.svg",
                },
                title: {
                  raw: {
                    $l10n: {
                      id: "screen-1-header",
                      text: "Now you can highlight your PDFs!",
                      comment: "",
                    },
                  },
                },
                width: "333.3333px",
                padding: 16,
                position: "callout",
                subtitle: {
                  raw: {
                    $l10n: {
                      id: "screen-1-variant-2-subtitle",
                      text: "With our new highlighter tool, you can read and edit PDFs in one place.",
                      comment:
                        "This string appears below an image of a document with important parts highlighted.",
                    },
                  },
                  marginBlock: "-8px 0",
                  marginInline: "22px",
                },
                title_logo: {
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/5c4047e1-77cc-4094-8693-6474562afc1b.svg",
                  alignment: "top",
                },
                submenu_button: {
                  style: "secondary",
                  submenu: [
                    {
                      id: "item1",
                      type: "action",
                      label: {
                        raw: {
                          $l10n: {
                            id: "feature-tour-submenu-item-1",
                            text: "Don’t show this recommendation again",
                            comment: "",
                          },
                        },
                      },
                      action: {
                        data: {
                          id: "PDF_ANNOTATIONS_HIGHLIGHT",
                        },
                        type: "BLOCK_MESSAGE",
                        dismiss: true,
                      },
                    },
                    {
                      id: "item2",
                      type: "action",
                      label: {
                        raw: {
                          $l10n: {
                            id: "feature-tour-submenu-item-2",
                            text: "Show fewer recommendations",
                            comment: "",
                          },
                        },
                      },
                      action: {
                        data: {
                          actions: [
                            {
                              data: {
                                pref: {
                                  name: "messaging-system-action.show-fewer-pdf-recommendations",
                                  value: true,
                                },
                              },
                              type: "SET_PREF",
                            },
                            {
                              data: {
                                id: "PDF_ANNOTATIONS_HIGHLIGHT",
                              },
                              type: "BLOCK_MESSAGE",
                            },
                          ],
                        },
                        type: "MULTI_ACTION",
                        dismiss: true,
                      },
                    },
                    {
                      type: "separator",
                    },
                    {
                      id: "item3",
                      type: "action",
                      label: {
                        raw: {
                          $l10n: {
                            id: "feature-tour-submenu-item-3",
                            text: "Manage settings",
                            comment: "",
                          },
                        },
                      },
                      action: {
                        data: {
                          args: "preferences#general-cfrfeatures",
                          where: "tab",
                        },
                        type: "OPEN_ABOUT_PAGE",
                        dismiss: true,
                      },
                    },
                  ],
                  attached_to: "additional_button",
                },
                additional_button: {
                  label: {
                    raw: {
                      $l10n: {
                        id: "feature-tour-dismiss-button",
                        text: "Dismiss",
                        comment: "",
                      },
                    },
                  },
                  style: "secondary",
                  action: {
                    data: {
                      actions: [
                        {
                          data: {
                            id: "PDF_ANNOTATIONS_HIGHLIGHT",
                          },
                          type: "BLOCK_MESSAGE",
                        },
                        {
                          data: {
                            pref: {
                              name: "messaging-system-action.pdfjsannotation.feature-tour-2",
                            },
                          },
                          type: "SET_PREF",
                        },
                      ],
                    },
                    type: "MULTI_ACTION",
                    dismiss: true,
                  },
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: false,
          tour_pref_name:
            "messaging-system-action.pdfjsannotation.feature-tour-2",
          disableHistoryUpdates: true,
          tour_pref_default_value:
            '{"screen":"PDF_ANNOTATIONS_HIGHLIGHT_WAS_DEFAULT_ROLLOUT_SCREEN_1","complete":false}',
        },
        trigger: {
          id: "pdfJsFeatureCalloutCheck",
        },
        priority: 1,
        template: "feature_callout",
        targeting:
          "userPrefs.cfrFeatures && (!os.isWindows || os.windowsVersion < 10 || hasActiveEnterprisePolicies || (isDefaultHandler || {}).pdf || ((defaultPDFHandler || {}).registered && !(defaultPDFHandler || {}).knownBrowser))",
      },
      {
        // Nimbus slug: fox-doodle-multi-action-cta-2025-rollout:treatment-a (message 1 of 6)
        // Version range: 134+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/fox-doodle-multi-action-cta-2025-rollout/summary#treatment-a
        id: "FOX_DOODLE_MULTI_ACTION",
        groups: ["eco"],
        content: {
          id: "FOX_DOODLE_MULTI_ACTION",
          screens: [
            {
              id: "FOX_DOODLE_MULTI_ACTION_CHECKBOXES_MAC_WINDOWS_NON_MSIX_EARLY_DAY_SCREEN",
              content: {
                logo: {
                  height: "125px",
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/3600b535-329d-4147-89c1-689108a804a8.gif",
                  reducedMotionImageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/35814ce7-903b-4140-a7b8-9ad8a1a010b3.png",
                },
                tiles: {
                  data: [
                    {
                      id: "checkbox-1-set-default",
                      label: {
                        string_id:
                          "mr2022-onboarding-easy-setup-set-default-checkbox-label",
                      },
                      action: {
                        type: "SET_DEFAULT_BROWSER",
                      },
                      defaultValue: true,
                    },
                    {
                      id: "checkbox-2-pin",
                      label: {
                        string_id: "mr2022-onboarding-pin-primary-button-label",
                      },
                      action: {
                        type: "PIN_FIREFOX_TO_TASKBAR",
                      },
                      defaultValue: true,
                    },
                  ],
                  type: "multiselect",
                  style: {
                    gap: "10px",
                    fontSize: "13px",
                    lineHeight: "1.4",
                    marginInline: "auto",
                    letterSpacing: 0,
                  },
                },
                title: {
                  fontSize: "22px",
                  string_id: "multi-cta-fox-doodle-title",
                  fontWeight: 590,
                  marginBlock: "-16px 0",
                  letterSpacing: 0,
                  paddingInline: "24px",
                },
                subtitle: {
                  fontSize: "13px",
                  string_id: "multi-cta-fox-doodle-quick-reminder-subtitle",
                  textAlign: "center",
                  lineHeight: "1.4",
                  marginBlock: "8px 24px",
                  letterSpacing: 0,
                  paddingInline: "24px",
                },
                dismiss_button: {
                  action: {
                    navigate: true,
                  },
                },
                primary_button: {
                  label: {
                    string_id:
                      "multi-cta-fox-doodle-start-browsing-primary-button-label",
                  },
                  action: {
                    data: {
                      actions: [],
                    },
                    type: "MULTI_ACTION",
                    navigate: true,
                    collectSelect: true,
                  },
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: true,
        },
        trigger: {
          id: "defaultBrowserCheck",
        },
        priority: 2,
        template: "spotlight",
        frequency: {
          lifetime: 1,
        },
        targeting:
          "doesAppNeedPin && (os.isMac || (os.isWindows && os.windowsVersion >= 10.0 && os.windowsBuildNumber >= 18362 && !isMSIX)) && source == 'startup' && !isMajorUpgrade && !activeNotifications && !isDefaultBrowser && !willShowDefaultPrompt && previousSessionEnd && userPrefs.cfrFeatures == true && (currentDate|date - profileAgeCreated|date) / 86400000 <= 28 && (currentDate|date - profileAgeCreated|date) / 86400000 >= 7",
      },
      {
        // Nimbus slug: fox-doodle-multi-action-cta-2025-rollout:treatment-a (message 2 of 6)
        // Version range: 134+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/fox-doodle-multi-action-cta-2025-rollout/summary#treatment-a
        id: "FOX_DOODLE_MULTI_ACTION",
        groups: ["eco"],
        content: {
          id: "FOX_DOODLE_MULTI_ACTION",
          screens: [
            {
              id: "FOX_DOODLE_MULTI_ACTION_CHECKBOXES_MSIX_EARLY_DAY_SCREEN",
              content: {
                logo: {
                  height: "125px",
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/3600b535-329d-4147-89c1-689108a804a8.gif",
                  reducedMotionImageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/35814ce7-903b-4140-a7b8-9ad8a1a010b3.png",
                },
                tiles: {
                  data: [
                    {
                      id: "checkbox-1-set-default",
                      label: {
                        string_id:
                          "mr2022-onboarding-easy-setup-set-default-checkbox-label",
                      },
                      action: {
                        type: "SET_DEFAULT_BROWSER",
                      },
                      defaultValue: true,
                    },
                    {
                      id: "checkbox-2-pin",
                      label: {
                        string_id: "multi-cta-fox-doodle-pin-checkbox",
                      },
                      action: {
                        type: "PIN_FIREFOX_TO_TASKBAR",
                      },
                      defaultValue: true,
                    },
                    {
                      id: "checkbox-3-pin-to-start",
                      label: {
                        string_id:
                          "multi-cta-fox-doodle-pin-startmenu-checkbox",
                      },
                      action: {
                        type: "PIN_FIREFOX_TO_START_MENU",
                      },
                      defaultValue: true,
                    },
                  ],
                  type: "multiselect",
                  style: {
                    gap: "10px",
                    fontSize: "13px",
                    lineHeight: "1.4",
                    marginInline: "auto",
                    letterSpacing: 0,
                  },
                },
                title: {
                  fontSize: "22px",
                  string_id: "multi-cta-fox-doodle-title",
                  fontWeight: 590,
                  marginBlock: "-16px 0",
                  letterSpacing: 0,
                  paddingInline: "24px",
                },
                subtitle: {
                  fontSize: "13px",
                  string_id: "multi-cta-fox-doodle-quick-reminder-subtitle",
                  textAlign: "center",
                  lineHeight: "1.4",
                  marginBlock: "8px 24px",
                  letterSpacing: 0,
                  paddingInline: "24px",
                },
                dismiss_button: {
                  action: {
                    navigate: true,
                  },
                },
                primary_button: {
                  label: {
                    string_id:
                      "mr2022-onboarding-gratitude-secondary-button-label",
                  },
                  action: {
                    data: {
                      actions: [],
                    },
                    type: "MULTI_ACTION",
                    navigate: true,
                    collectSelect: true,
                  },
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: true,
        },
        trigger: {
          id: "defaultBrowserCheck",
        },
        priority: 2,
        template: "spotlight",
        frequency: {
          lifetime: 1,
        },
        targeting:
          "doesAppNeedPin && isMSIX && os.isWindows && os.windowsVersion >= 10.0 && os.windowsBuildNumber >= 18362 && source == 'startup' && !isMajorUpgrade && !activeNotifications && !isDefaultBrowser && !willShowDefaultPrompt && previousSessionEnd && userPrefs.cfrFeatures == true && (currentDate|date - profileAgeCreated|date) / 86400000 <= 28 && (currentDate|date - profileAgeCreated|date) / 86400000 >= 7",
      },
      {
        // Nimbus slug: fox-doodle-multi-action-cta-2025-rollout:treatment-a (message 3 of 6)
        // Version range: 134+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/fox-doodle-multi-action-cta-2025-rollout/summary#treatment-a
        id: "FOX_DOODLE_MULTI_ACTION",
        groups: ["eco"],
        content: {
          id: "FOX_DOODLE_MULTI_ACTION",
          screens: [
            {
              id: "FOX_DOODLE_MULTI_ACTION_CHECKBOXES_MAC_WINDOWS_NON_MSIX_EXISTING_USER_SCREEN",
              content: {
                logo: {
                  height: "125px",
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/3600b535-329d-4147-89c1-689108a804a8.gif",
                  reducedMotionImageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/35814ce7-903b-4140-a7b8-9ad8a1a010b3.png",
                },
                tiles: {
                  data: [
                    {
                      id: "checkbox-1-set-default",
                      label: {
                        string_id:
                          "mr2022-onboarding-easy-setup-set-default-checkbox-label",
                      },
                      action: {
                        type: "SET_DEFAULT_BROWSER",
                      },
                      defaultValue: true,
                    },
                    {
                      id: "checkbox-2-pin",
                      label: {
                        string_id: "mr2022-onboarding-pin-primary-button-label",
                      },
                      action: {
                        type: "PIN_FIREFOX_TO_TASKBAR",
                      },
                      defaultValue: true,
                    },
                  ],
                  type: "multiselect",
                  style: {
                    gap: "10px",
                    fontSize: "13px",
                    lineHeight: "1.4",
                    marginInline: "auto",
                    letterSpacing: 0,
                  },
                },
                title: {
                  fontSize: "22px",
                  string_id: "multi-cta-fox-doodle-title",
                  fontWeight: 590,
                  marginBlock: "-16px 0",
                  letterSpacing: 0,
                  paddingInline: "24px",
                },
                subtitle: {
                  fontSize: "13px",
                  string_id: "multi-cta-fox-doodle-quick-reminder-subtitle",
                  textAlign: "center",
                  lineHeight: "1.4",
                  marginBlock: "8px 24px",
                  letterSpacing: 0,
                  paddingInline: "24px",
                },
                dismiss_button: {
                  action: {
                    navigate: true,
                  },
                },
                primary_button: {
                  label: {
                    string_id:
                      "multi-cta-fox-doodle-start-browsing-primary-button-label",
                  },
                  action: {
                    data: {
                      actions: [],
                    },
                    type: "MULTI_ACTION",
                    navigate: true,
                    collectSelect: true,
                  },
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: true,
        },
        trigger: {
          id: "defaultBrowserCheck",
        },
        priority: 2,
        template: "spotlight",
        frequency: {
          lifetime: 2,
        },
        targeting:
          "doesAppNeedPin && (os.isMac || (os.isWindows && os.windowsVersion >= 10.0 && os.windowsBuildNumber >= 18362 && !isMSIX)) && source == 'startup' && !isMajorUpgrade && !activeNotifications && !isDefaultBrowser && !willShowDefaultPrompt && previousSessionEnd && userPrefs.cfrFeatures == true && (currentDate|date - profileAgeCreated|date) / 86400000 >= 28",
      },
      {
        // Nimbus slug: fox-doodle-multi-action-cta-2025-rollout:treatment-a (message 4 of 6)
        // Version range: 134+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/fox-doodle-multi-action-cta-2025-rollout/summary#treatment-a
        id: "FOX_DOODLE_MULTI_ACTION",
        groups: ["eco"],
        content: {
          id: "FOX_DOODLE_MULTI_ACTION",
          screens: [
            {
              id: "FOX_DOODLE_MULTI_ACTION_CHECKBOXES_MSIX_SCREEN_EXISTING_USER_SCREEN",
              content: {
                logo: {
                  height: "125px",
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/3600b535-329d-4147-89c1-689108a804a8.gif",
                  reducedMotionImageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/35814ce7-903b-4140-a7b8-9ad8a1a010b3.png",
                },
                tiles: {
                  data: [
                    {
                      id: "checkbox-1-set-default",
                      label: {
                        string_id:
                          "mr2022-onboarding-easy-setup-set-default-checkbox-label",
                      },
                      action: {
                        type: "SET_DEFAULT_BROWSER",
                      },
                      defaultValue: true,
                    },
                    {
                      id: "checkbox-2-pin",
                      label: {
                        string_id: "multi-cta-fox-doodle-pin-checkbox",
                      },
                      action: {
                        type: "PIN_FIREFOX_TO_TASKBAR",
                      },
                      defaultValue: true,
                    },
                    {
                      id: "checkbox-3-pin-to-start",
                      label: {
                        string_id:
                          "multi-cta-fox-doodle-pin-startmenu-checkbox",
                      },
                      action: {
                        type: "PIN_FIREFOX_TO_START_MENU",
                      },
                      defaultValue: true,
                    },
                  ],
                  type: "multiselect",
                  style: {
                    gap: "10px",
                    fontSize: "13px",
                    lineHeight: "1.4",
                    marginInline: "auto",
                    letterSpacing: 0,
                  },
                },
                title: {
                  fontSize: "22px",
                  string_id: "multi-cta-fox-doodle-title",
                  fontWeight: 590,
                  marginBlock: "-16px 0",
                  letterSpacing: 0,
                  paddingInline: "24px",
                },
                subtitle: {
                  fontSize: "13px",
                  string_id: "multi-cta-fox-doodle-quick-reminder-subtitle",
                  textAlign: "center",
                  lineHeight: "1.4",
                  marginBlock: "8px 24px",
                  letterSpacing: 0,
                  paddingInline: "24px",
                },
                dismiss_button: {
                  action: {
                    navigate: true,
                  },
                },
                primary_button: {
                  label: {
                    string_id:
                      "mr2022-onboarding-gratitude-secondary-button-label",
                  },
                  action: {
                    data: {
                      actions: [],
                    },
                    type: "MULTI_ACTION",
                    navigate: true,
                    collectSelect: true,
                  },
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: true,
        },
        trigger: {
          id: "defaultBrowserCheck",
        },
        priority: 2,
        template: "spotlight",
        frequency: {
          lifetime: 2,
        },
        targeting:
          "doesAppNeedPin && isMSIX && os.isWindows && os.windowsVersion >= 10.0 && os.windowsBuildNumber >= 18362 && source == 'startup' && !isMajorUpgrade && !activeNotifications && !isDefaultBrowser && !willShowDefaultPrompt && previousSessionEnd && userPrefs.cfrFeatures == true && (currentDate|date - profileAgeCreated|date) / 86400000 >= 28",
      },
      {
        // Nimbus slug: fox-doodle-multi-action-cta-2025-rollout:treatment-a (message 5 of 6)
        // Version range: 134+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/fox-doodle-multi-action-cta-2025-rollout/summary#treatment-a
        id: "TAIL_FOX_SET_DEFAULT",
        groups: ["eco"],
        content: {
          id: "TAIL_FOX_SET_DEFAULT_CONTENT",
          screens: [
            {
              id: "TAIL_FOX_SET_DEFAULT_SCREEN",
              content: {
                logo: {
                  height: "140px",
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/92de1223-159b-4c2c-83bb-38e5ab767900.png",
                  reducedMotionImageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/92de1223-159b-4c2c-83bb-38e5ab767900.png",
                },
                title: {
                  fontSize: "22px",
                  string_id: "tail-fox-spotlight-title",
                  fontWeight: 590,
                  paddingBlock: "4px 0",
                  letterSpacing: 0,
                  paddingInline: "24px",
                },
                subtitle: {
                  fontSize: "15px",
                  string_id: "tail-fox-spotlight-subtitle",
                  lineHeight: "1.4",
                  marginBlock: "8px 16px",
                  letterSpacing: 0,
                  paddingInline: "24px",
                },
                dismiss_button: {
                  action: {
                    navigate: true,
                  },
                },
                primary_button: {
                  label: {
                    string_id: "tail-fox-spotlight-primary-button",
                    marginBlock: "4px 0",
                    paddingBlock: "0",
                    paddingInline: "16px",
                  },
                  action: {
                    type: "SET_DEFAULT_BROWSER",
                    navigate: true,
                  },
                },
                secondary_button: {
                  label: {
                    string_id: "tail-fox-spotlight-secondary-button",
                    marginBlock: "0 -20px",
                  },
                  action: {
                    navigate: true,
                  },
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: true,
        },
        trigger: {
          id: "defaultBrowserCheck",
        },
        template: "spotlight",
        frequency: {
          lifetime: 1,
        },
        targeting:
          "source == 'startup' && !isMajorUpgrade && !activeNotifications && !isDefaultBrowser && !willShowDefaultPrompt && (currentDate|date - profileAgeCreated|date) / 86400000 <= 28 && (currentDate|date - profileAgeCreated|date) / 86400000 >= 7 && previousSessionEnd && userPrefs.cfrFeatures == true && ((os.isMac && !doesAppNeedPin) || (os.isWindows && os.windowsVersion >= 10.0 && os.windowsBuildNumber >= 18362 && !doesAppNeedPin) || (os.isLinux || os.isWindows && (os.windowsVersion < 10.0 || os.windowsBuildNumber < 18362)))",
      },
      {
        // Nimbus slug: fox-doodle-multi-action-cta-2025-rollout:treatment-a (message 6 of 6)
        // Version range: 134+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/fox-doodle-multi-action-cta-2025-rollout/summary#treatment-a
        id: "FOX_DOODLE_SET_DEFAULT",
        groups: ["eco"],
        content: {
          id: "FOX_DOODLE_SET_DEFAULT",
          screens: [
            {
              id: "FOX_DOODLE_SET_DEFAULT_SCREEN",
              content: {
                logo: {
                  height: "125px",
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/3600b535-329d-4147-89c1-689108a804a8.gif",
                  reducedMotionImageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/35814ce7-903b-4140-a7b8-9ad8a1a010b3.png",
                },
                title: {
                  fontSize: "22px",
                  string_id: "fox-doodle-pin-headline",
                  fontWeight: 590,
                  paddingBlock: "4px 0",
                  letterSpacing: 0,
                  paddingInline: "24px",
                },
                subtitle: {
                  fontSize: "15px",
                  string_id: "fox-doodle-pin-body",
                  lineHeight: "1.4",
                  marginBlock: "8px 16px",
                  letterSpacing: 0,
                  paddingInline: "24px",
                },
                dismiss_button: {
                  action: {
                    navigate: true,
                  },
                },
                primary_button: {
                  label: {
                    string_id: "fox-doodle-pin-primary",
                    marginBlock: "4px 0",
                    paddingBlock: "0",
                    paddingInline: "16px",
                  },
                  action: {
                    type: "SET_DEFAULT_BROWSER",
                    navigate: true,
                  },
                },
                secondary_button: {
                  label: {
                    string_id: "fox-doodle-pin-secondary",
                    marginBlock: "0 -20px",
                  },
                  action: {
                    navigate: true,
                  },
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: true,
        },
        trigger: {
          id: "defaultBrowserCheck",
        },
        template: "spotlight",
        frequency: {
          lifetime: 2,
        },
        targeting:
          "source == 'startup' && !isMajorUpgrade && !activeNotifications && !isDefaultBrowser && !willShowDefaultPrompt && (currentDate|date - profileAgeCreated|date) / 86400000 >= 28 && previousSessionEnd && userPrefs.cfrFeatures == true && ((os.isMac && !doesAppNeedPin) || (os.isWindows && os.windowsVersion >= 10.0 && os.windowsBuildNumber >= 18362 && !doesAppNeedPin) || (os.isLinux || os.isWindows && (os.windowsVersion < 10.0 || os.windowsBuildNumber < 18362)))",
      },
      {
        // Nimbus slug: sidebar-button-feature-callout-vertical-tabs-users-existing-profiles:control
        // Version range: 133+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/sidebar-button-feature-callout-vertical-tabs-users-existing-profiles/summary#control
        id: "SIDEBAR_FEATURE_TOUR",
        groups: [],
        content: {
          id: "SIDEBAR_FEATURE_TOUR",
          screens: [
            {
              id: "SIDEBAR_BUTTON_CALLOUT",
              anchors: [
                {
                  selector: "#urlbar-container ~ #sidebar-button",
                  panel_position: {
                    anchor_attachment: "bottomcenter",
                    callout_attachment: "topright",
                  },
                },
                {
                  selector: "#sidebar-button",
                  panel_position: {
                    anchor_attachment: "bottomcenter",
                    callout_attachment: "topleft",
                  },
                },
              ],
              content: {
                logo: {
                  alt: "An illustration of the vertical tabs pane expanding to reveal tab labels",
                  height: "167px",
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/7448e55f-2f86-4565-8d8b-4f6620a57921.svg",
                  marginInline: "12px 12px",
                  darkModeImageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/5534a39b-5c5c-41cb-b8c8-f647a5e697f0.svg",
                  reducedMotionImageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/aae218dc-7888-494d-845e-6d9f70e41a31.svg",
                  darkModeReducedMotionImageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/2f19306c-3dcb-4362-8152-1442b8b3af32.svg",
                },
                title: {
                  string_id: "sidebar-button-callout-title",
                  marginInline: "4px 4px",
                },
                width: "324px",
                padding: 16,
                position: "callout",
                subtitle: {
                  string_id: "sidebar-button-callout-subtitle",
                  marginInline: "4px 4px",
                },
                dismiss_button: {
                  size: "small",
                  action: {
                    dismiss: true,
                  },
                  marginBlock: "20px 0",
                  marginInline: "0 20px",
                },
                page_event_listeners: [
                  {
                    action: {
                      dismiss: true,
                    },
                    params: {
                      type: "click",
                      selectors: "#sidebar-button",
                    },
                  },
                ],
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: false,
          disableHistoryUpdates: true,
        },
        trigger: {
          id: "openURL",
          patterns: ["*://*/*"],
        },
        template: "feature_callout",
        frequency: {
          lifetime: 1,
        },
        targeting: "'sidebar.verticalTabs'|preferenceValue",
      },
    ];
  },
};
