/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) 2023 Texas Instruments Incorporated - https://www.ti.com/
 */

#ifndef DTS_ARM64_TI_K3_FIREWALL_H
#define DTS_ARM64_TI_K3_FIREWALL_H

#define FWPRIVID_ALL    0xc3
#define FWPRIVID_ARMV8  1
#define FWPRIVID_SHIFT  16

#define FWCTRL_EN     0xA
#define FWCTRL_LOCK   (1 << 4)
#define FWCTRL_BG     (1 << 8)
#define FWCTRL_CACHE  (1 << 9)

#define FWPERM_SECURE_PRIV_WRITE      (1 << 0)
#define FWPERM_SECURE_PRIV_READ       (1 << 1)
#define FWPERM_SECURE_PRIV_CACHEABLE  (1 << 2)
#define FWPERM_SECURE_PRIV_DEBUG      (1 << 3)

#define FWPERM_SECURE_PRIV_RWCD       (FWPERM_SECURE_PRIV_READ | \
									   FWPERM_SECURE_PRIV_WRITE | \
									   FWPERM_SECURE_PRIV_CACHEABLE | \
									   FWPERM_SECURE_PRIV_DEBUG)

#define FWPERM_SECURE_USER_WRITE      (1 << 4)
#define FWPERM_SECURE_USER_READ       (1 << 5)
#define FWPERM_SECURE_USER_CACHEABLE  (1 << 6)
#define FWPERM_SECURE_USER_DEBUG      (1 << 7)

#define FWPERM_SECURE_USER_RWCD       (FWPERM_SECURE_USER_READ | \
									   FWPERM_SECURE_USER_WRITE | \
									   FWPERM_SECURE_USER_CACHEABLE | \
									   FWPERM_SECURE_USER_DEBUG)

#define FWPERM_NON_SECURE_PRIV_WRITE      (1 << 8)
#define FWPERM_NON_SECURE_PRIV_READ       (1 << 9)
#define FWPERM_NON_SECURE_PRIV_CACHEABLE  (1 << 10)
#define FWPERM_NON_SECURE_PRIV_DEBUG      (1 << 11)

#define FWPERM_NON_SECURE_PRIV_RWCD       (FWPERM_NON_SECURE_PRIV_READ | \
										   FWPERM_NON_SECURE_PRIV_WRITE | \
										   FWPERM_NON_SECURE_PRIV_CACHEABLE | \
										   FWPERM_NON_SECURE_PRIV_DEBUG)

#define FWPERM_NON_SECURE_USER_WRITE      (1 << 12)
#define FWPERM_NON_SECURE_USER_READ       (1 << 13)
#define FWPERM_NON_SECURE_USER_CACHEABLE  (1 << 14)
#define FWPERM_NON_SECURE_USER_DEBUG      (1 << 15)

#define FWPERM_NON_SECURE_USER_RWCD       (FWPERM_NON_SECURE_USER_READ | \
										   FWPERM_NON_SECURE_USER_WRITE | \
										   FWPERM_NON_SECURE_USER_CACHEABLE | \
										   FWPERM_NON_SECURE_USER_DEBUG)

#endif
