// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SQDMLAL2_2D_4S_S_TRACE_AARCH64_H_
#define VIXL_SIM_SQDMLAL2_2D_4S_S_TRACE_AARCH64_H_

const uint64_t kExpected_NEON_sqdmlal2_2D_4S_S[] = {
  0x0000007dfd0c0000, 0x0000000000000001,
  0x000000fcfa120000, 0x0000000000000001,
  0x000080f6fa240000, 0x0000000000000001,
  0x000080f6fa240000, 0x0000000000000001,
  0x0000007efd060000, 0x0000000000000001,
  0x00008078fd180000, 0x0000000000000001,
  0x00008078fd180000, 0x0000000000000001,
  0x00008078fe17fa00, 0x0000000000000001,
  0x00007ffa00120000, 0x0000000000000001,
  0x00007ffa00120000, 0x0000000000000001,
  0x00007ffa0111fa00, 0x0000000000000001,
  0x00007ffa0311ee00, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000fffa00, 0x0000000000000001,
  0x0000000002ffee00, 0x0000000000000001,
  0x0000000022ff2e00, 0x0000000000000001,
  0x0000000000fffa00, 0x0000000000000001,
  0x0000000002ffee00, 0x0000000000000001,
  0x0000000022ff2e00, 0x0000000000000001,
  0x000000009ffc4000, 0x0000000000000001,
  0x0000000001fff400, 0x0000000000000001,
  0x0000000021ff3400, 0x0000000000000001,
  0x000000009efc4600, 0x0000000000000001,
  0x000000011cf95200, 0x0000000000000001,
  0x000000001fff4000, 0x0000000000000001,
  0x000000009cfc5200, 0x0000000000000001,
  0x000000011af95e00, 0x0000000000000001,
  0x0000000199f66400, 0x0000000000000001,
  0x000000007cfd1200, 0x0000000000000001,
  0x00000000fafa1e00, 0x0000000000000001,
  0x0000000179f72400, 0x0000000000000001,
  0x0000008173f73600, 0x0000000000000001,
  0x000000007dfd0c00, 0x0000000000000001,
  0x00000000fcfa1200, 0x0000000000000001,
  0x00000080f6fa2400, 0x0000000000000001,
  0x00000100f1fa3000, 0x0000000000000001,
  0x000000007efd0600, 0x0000000000000001,
  0x0000008078fd1800, 0x0000000000000001,
  0x0000010073fd2400, 0x0000000000000001,
  0x000001806ffd2a00, 0x0000000000000001,
  0x0000007ffa001200, 0x0000000000000001,
  0x000000fff5001e00, 0x0000000000000001,
  0x0000017ff1002400, 0x0000000000000001,
  0x0033337ff0ccf200, 0x0000000000000001,
  0x0000007ffb000c00, 0x0000000000000001,
  0x000000fff7001200, 0x0000000000000001,
  0x003332fff6cce000, 0x0000000000000001,
  0x008886554bcce200, 0x0000000000000001,
  0x0000007ffc000600, 0x0000000000000001,
  0x0033327ffbccd400, 0x0000000000000001,
  0x008885d550ccd600, 0x0000000000000001,
  0x010882d54dcce800, 0x0000000000000001,
  0x003331ffffccce00, 0x0000000000000001,
  0x0088855554ccd000, 0x0000000000000001,
  0x0108825551cce200, 0x0000000000000001,
  0x01887f554fccee00, 0x0000000000000001,
  0x0055535555000200, 0x0000000000000001,
  0x00d5505552001400, 0x0000000000000001,
  0x01554d5550002000, 0x0000000000000001,
  0x01d54a554f002600, 0x0000000000000001,
  0x007ffcfffd001200, 0x0000000000000001,
  0x00fff9fffb001e00, 0x0000000000000001,
  0x017ff6fffa002400, 0x0000000000000001,
  0x00fff9fffa002400, 0x0000000000000001,
  0x007ffcfffe000c00, 0x0000000000000001,
  0x00fff9fffd001200, 0x0000000000000001,
  0x007ffcfffd001200, 0x0000000000000001,
  0xfffffffffe000c00, 0x0000000000000001,
  0x007ffcffff000600, 0x0000000000000001,
  0xffffffffff000600, 0x0000000000000001,
  0xff80030000000000, 0x0000000000000001,
  0xff2aafaaaa000400, 0x0000000000000001,
  0xff80030000000000, 0x0000000000000001,
  0xff00060000fffa00, 0x0000000000000001,
  0xfeaab2aaaafffe00, 0x0000000000000001,
  0xfe7780aaaa333600, 0x0000000000000001,
  0xff80030000fffa00, 0x0000000000000001,
  0xff2aafaaaafffe00, 0x0000000000000001,
  0xfef77daaaa333600, 0x0000000000000001,
  0xfef77d2aad333600, 0x0000000000000001,
  0xffaaacaaaa000400, 0x0000000000000001,
  0xff777aaaa9333c00, 0x0000000000000001,
  0xff777a2aac333c00, 0x0000000000000001,
  0xff7779aab0333600, 0x0000000000000001,
  0xffcccdffff333800, 0x0000000000000001,
  0xffcccd8002333800, 0x0000000000000001,
  0xffcccd0006333200, 0x0000000000000001,
  0xffcccc800b332600, 0x0000000000000001,
  0xffffff8003000000, 0x0000000000000001,
  0xffffff0006fffa00, 0x0000000000000001,
  0xfffffe800bffee00, 0x0000000000000001,
  0xfffffe0011ffdc00, 0x0000000000000001,
  0xffffff8003fffa00, 0x0000000000000001,
  0xffffff0008ffee00, 0x0000000000000001,
  0xfffffe800effdc00, 0x0000000000000001,
  0xfffffe7f8f02dc00, 0x0000000000000001,
  0xffffff8004fff400, 0x0000000000000001,
  0xffffff000affe200, 0x0000000000000001,
  0xfffffeff8b02e200, 0x0000000000000001,
  0xfffffeff0c05dc00, 0x0000000000000001,
  0xffffff8005ffee00, 0x0000000000000001,
  0xffffff7f8602ee00, 0x0000000000000001,
  0xffffff7f0705e800, 0x0000000000000001,
  0xffffff7e8908dc00, 0x0000000000000001,
  0xffffffff80030000, 0x0000000000000001,
  0xffffffff0105fa00, 0x0000000000000001,
  0xfffffffe8308ee00, 0x0000000000000001,
  0xfffffffe060bdc00, 0x0000000000000001,
  0xffffffff8102fa00, 0x0000000000000001,
  0xffffffff0305ee00, 0x0000000000000001,
  0xfffffffe8608dc00, 0x0000000000000001,
  0xfffffffe66099c00, 0x0000000000000001,
  0xffffffff8202f400, 0x0000000000000001,
  0xffffffff0505e200, 0x0000000000000001,
  0xfffffffee506a200, 0x0000000000000001,
  0xfffffffee206b400, 0x0000000000000001,
  0xffffffff8302ee00, 0x0000000000000001,
  0xffffffff6303ae00, 0x0000000000000001,
  0xffffffff6003c000, 0x0000000000000001,
  0xffffffff5e03cc00, 0x0000000000000001,
  0xffffffffe000c000, 0x0000000000000001,
  0xffffffffdd00d200, 0x0000000000000001,
  0xffffffffdb00de00, 0x0000000000000001,
  0xffffffffda00e400, 0x0000000000000001,
  0x0000000000000000, 0xfffffffffffffffb,
  0x0000000000000000, 0xfffffffffffffff7,
  0x0000000000000000, 0xfffffffffffffff5,
  0x0000000000000000, 0xfffffffffffffff5,
  0x0000000000000000, 0xfffffffffffffffd,
  0x0000000000000000, 0xfffffffffffffffb,
  0x0000000000000000, 0xfffffffffffffffb,
  0x0000000000000000, 0xfffffffffffffffd,
  0x0000000000000000, 0xffffffffffffffff,
  0x0000000000000000, 0xffffffffffffffff,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000005,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000003,
  0x0000000000000000, 0x0000000000000007,
  0x0000000000000000, 0x0000000000000047,
  0x0000000000000000, 0x0000000000000003,
  0x0000000000000000, 0x0000000000000007,
  0x0000000000000000, 0x0000000000000047,
  0x0000000000000000, 0x0000000000000141,
  0x0000000000000000, 0x0000000000000005,
  0x0000000000000000, 0x0000000000000045,
  0x0000000000000000, 0x000000000000013f,
  0x0000000000000000, 0x000000000000023b,
  0x0000000000000000, 0x0000000000000041,
  0x0000000000000000, 0x000000000000013b,
  0x0000000000000000, 0x0000000000000237,
  0x0000000000000000, 0x0000000000000335,
  0x0000000000000000, 0x00000000000000fb,
  0x0000000000000000, 0x00000000000001f7,
  0x0000000000000000, 0x00000000000002f5,
  0x0000000000000000, 0x00000000000102ef,
  0x0000000000000000, 0x00000000000000fd,
  0x0000000000000000, 0x00000000000001fb,
  0x0000000000000000, 0x00000000000101f5,
  0x0000000000000000, 0x00000000000201f1,
  0x0000000000000000, 0x00000000000000ff,
  0x0000000000000000, 0x00000000000100f9,
  0x0000000000000000, 0x00000000000200f5,
  0x0000000000000000, 0x00000000000300f3,
  0x0000000000000000, 0x000000000000fffb,
  0x0000000000000000, 0x000000000001fff7,
  0x0000000000000000, 0x000000000002fff5,
  0x0000000000000000, 0x000000006669665b,
  0x0000000000000000, 0x000000000000fffd,
  0x0000000000000000, 0x000000000001fffb,
  0x0000000000000000, 0x0000000066686661,
  0x0000000000000000, 0x000000011113110b,
  0x0000000000000000, 0x000000000000ffff,
  0x0000000000000000, 0x0000000066676665,
  0x0000000000000000, 0x000000011112110f,
  0x0000000000000000, 0x0000000211121109,
  0x0000000000000000, 0x0000000066666667,
  0x0000000000000000, 0x0000000111111111,
  0x0000000000000000, 0x000000021111110b,
  0x0000000000000000, 0x0000000311111107,
  0x0000000000000000, 0x00000000aaaaaaab,
  0x0000000000000000, 0x00000001aaaaaaa5,
  0x0000000000000000, 0x00000002aaaaaaa1,
  0x0000000000000000, 0x00000003aaaaaa9f,
  0x0000000000000000, 0x00000000fffffffb,
  0x0000000000000000, 0x00000001fffffff7,
  0x0000000000000000, 0x00000002fffffff5,
  0x0000000000000000, 0x00000001fffffff5,
  0x0000000000000000, 0x00000000fffffffd,
  0x0000000000000000, 0x00000001fffffffb,
  0x0000000000000000, 0x00000000fffffffb,
  0x0000000000000000, 0xfffffffffffffffd,
  0x0000000000000000, 0x00000000ffffffff,
  0x0000000000000000, 0xffffffffffffffff,
  0x0000000000000000, 0xffffffff00000001,
  0x0000000000000000, 0xfffffffe55555555,
  0x0000000000000000, 0xffffffff00000001,
  0x0000000000000000, 0xfffffffe00000003,
  0x0000000000000000, 0xfffffffd55555557,
  0x0000000000000000, 0xfffffffceeeeeeef,
  0x0000000000000000, 0xffffffff00000003,
  0x0000000000000000, 0xfffffffe55555557,
  0x0000000000000000, 0xfffffffdeeeeeeef,
  0x0000000000000000, 0xfffffffdeeedeeef,
  0x0000000000000000, 0xffffffff55555555,
  0x0000000000000000, 0xfffffffeeeeeeeed,
  0x0000000000000000, 0xfffffffeeeedeeed,
  0x0000000000000000, 0xfffffffeeeeceeef,
  0x0000000000000000, 0xffffffff99999999,
  0x0000000000000000, 0xffffffff99989999,
  0x0000000000000000, 0xffffffff9997999b,
  0x0000000000000000, 0xffffffff9996999f,
  0x0000000000000000, 0xffffffffffff0001,
  0x0000000000000000, 0xfffffffffffe0003,
  0x0000000000000000, 0xfffffffffffd0007,
  0x0000000000000000, 0xfffffffffffc000d,
  0x0000000000000000, 0xffffffffffff0003,
  0x0000000000000000, 0xfffffffffffe0007,
  0x0000000000000000, 0xfffffffffffd000d,
  0x0000000000000000, 0xfffffffffffcff0d,
  0x0000000000000000, 0xffffffffffff0005,
  0x0000000000000000, 0xfffffffffffe000b,
  0x0000000000000000, 0xfffffffffffdff0b,
  0x0000000000000000, 0xfffffffffffdfe0d,
  0x0000000000000000, 0xffffffffffff0007,
  0x0000000000000000, 0xfffffffffffeff07,
  0x0000000000000000, 0xfffffffffffefe09,
  0x0000000000000000, 0xfffffffffffefd0d,
  0x0000000000000000, 0xffffffffffffff01,
  0x0000000000000000, 0xfffffffffffffe03,
  0x0000000000000000, 0xfffffffffffffd07,
  0x0000000000000000, 0xfffffffffffffc0d,
  0x0000000000000000, 0xffffffffffffff03,
  0x0000000000000000, 0xfffffffffffffe07,
  0x0000000000000000, 0xfffffffffffffd0d,
  0x0000000000000000, 0xfffffffffffffccd,
  0x0000000000000000, 0xffffffffffffff05,
  0x0000000000000000, 0xfffffffffffffe0b,
  0x0000000000000000, 0xfffffffffffffdcb,
  0x0000000000000000, 0xfffffffffffffdc5,
  0x0000000000000000, 0xffffffffffffff07,
  0x0000000000000000, 0xfffffffffffffec7,
  0x0000000000000000, 0xfffffffffffffec1,
  0x0000000000000000, 0xfffffffffffffebd,
  0x0000000000000000, 0xffffffffffffffc1,
  0x0000000000000000, 0xffffffffffffffbb,
  0x0000000000000000, 0xffffffffffffffb7,
  0x0000000000000000, 0xffffffffffffffb5,
  0xfffffffffffffffa, 0xfffffffffffffff5,
  0xfffffffffffffff6, 0xffffffffffffffed,
  0xfffffffffffffff4, 0xffffffffffffffe9,
  0xfffffffffffffff4, 0xffffffffffffffe9,
  0xfffffffffffffffc, 0xfffffffffffffff9,
  0xfffffffffffffffa, 0xfffffffffffffff5,
  0xfffffffffffffffa, 0xfffffffffffffff5,
  0xfffffffffffffffc, 0xfffffffffffffff9,
  0xfffffffffffffffe, 0xfffffffffffffffd,
  0xfffffffffffffffe, 0xfffffffffffffffd,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000004, 0x0000000000000009,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000002, 0x0000000000000005,
  0x0000000000000006, 0x000000000000000d,
  0x0000000000000046, 0x000000000000008d,
  0x0000000000000002, 0x0000000000000005,
  0x0000000000000006, 0x000000000000000d,
  0x0000000000000046, 0x000000000000008d,
  0x0000000000000140, 0x0000000000000281,
  0x0000000000000004, 0x0000000000000009,
  0x0000000000000044, 0x0000000000000089,
  0x000000000000013e, 0x000000000000027d,
  0x000000000000023a, 0x0000000000000475,
  0x0000000000000040, 0x0000000000000081,
  0x000000000000013a, 0x0000000000000275,
  0x0000000000000236, 0x000000000000046d,
  0x0000000000000334, 0x0000000000000669,
  0x00000000000000fa, 0x00000000000001f5,
  0x00000000000001f6, 0x00000000000003ed,
  0x00000000000002f4, 0x00000000000005e9,
  0x00000000000102ee, 0x00000000000205dd,
  0x00000000000000fc, 0x00000000000001f9,
  0x00000000000001fa, 0x00000000000003f5,
  0x00000000000101f4, 0x00000000000203e9,
  0x00000000000201f0, 0x00000000000403e1,
  0x00000000000000fe, 0x00000000000001fd,
  0x00000000000100f8, 0x00000000000201f1,
  0x00000000000200f4, 0x00000000000401e9,
  0x00000000000300f2, 0x00000000000601e5,
  0x000000000000fffa, 0x000000000001fff5,
  0x000000000001fff6, 0x000000000003ffed,
  0x000000000002fff4, 0x000000000005ffe9,
  0x000000006669665a, 0x00000000ccd2ccb5,
  0x000000000000fffc, 0x000000000001fff9,
  0x000000000001fffa, 0x000000000003fff5,
  0x0000000066686660, 0x00000000ccd0ccc1,
  0x000000011113110a, 0x0000000222262215,
  0x000000000000fffe, 0x000000000001fffd,
  0x0000000066676664, 0x00000000ccceccc9,
  0x000000011112110e, 0x000000022224221d,
  0x0000000211121108, 0x0000000422242211,
  0x0000000066666666, 0x00000000cccccccd,
  0x0000000111111110, 0x0000000222222221,
  0x000000021111110a, 0x0000000422222215,
  0x0000000311111106, 0x000000062222220d,
  0x00000000aaaaaaaa, 0x0000000155555555,
  0x00000001aaaaaaa4, 0x0000000355555549,
  0x00000002aaaaaaa0, 0x0000000555555541,
  0x00000003aaaaaa9e, 0x000000075555553d,
  0x00000000fffffffa, 0x00000001fffffff5,
  0x00000001fffffff6, 0x00000003ffffffed,
  0x00000002fffffff4, 0x00000005ffffffe9,
  0x00000001fffffff4, 0x00000003ffffffe9,
  0x00000000fffffffc, 0x00000001fffffff9,
  0x00000001fffffffa, 0x00000003fffffff5,
  0x00000000fffffffa, 0x00000001fffffff5,
  0xfffffffffffffffc, 0xfffffffffffffff9,
  0x00000000fffffffe, 0x00000001fffffffd,
  0xfffffffffffffffe, 0xfffffffffffffffd,
  0xffffffff00000000, 0xfffffffe00000001,
  0xfffffffe55555554, 0xfffffffcaaaaaaa9,
  0xffffffff00000000, 0xfffffffe00000001,
  0xfffffffe00000002, 0xfffffffc00000005,
  0xfffffffd55555556, 0xfffffffaaaaaaaad,
  0xfffffffceeeeeeee, 0xfffffff9dddddddd,
  0xffffffff00000002, 0xfffffffe00000005,
  0xfffffffe55555556, 0xfffffffcaaaaaaad,
  0xfffffffdeeeeeeee, 0xfffffffbdddddddd,
  0xfffffffdeeedeeee, 0xfffffffbdddbdddd,
  0xffffffff55555554, 0xfffffffeaaaaaaa9,
  0xfffffffeeeeeeeec, 0xfffffffdddddddd9,
  0xfffffffeeeedeeec, 0xfffffffddddbddd9,
  0xfffffffeeeeceeee, 0xfffffffdddd9dddd,
  0xffffffff99999998, 0xffffffff33333331,
  0xffffffff99989998, 0xffffffff33313331,
  0xffffffff9997999a, 0xffffffff332f3335,
  0xffffffff9996999e, 0xffffffff332d333d,
  0xffffffffffff0000, 0xfffffffffffe0001,
  0xfffffffffffe0002, 0xfffffffffffc0005,
  0xfffffffffffd0006, 0xfffffffffffa000d,
  0xfffffffffffc000c, 0xfffffffffff80019,
  0xffffffffffff0002, 0xfffffffffffe0005,
  0xfffffffffffe0006, 0xfffffffffffc000d,
  0xfffffffffffd000c, 0xfffffffffffa0019,
  0xfffffffffffcff0c, 0xfffffffffff9fe19,
  0xffffffffffff0004, 0xfffffffffffe0009,
  0xfffffffffffe000a, 0xfffffffffffc0015,
  0xfffffffffffdff0a, 0xfffffffffffbfe15,
  0xfffffffffffdfe0c, 0xfffffffffffbfc19,
  0xffffffffffff0006, 0xfffffffffffe000d,
  0xfffffffffffeff06, 0xfffffffffffdfe0d,
  0xfffffffffffefe08, 0xfffffffffffdfc11,
  0xfffffffffffefd0c, 0xfffffffffffdfa19,
  0xffffffffffffff00, 0xfffffffffffffe01,
  0xfffffffffffffe02, 0xfffffffffffffc05,
  0xfffffffffffffd06, 0xfffffffffffffa0d,
  0xfffffffffffffc0c, 0xfffffffffffff819,
  0xffffffffffffff02, 0xfffffffffffffe05,
  0xfffffffffffffe06, 0xfffffffffffffc0d,
  0xfffffffffffffd0c, 0xfffffffffffffa19,
  0xfffffffffffffccc, 0xfffffffffffff999,
  0xffffffffffffff04, 0xfffffffffffffe09,
  0xfffffffffffffe0a, 0xfffffffffffffc15,
  0xfffffffffffffdca, 0xfffffffffffffb95,
  0xfffffffffffffdc4, 0xfffffffffffffb89,
  0xffffffffffffff06, 0xfffffffffffffe0d,
  0xfffffffffffffec6, 0xfffffffffffffd8d,
  0xfffffffffffffec0, 0xfffffffffffffd81,
  0xfffffffffffffebc, 0xfffffffffffffd79,
  0xffffffffffffffc0, 0xffffffffffffff81,
  0xffffffffffffffba, 0xffffffffffffff75,
  0xffffffffffffffb6, 0xffffffffffffff6d,
  0xffffffffffffffb4, 0xffffffffffffff69,
  0xfffffffffffffff4, 0xffffffffffffff41,
  0xffffffffffffffec, 0xfffffffffffffec1,
  0xffffffffffffffe8, 0xfffffffffffffe81,
  0xffffffffffffffe8, 0xfffffffffffffe81,
  0xfffffffffffffff8, 0xffffffffffffff81,
  0xfffffffffffffff4, 0xffffffffffffff41,
  0xfffffffffffffff4, 0xffffffffffffff41,
  0xfffffffffffffff8, 0xffffffffffffff81,
  0xfffffffffffffffc, 0xffffffffffffffc1,
  0xfffffffffffffffc, 0xffffffffffffffc1,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000008, 0x0000000000000081,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000004, 0x0000000000000041,
  0x000000000000000c, 0x00000000000000c1,
  0x000000000000008c, 0x00000000000008c1,
  0x0000000000000004, 0x0000000000000041,
  0x000000000000000c, 0x00000000000000c1,
  0x000000000000008c, 0x00000000000008c1,
  0x0000000000000280, 0x0000000000002801,
  0x0000000000000008, 0x0000000000000081,
  0x0000000000000088, 0x0000000000000881,
  0x000000000000027c, 0x00000000000027c1,
  0x0000000000000474, 0x0000000000004741,
  0x0000000000000080, 0x0000000000000801,
  0x0000000000000274, 0x0000000000002741,
  0x000000000000046c, 0x00000000000046c1,
  0x0000000000000668, 0x0000000000006681,
  0x00000000000001f4, 0x0000000000001f41,
  0x00000000000003ec, 0x0000000000003ec1,
  0x00000000000005e8, 0x0000000000005e81,
  0x00000000000205dc, 0x0000000000205dc1,
  0x00000000000001f8, 0x0000000000001f81,
  0x00000000000003f4, 0x0000000000003f41,
  0x00000000000203e8, 0x0000000000203e81,
  0x00000000000403e0, 0x0000000000403e01,
  0x00000000000001fc, 0x0000000000001fc1,
  0x00000000000201f0, 0x0000000000201f01,
  0x00000000000401e8, 0x0000000000401e81,
  0x00000000000601e4, 0x0000000000601e41,
  0x000000000001fff4, 0x00000000001fff41,
  0x000000000003ffec, 0x00000000003ffec1,
  0x000000000005ffe8, 0x00000000005ffe81,
  0x00000000ccd2ccb4, 0x0000000ccd2ccb41,
  0x000000000001fff8, 0x00000000001fff81,
  0x000000000003fff4, 0x00000000003fff41,
  0x00000000ccd0ccc0, 0x0000000ccd0ccc01,
  0x0000000222262214, 0x0000002222622141,
  0x000000000001fffc, 0x00000000001fffc1,
  0x00000000ccceccc8, 0x0000000ccceccc81,
  0x000000022224221c, 0x00000022224221c1,
  0x0000000422242210, 0x0000004222422101,
  0x00000000cccccccc, 0x0000000cccccccc1,
  0x0000000222222220, 0x0000002222222201,
  0x0000000422222214, 0x0000004222222141,
  0x000000062222220c, 0x00000062222220c1,
  0x0000000155555554, 0x0000001555555541,
  0x0000000355555548, 0x0000003555555481,
  0x0000000555555540, 0x0000005555555401,
  0x000000075555553c, 0x00000075555553c1,
  0x00000001fffffff4, 0x0000001fffffff41,
  0x00000003ffffffec, 0x0000003ffffffec1,
  0x00000005ffffffe8, 0x0000005ffffffe81,
  0x00000003ffffffe8, 0x0000003ffffffe81,
  0x00000001fffffff8, 0x0000001fffffff81,
  0x00000003fffffff4, 0x0000003fffffff41,
  0x00000001fffffff4, 0x0000001fffffff41,
  0xfffffffffffffff8, 0xffffffffffffff81,
  0x00000001fffffffc, 0x0000001fffffffc1,
  0xfffffffffffffffc, 0xffffffffffffffc1,
  0xfffffffe00000000, 0xffffffe000000001,
  0xfffffffcaaaaaaa8, 0xffffffcaaaaaaa81,
  0xfffffffe00000000, 0xffffffe000000001,
  0xfffffffc00000004, 0xffffffc000000041,
  0xfffffffaaaaaaaac, 0xffffffaaaaaaaac1,
  0xfffffff9dddddddc, 0xffffff9dddddddc1,
  0xfffffffe00000004, 0xffffffe000000041,
  0xfffffffcaaaaaaac, 0xffffffcaaaaaaac1,
  0xfffffffbdddddddc, 0xffffffbdddddddc1,
  0xfffffffbdddbdddc, 0xffffffbdddbdddc1,
  0xfffffffeaaaaaaa8, 0xffffffeaaaaaaa81,
  0xfffffffdddddddd8, 0xffffffdddddddd81,
  0xfffffffddddbddd8, 0xffffffddddbddd81,
  0xfffffffdddd9dddc, 0xffffffdddd9dddc1,
  0xffffffff33333330, 0xfffffff333333301,
  0xffffffff33313330, 0xfffffff333133301,
  0xffffffff332f3334, 0xfffffff332f33341,
  0xffffffff332d333c, 0xfffffff332d333c1,
  0xfffffffffffe0000, 0xffffffffffe00001,
  0xfffffffffffc0004, 0xffffffffffc00041,
  0xfffffffffffa000c, 0xffffffffffa000c1,
  0xfffffffffff80018, 0xffffffffff800181,
  0xfffffffffffe0004, 0xffffffffffe00041,
  0xfffffffffffc000c, 0xffffffffffc000c1,
  0xfffffffffffa0018, 0xffffffffffa00181,
  0xfffffffffff9fe18, 0xffffffffff9fe181,
  0xfffffffffffe0008, 0xffffffffffe00081,
  0xfffffffffffc0014, 0xffffffffffc00141,
  0xfffffffffffbfe14, 0xffffffffffbfe141,
  0xfffffffffffbfc18, 0xffffffffffbfc181,
  0xfffffffffffe000c, 0xffffffffffe000c1,
  0xfffffffffffdfe0c, 0xffffffffffdfe0c1,
  0xfffffffffffdfc10, 0xffffffffffdfc101,
  0xfffffffffffdfa18, 0xffffffffffdfa181,
  0xfffffffffffffe00, 0xffffffffffffe001,
  0xfffffffffffffc04, 0xffffffffffffc041,
  0xfffffffffffffa0c, 0xffffffffffffa0c1,
  0xfffffffffffff818, 0xffffffffffff8181,
  0xfffffffffffffe04, 0xffffffffffffe041,
  0xfffffffffffffc0c, 0xffffffffffffc0c1,
  0xfffffffffffffa18, 0xffffffffffffa181,
  0xfffffffffffff998, 0xffffffffffff9981,
  0xfffffffffffffe08, 0xffffffffffffe081,
  0xfffffffffffffc14, 0xffffffffffffc141,
  0xfffffffffffffb94, 0xffffffffffffb941,
  0xfffffffffffffb88, 0xffffffffffffb881,
  0xfffffffffffffe0c, 0xffffffffffffe0c1,
  0xfffffffffffffd8c, 0xffffffffffffd8c1,
  0xfffffffffffffd80, 0xffffffffffffd801,
  0xfffffffffffffd78, 0xffffffffffffd781,
  0xffffffffffffff80, 0xfffffffffffff801,
  0xffffffffffffff74, 0xfffffffffffff741,
  0xffffffffffffff6c, 0xfffffffffffff6c1,
  0xffffffffffffff68, 0xfffffffffffff681,
  0xffffffffffffff40, 0xfffffffffffffd13,
  0xfffffffffffffec0, 0xfffffffffffffb1f,
  0xfffffffffffffe80, 0xfffffffffffffa25,
  0xfffffffffffffe80, 0xfffffffffffffa25,
  0xffffffffffffff80, 0xfffffffffffffe0d,
  0xffffffffffffff40, 0xfffffffffffffd13,
  0xffffffffffffff40, 0xfffffffffffffd13,
  0xffffffffffffff80, 0xfffffffffffffe0d,
  0xffffffffffffffc0, 0xffffffffffffff07,
  0xffffffffffffffc0, 0xffffffffffffff07,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000080, 0x00000000000001f5,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000040, 0x00000000000000fb,
  0x00000000000000c0, 0x00000000000002ef,
  0x00000000000008c0, 0x000000000000222f,
  0x0000000000000040, 0x00000000000000fb,
  0x00000000000000c0, 0x00000000000002ef,
  0x00000000000008c0, 0x000000000000222f,
  0x0000000000002800, 0x0000000000009c41,
  0x0000000000000080, 0x00000000000001f5,
  0x0000000000000880, 0x0000000000002135,
  0x00000000000027c0, 0x0000000000009b47,
  0x0000000000004740, 0x0000000000011653,
  0x0000000000000800, 0x0000000000001f41,
  0x0000000000002740, 0x0000000000009953,
  0x00000000000046c0, 0x000000000001145f,
  0x0000000000006680, 0x0000000000019065,
  0x0000000000001f40, 0x0000000000007a13,
  0x0000000000003ec0, 0x000000000000f51f,
  0x0000000000005e80, 0x0000000000017125,
  0x0000000000205dc0, 0x00000000007e6e37,
  0x0000000000001f80, 0x0000000000007b0d,
  0x0000000000003f40, 0x000000000000f713,
  0x0000000000203e80, 0x00000000007df425,
  0x0000000000403e00, 0x0000000000faf231,
  0x0000000000001fc0, 0x0000000000007c07,
  0x0000000000201f00, 0x00000000007d7919,
  0x0000000000401e80, 0x0000000000fa7725,
  0x0000000000601e40, 0x000000000177762b,
  0x00000000001fff40, 0x00000000007cfd13,
  0x00000000003ffec0, 0x0000000000f9fb1f,
  0x00000000005ffe80, 0x000000000176fa25,
  0x0000000ccd2ccb40, 0x000000320176f9f3,
  0x00000000001fff80, 0x00000000007cfe0d,
  0x00000000003fff40, 0x0000000000f9fd13,
  0x0000000ccd0ccc00, 0x0000003200f9fce1,
  0x0000002222622140, 0x00000085564f51e3,
  0x00000000001fffc0, 0x00000000007cff07,
  0x0000000ccceccc80, 0x00000032007cfed5,
  0x00000022224221c0, 0x0000008555d253d7,
  0x0000004222422100, 0x0000010255d250e9,
  0x0000000cccccccc0, 0x00000031ffffffcf,
  0x0000002222222200, 0x00000085555554d1,
  0x0000004222222140, 0x00000102555551e3,
  0x00000062222220c0, 0x0000017f55554fef,
  0x0000001555555540, 0x0000005355555503,
  0x0000003555555480, 0x000000d055555215,
  0x0000005555555400, 0x0000014d55555021,
  0x00000075555553c0, 0x000001ca55554f27,
  0x0000001fffffff40, 0x0000007cfffffd13,
  0x0000003ffffffec0, 0x000000f9fffffb1f,
  0x0000005ffffffe80, 0x00000176fffffa25,
  0x0000003ffffffe80, 0x000000f9fffffa25,
  0x0000001fffffff80, 0x0000007cfffffe0d,
  0x0000003fffffff40, 0x000000f9fffffd13,
  0x0000001fffffff40, 0x0000007cfffffd13,
  0xffffffffffffff80, 0xfffffffffffffe0d,
  0x0000001fffffffc0, 0x0000007cffffff07,
  0xffffffffffffffc0, 0xffffffffffffff07,
  0xffffffe000000000, 0xffffff8300000001,
  0xffffffcaaaaaaa80, 0xffffff2faaaaaa05,
  0xffffffe000000000, 0xffffff8300000001,
  0xffffffc000000040, 0xffffff06000000fb,
  0xffffffaaaaaaaac0, 0xfffffeb2aaaaaaff,
  0xffffff9dddddddc0, 0xfffffe80aaaaaa37,
  0xffffffe000000040, 0xffffff83000000fb,
  0xffffffcaaaaaaac0, 0xffffff2faaaaaaff,
  0xffffffbdddddddc0, 0xfffffefdaaaaaa37,
  0xffffffbdddbdddc0, 0xfffffefdaa2daa37,
  0xffffffeaaaaaaa80, 0xffffffacaaaaaa05,
  0xffffffdddddddd80, 0xffffff7aaaaaa93d,
  0xffffffddddbddd80, 0xffffff7aaa2da93d,
  0xffffffdddd9dddc0, 0xffffff7aa9b0aa37,
  0xfffffff333333300, 0xffffffcdffffff39,
  0xfffffff333133300, 0xffffffcdff82ff39,
  0xfffffff332f33340, 0xffffffcdff060033,
  0xfffffff332d333c0, 0xffffffcdfe890227,
  0xffffffffffe00000, 0xffffffffff830001,
  0xffffffffffc00040, 0xffffffffff0600fb,
  0xffffffffffa000c0, 0xfffffffffe8902ef,
  0xffffffffff800180, 0xfffffffffe0c05dd,
  0xffffffffffe00040, 0xffffffffff8300fb,
  0xffffffffffc000c0, 0xffffffffff0602ef,
  0xffffffffffa00180, 0xfffffffffe8905dd,
  0xffffffffff9fe180, 0xfffffffffe8888dd,
  0xffffffffffe00080, 0xffffffffff8301f5,
  0xffffffffffc00140, 0xffffffffff0604e3,
  0xffffffffffbfe140, 0xffffffffff0587e3,
  0xffffffffffbfc180, 0xffffffffff050bdd,
  0xffffffffffe000c0, 0xffffffffff8302ef,
  0xffffffffffdfe0c0, 0xffffffffff8285ef,
  0xffffffffffdfc100, 0xffffffffff8209e9,
  0xffffffffffdfa180, 0xffffffffff818edd,
  0xffffffffffffe000, 0xffffffffffff8301,
  0xffffffffffffc040, 0xffffffffffff06fb,
  0xffffffffffffa0c0, 0xfffffffffffe8bef,
  0xffffffffffff8180, 0xfffffffffffe11dd,
  0xffffffffffffe040, 0xffffffffffff83fb,
  0xffffffffffffc0c0, 0xffffffffffff08ef,
  0xffffffffffffa180, 0xfffffffffffe8edd,
  0xffffffffffff9980, 0xfffffffffffe6f9d,
  0xffffffffffffe080, 0xffffffffffff84f5,
  0xffffffffffffc140, 0xffffffffffff0ae3,
  0xffffffffffffb940, 0xfffffffffffeeba3,
  0xffffffffffffb880, 0xfffffffffffee8b5,
  0xffffffffffffe0c0, 0xffffffffffff85ef,
  0xffffffffffffd8c0, 0xffffffffffff66af,
  0xffffffffffffd800, 0xffffffffffff63c1,
  0xffffffffffffd780, 0xffffffffffff61cd,
  0xfffffffffffff800, 0xffffffffffffe0c1,
  0xfffffffffffff740, 0xffffffffffffddd3,
  0xfffffffffffff6c0, 0xffffffffffffdbdf,
  0xfffffffffffff680, 0xffffffffffffdae5,
  0xfffffffffffffd12, 0xfffffffffffffd0d,
  0xfffffffffffffb1e, 0xfffffffffffffb15,
  0xfffffffffffffa24, 0xfffffffffffffa19,
  0xfffffffffffffa24, 0xfffffffffffffa19,
  0xfffffffffffffe0c, 0xfffffffffffffe09,
  0xfffffffffffffd12, 0xfffffffffffffd0d,
  0xfffffffffffffd12, 0xfffffffffffffd0d,
  0xfffffffffffffe0c, 0xfffffffffffffe09,
  0xffffffffffffff06, 0xffffffffffffff05,
  0xffffffffffffff06, 0xffffffffffffff05,
  0x0000000000000000, 0x0000000000000001,
  0x00000000000001f4, 0x00000000000001f9,
  0x0000000000000000, 0x0000000000000001,
  0x00000000000000fa, 0x00000000000000fd,
  0x00000000000002ee, 0x00000000000002f5,
  0x000000000000222e, 0x0000000000002275,
  0x00000000000000fa, 0x00000000000000fd,
  0x00000000000002ee, 0x00000000000002f5,
  0x000000000000222e, 0x0000000000002275,
  0x0000000000009c40, 0x0000000000009d81,
  0x00000000000001f4, 0x00000000000001f9,
  0x0000000000002134, 0x0000000000002179,
  0x0000000000009b46, 0x0000000000009c85,
  0x0000000000011652, 0x000000000001188d,
  0x0000000000001f40, 0x0000000000001f81,
  0x0000000000009952, 0x0000000000009a8d,
  0x000000000001145e, 0x0000000000011695,
  0x0000000000019064, 0x0000000000019399,
  0x0000000000007a12, 0x0000000000007b0d,
  0x000000000000f51e, 0x000000000000f715,
  0x0000000000017124, 0x0000000000017419,
  0x00000000007e6e36, 0x00000000007f7125,
  0x0000000000007b0c, 0x0000000000007c09,
  0x000000000000f712, 0x000000000000f90d,
  0x00000000007df424, 0x00000000007ef619,
  0x0000000000faf230, 0x0000000000fcf421,
  0x0000000000007c06, 0x0000000000007d05,
  0x00000000007d7918, 0x00000000007e7a11,
  0x0000000000fa7724, 0x0000000000fc7819,
  0x000000000177762a, 0x00000000017a771d,
  0x00000000007cfd12, 0x00000000007dfd0d,
  0x0000000000f9fb1e, 0x0000000000fbfb15,
  0x000000000176fa24, 0x000000000179fa19,
  0x000000320176f9f2, 0x0000003267e0604d,
  0x00000000007cfe0c, 0x00000000007dfe09,
  0x0000000000f9fd12, 0x0000000000fbfd0d,
  0x0000003200f9fce0, 0x0000003267626341,
  0x00000085564f51e2, 0x00000086676262ed,
  0x00000000007cff06, 0x00000000007dff05,
  0x00000032007cfed4, 0x0000003266e46539,
  0x0000008555d253d6, 0x0000008666e464e5,
  0x0000010255d250e8, 0x0000010466e461f1,
  0x00000031ffffffce, 0x0000003266666635,
  0x00000085555554d0, 0x00000086666665e1,
  0x00000102555551e2, 0x00000104666662ed,
  0x0000017f55554fee, 0x00000182666660f5,
  0x0000005355555502, 0x00000053ffffffad,
  0x000000d055555214, 0x000000d1fffffcb9,
  0x0000014d55555020, 0x0000014ffffffac1,
  0x000001ca55554f26, 0x000001cdfffff9c5,
  0x0000007cfffffd12, 0x0000007dfffffd0d,
  0x000000f9fffffb1e, 0x000000fbfffffb15,
  0x00000176fffffa24, 0x00000179fffffa19,
  0x000000f9fffffa24, 0x000000fbfffffa19,
  0x0000007cfffffe0c, 0x0000007dfffffe09,
  0x000000f9fffffd12, 0x000000fbfffffd0d,
  0x0000007cfffffd12, 0x0000007dfffffd0d,
  0xfffffffffffffe0c, 0xfffffffffffffe09,
  0x0000007cffffff06, 0x0000007dffffff05,
  0xffffffffffffff06, 0xffffffffffffff05,
  0xffffff8300000000, 0xffffff8200000001,
  0xffffff2faaaaaa04, 0xffffff2dffffff59,
  0xffffff8300000000, 0xffffff8200000001,
  0xffffff06000000fa, 0xffffff04000000fd,
  0xfffffeb2aaaaaafe, 0xfffffeb000000055,
  0xfffffe80aaaaaa36, 0xfffffe7d99999925,
  0xffffff83000000fa, 0xffffff82000000fd,
  0xffffff2faaaaaafe, 0xffffff2e00000055,
  0xfffffefdaaaaaa36, 0xfffffefb99999925,
  0xfffffefdaa2daa36, 0xfffffefb991b9925,
  0xffffffacaaaaaa04, 0xffffffabffffff59,
  0xffffff7aaaaaa93c, 0xffffff7999999829,
  0xffffff7aaa2da93c, 0xffffff79991b9829,
  0xffffff7aa9b0aa36, 0xffffff79989d9925,
  0xffffffcdffffff38, 0xffffffcd999998d1,
  0xffffffcdff82ff38, 0xffffffcd991b98d1,
  0xffffffcdff060032, 0xffffffcd989d99cd,
  0xffffffcdfe890226, 0xffffffcd981f9bc5,
  0xffffffffff830000, 0xffffffffff820001,
  0xffffffffff0600fa, 0xffffffffff0400fd,
  0xfffffffffe8902ee, 0xfffffffffe8602f5,
  0xfffffffffe0c05dc, 0xfffffffffe0805e9,
  0xffffffffff8300fa, 0xffffffffff8200fd,
  0xffffffffff0602ee, 0xffffffffff0402f5,
  0xfffffffffe8905dc, 0xfffffffffe8605e9,
  0xfffffffffe8888dc, 0xfffffffffe8587e9,
  0xffffffffff8301f4, 0xffffffffff8201f9,
  0xffffffffff0604e2, 0xffffffffff0404ed,
  0xffffffffff0587e2, 0xffffffffff0386ed,
  0xffffffffff050bdc, 0xffffffffff0309e9,
  0xffffffffff8302ee, 0xffffffffff8202f5,
  0xffffffffff8285ee, 0xffffffffff8184f5,
  0xffffffffff8209e8, 0xffffffffff8107f1,
  0xffffffffff818edc, 0xffffffffff808be9,
  0xffffffffffff8300, 0xffffffffffff8201,
  0xffffffffffff06fa, 0xffffffffffff04fd,
  0xfffffffffffe8bee, 0xfffffffffffe88f5,
  0xfffffffffffe11dc, 0xfffffffffffe0de9,
  0xffffffffffff83fa, 0xffffffffffff82fd,
  0xffffffffffff08ee, 0xffffffffffff06f5,
  0xfffffffffffe8edc, 0xfffffffffffe8be9,
  0xfffffffffffe6f9c, 0xfffffffffffe6c69,
  0xffffffffffff84f4, 0xffffffffffff83f9,
  0xffffffffffff0ae2, 0xffffffffffff08ed,
  0xfffffffffffeeba2, 0xfffffffffffee96d,
  0xfffffffffffee8b4, 0xfffffffffffee679,
  0xffffffffffff85ee, 0xffffffffffff84f5,
  0xffffffffffff66ae, 0xffffffffffff6575,
  0xffffffffffff63c0, 0xffffffffffff6281,
  0xffffffffffff61cc, 0xffffffffffff6089,
  0xffffffffffffe0c0, 0xffffffffffffe081,
  0xffffffffffffddd2, 0xffffffffffffdd8d,
  0xffffffffffffdbde, 0xffffffffffffdb95,
  0xffffffffffffdae4, 0xffffffffffffda99,
  0xfffffffffffffd0c, 0xfffffffffffffd07,
  0xfffffffffffffb14, 0xfffffffffffffb0b,
  0xfffffffffffffa18, 0xfffffffffffffa0d,
  0xfffffffffffffa18, 0xfffffffffffffa0d,
  0xfffffffffffffe08, 0xfffffffffffffe05,
  0xfffffffffffffd0c, 0xfffffffffffffd07,
  0xfffffffffffffd0c, 0xfffffffffffffd07,
  0xfffffffffffffe08, 0xfffffffffffffe05,
  0xffffffffffffff04, 0xffffffffffffff03,
  0xffffffffffffff04, 0xffffffffffffff03,
  0x0000000000000000, 0x0000000000000001,
  0x00000000000001f8, 0x00000000000001fd,
  0x0000000000000000, 0x0000000000000001,
  0x00000000000000fc, 0x00000000000000ff,
  0x00000000000002f4, 0x00000000000002fb,
  0x0000000000002274, 0x00000000000022bb,
  0x00000000000000fc, 0x00000000000000ff,
  0x00000000000002f4, 0x00000000000002fb,
  0x0000000000002274, 0x00000000000022bb,
  0x0000000000009d80, 0x0000000000009ec1,
  0x00000000000001f8, 0x00000000000001fd,
  0x0000000000002178, 0x00000000000021bd,
  0x0000000000009c84, 0x0000000000009dc3,
  0x000000000001188c, 0x0000000000011ac7,
  0x0000000000001f80, 0x0000000000001fc1,
  0x0000000000009a8c, 0x0000000000009bc7,
  0x0000000000011694, 0x00000000000118cb,
  0x0000000000019398, 0x00000000000196cd,
  0x0000000000007b0c, 0x0000000000007c07,
  0x000000000000f714, 0x000000000000f90b,
  0x0000000000017418, 0x000000000001770d,
  0x00000000007f7124, 0x0000000000807413,
  0x0000000000007c08, 0x0000000000007d05,
  0x000000000000f90c, 0x000000000000fb07,
  0x00000000007ef618, 0x00000000007ff80d,
  0x0000000000fcf420, 0x0000000000fef611,
  0x0000000000007d04, 0x0000000000007e03,
  0x00000000007e7a10, 0x00000000007f7b09,
  0x0000000000fc7818, 0x0000000000fe790d,
  0x00000000017a771c, 0x00000000017d780f,
  0x00000000007dfd0c, 0x00000000007efd07,
  0x0000000000fbfb14, 0x0000000000fdfb0b,
  0x000000000179fa18, 0x00000000017cfa0d,
  0x0000003267e0604c, 0x00000032ce49c6a7,
  0x00000000007dfe08, 0x00000000007efe05,
  0x0000000000fbfd0c, 0x0000000000fdfd07,
  0x0000003267626340, 0x00000032cdcac9a1,
  0x00000086676262ec, 0x00000087787573f7,
  0x00000000007dff04, 0x00000000007eff03,
  0x0000003266e46538, 0x00000032cd4bcb9d,
  0x0000008666e464e4, 0x0000008777f675f3,
  0x0000010466e461f0, 0x0000010677f672f9,
  0x0000003266666634, 0x00000032cccccc9b,
  0x00000086666665e0, 0x00000087777776f1,
  0x00000104666662ec, 0x00000106777773f7,
  0x00000182666660f4, 0x00000185777771fb,
  0x00000053ffffffac, 0x00000054aaaaaa57,
  0x000000d1fffffcb8, 0x000000d3aaaaa75d,
  0x0000014ffffffac0, 0x00000152aaaaa561,
  0x000001cdfffff9c4, 0x000001d1aaaaa463,
  0x0000007dfffffd0c, 0x0000007efffffd07,
  0x000000fbfffffb14, 0x000000fdfffffb0b,
  0x00000179fffffa18, 0x0000017cfffffa0d,
  0x000000fbfffffa18, 0x000000fdfffffa0d,
  0x0000007dfffffe08, 0x0000007efffffe05,
  0x000000fbfffffd0c, 0x000000fdfffffd07,
  0x0000007dfffffd0c, 0x0000007efffffd07,
  0xfffffffffffffe08, 0xfffffffffffffe05,
  0x0000007dffffff04, 0x0000007effffff03,
  0xffffffffffffff04, 0xffffffffffffff03,
  0xffffff8200000000, 0xffffff8100000001,
  0xffffff2dffffff58, 0xffffff2c555554ad,
  0xffffff8200000000, 0xffffff8100000001,
  0xffffff04000000fc, 0xffffff02000000ff,
  0xfffffeb000000054, 0xfffffead555555ab,
  0xfffffe7d99999924, 0xfffffe7a88888813,
  0xffffff82000000fc, 0xffffff81000000ff,
  0xffffff2e00000054, 0xffffff2c555555ab,
  0xfffffefb99999924, 0xfffffef988888813,
  0xfffffefb991b9924, 0xfffffef988098813,
  0xffffffabffffff58, 0xffffffab555554ad,
  0xffffff7999999828, 0xffffff7888888715,
  0xffffff79991b9828, 0xffffff7888098715,
  0xffffff79989d9924, 0xffffff78878a8813,
  0xffffffcd999998d0, 0xffffffcd33333269,
  0xffffffcd991b98d0, 0xffffffcd32b43269,
  0xffffffcd989d99cc, 0xffffffcd32353367,
  0xffffffcd981f9bc4, 0xffffffcd31b63563,
  0xffffffffff820000, 0xffffffffff810001,
  0xffffffffff0400fc, 0xffffffffff0200ff,
  0xfffffffffe8602f4, 0xfffffffffe8302fb,
  0xfffffffffe0805e8, 0xfffffffffe0405f5,
  0xffffffffff8200fc, 0xffffffffff8100ff,
  0xffffffffff0402f4, 0xffffffffff0202fb,
  0xfffffffffe8605e8, 0xfffffffffe8305f5,
  0xfffffffffe8587e8, 0xfffffffffe8286f5,
  0xffffffffff8201f8, 0xffffffffff8101fd,
  0xffffffffff0404ec, 0xffffffffff0204f7,
  0xffffffffff0386ec, 0xffffffffff0185f7,
  0xffffffffff0309e8, 0xffffffffff0107f5,
  0xffffffffff8202f4, 0xffffffffff8102fb,
  0xffffffffff8184f4, 0xffffffffff8083fb,
  0xffffffffff8107f0, 0xffffffffff8005f9,
  0xffffffffff808be8, 0xffffffffff7f88f5,
  0xffffffffffff8200, 0xffffffffffff8101,
  0xffffffffffff04fc, 0xffffffffffff02ff,
  0xfffffffffffe88f4, 0xfffffffffffe85fb,
  0xfffffffffffe0de8, 0xfffffffffffe09f5,
  0xffffffffffff82fc, 0xffffffffffff81ff,
  0xffffffffffff06f4, 0xffffffffffff04fb,
  0xfffffffffffe8be8, 0xfffffffffffe88f5,
  0xfffffffffffe6c68, 0xfffffffffffe6935,
  0xffffffffffff83f8, 0xffffffffffff82fd,
  0xffffffffffff08ec, 0xffffffffffff06f7,
  0xfffffffffffee96c, 0xfffffffffffee737,
  0xfffffffffffee678, 0xfffffffffffee43d,
  0xffffffffffff84f4, 0xffffffffffff83fb,
  0xffffffffffff6574, 0xffffffffffff643b,
  0xffffffffffff6280, 0xffffffffffff6141,
  0xffffffffffff6088, 0xffffffffffff5f45,
  0xffffffffffffe080, 0xffffffffffffe041,
  0xffffffffffffdd8c, 0xffffffffffffdd47,
  0xffffffffffffdb94, 0xffffffffffffdb4b,
  0xffffffffffffda98, 0xffffffffffffda4d,
  0xfffffffffffffd06, 0xfffffffffffd0013,
  0xfffffffffffffb0a, 0xfffffffffffb001f,
  0xfffffffffffffa0c, 0xfffffffffffa0025,
  0xfffffffffffffa0c, 0xfffffffffffa0025,
  0xfffffffffffffe04, 0xfffffffffffe000d,
  0xfffffffffffffd06, 0xfffffffffffd0013,
  0xfffffffffffffd06, 0xfffffffffffd0013,
  0xfffffffffffffe04, 0xfffffffffffe000d,
  0xffffffffffffff02, 0xffffffffffff0007,
  0xffffffffffffff02, 0xffffffffffff0007,
  0x0000000000000000, 0x0000000000000001,
  0x00000000000001fc, 0x000000000001fff5,
  0x0000000000000000, 0x0000000000000001,
  0x00000000000000fe, 0x000000000000fffb,
  0x00000000000002fa, 0x000000000002ffef,
  0x00000000000022ba, 0x000000000022ff2f,
  0x00000000000000fe, 0x000000000000fffb,
  0x00000000000002fa, 0x000000000002ffef,
  0x00000000000022ba, 0x000000000022ff2f,
  0x0000000000009ec0, 0x00000000009ffc41,
  0x00000000000001fc, 0x000000000001fff5,
  0x00000000000021bc, 0x000000000021ff35,
  0x0000000000009dc2, 0x00000000009efc47,
  0x0000000000011ac6, 0x00000000011cf953,
  0x0000000000001fc0, 0x00000000001fff41,
  0x0000000000009bc6, 0x00000000009cfc53,
  0x00000000000118ca, 0x00000000011af95f,
  0x00000000000196cc, 0x000000000199f665,
  0x0000000000007c06, 0x00000000007cfd13,
  0x000000000000f90a, 0x0000000000fafa1f,
  0x000000000001770c, 0x000000000179f725,
  0x0000000000807412, 0x000000008173f737,
  0x0000000000007d04, 0x00000000007dfd0d,
  0x000000000000fb06, 0x0000000000fcfa13,
  0x00000000007ff80c, 0x0000000080f6fa25,
  0x0000000000fef610, 0x0000000100f1fa31,
  0x0000000000007e02, 0x00000000007efd07,
  0x00000000007f7b08, 0x000000008078fd19,
  0x0000000000fe790c, 0x000000010073fd25,
  0x00000000017d780e, 0x00000001806ffd2b,
  0x00000000007efd06, 0x000000007ffa0013,
  0x0000000000fdfb0a, 0x00000000fff5001f,
  0x00000000017cfa0c, 0x000000017ff10025,
  0x00000032ce49c6a6, 0x000033337ff0ccf3,
  0x00000000007efe04, 0x000000007ffb000d,
  0x0000000000fdfd06, 0x00000000fff70013,
  0x00000032cdcac9a0, 0x00003332fff6cce1,
  0x00000087787573f6, 0x00008886554bcce3,
  0x00000000007eff02, 0x000000007ffc0007,
  0x00000032cd4bcb9c, 0x000033327ffbccd5,
  0x0000008777f675f2, 0x00008885d550ccd7,
  0x0000010677f672f8, 0x00010882d54dcce9,
  0x00000032cccccc9a, 0x00003331ffffcccf,
  0x00000087777776f0, 0x000088855554ccd1,
  0x00000106777773f6, 0x000108825551cce3,
  0x00000185777771fa, 0x0001887f554fccef,
  0x00000054aaaaaa56, 0x0000555355550003,
  0x000000d3aaaaa75c, 0x0000d55055520015,
  0x00000152aaaaa560, 0x0001554d55500021,
  0x000001d1aaaaa462, 0x0001d54a554f0027,
  0x0000007efffffd06, 0x00007ffcfffd0013,
  0x000000fdfffffb0a, 0x0000fff9fffb001f,
  0x0000017cfffffa0c, 0x00017ff6fffa0025,
  0x000000fdfffffa0c, 0x0000fff9fffa0025,
  0x0000007efffffe04, 0x00007ffcfffe000d,
  0x000000fdfffffd06, 0x0000fff9fffd0013,
  0x0000007efffffd06, 0x00007ffcfffd0013,
  0xfffffffffffffe04, 0xfffffffffffe000d,
  0x0000007effffff02, 0x00007ffcffff0007,
  0xffffffffffffff02, 0xffffffffffff0007,
  0xffffff8100000000, 0xffff800300000001,
  0xffffff2c555554ac, 0xffff2aafaaaa0005,
  0xffffff8100000000, 0xffff800300000001,
  0xffffff02000000fe, 0xffff00060000fffb,
  0xfffffead555555aa, 0xfffeaab2aaaaffff,
  0xfffffe7a88888812, 0xfffe7780aaaa3337,
  0xffffff81000000fe, 0xffff80030000fffb,
  0xffffff2c555555aa, 0xffff2aafaaaaffff,
  0xfffffef988888812, 0xfffef77daaaa3337,
  0xfffffef988098812, 0xfffef77d2aad3337,
  0xffffffab555554ac, 0xffffaaacaaaa0005,
  0xffffff7888888714, 0xffff777aaaa9333d,
  0xffffff7888098714, 0xffff777a2aac333d,
  0xffffff78878a8812, 0xffff7779aab03337,
  0xffffffcd33333268, 0xffffcccdffff3339,
  0xffffffcd32b43268, 0xffffcccd80023339,
  0xffffffcd32353366, 0xffffcccd00063333,
  0xffffffcd31b63562, 0xffffcccc800b3327,
  0xffffffffff810000, 0xffffffff80030001,
  0xffffffffff0200fe, 0xffffffff0006fffb,
  0xfffffffffe8302fa, 0xfffffffe800bffef,
  0xfffffffffe0405f4, 0xfffffffe0011ffdd,
  0xffffffffff8100fe, 0xffffffff8003fffb,
  0xffffffffff0202fa, 0xffffffff0008ffef,
  0xfffffffffe8305f4, 0xfffffffe800effdd,
  0xfffffffffe8286f4, 0xfffffffe7f8f02dd,
  0xffffffffff8101fc, 0xffffffff8004fff5,
  0xffffffffff0204f6, 0xffffffff000affe3,
  0xffffffffff0185f6, 0xfffffffeff8b02e3,
  0xffffffffff0107f4, 0xfffffffeff0c05dd,
  0xffffffffff8102fa, 0xffffffff8005ffef,
  0xffffffffff8083fa, 0xffffffff7f8602ef,
  0xffffffffff8005f8, 0xffffffff7f0705e9,
  0xffffffffff7f88f4, 0xffffffff7e8908dd,
  0xffffffffffff8100, 0xffffffffff800301,
  0xffffffffffff02fe, 0xffffffffff0105fb,
  0xfffffffffffe85fa, 0xfffffffffe8308ef,
  0xfffffffffffe09f4, 0xfffffffffe060bdd,
  0xffffffffffff81fe, 0xffffffffff8102fb,
  0xffffffffffff04fa, 0xffffffffff0305ef,
  0xfffffffffffe88f4, 0xfffffffffe8608dd,
  0xfffffffffffe6934, 0xfffffffffe66099d,
  0xffffffffffff82fc, 0xffffffffff8202f5,
  0xffffffffffff06f6, 0xffffffffff0505e3,
  0xfffffffffffee736, 0xfffffffffee506a3,
  0xfffffffffffee43c, 0xfffffffffee206b5,
  0xffffffffffff83fa, 0xffffffffff8302ef,
  0xffffffffffff643a, 0xffffffffff6303af,
  0xffffffffffff6140, 0xffffffffff6003c1,
  0xffffffffffff5f44, 0xffffffffff5e03cd,
  0xffffffffffffe040, 0xffffffffffe000c1,
  0xffffffffffffdd46, 0xffffffffffdd00d3,
  0xffffffffffffdb4a, 0xffffffffffdb00df,
  0xffffffffffffda4c, 0xffffffffffda00e5,
  0xfffffffffffd0012, 0xfffffffffffd000d,
  0xfffffffffffb001e, 0xfffffffffffb0015,
  0xfffffffffffa0024, 0xfffffffffffa0019,
  0xfffffffffffa0024, 0xfffffffffffa0019,
  0xfffffffffffe000c, 0xfffffffffffe0009,
  0xfffffffffffd0012, 0xfffffffffffd000d,
  0xfffffffffffd0012, 0xfffffffffffd000d,
  0xfffffffffffe000c, 0xfffffffffffe0009,
  0xffffffffffff0006, 0xffffffffffff0005,
  0xffffffffffff0006, 0xffffffffffff0005,
  0x0000000000000000, 0x0000000000000001,
  0x000000000001fff4, 0x000000000001fff9,
  0x0000000000000000, 0x0000000000000001,
  0x000000000000fffa, 0x000000000000fffd,
  0x000000000002ffee, 0x000000000002fff5,
  0x000000000022ff2e, 0x000000000022ff75,
  0x000000000000fffa, 0x000000000000fffd,
  0x000000000002ffee, 0x000000000002fff5,
  0x000000000022ff2e, 0x000000000022ff75,
  0x00000000009ffc40, 0x00000000009ffd81,
  0x000000000001fff4, 0x000000000001fff9,
  0x000000000021ff34, 0x000000000021ff79,
  0x00000000009efc46, 0x00000000009efd85,
  0x00000000011cf952, 0x00000000011cfb8d,
  0x00000000001fff40, 0x00000000001fff81,
  0x00000000009cfc52, 0x00000000009cfd8d,
  0x00000000011af95e, 0x00000000011afb95,
  0x000000000199f664, 0x000000000199f999,
  0x00000000007cfd12, 0x00000000007cfe0d,
  0x0000000000fafa1e, 0x0000000000fafc15,
  0x000000000179f724, 0x000000000179fa19,
  0x000000008173f736, 0x000000008174fa25,
  0x00000000007dfd0c, 0x00000000007dfe09,
  0x0000000000fcfa12, 0x0000000000fcfc0d,
  0x0000000080f6fa24, 0x0000000080f7fc19,
  0x0000000100f1fa30, 0x0000000100f3fc21,
  0x00000000007efd06, 0x00000000007efe05,
  0x000000008078fd18, 0x000000008079fe11,
  0x000000010073fd24, 0x000000010075fe19,
  0x00000001806ffd2a, 0x000000018072fe1d,
  0x000000007ffa0012, 0x000000007ffb000d,
  0x00000000fff5001e, 0x00000000fff70015,
  0x000000017ff10024, 0x000000017ff40019,
  0x000033337ff0ccf2, 0x00003333e65a334d,
  0x000000007ffb000c, 0x000000007ffc0009,
  0x00000000fff70012, 0x00000000fff9000d,
  0x00003332fff6cce0, 0x00003333665f3341,
  0x00008886554bcce2, 0x00008887665edded,
  0x000000007ffc0006, 0x000000007ffd0005,
  0x000033327ffbccd4, 0x00003332e6633339,
  0x00008885d550ccd6, 0x00008886e662dde5,
  0x00010882d54dcce8, 0x00010884e65fddf1,
  0x00003331ffffccce, 0x0000333266663335,
  0x000088855554ccd0, 0x000088866665dde1,
  0x000108825551cce2, 0x000108846662dded,
  0x0001887f554fccee, 0x000188826660ddf5,
  0x0000555355550002, 0x00005553ffffaaad,
  0x0000d55055520014, 0x0000d551fffcaab9,
  0x0001554d55500020, 0x0001554ffffaaac1,
  0x0001d54a554f0026, 0x0001d54dfff9aac5,
  0x00007ffcfffd0012, 0x00007ffdfffd000d,
  0x0000fff9fffb001e, 0x0000fffbfffb0015,
  0x00017ff6fffa0024, 0x00017ff9fffa0019,
  0x0000fff9fffa0024, 0x0000fffbfffa0019,
  0x00007ffcfffe000c, 0x00007ffdfffe0009,
  0x0000fff9fffd0012, 0x0000fffbfffd000d,
  0x00007ffcfffd0012, 0x00007ffdfffd000d,
  0xfffffffffffe000c, 0xfffffffffffe0009,
  0x00007ffcffff0006, 0x00007ffdffff0005,
  0xffffffffffff0006, 0xffffffffffff0005,
  0xffff800300000000, 0xffff800200000001,
  0xffff2aafaaaa0004, 0xffff2aadffff5559,
  0xffff800300000000, 0xffff800200000001,
  0xffff00060000fffa, 0xffff00040000fffd,
  0xfffeaab2aaaafffe, 0xfffeaab000005555,
  0xfffe7780aaaa3336, 0xfffe777d99992225,
  0xffff80030000fffa, 0xffff80020000fffd,
  0xffff2aafaaaafffe, 0xffff2aae00005555,
  0xfffef77daaaa3336, 0xfffef77b99992225,
  0xfffef77d2aad3336, 0xfffef77b199b2225,
  0xffffaaacaaaa0004, 0xffffaaabffff5559,
  0xffff777aaaa9333c, 0xffff777999982229,
  0xffff777a2aac333c, 0xffff7779199a2229,
  0xffff7779aab03336, 0xffff7778999d2225,
  0xffffcccdffff3338, 0xffffcccd9998ccd1,
  0xffffcccd80023338, 0xffffcccd199accd1,
  0xffffcccd00063332, 0xffffcccc999dcccd,
  0xffffcccc800b3326, 0xffffcccc19a1ccc5,
  0xffffffff80030000, 0xffffffff80020001,
  0xffffffff0006fffa, 0xffffffff0004fffd,
  0xfffffffe800bffee, 0xfffffffe8008fff5,
  0xfffffffe0011ffdc, 0xfffffffe000dffe9,
  0xffffffff8003fffa, 0xffffffff8002fffd,
  0xffffffff0008ffee, 0xffffffff0006fff5,
  0xfffffffe800effdc, 0xfffffffe800bffe9,
  0xfffffffe7f8f02dc, 0xfffffffe7f8c01e9,
  0xffffffff8004fff4, 0xffffffff8003fff9,
  0xffffffff000affe2, 0xffffffff0008ffed,
  0xfffffffeff8b02e2, 0xfffffffeff8901ed,
  0xfffffffeff0c05dc, 0xfffffffeff0a03e9,
  0xffffffff8005ffee, 0xffffffff8004fff5,
  0xffffffff7f8602ee, 0xffffffff7f8501f5,
  0xffffffff7f0705e8, 0xffffffff7f0603f1,
  0xffffffff7e8908dc, 0xffffffff7e8805e9,
  0xffffffffff800300, 0xffffffffff800201,
  0xffffffffff0105fa, 0xffffffffff0103fd,
  0xfffffffffe8308ee, 0xfffffffffe8305f5,
  0xfffffffffe060bdc, 0xfffffffffe0607e9,
  0xffffffffff8102fa, 0xffffffffff8101fd,
  0xffffffffff0305ee, 0xffffffffff0303f5,
  0xfffffffffe8608dc, 0xfffffffffe8605e9,
  0xfffffffffe66099c, 0xfffffffffe660669,
  0xffffffffff8202f4, 0xffffffffff8201f9,
  0xffffffffff0505e2, 0xffffffffff0503ed,
  0xfffffffffee506a2, 0xfffffffffee5046d,
  0xfffffffffee206b4, 0xfffffffffee20479,
  0xffffffffff8302ee, 0xffffffffff8301f5,
  0xffffffffff6303ae, 0xffffffffff630275,
  0xffffffffff6003c0, 0xffffffffff600281,
  0xffffffffff5e03cc, 0xffffffffff5e0289,
  0xffffffffffe000c0, 0xffffffffffe00081,
  0xffffffffffdd00d2, 0xffffffffffdd008d,
  0xffffffffffdb00de, 0xffffffffffdb0095,
  0xffffffffffda00e4, 0xffffffffffda0099,
  0xfffffffffffd000c, 0xfffffffffffd0007,
  0xfffffffffffb0014, 0xfffffffffffb000b,
  0xfffffffffffa0018, 0xfffffffffffa000d,
  0xfffffffffffa0018, 0xfffffffffffa000d,
  0xfffffffffffe0008, 0xfffffffffffe0005,
  0xfffffffffffd000c, 0xfffffffffffd0007,
  0xfffffffffffd000c, 0xfffffffffffd0007,
  0xfffffffffffe0008, 0xfffffffffffe0005,
  0xffffffffffff0004, 0xffffffffffff0003,
  0xffffffffffff0004, 0xffffffffffff0003,
  0x0000000000000000, 0x0000000000000001,
  0x000000000001fff8, 0x000000000001fffd,
  0x0000000000000000, 0x0000000000000001,
  0x000000000000fffc, 0x000000000000ffff,
  0x000000000002fff4, 0x000000000002fffb,
  0x000000000022ff74, 0x000000000022ffbb,
  0x000000000000fffc, 0x000000000000ffff,
  0x000000000002fff4, 0x000000000002fffb,
  0x000000000022ff74, 0x000000000022ffbb,
  0x00000000009ffd80, 0x00000000009ffec1,
  0x000000000001fff8, 0x000000000001fffd,
  0x000000000021ff78, 0x000000000021ffbd,
  0x00000000009efd84, 0x00000000009efec3,
  0x00000000011cfb8c, 0x00000000011cfdc7,
  0x00000000001fff80, 0x00000000001fffc1,
  0x00000000009cfd8c, 0x00000000009cfec7,
  0x00000000011afb94, 0x00000000011afdcb,
  0x000000000199f998, 0x000000000199fccd,
  0x00000000007cfe0c, 0x00000000007cff07,
  0x0000000000fafc14, 0x0000000000fafe0b,
  0x000000000179fa18, 0x000000000179fd0d,
  0x000000008174fa24, 0x000000008175fd13,
  0x00000000007dfe08, 0x00000000007dff05,
  0x0000000000fcfc0c, 0x0000000000fcfe07,
  0x0000000080f7fc18, 0x0000000080f8fe0d,
  0x0000000100f3fc20, 0x0000000100f5fe11,
  0x00000000007efe04, 0x00000000007eff03,
  0x000000008079fe10, 0x00000000807aff09,
  0x000000010075fe18, 0x000000010077ff0d,
  0x000000018072fe1c, 0x000000018075ff0f,
  0x000000007ffb000c, 0x000000007ffc0007,
  0x00000000fff70014, 0x00000000fff9000b,
  0x000000017ff40018, 0x000000017ff7000d,
  0x00003333e65a334c, 0x000033344cc399a7,
  0x000000007ffc0008, 0x000000007ffd0005,
  0x00000000fff9000c, 0x00000000fffb0007,
  0x00003333665f3340, 0x00003333ccc799a1,
  0x00008887665eddec, 0x000088887771eef7,
  0x000000007ffd0004, 0x000000007ffe0003,
  0x00003332e6633338, 0x000033334cca999d,
  0x00008886e662dde4, 0x00008887f774eef3,
  0x00010884e65fddf0, 0x00010886f771eef9,
  0x0000333266663334, 0x00003332cccc999b,
  0x000088866665dde0, 0x000088877776eef1,
  0x000108846662ddec, 0x000108867773eef7,
  0x000188826660ddf4, 0x000188857771eefb,
  0x00005553ffffaaac, 0x00005554aaaa5557,
  0x0000d551fffcaab8, 0x0000d553aaa7555d,
  0x0001554ffffaaac0, 0x00015552aaa55561,
  0x0001d54dfff9aac4, 0x0001d551aaa45563,
  0x00007ffdfffd000c, 0x00007ffefffd0007,
  0x0000fffbfffb0014, 0x0000fffdfffb000b,
  0x00017ff9fffa0018, 0x00017ffcfffa000d,
  0x0000fffbfffa0018, 0x0000fffdfffa000d,
  0x00007ffdfffe0008, 0x00007ffefffe0005,
  0x0000fffbfffd000c, 0x0000fffdfffd0007,
  0x00007ffdfffd000c, 0x00007ffefffd0007,
  0xfffffffffffe0008, 0xfffffffffffe0005,
  0x00007ffdffff0004, 0x00007ffeffff0003,
  0xffffffffffff0004, 0xffffffffffff0003,
  0xffff800200000000, 0xffff800100000001,
  0xffff2aadffff5558, 0xffff2aac5554aaad,
  0xffff800200000000, 0xffff800100000001,
  0xffff00040000fffc, 0xffff00020000ffff,
  0xfffeaab000005554, 0xfffeaaad5555aaab,
  0xfffe777d99992224, 0xfffe777a88881113,
  0xffff80020000fffc, 0xffff80010000ffff,
  0xffff2aae00005554, 0xffff2aac5555aaab,
  0xfffef77b99992224, 0xfffef77988881113,
  0xfffef77b199b2224, 0xfffef77908891113,
  0xffffaaabffff5558, 0xffffaaab5554aaad,
  0xffff777999982228, 0xffff777888871115,
  0xffff7779199a2228, 0xffff777808881115,
  0xffff7778999d2224, 0xffff7777888a1113,
  0xffffcccd9998ccd0, 0xffffcccd33326669,
  0xffffcccd199accd0, 0xffffccccb3336669,
  0xffffcccc999dcccc, 0xffffcccc33356667,
  0xffffcccc19a1ccc4, 0xffffcccbb3386663,
  0xffffffff80020000, 0xffffffff80010001,
  0xffffffff0004fffc, 0xffffffff0002ffff,
  0xfffffffe8008fff4, 0xfffffffe8005fffb,
  0xfffffffe000dffe8, 0xfffffffe0009fff5,
  0xffffffff8002fffc, 0xffffffff8001ffff,
  0xffffffff0006fff4, 0xffffffff0004fffb,
  0xfffffffe800bffe8, 0xfffffffe8008fff5,
  0xfffffffe7f8c01e8, 0xfffffffe7f8900f5,
  0xffffffff8003fff8, 0xffffffff8002fffd,
  0xffffffff0008ffec, 0xffffffff0006fff7,
  0xfffffffeff8901ec, 0xfffffffeff8700f7,
  0xfffffffeff0a03e8, 0xfffffffeff0801f5,
  0xffffffff8004fff4, 0xffffffff8003fffb,
  0xffffffff7f8501f4, 0xffffffff7f8400fb,
  0xffffffff7f0603f0, 0xffffffff7f0501f9,
  0xffffffff7e8805e8, 0xffffffff7e8702f5,
  0xffffffffff800200, 0xffffffffff800101,
  0xffffffffff0103fc, 0xffffffffff0101ff,
  0xfffffffffe8305f4, 0xfffffffffe8302fb,
  0xfffffffffe0607e8, 0xfffffffffe0603f5,
  0xffffffffff8101fc, 0xffffffffff8100ff,
  0xffffffffff0303f4, 0xffffffffff0301fb,
  0xfffffffffe8605e8, 0xfffffffffe8602f5,
  0xfffffffffe660668, 0xfffffffffe660335,
  0xffffffffff8201f8, 0xffffffffff8200fd,
  0xffffffffff0503ec, 0xffffffffff0501f7,
  0xfffffffffee5046c, 0xfffffffffee50237,
  0xfffffffffee20478, 0xfffffffffee2023d,
  0xffffffffff8301f4, 0xffffffffff8300fb,
  0xffffffffff630274, 0xffffffffff63013b,
  0xffffffffff600280, 0xffffffffff600141,
  0xffffffffff5e0288, 0xffffffffff5e0145,
  0xffffffffffe00080, 0xffffffffffe00041,
  0xffffffffffdd008c, 0xffffffffffdd0047,
  0xffffffffffdb0094, 0xffffffffffdb004b,
  0xffffffffffda0098, 0xffffffffffda004d,
  0xfffffffffffd0006, 0xfffffffecccccccf,
  0xfffffffffffb000a, 0xfffffffe00000003,
  0xfffffffffffa000c, 0xfffffffd9999999d,
  0xfffffffffffa000c, 0xfffffffd9999999d,
  0xfffffffffffe0004, 0xffffffff33333335,
  0xfffffffffffd0006, 0xfffffffecccccccf,
  0xfffffffffffd0006, 0xfffffffecccccccf,
  0xfffffffffffe0004, 0xffffffff33333335,
  0xffffffffffff0002, 0xffffffff9999999b,
  0xffffffffffff0002, 0xffffffff9999999b,
  0x0000000000000000, 0x0000000000000001,
  0x000000000001fffc, 0x00000000cccccccd,
  0x0000000000000000, 0x0000000000000001,
  0x000000000000fffe, 0x0000000066666667,
  0x000000000002fffa, 0x0000000133333333,
  0x000000000022ffba, 0x0000000dfffffff3,
  0x000000000000fffe, 0x0000000066666667,
  0x000000000002fffa, 0x0000000133333333,
  0x000000000022ffba, 0x0000000dfffffff3,
  0x00000000009ffec0, 0x0000003fffffffc1,
  0x000000000001fffc, 0x00000000cccccccd,
  0x000000000021ffbc, 0x0000000d9999998d,
  0x00000000009efec2, 0x0000003f9999995b,
  0x00000000011cfdc6, 0x00000071ffffff8f,
  0x00000000001fffc0, 0x0000000cccccccc1,
  0x00000000009cfec6, 0x0000003ecccccc8f,
  0x00000000011afdca, 0x00000071333332c3,
  0x000000000199fccc, 0x000000a3ffffff5d,
  0x00000000007cff06, 0x00000031ffffffcf,
  0x0000000000fafe0a, 0x0000006466666603,
  0x000000000179fd0c, 0x000000973333329d,
  0x000000008175fd12, 0x000033c93332ff6b,
  0x00000000007dff04, 0x0000003266666635,
  0x0000000000fcfe06, 0x00000065333332cf,
  0x0000000080f8fe0c, 0x000033973332ff9d,
  0x0000000100f5fe10, 0x000066c9999932d1,
  0x00000000007eff02, 0x00000032cccccc9b,
  0x00000000807aff08, 0x00003364cccc9969,
  0x000000010077ff0c, 0x000066973332cc9d,
  0x000000018075ff0e, 0x000099c9ffff6637,
  0x000000007ffc0006, 0x00003331ffffcccf,
  0x00000000fff9000a, 0x0000666466660003,
  0x000000017ff7000c, 0x000099973332999d,
  0x000033344cc399a6, 0x147b7adeb85151ef,
  0x000000007ffd0004, 0x0000333266663335,
  0x00000000fffb0006, 0x000066653332cccf,
  0x00003333ccc799a0, 0x147b47acb8518521,
  0x000088887771eef6, 0x369d69ce962f62ff,
  0x000000007ffe0002, 0x00003332cccc999b,
  0x000033334cca999c, 0x147b147a51eb51ed,
  0x00008887f774eef2, 0x369d369c2fc92fcb,
  0x00010886f771eef8, 0x69d069cdfc95fc99,
  0x00003332cccc999a, 0x147ae147851eb853,
  0x000088877776eef0, 0x369d036962fc9631,
  0x000108867773eef6, 0x69d0369b2fc962ff,
  0x000188857771eefa, 0x7fffffffffffffff,
  0x00005554aaaa5556, 0x22222221dddddddf,
  0x0000d553aaa7555c, 0x55555553aaaaaaad,
  0x00015552aaa55560, 0x7fffffffffffffff,
  0x0001d551aaa45562, 0x7fffffffffffffff,
  0x00007ffefffd0006, 0x33333331cccccccf,
  0x0000fffdfffb000a, 0x6666666400000003,
  0x00017ffcfffa000c, 0x7fffffffffffffff,
  0x0000fffdfffa000c, 0x4cccccccffffffff,
  0x00007ffefffe0004, 0x3333333233333335,
  0x0000fffdfffd0006, 0x66666664cccccccf,
  0x00007ffefffd0006, 0x33333331cccccccf,
  0xfffffffffffe0004, 0xffffffff33333335,
  0x00007ffeffff0002, 0x333333329999999b,
  0xffffffffffff0002, 0xffffffff9999999b,
  0xffff800100000000, 0xcccccccd00000001,
  0xffff2aac5554aaac, 0xaaaaaaaabbbbbbbd,
  0xffff800100000000, 0xcccccccd00000001,
  0xffff00020000fffe, 0x9999999a66666667,
  0xfffeaaad5555aaaa, 0x8000000000000000,
  0xfffe777a88881112, 0x8000000000000000,
  0xffff80010000fffe, 0xcccccccd66666667,
  0xffff2aac5555aaaa, 0xaaaaaaab22222223,
  0xfffef77988881112, 0x962fc963369d036b,
  0xfffef77908891112, 0x962f9630036a036b,
  0xffffaaab5554aaac, 0xddddddddbbbbbbbd,
  0xffff777888871114, 0xc962fc95d0369d05,
  0xffff777808881114, 0xc962c9629d039d05,
  0xffff7777888a1112, 0xc962962fd037036b,
  0xffffcccd33326668, 0xeb851eb8147ae149,
  0xffffccccb3336668, 0xeb84eb84e147e149,
  0xffffcccc33356666, 0xeb84b852147b47af,
  0xffffcccbb3386662, 0xeb84851fae15147b,
  0xffffffff80010000, 0xffffcccccccd0001,
  0xffffffff0002fffe, 0xffff999a00006667,
  0xfffffffe8005fffa, 0xffff6667999a3333,
  0xfffffffe0009fff4, 0xffff3335999a6665,
  0xffffffff8001fffe, 0xffffcccd33336667,
  0xffffffff0004fffa, 0xffff999acccd3333,
  0xfffffffe8008fff4, 0xffff6668cccd6665,
  0xfffffffe7f8900f4, 0xffff6635999a3365,
  0xffffffff8002fffc, 0xffffcccd9999cccd,
  0xffffffff0006fff6, 0xffff999b9999ffff,
  0xfffffffeff8700f6, 0xffff99686666ccff,
  0xfffffffeff0801f4, 0xffff9935999a0065,
  0xffffffff8003fffa, 0xffffccce00003333,
  0xffffffff7f8400fa, 0xffffcc9acccd0033,
  0xffffffff7f0501f8, 0xffffcc6800003399,
  0xffffffff7e8702f4, 0xffffcc359999cd65,
  0xffffffffff800100, 0xffffffcccccccd01,
  0xffffffffff0101fe, 0xffffff9a00000067,
  0xfffffffffe8302fa, 0xffffff6799999a33,
  0xfffffffffe0603f4, 0xffffff3599999a65,
  0xffffffffff8100fe, 0xffffffcd33333367,
  0xffffffffff0301fa, 0xffffff9acccccd33,
  0xfffffffffe8602f4, 0xffffff68cccccd65,
  0xfffffffffe660334, 0xffffff5c000000a5,
  0xffffffffff8200fc, 0xffffffcd999999cd,
  0xffffffffff0501f6, 0xffffff9b999999ff,
  0xfffffffffee50236, 0xffffff8ecccccd3f,
  0xfffffffffee2023c, 0xffffff8d99999a0d,
  0xffffffffff8300fa, 0xffffffce00000033,
  0xffffffffff63013a, 0xffffffc133333373,
  0xffffffffff600140, 0xffffffc000000041,
  0xffffffffff5e0144, 0xffffffbf33333375,
  0xffffffffffe00040, 0xfffffff333333341,
  0xffffffffffdd0046, 0xfffffff20000000f,
  0xffffffffffdb004a, 0xfffffff133333343,
  0xffffffffffda004c, 0xfffffff0ccccccdd,
  0xfffffffeccccccce, 0xfffffffe00000003,
  0xfffffffe00000002, 0xfffffffcaaaaaaaf,
  0xfffffffd9999999c, 0xfffffffc00000005,
  0xfffffffd9999999c, 0xfffffffc00000005,
  0xffffffff33333334, 0xfffffffeaaaaaaad,
  0xfffffffeccccccce, 0xfffffffe00000003,
  0xfffffffeccccccce, 0xfffffffe00000003,
  0xffffffff33333334, 0xfffffffeaaaaaaad,
  0xffffffff9999999a, 0xffffffff55555557,
  0xffffffff9999999a, 0xffffffff55555557,
  0x0000000000000000, 0x0000000000000001,
  0x00000000cccccccc, 0x0000000155555555,
  0x0000000000000000, 0x0000000000000001,
  0x0000000066666666, 0x00000000aaaaaaab,
  0x0000000133333332, 0x00000001ffffffff,
  0x0000000dfffffff2, 0x000000175555553f,
  0x0000000066666666, 0x00000000aaaaaaab,
  0x0000000133333332, 0x00000001ffffffff,
  0x0000000dfffffff2, 0x000000175555553f,
  0x0000003fffffffc0, 0x0000006aaaaaaa41,
  0x00000000cccccccc, 0x0000000155555555,
  0x0000000d9999998c, 0x00000016aaaaaa95,
  0x0000003f9999995a, 0x00000069ffffff97,
  0x00000071ffffff8e, 0x000000bdffffff43,
  0x0000000cccccccc0, 0x0000001555555541,
  0x0000003ecccccc8e, 0x00000068aaaaaa43,
  0x00000071333332c2, 0x000000bcaaaaa9ef,
  0x000000a3ffffff5c, 0x0000011155555445,
  0x00000031ffffffce, 0x0000005355555503,
  0x0000006466666602, 0x000000a7555554af,
  0x000000973333329c, 0x000000fbffffff05,
  0x000033c93332ff6a, 0x0000564f5554ff07,
  0x0000003266666634, 0x00000053ffffffad,
  0x00000065333332ce, 0x000000a8aaaaaa03,
  0x000033973332ff9c, 0x000055fbffffaa05,
  0x000066c9999932d0, 0x0000ab4fffff54b1,
  0x00000032cccccc9a, 0x00000054aaaaaa57,
  0x00003364cccc9968, 0x000055a7ffffaa59,
  0x000066973332cc9c, 0x0000aafbffff5505,
  0x000099c9ffff6636, 0x00010050aaa9aa5b,
  0x00003331ffffccce, 0x0000555355550003,
  0x0000666466660002, 0x0000aaa75554aaaf,
  0x000099973332999c, 0x0000fffbffff0005,
  0x147b7adeb85151ee, 0x2223221ddddcdde3,
  0x0000333266663334, 0x00005553ffffaaad,
  0x000066653332ccce, 0x0000aaa8aaaa0003,
  0x147b47acb8518520, 0x2222ccca8887dde1,
  0x369d69ce962f62fe, 0x5b065b02fa4efa53,
  0x00003332cccc999a, 0x00005554aaaa5557,
  0x147b147a51eb51ec, 0x2222777688883335,
  0x369d369c2fc92fca, 0x5b0605aefa4f4fa7,
  0x69d069cdfc95fc98, 0x7fffffffffffffff,
  0x147ae147851eb852, 0x22222221dddddddf,
  0x369d036962fc9630, 0x5b05b05a4fa4fa51,
  0x69d0369b2fc962fe, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x22222221ddddddde, 0x38e38e3871c71c73,
  0x55555553aaaaaaac, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x33333331ccccccce, 0x5555555300000003,
  0x6666666400000002, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x4cccccccffffffff, 0x2aaaaaaaffffffff,
  0x3333333233333334, 0x55555553aaaaaaad,
  0x66666664ccccccce, 0x7fffffffffffffff,
  0x33333331ccccccce, 0x2aaaaaaaffffffff,
  0xffffffff33333334, 0xd5555556aaaaaaa9,
  0x333333329999999a, 0x5555555455555557,
  0xffffffff9999999a, 0xffffffff55555557,
  0xcccccccd00000000, 0xaaaaaaab00000001,
  0xaaaaaaaabbbbbbbc, 0x8000000000000000,
  0xcccccccd00000000, 0xaaaaaaab00000001,
  0x9999999a66666666, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xcccccccd66666666, 0xaaaaaaabaaaaaaab,
  0xaaaaaaab22222222, 0x8000000000000000,
  0x962fc963369d036a, 0x8000000000000000,
  0x962f9630036a036a, 0x8000000000000000,
  0xddddddddbbbbbbbc, 0xc71c71c6e38e38e5,
  0xc962fc95d0369d04, 0xa4fa4fa45b05b05d,
  0xc962c9629d039d04, 0xa4f9fa4f05b0b05d,
  0xc962962fd037036a, 0xa4f9a4fa5b065b07,
  0xeb851eb8147ae148, 0xdddddddd77777779,
  0xeb84eb84e147e148, 0xdddd888822227779,
  0xeb84b852147b47ae, 0xdddd333377782223,
  0xeb84851fae15147a, 0xdddcdddf77787777,
  0xffffcccccccd0000, 0xffffaaaaaaab0001,
  0xffff999a00006666, 0xffff55560000aaab,
  0xffff6667999a3332, 0xffff00020000ffff,
  0xffff3335999a6664, 0xfffeaaaeaaabfffd,
  0xffffcccd33336666, 0xffffaaab5555aaab,
  0xffff999acccd3332, 0xffff55575555ffff,
  0xffff6668cccd6664, 0xffff00040000fffd,
  0xffff6635999a3364, 0xfffeffaeaaabaafd,
  0xffffcccd9999cccc, 0xffffaaac00005555,
  0xffff999b9999fffe, 0xffff5558aaab5553,
  0xffff99686666ccfe, 0xffff550355560053,
  0xffff9935999a0064, 0xffff54aeaaab55fd,
  0xffffccce00003332, 0xffffaaacaaaaffff,
  0xffffcc9acccd0032, 0xffffaa575555aaff,
  0xffffcc6800003398, 0xffffaa02aaab00a9,
  0xffffcc359999cd64, 0xffffa9aeaaab00fd,
  0xffffffcccccccd00, 0xffffffaaaaaaab01,
  0xffffff9a00000066, 0xffffff56000000ab,
  0xffffff6799999a32, 0xffffff02000000ff,
  0xffffff3599999a64, 0xfffffeaeaaaaabfd,
  0xffffffcd33333366, 0xffffffab555555ab,
  0xffffff9acccccd32, 0xffffff57555555ff,
  0xffffff68cccccd64, 0xffffff04000000fd,
  0xffffff5c000000a4, 0xfffffeeeaaaaabbd,
  0xffffffcd999999cc, 0xffffffac00000055,
  0xffffff9b999999fe, 0xffffff58aaaaab53,
  0xffffff8ecccccd3e, 0xffffff4355555613,
  0xffffff8d99999a0c, 0xffffff4155555615,
  0xffffffce00000032, 0xffffffacaaaaaaff,
  0xffffffc133333372, 0xffffff97555555bf,
  0xffffffc000000040, 0xffffff95555555c1,
  0xffffffbf33333374, 0xffffff940000006d,
  0xfffffff333333340, 0xffffffeaaaaaaac1,
  0xfffffff20000000e, 0xffffffe8aaaaaac3,
  0xfffffff133333342, 0xffffffe75555556f,
  0xfffffff0ccccccdc, 0xffffffe6aaaaaac5,
  0xfffffffe00000002, 0xfffffffd00000013,
  0xfffffffcaaaaaaae, 0xfffffffb0000001f,
  0xfffffffc00000004, 0xfffffffa00000025,
  0xfffffffc00000004, 0xfffffffa00000025,
  0xfffffffeaaaaaaac, 0xfffffffe0000000d,
  0xfffffffe00000002, 0xfffffffd00000013,
  0xfffffffe00000002, 0xfffffffd00000013,
  0xfffffffeaaaaaaac, 0xfffffffe0000000d,
  0xffffffff55555556, 0xffffffff00000007,
  0xffffffff55555556, 0xffffffff00000007,
  0x0000000000000000, 0x0000000000000001,
  0x0000000155555554, 0x00000001fffffff5,
  0x0000000000000000, 0x0000000000000001,
  0x00000000aaaaaaaa, 0x00000000fffffffb,
  0x00000001fffffffe, 0x00000002ffffffef,
  0x000000175555553e, 0x00000022ffffff2f,
  0x00000000aaaaaaaa, 0x00000000fffffffb,
  0x00000001fffffffe, 0x00000002ffffffef,
  0x000000175555553e, 0x00000022ffffff2f,
  0x0000006aaaaaaa40, 0x0000009ffffffc41,
  0x0000000155555554, 0x00000001fffffff5,
  0x00000016aaaaaa94, 0x00000021ffffff35,
  0x00000069ffffff96, 0x0000009efffffc47,
  0x000000bdffffff42, 0x0000011cfffff953,
  0x0000001555555540, 0x0000001fffffff41,
  0x00000068aaaaaa42, 0x0000009cfffffc53,
  0x000000bcaaaaa9ee, 0x0000011afffff95f,
  0x0000011155555444, 0x00000199fffff665,
  0x0000005355555502, 0x0000007cfffffd13,
  0x000000a7555554ae, 0x000000fafffffa1f,
  0x000000fbffffff04, 0x00000179fffff725,
  0x0000564f5554ff06, 0x00008176fffcf737,
  0x00000053ffffffac, 0x0000007dfffffd0d,
  0x000000a8aaaaaa02, 0x000000fcfffffa13,
  0x000055fbffffaa04, 0x000080f9fffcfa25,
  0x0000ab4fffff54b0, 0x000100f7fff9fa31,
  0x00000054aaaaaa56, 0x0000007efffffd07,
  0x000055a7ffffaa58, 0x0000807bfffcfd19,
  0x0000aafbffff5504, 0x00010079fff9fd25,
  0x00010050aaa9aa5a, 0x00018078fff6fd2b,
  0x0000555355550002, 0x00007ffcfffd0013,
  0x0000aaa75554aaae, 0x0000fffafffa001f,
  0x0000fffbffff0004, 0x00017ff9fff70025,
  0x2223221ddddcdde2, 0x3334b32bccc3ccf3,
  0x00005553ffffaaac, 0x00007ffdfffd000d,
  0x0000aaa8aaaa0002, 0x0000fffcfffa0013,
  0x2222ccca8887dde0, 0x3334332eccc6cce1,
  0x5b065b02fa4efa52, 0x7fffffffffffffff,
  0x00005554aaaa5556, 0x00007ffefffd0007,
  0x2222777688883334, 0x3333b330ccc9ccd5,
  0x5b0605aefa4f4fa6, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x22222221ddddddde, 0x33333331cccccccf,
  0x5b05b05a4fa4fa50, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x38e38e3871c71c72, 0x5555555300000003,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x5555555300000002, 0x7ffffffa00000013,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x2aaaaaaaffffffff, 0x00000002ffffffff,
  0x55555553aaaaaaac, 0x7ffffffb0000000d,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x2aaaaaaaffffffff, 0x00000002ffffffff,
  0xd5555556aaaaaaa9, 0x80000006fffffff9,
  0x5555555455555556, 0x7ffffffc00000007,
  0xffffffff55555556, 0xffffffff00000007,
  0xaaaaaaab00000000, 0x8000000300000001,
  0x8000000000000000, 0x8000000000000000,
  0xaaaaaaab00000000, 0x8000000300000001,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xaaaaaaabaaaaaaaa, 0x80000003fffffffb,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xc71c71c6e38e38e4, 0xaaaaaaac00000005,
  0xa4fa4fa45b05b05c, 0x8000000000000000,
  0xa4f9fa4f05b0b05c, 0x8000000000000000,
  0xa4f9a4fa5b065b06, 0x8000000000000000,
  0xdddddddd77777778, 0xcccccccd33333339,
  0xdddd888822227778, 0xcccc4ccd33363339,
  0xdddd333377782222, 0xcccbccce33393333,
  0xdddcdddf77787776, 0xcccb4cd0333c3327,
  0xffffaaaaaaab0000, 0xffff800000030001,
  0xffff55560000aaaa, 0xffff00010005fffb,
  0xffff00020000fffe, 0xfffe80030008ffef,
  0xfffeaaaeaaabfffc, 0xfffe0006000bffdd,
  0xffffaaab5555aaaa, 0xffff80010002fffb,
  0xffff55575555fffe, 0xffff00030005ffef,
  0xffff00040000fffc, 0xfffe80060008ffdd,
  0xfffeffaeaaabaafc, 0xfffe7f86000902dd,
  0xffffaaac00005554, 0xffff80020002fff5,
  0xffff5558aaab5552, 0xffff00050005ffe3,
  0xffff550355560052, 0xfffeff85000602e3,
  0xffff54aeaaab55fc, 0xfffeff06000605dd,
  0xffffaaacaaaafffe, 0xffff80030002ffef,
  0xffffaa575555aafe, 0xffff7f83000302ef,
  0xffffaa02aaab00a8, 0xffff7f04000305e9,
  0xffffa9aeaaab00fc, 0xffff7e86000308dd,
  0xffffffaaaaaaab00, 0xffffff8000000301,
  0xffffff56000000aa, 0xffffff01000005fb,
  0xffffff02000000fe, 0xfffffe83000008ef,
  0xfffffeaeaaaaabfc, 0xfffffe0600000bdd,
  0xffffffab555555aa, 0xffffff81000002fb,
  0xffffff57555555fe, 0xffffff03000005ef,
  0xffffff04000000fc, 0xfffffe86000008dd,
  0xfffffeeeaaaaabbc, 0xfffffe660000099d,
  0xffffffac00000054, 0xffffff82000002f5,
  0xffffff58aaaaab52, 0xffffff05000005e3,
  0xffffff4355555612, 0xfffffee5000006a3,
  0xffffff4155555614, 0xfffffee2000006b5,
  0xffffffacaaaaaafe, 0xffffff83000002ef,
  0xffffff97555555be, 0xffffff63000003af,
  0xffffff95555555c0, 0xffffff60000003c1,
  0xffffff940000006c, 0xffffff5e000003cd,
  0xffffffeaaaaaaac0, 0xffffffe0000000c1,
  0xffffffe8aaaaaac2, 0xffffffdd000000d3,
  0xffffffe75555556e, 0xffffffdb000000df,
  0xffffffe6aaaaaac4, 0xffffffda000000e5,
  0xfffffffd00000012, 0xfffffffd0000000d,
  0xfffffffb0000001e, 0xfffffffb00000015,
  0xfffffffa00000024, 0xfffffffa00000019,
  0xfffffffa00000024, 0xfffffffa00000019,
  0xfffffffe0000000c, 0xfffffffe00000009,
  0xfffffffd00000012, 0xfffffffd0000000d,
  0xfffffffd00000012, 0xfffffffd0000000d,
  0xfffffffe0000000c, 0xfffffffe00000009,
  0xffffffff00000006, 0xffffffff00000005,
  0xffffffff00000006, 0xffffffff00000005,
  0x0000000000000000, 0x0000000000000001,
  0x00000001fffffff4, 0x00000001fffffff9,
  0x0000000000000000, 0x0000000000000001,
  0x00000000fffffffa, 0x00000000fffffffd,
  0x00000002ffffffee, 0x00000002fffffff5,
  0x00000022ffffff2e, 0x00000022ffffff75,
  0x00000000fffffffa, 0x00000000fffffffd,
  0x00000002ffffffee, 0x00000002fffffff5,
  0x00000022ffffff2e, 0x00000022ffffff75,
  0x0000009ffffffc40, 0x0000009ffffffd81,
  0x00000001fffffff4, 0x00000001fffffff9,
  0x00000021ffffff34, 0x00000021ffffff79,
  0x0000009efffffc46, 0x0000009efffffd85,
  0x0000011cfffff952, 0x0000011cfffffb8d,
  0x0000001fffffff40, 0x0000001fffffff81,
  0x0000009cfffffc52, 0x0000009cfffffd8d,
  0x0000011afffff95e, 0x0000011afffffb95,
  0x00000199fffff664, 0x00000199fffff999,
  0x0000007cfffffd12, 0x0000007cfffffe0d,
  0x000000fafffffa1e, 0x000000fafffffc15,
  0x00000179fffff724, 0x00000179fffffa19,
  0x00008176fffcf736, 0x00008176fffdfa25,
  0x0000007dfffffd0c, 0x0000007dfffffe09,
  0x000000fcfffffa12, 0x000000fcfffffc0d,
  0x000080f9fffcfa24, 0x000080f9fffdfc19,
  0x000100f7fff9fa30, 0x000100f7fffbfc21,
  0x0000007efffffd06, 0x0000007efffffe05,
  0x0000807bfffcfd18, 0x0000807bfffdfe11,
  0x00010079fff9fd24, 0x00010079fffbfe19,
  0x00018078fff6fd2a, 0x00018078fff9fe1d,
  0x00007ffcfffd0012, 0x00007ffcfffe000d,
  0x0000fffafffa001e, 0x0000fffafffc0015,
  0x00017ff9fff70024, 0x00017ff9fffa0019,
  0x3334b32bccc3ccf2, 0x3334b32c332d334d,
  0x00007ffdfffd000c, 0x00007ffdfffe0009,
  0x0000fffcfffa0012, 0x0000fffcfffc000d,
  0x3334332eccc6cce0, 0x3334332f332f3341,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x00007ffefffd0006, 0x00007ffefffe0005,
  0x3333b330ccc9ccd4, 0x3333b33133313339,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x33333331ccccccce, 0x3333333233333335,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x5555555300000002, 0x55555553aaaaaaad,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7ffffffa00000012, 0x7ffffffb0000000d,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x00000002ffffffff, 0x00000001ffffffff,
  0x7ffffffb0000000c, 0x7ffffffc00000009,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x00000002ffffffff, 0x00000001ffffffff,
  0x80000006fffffff9, 0x80000004fffffffb,
  0x7ffffffc00000006, 0x7ffffffd00000005,
  0xffffffff00000006, 0xffffffff00000005,
  0x8000000300000000, 0x8000000200000001,
  0x8000000000000000, 0x8000000000000000,
  0x8000000300000000, 0x8000000200000001,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x80000003fffffffa, 0x80000002fffffffd,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xaaaaaaac00000004, 0xaaaaaaab55555559,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xcccccccd33333338, 0xccccccccccccccd1,
  0xcccc4ccd33363338, 0xcccc4cccccceccd1,
  0xcccbccce33393332, 0xcccbcccdccd0cccd,
  0xcccb4cd0333c3326, 0xcccb4ccfccd2ccc5,
  0xffff800000030000, 0xffff800000020001,
  0xffff00010005fffa, 0xffff00010003fffd,
  0xfffe80030008ffee, 0xfffe80030005fff5,
  0xfffe0006000bffdc, 0xfffe00060007ffe9,
  0xffff80010002fffa, 0xffff80010001fffd,
  0xffff00030005ffee, 0xffff00030003fff5,
  0xfffe80060008ffdc, 0xfffe80060005ffe9,
  0xfffe7f86000902dc, 0xfffe7f86000601e9,
  0xffff80020002fff4, 0xffff80020001fff9,
  0xffff00050005ffe2, 0xffff00050003ffed,
  0xfffeff85000602e2, 0xfffeff85000401ed,
  0xfffeff06000605dc, 0xfffeff06000403e9,
  0xffff80030002ffee, 0xffff80030001fff5,
  0xffff7f83000302ee, 0xffff7f83000201f5,
  0xffff7f04000305e8, 0xffff7f04000203f1,
  0xffff7e86000308dc, 0xffff7e86000205e9,
  0xffffff8000000300, 0xffffff8000000201,
  0xffffff01000005fa, 0xffffff01000003fd,
  0xfffffe83000008ee, 0xfffffe83000005f5,
  0xfffffe0600000bdc, 0xfffffe06000007e9,
  0xffffff81000002fa, 0xffffff81000001fd,
  0xffffff03000005ee, 0xffffff03000003f5,
  0xfffffe86000008dc, 0xfffffe86000005e9,
  0xfffffe660000099c, 0xfffffe6600000669,
  0xffffff82000002f4, 0xffffff82000001f9,
  0xffffff05000005e2, 0xffffff05000003ed,
  0xfffffee5000006a2, 0xfffffee50000046d,
  0xfffffee2000006b4, 0xfffffee200000479,
  0xffffff83000002ee, 0xffffff83000001f5,
  0xffffff63000003ae, 0xffffff6300000275,
  0xffffff60000003c0, 0xffffff6000000281,
  0xffffff5e000003cc, 0xffffff5e00000289,
  0xffffffe0000000c0, 0xffffffe000000081,
  0xffffffdd000000d2, 0xffffffdd0000008d,
  0xffffffdb000000de, 0xffffffdb00000095,
  0xffffffda000000e4, 0xffffffda00000099,
  0xfffffffd0000000c, 0xfffffffd00000007,
  0xfffffffb00000014, 0xfffffffb0000000b,
  0xfffffffa00000018, 0xfffffffa0000000d,
  0xfffffffa00000018, 0xfffffffa0000000d,
  0xfffffffe00000008, 0xfffffffe00000005,
  0xfffffffd0000000c, 0xfffffffd00000007,
  0xfffffffd0000000c, 0xfffffffd00000007,
  0xfffffffe00000008, 0xfffffffe00000005,
  0xffffffff00000004, 0xffffffff00000003,
  0xffffffff00000004, 0xffffffff00000003,
  0x0000000000000000, 0x0000000000000001,
  0x00000001fffffff8, 0x00000001fffffffd,
  0x0000000000000000, 0x0000000000000001,
  0x00000000fffffffc, 0x00000000ffffffff,
  0x00000002fffffff4, 0x00000002fffffffb,
  0x00000022ffffff74, 0x00000022ffffffbb,
  0x00000000fffffffc, 0x00000000ffffffff,
  0x00000002fffffff4, 0x00000002fffffffb,
  0x00000022ffffff74, 0x00000022ffffffbb,
  0x0000009ffffffd80, 0x0000009ffffffec1,
  0x00000001fffffff8, 0x00000001fffffffd,
  0x00000021ffffff78, 0x00000021ffffffbd,
  0x0000009efffffd84, 0x0000009efffffec3,
  0x0000011cfffffb8c, 0x0000011cfffffdc7,
  0x0000001fffffff80, 0x0000001fffffffc1,
  0x0000009cfffffd8c, 0x0000009cfffffec7,
  0x0000011afffffb94, 0x0000011afffffdcb,
  0x00000199fffff998, 0x00000199fffffccd,
  0x0000007cfffffe0c, 0x0000007cffffff07,
  0x000000fafffffc14, 0x000000fafffffe0b,
  0x00000179fffffa18, 0x00000179fffffd0d,
  0x00008176fffdfa24, 0x00008176fffefd13,
  0x0000007dfffffe08, 0x0000007dffffff05,
  0x000000fcfffffc0c, 0x000000fcfffffe07,
  0x000080f9fffdfc18, 0x000080f9fffefe0d,
  0x000100f7fffbfc20, 0x000100f7fffdfe11,
  0x0000007efffffe04, 0x0000007effffff03,
  0x0000807bfffdfe10, 0x0000807bfffeff09,
  0x00010079fffbfe18, 0x00010079fffdff0d,
  0x00018078fff9fe1c, 0x00018078fffcff0f,
  0x00007ffcfffe000c, 0x00007ffcffff0007,
  0x0000fffafffc0014, 0x0000fffafffe000b,
  0x00017ff9fffa0018, 0x00017ff9fffd000d,
  0x3334b32c332d334c, 0x3334b32c999699a7,
  0x00007ffdfffe0008, 0x00007ffdffff0005,
  0x0000fffcfffc000c, 0x0000fffcfffe0007,
  0x3334332f332f3340, 0x3334332f999799a1,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x00007ffefffe0004, 0x00007ffeffff0003,
  0x3333b33133313338, 0x3333b3319998999d,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x3333333233333334, 0x333333329999999b,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x55555553aaaaaaac, 0x5555555455555557,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7ffffffb0000000c, 0x7ffffffc00000007,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x00000001ffffffff, 0x00000000ffffffff,
  0x7ffffffc00000008, 0x7ffffffd00000005,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x00000001ffffffff, 0x00000000ffffffff,
  0x80000004fffffffb, 0x80000002fffffffd,
  0x7ffffffd00000004, 0x7ffffffe00000003,
  0xffffffff00000004, 0xffffffff00000003,
  0x8000000200000000, 0x8000000100000001,
  0x8000000000000000, 0x8000000000000000,
  0x8000000200000000, 0x8000000100000001,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x80000002fffffffc, 0x80000001ffffffff,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xaaaaaaab55555558, 0xaaaaaaaaaaaaaaad,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xccccccccccccccd0, 0xcccccccc66666669,
  0xcccc4cccccceccd0, 0xcccc4ccc66676669,
  0xcccbcccdccd0cccc, 0xcccbcccd66686667,
  0xcccb4ccfccd2ccc4, 0xcccb4ccf66696663,
  0xffff800000020000, 0xffff800000010001,
  0xffff00010003fffc, 0xffff00010001ffff,
  0xfffe80030005fff4, 0xfffe80030002fffb,
  0xfffe00060007ffe8, 0xfffe00060003fff5,
  0xffff80010001fffc, 0xffff80010000ffff,
  0xffff00030003fff4, 0xffff00030001fffb,
  0xfffe80060005ffe8, 0xfffe80060002fff5,
  0xfffe7f86000601e8, 0xfffe7f86000300f5,
  0xffff80020001fff8, 0xffff80020000fffd,
  0xffff00050003ffec, 0xffff00050001fff7,
  0xfffeff85000401ec, 0xfffeff85000200f7,
  0xfffeff06000403e8, 0xfffeff06000201f5,
  0xffff80030001fff4, 0xffff80030000fffb,
  0xffff7f83000201f4, 0xffff7f83000100fb,
  0xffff7f04000203f0, 0xffff7f04000101f9,
  0xffff7e86000205e8, 0xffff7e86000102f5,
  0xffffff8000000200, 0xffffff8000000101,
  0xffffff01000003fc, 0xffffff01000001ff,
  0xfffffe83000005f4, 0xfffffe83000002fb,
  0xfffffe06000007e8, 0xfffffe06000003f5,
  0xffffff81000001fc, 0xffffff81000000ff,
  0xffffff03000003f4, 0xffffff03000001fb,
  0xfffffe86000005e8, 0xfffffe86000002f5,
  0xfffffe6600000668, 0xfffffe6600000335,
  0xffffff82000001f8, 0xffffff82000000fd,
  0xffffff05000003ec, 0xffffff05000001f7,
  0xfffffee50000046c, 0xfffffee500000237,
  0xfffffee200000478, 0xfffffee20000023d,
  0xffffff83000001f4, 0xffffff83000000fb,
  0xffffff6300000274, 0xffffff630000013b,
  0xffffff6000000280, 0xffffff6000000141,
  0xffffff5e00000288, 0xffffff5e00000145,
  0xffffffe000000080, 0xffffffe000000041,
  0xffffffdd0000008c, 0xffffffdd00000047,
  0xffffffdb00000094, 0xffffffdb0000004b,
  0xffffffda00000098, 0xffffffda0000004d,
  0xfffffffd00000006, 0x0000000300000001,
  0xfffffffb0000000a, 0x0000000500000001,
  0xfffffffa0000000c, 0x0000000600000001,
  0xfffffffa0000000c, 0x0000000600000001,
  0xfffffffe00000004, 0x0000000200000001,
  0xfffffffd00000006, 0x0000000300000001,
  0xfffffffd00000006, 0x0000000300000001,
  0xfffffffe00000004, 0x0000000200000001,
  0xffffffff00000002, 0x0000000100000001,
  0xffffffff00000002, 0x0000000100000001,
  0x0000000000000000, 0x0000000000000001,
  0x00000001fffffffc, 0xfffffffe00000001,
  0x0000000000000000, 0x0000000000000001,
  0x00000000fffffffe, 0xffffffff00000001,
  0x00000002fffffffa, 0xfffffffd00000001,
  0x00000022ffffffba, 0xffffffdd00000001,
  0x00000000fffffffe, 0xffffffff00000001,
  0x00000002fffffffa, 0xfffffffd00000001,
  0x00000022ffffffba, 0xffffffdd00000001,
  0x0000009ffffffec0, 0xffffff6000000001,
  0x00000001fffffffc, 0xfffffffe00000001,
  0x00000021ffffffbc, 0xffffffde00000001,
  0x0000009efffffec2, 0xffffff6100000001,
  0x0000011cfffffdc6, 0xfffffee300000001,
  0x0000001fffffffc0, 0xffffffe000000001,
  0x0000009cfffffec6, 0xffffff6300000001,
  0x0000011afffffdca, 0xfffffee500000001,
  0x00000199fffffccc, 0xfffffe6600000001,
  0x0000007cffffff06, 0xffffff8300000001,
  0x000000fafffffe0a, 0xffffff0500000001,
  0x00000179fffffd0c, 0xfffffe8600000001,
  0x00008176fffefd12, 0xffff7e8900000001,
  0x0000007dffffff04, 0xffffff8200000001,
  0x000000fcfffffe06, 0xffffff0300000001,
  0x000080f9fffefe0c, 0xffff7f0600000001,
  0x000100f7fffdfe10, 0xfffeff0800000001,
  0x0000007effffff02, 0xffffff8100000001,
  0x0000807bfffeff08, 0xffff7f8400000001,
  0x00010079fffdff0c, 0xfffeff8600000001,
  0x00018078fffcff0e, 0xfffe7f8700000001,
  0x00007ffcffff0006, 0xffff800300000001,
  0x0000fffafffe000a, 0xffff000500000001,
  0x00017ff9fffd000c, 0xfffe800600000001,
  0x3334b32c999699a6, 0xcccb4cd300000001,
  0x00007ffdffff0004, 0xffff800200000001,
  0x0000fffcfffe0006, 0xffff000300000001,
  0x3334332f999799a0, 0xcccbccd000000001,
  0x7fffffffffffffff, 0x8000000000000000,
  0x00007ffeffff0002, 0xffff800100000001,
  0x3333b3319998999c, 0xcccc4cce00000001,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x333333329999999a, 0xcccccccd00000001,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x5555555455555556, 0xaaaaaaab00000001,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7ffffffc00000006, 0x8000000300000001,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x00000000ffffffff, 0xffffffffffffffff,
  0x7ffffffd00000004, 0x8000000200000001,
  0x7fffffffffffffff, 0x8000000000000000,
  0x00000000ffffffff, 0xffffffffffffffff,
  0x80000002fffffffd, 0x7ffffffeffffffff,
  0x7ffffffe00000002, 0x8000000100000001,
  0xffffffff00000002, 0x0000000100000000,
  0x8000000100000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000100000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x80000001fffffffe, 0x7fffffff00000001,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0xaaaaaaaaaaaaaaac, 0x5555555600000001,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0xcccccccc66666668, 0x3333333400000001,
  0xcccc4ccc66676668, 0x3333b33400000001,
  0xcccbcccd66686666, 0x3334333300000001,
  0xcccb4ccf66696662, 0x3334b33100000001,
  0xffff800000010000, 0x0000800000000001,
  0xffff00010001fffe, 0x0000ffff00000001,
  0xfffe80030002fffa, 0x00017ffd00000001,
  0xfffe00060003fff4, 0x0001fffa00000001,
  0xffff80010000fffe, 0x00007fff00000001,
  0xffff00030001fffa, 0x0000fffd00000001,
  0xfffe80060002fff4, 0x00017ffa00000001,
  0xfffe7f86000300f4, 0x0001807a00000001,
  0xffff80020000fffc, 0x00007ffe00000001,
  0xffff00050001fff6, 0x0000fffb00000001,
  0xfffeff85000200f6, 0x0001007b00000001,
  0xfffeff06000201f4, 0x000100fa00000001,
  0xffff80030000fffa, 0x00007ffd00000001,
  0xffff7f83000100fa, 0x0000807d00000001,
  0xffff7f04000101f8, 0x000080fc00000001,
  0xffff7e86000102f4, 0x0000817a00000001,
  0xffffff8000000100, 0x0000008000000001,
  0xffffff01000001fe, 0x000000ff00000001,
  0xfffffe83000002fa, 0x0000017d00000001,
  0xfffffe06000003f4, 0x000001fa00000001,
  0xffffff81000000fe, 0x0000007f00000001,
  0xffffff03000001fa, 0x000000fd00000001,
  0xfffffe86000002f4, 0x0000017a00000001,
  0xfffffe6600000334, 0x0000019a00000001,
  0xffffff82000000fc, 0x0000007e00000001,
  0xffffff05000001f6, 0x000000fb00000001,
  0xfffffee500000236, 0x0000011b00000001,
  0xfffffee20000023c, 0x0000011e00000001,
  0xffffff83000000fa, 0x0000007d00000001,
  0xffffff630000013a, 0x0000009d00000001,
  0xffffff6000000140, 0x000000a000000001,
  0xffffff5e00000144, 0x000000a200000001,
  0xffffffe000000040, 0x0000002000000001,
  0xffffffdd00000046, 0x0000002300000001,
  0xffffffdb0000004a, 0x0000002500000001,
  0xffffffda0000004c, 0x0000002600000001,
  0x0000000300000000, 0x00000002fffffffb,
  0x0000000500000000, 0x00000004fffffff7,
  0x0000000600000000, 0x00000005fffffff5,
  0x0000000600000000, 0x00000005fffffff5,
  0x0000000200000000, 0x00000001fffffffd,
  0x0000000300000000, 0x00000002fffffffb,
  0x0000000300000000, 0x00000002fffffffb,
  0x0000000200000000, 0x00000001fffffffd,
  0x0000000100000000, 0x00000000ffffffff,
  0x0000000100000000, 0x00000000ffffffff,
  0x0000000000000000, 0x0000000000000001,
  0xfffffffe00000000, 0xfffffffe00000005,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff00000000, 0xffffffff00000003,
  0xfffffffd00000000, 0xfffffffd00000007,
  0xffffffdd00000000, 0xffffffdd00000047,
  0xffffffff00000000, 0xffffffff00000003,
  0xfffffffd00000000, 0xfffffffd00000007,
  0xffffffdd00000000, 0xffffffdd00000047,
  0xffffff6000000000, 0xffffff6000000141,
  0xfffffffe00000000, 0xfffffffe00000005,
  0xffffffde00000000, 0xffffffde00000045,
  0xffffff6100000000, 0xffffff610000013f,
  0xfffffee300000000, 0xfffffee30000023b,
  0xffffffe000000000, 0xffffffe000000041,
  0xffffff6300000000, 0xffffff630000013b,
  0xfffffee500000000, 0xfffffee500000237,
  0xfffffe6600000000, 0xfffffe6600000335,
  0xffffff8300000000, 0xffffff83000000fb,
  0xffffff0500000000, 0xffffff05000001f7,
  0xfffffe8600000000, 0xfffffe86000002f5,
  0xffff7e8900000000, 0xffff7e89000102ef,
  0xffffff8200000000, 0xffffff82000000fd,
  0xffffff0300000000, 0xffffff03000001fb,
  0xffff7f0600000000, 0xffff7f06000101f5,
  0xfffeff0800000000, 0xfffeff08000201f1,
  0xffffff8100000000, 0xffffff81000000ff,
  0xffff7f8400000000, 0xffff7f84000100f9,
  0xfffeff8600000000, 0xfffeff86000200f5,
  0xfffe7f8700000000, 0xfffe7f87000300f3,
  0xffff800300000000, 0xffff80030000fffb,
  0xffff000500000000, 0xffff00050001fff7,
  0xfffe800600000000, 0xfffe80060002fff5,
  0xcccb4cd300000000, 0xcccb4cd36669665b,
  0xffff800200000000, 0xffff80020000fffd,
  0xffff000300000000, 0xffff00030001fffb,
  0xcccbccd000000000, 0xcccbccd066686661,
  0x8000000000000000, 0x8000000000000000,
  0xffff800100000000, 0xffff80010000ffff,
  0xcccc4cce00000000, 0xcccc4cce66676665,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xcccccccd00000000, 0xcccccccd66666667,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xaaaaaaab00000000, 0xaaaaaaabaaaaaaab,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000300000000, 0x80000003fffffffb,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffffffffffffffff, 0xffffffff00000000,
  0x8000000200000000, 0x80000002fffffffd,
  0x8000000000000000, 0x8000000000000000,
  0xffffffffffffffff, 0xffffffff00000000,
  0x7ffffffeffffffff, 0x7ffffffd00000002,
  0x8000000100000000, 0x80000001ffffffff,
  0x00000000ffffffff, 0x00000000ffffffff,
  0x7fffffffffffffff, 0x7fffffff00000001,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffff00000001,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffff00000000, 0x7ffffffe00000003,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x5555555600000000, 0x5555555555555555,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x3333333400000000, 0x3333333399999999,
  0x3333b33400000000, 0x3333b33399989999,
  0x3334333300000000, 0x333433329997999b,
  0x3334b33100000000, 0x3334b3309996999f,
  0x0000800000000000, 0x00007fffffff0001,
  0x0000ffff00000000, 0x0000fffefffe0003,
  0x00017ffd00000000, 0x00017ffcfffd0007,
  0x0001fffa00000000, 0x0001fff9fffc000d,
  0x00007fff00000000, 0x00007ffeffff0003,
  0x0000fffd00000000, 0x0000fffcfffe0007,
  0x00017ffa00000000, 0x00017ff9fffd000d,
  0x0001807a00000000, 0x00018079fffcff0d,
  0x00007ffe00000000, 0x00007ffdffff0005,
  0x0000fffb00000000, 0x0000fffafffe000b,
  0x0001007b00000000, 0x0001007afffdff0b,
  0x000100fa00000000, 0x000100f9fffdfe0d,
  0x00007ffd00000000, 0x00007ffcffff0007,
  0x0000807d00000000, 0x0000807cfffeff07,
  0x000080fc00000000, 0x000080fbfffefe09,
  0x0000817a00000000, 0x00008179fffefd0d,
  0x0000008000000000, 0x0000007fffffff01,
  0x000000ff00000000, 0x000000fefffffe03,
  0x0000017d00000000, 0x0000017cfffffd07,
  0x000001fa00000000, 0x000001f9fffffc0d,
  0x0000007f00000000, 0x0000007effffff03,
  0x000000fd00000000, 0x000000fcfffffe07,
  0x0000017a00000000, 0x00000179fffffd0d,
  0x0000019a00000000, 0x00000199fffffccd,
  0x0000007e00000000, 0x0000007dffffff05,
  0x000000fb00000000, 0x000000fafffffe0b,
  0x0000011b00000000, 0x0000011afffffdcb,
  0x0000011e00000000, 0x0000011dfffffdc5,
  0x0000007d00000000, 0x0000007cffffff07,
  0x0000009d00000000, 0x0000009cfffffec7,
  0x000000a000000000, 0x0000009ffffffec1,
  0x000000a200000000, 0x000000a1fffffebd,
  0x0000002000000000, 0x0000001fffffffc1,
  0x0000002300000000, 0x00000022ffffffbb,
  0x0000002500000000, 0x00000024ffffffb7,
  0x0000002600000000, 0x00000025ffffffb5,
  0x00000002fffffffa, 0x0000000200000005,
  0x00000004fffffff6, 0x000000035555555d,
  0x00000005fffffff4, 0x0000000400000009,
  0x00000005fffffff4, 0x0000000400000009,
  0x00000001fffffffc, 0x0000000155555559,
  0x00000002fffffffa, 0x0000000200000005,
  0x00000002fffffffa, 0x0000000200000005,
  0x00000001fffffffc, 0x0000000155555559,
  0x00000000fffffffe, 0x00000000aaaaaaad,
  0x00000000fffffffe, 0x00000000aaaaaaad,
  0x0000000000000000, 0x0000000000000001,
  0xfffffffe00000004, 0xfffffffeaaaaaaa9,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff00000002, 0xffffffff55555555,
  0xfffffffd00000006, 0xfffffffdfffffffd,
  0xffffffdd00000046, 0xffffffe8aaaaaa7d,
  0xffffffff00000002, 0xffffffff55555555,
  0xfffffffd00000006, 0xfffffffdfffffffd,
  0xffffffdd00000046, 0xffffffe8aaaaaa7d,
  0xffffff6000000140, 0xffffff9555555481,
  0xfffffffe00000004, 0xfffffffeaaaaaaa9,
  0xffffffde00000044, 0xffffffe955555529,
  0xffffff610000013e, 0xffffff95ffffff2d,
  0xfffffee30000023a, 0xffffff41fffffe85,
  0xffffffe000000040, 0xffffffeaaaaaaa81,
  0xffffff630000013a, 0xffffff9755555485,
  0xfffffee500000236, 0xffffff43555553dd,
  0xfffffe6600000334, 0xfffffeeeaaaaa889,
  0xffffff83000000fa, 0xffffffacaaaaaa05,
  0xffffff05000001f6, 0xffffff58aaaaa95d,
  0xfffffe86000002f4, 0xffffff03fffffe09,
  0xffff7e89000102ee, 0xffffa9b0aaa9fe0d,
  0xffffff82000000fc, 0xffffffabffffff59,
  0xffffff03000001fa, 0xffffff5755555405,
  0xffff7f06000101f4, 0xffffaa03ffff5409,
  0xfffeff08000201f0, 0xffff54affffea961,
  0xffffff81000000fe, 0xffffffab555554ad,
  0xffff7f84000100f8, 0xffffaa57ffff54b1,
  0xfffeff86000200f4, 0xffff5503fffeaa09,
  0xfffe7f87000300f2, 0xfffeffaf555354b5,
  0xffff80030000fffa, 0xffffaaacaaaa0005,
  0xffff00050001fff6, 0xffff5558aaa9555d,
  0xfffe80060002fff4, 0xffff0003fffe0009,
  0xcccb4cd36669665a, 0xdddcdde1bbb9bbc5,
  0xffff80020000fffc, 0xffffaaabffff5559,
  0xffff00030001fffa, 0xffff555755540005,
  0xcccbccd066686660, 0xdddd3335110fbbc1,
  0x8000000000000000, 0xa4f9a4fbf49df4a5,
  0xffff80010000fffe, 0xffffaaab5554aaad,
  0xcccc4cce66676664, 0xdddd888911106669,
  0x8000000000000000, 0xa4f9fa4ff49e9f4d,
  0x8000000000000000, 0x8000000000000000,
  0xcccccccd66666666, 0xddddddddbbbbbbbd,
  0x8000000000000000, 0xa4fa4fa49f49f4a1,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xaaaaaaabaaaaaaaa, 0xc71c71c6e38e38e5,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x80000003fffffffa, 0xaaaaaaac00000005,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xffffffff00000000, 0xd555555600000000,
  0x80000002fffffffc, 0xaaaaaaab55555559,
  0x8000000000000000, 0x8000000000000000,
  0xffffffff00000000, 0xd555555600000000,
  0x7ffffffd00000002, 0x2aaaaaab55555554,
  0x80000001fffffffe, 0xaaaaaaaaaaaaaaad,
  0x00000000fffffffe, 0x00000000aaaaaaad,
  0x7fffffff00000000, 0x5555555600000001,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffff00000000, 0x5555555600000001,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7ffffffe00000002, 0x5555555555555555,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x5555555555555554, 0x38e38e39c71c71c9,
  0x7fffffffffffffff, 0x5b05b05cb60b60b9,
  0x7fffffffffffffff, 0x5b0605b20b6160b9,
  0x7fffffffffffffff, 0x5b065b06b60cb60d,
  0x3333333399999998, 0x22222222eeeeeef1,
  0x3333b33399989998, 0x222277784444eef1,
  0x333433329997999a, 0x2222cccceef04445,
  0x3334b3309996999e, 0x22232220eef0eeed,
  0x00007fffffff0000, 0x0000555555560001,
  0x0000fffefffe0002, 0x0000aaaa00015555,
  0x00017ffcfffd0006, 0x0000fffe0001fffd,
  0x0001fff9fffc000c, 0x000155515557fff9,
  0x00007ffeffff0002, 0x00005554aaab5555,
  0x0000fffcfffe0006, 0x0000aaa8aaabfffd,
  0x00017ff9fffd000c, 0x0000fffc0001fff9,
  0x00018079fffcff0c, 0x00010051555755f9,
  0x00007ffdffff0004, 0x000055540000aaa9,
  0x0000fffafffe000a, 0x0000aaa75556aaa5,
  0x0001007afffdff0a, 0x0000aafcaaac00a5,
  0x000100f9fffdfe0c, 0x0000ab515556abf9,
  0x00007ffcffff0006, 0x000055535555fffd,
  0x0000807cfffeff06, 0x000055a8aaab55fd,
  0x000080fbfffefe08, 0x000055fd55560151,
  0x00008179fffefd0c, 0x00005651555601f9,
  0x0000007fffffff00, 0x0000005555555601,
  0x000000fefffffe02, 0x000000aa00000155,
  0x0000017cfffffd06, 0x000000fe000001fd,
  0x000001f9fffffc0c, 0x00000151555557f9,
  0x0000007effffff02, 0x00000054aaaaab55,
  0x000000fcfffffe06, 0x000000a8aaaaabfd,
  0x00000179fffffd0c, 0x000000fc000001f9,
  0x00000199fffffccc, 0x0000011155555779,
  0x0000007dffffff04, 0x00000054000000a9,
  0x000000fafffffe0a, 0x000000a7555556a5,
  0x0000011afffffdca, 0x000000bcaaaaac25,
  0x0000011dfffffdc4, 0x000000beaaaaac29,
  0x0000007cffffff06, 0x00000053555555fd,
  0x0000009cfffffec6, 0x00000068aaaaab7d,
  0x0000009ffffffec0, 0x0000006aaaaaab81,
  0x000000a1fffffebc, 0x0000006c000000d9,
  0x0000001fffffffc0, 0x0000001555555581,
  0x00000022ffffffba, 0x0000001755555585,
  0x00000024ffffffb6, 0x00000018aaaaaadd,
  0x00000025ffffffb4, 0x0000001955555589,
  0x0000000200000004, 0x0000000133333339,
  0x000000035555555c, 0x0000000200000009,
  0x0000000400000008, 0x0000000266666671,
  0x0000000400000008, 0x0000000266666671,
  0x0000000155555558, 0x00000000ccccccd1,
  0x0000000200000004, 0x0000000133333339,
  0x0000000200000004, 0x0000000133333339,
  0x0000000155555558, 0x00000000ccccccd1,
  0x00000000aaaaaaac, 0x0000000066666669,
  0x00000000aaaaaaac, 0x0000000066666669,
  0x0000000000000000, 0x0000000000000001,
  0xfffffffeaaaaaaa8, 0xffffffff33333331,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff55555554, 0xffffffff99999999,
  0xfffffffdfffffffc, 0xfffffffeccccccc9,
  0xffffffe8aaaaaa7c, 0xfffffff1ffffffc9,
  0xffffffff55555554, 0xffffffff99999999,
  0xfffffffdfffffffc, 0xfffffffeccccccc9,
  0xffffffe8aaaaaa7c, 0xfffffff1ffffffc9,
  0xffffff9555555480, 0xffffffbfffffff01,
  0xfffffffeaaaaaaa8, 0xffffffff33333331,
  0xffffffe955555528, 0xfffffff266666631,
  0xffffff95ffffff2c, 0xffffffc066666569,
  0xffffff41fffffe84, 0xffffff8dfffffe39,
  0xffffffeaaaaaaa80, 0xfffffff333333301,
  0xffffff9755555484, 0xffffffc133333239,
  0xffffff43555553dc, 0xffffff8ecccccb09,
  0xfffffeeeaaaaa888, 0xffffff5bfffffd71,
  0xffffffacaaaaaa04, 0xffffffcdffffff39,
  0xffffff58aaaaa95c, 0xffffff9b99999809,
  0xffffff03fffffe08, 0xffffff68ccccca71,
  0xffffa9b0aaa9fe0c, 0xffffcc36cccbfda9,
  0xffffffabffffff58, 0xffffffcd999998d1,
  0xffffff5755555404, 0xffffff9acccccb39,
  0xffffaa03ffff5408, 0xffffcc68cccbfe71,
  0xffff54affffea960, 0xffff99366664cb41,
  0xffffffab555554ac, 0xffffffcd33333269,
  0xffffaa57ffff54b0, 0xffffcc9b333265a1,
  0xffff5503fffeaa08, 0xffff9968cccb3271,
  0xfffeffaf555354b4, 0xffff6635fffd98d9,
  0xffffaaacaaaa0004, 0xffffcccdffff3339,
  0xffff5558aaa9555c, 0xffff999b99980009,
  0xffff0003fffe0008, 0xffff6668ccca6671,
  0xdddcdde1bbb9bbc4, 0xeb848520e14547b9,
  0xffffaaabffff5558, 0xffffcccd9998ccd1,
  0xffff555755540004, 0xffff999acccb3339,
  0xdddd3335110fbbc0, 0xeb84b852e1461481,
  0xa4f9a4fbf49df4a4, 0xc962963058bd8bf9,
  0xffffaaab5554aaac, 0xffffcccd33326669,
  0xdddd888911106668, 0xeb84eb8547ad47b1,
  0xa4f9fa4ff49e9f4c, 0xc962c962bf24bf29,
  0x8000000000000000, 0x962f962ff257f261,
  0xddddddddbbbbbbbc, 0xeb851eb8147ae149,
  0xa4fa4fa49f49f4a0, 0xc962fc958bf258c1,
  0x8000000000000000, 0x962fc962bf258bf9,
  0x8000000000000000, 0x8000000000000000,
  0xc71c71c6e38e38e4, 0xdddddddd77777779,
  0x8000000000000000, 0xaaaaaaaaaaaaaab1,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xaaaaaaac00000004, 0xcccccccd33333339,
  0x8000000000000000, 0x9999999a00000009,
  0x8000000000000000, 0x8000000000000000,
  0xd555555600000000, 0xb333333400000000,
  0xaaaaaaab55555558, 0xccccccccccccccd1,
  0x8000000000000000, 0x9999999933333339,
  0xd555555600000000, 0xcccccccd33333339,
  0x2aaaaaab55555554, 0x00000000ccccccd1,
  0xaaaaaaaaaaaaaaac, 0xcccccccc66666669,
  0x00000000aaaaaaac, 0x0000000066666669,
  0x5555555600000000, 0x3333333400000001,
  0x7fffffffffffffff, 0x55555556eeeeeef1,
  0x5555555600000000, 0x3333333400000001,
  0x7fffffffffffffff, 0x6666666799999999,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x5555555555555554, 0x3333333399999999,
  0x7fffffffffffffff, 0x5555555688888889,
  0x7fffffffffffffff, 0x69d0369eda740da9,
  0x7fffffffffffffff, 0x69d069d20da80da9,
  0x38e38e39c71c71c8, 0x22222222eeeeeef1,
  0x5b05b05cb60b60b8, 0x369d036b40da7411,
  0x5b0605b20b6160b8, 0x369d369e740e7411,
  0x5b065b06b60cb60c, 0x369d69d140dc0da9,
  0x22222222eeeeeef0, 0x147ae14851eb8521,
  0x222277784444eef0, 0x147b147b851f8521,
  0x2222cccceef04444, 0x147b47ae51ed1eb9,
  0x22232220eef0eeec, 0x147b7ae0b85451e9,
  0x0000555555560000, 0x0000333333340001,
  0x0000aaaa00015554, 0x0000666600019999,
  0x0000fffe0001fffc, 0x000099986668ccc9,
  0x000155515557fff8, 0x0000ccca66699991,
  0x00005554aaab5554, 0x00003332cccd9999,
  0x0000aaa8aaabfffc, 0x000066653334ccc9,
  0x0000fffc0001fff8, 0x0000999733359991,
  0x00010051555755f8, 0x000099ca6668cd91,
  0x000055540000aaa8, 0x0000333266673331,
  0x0000aaa75556aaa4, 0x000066646667fff9,
  0x0000aafcaaac00a4, 0x00006697999b33f9,
  0x0000ab515556abf8, 0x000066ca66680191,
  0x000055535555fffc, 0x000033320000ccc9,
  0x000055a8aaab55fc, 0x00003365333400c9,
  0x000055fd55560150, 0x000033980000ce61,
  0x00005651555601f8, 0x000033ca66673591,
  0x0000005555555600, 0x0000003333333401,
  0x000000aa00000154, 0x0000006600000199,
  0x000000fe000001fc, 0x00000098666668c9,
  0x00000151555557f8, 0x000000ca66666991,
  0x00000054aaaaab54, 0x00000032cccccd99,
  0x000000a8aaaaabfc, 0x00000065333334c9,
  0x000000fc000001f8, 0x0000009733333591,
  0x0000011155555778, 0x000000a400000291,
  0x00000054000000a8, 0x0000003266666731,
  0x000000a7555556a4, 0x00000064666667f9,
  0x000000bcaaaaac24, 0x00000071333334f9,
  0x000000beaaaaac28, 0x0000007266666831,
  0x00000053555555fc, 0x00000032000000c9,
  0x00000068aaaaab7c, 0x0000003ecccccdc9,
  0x0000006aaaaaab80, 0x0000004000000101,
  0x0000006c000000d8, 0x00000040cccccdd1,
  0x0000001555555580, 0x0000000ccccccd01,
  0x0000001755555584, 0x0000000e00000039,
  0x00000018aaaaaadc, 0x0000000ecccccd09,
  0x0000001955555588, 0x0000000f33333371,
  0x0000000133333338, 0x0000000000030001,
  0x0000000200000008, 0x0000000000050001,
  0x0000000266666670, 0x0000000000060001,
  0x0000000266666670, 0x0000000000060001,
  0x00000000ccccccd0, 0x0000000000020001,
  0x0000000133333338, 0x0000000000030001,
  0x0000000133333338, 0x0000000000030001,
  0x00000000ccccccd0, 0x0000000000020001,
  0x0000000066666668, 0x0000000000010001,
  0x0000000066666668, 0x0000000000010001,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff33333330, 0xfffffffffffe0001,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff99999998, 0xffffffffffff0001,
  0xfffffffeccccccc8, 0xfffffffffffd0001,
  0xfffffff1ffffffc8, 0xffffffffffdd0001,
  0xffffffff99999998, 0xffffffffffff0001,
  0xfffffffeccccccc8, 0xfffffffffffd0001,
  0xfffffff1ffffffc8, 0xffffffffffdd0001,
  0xffffffbfffffff00, 0xffffffffff600001,
  0xffffffff33333330, 0xfffffffffffe0001,
  0xfffffff266666630, 0xffffffffffde0001,
  0xffffffc066666568, 0xffffffffff610001,
  0xffffff8dfffffe38, 0xfffffffffee30001,
  0xfffffff333333300, 0xffffffffffe00001,
  0xffffffc133333238, 0xffffffffff630001,
  0xffffff8ecccccb08, 0xfffffffffee50001,
  0xffffff5bfffffd70, 0xfffffffffe660001,
  0xffffffcdffffff38, 0xffffffffff830001,
  0xffffff9b99999808, 0xffffffffff050001,
  0xffffff68ccccca70, 0xfffffffffe860001,
  0xffffcc36cccbfda8, 0xffffffff7e890001,
  0xffffffcd999998d0, 0xffffffffff820001,
  0xffffff9acccccb38, 0xffffffffff030001,
  0xffffcc68cccbfe70, 0xffffffff7f060001,
  0xffff99366664cb40, 0xfffffffeff080001,
  0xffffffcd33333268, 0xffffffffff810001,
  0xffffcc9b333265a0, 0xffffffff7f840001,
  0xffff9968cccb3270, 0xfffffffeff860001,
  0xffff6635fffd98d8, 0xfffffffe7f870001,
  0xffffcccdffff3338, 0xffffffff80030001,
  0xffff999b99980008, 0xffffffff00050001,
  0xffff6668ccca6670, 0xfffffffe80060001,
  0xeb848520e14547b8, 0xffffcccb4cd30001,
  0xffffcccd9998ccd0, 0xffffffff80020001,
  0xffff999acccb3338, 0xffffffff00030001,
  0xeb84b852e1461480, 0xffffcccbccd00001,
  0xc962963058bd8bf8, 0xffff7776777b0001,
  0xffffcccd33326668, 0xffffffff80010001,
  0xeb84eb8547ad47b0, 0xffffcccc4cce0001,
  0xc962c962bf24bf28, 0xffff7776f7790001,
  0x962f962ff257f260, 0xfffef776f77c0001,
  0xeb851eb8147ae148, 0xffffcccccccd0001,
  0xc962fc958bf258c0, 0xffff777777780001,
  0x962fc962bf258bf8, 0xfffef777777b0001,
  0x8000000000000000, 0xfffe7777777d0001,
  0xdddddddd77777778, 0xffffaaaaaaab0001,
  0xaaaaaaaaaaaaaab0, 0xffff2aaaaaae0001,
  0x8000000000000000, 0xfffeaaaaaab00001,
  0x8000000000000000, 0xfffe2aaaaab10001,
  0xcccccccd33333338, 0xffff800000030001,
  0x9999999a00000008, 0xffff000000050001,
  0x8000000000000000, 0xfffe800000060001,
  0xb333333400000000, 0xffff000000060001,
  0xccccccccccccccd0, 0xffff800000020001,
  0x9999999933333338, 0xffff000000030001,
  0xcccccccd33333338, 0xffff800000030001,
  0x00000000ccccccd0, 0x0000000000020001,
  0xcccccccc66666668, 0xffff800000010001,
  0x0000000066666668, 0x0000000000010001,
  0x3333333400000000, 0x0000800000000001,
  0x55555556eeeeeef0, 0x0000d55555560001,
  0x3333333400000000, 0x0000800000000001,
  0x6666666799999998, 0x0000ffffffff0001,
  0x7fffffffffffffff, 0x0001555555550001,
  0x7fffffffffffffff, 0x0001888888890001,
  0x3333333399999998, 0x00007fffffff0001,
  0x5555555688888888, 0x0000d55555550001,
  0x69d0369eda740da8, 0x0001088888890001,
  0x69d069d20da80da8, 0x0001088908890001,
  0x22222222eeeeeef0, 0x0000555555560001,
  0x369d036b40da7410, 0x00008888888a0001,
  0x369d369e740e7410, 0x00008889088a0001,
  0x369d69d140dc0da8, 0x0000888988890001,
  0x147ae14851eb8520, 0x0000333333340001,
  0x147b147b851f8520, 0x00003333b3340001,
  0x147b47ae51ed1eb8, 0x0000333433330001,
  0x147b7ae0b85451e8, 0x00003334b3310001,
  0x0000333333340000, 0x0000000080000001,
  0x0000666600019998, 0x00000000ffff0001,
  0x000099986668ccc8, 0x000000017ffd0001,
  0x0000ccca66699990, 0x00000001fffa0001,
  0x00003332cccd9998, 0x000000007fff0001,
  0x000066653334ccc8, 0x00000000fffd0001,
  0x0000999733359990, 0x000000017ffa0001,
  0x000099ca6668cd90, 0x00000001807a0001,
  0x0000333266673330, 0x000000007ffe0001,
  0x000066646667fff8, 0x00000000fffb0001,
  0x00006697999b33f8, 0x00000001007b0001,
  0x000066ca66680190, 0x0000000100fa0001,
  0x000033320000ccc8, 0x000000007ffd0001,
  0x00003365333400c8, 0x00000000807d0001,
  0x000033980000ce60, 0x0000000080fc0001,
  0x000033ca66673590, 0x00000000817a0001,
  0x0000003333333400, 0x0000000000800001,
  0x0000006600000198, 0x0000000000ff0001,
  0x00000098666668c8, 0x00000000017d0001,
  0x000000ca66666990, 0x0000000001fa0001,
  0x00000032cccccd98, 0x00000000007f0001,
  0x00000065333334c8, 0x0000000000fd0001,
  0x0000009733333590, 0x00000000017a0001,
  0x000000a400000290, 0x00000000019a0001,
  0x0000003266666730, 0x00000000007e0001,
  0x00000064666667f8, 0x0000000000fb0001,
  0x00000071333334f8, 0x00000000011b0001,
  0x0000007266666830, 0x00000000011e0001,
  0x00000032000000c8, 0x00000000007d0001,
  0x0000003ecccccdc8, 0x00000000009d0001,
  0x0000004000000100, 0x0000000000a00001,
  0x00000040cccccdd0, 0x0000000000a20001,
  0x0000000ccccccd00, 0x0000000000200001,
  0x0000000e00000038, 0x0000000000230001,
  0x0000000ecccccd08, 0x0000000000250001,
  0x0000000f33333370, 0x0000000000260001,
  0x0000000000030000, 0x000000000002fffb,
  0x0000000000050000, 0x000000000004fff7,
  0x0000000000060000, 0x000000000005fff5,
  0x0000000000060000, 0x000000000005fff5,
  0x0000000000020000, 0x000000000001fffd,
  0x0000000000030000, 0x000000000002fffb,
  0x0000000000030000, 0x000000000002fffb,
  0x0000000000020000, 0x000000000001fffd,
  0x0000000000010000, 0x000000000000ffff,
  0x0000000000010000, 0x000000000000ffff,
  0x0000000000000000, 0x0000000000000001,
  0xfffffffffffe0000, 0xfffffffffffe0005,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffff0000, 0xffffffffffff0003,
  0xfffffffffffd0000, 0xfffffffffffd0007,
  0xffffffffffdd0000, 0xffffffffffdd0047,
  0xffffffffffff0000, 0xffffffffffff0003,
  0xfffffffffffd0000, 0xfffffffffffd0007,
  0xffffffffffdd0000, 0xffffffffffdd0047,
  0xffffffffff600000, 0xffffffffff600141,
  0xfffffffffffe0000, 0xfffffffffffe0005,
  0xffffffffffde0000, 0xffffffffffde0045,
  0xffffffffff610000, 0xffffffffff61013f,
  0xfffffffffee30000, 0xfffffffffee3023b,
  0xffffffffffe00000, 0xffffffffffe00041,
  0xffffffffff630000, 0xffffffffff63013b,
  0xfffffffffee50000, 0xfffffffffee50237,
  0xfffffffffe660000, 0xfffffffffe660335,
  0xffffffffff830000, 0xffffffffff8300fb,
  0xffffffffff050000, 0xffffffffff0501f7,
  0xfffffffffe860000, 0xfffffffffe8602f5,
  0xffffffff7e890000, 0xffffffff7e8a02ef,
  0xffffffffff820000, 0xffffffffff8200fd,
  0xffffffffff030000, 0xffffffffff0301fb,
  0xffffffff7f060000, 0xffffffff7f0701f5,
  0xfffffffeff080000, 0xfffffffeff0a01f1,
  0xffffffffff810000, 0xffffffffff8100ff,
  0xffffffff7f840000, 0xffffffff7f8500f9,
  0xfffffffeff860000, 0xfffffffeff8800f5,
  0xfffffffe7f870000, 0xfffffffe7f8a00f3,
  0xffffffff80030000, 0xffffffff8003fffb,
  0xffffffff00050000, 0xffffffff0006fff7,
  0xfffffffe80060000, 0xfffffffe8008fff5,
  0xffffcccb4cd30000, 0xffffcccbb33c665b,
  0xffffffff80020000, 0xffffffff8002fffd,
  0xffffffff00030000, 0xffffffff0004fffb,
  0xffffcccbccd00000, 0xffffcccc33386661,
  0xffff7776777b0000, 0xffff7777888e110b,
  0xffffffff80010000, 0xffffffff8001ffff,
  0xffffcccc4cce0000, 0xffffccccb3356665,
  0xffff7776f7790000, 0xffff7778088b110f,
  0xfffef776f77c0000, 0xfffef779088e1109,
  0xffffcccccccd0000, 0xffffcccd33336667,
  0xffff777777780000, 0xffff777888891111,
  0xfffef777777b0000, 0xfffef779888c110b,
  0xfffe7777777d0000, 0xfffe777a888e1107,
  0xffffaaaaaaab0000, 0xffffaaab5555aaab,
  0xffff2aaaaaae0000, 0xffff2aac5558aaa5,
  0xfffeaaaaaab00000, 0xfffeaaad555aaaa1,
  0xfffe2aaaaab10000, 0xfffe2aae555baa9f,
  0xffff800000030000, 0xffff80010002fffb,
  0xffff000000050000, 0xffff00020004fff7,
  0xfffe800000060000, 0xfffe80030005fff5,
  0xffff000000060000, 0xffff00020005fff5,
  0xffff800000020000, 0xffff80010001fffd,
  0xffff000000030000, 0xffff00020002fffb,
  0xffff800000030000, 0xffff80010002fffb,
  0x0000000000020000, 0x000000000001fffd,
  0xffff800000010000, 0xffff80010000ffff,
  0x0000000000010000, 0x000000000000ffff,
  0x0000800000000000, 0x00007fff00000001,
  0x0000d55555560000, 0x0000d553aaab5555,
  0x0000800000000000, 0x00007fff00000001,
  0x0000ffffffff0000, 0x0000fffdffff0003,
  0x0001555555550000, 0x00015552aaaa5557,
  0x0001888888890000, 0x000188857777eeef,
  0x00007fffffff0000, 0x00007ffeffff0003,
  0x0000d55555550000, 0x0000d553aaaa5557,
  0x0001088888890000, 0x000108867777eeef,
  0x0001088908890000, 0x00010886f776eeef,
  0x0000555555560000, 0x00005554aaab5555,
  0x00008888888a0000, 0x000088877778eeed,
  0x00008889088a0000, 0x00008887f777eeed,
  0x0000888988890000, 0x000088887775eeef,
  0x0000333333340000, 0x00003332cccd9999,
  0x00003333b3340000, 0x000033334ccc9999,
  0x0000333433330000, 0x00003333ccca999b,
  0x00003334b3310000, 0x000033344cc7999f,
  0x0000000080000000, 0x000000007fff0001,
  0x00000000ffff0000, 0x00000000fffd0003,
  0x000000017ffd0000, 0x000000017ffa0007,
  0x00000001fffa0000, 0x00000001fff6000d,
  0x000000007fff0000, 0x000000007ffe0003,
  0x00000000fffd0000, 0x00000000fffb0007,
  0x000000017ffa0000, 0x000000017ff7000d,
  0x00000001807a0000, 0x000000018076ff0d,
  0x000000007ffe0000, 0x000000007ffd0005,
  0x00000000fffb0000, 0x00000000fff9000b,
  0x00000001007b0000, 0x000000010078ff0b,
  0x0000000100fa0000, 0x0000000100f7fe0d,
  0x000000007ffd0000, 0x000000007ffc0007,
  0x00000000807d0000, 0x00000000807bff07,
  0x0000000080fc0000, 0x0000000080fafe09,
  0x00000000817a0000, 0x000000008178fd0d,
  0x0000000000800000, 0x00000000007fff01,
  0x0000000000ff0000, 0x0000000000fefe03,
  0x00000000017d0000, 0x00000000017cfd07,
  0x0000000001fa0000, 0x0000000001f9fc0d,
  0x00000000007f0000, 0x00000000007eff03,
  0x0000000000fd0000, 0x0000000000fcfe07,
  0x00000000017a0000, 0x000000000179fd0d,
  0x00000000019a0000, 0x000000000199fccd,
  0x00000000007e0000, 0x00000000007dff05,
  0x0000000000fb0000, 0x0000000000fafe0b,
  0x00000000011b0000, 0x00000000011afdcb,
  0x00000000011e0000, 0x00000000011dfdc5,
  0x00000000007d0000, 0x00000000007cff07,
  0x00000000009d0000, 0x00000000009cfec7,
  0x0000000000a00000, 0x00000000009ffec1,
  0x0000000000a20000, 0x0000000000a1febd,
  0x0000000000200000, 0x00000000001fffc1,
  0x0000000000230000, 0x000000000022ffbb,
  0x0000000000250000, 0x000000000024ffb7,
  0x0000000000260000, 0x000000000025ffb5,
  0x000000000002fffa, 0x000000000002fff5,
  0x000000000004fff6, 0x000000000004ffed,
  0x000000000005fff4, 0x000000000005ffe9,
  0x000000000005fff4, 0x000000000005ffe9,
  0x000000000001fffc, 0x000000000001fff9,
  0x000000000002fffa, 0x000000000002fff5,
  0x000000000002fffa, 0x000000000002fff5,
  0x000000000001fffc, 0x000000000001fff9,
  0x000000000000fffe, 0x000000000000fffd,
  0x000000000000fffe, 0x000000000000fffd,
  0x0000000000000000, 0x0000000000000001,
  0xfffffffffffe0004, 0xfffffffffffe0009,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffff0002, 0xffffffffffff0005,
  0xfffffffffffd0006, 0xfffffffffffd000d,
  0xffffffffffdd0046, 0xffffffffffdd008d,
  0xffffffffffff0002, 0xffffffffffff0005,
  0xfffffffffffd0006, 0xfffffffffffd000d,
  0xffffffffffdd0046, 0xffffffffffdd008d,
  0xffffffffff600140, 0xffffffffff600281,
  0xfffffffffffe0004, 0xfffffffffffe0009,
  0xffffffffffde0044, 0xffffffffffde0089,
  0xffffffffff61013e, 0xffffffffff61027d,
  0xfffffffffee3023a, 0xfffffffffee30475,
  0xffffffffffe00040, 0xffffffffffe00081,
  0xffffffffff63013a, 0xffffffffff630275,
  0xfffffffffee50236, 0xfffffffffee5046d,
  0xfffffffffe660334, 0xfffffffffe660669,
  0xffffffffff8300fa, 0xffffffffff8301f5,
  0xffffffffff0501f6, 0xffffffffff0503ed,
  0xfffffffffe8602f4, 0xfffffffffe8605e9,
  0xffffffff7e8a02ee, 0xffffffff7e8b05dd,
  0xffffffffff8200fc, 0xffffffffff8201f9,
  0xffffffffff0301fa, 0xffffffffff0303f5,
  0xffffffff7f0701f4, 0xffffffff7f0803e9,
  0xfffffffeff0a01f0, 0xfffffffeff0c03e1,
  0xffffffffff8100fe, 0xffffffffff8101fd,
  0xffffffff7f8500f8, 0xffffffff7f8601f1,
  0xfffffffeff8800f4, 0xfffffffeff8a01e9,
  0xfffffffe7f8a00f2, 0xfffffffe7f8d01e5,
  0xffffffff8003fffa, 0xffffffff8004fff5,
  0xffffffff0006fff6, 0xffffffff0008ffed,
  0xfffffffe8008fff4, 0xfffffffe800bffe9,
  0xffffcccbb33c665a, 0xffffcccc19a5ccb5,
  0xffffffff8002fffc, 0xffffffff8003fff9,
  0xffffffff0004fffa, 0xffffffff0006fff5,
  0xffffcccc33386660, 0xffffcccc99a0ccc1,
  0xffff7777888e110a, 0xffff777899a12215,
  0xffffffff8001fffe, 0xffffffff8002fffd,
  0xffffccccb3356664, 0xffffcccd199cccc9,
  0xffff7778088b110e, 0xffff7779199d221d,
  0xfffef779088e1108, 0xfffef77b19a02211,
  0xffffcccd33336666, 0xffffcccd9999cccd,
  0xffff777888891110, 0xffff7779999a2221,
  0xfffef779888c110a, 0xfffef77b999d2215,
  0xfffe777a888e1106, 0xfffe777d999f220d,
  0xffffaaab5555aaaa, 0xffffaaac00005555,
  0xffff2aac5558aaa4, 0xffff2aae00035549,
  0xfffeaaad555aaaa0, 0xfffeaab000055541,
  0xfffe2aae555baa9e, 0xfffe2ab20006553d,
  0xffff80010002fffa, 0xffff80020002fff5,
  0xffff00020004fff6, 0xffff00040004ffed,
  0xfffe80030005fff4, 0xfffe80060005ffe9,
  0xffff00020005fff4, 0xffff00040005ffe9,
  0xffff80010001fffc, 0xffff80020001fff9,
  0xffff00020002fffa, 0xffff00040002fff5,
  0xffff80010002fffa, 0xffff80020002fff5,
  0x000000000001fffc, 0x000000000001fff9,
  0xffff80010000fffe, 0xffff80020000fffd,
  0x000000000000fffe, 0x000000000000fffd,
  0x00007fff00000000, 0x00007ffe00000001,
  0x0000d553aaab5554, 0x0000d5520000aaa9,
  0x00007fff00000000, 0x00007ffe00000001,
  0x0000fffdffff0002, 0x0000fffbffff0005,
  0x00015552aaaa5556, 0x0001554fffffaaad,
  0x000188857777eeee, 0x000188826666dddd,
  0x00007ffeffff0002, 0x00007ffdffff0005,
  0x0000d553aaaa5556, 0x0000d551ffffaaad,
  0x000108867777eeee, 0x000108846666dddd,
  0x00010886f776eeee, 0x00010884e664dddd,
  0x00005554aaab5554, 0x000055540000aaa9,
  0x000088877778eeec, 0x000088866667ddd9,
  0x00008887f777eeec, 0x00008886e665ddd9,
  0x000088887775eeee, 0x000088876662dddd,
  0x00003332cccd9998, 0x0000333266673331,
  0x000033334ccc9998, 0x00003332e6653331,
  0x00003333ccca999a, 0x0000333366623335,
  0x000033344cc7999e, 0x00003333e65e333d,
  0x000000007fff0000, 0x000000007ffe0001,
  0x00000000fffd0002, 0x00000000fffb0005,
  0x000000017ffa0006, 0x000000017ff7000d,
  0x00000001fff6000c, 0x00000001fff20019,
  0x000000007ffe0002, 0x000000007ffd0005,
  0x00000000fffb0006, 0x00000000fff9000d,
  0x000000017ff7000c, 0x000000017ff40019,
  0x000000018076ff0c, 0x000000018073fe19,
  0x000000007ffd0004, 0x000000007ffc0009,
  0x00000000fff9000a, 0x00000000fff70015,
  0x000000010078ff0a, 0x000000010076fe15,
  0x0000000100f7fe0c, 0x0000000100f5fc19,
  0x000000007ffc0006, 0x000000007ffb000d,
  0x00000000807bff06, 0x00000000807afe0d,
  0x0000000080fafe08, 0x0000000080f9fc11,
  0x000000008178fd0c, 0x000000008177fa19,
  0x00000000007fff00, 0x00000000007ffe01,
  0x0000000000fefe02, 0x0000000000fefc05,
  0x00000000017cfd06, 0x00000000017cfa0d,
  0x0000000001f9fc0c, 0x0000000001f9f819,
  0x00000000007eff02, 0x00000000007efe05,
  0x0000000000fcfe06, 0x0000000000fcfc0d,
  0x000000000179fd0c, 0x000000000179fa19,
  0x000000000199fccc, 0x000000000199f999,
  0x00000000007dff04, 0x00000000007dfe09,
  0x0000000000fafe0a, 0x0000000000fafc15,
  0x00000000011afdca, 0x00000000011afb95,
  0x00000000011dfdc4, 0x00000000011dfb89,
  0x00000000007cff06, 0x00000000007cfe0d,
  0x00000000009cfec6, 0x00000000009cfd8d,
  0x00000000009ffec0, 0x00000000009ffd81,
  0x0000000000a1febc, 0x0000000000a1fd79,
  0x00000000001fffc0, 0x00000000001fff81,
  0x000000000022ffba, 0x000000000022ff75,
  0x000000000024ffb6, 0x000000000024ff6d,
  0x000000000025ffb4, 0x000000000025ff69,
  0x000000000002fff4, 0x000000000002ffef,
  0x000000000004ffec, 0x000000000004ffe3,
  0x000000000005ffe8, 0x000000000005ffdd,
  0x000000000005ffe8, 0x000000000005ffdd,
  0x000000000001fff8, 0x000000000001fff5,
  0x000000000002fff4, 0x000000000002ffef,
  0x000000000002fff4, 0x000000000002ffef,
  0x000000000001fff8, 0x000000000001fff5,
  0x000000000000fffc, 0x000000000000fffb,
  0x000000000000fffc, 0x000000000000fffb,
  0x0000000000000000, 0x0000000000000001,
  0xfffffffffffe0008, 0xfffffffffffe000d,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffff0004, 0xffffffffffff0007,
  0xfffffffffffd000c, 0xfffffffffffd0013,
  0xffffffffffdd008c, 0xffffffffffdd00d3,
  0xffffffffffff0004, 0xffffffffffff0007,
  0xfffffffffffd000c, 0xfffffffffffd0013,
  0xffffffffffdd008c, 0xffffffffffdd00d3,
  0xffffffffff600280, 0xffffffffff6003c1,
  0xfffffffffffe0008, 0xfffffffffffe000d,
  0xffffffffffde0088, 0xffffffffffde00cd,
  0xffffffffff61027c, 0xffffffffff6103bb,
  0xfffffffffee30474, 0xfffffffffee306af,
  0xffffffffffe00080, 0xffffffffffe000c1,
  0xffffffffff630274, 0xffffffffff6303af,
  0xfffffffffee5046c, 0xfffffffffee506a3,
  0xfffffffffe660668, 0xfffffffffe66099d,
  0xffffffffff8301f4, 0xffffffffff8302ef,
  0xffffffffff0503ec, 0xffffffffff0505e3,
  0xfffffffffe8605e8, 0xfffffffffe8608dd,
  0xffffffff7e8b05dc, 0xffffffff7e8c08cb,
  0xffffffffff8201f8, 0xffffffffff8202f5,
  0xffffffffff0303f4, 0xffffffffff0305ef,
  0xffffffff7f0803e8, 0xffffffff7f0905dd,
  0xfffffffeff0c03e0, 0xfffffffeff0e05d1,
  0xffffffffff8101fc, 0xffffffffff8102fb,
  0xffffffff7f8601f0, 0xffffffff7f8702e9,
  0xfffffffeff8a01e8, 0xfffffffeff8c02dd,
  0xfffffffe7f8d01e4, 0xfffffffe7f9002d7,
  0xffffffff8004fff4, 0xffffffff8005ffef,
  0xffffffff0008ffec, 0xffffffff000affe3,
  0xfffffffe800bffe8, 0xfffffffe800effdd,
  0xffffcccc19a5ccb4, 0xffffcccc800f330f,
  0xffffffff8003fff8, 0xffffffff8004fff5,
  0xffffffff0006fff4, 0xffffffff0008ffef,
  0xffffcccc99a0ccc0, 0xffffcccd00093321,
  0xffff777899a12214, 0xffff7779aab4331f,
  0xffffffff8002fffc, 0xffffffff8003fffb,
  0xffffcccd199cccc8, 0xffffcccd8004332d,
  0xffff7779199d221c, 0xffff777a2aaf332b,
  0xfffef77b19a02210, 0xfffef77d2ab23319,
  0xffffcccd9999cccc, 0xffffccce00003333,
  0xffff7779999a2220, 0xffff777aaaab3331,
  0xfffef77b999d2214, 0xfffef77daaae331f,
  0xfffe777d999f220c, 0xfffe7780aab03313,
  0xffffaaac00005554, 0xffffaaacaaaaffff,
  0xffff2aae00035548, 0xffff2aafaaadffed,
  0xfffeaab000055540, 0xfffeaab2aaafffe1,
  0xfffe2ab20006553c, 0xfffe2ab5aab0ffdb,
  0xffff80020002fff4, 0xffff80030002ffef,
  0xffff00040004ffec, 0xffff00060004ffe3,
  0xfffe80060005ffe8, 0xfffe80090005ffdd,
  0xffff00040005ffe8, 0xffff00060005ffdd,
  0xffff80020001fff8, 0xffff80030001fff5,
  0xffff00040002fff4, 0xffff00060002ffef,
  0xffff80020002fff4, 0xffff80030002ffef,
  0x000000000001fff8, 0x000000000001fff5,
  0xffff80020000fffc, 0xffff80030000fffb,
  0x000000000000fffc, 0x000000000000fffb,
  0x00007ffe00000000, 0x00007ffd00000001,
  0x0000d5520000aaa8, 0x0000d5505555fffd,
  0x00007ffe00000000, 0x00007ffd00000001,
  0x0000fffbffff0004, 0x0000fff9ffff0007,
  0x0001554fffffaaac, 0x0001554d55550003,
  0x000188826666dddc, 0x0001887f5555cccb,
  0x00007ffdffff0004, 0x00007ffcffff0007,
  0x0000d551ffffaaac, 0x0000d55055550003,
  0x000108846666dddc, 0x000108825555cccb,
  0x00010884e664dddc, 0x00010882d552cccb,
  0x000055540000aaa8, 0x000055535555fffd,
  0x000088866667ddd8, 0x000088855556ccc5,
  0x00008886e665ddd8, 0x00008885d553ccc5,
  0x000088876662dddc, 0x00008886554fcccb,
  0x0000333266673330, 0x000033320000ccc9,
  0x00003332e6653330, 0x000033327ffdccc9,
  0x0000333366623334, 0x00003332fff9cccf,
  0x00003333e65e333c, 0x000033337ff4ccdb,
  0x000000007ffe0000, 0x000000007ffd0001,
  0x00000000fffb0004, 0x00000000fff90007,
  0x000000017ff7000c, 0x000000017ff40013,
  0x00000001fff20018, 0x00000001ffee0025,
  0x000000007ffd0004, 0x000000007ffc0007,
  0x00000000fff9000c, 0x00000000fff70013,
  0x000000017ff40018, 0x000000017ff10025,
  0x000000018073fe18, 0x000000018070fd25,
  0x000000007ffc0008, 0x000000007ffb000d,
  0x00000000fff70014, 0x00000000fff5001f,
  0x000000010076fe14, 0x000000010074fd1f,
  0x0000000100f5fc18, 0x0000000100f3fa25,
  0x000000007ffb000c, 0x000000007ffa0013,
  0x00000000807afe0c, 0x000000008079fd13,
  0x0000000080f9fc10, 0x0000000080f8fa19,
  0x000000008177fa18, 0x000000008176f725,
  0x00000000007ffe00, 0x00000000007ffd01,
  0x0000000000fefc04, 0x0000000000fefa07,
  0x00000000017cfa0c, 0x00000000017cf713,
  0x0000000001f9f818, 0x0000000001f9f425,
  0x00000000007efe04, 0x00000000007efd07,
  0x0000000000fcfc0c, 0x0000000000fcfa13,
  0x000000000179fa18, 0x000000000179f725,
  0x000000000199f998, 0x000000000199f665,
  0x00000000007dfe08, 0x00000000007dfd0d,
  0x0000000000fafc14, 0x0000000000fafa1f,
  0x00000000011afb94, 0x00000000011af95f,
  0x00000000011dfb88, 0x00000000011df94d,
  0x00000000007cfe0c, 0x00000000007cfd13,
  0x00000000009cfd8c, 0x00000000009cfc53,
  0x00000000009ffd80, 0x00000000009ffc41,
  0x0000000000a1fd78, 0x0000000000a1fc35,
  0x00000000001fff80, 0x00000000001fff41,
  0x000000000022ff74, 0x000000000022ff2f,
  0x000000000024ff6c, 0x000000000024ff23,
  0x000000000025ff68, 0x000000000025ff1d,
  0x000000000002ffee, 0x0000000000000301,
  0x000000000004ffe2, 0x0000000000000501,
  0x000000000005ffdc, 0x0000000000000601,
  0x000000000005ffdc, 0x0000000000000601,
  0x000000000001fff4, 0x0000000000000201,
  0x000000000002ffee, 0x0000000000000301,
  0x000000000002ffee, 0x0000000000000301,
  0x000000000001fff4, 0x0000000000000201,
  0x000000000000fffa, 0x0000000000000101,
  0x000000000000fffa, 0x0000000000000101,
  0x0000000000000000, 0x0000000000000001,
  0xfffffffffffe000c, 0xfffffffffffffe01,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffff0006, 0xffffffffffffff01,
  0xfffffffffffd0012, 0xfffffffffffffd01,
  0xffffffffffdd00d2, 0xffffffffffffdd01,
  0xffffffffffff0006, 0xffffffffffffff01,
  0xfffffffffffd0012, 0xfffffffffffffd01,
  0xffffffffffdd00d2, 0xffffffffffffdd01,
  0xffffffffff6003c0, 0xffffffffffff6001,
  0xfffffffffffe000c, 0xfffffffffffffe01,
  0xffffffffffde00cc, 0xffffffffffffde01,
  0xffffffffff6103ba, 0xffffffffffff6101,
  0xfffffffffee306ae, 0xfffffffffffee301,
  0xffffffffffe000c0, 0xffffffffffffe001,
  0xffffffffff6303ae, 0xffffffffffff6301,
  0xfffffffffee506a2, 0xfffffffffffee501,
  0xfffffffffe66099c, 0xfffffffffffe6601,
  0xffffffffff8302ee, 0xffffffffffff8301,
  0xffffffffff0505e2, 0xffffffffffff0501,
  0xfffffffffe8608dc, 0xfffffffffffe8601,
  0xffffffff7e8c08ca, 0xffffffffff7e8901,
  0xffffffffff8202f4, 0xffffffffffff8201,
  0xffffffffff0305ee, 0xffffffffffff0301,
  0xffffffff7f0905dc, 0xffffffffff7f0601,
  0xfffffffeff0e05d0, 0xfffffffffeff0801,
  0xffffffffff8102fa, 0xffffffffffff8101,
  0xffffffff7f8702e8, 0xffffffffff7f8401,
  0xfffffffeff8c02dc, 0xfffffffffeff8601,
  0xfffffffe7f9002d6, 0xfffffffffe7f8701,
  0xffffffff8005ffee, 0xffffffffff800301,
  0xffffffff000affe2, 0xffffffffff000501,
  0xfffffffe800effdc, 0xfffffffffe800601,
  0xffffcccc800f330e, 0xffffffcccb4cd301,
  0xffffffff8004fff4, 0xffffffffff800201,
  0xffffffff0008ffee, 0xffffffffff000301,
  0xffffcccd00093320, 0xffffffcccbccd001,
  0xffff7779aab4331e, 0xffffff7776777b01,
  0xffffffff8003fffa, 0xffffffffff800101,
  0xffffcccd8004332c, 0xffffffcccc4cce01,
  0xffff777a2aaf332a, 0xffffff7776f77901,
  0xfffef77d2ab23318, 0xfffffef776f77c01,
  0xffffccce00003332, 0xffffffcccccccd01,
  0xffff777aaaab3330, 0xffffff7777777801,
  0xfffef77daaae331e, 0xfffffef777777b01,
  0xfffe7780aab03312, 0xfffffe7777777d01,
  0xffffaaacaaaafffe, 0xffffffaaaaaaab01,
  0xffff2aafaaadffec, 0xffffff2aaaaaae01,
  0xfffeaab2aaafffe0, 0xfffffeaaaaaab001,
  0xfffe2ab5aab0ffda, 0xfffffe2aaaaab101,
  0xffff80030002ffee, 0xffffff8000000301,
  0xffff00060004ffe2, 0xffffff0000000501,
  0xfffe80090005ffdc, 0xfffffe8000000601,
  0xffff00060005ffdc, 0xffffff0000000601,
  0xffff80030001fff4, 0xffffff8000000201,
  0xffff00060002ffee, 0xffffff0000000301,
  0xffff80030002ffee, 0xffffff8000000301,
  0x000000000001fff4, 0x0000000000000201,
  0xffff80030000fffa, 0xffffff8000000101,
  0x000000000000fffa, 0x0000000000000101,
  0x00007ffd00000000, 0x0000008000000001,
  0x0000d5505555fffc, 0x000000d555555601,
  0x00007ffd00000000, 0x0000008000000001,
  0x0000fff9ffff0006, 0x000000ffffffff01,
  0x0001554d55550002, 0x0000015555555501,
  0x0001887f5555ccca, 0x0000018888888901,
  0x00007ffcffff0006, 0x0000007fffffff01,
  0x0000d55055550002, 0x000000d555555501,
  0x000108825555ccca, 0x0000010888888901,
  0x00010882d552ccca, 0x0000010889088901,
  0x000055535555fffc, 0x0000005555555601,
  0x000088855556ccc4, 0x0000008888888a01,
  0x00008885d553ccc4, 0x0000008889088a01,
  0x00008886554fccca, 0x0000008889888901,
  0x000033320000ccc8, 0x0000003333333401,
  0x000033327ffdccc8, 0x0000003333b33401,
  0x00003332fff9ccce, 0x0000003334333301,
  0x000033337ff4ccda, 0x0000003334b33101,
  0x000000007ffd0000, 0x0000000000800001,
  0x00000000fff90006, 0x0000000000ffff01,
  0x000000017ff40012, 0x00000000017ffd01,
  0x00000001ffee0024, 0x0000000001fffa01,
  0x000000007ffc0006, 0x00000000007fff01,
  0x00000000fff70012, 0x0000000000fffd01,
  0x000000017ff10024, 0x00000000017ffa01,
  0x000000018070fd24, 0x0000000001807a01,
  0x000000007ffb000c, 0x00000000007ffe01,
  0x00000000fff5001e, 0x0000000000fffb01,
  0x000000010074fd1e, 0x0000000001007b01,
  0x0000000100f3fa24, 0x000000000100fa01,
  0x000000007ffa0012, 0x00000000007ffd01,
  0x000000008079fd12, 0x0000000000807d01,
  0x0000000080f8fa18, 0x000000000080fc01,
  0x000000008176f724, 0x0000000000817a01,
  0x00000000007ffd00, 0x0000000000008001,
  0x0000000000fefa06, 0x000000000000ff01,
  0x00000000017cf712, 0x0000000000017d01,
  0x0000000001f9f424, 0x000000000001fa01,
  0x00000000007efd06, 0x0000000000007f01,
  0x0000000000fcfa12, 0x000000000000fd01,
  0x000000000179f724, 0x0000000000017a01,
  0x000000000199f664, 0x0000000000019a01,
  0x00000000007dfd0c, 0x0000000000007e01,
  0x0000000000fafa1e, 0x000000000000fb01,
  0x00000000011af95e, 0x0000000000011b01,
  0x00000000011df94c, 0x0000000000011e01,
  0x00000000007cfd12, 0x0000000000007d01,
  0x00000000009cfc52, 0x0000000000009d01,
  0x00000000009ffc40, 0x000000000000a001,
  0x0000000000a1fc34, 0x000000000000a201,
  0x00000000001fff40, 0x0000000000002001,
  0x000000000022ff2e, 0x0000000000002301,
  0x000000000024ff22, 0x0000000000002501,
  0x000000000025ff1c, 0x0000000000002601,
  0x0000000000000300, 0x00000000000002fb,
  0x0000000000000500, 0x00000000000004f7,
  0x0000000000000600, 0x00000000000005f5,
  0x0000000000000600, 0x00000000000005f5,
  0x0000000000000200, 0x00000000000001fd,
  0x0000000000000300, 0x00000000000002fb,
  0x0000000000000300, 0x00000000000002fb,
  0x0000000000000200, 0x00000000000001fd,
  0x0000000000000100, 0x00000000000000ff,
  0x0000000000000100, 0x00000000000000ff,
  0x0000000000000000, 0x0000000000000001,
  0xfffffffffffffe00, 0xfffffffffffffe05,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffffff00, 0xffffffffffffff03,
  0xfffffffffffffd00, 0xfffffffffffffd07,
  0xffffffffffffdd00, 0xffffffffffffdd47,
  0xffffffffffffff00, 0xffffffffffffff03,
  0xfffffffffffffd00, 0xfffffffffffffd07,
  0xffffffffffffdd00, 0xffffffffffffdd47,
  0xffffffffffff6000, 0xffffffffffff6141,
  0xfffffffffffffe00, 0xfffffffffffffe05,
  0xffffffffffffde00, 0xffffffffffffde45,
  0xffffffffffff6100, 0xffffffffffff623f,
  0xfffffffffffee300, 0xfffffffffffee53b,
  0xffffffffffffe000, 0xffffffffffffe041,
  0xffffffffffff6300, 0xffffffffffff643b,
  0xfffffffffffee500, 0xfffffffffffee737,
  0xfffffffffffe6600, 0xfffffffffffe6935,
  0xffffffffffff8300, 0xffffffffffff83fb,
  0xffffffffffff0500, 0xffffffffffff06f7,
  0xfffffffffffe8600, 0xfffffffffffe88f5,
  0xffffffffff7e8900, 0xffffffffff7f8bef,
  0xffffffffffff8200, 0xffffffffffff82fd,
  0xffffffffffff0300, 0xffffffffffff04fb,
  0xffffffffff7f0600, 0xffffffffff8007f5,
  0xfffffffffeff0800, 0xffffffffff0109f1,
  0xffffffffffff8100, 0xffffffffffff81ff,
  0xffffffffff7f8400, 0xffffffffff8084f9,
  0xfffffffffeff8600, 0xffffffffff0186f5,
  0xfffffffffe7f8700, 0xfffffffffe8287f3,
  0xffffffffff800300, 0xffffffffff8102fb,
  0xffffffffff000500, 0xffffffffff0204f7,
  0xfffffffffe800600, 0xfffffffffe8305f5,
  0xffffffcccb4cd300, 0xffffffcd31b6395b,
  0xffffffffff800200, 0xffffffffff8101fd,
  0xffffffffff000300, 0xffffffffff0202fb,
  0xffffffcccbccd000, 0xffffffcd32353661,
  0xffffff7776777b00, 0xffffff78878a8c0b,
  0xffffffffff800100, 0xffffffffff8100ff,
  0xffffffcccc4cce00, 0xffffffcd32b43465,
  0xffffff7776f77900, 0xffffff7888098a0f,
  0xfffffef776f77c00, 0xfffffef988098d09,
  0xffffffcccccccd00, 0xffffffcd33333367,
  0xffffff7777777800, 0xffffff7888888911,
  0xfffffef777777b00, 0xfffffef988888c0b,
  0xfffffe7777777d00, 0xfffffe7a88888e07,
  0xffffffaaaaaaab00, 0xffffffab555555ab,
  0xffffff2aaaaaae00, 0xffffff2c555558a5,
  0xfffffeaaaaaab000, 0xfffffead55555aa1,
  0xfffffe2aaaaab100, 0xfffffe2e55555b9f,
  0xffffff8000000300, 0xffffff81000002fb,
  0xffffff0000000500, 0xffffff02000004f7,
  0xfffffe8000000600, 0xfffffe83000005f5,
  0xffffff0000000600, 0xffffff02000005f5,
  0xffffff8000000200, 0xffffff81000001fd,
  0xffffff0000000300, 0xffffff02000002fb,
  0xffffff8000000300, 0xffffff81000002fb,
  0x0000000000000200, 0x00000000000001fd,
  0xffffff8000000100, 0xffffff81000000ff,
  0x0000000000000100, 0x00000000000000ff,
  0x0000008000000000, 0x0000007f00000001,
  0x000000d555555600, 0x000000d3aaaaab55,
  0x0000008000000000, 0x0000007f00000001,
  0x000000ffffffff00, 0x000000fdffffff03,
  0x0000015555555500, 0x00000152aaaaaa57,
  0x0000018888888900, 0x00000185777777ef,
  0x0000007fffffff00, 0x0000007effffff03,
  0x000000d555555500, 0x000000d3aaaaaa57,
  0x0000010888888900, 0x00000106777777ef,
  0x0000010889088900, 0x0000010677f677ef,
  0x0000005555555600, 0x00000054aaaaab55,
  0x0000008888888a00, 0x00000087777778ed,
  0x0000008889088a00, 0x0000008777f678ed,
  0x0000008889888900, 0x00000087787577ef,
  0x0000003333333400, 0x00000032cccccd99,
  0x0000003333b33400, 0x00000032cd4bcd99,
  0x0000003334333300, 0x00000032cdcacc9b,
  0x0000003334b33100, 0x00000032ce49ca9f,
  0x0000000000800000, 0x00000000007f0001,
  0x0000000000ffff00, 0x0000000000fdff03,
  0x00000000017ffd00, 0x00000000017cfd07,
  0x0000000001fffa00, 0x0000000001fbfa0d,
  0x00000000007fff00, 0x00000000007eff03,
  0x0000000000fffd00, 0x0000000000fdfd07,
  0x00000000017ffa00, 0x00000000017cfa0d,
  0x0000000001807a00, 0x00000000017d790d,
  0x00000000007ffe00, 0x00000000007efe05,
  0x0000000000fffb00, 0x0000000000fdfb0b,
  0x0000000001007b00, 0x0000000000fe7a0b,
  0x000000000100fa00, 0x0000000000fef80d,
  0x00000000007ffd00, 0x00000000007efd07,
  0x0000000000807d00, 0x00000000007f7c07,
  0x000000000080fc00, 0x00000000007ffa09,
  0x0000000000817a00, 0x000000000080770d,
  0x0000000000008000, 0x0000000000007f01,
  0x000000000000ff00, 0x000000000000fd03,
  0x0000000000017d00, 0x0000000000017a07,
  0x000000000001fa00, 0x000000000001f60d,
  0x0000000000007f00, 0x0000000000007e03,
  0x000000000000fd00, 0x000000000000fb07,
  0x0000000000017a00, 0x000000000001770d,
  0x0000000000019a00, 0x00000000000196cd,
  0x0000000000007e00, 0x0000000000007d05,
  0x000000000000fb00, 0x000000000000f90b,
  0x0000000000011b00, 0x00000000000118cb,
  0x0000000000011e00, 0x0000000000011bc5,
  0x0000000000007d00, 0x0000000000007c07,
  0x0000000000009d00, 0x0000000000009bc7,
  0x000000000000a000, 0x0000000000009ec1,
  0x000000000000a200, 0x000000000000a0bd,
  0x0000000000002000, 0x0000000000001fc1,
  0x0000000000002300, 0x00000000000022bb,
  0x0000000000002500, 0x00000000000024b7,
  0x0000000000002600, 0x00000000000025b5,
  0x00000000000002fa, 0x00000000000002f5,
  0x00000000000004f6, 0x00000000000004ed,
  0x00000000000005f4, 0x00000000000005e9,
  0x00000000000005f4, 0x00000000000005e9,
  0x00000000000001fc, 0x00000000000001f9,
  0x00000000000002fa, 0x00000000000002f5,
  0x00000000000002fa, 0x00000000000002f5,
  0x00000000000001fc, 0x00000000000001f9,
  0x00000000000000fe, 0x00000000000000fd,
  0x00000000000000fe, 0x00000000000000fd,
  0x0000000000000000, 0x0000000000000001,
  0xfffffffffffffe04, 0xfffffffffffffe09,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffffff02, 0xffffffffffffff05,
  0xfffffffffffffd06, 0xfffffffffffffd0d,
  0xffffffffffffdd46, 0xffffffffffffdd8d,
  0xffffffffffffff02, 0xffffffffffffff05,
  0xfffffffffffffd06, 0xfffffffffffffd0d,
  0xffffffffffffdd46, 0xffffffffffffdd8d,
  0xffffffffffff6140, 0xffffffffffff6281,
  0xfffffffffffffe04, 0xfffffffffffffe09,
  0xffffffffffffde44, 0xffffffffffffde89,
  0xffffffffffff623e, 0xffffffffffff637d,
  0xfffffffffffee53a, 0xfffffffffffee775,
  0xffffffffffffe040, 0xffffffffffffe081,
  0xffffffffffff643a, 0xffffffffffff6575,
  0xfffffffffffee736, 0xfffffffffffee96d,
  0xfffffffffffe6934, 0xfffffffffffe6c69,
  0xffffffffffff83fa, 0xffffffffffff84f5,
  0xffffffffffff06f6, 0xffffffffffff08ed,
  0xfffffffffffe88f4, 0xfffffffffffe8be9,
  0xffffffffff7f8bee, 0xffffffffff808edd,
  0xffffffffffff82fc, 0xffffffffffff83f9,
  0xffffffffffff04fa, 0xffffffffffff06f5,
  0xffffffffff8007f4, 0xffffffffff8109e9,
  0xffffffffff0109f0, 0xffffffffff030be1,
  0xffffffffffff81fe, 0xffffffffffff82fd,
  0xffffffffff8084f8, 0xffffffffff8185f1,
  0xffffffffff0186f4, 0xffffffffff0387e9,
  0xfffffffffe8287f2, 0xfffffffffe8588e5,
  0xffffffffff8102fa, 0xffffffffff8202f5,
  0xffffffffff0204f6, 0xffffffffff0404ed,
  0xfffffffffe8305f4, 0xfffffffffe8605e9,
  0xffffffcd31b6395a, 0xffffffcd981f9fb5,
  0xffffffffff8101fc, 0xffffffffff8201f9,
  0xffffffffff0202fa, 0xffffffffff0402f5,
  0xffffffcd32353660, 0xffffffcd989d9cc1,
  0xffffff78878a8c0a, 0xffffff79989d9d15,
  0xffffffffff8100fe, 0xffffffffff8200fd,
  0xffffffcd32b43464, 0xffffffcd991b9ac9,
  0xffffff7888098a0e, 0xffffff79991b9b1d,
  0xfffffef988098d08, 0xfffffefb991b9e11,
  0xffffffcd33333366, 0xffffffcd999999cd,
  0xffffff7888888910, 0xffffff7999999a21,
  0xfffffef988888c0a, 0xfffffefb99999d15,
  0xfffffe7a88888e06, 0xfffffe7d99999f0d,
  0xffffffab555555aa, 0xffffffac00000055,
  0xffffff2c555558a4, 0xffffff2e00000349,
  0xfffffead55555aa0, 0xfffffeb000000541,
  0xfffffe2e55555b9e, 0xfffffe320000063d,
  0xffffff81000002fa, 0xffffff82000002f5,
  0xffffff02000004f6, 0xffffff04000004ed,
  0xfffffe83000005f4, 0xfffffe86000005e9,
  0xffffff02000005f4, 0xffffff04000005e9,
  0xffffff81000001fc, 0xffffff82000001f9,
  0xffffff02000002fa, 0xffffff04000002f5,
  0xffffff81000002fa, 0xffffff82000002f5,
  0x00000000000001fc, 0x00000000000001f9,
  0xffffff81000000fe, 0xffffff82000000fd,
  0x00000000000000fe, 0x00000000000000fd,
  0x0000007f00000000, 0x0000007e00000001,
  0x000000d3aaaaab54, 0x000000d2000000a9,
  0x0000007f00000000, 0x0000007e00000001,
  0x000000fdffffff02, 0x000000fbffffff05,
  0x00000152aaaaaa56, 0x0000014fffffffad,
  0x00000185777777ee, 0x00000182666666dd,
  0x0000007effffff02, 0x0000007dffffff05,
  0x000000d3aaaaaa56, 0x000000d1ffffffad,
  0x00000106777777ee, 0x00000104666666dd,
  0x0000010677f677ee, 0x0000010466e466dd,
  0x00000054aaaaab54, 0x00000054000000a9,
  0x00000087777778ec, 0x00000086666667d9,
  0x0000008777f678ec, 0x0000008666e467d9,
  0x00000087787577ee, 0x00000086676266dd,
  0x00000032cccccd98, 0x0000003266666731,
  0x00000032cd4bcd98, 0x0000003266e46731,
  0x00000032cdcacc9a, 0x0000003267626635,
  0x00000032ce49ca9e, 0x0000003267e0643d,
  0x00000000007f0000, 0x00000000007e0001,
  0x0000000000fdff02, 0x0000000000fbff05,
  0x00000000017cfd06, 0x000000000179fd0d,
  0x0000000001fbfa0c, 0x0000000001f7fa19,
  0x00000000007eff02, 0x00000000007dff05,
  0x0000000000fdfd06, 0x0000000000fbfd0d,
  0x00000000017cfa0c, 0x000000000179fa19,
  0x00000000017d790c, 0x00000000017a7819,
  0x00000000007efe04, 0x00000000007dfe09,
  0x0000000000fdfb0a, 0x0000000000fbfb15,
  0x0000000000fe7a0a, 0x0000000000fc7915,
  0x0000000000fef80c, 0x0000000000fcf619,
  0x00000000007efd06, 0x00000000007dfd0d,
  0x00000000007f7c06, 0x00000000007e7b0d,
  0x00000000007ffa08, 0x00000000007ef811,
  0x000000000080770c, 0x00000000007f7419,
  0x0000000000007f00, 0x0000000000007e01,
  0x000000000000fd02, 0x000000000000fb05,
  0x0000000000017a06, 0x000000000001770d,
  0x000000000001f60c, 0x000000000001f219,
  0x0000000000007e02, 0x0000000000007d05,
  0x000000000000fb06, 0x000000000000f90d,
  0x000000000001770c, 0x0000000000017419,
  0x00000000000196cc, 0x0000000000019399,
  0x0000000000007d04, 0x0000000000007c09,
  0x000000000000f90a, 0x000000000000f715,
  0x00000000000118ca, 0x0000000000011695,
  0x0000000000011bc4, 0x0000000000011989,
  0x0000000000007c06, 0x0000000000007b0d,
  0x0000000000009bc6, 0x0000000000009a8d,
  0x0000000000009ec0, 0x0000000000009d81,
  0x000000000000a0bc, 0x0000000000009f79,
  0x0000000000001fc0, 0x0000000000001f81,
  0x00000000000022ba, 0x0000000000002275,
  0x00000000000024b6, 0x000000000000246d,
  0x00000000000025b4, 0x0000000000002569,
  0x00000000000002f4, 0x00000000000002ef,
  0x00000000000004ec, 0x00000000000004e3,
  0x00000000000005e8, 0x00000000000005dd,
  0x00000000000005e8, 0x00000000000005dd,
  0x00000000000001f8, 0x00000000000001f5,
  0x00000000000002f4, 0x00000000000002ef,
  0x00000000000002f4, 0x00000000000002ef,
  0x00000000000001f8, 0x00000000000001f5,
  0x00000000000000fc, 0x00000000000000fb,
  0x00000000000000fc, 0x00000000000000fb,
  0x0000000000000000, 0x0000000000000001,
  0xfffffffffffffe08, 0xfffffffffffffe0d,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffffff04, 0xffffffffffffff07,
  0xfffffffffffffd0c, 0xfffffffffffffd13,
  0xffffffffffffdd8c, 0xffffffffffffddd3,
  0xffffffffffffff04, 0xffffffffffffff07,
  0xfffffffffffffd0c, 0xfffffffffffffd13,
  0xffffffffffffdd8c, 0xffffffffffffddd3,
  0xffffffffffff6280, 0xffffffffffff63c1,
  0xfffffffffffffe08, 0xfffffffffffffe0d,
  0xffffffffffffde88, 0xffffffffffffdecd,
  0xffffffffffff637c, 0xffffffffffff64bb,
  0xfffffffffffee774, 0xfffffffffffee9af,
  0xffffffffffffe080, 0xffffffffffffe0c1,
  0xffffffffffff6574, 0xffffffffffff66af,
  0xfffffffffffee96c, 0xfffffffffffeeba3,
  0xfffffffffffe6c68, 0xfffffffffffe6f9d,
  0xffffffffffff84f4, 0xffffffffffff85ef,
  0xffffffffffff08ec, 0xffffffffffff0ae3,
  0xfffffffffffe8be8, 0xfffffffffffe8edd,
  0xffffffffff808edc, 0xffffffffff8191cb,
  0xffffffffffff83f8, 0xffffffffffff84f5,
  0xffffffffffff06f4, 0xffffffffffff08ef,
  0xffffffffff8109e8, 0xffffffffff820bdd,
  0xffffffffff030be0, 0xffffffffff050dd1,
  0xffffffffffff82fc, 0xffffffffffff83fb,
  0xffffffffff8185f0, 0xffffffffff8286e9,
  0xffffffffff0387e8, 0xffffffffff0588dd,
  0xfffffffffe8588e4, 0xfffffffffe8889d7,
  0xffffffffff8202f4, 0xffffffffff8302ef,
  0xffffffffff0404ec, 0xffffffffff0604e3,
  0xfffffffffe8605e8, 0xfffffffffe8905dd,
  0xffffffcd981f9fb4, 0xffffffcdfe89060f,
  0xffffffffff8201f8, 0xffffffffff8301f5,
  0xffffffffff0402f4, 0xffffffffff0602ef,
  0xffffffcd989d9cc0, 0xffffffcdff060321,
  0xffffff79989d9d14, 0xffffff7aa9b0ae1f,
  0xffffffffff8200fc, 0xffffffffff8300fb,
  0xffffffcd991b9ac8, 0xffffffcdff83012d,
  0xffffff79991b9b1c, 0xffffff7aaa2dac2b,
  0xfffffefb991b9e10, 0xfffffefdaa2daf19,
  0xffffffcd999999cc, 0xffffffce00000033,
  0xffffff7999999a20, 0xffffff7aaaaaab31,
  0xfffffefb99999d14, 0xfffffefdaaaaae1f,
  0xfffffe7d99999f0c, 0xfffffe80aaaab013,
  0xffffffac00000054, 0xffffffacaaaaaaff,
  0xffffff2e00000348, 0xffffff2faaaaaded,
  0xfffffeb000000540, 0xfffffeb2aaaaafe1,
  0xfffffe320000063c, 0xfffffe35aaaab0db,
  0xffffff82000002f4, 0xffffff83000002ef,
  0xffffff04000004ec, 0xffffff06000004e3,
  0xfffffe86000005e8, 0xfffffe89000005dd,
  0xffffff04000005e8, 0xffffff06000005dd,
  0xffffff82000001f8, 0xffffff83000001f5,
  0xffffff04000002f4, 0xffffff06000002ef,
  0xffffff82000002f4, 0xffffff83000002ef,
  0x00000000000001f8, 0x00000000000001f5,
  0xffffff82000000fc, 0xffffff83000000fb,
  0x00000000000000fc, 0x00000000000000fb,
  0x0000007e00000000, 0x0000007d00000001,
  0x000000d2000000a8, 0x000000d0555555fd,
  0x0000007e00000000, 0x0000007d00000001,
  0x000000fbffffff04, 0x000000f9ffffff07,
  0x0000014fffffffac, 0x0000014d55555503,
  0x00000182666666dc, 0x0000017f555555cb,
  0x0000007dffffff04, 0x0000007cffffff07,
  0x000000d1ffffffac, 0x000000d055555503,
  0x00000104666666dc, 0x00000102555555cb,
  0x0000010466e466dc, 0x0000010255d255cb,
  0x00000054000000a8, 0x00000053555555fd,
  0x00000086666667d8, 0x00000085555556c5,
  0x0000008666e467d8, 0x0000008555d256c5,
  0x00000086676266dc, 0x00000085564f55cb,
  0x0000003266666730, 0x00000032000000c9,
  0x0000003266e46730, 0x00000032007d00c9,
  0x0000003267626634, 0x0000003200f9ffcf,
  0x0000003267e0643c, 0x000000320176fddb,
  0x00000000007e0000, 0x00000000007d0001,
  0x0000000000fbff04, 0x0000000000f9ff07,
  0x000000000179fd0c, 0x000000000176fd13,
  0x0000000001f7fa18, 0x0000000001f3fa25,
  0x00000000007dff04, 0x00000000007cff07,
  0x0000000000fbfd0c, 0x0000000000f9fd13,
  0x000000000179fa18, 0x000000000176fa25,
  0x00000000017a7818, 0x0000000001777725,
  0x00000000007dfe08, 0x00000000007cfe0d,
  0x0000000000fbfb14, 0x0000000000f9fb1f,
  0x0000000000fc7914, 0x0000000000fa781f,
  0x0000000000fcf618, 0x0000000000faf425,
  0x00000000007dfd0c, 0x00000000007cfd13,
  0x00000000007e7b0c, 0x00000000007d7a13,
  0x00000000007ef810, 0x00000000007df619,
  0x00000000007f7418, 0x00000000007e7125,
  0x0000000000007e00, 0x0000000000007d01,
  0x000000000000fb04, 0x000000000000f907,
  0x000000000001770c, 0x0000000000017413,
  0x000000000001f218, 0x000000000001ee25,
  0x0000000000007d04, 0x0000000000007c07,
  0x000000000000f90c, 0x000000000000f713,
  0x0000000000017418, 0x0000000000017125,
  0x0000000000019398, 0x0000000000019065,
  0x0000000000007c08, 0x0000000000007b0d,
  0x000000000000f714, 0x000000000000f51f,
  0x0000000000011694, 0x000000000001145f,
  0x0000000000011988, 0x000000000001174d,
  0x0000000000007b0c, 0x0000000000007a13,
  0x0000000000009a8c, 0x0000000000009953,
  0x0000000000009d80, 0x0000000000009c41,
  0x0000000000009f78, 0x0000000000009e35,
  0x0000000000001f80, 0x0000000000001f41,
  0x0000000000002274, 0x000000000000222f,
  0x000000000000246c, 0x0000000000002423,
  0x0000000000002568, 0x000000000000251d,
  0x00000000000002ee, 0x00000000000000c1,
  0x00000000000004e2, 0x0000000000000141,
  0x00000000000005dc, 0x0000000000000181,
  0x00000000000005dc, 0x0000000000000181,
  0x00000000000001f4, 0x0000000000000081,
  0x00000000000002ee, 0x00000000000000c1,
  0x00000000000002ee, 0x00000000000000c1,
  0x00000000000001f4, 0x0000000000000081,
  0x00000000000000fa, 0x0000000000000041,
  0x00000000000000fa, 0x0000000000000041,
  0x0000000000000000, 0x0000000000000001,
  0xfffffffffffffe0c, 0xffffffffffffff81,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffffff06, 0xffffffffffffffc1,
  0xfffffffffffffd12, 0xffffffffffffff41,
  0xffffffffffffddd2, 0xfffffffffffff741,
  0xffffffffffffff06, 0xffffffffffffffc1,
  0xfffffffffffffd12, 0xffffffffffffff41,
  0xffffffffffffddd2, 0xfffffffffffff741,
  0xffffffffffff63c0, 0xffffffffffffd801,
  0xfffffffffffffe0c, 0xffffffffffffff81,
  0xffffffffffffdecc, 0xfffffffffffff781,
  0xffffffffffff64ba, 0xffffffffffffd841,
  0xfffffffffffee9ae, 0xffffffffffffb8c1,
  0xffffffffffffe0c0, 0xfffffffffffff801,
  0xffffffffffff66ae, 0xffffffffffffd8c1,
  0xfffffffffffeeba2, 0xffffffffffffb941,
  0xfffffffffffe6f9c, 0xffffffffffff9981,
  0xffffffffffff85ee, 0xffffffffffffe0c1,
  0xffffffffffff0ae2, 0xffffffffffffc141,
  0xfffffffffffe8edc, 0xffffffffffffa181,
  0xffffffffff8191ca, 0xffffffffffdfa241,
  0xffffffffffff84f4, 0xffffffffffffe081,
  0xffffffffffff08ee, 0xffffffffffffc0c1,
  0xffffffffff820bdc, 0xffffffffffdfc181,
  0xffffffffff050dd0, 0xffffffffffbfc201,
  0xffffffffffff83fa, 0xffffffffffffe041,
  0xffffffffff8286e8, 0xffffffffffdfe101,
  0xffffffffff0588dc, 0xffffffffffbfe181,
  0xfffffffffe8889d6, 0xffffffffff9fe1c1,
  0xffffffffff8302ee, 0xffffffffffe000c1,
  0xffffffffff0604e2, 0xffffffffffc00141,
  0xfffffffffe8905dc, 0xffffffffffa00181,
  0xffffffcdfe89060e, 0xfffffff332d334c1,
  0xffffffffff8301f4, 0xffffffffffe00081,
  0xffffffffff0602ee, 0xffffffffffc000c1,
  0xffffffcdff060320, 0xfffffff332f33401,
  0xffffff7aa9b0ae1e, 0xffffffdddd9ddec1,
  0xffffffffff8300fa, 0xffffffffffe00041,
  0xffffffcdff83012c, 0xfffffff333133381,
  0xffffff7aaa2dac2a, 0xffffffddddbdde41,
  0xfffffefdaa2daf18, 0xffffffbdddbddf01,
  0xffffffce00000032, 0xfffffff333333341,
  0xffffff7aaaaaab30, 0xffffffddddddde01,
  0xfffffefdaaaaae1e, 0xffffffbddddddec1,
  0xfffffe80aaaab012, 0xffffff9ddddddf41,
  0xffffffacaaaaaafe, 0xffffffeaaaaaaac1,
  0xffffff2faaaaadec, 0xffffffcaaaaaab81,
  0xfffffeb2aaaaafe0, 0xffffffaaaaaaac01,
  0xfffffe35aaaab0da, 0xffffff8aaaaaac41,
  0xffffff83000002ee, 0xffffffe0000000c1,
  0xffffff06000004e2, 0xffffffc000000141,
  0xfffffe89000005dc, 0xffffffa000000181,
  0xffffff06000005dc, 0xffffffc000000181,
  0xffffff83000001f4, 0xffffffe000000081,
  0xffffff06000002ee, 0xffffffc0000000c1,
  0xffffff83000002ee, 0xffffffe0000000c1,
  0x00000000000001f4, 0x0000000000000081,
  0xffffff83000000fa, 0xffffffe000000041,
  0x00000000000000fa, 0x0000000000000041,
  0x0000007d00000000, 0x0000002000000001,
  0x000000d0555555fc, 0x0000003555555581,
  0x0000007d00000000, 0x0000002000000001,
  0x000000f9ffffff06, 0x0000003fffffffc1,
  0x0000014d55555502, 0x0000005555555541,
  0x0000017f555555ca, 0x0000006222222241,
  0x0000007cffffff06, 0x0000001fffffffc1,
  0x000000d055555502, 0x0000003555555541,
  0x00000102555555ca, 0x0000004222222241,
  0x0000010255d255ca, 0x0000004222422241,
  0x00000053555555fc, 0x0000001555555581,
  0x00000085555556c4, 0x0000002222222281,
  0x0000008555d256c4, 0x0000002222422281,
  0x00000085564f55ca, 0x0000002222622241,
  0x00000032000000c8, 0x0000000ccccccd01,
  0x00000032007d00c8, 0x0000000ccceccd01,
  0x0000003200f9ffce, 0x0000000ccd0cccc1,
  0x000000320176fdda, 0x0000000ccd2ccc41,
  0x00000000007d0000, 0x0000000000200001,
  0x0000000000f9ff06, 0x00000000003fffc1,
  0x000000000176fd12, 0x00000000005fff41,
  0x0000000001f3fa24, 0x00000000007ffe81,
  0x00000000007cff06, 0x00000000001fffc1,
  0x0000000000f9fd12, 0x00000000003fff41,
  0x000000000176fa24, 0x00000000005ffe81,
  0x0000000001777724, 0x0000000000601e81,
  0x00000000007cfe0c, 0x00000000001fff81,
  0x0000000000f9fb1e, 0x00000000003ffec1,
  0x0000000000fa781e, 0x0000000000401ec1,
  0x0000000000faf424, 0x0000000000403e81,
  0x00000000007cfd12, 0x00000000001fff41,
  0x00000000007d7a12, 0x0000000000201f41,
  0x00000000007df618, 0x0000000000203f01,
  0x00000000007e7124, 0x0000000000205e81,
  0x0000000000007d00, 0x0000000000002001,
  0x000000000000f906, 0x0000000000003fc1,
  0x0000000000017412, 0x0000000000005f41,
  0x000000000001ee24, 0x0000000000007e81,
  0x0000000000007c06, 0x0000000000001fc1,
  0x000000000000f712, 0x0000000000003f41,
  0x0000000000017124, 0x0000000000005e81,
  0x0000000000019064, 0x0000000000006681,
  0x0000000000007b0c, 0x0000000000001f81,
  0x000000000000f51e, 0x0000000000003ec1,
  0x000000000001145e, 0x00000000000046c1,
  0x000000000001174c, 0x0000000000004781,
  0x0000000000007a12, 0x0000000000001f41,
  0x0000000000009952, 0x0000000000002741,
  0x0000000000009c40, 0x0000000000002801,
  0x0000000000009e34, 0x0000000000002881,
  0x0000000000001f40, 0x0000000000000801,
  0x000000000000222e, 0x00000000000008c1,
  0x0000000000002422, 0x0000000000000941,
  0x000000000000251c, 0x0000000000000981,
  0x00000000000000c0, 0x0000000000000013,
  0x0000000000000140, 0x000000000000001f,
  0x0000000000000180, 0x0000000000000025,
  0x0000000000000180, 0x0000000000000025,
  0x0000000000000080, 0x000000000000000d,
  0x00000000000000c0, 0x0000000000000013,
  0x00000000000000c0, 0x0000000000000013,
  0x0000000000000080, 0x000000000000000d,
  0x0000000000000040, 0x0000000000000007,
  0x0000000000000040, 0x0000000000000007,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffffff80, 0xfffffffffffffff5,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffffffc0, 0xfffffffffffffffb,
  0xffffffffffffff40, 0xffffffffffffffef,
  0xfffffffffffff740, 0xffffffffffffff2f,
  0xffffffffffffffc0, 0xfffffffffffffffb,
  0xffffffffffffff40, 0xffffffffffffffef,
  0xfffffffffffff740, 0xffffffffffffff2f,
  0xffffffffffffd800, 0xfffffffffffffc41,
  0xffffffffffffff80, 0xfffffffffffffff5,
  0xfffffffffffff780, 0xffffffffffffff35,
  0xffffffffffffd840, 0xfffffffffffffc47,
  0xffffffffffffb8c0, 0xfffffffffffff953,
  0xfffffffffffff800, 0xffffffffffffff41,
  0xffffffffffffd8c0, 0xfffffffffffffc53,
  0xffffffffffffb940, 0xfffffffffffff95f,
  0xffffffffffff9980, 0xfffffffffffff665,
  0xffffffffffffe0c0, 0xfffffffffffffd13,
  0xffffffffffffc140, 0xfffffffffffffa1f,
  0xffffffffffffa180, 0xfffffffffffff725,
  0xffffffffffdfa240, 0xfffffffffffcf737,
  0xffffffffffffe080, 0xfffffffffffffd0d,
  0xffffffffffffc0c0, 0xfffffffffffffa13,
  0xffffffffffdfc180, 0xfffffffffffcfa25,
  0xffffffffffbfc200, 0xfffffffffff9fa31,
  0xffffffffffffe040, 0xfffffffffffffd07,
  0xffffffffffdfe100, 0xfffffffffffcfd19,
  0xffffffffffbfe180, 0xfffffffffff9fd25,
  0xffffffffff9fe1c0, 0xfffffffffff6fd2b,
  0xffffffffffe000c0, 0xfffffffffffd0013,
  0xffffffffffc00140, 0xfffffffffffa001f,
  0xffffffffffa00180, 0xfffffffffff70025,
  0xfffffff332d334c0, 0xfffffffeccc3ccf3,
  0xffffffffffe00080, 0xfffffffffffd000d,
  0xffffffffffc000c0, 0xfffffffffffa0013,
  0xfffffff332f33400, 0xfffffffeccc6cce1,
  0xffffffdddd9ddec0, 0xfffffffcccc6cce3,
  0xffffffffffe00040, 0xfffffffffffd0007,
  0xfffffff333133380, 0xfffffffeccc9ccd5,
  0xffffffddddbdde40, 0xfffffffcccc9ccd7,
  0xffffffbdddbddf00, 0xfffffff9ccc9cce9,
  0xfffffff333333340, 0xfffffffecccccccf,
  0xffffffddddddde00, 0xfffffffcccccccd1,
  0xffffffbddddddec0, 0xfffffff9cccccce3,
  0xffffff9ddddddf40, 0xfffffff6ccccccef,
  0xffffffeaaaaaaac0, 0xfffffffe00000003,
  0xffffffcaaaaaab80, 0xfffffffb00000015,
  0xffffffaaaaaaac00, 0xfffffff800000021,
  0xffffff8aaaaaac40, 0xfffffff500000027,
  0xffffffe0000000c0, 0xfffffffd00000013,
  0xffffffc000000140, 0xfffffffa0000001f,
  0xffffffa000000180, 0xfffffff700000025,
  0xffffffc000000180, 0xfffffffa00000025,
  0xffffffe000000080, 0xfffffffd0000000d,
  0xffffffc0000000c0, 0xfffffffa00000013,
  0xffffffe0000000c0, 0xfffffffd00000013,
  0x0000000000000080, 0x000000000000000d,
  0xffffffe000000040, 0xfffffffd00000007,
  0x0000000000000040, 0x0000000000000007,
  0x0000002000000000, 0x0000000300000001,
  0x0000003555555580, 0x0000000500000005,
  0x0000002000000000, 0x0000000300000001,
  0x0000003fffffffc0, 0x00000005fffffffb,
  0x0000005555555540, 0x00000007ffffffff,
  0x0000006222222240, 0x0000000933333337,
  0x0000001fffffffc0, 0x00000002fffffffb,
  0x0000003555555540, 0x00000004ffffffff,
  0x0000004222222240, 0x0000000633333337,
  0x0000004222422240, 0x0000000633363337,
  0x0000001555555580, 0x0000000200000005,
  0x0000002222222280, 0x000000033333333d,
  0x0000002222422280, 0x000000033336333d,
  0x0000002222622240, 0x0000000333393337,
  0x0000000ccccccd00, 0x0000000133333339,
  0x0000000ccceccd00, 0x0000000133363339,
  0x0000000ccd0cccc0, 0x0000000133393333,
  0x0000000ccd2ccc40, 0x00000001333c3327,
  0x0000000000200000, 0x0000000000030001,
  0x00000000003fffc0, 0x000000000005fffb,
  0x00000000005fff40, 0x000000000008ffef,
  0x00000000007ffe80, 0x00000000000bffdd,
  0x00000000001fffc0, 0x000000000002fffb,
  0x00000000003fff40, 0x000000000005ffef,
  0x00000000005ffe80, 0x000000000008ffdd,
  0x0000000000601e80, 0x00000000000902dd,
  0x00000000001fff80, 0x000000000002fff5,
  0x00000000003ffec0, 0x000000000005ffe3,
  0x0000000000401ec0, 0x00000000000602e3,
  0x0000000000403e80, 0x00000000000605dd,
  0x00000000001fff40, 0x000000000002ffef,
  0x0000000000201f40, 0x00000000000302ef,
  0x0000000000203f00, 0x00000000000305e9,
  0x0000000000205e80, 0x00000000000308dd,
  0x0000000000002000, 0x0000000000000301,
  0x0000000000003fc0, 0x00000000000005fb,
  0x0000000000005f40, 0x00000000000008ef,
  0x0000000000007e80, 0x0000000000000bdd,
  0x0000000000001fc0, 0x00000000000002fb,
  0x0000000000003f40, 0x00000000000005ef,
  0x0000000000005e80, 0x00000000000008dd,
  0x0000000000006680, 0x000000000000099d,
  0x0000000000001f80, 0x00000000000002f5,
  0x0000000000003ec0, 0x00000000000005e3,
  0x00000000000046c0, 0x00000000000006a3,
  0x0000000000004780, 0x00000000000006b5,
  0x0000000000001f40, 0x00000000000002ef,
  0x0000000000002740, 0x00000000000003af,
  0x0000000000002800, 0x00000000000003c1,
  0x0000000000002880, 0x00000000000003cd,
  0x0000000000000800, 0x00000000000000c1,
  0x00000000000008c0, 0x00000000000000d3,
  0x0000000000000940, 0x00000000000000df,
  0x0000000000000980, 0x00000000000000e5,
  0x0000000000000012, 0x000000000000000d,
  0x000000000000001e, 0x0000000000000015,
  0x0000000000000024, 0x0000000000000019,
  0x0000000000000024, 0x0000000000000019,
  0x000000000000000c, 0x0000000000000009,
  0x0000000000000012, 0x000000000000000d,
  0x0000000000000012, 0x000000000000000d,
  0x000000000000000c, 0x0000000000000009,
  0x0000000000000006, 0x0000000000000005,
  0x0000000000000006, 0x0000000000000005,
  0x0000000000000000, 0x0000000000000001,
  0xfffffffffffffff4, 0xfffffffffffffff9,
  0x0000000000000000, 0x0000000000000001,
  0xfffffffffffffffa, 0xfffffffffffffffd,
  0xffffffffffffffee, 0xfffffffffffffff5,
  0xffffffffffffff2e, 0xffffffffffffff75,
  0xfffffffffffffffa, 0xfffffffffffffffd,
  0xffffffffffffffee, 0xfffffffffffffff5,
  0xffffffffffffff2e, 0xffffffffffffff75,
  0xfffffffffffffc40, 0xfffffffffffffd81,
  0xfffffffffffffff4, 0xfffffffffffffff9,
  0xffffffffffffff34, 0xffffffffffffff79,
  0xfffffffffffffc46, 0xfffffffffffffd85,
  0xfffffffffffff952, 0xfffffffffffffb8d,
  0xffffffffffffff40, 0xffffffffffffff81,
  0xfffffffffffffc52, 0xfffffffffffffd8d,
  0xfffffffffffff95e, 0xfffffffffffffb95,
  0xfffffffffffff664, 0xfffffffffffff999,
  0xfffffffffffffd12, 0xfffffffffffffe0d,
  0xfffffffffffffa1e, 0xfffffffffffffc15,
  0xfffffffffffff724, 0xfffffffffffffa19,
  0xfffffffffffcf736, 0xfffffffffffdfa25,
  0xfffffffffffffd0c, 0xfffffffffffffe09,
  0xfffffffffffffa12, 0xfffffffffffffc0d,
  0xfffffffffffcfa24, 0xfffffffffffdfc19,
  0xfffffffffff9fa30, 0xfffffffffffbfc21,
  0xfffffffffffffd06, 0xfffffffffffffe05,
  0xfffffffffffcfd18, 0xfffffffffffdfe11,
  0xfffffffffff9fd24, 0xfffffffffffbfe19,
  0xfffffffffff6fd2a, 0xfffffffffff9fe1d,
  0xfffffffffffd0012, 0xfffffffffffe000d,
  0xfffffffffffa001e, 0xfffffffffffc0015,
  0xfffffffffff70024, 0xfffffffffffa0019,
  0xfffffffeccc3ccf2, 0xffffffff332d334d,
  0xfffffffffffd000c, 0xfffffffffffe0009,
  0xfffffffffffa0012, 0xfffffffffffc000d,
  0xfffffffeccc6cce0, 0xffffffff332f3341,
  0xfffffffcccc6cce2, 0xfffffffdddd9dded,
  0xfffffffffffd0006, 0xfffffffffffe0005,
  0xfffffffeccc9ccd4, 0xffffffff33313339,
  0xfffffffcccc9ccd6, 0xfffffffddddbdde5,
  0xfffffff9ccc9cce8, 0xfffffffbdddbddf1,
  0xfffffffeccccccce, 0xffffffff33333335,
  0xfffffffcccccccd0, 0xfffffffddddddde1,
  0xfffffff9cccccce2, 0xfffffffbdddddded,
  0xfffffff6ccccccee, 0xfffffff9ddddddf5,
  0xfffffffe00000002, 0xfffffffeaaaaaaad,
  0xfffffffb00000014, 0xfffffffcaaaaaab9,
  0xfffffff800000020, 0xfffffffaaaaaaac1,
  0xfffffff500000026, 0xfffffff8aaaaaac5,
  0xfffffffd00000012, 0xfffffffe0000000d,
  0xfffffffa0000001e, 0xfffffffc00000015,
  0xfffffff700000024, 0xfffffffa00000019,
  0xfffffffa00000024, 0xfffffffc00000019,
  0xfffffffd0000000c, 0xfffffffe00000009,
  0xfffffffa00000012, 0xfffffffc0000000d,
  0xfffffffd00000012, 0xfffffffe0000000d,
  0x000000000000000c, 0x0000000000000009,
  0xfffffffd00000006, 0xfffffffe00000005,
  0x0000000000000006, 0x0000000000000005,
  0x0000000300000000, 0x0000000200000001,
  0x0000000500000004, 0x0000000355555559,
  0x0000000300000000, 0x0000000200000001,
  0x00000005fffffffa, 0x00000003fffffffd,
  0x00000007fffffffe, 0x0000000555555555,
  0x0000000933333336, 0x0000000622222225,
  0x00000002fffffffa, 0x00000001fffffffd,
  0x00000004fffffffe, 0x0000000355555555,
  0x0000000633333336, 0x0000000422222225,
  0x0000000633363336, 0x0000000422242225,
  0x0000000200000004, 0x0000000155555559,
  0x000000033333333c, 0x0000000222222229,
  0x000000033336333c, 0x0000000222242229,
  0x0000000333393336, 0x0000000222262225,
  0x0000000133333338, 0x00000000ccccccd1,
  0x0000000133363338, 0x00000000ccceccd1,
  0x0000000133393332, 0x00000000ccd0cccd,
  0x00000001333c3326, 0x00000000ccd2ccc5,
  0x0000000000030000, 0x0000000000020001,
  0x000000000005fffa, 0x000000000003fffd,
  0x000000000008ffee, 0x000000000005fff5,
  0x00000000000bffdc, 0x000000000007ffe9,
  0x000000000002fffa, 0x000000000001fffd,
  0x000000000005ffee, 0x000000000003fff5,
  0x000000000008ffdc, 0x000000000005ffe9,
  0x00000000000902dc, 0x00000000000601e9,
  0x000000000002fff4, 0x000000000001fff9,
  0x000000000005ffe2, 0x000000000003ffed,
  0x00000000000602e2, 0x00000000000401ed,
  0x00000000000605dc, 0x00000000000403e9,
  0x000000000002ffee, 0x000000000001fff5,
  0x00000000000302ee, 0x00000000000201f5,
  0x00000000000305e8, 0x00000000000203f1,
  0x00000000000308dc, 0x00000000000205e9,
  0x0000000000000300, 0x0000000000000201,
  0x00000000000005fa, 0x00000000000003fd,
  0x00000000000008ee, 0x00000000000005f5,
  0x0000000000000bdc, 0x00000000000007e9,
  0x00000000000002fa, 0x00000000000001fd,
  0x00000000000005ee, 0x00000000000003f5,
  0x00000000000008dc, 0x00000000000005e9,
  0x000000000000099c, 0x0000000000000669,
  0x00000000000002f4, 0x00000000000001f9,
  0x00000000000005e2, 0x00000000000003ed,
  0x00000000000006a2, 0x000000000000046d,
  0x00000000000006b4, 0x0000000000000479,
  0x00000000000002ee, 0x00000000000001f5,
  0x00000000000003ae, 0x0000000000000275,
  0x00000000000003c0, 0x0000000000000281,
  0x00000000000003cc, 0x0000000000000289,
  0x00000000000000c0, 0x0000000000000081,
  0x00000000000000d2, 0x000000000000008d,
  0x00000000000000de, 0x0000000000000095,
  0x00000000000000e4, 0x0000000000000099,
  0x000000000000000c, 0x0000000000000007,
  0x0000000000000014, 0x000000000000000b,
  0x0000000000000018, 0x000000000000000d,
  0x0000000000000018, 0x000000000000000d,
  0x0000000000000008, 0x0000000000000005,
  0x000000000000000c, 0x0000000000000007,
  0x000000000000000c, 0x0000000000000007,
  0x0000000000000008, 0x0000000000000005,
  0x0000000000000004, 0x0000000000000003,
  0x0000000000000004, 0x0000000000000003,
  0x0000000000000000, 0x0000000000000001,
  0xfffffffffffffff8, 0xfffffffffffffffd,
  0x0000000000000000, 0x0000000000000001,
  0xfffffffffffffffc, 0xffffffffffffffff,
  0xfffffffffffffff4, 0xfffffffffffffffb,
  0xffffffffffffff74, 0xffffffffffffffbb,
  0xfffffffffffffffc, 0xffffffffffffffff,
  0xfffffffffffffff4, 0xfffffffffffffffb,
  0xffffffffffffff74, 0xffffffffffffffbb,
  0xfffffffffffffd80, 0xfffffffffffffec1,
  0xfffffffffffffff8, 0xfffffffffffffffd,
  0xffffffffffffff78, 0xffffffffffffffbd,
  0xfffffffffffffd84, 0xfffffffffffffec3,
  0xfffffffffffffb8c, 0xfffffffffffffdc7,
  0xffffffffffffff80, 0xffffffffffffffc1,
  0xfffffffffffffd8c, 0xfffffffffffffec7,
  0xfffffffffffffb94, 0xfffffffffffffdcb,
  0xfffffffffffff998, 0xfffffffffffffccd,
  0xfffffffffffffe0c, 0xffffffffffffff07,
  0xfffffffffffffc14, 0xfffffffffffffe0b,
  0xfffffffffffffa18, 0xfffffffffffffd0d,
  0xfffffffffffdfa24, 0xfffffffffffefd13,
  0xfffffffffffffe08, 0xffffffffffffff05,
  0xfffffffffffffc0c, 0xfffffffffffffe07,
  0xfffffffffffdfc18, 0xfffffffffffefe0d,
  0xfffffffffffbfc20, 0xfffffffffffdfe11,
  0xfffffffffffffe04, 0xffffffffffffff03,
  0xfffffffffffdfe10, 0xfffffffffffeff09,
  0xfffffffffffbfe18, 0xfffffffffffdff0d,
  0xfffffffffff9fe1c, 0xfffffffffffcff0f,
  0xfffffffffffe000c, 0xffffffffffff0007,
  0xfffffffffffc0014, 0xfffffffffffe000b,
  0xfffffffffffa0018, 0xfffffffffffd000d,
  0xffffffff332d334c, 0xffffffff999699a7,
  0xfffffffffffe0008, 0xffffffffffff0005,
  0xfffffffffffc000c, 0xfffffffffffe0007,
  0xffffffff332f3340, 0xffffffff999799a1,
  0xfffffffdddd9ddec, 0xfffffffeeeeceef7,
  0xfffffffffffe0004, 0xffffffffffff0003,
  0xffffffff33313338, 0xffffffff9998999d,
  0xfffffffddddbdde4, 0xfffffffeeeedeef3,
  0xfffffffbdddbddf0, 0xfffffffdeeedeef9,
  0xffffffff33333334, 0xffffffff9999999b,
  0xfffffffddddddde0, 0xfffffffeeeeeeef1,
  0xfffffffbddddddec, 0xfffffffdeeeeeef7,
  0xfffffff9ddddddf4, 0xfffffffceeeeeefb,
  0xfffffffeaaaaaaac, 0xffffffff55555557,
  0xfffffffcaaaaaab8, 0xfffffffe5555555d,
  0xfffffffaaaaaaac0, 0xfffffffd55555561,
  0xfffffff8aaaaaac4, 0xfffffffc55555563,
  0xfffffffe0000000c, 0xffffffff00000007,
  0xfffffffc00000014, 0xfffffffe0000000b,
  0xfffffffa00000018, 0xfffffffd0000000d,
  0xfffffffc00000018, 0xfffffffe0000000d,
  0xfffffffe00000008, 0xffffffff00000005,
  0xfffffffc0000000c, 0xfffffffe00000007,
  0xfffffffe0000000c, 0xffffffff00000007,
  0x0000000000000008, 0x0000000000000005,
  0xfffffffe00000004, 0xffffffff00000003,
  0x0000000000000004, 0x0000000000000003,
  0x0000000200000000, 0x0000000100000001,
  0x0000000355555558, 0x00000001aaaaaaad,
  0x0000000200000000, 0x0000000100000001,
  0x00000003fffffffc, 0x00000001ffffffff,
  0x0000000555555554, 0x00000002aaaaaaab,
  0x0000000622222224, 0x0000000311111113,
  0x00000001fffffffc, 0x00000000ffffffff,
  0x0000000355555554, 0x00000001aaaaaaab,
  0x0000000422222224, 0x0000000211111113,
  0x0000000422242224, 0x0000000211121113,
  0x0000000155555558, 0x00000000aaaaaaad,
  0x0000000222222228, 0x0000000111111115,
  0x0000000222242228, 0x0000000111121115,
  0x0000000222262224, 0x0000000111131113,
  0x00000000ccccccd0, 0x0000000066666669,
  0x00000000ccceccd0, 0x0000000066676669,
  0x00000000ccd0cccc, 0x0000000066686667,
  0x00000000ccd2ccc4, 0x0000000066696663,
  0x0000000000020000, 0x0000000000010001,
  0x000000000003fffc, 0x000000000001ffff,
  0x000000000005fff4, 0x000000000002fffb,
  0x000000000007ffe8, 0x000000000003fff5,
  0x000000000001fffc, 0x000000000000ffff,
  0x000000000003fff4, 0x000000000001fffb,
  0x000000000005ffe8, 0x000000000002fff5,
  0x00000000000601e8, 0x00000000000300f5,
  0x000000000001fff8, 0x000000000000fffd,
  0x000000000003ffec, 0x000000000001fff7,
  0x00000000000401ec, 0x00000000000200f7,
  0x00000000000403e8, 0x00000000000201f5,
  0x000000000001fff4, 0x000000000000fffb,
  0x00000000000201f4, 0x00000000000100fb,
  0x00000000000203f0, 0x00000000000101f9,
  0x00000000000205e8, 0x00000000000102f5,
  0x0000000000000200, 0x0000000000000101,
  0x00000000000003fc, 0x00000000000001ff,
  0x00000000000005f4, 0x00000000000002fb,
  0x00000000000007e8, 0x00000000000003f5,
  0x00000000000001fc, 0x00000000000000ff,
  0x00000000000003f4, 0x00000000000001fb,
  0x00000000000005e8, 0x00000000000002f5,
  0x0000000000000668, 0x0000000000000335,
  0x00000000000001f8, 0x00000000000000fd,
  0x00000000000003ec, 0x00000000000001f7,
  0x000000000000046c, 0x0000000000000237,
  0x0000000000000478, 0x000000000000023d,
  0x00000000000001f4, 0x00000000000000fb,
  0x0000000000000274, 0x000000000000013b,
  0x0000000000000280, 0x0000000000000141,
  0x0000000000000288, 0x0000000000000145,
  0x0000000000000080, 0x0000000000000041,
  0x000000000000008c, 0x0000000000000047,
  0x0000000000000094, 0x000000000000004b,
  0x0000000000000098, 0x000000000000004d,
};
const unsigned kExpectedCount_NEON_sqdmlal2_2D_4S_S = 3844;

#endif  // VIXL_SIM_SQDMLAL2_2D_4S_S_TRACE_AARCH64_H_
