// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.12.3
// source: google/cloud/bigquery/v2/model.proto

package bigquery

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Indicates the type of the Model.
type Model_ModelType int32

const (
	Model_MODEL_TYPE_UNSPECIFIED Model_ModelType = 0
	// Linear regression model.
	Model_LINEAR_REGRESSION Model_ModelType = 1
	// Logistic regression based classification model.
	Model_LOGISTIC_REGRESSION Model_ModelType = 2
	// K-means clustering model.
	Model_KMEANS Model_ModelType = 3
	// [Beta] An imported TensorFlow model.
	Model_TENSORFLOW Model_ModelType = 6
)

// Enum value maps for Model_ModelType.
var (
	Model_ModelType_name = map[int32]string{
		0: "MODEL_TYPE_UNSPECIFIED",
		1: "LINEAR_REGRESSION",
		2: "LOGISTIC_REGRESSION",
		3: "KMEANS",
		6: "TENSORFLOW",
	}
	Model_ModelType_value = map[string]int32{
		"MODEL_TYPE_UNSPECIFIED": 0,
		"LINEAR_REGRESSION":      1,
		"LOGISTIC_REGRESSION":    2,
		"KMEANS":                 3,
		"TENSORFLOW":             6,
	}
)

func (x Model_ModelType) Enum() *Model_ModelType {
	p := new(Model_ModelType)
	*p = x
	return p
}

func (x Model_ModelType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Model_ModelType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_v2_model_proto_enumTypes[0].Descriptor()
}

func (Model_ModelType) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_v2_model_proto_enumTypes[0]
}

func (x Model_ModelType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Model_ModelType.Descriptor instead.
func (Model_ModelType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 0}
}

// Loss metric to evaluate model training performance.
type Model_LossType int32

const (
	Model_LOSS_TYPE_UNSPECIFIED Model_LossType = 0
	// Mean squared loss, used for linear regression.
	Model_MEAN_SQUARED_LOSS Model_LossType = 1
	// Mean log loss, used for logistic regression.
	Model_MEAN_LOG_LOSS Model_LossType = 2
)

// Enum value maps for Model_LossType.
var (
	Model_LossType_name = map[int32]string{
		0: "LOSS_TYPE_UNSPECIFIED",
		1: "MEAN_SQUARED_LOSS",
		2: "MEAN_LOG_LOSS",
	}
	Model_LossType_value = map[string]int32{
		"LOSS_TYPE_UNSPECIFIED": 0,
		"MEAN_SQUARED_LOSS":     1,
		"MEAN_LOG_LOSS":         2,
	}
)

func (x Model_LossType) Enum() *Model_LossType {
	p := new(Model_LossType)
	*p = x
	return p
}

func (x Model_LossType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Model_LossType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_v2_model_proto_enumTypes[1].Descriptor()
}

func (Model_LossType) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_v2_model_proto_enumTypes[1]
}

func (x Model_LossType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Model_LossType.Descriptor instead.
func (Model_LossType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 1}
}

// Distance metric used to compute the distance between two points.
type Model_DistanceType int32

const (
	Model_DISTANCE_TYPE_UNSPECIFIED Model_DistanceType = 0
	// Eculidean distance.
	Model_EUCLIDEAN Model_DistanceType = 1
	// Cosine distance.
	Model_COSINE Model_DistanceType = 2
)

// Enum value maps for Model_DistanceType.
var (
	Model_DistanceType_name = map[int32]string{
		0: "DISTANCE_TYPE_UNSPECIFIED",
		1: "EUCLIDEAN",
		2: "COSINE",
	}
	Model_DistanceType_value = map[string]int32{
		"DISTANCE_TYPE_UNSPECIFIED": 0,
		"EUCLIDEAN":                 1,
		"COSINE":                    2,
	}
)

func (x Model_DistanceType) Enum() *Model_DistanceType {
	p := new(Model_DistanceType)
	*p = x
	return p
}

func (x Model_DistanceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Model_DistanceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_v2_model_proto_enumTypes[2].Descriptor()
}

func (Model_DistanceType) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_v2_model_proto_enumTypes[2]
}

func (x Model_DistanceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Model_DistanceType.Descriptor instead.
func (Model_DistanceType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 2}
}

// Indicates the method to split input data into multiple tables.
type Model_DataSplitMethod int32

const (
	Model_DATA_SPLIT_METHOD_UNSPECIFIED Model_DataSplitMethod = 0
	// Splits data randomly.
	Model_RANDOM Model_DataSplitMethod = 1
	// Splits data with the user provided tags.
	Model_CUSTOM Model_DataSplitMethod = 2
	// Splits data sequentially.
	Model_SEQUENTIAL Model_DataSplitMethod = 3
	// Data split will be skipped.
	Model_NO_SPLIT Model_DataSplitMethod = 4
	// Splits data automatically: Uses NO_SPLIT if the data size is small.
	// Otherwise uses RANDOM.
	Model_AUTO_SPLIT Model_DataSplitMethod = 5
)

// Enum value maps for Model_DataSplitMethod.
var (
	Model_DataSplitMethod_name = map[int32]string{
		0: "DATA_SPLIT_METHOD_UNSPECIFIED",
		1: "RANDOM",
		2: "CUSTOM",
		3: "SEQUENTIAL",
		4: "NO_SPLIT",
		5: "AUTO_SPLIT",
	}
	Model_DataSplitMethod_value = map[string]int32{
		"DATA_SPLIT_METHOD_UNSPECIFIED": 0,
		"RANDOM":                        1,
		"CUSTOM":                        2,
		"SEQUENTIAL":                    3,
		"NO_SPLIT":                      4,
		"AUTO_SPLIT":                    5,
	}
)

func (x Model_DataSplitMethod) Enum() *Model_DataSplitMethod {
	p := new(Model_DataSplitMethod)
	*p = x
	return p
}

func (x Model_DataSplitMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Model_DataSplitMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_v2_model_proto_enumTypes[3].Descriptor()
}

func (Model_DataSplitMethod) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_v2_model_proto_enumTypes[3]
}

func (x Model_DataSplitMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Model_DataSplitMethod.Descriptor instead.
func (Model_DataSplitMethod) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 3}
}

// Indicates the learning rate optimization strategy to use.
type Model_LearnRateStrategy int32

const (
	Model_LEARN_RATE_STRATEGY_UNSPECIFIED Model_LearnRateStrategy = 0
	// Use line search to determine learning rate.
	Model_LINE_SEARCH Model_LearnRateStrategy = 1
	// Use a constant learning rate.
	Model_CONSTANT Model_LearnRateStrategy = 2
)

// Enum value maps for Model_LearnRateStrategy.
var (
	Model_LearnRateStrategy_name = map[int32]string{
		0: "LEARN_RATE_STRATEGY_UNSPECIFIED",
		1: "LINE_SEARCH",
		2: "CONSTANT",
	}
	Model_LearnRateStrategy_value = map[string]int32{
		"LEARN_RATE_STRATEGY_UNSPECIFIED": 0,
		"LINE_SEARCH":                     1,
		"CONSTANT":                        2,
	}
)

func (x Model_LearnRateStrategy) Enum() *Model_LearnRateStrategy {
	p := new(Model_LearnRateStrategy)
	*p = x
	return p
}

func (x Model_LearnRateStrategy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Model_LearnRateStrategy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_v2_model_proto_enumTypes[4].Descriptor()
}

func (Model_LearnRateStrategy) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_v2_model_proto_enumTypes[4]
}

func (x Model_LearnRateStrategy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Model_LearnRateStrategy.Descriptor instead.
func (Model_LearnRateStrategy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 4}
}

// Indicates the optimization strategy used for training.
type Model_OptimizationStrategy int32

const (
	Model_OPTIMIZATION_STRATEGY_UNSPECIFIED Model_OptimizationStrategy = 0
	// Uses an iterative batch gradient descent algorithm.
	Model_BATCH_GRADIENT_DESCENT Model_OptimizationStrategy = 1
	// Uses a normal equation to solve linear regression problem.
	Model_NORMAL_EQUATION Model_OptimizationStrategy = 2
)

// Enum value maps for Model_OptimizationStrategy.
var (
	Model_OptimizationStrategy_name = map[int32]string{
		0: "OPTIMIZATION_STRATEGY_UNSPECIFIED",
		1: "BATCH_GRADIENT_DESCENT",
		2: "NORMAL_EQUATION",
	}
	Model_OptimizationStrategy_value = map[string]int32{
		"OPTIMIZATION_STRATEGY_UNSPECIFIED": 0,
		"BATCH_GRADIENT_DESCENT":            1,
		"NORMAL_EQUATION":                   2,
	}
)

func (x Model_OptimizationStrategy) Enum() *Model_OptimizationStrategy {
	p := new(Model_OptimizationStrategy)
	*p = x
	return p
}

func (x Model_OptimizationStrategy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Model_OptimizationStrategy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_v2_model_proto_enumTypes[5].Descriptor()
}

func (Model_OptimizationStrategy) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_v2_model_proto_enumTypes[5]
}

func (x Model_OptimizationStrategy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Model_OptimizationStrategy.Descriptor instead.
func (Model_OptimizationStrategy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 5}
}

// Indicates the method used to initialize the centroids for KMeans
// clustering algorithm.
type Model_KmeansEnums_KmeansInitializationMethod int32

const (
	Model_KmeansEnums_KMEANS_INITIALIZATION_METHOD_UNSPECIFIED Model_KmeansEnums_KmeansInitializationMethod = 0
	// Initializes the centroids randomly.
	Model_KmeansEnums_RANDOM Model_KmeansEnums_KmeansInitializationMethod = 1
	// Initializes the centroids using data specified in
	// kmeans_initialization_column.
	Model_KmeansEnums_CUSTOM Model_KmeansEnums_KmeansInitializationMethod = 2
)

// Enum value maps for Model_KmeansEnums_KmeansInitializationMethod.
var (
	Model_KmeansEnums_KmeansInitializationMethod_name = map[int32]string{
		0: "KMEANS_INITIALIZATION_METHOD_UNSPECIFIED",
		1: "RANDOM",
		2: "CUSTOM",
	}
	Model_KmeansEnums_KmeansInitializationMethod_value = map[string]int32{
		"KMEANS_INITIALIZATION_METHOD_UNSPECIFIED": 0,
		"RANDOM": 1,
		"CUSTOM": 2,
	}
)

func (x Model_KmeansEnums_KmeansInitializationMethod) Enum() *Model_KmeansEnums_KmeansInitializationMethod {
	p := new(Model_KmeansEnums_KmeansInitializationMethod)
	*p = x
	return p
}

func (x Model_KmeansEnums_KmeansInitializationMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Model_KmeansEnums_KmeansInitializationMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_v2_model_proto_enumTypes[6].Descriptor()
}

func (Model_KmeansEnums_KmeansInitializationMethod) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_v2_model_proto_enumTypes[6]
}

func (x Model_KmeansEnums_KmeansInitializationMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Model_KmeansEnums_KmeansInitializationMethod.Descriptor instead.
func (Model_KmeansEnums_KmeansInitializationMethod) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 0, 0}
}

type Model struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. A hash of this resource.
	Etag string `protobuf:"bytes,1,opt,name=etag,proto3" json:"etag,omitempty"`
	// Required. Unique identifier for this model.
	ModelReference *ModelReference `protobuf:"bytes,2,opt,name=model_reference,json=modelReference,proto3" json:"model_reference,omitempty"`
	// Output only. The time when this model was created, in millisecs since the epoch.
	CreationTime int64 `protobuf:"varint,5,opt,name=creation_time,json=creationTime,proto3" json:"creation_time,omitempty"`
	// Output only. The time when this model was last modified, in millisecs since the epoch.
	LastModifiedTime int64 `protobuf:"varint,6,opt,name=last_modified_time,json=lastModifiedTime,proto3" json:"last_modified_time,omitempty"`
	// Optional. A user-friendly description of this model.
	Description string `protobuf:"bytes,12,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. A descriptive name for this model.
	FriendlyName string `protobuf:"bytes,14,opt,name=friendly_name,json=friendlyName,proto3" json:"friendly_name,omitempty"`
	// The labels associated with this model. You can use these to organize
	// and group your models. Label keys and values can be no longer
	// than 63 characters, can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// Label values are optional. Label keys must start with a letter and each
	// label in the list must have a different key.
	Labels map[string]string `protobuf:"bytes,15,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The time when this model expires, in milliseconds since the epoch.
	// If not present, the model will persist indefinitely. Expired models
	// will be deleted and their storage reclaimed.  The defaultTableExpirationMs
	// property of the encapsulating dataset can be used to set a default
	// expirationTime on newly created models.
	ExpirationTime int64 `protobuf:"varint,16,opt,name=expiration_time,json=expirationTime,proto3" json:"expiration_time,omitempty"`
	// Output only. The geographic location where the model resides. This value
	// is inherited from the dataset.
	Location string `protobuf:"bytes,13,opt,name=location,proto3" json:"location,omitempty"`
	// Custom encryption configuration (e.g., Cloud KMS keys). This shows the
	// encryption configuration of the model data while stored in BigQuery
	// storage.
	EncryptionConfiguration *EncryptionConfiguration `protobuf:"bytes,17,opt,name=encryption_configuration,json=encryptionConfiguration,proto3" json:"encryption_configuration,omitempty"`
	// Output only. Type of the model resource.
	ModelType Model_ModelType `protobuf:"varint,7,opt,name=model_type,json=modelType,proto3,enum=google.cloud.bigquery.v2.Model_ModelType" json:"model_type,omitempty"`
	// Output only. Information for all training runs in increasing order of start_time.
	TrainingRuns []*Model_TrainingRun `protobuf:"bytes,9,rep,name=training_runs,json=trainingRuns,proto3" json:"training_runs,omitempty"`
	// Output only. Input feature columns that were used to train this model.
	FeatureColumns []*StandardSqlField `protobuf:"bytes,10,rep,name=feature_columns,json=featureColumns,proto3" json:"feature_columns,omitempty"`
	// Output only. Label columns that were used to train this model.
	// The output of the model will have a "predicted_" prefix to these columns.
	LabelColumns []*StandardSqlField `protobuf:"bytes,11,rep,name=label_columns,json=labelColumns,proto3" json:"label_columns,omitempty"`
}

func (x *Model) Reset() {
	*x = Model{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model) ProtoMessage() {}

func (x *Model) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model.ProtoReflect.Descriptor instead.
func (*Model) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0}
}

func (x *Model) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Model) GetModelReference() *ModelReference {
	if x != nil {
		return x.ModelReference
	}
	return nil
}

func (x *Model) GetCreationTime() int64 {
	if x != nil {
		return x.CreationTime
	}
	return 0
}

func (x *Model) GetLastModifiedTime() int64 {
	if x != nil {
		return x.LastModifiedTime
	}
	return 0
}

func (x *Model) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Model) GetFriendlyName() string {
	if x != nil {
		return x.FriendlyName
	}
	return ""
}

func (x *Model) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Model) GetExpirationTime() int64 {
	if x != nil {
		return x.ExpirationTime
	}
	return 0
}

func (x *Model) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *Model) GetEncryptionConfiguration() *EncryptionConfiguration {
	if x != nil {
		return x.EncryptionConfiguration
	}
	return nil
}

func (x *Model) GetModelType() Model_ModelType {
	if x != nil {
		return x.ModelType
	}
	return Model_MODEL_TYPE_UNSPECIFIED
}

func (x *Model) GetTrainingRuns() []*Model_TrainingRun {
	if x != nil {
		return x.TrainingRuns
	}
	return nil
}

func (x *Model) GetFeatureColumns() []*StandardSqlField {
	if x != nil {
		return x.FeatureColumns
	}
	return nil
}

func (x *Model) GetLabelColumns() []*StandardSqlField {
	if x != nil {
		return x.LabelColumns
	}
	return nil
}

type GetModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Project ID of the requested model.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Dataset ID of the requested model.
	DatasetId string `protobuf:"bytes,2,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// Required. Model ID of the requested model.
	ModelId string `protobuf:"bytes,3,opt,name=model_id,json=modelId,proto3" json:"model_id,omitempty"`
}

func (x *GetModelRequest) Reset() {
	*x = GetModelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetModelRequest) ProtoMessage() {}

func (x *GetModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetModelRequest.ProtoReflect.Descriptor instead.
func (*GetModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{1}
}

func (x *GetModelRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *GetModelRequest) GetDatasetId() string {
	if x != nil {
		return x.DatasetId
	}
	return ""
}

func (x *GetModelRequest) GetModelId() string {
	if x != nil {
		return x.ModelId
	}
	return ""
}

type PatchModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Project ID of the model to patch.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Dataset ID of the model to patch.
	DatasetId string `protobuf:"bytes,2,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// Required. Model ID of the model to patch.
	ModelId string `protobuf:"bytes,3,opt,name=model_id,json=modelId,proto3" json:"model_id,omitempty"`
	// Required. Patched model.
	// Follows RFC5789 patch semantics. Missing fields are not updated.
	// To clear a field, explicitly set to default value.
	Model *Model `protobuf:"bytes,4,opt,name=model,proto3" json:"model,omitempty"`
}

func (x *PatchModelRequest) Reset() {
	*x = PatchModelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchModelRequest) ProtoMessage() {}

func (x *PatchModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchModelRequest.ProtoReflect.Descriptor instead.
func (*PatchModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{2}
}

func (x *PatchModelRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *PatchModelRequest) GetDatasetId() string {
	if x != nil {
		return x.DatasetId
	}
	return ""
}

func (x *PatchModelRequest) GetModelId() string {
	if x != nil {
		return x.ModelId
	}
	return ""
}

func (x *PatchModelRequest) GetModel() *Model {
	if x != nil {
		return x.Model
	}
	return nil
}

type DeleteModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Project ID of the model to delete.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Dataset ID of the model to delete.
	DatasetId string `protobuf:"bytes,2,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// Required. Model ID of the model to delete.
	ModelId string `protobuf:"bytes,3,opt,name=model_id,json=modelId,proto3" json:"model_id,omitempty"`
}

func (x *DeleteModelRequest) Reset() {
	*x = DeleteModelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteModelRequest) ProtoMessage() {}

func (x *DeleteModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteModelRequest.ProtoReflect.Descriptor instead.
func (*DeleteModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{3}
}

func (x *DeleteModelRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *DeleteModelRequest) GetDatasetId() string {
	if x != nil {
		return x.DatasetId
	}
	return ""
}

func (x *DeleteModelRequest) GetModelId() string {
	if x != nil {
		return x.ModelId
	}
	return ""
}

type ListModelsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Project ID of the models to list.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Dataset ID of the models to list.
	DatasetId string `protobuf:"bytes,2,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// The maximum number of results to return in a single response page.
	// Leverage the page tokens to iterate through the entire collection.
	MaxResults *wrapperspb.UInt32Value `protobuf:"bytes,3,opt,name=max_results,json=maxResults,proto3" json:"max_results,omitempty"`
	// Page token, returned by a previous call to request the next page of
	// results
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListModelsRequest) Reset() {
	*x = ListModelsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListModelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListModelsRequest) ProtoMessage() {}

func (x *ListModelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListModelsRequest.ProtoReflect.Descriptor instead.
func (*ListModelsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{4}
}

func (x *ListModelsRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *ListModelsRequest) GetDatasetId() string {
	if x != nil {
		return x.DatasetId
	}
	return ""
}

func (x *ListModelsRequest) GetMaxResults() *wrapperspb.UInt32Value {
	if x != nil {
		return x.MaxResults
	}
	return nil
}

func (x *ListModelsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

type ListModelsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Models in the requested dataset. Only the following fields are populated:
	// model_reference, model_type, creation_time, last_modified_time and
	// labels.
	Models []*Model `protobuf:"bytes,1,rep,name=models,proto3" json:"models,omitempty"`
	// A token to request the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListModelsResponse) Reset() {
	*x = ListModelsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListModelsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListModelsResponse) ProtoMessage() {}

func (x *ListModelsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListModelsResponse.ProtoReflect.Descriptor instead.
func (*ListModelsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{5}
}

func (x *ListModelsResponse) GetModels() []*Model {
	if x != nil {
		return x.Models
	}
	return nil
}

func (x *ListModelsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

type Model_KmeansEnums struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Model_KmeansEnums) Reset() {
	*x = Model_KmeansEnums{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_KmeansEnums) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_KmeansEnums) ProtoMessage() {}

func (x *Model_KmeansEnums) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_KmeansEnums.ProtoReflect.Descriptor instead.
func (*Model_KmeansEnums) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 0}
}

// Evaluation metrics for regression and explicit feedback type matrix
// factorization models.
type Model_RegressionMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Mean absolute error.
	MeanAbsoluteError *wrapperspb.DoubleValue `protobuf:"bytes,1,opt,name=mean_absolute_error,json=meanAbsoluteError,proto3" json:"mean_absolute_error,omitempty"`
	// Mean squared error.
	MeanSquaredError *wrapperspb.DoubleValue `protobuf:"bytes,2,opt,name=mean_squared_error,json=meanSquaredError,proto3" json:"mean_squared_error,omitempty"`
	// Mean squared log error.
	MeanSquaredLogError *wrapperspb.DoubleValue `protobuf:"bytes,3,opt,name=mean_squared_log_error,json=meanSquaredLogError,proto3" json:"mean_squared_log_error,omitempty"`
	// Median absolute error.
	MedianAbsoluteError *wrapperspb.DoubleValue `protobuf:"bytes,4,opt,name=median_absolute_error,json=medianAbsoluteError,proto3" json:"median_absolute_error,omitempty"`
	// R^2 score.
	RSquared *wrapperspb.DoubleValue `protobuf:"bytes,5,opt,name=r_squared,json=rSquared,proto3" json:"r_squared,omitempty"`
}

func (x *Model_RegressionMetrics) Reset() {
	*x = Model_RegressionMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_RegressionMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_RegressionMetrics) ProtoMessage() {}

func (x *Model_RegressionMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_RegressionMetrics.ProtoReflect.Descriptor instead.
func (*Model_RegressionMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Model_RegressionMetrics) GetMeanAbsoluteError() *wrapperspb.DoubleValue {
	if x != nil {
		return x.MeanAbsoluteError
	}
	return nil
}

func (x *Model_RegressionMetrics) GetMeanSquaredError() *wrapperspb.DoubleValue {
	if x != nil {
		return x.MeanSquaredError
	}
	return nil
}

func (x *Model_RegressionMetrics) GetMeanSquaredLogError() *wrapperspb.DoubleValue {
	if x != nil {
		return x.MeanSquaredLogError
	}
	return nil
}

func (x *Model_RegressionMetrics) GetMedianAbsoluteError() *wrapperspb.DoubleValue {
	if x != nil {
		return x.MedianAbsoluteError
	}
	return nil
}

func (x *Model_RegressionMetrics) GetRSquared() *wrapperspb.DoubleValue {
	if x != nil {
		return x.RSquared
	}
	return nil
}

// Aggregate metrics for classification/classifier models. For multi-class
// models, the metrics are either macro-averaged or micro-averaged. When
// macro-averaged, the metrics are calculated for each label and then an
// unweighted average is taken of those values. When micro-averaged, the
// metric is calculated globally by counting the total number of correctly
// predicted rows.
type Model_AggregateClassificationMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Precision is the fraction of actual positive predictions that had
	// positive actual labels. For multiclass this is a macro-averaged
	// metric treating each class as a binary classifier.
	Precision *wrapperspb.DoubleValue `protobuf:"bytes,1,opt,name=precision,proto3" json:"precision,omitempty"`
	// Recall is the fraction of actual positive labels that were given a
	// positive prediction. For multiclass this is a macro-averaged metric.
	Recall *wrapperspb.DoubleValue `protobuf:"bytes,2,opt,name=recall,proto3" json:"recall,omitempty"`
	// Accuracy is the fraction of predictions given the correct label. For
	// multiclass this is a micro-averaged metric.
	Accuracy *wrapperspb.DoubleValue `protobuf:"bytes,3,opt,name=accuracy,proto3" json:"accuracy,omitempty"`
	// Threshold at which the metrics are computed. For binary
	// classification models this is the positive class threshold.
	// For multi-class classfication models this is the confidence
	// threshold.
	Threshold *wrapperspb.DoubleValue `protobuf:"bytes,4,opt,name=threshold,proto3" json:"threshold,omitempty"`
	// The F1 score is an average of recall and precision. For multiclass
	// this is a macro-averaged metric.
	F1Score *wrapperspb.DoubleValue `protobuf:"bytes,5,opt,name=f1_score,json=f1Score,proto3" json:"f1_score,omitempty"`
	// Logarithmic Loss. For multiclass this is a macro-averaged metric.
	LogLoss *wrapperspb.DoubleValue `protobuf:"bytes,6,opt,name=log_loss,json=logLoss,proto3" json:"log_loss,omitempty"`
	// Area Under a ROC Curve. For multiclass this is a macro-averaged
	// metric.
	RocAuc *wrapperspb.DoubleValue `protobuf:"bytes,7,opt,name=roc_auc,json=rocAuc,proto3" json:"roc_auc,omitempty"`
}

func (x *Model_AggregateClassificationMetrics) Reset() {
	*x = Model_AggregateClassificationMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_AggregateClassificationMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_AggregateClassificationMetrics) ProtoMessage() {}

func (x *Model_AggregateClassificationMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_AggregateClassificationMetrics.ProtoReflect.Descriptor instead.
func (*Model_AggregateClassificationMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 2}
}

func (x *Model_AggregateClassificationMetrics) GetPrecision() *wrapperspb.DoubleValue {
	if x != nil {
		return x.Precision
	}
	return nil
}

func (x *Model_AggregateClassificationMetrics) GetRecall() *wrapperspb.DoubleValue {
	if x != nil {
		return x.Recall
	}
	return nil
}

func (x *Model_AggregateClassificationMetrics) GetAccuracy() *wrapperspb.DoubleValue {
	if x != nil {
		return x.Accuracy
	}
	return nil
}

func (x *Model_AggregateClassificationMetrics) GetThreshold() *wrapperspb.DoubleValue {
	if x != nil {
		return x.Threshold
	}
	return nil
}

func (x *Model_AggregateClassificationMetrics) GetF1Score() *wrapperspb.DoubleValue {
	if x != nil {
		return x.F1Score
	}
	return nil
}

func (x *Model_AggregateClassificationMetrics) GetLogLoss() *wrapperspb.DoubleValue {
	if x != nil {
		return x.LogLoss
	}
	return nil
}

func (x *Model_AggregateClassificationMetrics) GetRocAuc() *wrapperspb.DoubleValue {
	if x != nil {
		return x.RocAuc
	}
	return nil
}

// Evaluation metrics for binary classification/classifier models.
type Model_BinaryClassificationMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Aggregate classification metrics.
	AggregateClassificationMetrics *Model_AggregateClassificationMetrics `protobuf:"bytes,1,opt,name=aggregate_classification_metrics,json=aggregateClassificationMetrics,proto3" json:"aggregate_classification_metrics,omitempty"`
	// Binary confusion matrix at multiple thresholds.
	BinaryConfusionMatrixList []*Model_BinaryClassificationMetrics_BinaryConfusionMatrix `protobuf:"bytes,2,rep,name=binary_confusion_matrix_list,json=binaryConfusionMatrixList,proto3" json:"binary_confusion_matrix_list,omitempty"`
	// Label representing the positive class.
	PositiveLabel string `protobuf:"bytes,3,opt,name=positive_label,json=positiveLabel,proto3" json:"positive_label,omitempty"`
	// Label representing the negative class.
	NegativeLabel string `protobuf:"bytes,4,opt,name=negative_label,json=negativeLabel,proto3" json:"negative_label,omitempty"`
}

func (x *Model_BinaryClassificationMetrics) Reset() {
	*x = Model_BinaryClassificationMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_BinaryClassificationMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_BinaryClassificationMetrics) ProtoMessage() {}

func (x *Model_BinaryClassificationMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_BinaryClassificationMetrics.ProtoReflect.Descriptor instead.
func (*Model_BinaryClassificationMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 3}
}

func (x *Model_BinaryClassificationMetrics) GetAggregateClassificationMetrics() *Model_AggregateClassificationMetrics {
	if x != nil {
		return x.AggregateClassificationMetrics
	}
	return nil
}

func (x *Model_BinaryClassificationMetrics) GetBinaryConfusionMatrixList() []*Model_BinaryClassificationMetrics_BinaryConfusionMatrix {
	if x != nil {
		return x.BinaryConfusionMatrixList
	}
	return nil
}

func (x *Model_BinaryClassificationMetrics) GetPositiveLabel() string {
	if x != nil {
		return x.PositiveLabel
	}
	return ""
}

func (x *Model_BinaryClassificationMetrics) GetNegativeLabel() string {
	if x != nil {
		return x.NegativeLabel
	}
	return ""
}

// Evaluation metrics for multi-class classification/classifier models.
type Model_MultiClassClassificationMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Aggregate classification metrics.
	AggregateClassificationMetrics *Model_AggregateClassificationMetrics `protobuf:"bytes,1,opt,name=aggregate_classification_metrics,json=aggregateClassificationMetrics,proto3" json:"aggregate_classification_metrics,omitempty"`
	// Confusion matrix at different thresholds.
	ConfusionMatrixList []*Model_MultiClassClassificationMetrics_ConfusionMatrix `protobuf:"bytes,2,rep,name=confusion_matrix_list,json=confusionMatrixList,proto3" json:"confusion_matrix_list,omitempty"`
}

func (x *Model_MultiClassClassificationMetrics) Reset() {
	*x = Model_MultiClassClassificationMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_MultiClassClassificationMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_MultiClassClassificationMetrics) ProtoMessage() {}

func (x *Model_MultiClassClassificationMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_MultiClassClassificationMetrics.ProtoReflect.Descriptor instead.
func (*Model_MultiClassClassificationMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 4}
}

func (x *Model_MultiClassClassificationMetrics) GetAggregateClassificationMetrics() *Model_AggregateClassificationMetrics {
	if x != nil {
		return x.AggregateClassificationMetrics
	}
	return nil
}

func (x *Model_MultiClassClassificationMetrics) GetConfusionMatrixList() []*Model_MultiClassClassificationMetrics_ConfusionMatrix {
	if x != nil {
		return x.ConfusionMatrixList
	}
	return nil
}

// Evaluation metrics for clustering models.
type Model_ClusteringMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Davies-Bouldin index.
	DaviesBouldinIndex *wrapperspb.DoubleValue `protobuf:"bytes,1,opt,name=davies_bouldin_index,json=daviesBouldinIndex,proto3" json:"davies_bouldin_index,omitempty"`
	// Mean of squared distances between each sample to its cluster centroid.
	MeanSquaredDistance *wrapperspb.DoubleValue `protobuf:"bytes,2,opt,name=mean_squared_distance,json=meanSquaredDistance,proto3" json:"mean_squared_distance,omitempty"`
	// [Beta] Information for all clusters.
	Clusters []*Model_ClusteringMetrics_Cluster `protobuf:"bytes,3,rep,name=clusters,proto3" json:"clusters,omitempty"`
}

func (x *Model_ClusteringMetrics) Reset() {
	*x = Model_ClusteringMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_ClusteringMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_ClusteringMetrics) ProtoMessage() {}

func (x *Model_ClusteringMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_ClusteringMetrics.ProtoReflect.Descriptor instead.
func (*Model_ClusteringMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 5}
}

func (x *Model_ClusteringMetrics) GetDaviesBouldinIndex() *wrapperspb.DoubleValue {
	if x != nil {
		return x.DaviesBouldinIndex
	}
	return nil
}

func (x *Model_ClusteringMetrics) GetMeanSquaredDistance() *wrapperspb.DoubleValue {
	if x != nil {
		return x.MeanSquaredDistance
	}
	return nil
}

func (x *Model_ClusteringMetrics) GetClusters() []*Model_ClusteringMetrics_Cluster {
	if x != nil {
		return x.Clusters
	}
	return nil
}

// Evaluation metrics of a model. These are either computed on all training
// data or just the eval data based on whether eval data was used during
// training. These are not present for imported models.
type Model_EvaluationMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Metrics:
	//	*Model_EvaluationMetrics_RegressionMetrics
	//	*Model_EvaluationMetrics_BinaryClassificationMetrics
	//	*Model_EvaluationMetrics_MultiClassClassificationMetrics
	//	*Model_EvaluationMetrics_ClusteringMetrics
	Metrics isModel_EvaluationMetrics_Metrics `protobuf_oneof:"metrics"`
}

func (x *Model_EvaluationMetrics) Reset() {
	*x = Model_EvaluationMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_EvaluationMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_EvaluationMetrics) ProtoMessage() {}

func (x *Model_EvaluationMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_EvaluationMetrics.ProtoReflect.Descriptor instead.
func (*Model_EvaluationMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 6}
}

func (m *Model_EvaluationMetrics) GetMetrics() isModel_EvaluationMetrics_Metrics {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (x *Model_EvaluationMetrics) GetRegressionMetrics() *Model_RegressionMetrics {
	if x, ok := x.GetMetrics().(*Model_EvaluationMetrics_RegressionMetrics); ok {
		return x.RegressionMetrics
	}
	return nil
}

func (x *Model_EvaluationMetrics) GetBinaryClassificationMetrics() *Model_BinaryClassificationMetrics {
	if x, ok := x.GetMetrics().(*Model_EvaluationMetrics_BinaryClassificationMetrics); ok {
		return x.BinaryClassificationMetrics
	}
	return nil
}

func (x *Model_EvaluationMetrics) GetMultiClassClassificationMetrics() *Model_MultiClassClassificationMetrics {
	if x, ok := x.GetMetrics().(*Model_EvaluationMetrics_MultiClassClassificationMetrics); ok {
		return x.MultiClassClassificationMetrics
	}
	return nil
}

func (x *Model_EvaluationMetrics) GetClusteringMetrics() *Model_ClusteringMetrics {
	if x, ok := x.GetMetrics().(*Model_EvaluationMetrics_ClusteringMetrics); ok {
		return x.ClusteringMetrics
	}
	return nil
}

type isModel_EvaluationMetrics_Metrics interface {
	isModel_EvaluationMetrics_Metrics()
}

type Model_EvaluationMetrics_RegressionMetrics struct {
	// Populated for regression models and explicit feedback type matrix
	// factorization models.
	RegressionMetrics *Model_RegressionMetrics `protobuf:"bytes,1,opt,name=regression_metrics,json=regressionMetrics,proto3,oneof"`
}

type Model_EvaluationMetrics_BinaryClassificationMetrics struct {
	// Populated for binary classification/classifier models.
	BinaryClassificationMetrics *Model_BinaryClassificationMetrics `protobuf:"bytes,2,opt,name=binary_classification_metrics,json=binaryClassificationMetrics,proto3,oneof"`
}

type Model_EvaluationMetrics_MultiClassClassificationMetrics struct {
	// Populated for multi-class classification/classifier models.
	MultiClassClassificationMetrics *Model_MultiClassClassificationMetrics `protobuf:"bytes,3,opt,name=multi_class_classification_metrics,json=multiClassClassificationMetrics,proto3,oneof"`
}

type Model_EvaluationMetrics_ClusteringMetrics struct {
	// Populated for clustering models.
	ClusteringMetrics *Model_ClusteringMetrics `protobuf:"bytes,4,opt,name=clustering_metrics,json=clusteringMetrics,proto3,oneof"`
}

func (*Model_EvaluationMetrics_RegressionMetrics) isModel_EvaluationMetrics_Metrics() {}

func (*Model_EvaluationMetrics_BinaryClassificationMetrics) isModel_EvaluationMetrics_Metrics() {}

func (*Model_EvaluationMetrics_MultiClassClassificationMetrics) isModel_EvaluationMetrics_Metrics() {}

func (*Model_EvaluationMetrics_ClusteringMetrics) isModel_EvaluationMetrics_Metrics() {}

// Information about a single training query run for the model.
type Model_TrainingRun struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Options that were used for this training run, includes
	// user specified and default options that were used.
	TrainingOptions *Model_TrainingRun_TrainingOptions `protobuf:"bytes,1,opt,name=training_options,json=trainingOptions,proto3" json:"training_options,omitempty"`
	// The start time of this training run.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output of each iteration run, results.size() <= max_iterations.
	Results []*Model_TrainingRun_IterationResult `protobuf:"bytes,6,rep,name=results,proto3" json:"results,omitempty"`
	// The evaluation metrics over training/eval data that were computed at the
	// end of training.
	EvaluationMetrics *Model_EvaluationMetrics `protobuf:"bytes,7,opt,name=evaluation_metrics,json=evaluationMetrics,proto3" json:"evaluation_metrics,omitempty"`
}

func (x *Model_TrainingRun) Reset() {
	*x = Model_TrainingRun{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_TrainingRun) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_TrainingRun) ProtoMessage() {}

func (x *Model_TrainingRun) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_TrainingRun.ProtoReflect.Descriptor instead.
func (*Model_TrainingRun) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 7}
}

func (x *Model_TrainingRun) GetTrainingOptions() *Model_TrainingRun_TrainingOptions {
	if x != nil {
		return x.TrainingOptions
	}
	return nil
}

func (x *Model_TrainingRun) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Model_TrainingRun) GetResults() []*Model_TrainingRun_IterationResult {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *Model_TrainingRun) GetEvaluationMetrics() *Model_EvaluationMetrics {
	if x != nil {
		return x.EvaluationMetrics
	}
	return nil
}

// Confusion matrix for binary classification models.
type Model_BinaryClassificationMetrics_BinaryConfusionMatrix struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Threshold value used when computing each of the following metric.
	PositiveClassThreshold *wrapperspb.DoubleValue `protobuf:"bytes,1,opt,name=positive_class_threshold,json=positiveClassThreshold,proto3" json:"positive_class_threshold,omitempty"`
	// Number of true samples predicted as true.
	TruePositives *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=true_positives,json=truePositives,proto3" json:"true_positives,omitempty"`
	// Number of false samples predicted as true.
	FalsePositives *wrapperspb.Int64Value `protobuf:"bytes,3,opt,name=false_positives,json=falsePositives,proto3" json:"false_positives,omitempty"`
	// Number of true samples predicted as false.
	TrueNegatives *wrapperspb.Int64Value `protobuf:"bytes,4,opt,name=true_negatives,json=trueNegatives,proto3" json:"true_negatives,omitempty"`
	// Number of false samples predicted as false.
	FalseNegatives *wrapperspb.Int64Value `protobuf:"bytes,5,opt,name=false_negatives,json=falseNegatives,proto3" json:"false_negatives,omitempty"`
	// The fraction of actual positive predictions that had positive actual
	// labels.
	Precision *wrapperspb.DoubleValue `protobuf:"bytes,6,opt,name=precision,proto3" json:"precision,omitempty"`
	// The fraction of actual positive labels that were given a positive
	// prediction.
	Recall *wrapperspb.DoubleValue `protobuf:"bytes,7,opt,name=recall,proto3" json:"recall,omitempty"`
	// The equally weighted average of recall and precision.
	F1Score *wrapperspb.DoubleValue `protobuf:"bytes,8,opt,name=f1_score,json=f1Score,proto3" json:"f1_score,omitempty"`
	// The fraction of predictions given the correct label.
	Accuracy *wrapperspb.DoubleValue `protobuf:"bytes,9,opt,name=accuracy,proto3" json:"accuracy,omitempty"`
}

func (x *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) Reset() {
	*x = Model_BinaryClassificationMetrics_BinaryConfusionMatrix{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_BinaryClassificationMetrics_BinaryConfusionMatrix) ProtoMessage() {}

func (x *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_BinaryClassificationMetrics_BinaryConfusionMatrix.ProtoReflect.Descriptor instead.
func (*Model_BinaryClassificationMetrics_BinaryConfusionMatrix) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 3, 0}
}

func (x *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) GetPositiveClassThreshold() *wrapperspb.DoubleValue {
	if x != nil {
		return x.PositiveClassThreshold
	}
	return nil
}

func (x *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) GetTruePositives() *wrapperspb.Int64Value {
	if x != nil {
		return x.TruePositives
	}
	return nil
}

func (x *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) GetFalsePositives() *wrapperspb.Int64Value {
	if x != nil {
		return x.FalsePositives
	}
	return nil
}

func (x *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) GetTrueNegatives() *wrapperspb.Int64Value {
	if x != nil {
		return x.TrueNegatives
	}
	return nil
}

func (x *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) GetFalseNegatives() *wrapperspb.Int64Value {
	if x != nil {
		return x.FalseNegatives
	}
	return nil
}

func (x *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) GetPrecision() *wrapperspb.DoubleValue {
	if x != nil {
		return x.Precision
	}
	return nil
}

func (x *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) GetRecall() *wrapperspb.DoubleValue {
	if x != nil {
		return x.Recall
	}
	return nil
}

func (x *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) GetF1Score() *wrapperspb.DoubleValue {
	if x != nil {
		return x.F1Score
	}
	return nil
}

func (x *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) GetAccuracy() *wrapperspb.DoubleValue {
	if x != nil {
		return x.Accuracy
	}
	return nil
}

// Confusion matrix for multi-class classification models.
type Model_MultiClassClassificationMetrics_ConfusionMatrix struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Confidence threshold used when computing the entries of the
	// confusion matrix.
	ConfidenceThreshold *wrapperspb.DoubleValue `protobuf:"bytes,1,opt,name=confidence_threshold,json=confidenceThreshold,proto3" json:"confidence_threshold,omitempty"`
	// One row per actual label.
	Rows []*Model_MultiClassClassificationMetrics_ConfusionMatrix_Row `protobuf:"bytes,2,rep,name=rows,proto3" json:"rows,omitempty"`
}

func (x *Model_MultiClassClassificationMetrics_ConfusionMatrix) Reset() {
	*x = Model_MultiClassClassificationMetrics_ConfusionMatrix{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_MultiClassClassificationMetrics_ConfusionMatrix) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_MultiClassClassificationMetrics_ConfusionMatrix) ProtoMessage() {}

func (x *Model_MultiClassClassificationMetrics_ConfusionMatrix) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_MultiClassClassificationMetrics_ConfusionMatrix.ProtoReflect.Descriptor instead.
func (*Model_MultiClassClassificationMetrics_ConfusionMatrix) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 4, 0}
}

func (x *Model_MultiClassClassificationMetrics_ConfusionMatrix) GetConfidenceThreshold() *wrapperspb.DoubleValue {
	if x != nil {
		return x.ConfidenceThreshold
	}
	return nil
}

func (x *Model_MultiClassClassificationMetrics_ConfusionMatrix) GetRows() []*Model_MultiClassClassificationMetrics_ConfusionMatrix_Row {
	if x != nil {
		return x.Rows
	}
	return nil
}

// A single entry in the confusion matrix.
type Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The predicted label. For confidence_threshold > 0, we will
	// also add an entry indicating the number of items under the
	// confidence threshold.
	PredictedLabel string `protobuf:"bytes,1,opt,name=predicted_label,json=predictedLabel,proto3" json:"predicted_label,omitempty"`
	// Number of items being predicted as this label.
	ItemCount *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=item_count,json=itemCount,proto3" json:"item_count,omitempty"`
}

func (x *Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry) Reset() {
	*x = Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry) ProtoMessage() {}

func (x *Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry.ProtoReflect.Descriptor instead.
func (*Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 4, 0, 0}
}

func (x *Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry) GetPredictedLabel() string {
	if x != nil {
		return x.PredictedLabel
	}
	return ""
}

func (x *Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry) GetItemCount() *wrapperspb.Int64Value {
	if x != nil {
		return x.ItemCount
	}
	return nil
}

// A single row in the confusion matrix.
type Model_MultiClassClassificationMetrics_ConfusionMatrix_Row struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The original label of this row.
	ActualLabel string `protobuf:"bytes,1,opt,name=actual_label,json=actualLabel,proto3" json:"actual_label,omitempty"`
	// Info describing predicted label distribution.
	Entries []*Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry `protobuf:"bytes,2,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (x *Model_MultiClassClassificationMetrics_ConfusionMatrix_Row) Reset() {
	*x = Model_MultiClassClassificationMetrics_ConfusionMatrix_Row{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_MultiClassClassificationMetrics_ConfusionMatrix_Row) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_MultiClassClassificationMetrics_ConfusionMatrix_Row) ProtoMessage() {}

func (x *Model_MultiClassClassificationMetrics_ConfusionMatrix_Row) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_MultiClassClassificationMetrics_ConfusionMatrix_Row.ProtoReflect.Descriptor instead.
func (*Model_MultiClassClassificationMetrics_ConfusionMatrix_Row) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 4, 0, 1}
}

func (x *Model_MultiClassClassificationMetrics_ConfusionMatrix_Row) GetActualLabel() string {
	if x != nil {
		return x.ActualLabel
	}
	return ""
}

func (x *Model_MultiClassClassificationMetrics_ConfusionMatrix_Row) GetEntries() []*Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry {
	if x != nil {
		return x.Entries
	}
	return nil
}

// Message containing the information about one cluster.
type Model_ClusteringMetrics_Cluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Centroid id.
	CentroidId int64 `protobuf:"varint,1,opt,name=centroid_id,json=centroidId,proto3" json:"centroid_id,omitempty"`
	// Values of highly variant features for this cluster.
	FeatureValues []*Model_ClusteringMetrics_Cluster_FeatureValue `protobuf:"bytes,2,rep,name=feature_values,json=featureValues,proto3" json:"feature_values,omitempty"`
	// Count of training data rows that were assigned to this cluster.
	Count *wrapperspb.Int64Value `protobuf:"bytes,3,opt,name=count,proto3" json:"count,omitempty"`
}

func (x *Model_ClusteringMetrics_Cluster) Reset() {
	*x = Model_ClusteringMetrics_Cluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_ClusteringMetrics_Cluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_ClusteringMetrics_Cluster) ProtoMessage() {}

func (x *Model_ClusteringMetrics_Cluster) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_ClusteringMetrics_Cluster.ProtoReflect.Descriptor instead.
func (*Model_ClusteringMetrics_Cluster) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 5, 0}
}

func (x *Model_ClusteringMetrics_Cluster) GetCentroidId() int64 {
	if x != nil {
		return x.CentroidId
	}
	return 0
}

func (x *Model_ClusteringMetrics_Cluster) GetFeatureValues() []*Model_ClusteringMetrics_Cluster_FeatureValue {
	if x != nil {
		return x.FeatureValues
	}
	return nil
}

func (x *Model_ClusteringMetrics_Cluster) GetCount() *wrapperspb.Int64Value {
	if x != nil {
		return x.Count
	}
	return nil
}

// Representative value of a single feature within the cluster.
type Model_ClusteringMetrics_Cluster_FeatureValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The feature column name.
	FeatureColumn string `protobuf:"bytes,1,opt,name=feature_column,json=featureColumn,proto3" json:"feature_column,omitempty"`
	// Types that are assignable to Value:
	//	*Model_ClusteringMetrics_Cluster_FeatureValue_NumericalValue
	//	*Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_
	Value isModel_ClusteringMetrics_Cluster_FeatureValue_Value `protobuf_oneof:"value"`
}

func (x *Model_ClusteringMetrics_Cluster_FeatureValue) Reset() {
	*x = Model_ClusteringMetrics_Cluster_FeatureValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_ClusteringMetrics_Cluster_FeatureValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_ClusteringMetrics_Cluster_FeatureValue) ProtoMessage() {}

func (x *Model_ClusteringMetrics_Cluster_FeatureValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_ClusteringMetrics_Cluster_FeatureValue.ProtoReflect.Descriptor instead.
func (*Model_ClusteringMetrics_Cluster_FeatureValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 5, 0, 0}
}

func (x *Model_ClusteringMetrics_Cluster_FeatureValue) GetFeatureColumn() string {
	if x != nil {
		return x.FeatureColumn
	}
	return ""
}

func (m *Model_ClusteringMetrics_Cluster_FeatureValue) GetValue() isModel_ClusteringMetrics_Cluster_FeatureValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *Model_ClusteringMetrics_Cluster_FeatureValue) GetNumericalValue() *wrapperspb.DoubleValue {
	if x, ok := x.GetValue().(*Model_ClusteringMetrics_Cluster_FeatureValue_NumericalValue); ok {
		return x.NumericalValue
	}
	return nil
}

func (x *Model_ClusteringMetrics_Cluster_FeatureValue) GetCategoricalValue() *Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue {
	if x, ok := x.GetValue().(*Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_); ok {
		return x.CategoricalValue
	}
	return nil
}

type isModel_ClusteringMetrics_Cluster_FeatureValue_Value interface {
	isModel_ClusteringMetrics_Cluster_FeatureValue_Value()
}

type Model_ClusteringMetrics_Cluster_FeatureValue_NumericalValue struct {
	// The numerical feature value. This is the centroid value for this
	// feature.
	NumericalValue *wrapperspb.DoubleValue `protobuf:"bytes,2,opt,name=numerical_value,json=numericalValue,proto3,oneof"`
}

type Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_ struct {
	// The categorical feature value.
	CategoricalValue *Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue `protobuf:"bytes,3,opt,name=categorical_value,json=categoricalValue,proto3,oneof"`
}

func (*Model_ClusteringMetrics_Cluster_FeatureValue_NumericalValue) isModel_ClusteringMetrics_Cluster_FeatureValue_Value() {
}

func (*Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_) isModel_ClusteringMetrics_Cluster_FeatureValue_Value() {
}

// Representative value of a categorical feature.
type Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Counts of all categories for the categorical feature. If there are
	// more than ten categories, we return top ten (by count) and return
	// one more CategoryCount with category "_OTHER_" and count as
	// aggregate counts of remaining categories.
	CategoryCounts []*Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_CategoryCount `protobuf:"bytes,1,rep,name=category_counts,json=categoryCounts,proto3" json:"category_counts,omitempty"`
}

func (x *Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue) Reset() {
	*x = Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue) ProtoMessage() {}

func (x *Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue.ProtoReflect.Descriptor instead.
func (*Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 5, 0, 0, 0}
}

func (x *Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue) GetCategoryCounts() []*Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_CategoryCount {
	if x != nil {
		return x.CategoryCounts
	}
	return nil
}

// Represents the count of a single category within the cluster.
type Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_CategoryCount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of category.
	Category string `protobuf:"bytes,1,opt,name=category,proto3" json:"category,omitempty"`
	// The count of training samples matching the category within the
	// cluster.
	Count *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=count,proto3" json:"count,omitempty"`
}

func (x *Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_CategoryCount) Reset() {
	*x = Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_CategoryCount{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_CategoryCount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_CategoryCount) ProtoMessage() {}

func (x *Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_CategoryCount) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_CategoryCount.ProtoReflect.Descriptor instead.
func (*Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_CategoryCount) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 5, 0, 0, 0, 0}
}

func (x *Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_CategoryCount) GetCategory() string {
	if x != nil {
		return x.Category
	}
	return ""
}

func (x *Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_CategoryCount) GetCount() *wrapperspb.Int64Value {
	if x != nil {
		return x.Count
	}
	return nil
}

type Model_TrainingRun_TrainingOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum number of iterations in training. Used only for iterative
	// training algorithms.
	MaxIterations int64 `protobuf:"varint,1,opt,name=max_iterations,json=maxIterations,proto3" json:"max_iterations,omitempty"`
	// Type of loss function used during training run.
	LossType Model_LossType `protobuf:"varint,2,opt,name=loss_type,json=lossType,proto3,enum=google.cloud.bigquery.v2.Model_LossType" json:"loss_type,omitempty"`
	// Learning rate in training. Used only for iterative training algorithms.
	LearnRate float64 `protobuf:"fixed64,3,opt,name=learn_rate,json=learnRate,proto3" json:"learn_rate,omitempty"`
	// L1 regularization coefficient.
	L1Regularization *wrapperspb.DoubleValue `protobuf:"bytes,4,opt,name=l1_regularization,json=l1Regularization,proto3" json:"l1_regularization,omitempty"`
	// L2 regularization coefficient.
	L2Regularization *wrapperspb.DoubleValue `protobuf:"bytes,5,opt,name=l2_regularization,json=l2Regularization,proto3" json:"l2_regularization,omitempty"`
	// When early_stop is true, stops training when accuracy improvement is
	// less than 'min_relative_progress'. Used only for iterative training
	// algorithms.
	MinRelativeProgress *wrapperspb.DoubleValue `protobuf:"bytes,6,opt,name=min_relative_progress,json=minRelativeProgress,proto3" json:"min_relative_progress,omitempty"`
	// Whether to train a model from the last checkpoint.
	WarmStart *wrapperspb.BoolValue `protobuf:"bytes,7,opt,name=warm_start,json=warmStart,proto3" json:"warm_start,omitempty"`
	// Whether to stop early when the loss doesn't improve significantly
	// any more (compared to min_relative_progress). Used only for iterative
	// training algorithms.
	EarlyStop *wrapperspb.BoolValue `protobuf:"bytes,8,opt,name=early_stop,json=earlyStop,proto3" json:"early_stop,omitempty"`
	// Name of input label columns in training data.
	InputLabelColumns []string `protobuf:"bytes,9,rep,name=input_label_columns,json=inputLabelColumns,proto3" json:"input_label_columns,omitempty"`
	// The data split type for training and evaluation, e.g. RANDOM.
	DataSplitMethod Model_DataSplitMethod `protobuf:"varint,10,opt,name=data_split_method,json=dataSplitMethod,proto3,enum=google.cloud.bigquery.v2.Model_DataSplitMethod" json:"data_split_method,omitempty"`
	// The fraction of evaluation data over the whole input data. The rest
	// of data will be used as training data. The format should be double.
	// Accurate to two decimal places.
	// Default value is 0.2.
	DataSplitEvalFraction float64 `protobuf:"fixed64,11,opt,name=data_split_eval_fraction,json=dataSplitEvalFraction,proto3" json:"data_split_eval_fraction,omitempty"`
	// The column to split data with. This column won't be used as a
	// feature.
	// 1. When data_split_method is CUSTOM, the corresponding column should
	// be boolean. The rows with true value tag are eval data, and the false
	// are training data.
	// 2. When data_split_method is SEQ, the first DATA_SPLIT_EVAL_FRACTION
	// rows (from smallest to largest) in the corresponding column are used
	// as training data, and the rest are eval data. It respects the order
	// in Orderable data types:
	// https://cloud.google.com/bigquery/docs/reference/standard-sql/data-types#data-type-properties
	DataSplitColumn string `protobuf:"bytes,12,opt,name=data_split_column,json=dataSplitColumn,proto3" json:"data_split_column,omitempty"`
	// The strategy to determine learn rate for the current iteration.
	LearnRateStrategy Model_LearnRateStrategy `protobuf:"varint,13,opt,name=learn_rate_strategy,json=learnRateStrategy,proto3,enum=google.cloud.bigquery.v2.Model_LearnRateStrategy" json:"learn_rate_strategy,omitempty"`
	// Specifies the initial learning rate for the line search learn rate
	// strategy.
	InitialLearnRate float64 `protobuf:"fixed64,16,opt,name=initial_learn_rate,json=initialLearnRate,proto3" json:"initial_learn_rate,omitempty"`
	// Weights associated with each label class, for rebalancing the
	// training data. Only applicable for classification models.
	LabelClassWeights map[string]float64 `protobuf:"bytes,17,rep,name=label_class_weights,json=labelClassWeights,proto3" json:"label_class_weights,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"fixed64,2,opt,name=value,proto3"`
	// Distance type for clustering models.
	DistanceType Model_DistanceType `protobuf:"varint,20,opt,name=distance_type,json=distanceType,proto3,enum=google.cloud.bigquery.v2.Model_DistanceType" json:"distance_type,omitempty"`
	// Number of clusters for clustering models.
	NumClusters int64 `protobuf:"varint,21,opt,name=num_clusters,json=numClusters,proto3" json:"num_clusters,omitempty"`
	// [Beta] Google Cloud Storage URI from which the model was imported. Only
	// applicable for imported models.
	ModelUri string `protobuf:"bytes,22,opt,name=model_uri,json=modelUri,proto3" json:"model_uri,omitempty"`
	// Optimization strategy for training linear regression models.
	OptimizationStrategy Model_OptimizationStrategy `protobuf:"varint,23,opt,name=optimization_strategy,json=optimizationStrategy,proto3,enum=google.cloud.bigquery.v2.Model_OptimizationStrategy" json:"optimization_strategy,omitempty"`
	// The method used to initialize the centroids for kmeans algorithm.
	KmeansInitializationMethod Model_KmeansEnums_KmeansInitializationMethod `protobuf:"varint,33,opt,name=kmeans_initialization_method,json=kmeansInitializationMethod,proto3,enum=google.cloud.bigquery.v2.Model_KmeansEnums_KmeansInitializationMethod" json:"kmeans_initialization_method,omitempty"`
	// The column used to provide the initial centroids for kmeans algorithm
	// when kmeans_initialization_method is CUSTOM.
	KmeansInitializationColumn string `protobuf:"bytes,34,opt,name=kmeans_initialization_column,json=kmeansInitializationColumn,proto3" json:"kmeans_initialization_column,omitempty"`
}

func (x *Model_TrainingRun_TrainingOptions) Reset() {
	*x = Model_TrainingRun_TrainingOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_TrainingRun_TrainingOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_TrainingRun_TrainingOptions) ProtoMessage() {}

func (x *Model_TrainingRun_TrainingOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_TrainingRun_TrainingOptions.ProtoReflect.Descriptor instead.
func (*Model_TrainingRun_TrainingOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 7, 0}
}

func (x *Model_TrainingRun_TrainingOptions) GetMaxIterations() int64 {
	if x != nil {
		return x.MaxIterations
	}
	return 0
}

func (x *Model_TrainingRun_TrainingOptions) GetLossType() Model_LossType {
	if x != nil {
		return x.LossType
	}
	return Model_LOSS_TYPE_UNSPECIFIED
}

func (x *Model_TrainingRun_TrainingOptions) GetLearnRate() float64 {
	if x != nil {
		return x.LearnRate
	}
	return 0
}

func (x *Model_TrainingRun_TrainingOptions) GetL1Regularization() *wrapperspb.DoubleValue {
	if x != nil {
		return x.L1Regularization
	}
	return nil
}

func (x *Model_TrainingRun_TrainingOptions) GetL2Regularization() *wrapperspb.DoubleValue {
	if x != nil {
		return x.L2Regularization
	}
	return nil
}

func (x *Model_TrainingRun_TrainingOptions) GetMinRelativeProgress() *wrapperspb.DoubleValue {
	if x != nil {
		return x.MinRelativeProgress
	}
	return nil
}

func (x *Model_TrainingRun_TrainingOptions) GetWarmStart() *wrapperspb.BoolValue {
	if x != nil {
		return x.WarmStart
	}
	return nil
}

func (x *Model_TrainingRun_TrainingOptions) GetEarlyStop() *wrapperspb.BoolValue {
	if x != nil {
		return x.EarlyStop
	}
	return nil
}

func (x *Model_TrainingRun_TrainingOptions) GetInputLabelColumns() []string {
	if x != nil {
		return x.InputLabelColumns
	}
	return nil
}

func (x *Model_TrainingRun_TrainingOptions) GetDataSplitMethod() Model_DataSplitMethod {
	if x != nil {
		return x.DataSplitMethod
	}
	return Model_DATA_SPLIT_METHOD_UNSPECIFIED
}

func (x *Model_TrainingRun_TrainingOptions) GetDataSplitEvalFraction() float64 {
	if x != nil {
		return x.DataSplitEvalFraction
	}
	return 0
}

func (x *Model_TrainingRun_TrainingOptions) GetDataSplitColumn() string {
	if x != nil {
		return x.DataSplitColumn
	}
	return ""
}

func (x *Model_TrainingRun_TrainingOptions) GetLearnRateStrategy() Model_LearnRateStrategy {
	if x != nil {
		return x.LearnRateStrategy
	}
	return Model_LEARN_RATE_STRATEGY_UNSPECIFIED
}

func (x *Model_TrainingRun_TrainingOptions) GetInitialLearnRate() float64 {
	if x != nil {
		return x.InitialLearnRate
	}
	return 0
}

func (x *Model_TrainingRun_TrainingOptions) GetLabelClassWeights() map[string]float64 {
	if x != nil {
		return x.LabelClassWeights
	}
	return nil
}

func (x *Model_TrainingRun_TrainingOptions) GetDistanceType() Model_DistanceType {
	if x != nil {
		return x.DistanceType
	}
	return Model_DISTANCE_TYPE_UNSPECIFIED
}

func (x *Model_TrainingRun_TrainingOptions) GetNumClusters() int64 {
	if x != nil {
		return x.NumClusters
	}
	return 0
}

func (x *Model_TrainingRun_TrainingOptions) GetModelUri() string {
	if x != nil {
		return x.ModelUri
	}
	return ""
}

func (x *Model_TrainingRun_TrainingOptions) GetOptimizationStrategy() Model_OptimizationStrategy {
	if x != nil {
		return x.OptimizationStrategy
	}
	return Model_OPTIMIZATION_STRATEGY_UNSPECIFIED
}

func (x *Model_TrainingRun_TrainingOptions) GetKmeansInitializationMethod() Model_KmeansEnums_KmeansInitializationMethod {
	if x != nil {
		return x.KmeansInitializationMethod
	}
	return Model_KmeansEnums_KMEANS_INITIALIZATION_METHOD_UNSPECIFIED
}

func (x *Model_TrainingRun_TrainingOptions) GetKmeansInitializationColumn() string {
	if x != nil {
		return x.KmeansInitializationColumn
	}
	return ""
}

// Information about a single iteration of the training run.
type Model_TrainingRun_IterationResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Index of the iteration, 0 based.
	Index *wrapperspb.Int32Value `protobuf:"bytes,1,opt,name=index,proto3" json:"index,omitempty"`
	// Time taken to run the iteration in milliseconds.
	DurationMs *wrapperspb.Int64Value `protobuf:"bytes,4,opt,name=duration_ms,json=durationMs,proto3" json:"duration_ms,omitempty"`
	// Loss computed on the training data at the end of iteration.
	TrainingLoss *wrapperspb.DoubleValue `protobuf:"bytes,5,opt,name=training_loss,json=trainingLoss,proto3" json:"training_loss,omitempty"`
	// Loss computed on the eval data at the end of iteration.
	EvalLoss *wrapperspb.DoubleValue `protobuf:"bytes,6,opt,name=eval_loss,json=evalLoss,proto3" json:"eval_loss,omitempty"`
	// Learn rate used for this iteration.
	LearnRate float64 `protobuf:"fixed64,7,opt,name=learn_rate,json=learnRate,proto3" json:"learn_rate,omitempty"`
	// Information about top clusters for clustering models.
	ClusterInfos []*Model_TrainingRun_IterationResult_ClusterInfo `protobuf:"bytes,8,rep,name=cluster_infos,json=clusterInfos,proto3" json:"cluster_infos,omitempty"`
}

func (x *Model_TrainingRun_IterationResult) Reset() {
	*x = Model_TrainingRun_IterationResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_TrainingRun_IterationResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_TrainingRun_IterationResult) ProtoMessage() {}

func (x *Model_TrainingRun_IterationResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_TrainingRun_IterationResult.ProtoReflect.Descriptor instead.
func (*Model_TrainingRun_IterationResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 7, 1}
}

func (x *Model_TrainingRun_IterationResult) GetIndex() *wrapperspb.Int32Value {
	if x != nil {
		return x.Index
	}
	return nil
}

func (x *Model_TrainingRun_IterationResult) GetDurationMs() *wrapperspb.Int64Value {
	if x != nil {
		return x.DurationMs
	}
	return nil
}

func (x *Model_TrainingRun_IterationResult) GetTrainingLoss() *wrapperspb.DoubleValue {
	if x != nil {
		return x.TrainingLoss
	}
	return nil
}

func (x *Model_TrainingRun_IterationResult) GetEvalLoss() *wrapperspb.DoubleValue {
	if x != nil {
		return x.EvalLoss
	}
	return nil
}

func (x *Model_TrainingRun_IterationResult) GetLearnRate() float64 {
	if x != nil {
		return x.LearnRate
	}
	return 0
}

func (x *Model_TrainingRun_IterationResult) GetClusterInfos() []*Model_TrainingRun_IterationResult_ClusterInfo {
	if x != nil {
		return x.ClusterInfos
	}
	return nil
}

// Information about a single cluster for clustering model.
type Model_TrainingRun_IterationResult_ClusterInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Centroid id.
	CentroidId int64 `protobuf:"varint,1,opt,name=centroid_id,json=centroidId,proto3" json:"centroid_id,omitempty"`
	// Cluster radius, the average distance from centroid
	// to each point assigned to the cluster.
	ClusterRadius *wrapperspb.DoubleValue `protobuf:"bytes,2,opt,name=cluster_radius,json=clusterRadius,proto3" json:"cluster_radius,omitempty"`
	// Cluster size, the total number of points assigned to the cluster.
	ClusterSize *wrapperspb.Int64Value `protobuf:"bytes,3,opt,name=cluster_size,json=clusterSize,proto3" json:"cluster_size,omitempty"`
}

func (x *Model_TrainingRun_IterationResult_ClusterInfo) Reset() {
	*x = Model_TrainingRun_IterationResult_ClusterInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Model_TrainingRun_IterationResult_ClusterInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Model_TrainingRun_IterationResult_ClusterInfo) ProtoMessage() {}

func (x *Model_TrainingRun_IterationResult_ClusterInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_v2_model_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Model_TrainingRun_IterationResult_ClusterInfo.ProtoReflect.Descriptor instead.
func (*Model_TrainingRun_IterationResult_ClusterInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_v2_model_proto_rawDescGZIP(), []int{0, 7, 1, 0}
}

func (x *Model_TrainingRun_IterationResult_ClusterInfo) GetCentroidId() int64 {
	if x != nil {
		return x.CentroidId
	}
	return 0
}

func (x *Model_TrainingRun_IterationResult_ClusterInfo) GetClusterRadius() *wrapperspb.DoubleValue {
	if x != nil {
		return x.ClusterRadius
	}
	return nil
}

func (x *Model_TrainingRun_IterationResult_ClusterInfo) GetClusterSize() *wrapperspb.Int64Value {
	if x != nil {
		return x.ClusterSize
	}
	return nil
}

var File_google_cloud_bigquery_v2_model_proto protoreflect.FileDescriptor

var file_google_cloud_bigquery_v2_model_proto_rawDesc = []byte{
	0x0a, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x76, 0x32, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32,
	0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2f, 0x76, 0x32, 0x2f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2f, 0x76, 0x32, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x5f,
	0x73, 0x71, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8a, 0x41, 0x0a, 0x05, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12,
	0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x56, 0x0a, 0x0f, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x12, 0x28, 0x0a, 0x0d, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x31, 0x0a, 0x12, 0x6c, 0x61,
	0x73, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x6c, 0x61, 0x73,
	0x74, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x25, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0d, 0x66, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x6c, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0c, 0x66, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x6c, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x43,
	0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x12, 0x2c, 0x0a, 0x0f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0e, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x1f, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x6c, 0x0a, 0x18, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x11,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e,
	0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x17, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x4d, 0x0a, 0x0a, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x55, 0x0a, 0x0d, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x75, 0x6e, 0x73,
	0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76,
	0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67,
	0x52, 0x75, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69,
	0x6e, 0x67, 0x52, 0x75, 0x6e, 0x73, 0x12, 0x58, 0x0a, 0x0f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x6e, 0x64,
	0x61, 0x72, 0x64, 0x53, 0x71, 0x6c, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0e, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73,
	0x12, 0x54, 0x0a, 0x0d, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e,
	0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x76, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x53, 0x71, 0x6c, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x43,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x1a, 0x71, 0x0a, 0x0b, 0x4b, 0x6d, 0x65, 0x61, 0x6e, 0x73,
	0x45, 0x6e, 0x75, 0x6d, 0x73, 0x22, 0x62, 0x0a, 0x1a, 0x4b, 0x6d, 0x65, 0x61, 0x6e, 0x73, 0x49,
	0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x68, 0x6f, 0x64, 0x12, 0x2c, 0x0a, 0x28, 0x4b, 0x4d, 0x45, 0x41, 0x4e, 0x53, 0x5f, 0x49, 0x4e,
	0x49, 0x54, 0x49, 0x41, 0x4c, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x45, 0x54,
	0x48, 0x4f, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0a, 0x0a, 0x06, 0x52, 0x41, 0x4e, 0x44, 0x4f, 0x4d, 0x10, 0x01, 0x12, 0x0a, 0x0a,
	0x06, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x10, 0x02, 0x1a, 0x8d, 0x03, 0x0a, 0x11, 0x52, 0x65,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12,
	0x4c, 0x0a, 0x13, 0x6d, 0x65, 0x61, 0x6e, 0x5f, 0x61, 0x62, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x65,
	0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x11, 0x6d, 0x65, 0x61, 0x6e,
	0x41, 0x62, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x65, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x4a, 0x0a,
	0x12, 0x6d, 0x65, 0x61, 0x6e, 0x5f, 0x73, 0x71, 0x75, 0x61, 0x72, 0x65, 0x64, 0x5f, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62,
	0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x10, 0x6d, 0x65, 0x61, 0x6e, 0x53, 0x71, 0x75,
	0x61, 0x72, 0x65, 0x64, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x51, 0x0a, 0x16, 0x6d, 0x65, 0x61,
	0x6e, 0x5f, 0x73, 0x71, 0x75, 0x61, 0x72, 0x65, 0x64, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62,
	0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x13, 0x6d, 0x65, 0x61, 0x6e, 0x53, 0x71, 0x75,
	0x61, 0x72, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x50, 0x0a, 0x15,
	0x6d, 0x65, 0x64, 0x69, 0x61, 0x6e, 0x5f, 0x61, 0x62, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x65, 0x5f,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f,
	0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x13, 0x6d, 0x65, 0x64, 0x69, 0x61,
	0x6e, 0x41, 0x62, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x65, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x39,
	0x0a, 0x09, 0x72, 0x5f, 0x73, 0x71, 0x75, 0x61, 0x72, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x08, 0x72, 0x53, 0x71, 0x75, 0x61, 0x72, 0x65, 0x64, 0x1a, 0xb1, 0x03, 0x0a, 0x1e, 0x41, 0x67,
	0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x3a, 0x0a, 0x09,
	0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x70,
	0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x0a, 0x06, 0x72, 0x65, 0x63, 0x61,
	0x6c, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c,
	0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x72, 0x65, 0x63, 0x61, 0x6c, 0x6c, 0x12, 0x38,
	0x0a, 0x08, 0x61, 0x63, 0x63, 0x75, 0x72, 0x61, 0x63, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08,
	0x61, 0x63, 0x63, 0x75, 0x72, 0x61, 0x63, 0x79, 0x12, 0x3a, 0x0a, 0x09, 0x74, 0x68, 0x72, 0x65,
	0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f,
	0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x74, 0x68, 0x72, 0x65, 0x73,
	0x68, 0x6f, 0x6c, 0x64, 0x12, 0x37, 0x0a, 0x08, 0x66, 0x31, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x66, 0x31, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x37, 0x0a,
	0x08, 0x6c, 0x6f, 0x67, 0x5f, 0x6c, 0x6f, 0x73, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x6c,
	0x6f, 0x67, 0x4c, 0x6f, 0x73, 0x73, 0x12, 0x35, 0x0a, 0x07, 0x72, 0x6f, 0x63, 0x5f, 0x61, 0x75,
	0x63, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x72, 0x6f, 0x63, 0x41, 0x75, 0x63, 0x1a, 0xf6, 0x07,
	0x0a, 0x1b, 0x42, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x88, 0x01,
	0x0a, 0x20, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73,
	0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67,
	0x61, 0x74, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x1e, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67,
	0x61, 0x74, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x92, 0x01, 0x0a, 0x1c, 0x62, 0x69, 0x6e,
	0x61, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61,
	0x74, 0x72, 0x69, 0x78, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x2e, 0x42, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x42, 0x69, 0x6e,
	0x61, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x72,
	0x69, 0x78, 0x52, 0x19, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x75, 0x73,
	0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x25, 0x0a,
	0x0e, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x12, 0x25, 0x0a, 0x0e, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x67, 0x61, 0x74, 0x69, 0x76, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x1a, 0xe8, 0x04, 0x0a, 0x15,
	0x42, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x4d,
	0x61, 0x74, 0x72, 0x69, 0x78, 0x12, 0x56, 0x0a, 0x18, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x76,
	0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x16, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x42, 0x0a,
	0x0e, 0x74, 0x72, 0x75, 0x65, 0x5f, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x0d, 0x74, 0x72, 0x75, 0x65, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65,
	0x73, 0x12, 0x44, 0x0a, 0x0f, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x5f, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x69, 0x76, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74,
	0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x50, 0x6f,
	0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x73, 0x12, 0x42, 0x0a, 0x0e, 0x74, 0x72, 0x75, 0x65, 0x5f,
	0x6e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x74, 0x72,
	0x75, 0x65, 0x4e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65, 0x73, 0x12, 0x44, 0x0a, 0x0f, 0x66,
	0x61, 0x6c, 0x73, 0x65, 0x5f, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65, 0x73, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x0e, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x4e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x73, 0x12, 0x3a, 0x0a, 0x09, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x09, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x0a,
	0x06, 0x72, 0x65, 0x63, 0x61, 0x6c, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x72, 0x65, 0x63,
	0x61, 0x6c, 0x6c, 0x12, 0x37, 0x0a, 0x08, 0x66, 0x31, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x07, 0x66, 0x31, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x38, 0x0a, 0x08,
	0x61, 0x63, 0x63, 0x75, 0x72, 0x61, 0x63, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x61, 0x63,
	0x63, 0x75, 0x72, 0x61, 0x63, 0x79, 0x1a, 0x8a, 0x06, 0x0a, 0x1f, 0x4d, 0x75, 0x6c, 0x74, 0x69,
	0x43, 0x6c, 0x61, 0x73, 0x73, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x88, 0x01, 0x0a, 0x20, 0x61,
	0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32,
	0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65,
	0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x1e, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65,
	0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x83, 0x01, 0x0a, 0x15, 0x63, 0x6f, 0x6e, 0x66, 0x75, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32,
	0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x61, 0x73,
	0x73, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e,
	0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x52, 0x13, 0x63, 0x6f, 0x6e, 0x66, 0x75, 0x73, 0x69, 0x6f,
	0x6e, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x4c, 0x69, 0x73, 0x74, 0x1a, 0xd5, 0x03, 0x0a, 0x0f,
	0x43, 0x6f, 0x6e, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x12,
	0x4f, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x68,
	0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x13, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64,
	0x12, 0x67, 0x0a, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x53,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e,
	0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e,
	0x43, 0x6f, 0x6e, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x2e,
	0x52, 0x6f, 0x77, 0x52, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x1a, 0x6c, 0x0a, 0x05, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x65, 0x64, 0x5f,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x70, 0x72, 0x65,
	0x64, 0x69, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x3a, 0x0a, 0x0a, 0x69,
	0x74, 0x65, 0x6d, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x69, 0x74,
	0x65, 0x6d, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x99, 0x01, 0x0a, 0x03, 0x52, 0x6f, 0x77, 0x12,
	0x21, 0x0a, 0x0c, 0x61, 0x63, 0x74, 0x75, 0x61, 0x6c, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x61, 0x63, 0x74, 0x75, 0x61, 0x6c, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x12, 0x6f, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x55, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x61,
	0x74, 0x72, 0x69, 0x78, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72,
	0x69, 0x65, 0x73, 0x1a, 0xf4, 0x07, 0x0a, 0x11, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x67, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x4e, 0x0a, 0x14, 0x64, 0x61, 0x76,
	0x69, 0x65, 0x73, 0x5f, 0x62, 0x6f, 0x75, 0x6c, 0x64, 0x69, 0x6e, 0x5f, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x12, 0x64, 0x61, 0x76, 0x69, 0x65, 0x73, 0x42, 0x6f, 0x75,
	0x6c, 0x64, 0x69, 0x6e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x50, 0x0a, 0x15, 0x6d, 0x65, 0x61,
	0x6e, 0x5f, 0x73, 0x71, 0x75, 0x61, 0x72, 0x65, 0x64, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c,
	0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x13, 0x6d, 0x65, 0x61, 0x6e, 0x53, 0x71, 0x75, 0x61,
	0x72, 0x65, 0x64, 0x44, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x55, 0x0a, 0x08, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x08, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x73, 0x1a, 0xe5, 0x05, 0x0a, 0x07, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x1f,
	0x0a, 0x0b, 0x63, 0x65, 0x6e, 0x74, 0x72, 0x6f, 0x69, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0a, 0x63, 0x65, 0x6e, 0x74, 0x72, 0x6f, 0x69, 0x64, 0x49, 0x64, 0x12,
	0x6d, 0x0a, 0x0e, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x0d, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x31,
	0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x1a, 0x96, 0x04, 0x0a, 0x0c, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6f,
	0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x66, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x47, 0x0a, 0x0f, 0x6e, 0x75, 0x6d,
	0x65, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x48, 0x00, 0x52, 0x0e, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x86, 0x01, 0x0a, 0x11, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63,
	0x61, 0x6c, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x57,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63,
	0x61, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x48, 0x00, 0x52, 0x10, 0x63, 0x61, 0x74, 0x65, 0x67,
	0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x83, 0x02, 0x0a, 0x10,
	0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x8e, 0x01, 0x0a, 0x0f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x2e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x2e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x52, 0x0e, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x1a, 0x5e, 0x0a, 0x0d, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x31,
	0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x42, 0x07, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0xfb, 0x03, 0x0a, 0x11, 0x45,
	0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x12, 0x62, 0x0a, 0x12, 0x72, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x52, 0x65,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x48,
	0x00, 0x52, 0x11, 0x72, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x12, 0x81, 0x01, 0x0a, 0x1d, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x5f,
	0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x42, 0x69,
	0x6e, 0x61, 0x72, 0x79, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x48, 0x00, 0x52, 0x1b, 0x62, 0x69, 0x6e,
	0x61, 0x72, 0x79, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x8e, 0x01, 0x0a, 0x22, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32,
	0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x61, 0x73,
	0x73, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x48, 0x00, 0x52, 0x1f, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x62, 0x0a, 0x12, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32,
	0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x67, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x48, 0x00, 0x52, 0x11, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x42, 0x09, 0x0a,
	0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x1a, 0xc7, 0x13, 0x0a, 0x0b, 0x54, 0x72, 0x61,
	0x69, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6e, 0x12, 0x66, 0x0a, 0x10, 0x74, 0x72, 0x61, 0x69,
	0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x2e, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6e, 0x2e,
	0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x0f, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x55, 0x0a, 0x07, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x54, 0x72,
	0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6e, 0x2e, 0x49, 0x74, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x73, 0x12, 0x60, 0x0a, 0x12, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e,
	0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x52, 0x11, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x1a, 0x95, 0x0c, 0x0a, 0x0f, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e,
	0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x6d, 0x61, 0x78, 0x5f,
	0x69, 0x74, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0d, 0x6d, 0x61, 0x78, 0x49, 0x74, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x45, 0x0a, 0x09, 0x6c, 0x6f, 0x73, 0x73, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x2e, 0x4c, 0x6f, 0x73, 0x73, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x6c, 0x6f,
	0x73, 0x73, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x6c, 0x65, 0x61, 0x72, 0x6e, 0x5f,
	0x72, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x09, 0x6c, 0x65, 0x61, 0x72,
	0x6e, 0x52, 0x61, 0x74, 0x65, 0x12, 0x49, 0x0a, 0x11, 0x6c, 0x31, 0x5f, 0x72, 0x65, 0x67, 0x75,
	0x6c, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x10,
	0x6c, 0x31, 0x52, 0x65, 0x67, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x49, 0x0a, 0x11, 0x6c, 0x32, 0x5f, 0x72, 0x65, 0x67, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f,
	0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x10, 0x6c, 0x32, 0x52, 0x65, 0x67,
	0x75, 0x6c, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x15, 0x6d,
	0x69, 0x6e, 0x5f, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x67,
	0x72, 0x65, 0x73, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75,
	0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x13, 0x6d, 0x69, 0x6e, 0x52, 0x65, 0x6c,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x39, 0x0a,
	0x0a, 0x77, 0x61, 0x72, 0x6d, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x77,
	0x61, 0x72, 0x6d, 0x53, 0x74, 0x61, 0x72, 0x74, 0x12, 0x39, 0x0a, 0x0a, 0x65, 0x61, 0x72, 0x6c,
	0x79, 0x5f, 0x73, 0x74, 0x6f, 0x70, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42,
	0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x65, 0x61, 0x72, 0x6c, 0x79, 0x53,
	0x74, 0x6f, 0x70, 0x12, 0x2e, 0x0a, 0x13, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x11, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x43, 0x6f, 0x6c, 0x75,
	0x6d, 0x6e, 0x73, 0x12, 0x5b, 0x0a, 0x11, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x70, 0x6c, 0x69,
	0x74, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52,
	0x0f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64,
	0x12, 0x37, 0x0a, 0x18, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x5f, 0x65,
	0x76, 0x61, 0x6c, 0x5f, 0x66, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x01, 0x52, 0x15, 0x64, 0x61, 0x74, 0x61, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x45, 0x76, 0x61,
	0x6c, 0x46, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x0a, 0x11, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x43,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x61, 0x0a, 0x13, 0x6c, 0x65, 0x61, 0x72, 0x6e, 0x5f, 0x72,
	0x61, 0x74, 0x65, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x2e, 0x4c, 0x65, 0x61, 0x72, 0x6e, 0x52, 0x61, 0x74, 0x65, 0x53, 0x74, 0x72,
	0x61, 0x74, 0x65, 0x67, 0x79, 0x52, 0x11, 0x6c, 0x65, 0x61, 0x72, 0x6e, 0x52, 0x61, 0x74, 0x65,
	0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x2c, 0x0a, 0x12, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x61, 0x6c, 0x5f, 0x6c, 0x65, 0x61, 0x72, 0x6e, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x10,
	0x20, 0x01, 0x28, 0x01, 0x52, 0x10, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x4c, 0x65, 0x61,
	0x72, 0x6e, 0x52, 0x61, 0x74, 0x65, 0x12, 0x82, 0x01, 0x0a, 0x13, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x73, 0x18, 0x11,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x75,
	0x6e, 0x2e, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x57, 0x65, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x11, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x57, 0x65, 0x69, 0x67, 0x68, 0x74, 0x73, 0x12, 0x51, 0x0a, 0x0d, 0x64,
	0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x14, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x2e, 0x44, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x0c, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x21,
	0x0a, 0x0c, 0x6e, 0x75, 0x6d, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x18, 0x15,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x6e, 0x75, 0x6d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x73, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x16,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x55, 0x72, 0x69, 0x12, 0x69,
	0x0a, 0x15, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73,
	0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x4f,
	0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x61, 0x74,
	0x65, 0x67, 0x79, 0x52, 0x14, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x88, 0x01, 0x0a, 0x1c, 0x6b, 0x6d,
	0x65, 0x61, 0x6e, 0x73, 0x5f, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x21, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x2e, 0x4b, 0x6d, 0x65, 0x61, 0x6e, 0x73, 0x45, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x4b, 0x6d,
	0x65, 0x61, 0x6e, 0x73, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x1a, 0x6b, 0x6d, 0x65, 0x61, 0x6e, 0x73,
	0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x68, 0x6f, 0x64, 0x12, 0x40, 0x0a, 0x1c, 0x6b, 0x6d, 0x65, 0x61, 0x6e, 0x73, 0x5f, 0x69,
	0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f,
	0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x22, 0x20, 0x01, 0x28, 0x09, 0x52, 0x1a, 0x6b, 0x6d, 0x65, 0x61,
	0x6e, 0x73, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x1a, 0x44, 0x0a, 0x16, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x57, 0x65, 0x69, 0x67, 0x68, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x01, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0xc3, 0x04, 0x0a,
	0x0f, 0x49, 0x74, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x12, 0x31, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x12, 0x3c, 0x0a, 0x0b, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x6d, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x73, 0x12, 0x41, 0x0a, 0x0d, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x6f,
	0x73, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c,
	0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67,
	0x4c, 0x6f, 0x73, 0x73, 0x12, 0x39, 0x0a, 0x09, 0x65, 0x76, 0x61, 0x6c, 0x5f, 0x6c, 0x6f, 0x73,
	0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x65, 0x76, 0x61, 0x6c, 0x4c, 0x6f, 0x73, 0x73, 0x12,
	0x1d, 0x0a, 0x0a, 0x6c, 0x65, 0x61, 0x72, 0x6e, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x01, 0x52, 0x09, 0x6c, 0x65, 0x61, 0x72, 0x6e, 0x52, 0x61, 0x74, 0x65, 0x12, 0x6c,
	0x0a, 0x0d, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x73, 0x18,
	0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32,
	0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x52,
	0x75, 0x6e, 0x2e, 0x49, 0x74, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0c,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x73, 0x1a, 0xb3, 0x01, 0x0a,
	0x0b, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1f, 0x0a, 0x0b,
	0x63, 0x65, 0x6e, 0x74, 0x72, 0x6f, 0x69, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x0a, 0x63, 0x65, 0x6e, 0x74, 0x72, 0x6f, 0x69, 0x64, 0x49, 0x64, 0x12, 0x43, 0x0a,
	0x0e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x72, 0x61, 0x64, 0x69, 0x75, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x0d, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x61, 0x64, 0x69,
	0x75, 0x73, 0x12, 0x3e, 0x0a, 0x0c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x69,
	0x7a, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x73, 0x0a,
	0x09, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x4d, 0x4f,
	0x44, 0x45, 0x4c, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x4c, 0x49, 0x4e, 0x45, 0x41, 0x52,
	0x5f, 0x52, 0x45, 0x47, 0x52, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x17, 0x0a,
	0x13, 0x4c, 0x4f, 0x47, 0x49, 0x53, 0x54, 0x49, 0x43, 0x5f, 0x52, 0x45, 0x47, 0x52, 0x45, 0x53,
	0x53, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x4b, 0x4d, 0x45, 0x41, 0x4e, 0x53,
	0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x54, 0x45, 0x4e, 0x53, 0x4f, 0x52, 0x46, 0x4c, 0x4f, 0x57,
	0x10, 0x06, 0x22, 0x4f, 0x0a, 0x08, 0x4c, 0x6f, 0x73, 0x73, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19,
	0x0a, 0x15, 0x4c, 0x4f, 0x53, 0x53, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x4d, 0x45, 0x41,
	0x4e, 0x5f, 0x53, 0x51, 0x55, 0x41, 0x52, 0x45, 0x44, 0x5f, 0x4c, 0x4f, 0x53, 0x53, 0x10, 0x01,
	0x12, 0x11, 0x0a, 0x0d, 0x4d, 0x45, 0x41, 0x4e, 0x5f, 0x4c, 0x4f, 0x47, 0x5f, 0x4c, 0x4f, 0x53,
	0x53, 0x10, 0x02, 0x22, 0x48, 0x0a, 0x0c, 0x44, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x44, 0x49, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x45, 0x55, 0x43, 0x4c, 0x49, 0x44, 0x45, 0x41, 0x4e, 0x10,
	0x01, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x4f, 0x53, 0x49, 0x4e, 0x45, 0x10, 0x02, 0x22, 0x7a, 0x0a,
	0x0f, 0x44, 0x61, 0x74, 0x61, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64,
	0x12, 0x21, 0x0a, 0x1d, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x53, 0x50, 0x4c, 0x49, 0x54, 0x5f, 0x4d,
	0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x52, 0x41, 0x4e, 0x44, 0x4f, 0x4d, 0x10, 0x01, 0x12,
	0x0a, 0x0a, 0x06, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x53,
	0x45, 0x51, 0x55, 0x45, 0x4e, 0x54, 0x49, 0x41, 0x4c, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x4e,
	0x4f, 0x5f, 0x53, 0x50, 0x4c, 0x49, 0x54, 0x10, 0x04, 0x12, 0x0e, 0x0a, 0x0a, 0x41, 0x55, 0x54,
	0x4f, 0x5f, 0x53, 0x50, 0x4c, 0x49, 0x54, 0x10, 0x05, 0x22, 0x57, 0x0a, 0x11, 0x4c, 0x65, 0x61,
	0x72, 0x6e, 0x52, 0x61, 0x74, 0x65, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x23,
	0x0a, 0x1f, 0x4c, 0x45, 0x41, 0x52, 0x4e, 0x5f, 0x52, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x54, 0x52,
	0x41, 0x54, 0x45, 0x47, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x53, 0x45, 0x41, 0x52,
	0x43, 0x48, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x4f, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x54,
	0x10, 0x02, 0x22, 0x6e, 0x0a, 0x14, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x25, 0x0a, 0x21, 0x4f, 0x50,
	0x54, 0x49, 0x4d, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x52, 0x41, 0x54,
	0x45, 0x47, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x1a, 0x0a, 0x16, 0x42, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x47, 0x52, 0x41, 0x44, 0x49,
	0x45, 0x4e, 0x54, 0x5f, 0x44, 0x45, 0x53, 0x43, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x13, 0x0a,
	0x0f, 0x4e, 0x4f, 0x52, 0x4d, 0x41, 0x4c, 0x5f, 0x45, 0x51, 0x55, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x10, 0x02, 0x22, 0x79, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x0a, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x49, 0x64, 0x12, 0x1e, 0x0a,
	0x08, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x49, 0x64, 0x22, 0xb7, 0x01,
	0x0a, 0x11, 0x50, 0x61, 0x74, 0x63, 0x68, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x49, 0x64, 0x12, 0x1e, 0x0a, 0x08, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x07, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x49, 0x64, 0x12, 0x3a, 0x0a, 0x05, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x22, 0x7c, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x22, 0x0a,
	0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49,
	0x64, 0x12, 0x22, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x49, 0x64, 0x12, 0x1e, 0x0a, 0x08, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x49, 0x64, 0x22, 0xb9, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12,
	0x22, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x49, 0x64, 0x12, 0x3d, 0x0a, 0x0b, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33,
	0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x6d, 0x61, 0x78, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x75, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x06, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x06, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x32, 0xfa, 0x05, 0x0a, 0x0c, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x79, 0x0a, 0x08, 0x47, 0x65, 0x74,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32,
	0x2e, 0x47, 0x65, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x22, 0x21, 0xda, 0x41, 0x1e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64,
	0x2c, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x5f, 0x69, 0x64, 0x12, 0x8d, 0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x73, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x24,
	0xda, 0x41, 0x21, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x12, 0x83, 0x01, 0x0a, 0x0a, 0x50, 0x61, 0x74, 0x63, 0x68, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x50,
	0x61, 0x74, 0x63, 0x68, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x22, 0x27, 0xda, 0x41, 0x24, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64,
	0x2c, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x5f, 0x69, 0x64, 0x2c, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x76, 0x0a, 0x0b, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22,
	0x21, 0xda, 0x41, 0x1e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f,
	0x69, 0x64, 0x1a, 0xe0, 0x01, 0xca, 0x41, 0x17, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2,
	0x41, 0xc2, 0x01, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2c, 0x68, 0x74, 0x74, 0x70,
	0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x72, 0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x2c, 0x68, 0x74,
	0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74,
	0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x72, 0x65, 0x61, 0x64,
	0x2d, 0x6f, 0x6e, 0x6c, 0x79, 0x42, 0x6c, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x76, 0x32, 0x42, 0x0a, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x5a, 0x40, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67,
	0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x76, 0x32, 0x3b, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_bigquery_v2_model_proto_rawDescOnce sync.Once
	file_google_cloud_bigquery_v2_model_proto_rawDescData = file_google_cloud_bigquery_v2_model_proto_rawDesc
)

func file_google_cloud_bigquery_v2_model_proto_rawDescGZIP() []byte {
	file_google_cloud_bigquery_v2_model_proto_rawDescOnce.Do(func() {
		file_google_cloud_bigquery_v2_model_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_bigquery_v2_model_proto_rawDescData)
	})
	return file_google_cloud_bigquery_v2_model_proto_rawDescData
}

var file_google_cloud_bigquery_v2_model_proto_enumTypes = make([]protoimpl.EnumInfo, 7)
var file_google_cloud_bigquery_v2_model_proto_msgTypes = make([]protoimpl.MessageInfo, 27)
var file_google_cloud_bigquery_v2_model_proto_goTypes = []interface{}{
	(Model_ModelType)(0),                              // 0: google.cloud.bigquery.v2.Model.ModelType
	(Model_LossType)(0),                               // 1: google.cloud.bigquery.v2.Model.LossType
	(Model_DistanceType)(0),                           // 2: google.cloud.bigquery.v2.Model.DistanceType
	(Model_DataSplitMethod)(0),                        // 3: google.cloud.bigquery.v2.Model.DataSplitMethod
	(Model_LearnRateStrategy)(0),                      // 4: google.cloud.bigquery.v2.Model.LearnRateStrategy
	(Model_OptimizationStrategy)(0),                   // 5: google.cloud.bigquery.v2.Model.OptimizationStrategy
	(Model_KmeansEnums_KmeansInitializationMethod)(0), // 6: google.cloud.bigquery.v2.Model.KmeansEnums.KmeansInitializationMethod
	(*Model)(nil),                                     // 7: google.cloud.bigquery.v2.Model
	(*GetModelRequest)(nil),                           // 8: google.cloud.bigquery.v2.GetModelRequest
	(*PatchModelRequest)(nil),                         // 9: google.cloud.bigquery.v2.PatchModelRequest
	(*DeleteModelRequest)(nil),                        // 10: google.cloud.bigquery.v2.DeleteModelRequest
	(*ListModelsRequest)(nil),                         // 11: google.cloud.bigquery.v2.ListModelsRequest
	(*ListModelsResponse)(nil),                        // 12: google.cloud.bigquery.v2.ListModelsResponse
	(*Model_KmeansEnums)(nil),                         // 13: google.cloud.bigquery.v2.Model.KmeansEnums
	(*Model_RegressionMetrics)(nil),                   // 14: google.cloud.bigquery.v2.Model.RegressionMetrics
	(*Model_AggregateClassificationMetrics)(nil),      // 15: google.cloud.bigquery.v2.Model.AggregateClassificationMetrics
	(*Model_BinaryClassificationMetrics)(nil),         // 16: google.cloud.bigquery.v2.Model.BinaryClassificationMetrics
	(*Model_MultiClassClassificationMetrics)(nil),     // 17: google.cloud.bigquery.v2.Model.MultiClassClassificationMetrics
	(*Model_ClusteringMetrics)(nil),                   // 18: google.cloud.bigquery.v2.Model.ClusteringMetrics
	(*Model_EvaluationMetrics)(nil),                   // 19: google.cloud.bigquery.v2.Model.EvaluationMetrics
	(*Model_TrainingRun)(nil),                         // 20: google.cloud.bigquery.v2.Model.TrainingRun
	nil,                                               // 21: google.cloud.bigquery.v2.Model.LabelsEntry
	(*Model_BinaryClassificationMetrics_BinaryConfusionMatrix)(nil),                     // 22: google.cloud.bigquery.v2.Model.BinaryClassificationMetrics.BinaryConfusionMatrix
	(*Model_MultiClassClassificationMetrics_ConfusionMatrix)(nil),                       // 23: google.cloud.bigquery.v2.Model.MultiClassClassificationMetrics.ConfusionMatrix
	(*Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry)(nil),                 // 24: google.cloud.bigquery.v2.Model.MultiClassClassificationMetrics.ConfusionMatrix.Entry
	(*Model_MultiClassClassificationMetrics_ConfusionMatrix_Row)(nil),                   // 25: google.cloud.bigquery.v2.Model.MultiClassClassificationMetrics.ConfusionMatrix.Row
	(*Model_ClusteringMetrics_Cluster)(nil),                                             // 26: google.cloud.bigquery.v2.Model.ClusteringMetrics.Cluster
	(*Model_ClusteringMetrics_Cluster_FeatureValue)(nil),                                // 27: google.cloud.bigquery.v2.Model.ClusteringMetrics.Cluster.FeatureValue
	(*Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue)(nil),               // 28: google.cloud.bigquery.v2.Model.ClusteringMetrics.Cluster.FeatureValue.CategoricalValue
	(*Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_CategoryCount)(nil), // 29: google.cloud.bigquery.v2.Model.ClusteringMetrics.Cluster.FeatureValue.CategoricalValue.CategoryCount
	(*Model_TrainingRun_TrainingOptions)(nil),                                           // 30: google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions
	(*Model_TrainingRun_IterationResult)(nil),                                           // 31: google.cloud.bigquery.v2.Model.TrainingRun.IterationResult
	nil, // 32: google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.LabelClassWeightsEntry
	(*Model_TrainingRun_IterationResult_ClusterInfo)(nil), // 33: google.cloud.bigquery.v2.Model.TrainingRun.IterationResult.ClusterInfo
	(*ModelReference)(nil),                                // 34: google.cloud.bigquery.v2.ModelReference
	(*EncryptionConfiguration)(nil),                       // 35: google.cloud.bigquery.v2.EncryptionConfiguration
	(*StandardSqlField)(nil),                              // 36: google.cloud.bigquery.v2.StandardSqlField
	(*wrapperspb.UInt32Value)(nil),                        // 37: google.protobuf.UInt32Value
	(*wrapperspb.DoubleValue)(nil),                        // 38: google.protobuf.DoubleValue
	(*timestamppb.Timestamp)(nil),                         // 39: google.protobuf.Timestamp
	(*wrapperspb.Int64Value)(nil),                         // 40: google.protobuf.Int64Value
	(*wrapperspb.BoolValue)(nil),                          // 41: google.protobuf.BoolValue
	(*wrapperspb.Int32Value)(nil),                         // 42: google.protobuf.Int32Value
	(*emptypb.Empty)(nil),                                 // 43: google.protobuf.Empty
}
var file_google_cloud_bigquery_v2_model_proto_depIdxs = []int32{
	34, // 0: google.cloud.bigquery.v2.Model.model_reference:type_name -> google.cloud.bigquery.v2.ModelReference
	21, // 1: google.cloud.bigquery.v2.Model.labels:type_name -> google.cloud.bigquery.v2.Model.LabelsEntry
	35, // 2: google.cloud.bigquery.v2.Model.encryption_configuration:type_name -> google.cloud.bigquery.v2.EncryptionConfiguration
	0,  // 3: google.cloud.bigquery.v2.Model.model_type:type_name -> google.cloud.bigquery.v2.Model.ModelType
	20, // 4: google.cloud.bigquery.v2.Model.training_runs:type_name -> google.cloud.bigquery.v2.Model.TrainingRun
	36, // 5: google.cloud.bigquery.v2.Model.feature_columns:type_name -> google.cloud.bigquery.v2.StandardSqlField
	36, // 6: google.cloud.bigquery.v2.Model.label_columns:type_name -> google.cloud.bigquery.v2.StandardSqlField
	7,  // 7: google.cloud.bigquery.v2.PatchModelRequest.model:type_name -> google.cloud.bigquery.v2.Model
	37, // 8: google.cloud.bigquery.v2.ListModelsRequest.max_results:type_name -> google.protobuf.UInt32Value
	7,  // 9: google.cloud.bigquery.v2.ListModelsResponse.models:type_name -> google.cloud.bigquery.v2.Model
	38, // 10: google.cloud.bigquery.v2.Model.RegressionMetrics.mean_absolute_error:type_name -> google.protobuf.DoubleValue
	38, // 11: google.cloud.bigquery.v2.Model.RegressionMetrics.mean_squared_error:type_name -> google.protobuf.DoubleValue
	38, // 12: google.cloud.bigquery.v2.Model.RegressionMetrics.mean_squared_log_error:type_name -> google.protobuf.DoubleValue
	38, // 13: google.cloud.bigquery.v2.Model.RegressionMetrics.median_absolute_error:type_name -> google.protobuf.DoubleValue
	38, // 14: google.cloud.bigquery.v2.Model.RegressionMetrics.r_squared:type_name -> google.protobuf.DoubleValue
	38, // 15: google.cloud.bigquery.v2.Model.AggregateClassificationMetrics.precision:type_name -> google.protobuf.DoubleValue
	38, // 16: google.cloud.bigquery.v2.Model.AggregateClassificationMetrics.recall:type_name -> google.protobuf.DoubleValue
	38, // 17: google.cloud.bigquery.v2.Model.AggregateClassificationMetrics.accuracy:type_name -> google.protobuf.DoubleValue
	38, // 18: google.cloud.bigquery.v2.Model.AggregateClassificationMetrics.threshold:type_name -> google.protobuf.DoubleValue
	38, // 19: google.cloud.bigquery.v2.Model.AggregateClassificationMetrics.f1_score:type_name -> google.protobuf.DoubleValue
	38, // 20: google.cloud.bigquery.v2.Model.AggregateClassificationMetrics.log_loss:type_name -> google.protobuf.DoubleValue
	38, // 21: google.cloud.bigquery.v2.Model.AggregateClassificationMetrics.roc_auc:type_name -> google.protobuf.DoubleValue
	15, // 22: google.cloud.bigquery.v2.Model.BinaryClassificationMetrics.aggregate_classification_metrics:type_name -> google.cloud.bigquery.v2.Model.AggregateClassificationMetrics
	22, // 23: google.cloud.bigquery.v2.Model.BinaryClassificationMetrics.binary_confusion_matrix_list:type_name -> google.cloud.bigquery.v2.Model.BinaryClassificationMetrics.BinaryConfusionMatrix
	15, // 24: google.cloud.bigquery.v2.Model.MultiClassClassificationMetrics.aggregate_classification_metrics:type_name -> google.cloud.bigquery.v2.Model.AggregateClassificationMetrics
	23, // 25: google.cloud.bigquery.v2.Model.MultiClassClassificationMetrics.confusion_matrix_list:type_name -> google.cloud.bigquery.v2.Model.MultiClassClassificationMetrics.ConfusionMatrix
	38, // 26: google.cloud.bigquery.v2.Model.ClusteringMetrics.davies_bouldin_index:type_name -> google.protobuf.DoubleValue
	38, // 27: google.cloud.bigquery.v2.Model.ClusteringMetrics.mean_squared_distance:type_name -> google.protobuf.DoubleValue
	26, // 28: google.cloud.bigquery.v2.Model.ClusteringMetrics.clusters:type_name -> google.cloud.bigquery.v2.Model.ClusteringMetrics.Cluster
	14, // 29: google.cloud.bigquery.v2.Model.EvaluationMetrics.regression_metrics:type_name -> google.cloud.bigquery.v2.Model.RegressionMetrics
	16, // 30: google.cloud.bigquery.v2.Model.EvaluationMetrics.binary_classification_metrics:type_name -> google.cloud.bigquery.v2.Model.BinaryClassificationMetrics
	17, // 31: google.cloud.bigquery.v2.Model.EvaluationMetrics.multi_class_classification_metrics:type_name -> google.cloud.bigquery.v2.Model.MultiClassClassificationMetrics
	18, // 32: google.cloud.bigquery.v2.Model.EvaluationMetrics.clustering_metrics:type_name -> google.cloud.bigquery.v2.Model.ClusteringMetrics
	30, // 33: google.cloud.bigquery.v2.Model.TrainingRun.training_options:type_name -> google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions
	39, // 34: google.cloud.bigquery.v2.Model.TrainingRun.start_time:type_name -> google.protobuf.Timestamp
	31, // 35: google.cloud.bigquery.v2.Model.TrainingRun.results:type_name -> google.cloud.bigquery.v2.Model.TrainingRun.IterationResult
	19, // 36: google.cloud.bigquery.v2.Model.TrainingRun.evaluation_metrics:type_name -> google.cloud.bigquery.v2.Model.EvaluationMetrics
	38, // 37: google.cloud.bigquery.v2.Model.BinaryClassificationMetrics.BinaryConfusionMatrix.positive_class_threshold:type_name -> google.protobuf.DoubleValue
	40, // 38: google.cloud.bigquery.v2.Model.BinaryClassificationMetrics.BinaryConfusionMatrix.true_positives:type_name -> google.protobuf.Int64Value
	40, // 39: google.cloud.bigquery.v2.Model.BinaryClassificationMetrics.BinaryConfusionMatrix.false_positives:type_name -> google.protobuf.Int64Value
	40, // 40: google.cloud.bigquery.v2.Model.BinaryClassificationMetrics.BinaryConfusionMatrix.true_negatives:type_name -> google.protobuf.Int64Value
	40, // 41: google.cloud.bigquery.v2.Model.BinaryClassificationMetrics.BinaryConfusionMatrix.false_negatives:type_name -> google.protobuf.Int64Value
	38, // 42: google.cloud.bigquery.v2.Model.BinaryClassificationMetrics.BinaryConfusionMatrix.precision:type_name -> google.protobuf.DoubleValue
	38, // 43: google.cloud.bigquery.v2.Model.BinaryClassificationMetrics.BinaryConfusionMatrix.recall:type_name -> google.protobuf.DoubleValue
	38, // 44: google.cloud.bigquery.v2.Model.BinaryClassificationMetrics.BinaryConfusionMatrix.f1_score:type_name -> google.protobuf.DoubleValue
	38, // 45: google.cloud.bigquery.v2.Model.BinaryClassificationMetrics.BinaryConfusionMatrix.accuracy:type_name -> google.protobuf.DoubleValue
	38, // 46: google.cloud.bigquery.v2.Model.MultiClassClassificationMetrics.ConfusionMatrix.confidence_threshold:type_name -> google.protobuf.DoubleValue
	25, // 47: google.cloud.bigquery.v2.Model.MultiClassClassificationMetrics.ConfusionMatrix.rows:type_name -> google.cloud.bigquery.v2.Model.MultiClassClassificationMetrics.ConfusionMatrix.Row
	40, // 48: google.cloud.bigquery.v2.Model.MultiClassClassificationMetrics.ConfusionMatrix.Entry.item_count:type_name -> google.protobuf.Int64Value
	24, // 49: google.cloud.bigquery.v2.Model.MultiClassClassificationMetrics.ConfusionMatrix.Row.entries:type_name -> google.cloud.bigquery.v2.Model.MultiClassClassificationMetrics.ConfusionMatrix.Entry
	27, // 50: google.cloud.bigquery.v2.Model.ClusteringMetrics.Cluster.feature_values:type_name -> google.cloud.bigquery.v2.Model.ClusteringMetrics.Cluster.FeatureValue
	40, // 51: google.cloud.bigquery.v2.Model.ClusteringMetrics.Cluster.count:type_name -> google.protobuf.Int64Value
	38, // 52: google.cloud.bigquery.v2.Model.ClusteringMetrics.Cluster.FeatureValue.numerical_value:type_name -> google.protobuf.DoubleValue
	28, // 53: google.cloud.bigquery.v2.Model.ClusteringMetrics.Cluster.FeatureValue.categorical_value:type_name -> google.cloud.bigquery.v2.Model.ClusteringMetrics.Cluster.FeatureValue.CategoricalValue
	29, // 54: google.cloud.bigquery.v2.Model.ClusteringMetrics.Cluster.FeatureValue.CategoricalValue.category_counts:type_name -> google.cloud.bigquery.v2.Model.ClusteringMetrics.Cluster.FeatureValue.CategoricalValue.CategoryCount
	40, // 55: google.cloud.bigquery.v2.Model.ClusteringMetrics.Cluster.FeatureValue.CategoricalValue.CategoryCount.count:type_name -> google.protobuf.Int64Value
	1,  // 56: google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.loss_type:type_name -> google.cloud.bigquery.v2.Model.LossType
	38, // 57: google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.l1_regularization:type_name -> google.protobuf.DoubleValue
	38, // 58: google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.l2_regularization:type_name -> google.protobuf.DoubleValue
	38, // 59: google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.min_relative_progress:type_name -> google.protobuf.DoubleValue
	41, // 60: google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.warm_start:type_name -> google.protobuf.BoolValue
	41, // 61: google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.early_stop:type_name -> google.protobuf.BoolValue
	3,  // 62: google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.data_split_method:type_name -> google.cloud.bigquery.v2.Model.DataSplitMethod
	4,  // 63: google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.learn_rate_strategy:type_name -> google.cloud.bigquery.v2.Model.LearnRateStrategy
	32, // 64: google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.label_class_weights:type_name -> google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.LabelClassWeightsEntry
	2,  // 65: google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.distance_type:type_name -> google.cloud.bigquery.v2.Model.DistanceType
	5,  // 66: google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.optimization_strategy:type_name -> google.cloud.bigquery.v2.Model.OptimizationStrategy
	6,  // 67: google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.kmeans_initialization_method:type_name -> google.cloud.bigquery.v2.Model.KmeansEnums.KmeansInitializationMethod
	42, // 68: google.cloud.bigquery.v2.Model.TrainingRun.IterationResult.index:type_name -> google.protobuf.Int32Value
	40, // 69: google.cloud.bigquery.v2.Model.TrainingRun.IterationResult.duration_ms:type_name -> google.protobuf.Int64Value
	38, // 70: google.cloud.bigquery.v2.Model.TrainingRun.IterationResult.training_loss:type_name -> google.protobuf.DoubleValue
	38, // 71: google.cloud.bigquery.v2.Model.TrainingRun.IterationResult.eval_loss:type_name -> google.protobuf.DoubleValue
	33, // 72: google.cloud.bigquery.v2.Model.TrainingRun.IterationResult.cluster_infos:type_name -> google.cloud.bigquery.v2.Model.TrainingRun.IterationResult.ClusterInfo
	38, // 73: google.cloud.bigquery.v2.Model.TrainingRun.IterationResult.ClusterInfo.cluster_radius:type_name -> google.protobuf.DoubleValue
	40, // 74: google.cloud.bigquery.v2.Model.TrainingRun.IterationResult.ClusterInfo.cluster_size:type_name -> google.protobuf.Int64Value
	8,  // 75: google.cloud.bigquery.v2.ModelService.GetModel:input_type -> google.cloud.bigquery.v2.GetModelRequest
	11, // 76: google.cloud.bigquery.v2.ModelService.ListModels:input_type -> google.cloud.bigquery.v2.ListModelsRequest
	9,  // 77: google.cloud.bigquery.v2.ModelService.PatchModel:input_type -> google.cloud.bigquery.v2.PatchModelRequest
	10, // 78: google.cloud.bigquery.v2.ModelService.DeleteModel:input_type -> google.cloud.bigquery.v2.DeleteModelRequest
	7,  // 79: google.cloud.bigquery.v2.ModelService.GetModel:output_type -> google.cloud.bigquery.v2.Model
	12, // 80: google.cloud.bigquery.v2.ModelService.ListModels:output_type -> google.cloud.bigquery.v2.ListModelsResponse
	7,  // 81: google.cloud.bigquery.v2.ModelService.PatchModel:output_type -> google.cloud.bigquery.v2.Model
	43, // 82: google.cloud.bigquery.v2.ModelService.DeleteModel:output_type -> google.protobuf.Empty
	79, // [79:83] is the sub-list for method output_type
	75, // [75:79] is the sub-list for method input_type
	75, // [75:75] is the sub-list for extension type_name
	75, // [75:75] is the sub-list for extension extendee
	0,  // [0:75] is the sub-list for field type_name
}

func init() { file_google_cloud_bigquery_v2_model_proto_init() }
func file_google_cloud_bigquery_v2_model_proto_init() {
	if File_google_cloud_bigquery_v2_model_proto != nil {
		return
	}
	file_google_cloud_bigquery_v2_encryption_config_proto_init()
	file_google_cloud_bigquery_v2_model_reference_proto_init()
	file_google_cloud_bigquery_v2_standard_sql_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_bigquery_v2_model_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetModelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchModelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteModelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListModelsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListModelsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_KmeansEnums); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_RegressionMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_AggregateClassificationMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_BinaryClassificationMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_MultiClassClassificationMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_ClusteringMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_EvaluationMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_TrainingRun); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_BinaryClassificationMetrics_BinaryConfusionMatrix); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_MultiClassClassificationMetrics_ConfusionMatrix); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_MultiClassClassificationMetrics_ConfusionMatrix_Row); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_ClusteringMetrics_Cluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_ClusteringMetrics_Cluster_FeatureValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_CategoryCount); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_TrainingRun_TrainingOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_TrainingRun_IterationResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_v2_model_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Model_TrainingRun_IterationResult_ClusterInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_bigquery_v2_model_proto_msgTypes[12].OneofWrappers = []interface{}{
		(*Model_EvaluationMetrics_RegressionMetrics)(nil),
		(*Model_EvaluationMetrics_BinaryClassificationMetrics)(nil),
		(*Model_EvaluationMetrics_MultiClassClassificationMetrics)(nil),
		(*Model_EvaluationMetrics_ClusteringMetrics)(nil),
	}
	file_google_cloud_bigquery_v2_model_proto_msgTypes[20].OneofWrappers = []interface{}{
		(*Model_ClusteringMetrics_Cluster_FeatureValue_NumericalValue)(nil),
		(*Model_ClusteringMetrics_Cluster_FeatureValue_CategoricalValue_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_bigquery_v2_model_proto_rawDesc,
			NumEnums:      7,
			NumMessages:   27,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_bigquery_v2_model_proto_goTypes,
		DependencyIndexes: file_google_cloud_bigquery_v2_model_proto_depIdxs,
		EnumInfos:         file_google_cloud_bigquery_v2_model_proto_enumTypes,
		MessageInfos:      file_google_cloud_bigquery_v2_model_proto_msgTypes,
	}.Build()
	File_google_cloud_bigquery_v2_model_proto = out.File
	file_google_cloud_bigquery_v2_model_proto_rawDesc = nil
	file_google_cloud_bigquery_v2_model_proto_goTypes = nil
	file_google_cloud_bigquery_v2_model_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ModelServiceClient is the client API for ModelService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ModelServiceClient interface {
	// Gets the specified model resource by model ID.
	GetModel(ctx context.Context, in *GetModelRequest, opts ...grpc.CallOption) (*Model, error)
	// Lists all models in the specified dataset. Requires the READER dataset
	// role.
	ListModels(ctx context.Context, in *ListModelsRequest, opts ...grpc.CallOption) (*ListModelsResponse, error)
	// Patch specific fields in the specified model.
	PatchModel(ctx context.Context, in *PatchModelRequest, opts ...grpc.CallOption) (*Model, error)
	// Deletes the model specified by modelId from the dataset.
	DeleteModel(ctx context.Context, in *DeleteModelRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type modelServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewModelServiceClient(cc grpc.ClientConnInterface) ModelServiceClient {
	return &modelServiceClient{cc}
}

func (c *modelServiceClient) GetModel(ctx context.Context, in *GetModelRequest, opts ...grpc.CallOption) (*Model, error) {
	out := new(Model)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.v2.ModelService/GetModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) ListModels(ctx context.Context, in *ListModelsRequest, opts ...grpc.CallOption) (*ListModelsResponse, error) {
	out := new(ListModelsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.v2.ModelService/ListModels", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) PatchModel(ctx context.Context, in *PatchModelRequest, opts ...grpc.CallOption) (*Model, error) {
	out := new(Model)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.v2.ModelService/PatchModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) DeleteModel(ctx context.Context, in *DeleteModelRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.v2.ModelService/DeleteModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ModelServiceServer is the server API for ModelService service.
type ModelServiceServer interface {
	// Gets the specified model resource by model ID.
	GetModel(context.Context, *GetModelRequest) (*Model, error)
	// Lists all models in the specified dataset. Requires the READER dataset
	// role.
	ListModels(context.Context, *ListModelsRequest) (*ListModelsResponse, error)
	// Patch specific fields in the specified model.
	PatchModel(context.Context, *PatchModelRequest) (*Model, error)
	// Deletes the model specified by modelId from the dataset.
	DeleteModel(context.Context, *DeleteModelRequest) (*emptypb.Empty, error)
}

// UnimplementedModelServiceServer can be embedded to have forward compatible implementations.
type UnimplementedModelServiceServer struct {
}

func (*UnimplementedModelServiceServer) GetModel(context.Context, *GetModelRequest) (*Model, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetModel not implemented")
}
func (*UnimplementedModelServiceServer) ListModels(context.Context, *ListModelsRequest) (*ListModelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListModels not implemented")
}
func (*UnimplementedModelServiceServer) PatchModel(context.Context, *PatchModelRequest) (*Model, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PatchModel not implemented")
}
func (*UnimplementedModelServiceServer) DeleteModel(context.Context, *DeleteModelRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteModel not implemented")
}

func RegisterModelServiceServer(s *grpc.Server, srv ModelServiceServer) {
	s.RegisterService(&_ModelService_serviceDesc, srv)
}

func _ModelService_GetModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).GetModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.v2.ModelService/GetModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).GetModel(ctx, req.(*GetModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_ListModels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListModelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).ListModels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.v2.ModelService/ListModels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).ListModels(ctx, req.(*ListModelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_PatchModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).PatchModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.v2.ModelService/PatchModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).PatchModel(ctx, req.(*PatchModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_DeleteModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).DeleteModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.v2.ModelService/DeleteModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).DeleteModel(ctx, req.(*DeleteModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ModelService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.bigquery.v2.ModelService",
	HandlerType: (*ModelServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetModel",
			Handler:    _ModelService_GetModel_Handler,
		},
		{
			MethodName: "ListModels",
			Handler:    _ModelService_ListModels_Handler,
		},
		{
			MethodName: "PatchModel",
			Handler:    _ModelService_PatchModel_Handler,
		},
		{
			MethodName: "DeleteModel",
			Handler:    _ModelService_DeleteModel_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/bigquery/v2/model.proto",
}
