// header include
#include "fixtures/test_utils.h"

// system includes
#include <cstdlib>

// system includes
#include <cstdint>
#include <iostream>
#include <regex>

namespace ut_consts {
  namespace {
    template<typename... Ts>
    std::vector<std::byte> makeBytes(Ts &&...args) {
      return {std::byte {static_cast<std::uint8_t>(args)}...};
    }
  }  // namespace

  const std::vector<std::byte> DEFAULT_EDID {makeBytes(
    // clang-format off
    0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x04, 0x69,
    0xEC, 0x27, 0xAA, 0x55, 0x00, 0x00, 0x13, 0x1D, 0x01, 0x04,
    0xA5, 0x3C, 0x22, 0x78, 0x06, 0xEE, 0x91, 0xA3, 0x54, 0x4C,
    0x99, 0x26, 0x0F, 0x50, 0x54, 0x21, 0x08, 0x00, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x56, 0x5E, 0x00, 0xA0, 0xA0, 0xA0,
    0x29, 0x50, 0x30, 0x20, 0x35, 0x00, 0x56, 0x50, 0x21, 0x00,
    0x00, 0x1A, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x23, 0x41, 0x53,
    0x4E, 0x39, 0x4A, 0x36, 0x6E, 0x4E, 0x49, 0x54, 0x62, 0x64,
    0x00, 0x00, 0x00, 0xFD, 0x00, 0x1E, 0x90, 0x22, 0xDE, 0x3B,
    0x01, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00,
    0x00, 0xFC, 0x00, 0x52, 0x4F, 0x47, 0x20, 0x50, 0x47, 0x32,
    0x37, 0x39, 0x51, 0x0A, 0x20, 0x20, 0x01, 0x8B
    // clang-format on
  )};
  const display_device::EdidData DEFAULT_EDID_DATA {
    .m_manufacturer_id = "ACI",
    .m_product_code = "27EC",
    .m_serial_number = 21930
  };
}  // namespace ut_consts

bool testRegex(const std::string &input, const std::string &pattern) {
  std::regex regex(pattern);
  std::smatch match;
  if (!std::regex_match(input, match, regex)) {
    std::cout << "Regex test failed:\n"
              << "    Input  : " << input << "\n"
              << "    Pattern: " << pattern << std::endl;
    return false;
  }
  return true;
}

int setEnv(const std::string &name, const std::string &value) {
#ifdef _WIN32
  return _putenv_s(name.c_str(), value.c_str());
#else
  return setenv(name.c_str(), value.c_str(), 1);
#endif
}

std::optional<std::string> getEnv(const std::string &name) {
  if (const auto value {std::getenv(name.c_str())}; value) {
    return std::string {value};
  }
  return std::nullopt;
}
