#########################################################################################
# $Id: 14_SD_UT.pm 27977 2023-09-18 17:56:28Z HomeAuto_User $
#
# The file is part of the SIGNALduino project.
# The purpose of this module is universal support for devices.
#
# 2016      - 1.fhemtester
# 2018-     - HomeAuto_User, elektron-bbs
#
# - unitec Modul alte Variante bis 20180901 (Typ unitec-Sound) --> keine MU MSG!
# - unitec Funkfernschalterset (Typ uniTEC_48110) ??? EIM-826 Funksteckdosen --> keine MU MSG!
###############################################################################################################################################################################
# - unitec remote door reed switch 47031 (Typ Unitec_47031) [Protocol 30] and [additionally Protocol 83] (sync -30)  (1 = on | 0 = off)
#{    FORUM: https://forum.fhem.de/index.php/topic,43346.msg353144.html#msg353144
#     8 DIP-switches for deviceCode (1-8) | 3 DIP-switches for zone (9-11) | 1 DIP-switch unknown (12) | baugleich FRIEDLAND SU4F zwecks gleichem Platinenlayout + Jumper
#     Kopplung an Unitec 47121 (Zone 1-6) | Unitec 47125 (Zone 1-2) | Friedland (Zone 1)
#     Adresse: 95 - öffnen?               |  get sduino_dummy raw MU;;P0=309;;P1=636;;P2=-690;;P3=-363;;P4=-10027;;D=012031203120402031312031203120312031204020313120312031203120312040203131203120312031203120402031312031203120312031204020313120312031203120312040203131203120312031203120402031312031203120312031204020313120312031203120312040203131203120312030;;CP=0;;O;;
#}    Adresse: 00 - Gehäuse geöffnet?     |  get sduino_dummy raw MU;;P0=684;;P1=-304;;P2=-644;;P3=369;;P4=-9931;;D=010101010101010232323104310101010101010102323231043101010101010101023232310431010101010101010232323104310101010101010102323231043101010101010101023232310431010101010101010232323104310101010101010102323231043101010101010101023232310431010100;;CP=0;;O;;
###############################################################################################################################################################################
# - Westinghouse Deckenventilator (Typ HT12E | remote with 5 buttons without SET | Buttons_five ??? 7787100 ???) [Protocol 29] and [additionally Protocol 30] (sync -35) (1 = off | 0 = on)
#{    FORUM: https://forum.fhem.de/index.php/topic,58397.960.html | https://forum.fhem.de/index.php/topic,53282.30.html
#     Adresse e | 1110 (off|off|off|on): fan_off         |  get sduino_dummy raw MU;;P0=250;;P1=-492;;P2=166;;P3=-255;;P4=491;;P5=-8588;;D=052121212121234121212121234521212121212341212121212345212121212123412121212123452121212121234121212121234;;CP=0;;
#}    Adresse e | 1110 (off|off|off|on): fan low speed   |  get sduino_dummy raw MU;;P0=-32001;;P1=224;;P2=-255;;P3=478;;P4=-508;;P6=152;;P7=-8598;;D=01234141414641414141414123712341414141414141414141237123414141414141414141412371234141414141414141414123712341414141414141414141237123414141414141414141412371234141414141414141414123712341414141414141414141237123414141414141414141412371234141414141414141;;CP=1;;R=108;;O;;
# - Westinghouse Deckenventilator (Typ HT12E | remote with 6 buttons, with light dimmer | Buttons_six - 7787800) [Protocol 29] (start -35) (1 = off | 0 = on)
#{    FORUM: https://forum.fhem.de/index.php/topic,53282.msg1229192.html#msg1229192
#}    Adresse E | 1110 (off|off|off|on): light_dimm | get sduino_dummy rawmsg MU;P0=24164;P1=-495;P2=191;P3=-271;P4=415;P5=-8052;D=01212341212121212121212345212123412121212121212123452121234121212121212121234521212341212121212121212345212123412121212121212123452121234121212121212121234521212341212121212121212345212123412121212121212123452121234121212121212121234521212341212121212121;CP=2;R=52;O;
####################################################################################################################################
# - Westinghouse Deckenventilator (Typ [M1EN compatible HT12E] example Delancey | remote RH787T with 9 buttons + SET) [Protocol 83] and [additionally Protocol 30] (sync -36) (1 = off | 0 = on)
#{    Adresse 0 | 0000 (on|on|on|on): I - fan minimum speed  |  get sduino_dummy raw MU;;P0=388;;P1=-112;;P2=267;;P3=-378;;P5=585;;P6=-693;;P7=-11234;;D=0123035353535356262623562626272353535353562626235626262723535353535626262356262627235353535356262623562626272353535353562626235626262723535353535626262356262627235353535356262623562626272353535353562626235626262723535353535626262356262627235353535356262;;CP=2;;R=43;;O;;
#     Adresse 8 | 1000 (off|on|on|on): I - fan minimum speed |  get sduino_dummy raw MU;;P0=-11250;;P1=-200;;P2=263;;P3=-116;;P4=-374;;P5=578;;P6=-697;;D=1232456245454562626245626262024562454545626262456262620245624545456262624562626202456245454562626245626262024562454545626262456262620245624545456262624562626202456245454562626245626262024562454545626262456262620245624545456262624562626202456245454562626;;CP=2;;R=49;;O;;
#     Adresse c | 1100 (off|off|on|on): fan_off              |  get sduino_dummy raw MU;;P0=-720;;P1=235;;P2=-386;;P3=561;;P4=-11254;;D=01230141230101232301010101012301412301012323010101010123014123010123230101010101010141230101232301010101010101412301012323010101010101014123010123230101010101010;;CP=1;;R=242;;
#}    Adresse c | 1100 (off|off|on|on): fan_off              |  get sduino_dummy raw MU;;P0=-11230;;P1=258;;P2=-390;;P3=571;;P4=-699;;D=0123414123234141414141234101234141232341414141412341012341412323414141414123410123414123234141414141234101234141232341414141412341012341412323414141414123410123414123234141414141234101234141232341414141412341012341412323414141414123410123414123234141414;;CP=1;;R=246;;O;;
####################################################################################################################################
# - Deckenventilator mit Licht Westinghouse Bendan (remote control TR60C-1 with touch screen) [Protocol 104]
#{    Adresse 0 | DIP 0000 Licht aus/Ventilator aus | get sduino_dummy raw MU;P0=18280;P1=-737;P2=419;P3=-331;P4=799;P5=-9574;P6=-7080;D=012121234343434341212121212121252121212123434343434121212121212125212121212343434343412121212121212521212121234343434341212121212121252121212123434343434121212121212126;CP=2;R=2;
#     Adresse 8 | DIP 1000 Licht an/Ventilator aus  | get sduino_dummy raw MU;P0=-2496;P1=778;P2=-755;P3=379;P4=-358;P5=-9582;D=0123232341414141412323234141414153412323234141414141232323414141415341232323414141414123232341414141534123232341414141412323234141414153412323234141414141232323414141415341232323414141414123232341414141;CP=3;R=12;
#}    Adresse B | DIP 1011 Licht an/Ventilator aus  | get sduino_dummy raw MU;P0=25688;P1=-764;P2=381;P3=-371;P4=773;P5=-9586;P6=-20664;P7=-176;D=012343434343434341212123434343452341234343434343434121212343434345234123434343434343412121234343434523412343434343434341212123434343452341234343434343434121212343434345234123434343434343412121234343434627;CP=4;R=3;
###############################################################################################################################################################################
# - Remote control SA-434-1 mini 923301 [Protocol 81] and [additionally Protocol 83 + Protocol 86]
#{    one Button, 434 MHz
#     protocol like HT12E
#     10 DIP-switches for address:
#     switch                                hex     bin
#     ------------------------------------------------------------
#     1-10 on                               004     0000 0000 0100
#     1 off, 9-10 on                        804     1000 0000 0100
#     4/8 off, 9-3 5-7 9-10 on              114     0001 0001 0100
#     4/8 off, 9-3 5-7 on, 9 off, 10 on     115     0001 0001 0101
#     4/8 off, 9-3 5-7 on, 9 on, 10 off     11C     0001 0001 1100
#     4/8 off, 9-3 5-7 on, 9-10 off         11D     0001 0001 1101
#     ------------------------------------------------------------
#     pilot 12 bitlength, from that 1/3 bitlength high: -175000, 500   -35, 1
#     one:                                                -1000, 500    -2, 1
#     zero:                                                -500, 1000   -1, 2
#
#     get sduino_dummy raw MU;;P0=-1756;;P1=112;;P2=-11752;;P3=496;;P4=-495;;P5=998;;P6=-988;;P7=-17183;;D=0123454545634545456345634563734545456345454563456345637345454563454545634563456373454545634545456345634563734545456345454563456345637345454563454545634563456373454545634545456345634563734545456345454563456345637345454563454545634563456373454545634545456;;CP=3;;R=0;;
#}    get sduino_dummy raw MU;;P0=-485;;P1=188;;P2=-6784;;P3=508;;P5=1010;;P6=-974;;P7=-17172;;D=0123050505630505056305630563730505056305050563056305637305050563050505630563056373050505630505056305630563730505056305050563056305637305050563050505630563056373050505630505056305630563730505056305050563056305637305050563050505630563056373050505630505056;;CP=3;;R=0;;
###############################################################################################################################################################################
# - QUIGG GT-7000 Funk-Steckdosendimmer | transmitter QUIGG_DMV - receiver DMV-7009AS  [Protocol 34]
#{    https://github.com/RFD-FHEM/RFFHEM/issues/195
#     nibble 0-2 -> Ident | nibble 3-4 -> Tastencode
#     get sduino_dummy raw MU;;P0=-5476;;P1=592;;P2=-665;;P3=1226;;P4=-1309;;D=01232323232323232323232323412323412323414;;CP=3;;R=1;;
#}    Send Adresse FFF funktioniert nicht 100%ig!
###############################################################################################################################################################################
# - TR-502MSV (LIBRA GmbH [LIDL] Funk-Steckdosendimmer + Schalter | transmitter TR-502MSV - receiver RC-710DX|RC-710 [Protocol 34]
#{    nibble 0-2 -> Hauscode | nibble 3-4 -> Tastencode | repeats 3
#     get sduino_dummy raw MU;;P0=-12064;;P1=717;;P2=-669;;P3=1351;;P4=-1319;;D=012323414141234123232323232323232323232323;;
#}    get sduino_dummy raw MU;;P0=697;;P1=-1352;;P2=-679;;P3=1343;;D=01010101010231023232323232323232323232323;CP=0;R=27;;
###############################################################################################################################################################################
# - Remote Control Novy_840029 for Novy Pureline 6830 kitchen hood [Protocol 86] (Länge je nach Taste 12 oder 18 Bit) [additionally Protocol 81]
#{    0100        "novy"            - nicht geprüft
#     0101        "speed_plus"      - i.O.
#     0110        "speed_minus"     - i.O.
#     0111010001  "light_on_off"    - nur 10 Bit, SIGNALduino.pm hängt 2 Nullen an
#     0111010011  "power_on_off"    - nur 10 Bit, SIGNALduino.pm hängt 2 Nullen an
#     https://github.com/RFD-FHEM/RFFHEM/issues/331
#     nibble 0-1 -> Ident | nibble 2-4 -> Tastencode
#     light_on_off   - hex_length 5  get sduino_dummy raw MU;;P0=710;;P1=353;;P2=-403;;P4=-761;;P6=-16071;;D=20204161204120412041204120414141204120202041612041204120412041204141412041202020416120412041204120412041414120412020204161204120412041204120414141204120202041;;CP=1;;R=40;;
#     novy           - hex_length 3  get sduino_dummy raw MU;;P0=706;;P1=-763;;P2=370;;P3=-405;;P4=-15980;;D=0123012301230304230123012301230123012303042;;CP=2;;R=42;;
#     power_on_off   - hex_length 5  get sduino_dummy raw MU;;P0=-756;;P1=718;;P2=354;;P3=-395;;P4=-16056;;D=01020202310231310202423102310231023102310202023102313102024231023102310231023102020231023131020242310231023102310231020202310231310202;;CP=2;;R=41;;
#     speed_minus    - hex_length 3  get sduino_dummy raw MU;;P0=-8032;;P1=364;;P2=-398;;P3=700;;P4=-760;;P5=-15980;;D=0123412341234123412341412351234123412341234123414123512341234123412341234141235123412341234123412341412351234123412341234123414123;;CP=1;;R=40;;
#}    speed_plus     - hex_length 3  get sduino_dummy raw MU;;P0=22808;;P1=-24232;;P2=701;;P3=-765;;P4=357;;P5=-15970;;P7=-406;;D=012345472347234723472347234723454723472347234723472347234547234723472347234723472345472347234723472347234723454723472347234723472347234;;CP=4;;R=39;;
###
# - Remote Control Novy_840039 for Novy Cloud 230 kitchen hood [Protocol 86] (Länge je nach Taste 12 oder 18 Bit) [additionally Protocol 81]
#{    https://github.com/RFD-FHEM/RFFHEM/issues/792 | https://forum.fhem.de/index.php/topic,107867.0.html
#     nibble 0-1 -> Ident | nibble 2-4 -> Tastencode
#     0111010011  "power_on_off"            - nur 10 Bit, SIGNALduino.pm hängt 2 Nullen an   hex_length 5  get sduino_dummy raw MU;;P0=-749;;P1=378;;P2=-456;;P3=684;;P4=-16081;;D=01230101012301232301014123012301230123012301010123012323010141230123012301230123010101230123230101412;;CP=1;;R=66;;
#     0110110110  "cooking_light_on"        - i.O.                                           hex_length 5  get sduino_dummy raw MU;;P0=-4768;;P1=380;;P2=-397;;P3=690;;P4=-755;;P5=-16077;;CP=1;;R=39;;D=0123412341234123412341412341412341412351234123412341234123414123414123414123;;O;;w=0;;
#     0110110100  "cooking_light_off"       - i.O.                                           hex_length 5  get sduino_dummy raw MU;;P0=382;;P1=200;;P2=-745;;P4=-394;;P5=696;;P6=-16083;;CP=0;;R=81;;D=1204520204520204520454560452045204520452045202045202045204545;;O;;w=0;;
#     0110110101  "cooking_light_dim_plus"  - i.O.                                           hex_length 5  get sduino_dummy raw MU;;P0=-753;;P1=387;;P2=-419;;P3=679;;P6=-16050;;CP=1;;R=58;;D=0123012301012301012301230161230123012301230123010123010123012301;;p;;w=0;;
#     0110110011  "cooking_light_dim_minus" - i.O.                                           hex_length 5  get sduino_dummy raw MU;;P1=386;;P2=-394;;P3=694;;P4=-794;;P5=-16064;;CP=1;;R=51;;D=123412341234123412341412341412323414151234123412341234123414123414123234141;;p;;w=0;;
#     0111001110  "cooking_light_cold"      - i.O.                                           hex_length 5  get sduino_dummy raw MU;;P0=-92;;P1=371;;P2=-738;;P4=-393;;P5=702;;P6=-16072;;CP=1;;R=69;;D=012145214521212145452121214561452145214521452145212121454521212145;;e;;w=0;;
#     0111001011  "cooking_light_warm"      - i.O.                                           hex_length 5  get sduino_dummy raw MU;;P0=-17440;;P1=381;;P2=-415;;P3=668;;P4=-756;;P6=-6786;;CP=1;;R=85;;D=0123412341234123412341414123234123414101634123414141232341234141;;e;;w=0;;
#     0110111110  "ambient_light_on"        - i.O.                                           hex_length 5  get sduino_dummy raw MU;;P0=-9524;;P1=364;;P2=-414;;P3=669;;P4=-755;;P5=-16076;;CP=1;;R=83;;D=0123412341234123412341412341414141412351234123412341234123414123414141414123;;e;;w=0;;
#     0110111100  "ambient_light_off"       - i.O.                                           hex_length 5  get sduino_dummy raw MU;;P1=371;;P2=-406;;P3=685;;P4=-744;;P6=-16050;;CP=1;;R=88;;D=123412341234123412341412341414141232361234123412341234123414123414141412323;;e;;w=0;;
#     0110111101  "ambient_light_dim_plus"  - i.O.                                           hex_length 5  get sduino_dummy raw MU;;P0=-10584;;P1=362;;P2=-417;;P3=678;;P4=-765;;P5=-16075;;CP=1;;R=67;;D=0123412341234123412341412341414141234151234123412341234123414123414141412341;;O;;w=0;;
#     0110111011  "ambient_light_dim_minus" - i.O.                                           hex_length 5  get sduino_dummy raw MU;;P2=-14541;;P3=-396;;P4=707;;P5=-733;;P6=367;;CP=6;;R=86;;D=62634563456345634563456563456565634565626345634563456345634565634565656345656;;p;;w=0;;
#     0111010110  "ambient_light_cold"      - i.O.                                           hex_length 5  get sduino_dummy raw MU;;P1=363;;P2=-416;;P3=683;;P4=-755;;P5=-16073;;CP=1;;R=74;;D=123412341234123412341414123412341412351234123412341234123414141234123414123;;p;;w=0;;
#     0111001101  "ambient_light_warm"      - i.O.                                           hex_length 5  get sduino_dummy raw MU;;P0=381;;P2=-751;;P4=-419;;P5=678;;P6=-16060;;CP=0;;R=78;;D=6045204520452045204520202045452020452060452045204520452045202020454520204520;;p;;w=1;;
#     0110        "fan_minus"               - i.O.                                           hex_length 3  get sduino_dummy raw MU;;P0=388;;P1=-756;;P2=264;;P3=-399;;P4=683;;P5=-16082;;CP=0;;R=67;;D=0123410341034103410341050341034103410341034103410;;e;;w=0;;
#     0101        "fan_plus"                - i.O.                                           hex_length 3  get sduino_dummy raw MU;;P1=-16074;;P2=366;;P3=-757;;P6=-422;;P7=680;;CP=2;;R=81;;D=671267326732673267326732326712673267326732673267323267;;e;;w=0;;
#     0110011101  "fan_left"                - not assigned for Novy Cloud 230                hex_length 5  get sduino_dummy raw MU;;P0=378;;P2=-788;;P3=-434;;P4=649;;P5=-16070;;CP=0;;R=79;;D=02034203420203434202020342050342034203420342034202034342020203420;;p;;w=0;;
#     0110011010  "fan_right"               - not assigned for Novy Cloud 230                hex_length 5  get sduino_dummy raw MU;;P0=-16705;;P1=361;;P2=-2704;;P3=663;;P4=-778;;P5=-423;;CP=1;;R=68;;D=012341534153415341415353414153415301534153415341534153414153534141534153;;O;;w=0;;
#}
###############################################################################################################################################################################
# - CAME Drehtor Antrieb - remote CAME_TOP_432EV [Protocol 86] and [additionally Protocol 81]
#{    https://github.com/RFD-FHEM/RFFHEM/issues/151
#     nibble 0-1 -> Ident | nibble 2 -> Tastencode
#}    left_button   -   get sduino_dummy raw MU;;P0=-322;;P1=136;;P2=-15241;;P3=288;;P4=-735;;P6=723;;D=0123434343064343430643434306234343430643434306434343062343434306434343064343430623434343064343430643434306234343430643434306434343062343434306434343064343430623434343064343430643434306234343430643434306434343062343434306434343064343430;;CP=3;;R=27;;
###############################################################################################################################################################################
# - Hoermann HS1-868-BS [Protocol 69]
#{    https://github.com/RFD-FHEM/RFFHEM/issues/344 | https://github.com/RFD-FHEM/RFFHEM/issues/149
#                iiii iiii iiii iiii iiii iiii iiii bbbb
#      0000 0000 1111 0110 0010 1010 1001 1100 0000 0001 1100 (HS1-868-BS)
#}    get sduino_dummy raw MU;;P0=-578;;P1=1033;;P2=506;;P3=-1110;;P4=13632;;D=0101010232323101040101010101010101023232323102323101010231023102310231010232323101010101010101010232323101040101010101010101023232323102323101010231023102310231010232323101010101010101010232323101040101010101010101023232323102323101010231023102310231010;;CP=2;;R=77;;
###############################################################################################################################################################################
# - Hoermann HSM4 [Protocol 69]
#{    https://forum.fhem.de/index.php/topic,71877.msg642879.html (HSM4, Taste 1-4)
#               iiii iiii iiii iiii iiii iiii iiii bbbb
#     0000 0000 1110 0110 1011 1110 1001 0001 0000 0111 1100 (HSM4 Taste A)
#     0000 0000 1110 0110 1011 1110 1001 0001 0000 1011 1100 (HSM4 Taste B)
#     0000 0000 1110 0110 1011 1110 1001 0001 0000 1110 1100 (HSM4 Taste C)
#     0000 0000 1110 0110 1011 1110 1001 0001 0000 1101 1100 (HSM4 Taste D)
#}    get sduino_dummy raw MU;;P0=-3656;;P1=12248;;P2=-519;;P3=1008;;P4=506;;P5=-1033;;D=01232323232323232324545453232454532453245454545453245323245323232453232323245453245454532321232323232323232324545453232454532453245454545453245323245323232453232323245453245454532321232323232323232324545453232454532453245454545453245323245323232453232323;;CP=4;;R=48;;O;;
###############################################################################################################################################################################
# - Transmitter SF01 01319004 433,92 MHz (SF01_01319004) (NEFF / Refsta Topdraft kitchen hood) [Protocol 86]
#{    https://github.com/RFD-FHEM/RFFHEM/issues/376 | https://forum.fhem.de/index.php?topic=93545.0 | https://forum.fhem.de/index.php/topic,93545.msg908150.html#msg908150
#     Sends 18 bits, converting to hex in SIGNALduino.pm adds 2 bits of 0
#                   iiii iiii iiii ii bbbb aa   hex
#     ------------------------------------------------
#     Plus:         1010 0001 0101 00 1100 00   A15 30
#     Minus:        1010 0001 0101 00 1010 00   A15 28
#     Licht:        1010 0001 0101 00 1110 00   A15 38
#     Nachlüften:   1010 0001 0101 00 1001 00   A15 24
#     Intervall:    1010 0001 0101 00 1101 00   A15 34
#     ------------------------------------------------
#     i - ident, b - button, a - appended
#     plus         | get sduino_dummy raw MU;;P0=-220;;P1=348;;P2=-702;;P3=-381;;P4=662;;P5=-15257;;D=01213421342134342121343451213421343434342134213421343421213434512134213434343421342134213434212134345121342134343434213421342134342121343451213421343434342134213421343421213434512134213434343421342134213434212134345121342134343434213421342134342121343451;;CP=1;;R=6;;O;;
#     minus        | get sduino_dummy raw MU;;P0=-2112;;P1=340;;P2=-708;;P3=-381;;P4=660;;P5=-15243;;D=01213421343434342134213421343421342134512134213434343421342134213434213421345121342134343434213421342134342134213451213421343434342134213421343421342134512134213434343421342134213434213421345121342134343434213421342134342134213451213421343434342134213421;;CP=1;;R=7;;O;;
#     light_on_off | get sduino_dummy raw MU;;P0=-707;;P1=332;;P2=-376;;P3=670;;P5=-15243;;D=01012301232323230123012301232301010123510123012323232301230123012323010101235101230123232323012301230123230101012351012301232323230123012301232301010123510123012323232301230123012323010101235101230123232323012301230123230101012351012301232323230123012301;;CP=1;;R=3;;O;;
#     delay        | get sduino_dummy raw MU;;P0=-944;;P1=341;;P2=-695;;P3=-375;;P4=672;;P5=-15261;;D=01213421343434342134213421343421343421512134213434343421342134213434213434215121342134343434213421342134342134342151213421343434342134213421343421343421512134213434343421342134213434213434215121342134343434213421342134342134342151213421343434342134213421;;CP=1;;R=2;;O;;
#}    intervall    | get sduino_dummy raw MU;;P0=-372;;P1=330;;P2=684;;P3=-699;;P4=-14178;;D=010231020202023102310231020231310231413102310202020231023102310202313102314;;CP=1;;R=253;;
###
# - Transmitter SF01 01319004 (SF01_01319004_Typ2) 433,92 MHz (BOSCH kitchen) [Protocol 86]
#{                  iiii iiii iiii ii bbbb aa   hex
#     ------------------------------------------------
#     Plus:         0010 0110 0011 10 0100 00   263 90
#     Minus:        0010 0110 0011 10 0010 00   263 88
#     Licht:        0010 0110 0011 10 0110 00   263 98
#     Nachlüften:   0010 0110 0011 10 0001 00   263 84
#     Intervall:    0010 0110 0011 10 0101 00   263 94
#     ------------------------------------------------
#     i - ident, b - button, a - appended
#     get sduino_dummy raw MU;;P0=706;;P1=-160;;P2=140;;P3=-335;;P4=-664;;P5=385;;P6=-15226;;P7=248;;D=01210103045303045453030304545453030454530653030453030454530303045454530304747306530304530304545303030454545303045453065303045303045453030304545453030454530653030453030454530303045454530304545306530304530304545303030454545303045453065303045303045453030304;;CP=5;;O;;
#     get sduino_dummy raw MU;;P0=-15222;;P1=379;;P2=-329;;P3=712;;P6=-661;;D=30123236123236161232323616161232361232301232361232361612323236161612323612323012323612323616123232361616123236123230123236123236161232323616161232361232301232361232361612323236161612323612323012323612323616123232361616123236123230123236123236161232323616;;CP=1;;O;;
#     get sduino_dummy raw MU;;P0=705;;P1=-140;;P2=-336;;P3=-667;;P4=377;;P5=-15230;;P6=248;;D=01020342020343420202034343420202020345420203420203434202020343434202020203654202034202034342020203434342020202034542020342020343420202034343420202020345420203420203434202020343434202020203454202034202034342020203434342020202034542020342020343420202034343;;CP=4;;O;;
#     get sduino_dummy raw MU;;P0=704;;P1=-338;;P2=-670;;P3=378;;P4=-15227;;P5=244;;D=01023231010102323231010102310431010231010232310101023232310101025104310102310102323101010232323101010231043101023101023231010102323231010102310431010231010232310101023232310101023104310102310102323101010232323101010231043101023101023231010102323231010102;;CP=3;;O;;
#}    get sduino_dummy raw MU;;P0=-334;;P1=709;;P2=-152;;P3=-663;;P4=379;;P5=-15226;;P6=250;;D=01210134010134340101013434340101340134540101340101343401010134343401013601365401013401013434010101343434010134013454010134010134340101013434340101340134540101340101343401010134343401013401345401013401013434010101343434010134013454010134010134340101013434;;CP=4;;O;;
###############################################################################################################################################################################
# - Berner Garagentorantrieb GA401 | remote TEDSEN SKX1MD 433.92 MHz - 1 button | settings via 9 switch on battery compartment [Protocol 46]
#{    compatible with doors: BERNER SKX1MD, ELKA SKX1MD, TEDSEN SKX1LC, TEDSEN SKX1
#     https://github.com/RFD-FHEM/RFFHEM/issues/91
#     get sduino_dummy raw MU;;P0=-15829;;P1=-3580;;P2=1962;;P3=-330;;P4=245;;P5=-2051;;D=1234523232345234523232323234523234540023452323234523452323232323452323454023452323234523452323232323452323454023452323234523452323232323452323454023452323234523452323232323452323454023452323234523452323;;CP=2;;
#     GEIGER GF0001, 2 Button, DIP-Schalter: + 0 + - + + - 0 0
#     https://forum.fhem.de/index.php/topic,39153.0.html
#     rauf:   MU;P0=-32001;P1=2072;P2=-260;P3=326;P4=-2015;P5=-15769;D=01212123412123434121212123434123412351212123412123434121212123434123412351212123412123434121212123434123412351212123412123434121212123434123412351212123412123434121212123434123412351212123412123434121212123434123412351212123412123434121212123434123412351;CP=3;R=37;O;
#     runter: MU;P0=-15694;P1=2009;P2=-261;P3=324;P4=-2016;D=01212123412123434121212123434123434301212123412123434121212123434123434301212123412123434121212123434123434301212123412123434121212123434123434301212123412123434121212123434123434301;CP=3;R=30;
#     ???
#     MU;P0=313;P1=1212;P2=-309;P4=-2024;P5=-16091;P6=2014;D=01204040562620404626204040404040462046204040562620404626204040404040462046204040562620404626204040404040462046204040562620404626204040404040462046204040;CP=0;R=236;
#     MU;P0=-15770;P1=2075;P2=-264;P3=326;P4=-2016;P5=948;D=012121234121234341212121234341234343012125;CP=3;R=208;
#}
###############################################################################################################################################################################
# - Chilitec Großhandel 22640 - LED Christbaumkerzen mit Fernbedienung [Protocol 14]
#{    Taste -:    AA802     0010    brightness_minus
#     Taste Aus:  AA804     0100    power_off
#     Taste FL:   AA806     0110    flickering_fast
#     Taste Ein:  AA808     1000    power_on
#     Taste SL:   AA80A     1010    flickering_slowly
#     Taste +:    AA80C     1100    brightness_plus
#
#}    get sduino_dummy raw MS;;P0=988;;P1=-384;;P2=346;;P3=-1026;;P4=-4923;;D=240123012301230123012323232323232301232323;;CP=2;;SP=4;;R=0;;O;;m=1;;
###############################################################################################################################################################################
# - XM21-0 - LED Christbaumkerzen mit Fernbedienung [Protocol 76]
#{    button - ON
#     MU;P0=-205;P1=113;P3=406;D=010101010101010101010101010101010101010101010101010101010101030303030101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010103030303010101010101010101010100;CP=1;R=69;
#     MU;P0=-198;P1=115;P4=424;D=0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010404040401010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101040404040;CP=1;R=60;O;
#     MU;P0=114;P1=-197;P2=419;D=01212121210101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010121212121010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010
#     button - OFF
#     MU;P0=-189;P1=115;P4=422;D=0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101040404040101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010104040404010101010;CP=1;R=73;O;
#     MU;P0=-203;P1=412;P2=114;D=01010101020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020101010102020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020200;CP=2;R=74;
#     MU;P0=-210;P1=106;P3=413;D=0101010101010101010303030301010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101030303030100;CP=1;R=80;
#
#         iiiiiiiiiiiiii bb
#     ---------------------
#     P76#FFFFFFFFFFFFFF FF   - on
#}    P76#FFFFFFFFFFFFFF C    - off
###############################################################################################################################################################################
# - Krinner LUMIX - LED X-MAS model 572152 [Protocol 92]
#{    button - ON
#     MU;P0=-592;P1=112;P2=-968;P3=413;P4=995;P5=-394;P6=-10161;D=01232323245453245453232323232323232454645324532323232323245453245453232323245453245453232323232323232454645324532323232323245453245453232323245453245453232323232323232454645324532323232323245453245453232323245453245453232323232323232454;CP=3;R=25;
#     MU;P0=24188;P1=-16308;P2=993;P3=-402;P4=416;P5=-967;P6=-10162;D=0123234545454523234523234545454545454545232623452345454545454523234523234545454523234523234545454545454545232623452345454545454523234523234545454523234523234545454545454545232623452345454545454523234523234545454523234523234545454545454545232;CP=4;R=25;
#     button - OFF
#     MU;P0=417;P1=-558;P2=975;P3=272;P4=-974;P5=140;P6=-419;P7=-10150;D=01213454040426260426260404040404040404042726042604040404040426260426260404040426260426260404040404040404042726042604040404040426260426260404040426260426260404040404040404042726042604040404040426260426260404040426260426260404040404040404042;CP=0;R=37;
#     MU;P0=11076;P1=-20524;P2=281;P3=-980;P4=982;P5=-411;P6=408;P7=-10156;D=0123232345456345456363636363636363634745634563636363636345456345456363636345456345456363636363636363634745634563636363636345456345456363636345456345456363636363636363634745634563636363636345456345456363636345456345456363636363636363634;CP=6;R=38;
#
#         iiiiiii b
#     ----------- -
#     P92#A06C360 1
#}    P92#A06C360 0
###############################################################################################################################################################################
# - Atlantic Security / Focus Security China Devices | door/windows switch MD-210R | Vibration Schock Sensor MD-2018R | GasSensor MD-2003R [Protocol 91] & [Protocol 91.1]
#     https://forum.fhem.de/index.php/topic,95346.0.html | https://forum.fhem.de/index.php?topic=95346.msg881810#msg881810 | https://github.com/RFD-FHEM/RFFHEM/issues/477
#     36bit = 24bit DeviceID + 8bit Commando (4 Bit -> Sabo,Contact,Contact extern,keepalive or batterie | 4 bit -> typ) + 4bit Check | all nibbles are XOR = 0
#     i ident | s sabo | c contact intern | e contact extern | k keepalive (battery?) | t typ | C ckecksumme
#
#{  door/windows switch MD_210R
#
#     iiiiiiiiiiiiiiiiiiiiiiiiscekttttCCCC
#     ------------------------------------
#     Kontakt auf | Gehäuse auf   get sduino_dummy raw MS;;P1=-410;;P2=807;;P3=-803;;P4=394;;P5=-3994;;D=45412123434123412123434341234123434121234123412121234341234343434123412343;;CP=4;;SP=5;;R=30;;O;;m2;;
#     Kontakt zu  | Gehäuse auf   get sduino_dummy raw MS;;P0=-397;;P1=816;;P2=-804;;P3=407;;P4=-4007;;D=34301012323012301012323230123012323010123012301010123010123232323012323232;;CP=3;;SP=4;;R=71;;O;;m2;;
#     Kontakt auf | Gehäuse zu    get sduino_dummy raw MS;;P1=-404;;P2=813;;P3=-794;;P4=409;;P5=-4002;;D=45412123434123412123434341234123434121234123412121212341234343434121212343;;CP=4;;SP=5;;R=65;;m0;;
#     Kontakt zu  | Gehäuse zu    get sduino_dummy raw MS;;P0=-800;;P1=402;;P2=-401;;P3=806;;P4=-3983;;D=14123230101230123230101012301230101232301230123232323232301010101232301010;;CP=1;;SP=4;;R=57;;O;;m2;;
#}
#{  Vibration Schock Sensor MD-2018R | water sensor MD_230R
#
#     iiiiiiiiiiiiiiiiiiiiiiiisc?kttttCCCC
#     ------------------------------------
#     get sduino_dummy raw MS;;P0=-404;;P1=383;;P2=-797;;P3=778;;P4=-3934;;D=14103030321032121032103030303030321210321032103210303030321032103032103212;;CP=1;;SP=4;;R=0;;
#     get sduino_dummy raw MU;;P0=776;;P1=-409;;P2=-802;;P3=379;;P4=-3946;;D=010102310102323231043101010231023231023101010101010232310231023102310102310101023101023232310431010102310232310231010101010102323102310231023101023101010231010232323100;;CP=3;;R=0;;
#}
#{  GasSensor MD-2003R
#
#     iiiiiiiiiiiiiiiiiiiiiiiisc?kttttCCCC
#     ------------------------------------
#     get sduino_dummy raw MU;;P0=-164;;P1=378;;P2=-813;;P3=-429;;P4=764;;P5=-3929;;D=0121212134342121343434343421342121212121213434343421212134342134213451212121212121343421213434343434213421212121212134343434212121343421342134512121212121213434212134343434342134212121212121343434342121213434213421345121212121212134342121343434343421342;;CP=1;;R=0;;O;;
#     get sduino_dummy raw MU;;P1=-419;;P2=380;;P3=-810;;P5=767;;P6=-3912;;P7=-32001;;D=262323232323232151532321515151515321532323232323215321515153232151515153232;;CP=2;;R=0;;
#}
###############################################################################################################################################################################
# - Manax | MX-RCS270 , Typ: RCS-10 | MX-RCS250 / mumbi | m-FS300 [Protocol 90] and [additionally Protocol 93]
#{  Manax https://forum.fhem.de/index.php/topic,94327.0.html remote MANAX MX-RCS250
#
#     i ident | b button | ? unknown
#     iiii iiii iiii iiii ???? bbbb ???? ???? ?????
#     ---------------------------------------------
#     Taste A Ein: MS;P1=274;P2=-865;P3=787;P4=-349;P5=-10168;D=15123412121212343434341212341234341212121234343434341234121212123412;CP=1;SP=5;R=46;O;m2;
#     Taste A Aus: MS;P1=285;P2=-858;P3=794;P4=-341;P6=-10162;D=16123412121212343434341212341234341212121234343412341234121212121212;CP=1;SP=6;R=61;O;m2;
#     Taste B Ein: MS;P1=269;P2=-872;P3=795;P4=-338;P6=-10174;D=16123412121212343434341212341234341212121234341234341234121212341212;CP=1;SP=6;R=73;O;m2;
#     Taste B Aus: MS;P1=264;P2=-863;P3=795;P4=-348;P7=-10167;D=17123412121212343434341212341234341212121234341212341234121212343412;CP=1;SP=7;R=73;O;m2;
#     Taste C Ein: MS;P0=-851;P1=283;P2=805;P3=-343;P4=-10146;D=14102310101010232323231010231023231010101023102323231023101023231010;CP=1;SP=4;R=65;O;m2;
#     Taste C Aus: MS;P0=-337;P1=766;P3=273;P4=-862;P5=-10178;D=35341034343434101010103434103410103434343410341034103410343410101034;CP=3;SP=5;R=55;m2;
#     Taste D Ein: MS;P1=261;P2=-872;P3=794;P4=-349;P6=-10168;D=16123412121212343434341212341234341212121212343434341234123434341212;CP=1;SP=6;R=58;O;m2;
#     Taste D Aus: MS;P1=281;P2=-862;P3=790;P4=-342;P6=-10160;D=16123412121212343434341212341234341212121212343412341234123434343412;CP=1;SP=6;R=61;O;m2;
#     Taste Alles Ein: MS;P2=-841;P3=294;P4=812;P6=-325;P7=-10140;D=37324632323232464646463232463246463232323232463232463246324646324632;CP=3;SP=7;R=68;O;m2;
#     Taste Alles Aus: MS;P1=282;P2=-844;P3=816;P4=-330;P6=-10153;D=16123412121212343434341212341234341212121234121212341234121234123412;CP=1;SP=6;R=65;O;m2;
#
# - mumbi m-FS300 https://github.com/RFD-FHEM/RFFHEM/issues/60
#   ...
#
#     SET mumbi AFS300-s  https://forum.fhem.de/index.php/topic,94327.msg953226.html#msg953226 | https://forum.fhem.de/index.php/topic,94327.msg953235.html#msg953235
#     remote control typ RC-10 | random code wireless switch typ RCS-22GS
#     Taste A on    : MS;P1=781;P3=-372;P4=251;P5=-903;P6=-10342;D=46451313131345454545131345134545134545454513131313454513454513451345;CP=4;SP=6;O;m1;E;
#     Taste A off   : MS;P1=790;P2=-363;P3=257;P4=-896;P5=-10283;D=35341212121234343434121234123434123434343412121234343412343412343434;CP=3;SP=5;O;m2;C;C;
#     Taste B on    : MS;P0=-367;P2=-892;P3=265;P4=-10335;P5=787;D=34325050505032323232505032503232503232323250503250323250323250503232;CP=3;SP=4;O;m2;2;P;
#     Taste B off   : MS;P0=264;P1=-367;P2=791;P4=-887;P6=-10335;D=06042121212104040404212104210404210404040421210404040421040421212104;CP=0;SP=6;O;m2;
#     Taste C on    : MS;P0=-887;P1=790;P2=-361;P3=265;P5=-10342;D=35301212121230303030121230123030123030303012301212303012303030301230;CP=3;SP=5;O;m2;0;0;
#     Taste C off   : MS;P0=794;P1=-364;P2=265;P3=-885;P4=-10325;D=24230101010123232323010123012323012323232301230123232301232323232323;CP=2;SP=4;O;m1;
#     Taste D on    : MS;P0=-884;P1=790;P2=-365;P3=272;P4=-10323;D=34301212121230303030121230123030123030303030121212303012301230301230;CP=3;SP=4;O;m1;0;
#     Taste D off   : MS;P1=-364;P2=264;P3=-892;P4=787;P5=-10331;D=25234141414123232323414123412323412323232323414123232341234123232323;CP=2;SP=5;O;m2;A;
#     Taste All on  : MS;P1=-361;P2=267;P3=-884;P4=792;P5=-10342;D=25234141414123232323414123412323412323232323412323232341234123414123;CP=2;SP=5;O;m2;A;
#     Taste All off : MS;P1=-363;P2=789;P3=267;P4=-887;P5=-10332;D=35342121212134343434212134213434213434343421343434343421343434212134;CP=3;SP=5;O;m2;4;
#}
###############################################################################################################################################################################
# - ESTO Lighting GmbH | remote control KL-RF01 with 9 buttons (CP 375-395) [Protocol 93] and [additionally Protocol 90]
#{    https://github.com/RFD-FHEM/RFFHEM/issues/449
#}
###############################################################################################################################################################################
# - Techmar / Garden Lights Fernbedienung, 6148011 Remote control + 12V Outdoor receiver [Protocol 95]
#{    https://github.com/RFD-FHEM/RFFHEM/issues/558 @BlackcatSandy
#     Fernbedienung mit 10 Tasten, 9 Gruppentasten und 1 Master
#     gesamt 50 Bit, Bit 0-31 Ident, Bit 32-39 Button, Bit 40-47 = Bit 32-39 invertiert, Bit 48-49 wechselt 00|01|02
#     Die letzten beiden Bits wechseln bei der Fernbedienung zwischen 00, 01 oder 02. Der Empfänger reagiert aber auch, wenn nur 00 gesendet wird.
#     sendet bei jedem Tastendruck ca. 50 Wiederholungen, Dauer etwa 6 Sekunden
#
#     Group_1_on:  MU;P0=-972;P1=526;P2=-335;P3=-666;D=01213131312131313121212121312121313131313121312131313121313131312121212121312121313131313121313121212101213131312131313121212121312121313131313121312131313121313131312121212121312121313131313121313121212101213131312131313121212121312121313131313121312131;CP=1;R=44;O;
#     Group_5_on:  MU;P0=-651;P1=530;P2=-345;P3=-969;D=01212121312101010121010101212121210121210101010101210121010101210101010121212121012121210101010121010101212101312101010121010101212121210121210101010101210121010101210101010121212121012121210101010121010101212121312101010121010101212121210121210101010101;CP=1;R=24;O;
#     Group_8_off: MU;P0=538;P1=-329;P2=-653;P3=-964;D=01020301020202010202020101010102010102020202020102010202020102020202010101010101010201020202020202010202010301020202010202020101010102010102020202020102010202020102020202010101010101010201020202020202010201010301020202010202020101010102010102020202020102;CP=0;R=19;O;
#}
###############################################################################################################################################################################
# - Medion OR28V RF Vista Remote Control (Made in china by X10) [Protocol 68]
#{  !! sendet zwei verschiedene Codes pro Taste (ausser power) !!
#     Taste ok    MS;P1=-1746;P2=513;P3=-571;P4=-4612;P5=2801;D=24512321212123232121212323212121212323232323;CP=2;SP=4;R=58;#;#;
#     Taste ok    MS;P1=-1712;P2=518;P3=-544;P4=-4586;P5=2807;D=24512121212123232121232323212121212323232323;CP=2;SP=4;R=58;m2;#;#;
#     Taste Vol+  MS;P1=-1620;P2=580;P3=-549;P4=-4561;P5=2812;D=24512121212323232323232323232123212123232323;CP=2;SP=4;R=69;O;m2;#;#;
#     Taste Vol+  MS;P1=-1645;P2=574;P3=-535;P4=-4556;P5=2811;D=24512321212323232323212323232123212123232323;CP=2;SP=4;R=57;m2;#;#;
#}
###############################################################################################################################################################################
# - Remote control with 4 buttons for diesel heating [Protocol 20]
#{    https://forum.fhem.de/index.php/topic,58397.msg999475.html#msg999475 @ fhem_user0815 2019-12-04
#     RCnoName20_17E9 on     MS;P0=-740;P2=686;P3=-283;P5=229;P6=-7889;D=5650505023502323232323235023505023505050235050502323502323505050;CP=5;SP=6;R=67;O;m2;
#     RCnoName20_17E9 off    MS;P1=-754;P2=213;P4=681;P5=-283;P6=-7869;D=2621212145214545454545452145212145212121212145214521212121452121;CP=2;SP=6;R=69;O;m2;
#     RCnoName20_17E9 plus   MS;P1=-744;P2=221;P3=679;P4=-278;P5=-7860;D=2521212134213434343434342134212134212121213421212134343434212121;CP=2;SP=5;R=66;O;m2;
#     RCnoName20_17E9 minus  MS;P0=233;P1=-7903;P3=-278;P5=-738;P6=679;D=0105050563056363636363630563050563050505050505630563050505630505;CP=0;SP=1;R=71;O;m1;
#}
# - Remote control with 10 buttons for Leroy Deckenventilator [Protocol 20]
#{    https://forum.fhem.de/index.php/topic,53282.msg1233431.html#msg1233431 @ steffen83 2022-09-01
#     RCnoName20_10_3E00 light_on   MU;P0=-8774;P1=282;P2=-775;P3=815;P4=-253;P5=-32001;D=10121234343434341212121212121212121212123434343412121234343412343415;CP=1;
#     RCnoName20_10_3E00 light_off  MU;P0=-238;P1=831;P3=300;P4=-762;P5=-363;P6=192;P7=-8668;D=01010101010343434343434343434343434103415156464156464641564646734341010101010343434343434343434343434103410103434103434341034343734341010101010343434343434343434343434103410103434103434341034343734341010101010343434343434343434343434103410103434103434341;CP=3;O;
#     RCnoName20_10_3E00 fan_stop   MU;P0=184;P1=-380;P2=128;P3=-9090;P4=-768;P5=828;P6=-238;P7=298;D=45656565656747474747474747474747474567474560404515124040451040374745656565656747474747474747474747474567474567474565674747456747374745656565656747474747474747474747474567474567474565674747456747374745656565656747474747474747474747474567474567474565674747;CP=7;O;
#}
# - Remote control DC-1961-TG with 12 buttons for ceiling fan with lighting [Protocol 20]
#{    https://forum.fhem.de/index.php/topic,53282.msg1240911.html#msg1240911 @ Skusi  2022-10-23
#     DC_1961_TG_1846 light_on_off   MS;P1=291;P2=-753;P3=762;P4=-249;P5=-8312;D=151212123434121212123412121234341234123412341212121234341212341234;CP=1;SP=5;R=224;O;m2;
#     DC_1961_TG_1846 fan_off        MS;P1=-760;P2=747;P3=-282;P4=253;P5=-8335;D=454141412323414141412341414123234123412341412323234123232323412323;CP=4;SP=5;R=27;O;m2;
#     DC_1961_TG_1846 fan_direction  MS;P0=-8384;P1=255;P2=-766;P3=754;P4=-263;D=101212123434121212123412121234341234123412341212341234341212341212;CP=1;SP=0;R=27;O;m2;
#}
###############################################################################################################################################################################
# - Remote control Momento for wireless digital picture frame [Protocol 97]
#{    elektron-bbs 2020-03-21
#     0x0000064147
#     iiiiiiibss - i = 7 nibbles ident, b = 1 nibble button code, s = 1 byte checksum over 4 bytes
#     Short press repeatedly message 3 times, long press repeatedly until release.
#     When sending, the original message is not reproduced, but the recipient also reacts to the messages generated in this way.
#     Momento_0000064 play/pause MU;P0=-294;P1=237;P2=5829;P3=-3887;P4=1001;P5=-523;P6=504;P7=-995;D=01010101010101010101010234545454545454545454545454545454545454545456767454567454545456745456745456745454523454545454545454545454545454545454545454545676745456745454545674545674545674545452345454545454545454545454545454545454545454567674545674545454567454;CP=4;R=45;O;
#     Momento_0000064 power      MU;P0=-998;P1=-273;P2=256;P3=5830;P4=-3906;P5=991;P6=-527;P7=508;D=12121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121345656565656565656565656565656565656565656567070565670565656565670567056565670707034565656565656565656565656565656565656565656707056567;CP=2;R=40;O;
#     Momento_0000064 up         MU;P0=-1005;P1=-272;P2=258;P3=5856;P4=-3902;P5=1001;P6=-520;P7=508;D=0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121213456565656565656565656565656565656565656565670705656705656567056565670565670567056345656565656565656565656565656565656565656567070565;CP=2;R=63;O;
#}
###############################################################################################################################################################################
# - NAVARIS touch light switch Model No.: 44344.04 [Protocol 99]
#{    elektron-bbs 2020-04-14
#     only one touch button
#     Navaris_211073   MU;P0=-302;P1=180;P2=294;P3=-208;P4=419;P5=-423;D=01023101010101023232310102323451010231010101023101010231010101010232323101023234510102310101010231010102310101010102323231010232345101023101010102310101023101010101023232310102323451010231010101023101010231010101010232323101023234510102310101010231010102;CP=1;R=36;O;
#     Navaris_13F8E3   MU;P0=406;P1=-294;P2=176;P3=286;P4=-191;P6=-415;D=01212134212134343434343434212121343434212121343406212121342121343434343434342121213434342121213434062121213421213434343434343421212134343421212134340621212134212134343434343434212121343434212121343406212121342121343434343434342121213434342121213434062121;CP=2;R=67;O;
#}
###############################################################################################################################################################################
# - Remote control BF-301 from Shenzhen BOFU Mechanic & Electronic Co., Ltd. [Protocol 105]
#{    elektron-bbs 2020-06-28
#     Protocol description found on https://github.com/akirjavainen/markisol/blob/master/Markisol.ino
#     original remotes repeat 8 (multi) or 10 (single) times by default
#     https://github.com/RFD-FHEM/RFFHEM/issues/861 stsirakidis 2020-06-27
#     BF_301_FAD0 down   MU;P0=-697;P1=5629;P2=291;P3=3952;P4=-2459;P5=1644;P6=-298;P7=689;D=34567676767676207620767620762020202076202020762020207620202020207676762076202020767614567676767676207620767620762020202076202020762020207620202020207676762076202020767614567676767676207620767620762020202076202020762020207620202020207676762076202020767614;CP=2;R=41;O;
#     BF_301_FAD0 stop   MU;P0=5630;P1=3968;P2=-2458;P3=1642;P4=-285;P5=690;P6=282;P7=-704;D=12345454545454675467545467546767676754676767546754675467676767675454546754676767675402345454545454675467545467546767676754676767546754675467676767675454546754676767675402345454545454675467545467546767676754676767546754675467676767675454546754676767675402;CP=6;R=47;O;
#     BF_301_FAD0 up     MU;P0=-500;P1=5553;P2=-2462;P3=1644;P4=-299;P5=679;P6=298;P7=-687;D=01234545454545467546754546754676767675467676767675454546767676767545454675467546767671234545454545467546754546754676767675467676767675454546767676767545454675467546767671234545454545467546754546754676767675467676767675454546767676767545454675467546767671;CP=6;R=48;O;
#}
###############################################################################################################################################################################
# - Remote control AC114-01B from Shenzhen A-OK Technology Grand Development Co. [Protocol 56]
#{    elektron-bbs 2020-12-04
#     Protocol description found on https://github.com/akirjavainen/A-OK
#     Command is sent repeatedly at least 3 times, followed by a second command at least 3 times for button up and down. This command is always the same and is not evaluated.
#     Series of various remote controls with different numbers of channels: AC114-01, AC114-02, AC114-06, AC114-16. Currently only AC114-01B implemented.
#     https://forum.fhem.de/index.php/topic,52025.0.html @Horst12345
#     AC114_01B_00587B down MU;P0=5036;P1=-624;P2=591;P3=-227;P4=187;P5=-5048;D=0123412341414123234141414141414141412341232341414141232323234123234141414141414123414141414141414141234141414123234141412341232323250123412341414123234141414141414141412341232341414141232323234123234141414141414123414141414141414141234141414123234141412;CP=4;O;
#     Alphavision Slender Line Plus motor canvas, remote control AC114-01B:
#     https://github.com/RFD-FHEM/RFFHEM/issues/906 @TheChatty
#     AC114_01B_479696 up   MU;P0=-16412;P1=5195;P2=-598;P3=585;P4=-208;P5=192;D=01234523452525234345234525252343434345252345234345234525234523434525252525252525234525252525252525252525252345234345234343434343434341234523452525234345234525252343434345252345234345234525234523434525252525252525234525252525252525252525252345234345234343;CP=5;R=105;O;
#     AC114_01B_479696 stop MU;P0=-2341;P1=5206;P2=-571;P3=591;P4=-211;P5=207;D=01234523452525234345234525252343434345252345234345234525234523434525252525252525234525252525252525252523452525234343452523452343434341234523452525234345234525252343434345252345234345234525234523434525252525252525234525252525252525252523452525234343452523;CP=5;R=107;O;
#}
###############################################################################################################################################################################
# - Remote control for motorized screen from Visivo [Protocol 24]
#{    elektron-bbs 2020-12-12
#     The protocol could not be fully verified as only messages from a remote control were available.
#     https://forum.fhem.de/index.php/topic,42273.msg368989.html#msg368989 @MikeRoxx
#     Visivo_7DF825 up    MU;P0=505;P1=140;P2=-771;P3=-225;P5=4558;D=012031212030303030312030303030312030303030303121212121203121203120312121212121203120312120303031212121212031212121252031212030303030312030303030312030303030303121212121203121203120312121212121203120312120303031212121212031212121252031212030;CP=1;O;
#     Visivo_7DF825 down  MU;P0=147;P1=-220;P2=512;P3=-774;P5=4548;D=001210303210303212121210303030321030303035321030321212121210321212121210321212121212103030303032103032103210303030303210303210303212121210303030321030303035321030321212121210321212121210321212121212103030303032103032103210303030303210303210;CP=0;O;
#     Visivo_7DF825 stop  MU;P0=-764;P1=517;P2=-216;P3=148;P5=4550;D=012303012121212123012121212123012121212121230303030301230301230123030303012303030123012303030123030303012303030305012303012121212123012121212123012121212121230303030301230301230123030303012303030123012303030123030303012303030305012303012120;CP=3;O;
#}
###############################################################################################################################################################################
# - Remote control SEAV BeSmart S4 for BEST Cirrus Draw (07F57800) Deckenluefter [Protocol 78]
#{    elektron-bbs 2020-12-21
#     The protocol could not be fully verified as only messages from one remote control were available.
#     This remote control is also available with a neutral keyboard. The set commands were set up according to the user's wishes.
#     https://github.com/RFD-FHEM/RFFHEM/issues/909 @TheChatty
#     BeSmart_S4_534 light_toggle MU;P0=-19987;P1=205;P2=-530;P3=501;P4=-253;P6=-4094;D=01234123412123434123412123412123412121216123412341212343412341212341212341212121612341234121234341234121234121234121212161234123412123434123412123412123412121216123412341212343412341212341212341212121;CP=1;R=70;
#     BeSmart_S4_534 5min_boost   MU;P0=-23944;P1=220;P2=-529;P3=483;P4=-252;P5=-3828;D=01234123412123434123412123412121212121235123412341212343412341212341212121212123512341234121234341234121234121212121212351234123412123434123412123412121212121235123412341212343412341212341212121212123;CP=1;R=74;
#     BeSmart_S4_534 level_up     MU;P0=-8617;P1=204;P2=-544;P3=490;P4=-246;P6=-4106;D=01234123412123434123412123412121234121216123412341212343412341212341212123412121612341234121234341234121234121212341212161234123412123434123412123412121234121216123412341212343412341212341212123412121;CP=1;R=70;
#     BeSmart_S4_534 level_down   MU;P0=-14542;P1=221;P2=-522;P3=492;P4=-240;P5=-4114;D=01234123412123434123412123412121212341215123412341212343412341212341212121234121512341234121234341234121234121212123412151234123412123434123412123412121212341215123412341212343412341212341212121234121;CP=1;R=62;
#}
###############################################################################################################################################################################
# - Remote control TR401 [Protocol 114]
#{    Ralf9 2021-05-16 and added 2021-07-28 after a notice from user Ralf9 & Jake
#     Well-Light is only distributor, manufacturer CIXI CITY Sanity Light-Marking Co. Ltd. / China
#     https://forum.fhem.de/index.php/topic,121103
#     TR401_0_2 off  MU;P0=311;P1=585;P2=-779;P3=1255;P4=-1445;P5=-23617;P7=-5646;CP=1;R=230;D=12323234141414141514123414123232341414141415141234141232323414141414151412341412323234141414141514123414123232341414141415141234141232323414141414151412341412323234141414141517141232323414141414150;p;
#     TR401_0_2 off  MU;P0=-14293;P1=611;P2=-1424;P3=-753;P4=1277;P5=-23626;P6=-9108;P7=214;CP=1;R=240;D=1213421213434342121212121512134212134343421212121216701213421213434342121212121512134212134343421212121215121342121343434212121212151213421213434342121212121512134212134343421212121215121342121343434212121212151213421213434342121212121512134212134343421212121215121342121343434212121212151;p;
#     TR401_0_2 on   MU;P0=-1426;P1=599;P2=-23225;P3=-748;P4=1281;P5=372;P6=111;P7=268;CP=1;R=235;D=0121343401013434340101010101252621343401013434340101010101252705012134340101343434010101010125;p;
#     TR401_0_2 on   MU;P0=-14148;P1=-23738;P2=607;P3=-737;P4=1298;P5=-1419;P6=340;P7=134;CP=2;R=236;D=12343452523434345252525252161712343452523434345252525252160;p;
#}
###############################################################################################################################################################################
# - Remote controls Meikee [Protocol 118]
#{    elektron-bbs 2022-02-13
#     https://forum.fhem.de/index.php/topic,126110.0.html @ Sepp 2022-02-09
#     Meikee_24 - remote control with 24 buttons
#     Meikee_24_20D3 on     MU;P0=506;P1=-1015;P2=1008;P3=-523;P4=-12696;D=01012301040101230101010101232301230101232301010101010123010;CP=0;R=49;
#     Meikee_24_20D3 off    MU;P0=-516;P1=518;P2=-1015;P3=1000;P4=-12712;D=01230121230301212121212121230141212301212121212303012301212303012121212121212301;CP=1;R=35;
#     Meikee_24_20D3 learn  MU;P0=-509;P1=513;P2=-999;P3=1027;P4=-12704;D=01230121230301212121212121212141212301212121212303012301212303012121212121212121;CP=1;R=77;
#     Meikee_21 - remote control with 21 buttons
#     Same codes as Meikee_24, but different key assignments.
#}
###############################################################################################################################################################################
# - Remote control Busch-Transcontrol HF - Handsender 6861 [Protocol 121]
#{    elektron-bbs 2022-05-25
#     TC6861_3DC_1 OFF   MU;P0=28479;P1=-692;P2=260;P3=574;P4=-371;D=0121212121212134343434213434342121213434343434342;CP=2;R=41; 
#     TC6861_3DC_1 ON    MU;P0=4372;P1=-689;P2=254;P3=575;P4=-368;D=0121213434212134343434213434342121213434343434342;CP=2;R=59;
#}
###############################################################################################################################################################################
# - Remote control with 14 buttons RCnoName127 for ceiling fan [Protocol 127]
#{    elektron-bbs 2023-07-08
#     RCnoName127_3603A fan_off       MU;P0=5271;P1=-379;P2=1096;P3=368;P4=-1108;P5=-5997;D=01213434213434212121212121213434342134212121343421343434212521213434213434212121212121213434342134212121343421343434212521213434213434212121212121213434342134212121343421343434212521213434213434212121212121213434342134212121343421343434212;CP=3;R=63;
#     RCnoName127_3603A fan_1         MS;P1=-385;P2=1098;P3=372;P4=-1108;P5=-6710;D=352121343421343421212121212121343434213421212121213421343434;CP=3;SP=5;R=79;m2;
#     RCnoName127_3603A light_on_off  MS;P1=-372;P2=1098;P3=376;P4=-1096;P5=-6712;D=352121343421343421212121212121343434213421342134212134213421;CP=3;SP=5;R=73;m2;
#}
###############################################################################################################################################################################
# - Remote control with 12 buttons RCnoName128 for ceiling fan [Protocol 128]
#{    elektron-bbs 2023-07-19
#     RCnoName128_8A7F fan_slower      MU;P0=-420;P1=1207;P2=-1199;P3=424;P4=-10154;D=010101230123010123232323232323232323230123010143230101012301230101232323232323232323232301230101432301010123012301012323232323232323232323012301014323010101230123010123232323232323232323230123010143230101012301230101232323232323232323232301230101;CP=3;R=18;
#     RCnoName128_8A7F fan_on_off      MS;P2=-424;P3=432;P4=1201;P5=-1197;P6=-10133;D=36353242424532453242453535353535353535353532453535;CP=3;SP=6;R=36;m1;
#     RCnoName128_8A7F fan_direction   MS;P0=-10144;P4=434;P5=-415;P6=1215;P7=-1181;D=40474565656745674565674747474747474747474745656567;CP=4;SP=0;R=37;m2;
#}
###############################################################################################################################################################################
# !!! ToDo´s !!!
#     - LED lights, counter battery-h reading --> commandref hour_counter module
#     -
###############################################################################################################################################################################

package main;

use strict;
use warnings;
use FHEM::Meta;
no warnings 'portable';  # Support for 64-bit ints required

our $VERSION = '2023-07-19';

sub SD_UT_bin2tristate;
sub SD_UT_tristate2bin;

### HASH for all modul models ###
my %models = (
  # keys(model) => values
  'Buttons_five' => { '011111'   => '1_fan_low_speed',
                      '111111'   => '2_fan_medium_speed',
                      '111101'   => '3_fan_high_speed',
                      '101111'   => 'light_on_off',
                      '111110'   => 'fan_off',
                      hex_length => [3],
                      Protocol   => 'P29',
                      Typ        => 'remote'
                    },
  'Buttons_six' => { '011111'   => '1_fan_low_speed',
                     '111011'   => '2_fan_medium_speed',
                     '111101'   => '3_fan_high_speed',
                     '111110'   => 'fan_off',
                     '101111'   => 'light_on_off',
                     '110111'   => 'light_dimm',
                      hex_length => [3],
                      Protocol   => 'P29',
                      Typ        => 'remote'
                    },
  'CAME_TOP_432EV' => { '1110'     => 'left_button',
                        '1101'     => 'right_button',
                        hex_length => [3],
                        Protocol   => 'P86',
                        Typ        => 'remote'
                      },
  'Chilitec_22640' => { '0010'     => 'brightness_minus',
                        '0100'     => 'power_off',
                        '0110'     => 'flickering_fast',
                        '1000'     => 'power_on',
                        '1010'     => 'flickering_slowly',
                        '1100'     => 'brightness_plus',
                        hex_length => [5],
                        Protocol   => 'P14',
                        Typ        => 'remote'
                      },
  'HS1_868_BS' => { '0'        => 'send',
                    hex_length => [11],
                    Protocol   => 'P69',
                    Typ        => 'remote'
                  },
  'HSM4' => { '0111'     => 'button_1',
              '1011'     => 'button_2',
              '1110'     => 'button_3',
              '1101'     => 'button_4',
              hex_length => [11],
              Protocol   => 'P69',
              Typ        => 'remote'
            },
  'Krinner_LUMIX' =>  { '0000'     => 'off',
                        '0001'     => 'on',
                        Protocol   => 'P92',
                        hex_length => [8],
                        Typ        => 'remote'
                      },
  'OR28V' =>  { '000000'   => 'volume_mute',
                '000010'   => 'power',
                '000100'   => 'tv_guide',
                '001000'   => 'volume_minus',
                '001001'   => 'volume_plus',
                '001011'   => 'channel_plus',
                '001100'   => 'channel_minus',
                '001101'   => '1',
                '001110'   => '2',
                '001111'   => '3',
                '010000'   => '4',
                '010001'   => '5',
                '010010'   => '6',
                '010011'   => '7',
                '010100'   => '8',
                '010101'   => '9',
                '010110'   => 'T',
                '010111'   => '0',
                '011000'   => 'tv_record',
                '011010'   => 'arrow_up',
                '011011'   => 'menu',
                '011100'   => 'tv_play',
                '011101'   => 'arrow_left',
                '011110'   => 'ok',
                '011111'   => 'arrow_right',
                '100000'   => 'back',
                '100001'   => 'video_back',
                '100010'   => 'arrow_down',
                '100011'   => 'video_forward',
                '100100'   => 'video_rewind',
                '100101'   => 'video_play',
                '100110'   => 'video_fastforward',
                '100111'   => 'video_record',
                '101000'   => 'video_stop',
                '101001'   => 'video_pause',
                '101111'   => 'info',
                '110000'   => 'clear',
                '110001'   => 'tv_list',
                '110010'   => 'color_red',
                '110011'   => 'color_green',
                '110100'   => 'color_yellow',
                '110101'   => 'color_blue',
                '110110'   => 'enter',
                '110111'   => '*',
                '111000'   => '#',
                Protocol   => 'P68',
                hex_length => [5],
                Typ        => 'remote'
              },
  'Novy_840029' =>  { '0100'       => 'novy',
                      '0101'       => 'speed_plus',
                      '0110'       => 'speed_minus',
                      '0111010001' => 'light_on_off',  # 0111010000
                      '0111010011' => 'power_on_off',  # 0111010010
                      hex_length   => [3,5],           # 3 or 5, not 3.5
                      Protocol     => 'P86',
                      Typ          => 'remote'
                    },
  'Novy_840039' =>  { '0101'       => 'fan_plus',                # Novy_840029 same code!
                      '0110'       => 'fan_minus',               # Novy_840029 same code!
                      '0110011010' => 'fan_right',
                      '0110011101' => 'fan_left',
                      '0110110011' => 'cooking_light_dim_minus',
                      '0110110100' => 'cooking_light_off',
                      '0110110101' => 'cooking_light_dim_plus',
                      '0110110110' => 'cooking_light_on',
                      '0110111011' => 'ambient_light_dim_minus',
                      '0110111100' => 'ambient_light_off',
                      '0110111101' => 'ambient_light_dim_plus',
                      '0110111110' => 'ambient_light_on',
                      '0111001000' => 'reset_clean_led',
                      '0111001011' => 'cooking_light_warm',
                      '0111001101' => 'ambient_light_warm',
                      '0111001110' => 'cooking_light_cold',
                      '0111010011' => 'power_on_off',            # Novy_840029 same code!
                      '0111010110' => 'ambient_light_cold',
                      hex_length   => [3,5],                     # 3 or 5, not 3.5
                      Protocol     => 'P86',
                      Typ          => 'remote'
                    },
  'QUIGG_DMV' =>  { '11101110' => 'Ch1_on',
                    '11111111' => 'Ch1_off',
                    '01101100' => 'Ch2_on',
                    '01111101' => 'Ch2_off',
                    '10101111' => 'Ch3_on',
                    '10111110' => 'Ch3_off',
                    '00101101' => 'Ch4_on',
                    '00111100' => 'Ch4_off',
                    '00001111' => 'Master_on',
                    '00011110' => 'Master_off',
                    '00010100' => 'Unknown_up',
                    '00000101' => 'Unknown_down',
                    hex_length => [5],
                    Protocol   => 'P34',
                    Typ        => 'remote'
                  },
  'xavax' =>  { '10000111' => 'Ch1_on',      # 11011010101010110010010101010100 10000111
                '01111000' => 'Ch1_off',     # 11011010101010110010010101010100 01111000
                '01001011' => 'Ch2_on',      # 11011010101010110010010101010100 01001011
                '10110100' => 'Ch2_off',     # 11011010101010110010010101010100 10110100
                '11000011' => 'Ch3_on',      # 11011010101010110010010101010100 11000011
                '00111100' => 'Ch3_off',     # 11011010101010110010010101010100 00111100
                '00101101' => 'Ch4_on',      # 11011010101010110010010101010100 00101101
                '11010010' => 'Ch4_off',     # 11011010101010110010010101010100 11010010
                '10100101' => 'Master_on',   # 11011010101010110010010101010100 10100101
                '01011010' => 'Master_off',  # 11011010101010110010010101010100 01011010
                hex_length => [10],
                Protocol   => 'P26',
                Typ        => 'remote'
              },
  'TR_502MSV' =>  { '11101110' => 'Ch1_on',
                    '11111111' => 'Ch1_off',
                    '01101100' => 'Ch2_on',
                    '01111101' => 'Ch2_off',
                    '10101111' => 'Ch3_on',
                    '10111110' => 'Ch3_off',
                    '00101101' => 'Ch4_on',
                    '00111100' => 'Ch4_off',
                    '00001111' => 'Master_on',
                    '00011110' => 'Master_off',
                    '00010100' => 'dim_up',        # after Master on/off
                    '00000101' => 'dim_down',      # after Master on/off
                    '11110101' => 'Ch1_dim_up',    # after CH1 on/off
                    '11100100' => 'Ch1_dim_down',  # after CH1 on/off
                    '01110111' => 'Ch2_dim_up',    # after CH2 on/off
                    '01100110' => 'Ch2_dim_down',  # after CH2 on/off
                    '10110100' => 'Ch3_dim_up',    # after CH3 on/off
                    '10100101' => 'Ch3_dim_down',  # after CH3 on/off
                    '00110110' => 'Ch4_dim_up',    # after CH4 on/off
                    '00100111' => 'Ch4_dim_down',  # after CH4 on/off
                    hex_length => [5],
                    Protocol   => 'P34',
                    Typ        => 'remote'
                  },
  'RH787T' => { '110111'   => '1_fan_minimum_speed',
                '110101'   => '2_fan_low_speed',
                '101111'   => '3_fan_medium_low_speed',
                '100111'   => '4_fan_medium_speed',
                '011101'   => '5_fan_medium_high_speed',
                '011111'   => '6_fan_high_speed',
                '111011'   => 'fan_direction',
                '111101'   => 'fan_off',
                '111110'   => 'light_on_off',
                '101101'   => 'set',
                hex_length => [3],
                Protocol   => 'P83',
                Typ        => 'remote'
              },
  'TR60C1' => { '111110000000' => 'light_off_fan_off',
                '110110000000' => 'light_off_fan_1',
                '001110000000' => 'light_off_fan_2',
                '101110000000' => 'light_off_fan_3',
                '011110000000' => 'light_off_fan_4',
                '111110001111' => 'light_on_fan_off',
                '110110001111' => 'light_on_fan_1',
                '001110001111' => 'light_on_fan_2',
                '101110001111' => 'light_on_fan_3',
                '011110001111' => 'light_on_fan_4',
                '11111000'     => 'fan_off',         # is not sent directly
                '11011000'     => 'fan_1',           # is not sent directly
                '00111000'     => 'fan_2',           # is not sent directly
                '10111000'     => 'fan_3',           # is not sent directly
                '01111000'     => 'fan_4',           # is not sent directly
                '0000'         => 'light_off',       # is not sent directly
                '1111'         => 'light_on',        # is not sent directly
                hex_length     => [4],
                Protocol       => 'P104',
                Typ            => 'remote'
              },
  'SA_434_1_mini' =>  { '0'        => 'send',
                        hex_length => [3],
                        Protocol   => 'P81',
                        Typ        => 'remote'
                      },
  'Techmar' =>  { '00001001' => 'Group_1_on',    # 0x09
                  '00001010' => 'Group_1_off',   # 0x0A
                  '00001111' => 'Group_2_on',    # 0x0F
                  '00010000' => 'Group_2_off',   # 0x10
                  '00000101' => 'Group_3_on',    # 0x05
                  '00000110' => 'Group_3_off',   # 0x06
                  '00001011' => 'Group_4_on',    # 0x0B
                  '00001100' => 'Group_4_off',   # 0x0C
                  '00010001' => 'Group_5_on',    # 0x11
                  '00010010' => 'Group_5_off',   # 0x12
                  '00001101' => 'Group_6_on',    # 0x0D
                  '00001110' => 'Group_6_off',   # 0x0E
                  '00000111' => 'Group_7_on',    # 0x07
                  '00001000' => 'Group_7_off',   # 0x08
                  '00000001' => 'Group_8_on',    # 0x01
                  '00000010' => 'Group_8_off',   # 0x02
                  '00000011' => 'Group_9_on',    # 0x03
                  '00000100' => 'Group_9_off',   # 0x04
                  '00010011' => 'All_on',        # 0x13
                  '00010100' => 'All_off',       # 0x14
                  hex_length => [13],
                  Protocol   => 'P95',
                  Typ        => 'remote'
                },
  'Tedsen_SKX1xx' =>  { '1100'     => 'Button_1',  # tristate 10
                        hex_length => [5],
                        Protocol   => 'P46',
                        Typ        => 'remote'
                      },
  'Tedsen_SKX2xx' =>  { '1000'     => 'Button_1',  # tristate F0 = GEIGER Ab:  0-
                        '1010'     => 'Button_2',  # tristate FF = GEIGER Auf: 00
                        hex_length => [5],
                        Protocol   => 'P46',
                        Typ        => 'remote'
                      },
  'Tedsen_SKX4xx' =>  { '1000'     => 'Button_1',  # tristate F0 = GEIGER Ab:  0-
                        '1010'     => 'Button_2',  # tristate FF = GEIGER Auf: 00
                        '0000'     => 'Button_3',  # tristate 00 = GEIGER Ab:  --
                        '0010'     => 'Button_4',  # tristate 0F = GEIGER Auf: -0
                        hex_length => [5],
                        Protocol   => 'P46',
                        Typ        => 'remote'
                      },
  'Tedsen_SKX6xx' =>  { '1000'     => 'Button_1',  # tristate F0 = GEIGER Ab:  0-
                        '1010'     => 'Button_2',  # tristate FF = GEIGER Auf: 00
                        '0000'     => 'Button_3',  # tristate 00 = GEIGER Ab:  --
                        '0010'     => 'Button_4',  # tristate 0F = GEIGER Auf: -0
                        '1110'     => 'Button_5',  # tristate 1F = GEIGER Ab:  +0
                        '1011'     => 'Button_6',  # tristate F1 = GEIGER Auf: 0+
                        hex_length => [5],
                        Protocol   => 'P46',
                        Typ        => 'remote'
                      },
  'Unitec_47031' => { Protocol   => 'P30',
                      hex_length => [3],
                      Typ        => 'switch'
                    },
  'LED_XM21_0' => { '1100'     => 'off',
                    '11111111' => 'on',
                    Protocol   => 'P76',
                    hex_length => [15,16],
                    Typ        => 'remote'
                  },
  'SF01_01319004' =>  { '1100'     => 'plus',
                        '1010'     => 'minus',
                        '1101'     => 'interval',
                        '1110'     => 'light_on_off',
                        '1001'     => 'delay',
                        hex_length => [5],
                        Protocol   => 'P86',
                        Typ        => 'remote'
                      },
  'SF01_01319004_Typ2' => { '0100'     => 'plus',
                            '0010'     => 'minus',
                            '0101'     => 'interval',
                            '0110'     => 'light_on_off',
                            '0001'     => 'delay',
                            hex_length => [5],
                            Protocol   => 'P86',
                            Typ        => 'remote'
                          },
  'KL_RF01' =>  { '0001'     => 'light_color_cold_white',
                  '0010'     => 'night_mode',
                  '0100'     => 'on',
                  '0110'     => 'alternating_full_luminosity',
                  '1000'     => 'full_brightness',
                  '1001'     => 'off',
                  '1010'     => 'light_color_warm_white',
                  '1100'     => 'dimdown',
                  '1110'     => 'dimup',
                  Protocol   => 'P93',
                  hex_length => [9],
                  Typ        => 'remote'
                },
  'MD_2003R' => { Protocol   => 'P91',   #P91.1
                  hex_length => [9],
                  Typ        => 'gas'
                },
  'MD_210R' =>  { Protocol   => 'P91',   #P91.1
                  hex_length => [9],
                  Typ        => 'switch'
                },
  'MD_2018R' => { Protocol   => 'P91',   #P91.1
                  hex_length => [9],
                  Typ        => 'vibration'
                },
  'RC_10' =>  { '1'        => 'on',
                '0'        => 'off',
                'buttons'  => {
                                '111' => 'A',
                                '110' => 'B',
                                '101' => 'C',
                                '011' => 'D',
                                '010' => 'all',
                                '100' => 'all',
                              },
                Protocol   => 'P90',
                hex_length => [9],
                Typ        => 'remote'
              },
  'RCnoName20' => { '000010001111000' => 'plus',
                    '000000101000100' => 'minus',
                    '000001010000100' => 'off',
                    '000100011011000' => 'on',
                    hex_length        => [8],
                    Protocol          => 'P20',
                    Typ               => 'remote'
                  },
  'RCnoName20_10' => { '00011110' => 'light_on',
                       '00010110' => 'light_off',
                       '00010101' => 'fan_low',
                       '00011111' => 'fan_mid',
                       '00010100' => 'fan_high',
                       '00010010' => 'fan_stop',
                       '00010011' => 'fan_natural',
                       '00011101' => 'time_1h',
                       '00010001' => 'time_2h',
                       '00011001' => 'time_4h',
                       hex_length => [8],
                       Protocol   => 'P20',
                       Typ        => 'remote'
                     },
  'RCnoName127' => { '00110111' => 'fan_off',
                     '00001011' => 'fan_1',
                     '00011011' => 'fan_2',
                     '00101011' => 'fan_3',
                     '00111011' => 'fan_4',
                     '01001010' => 'fan_5',
                     '01011010' => 'fan_6',
                     '01101010' => 'fan_direction',
                     '01111010' => 'fan_natural',
                     '10100101' => 'light_on_off',
                     '10110101' => 'time_1h',
                     '11100100' => 'time_2h',
                     '11000100' => 'time_4h',
                     '01010110' => 'time_8h',
                     hex_length => [8],
                     Protocol   => 'P127',
                     Typ        => 'remote'
                   },
  'RCnoName128' => { '11110111' => 'fan_on_off',
                     '11110100' => 'fan_slower',
                     '11111010' => 'fan_faster',
                     '11111110' => 'button_left',
                     '11111100' => 'button_right',
                     '11111000' => 'paddle_left',
                     '11110110' => 'paddle_right',
                     '11110001' => 'fan_direction',
                     '11110010' => 'time_1h',
                     '11110000' => 'time_2h',
                     '11101111' => 'time_4h',
                     '11101101' => 'time_8h',
                     hex_length => [6],
                     Protocol   => 'P128',
                     Typ        => 'remote'
                   },
  'DC_1961_TG' => { '10100111' => 'fan_off',
                    '10100001' => 'fan_1',
                    '10100010' => 'fan_2',
                    '10100011' => 'fan_3',
                    '10100100' => 'fan_4',
                    '10100101' => 'fan_5',
                    '10100110' => 'fan_6',
                    '10101001' => 'fan_direction',
                    '10101000' => 'light_on_off',
                    '10101011' => 'time_2h',
                    '10101100' => 'time_4h',
                    '10101101' => 'time_8h',
                    hex_length => [8],
                    Protocol   => 'P20',
                    Typ        => 'remote'
                  },
  'Momento' =>  { '0001'      => 'power',
                  '0010'      => 'play/pause',
                  '0011'      => 'back',
                  '0100'      => 'up',
                  '0101'      => 'menu',
                  '0110'      => 'left',
                  '0111'      => 'ok',
                  '1000'      => 'right',
                  '1001'      => 'down',
                  '1010'      => 'info',
                  '1011'      => 'mode',
                  '1100'      => 'help',
                  hex_length  => [10],
                  Protocol    => 'P97',
                  Typ         => 'remote'
                },
  'Navaris' =>  { '0'        => 'send',
                  hex_length => [6],
                  Protocol   => 'P99',
                  Typ        => 'remote'
                },
  'BF_301' => { '1000'     => 'down',
                '1010'     => 'stop',
                '0011'     => 'up',
                '0010'     => 'confirm',
                '0100'     => 'limit',
                '0001'     => 'direction',
                hex_length => [10],
                Protocol   => 'P105',
                Typ        => 'remote'
              },
  'AC114_01B' =>  { '00001011' => 'up',
                    '00100011' => 'stop',
                    # '00100100' => 'after_updown', # Command 2, remote sends it after up or down
                    '01000011' => 'down',
                    '01010011' => 'program',
                    hex_length => [17],
                    Protocol   => 'P56',
                    Typ        => 'remote'
                  },
  'Visivo' => { '00000010' => 'up',
                '00001000' => 'stop',
                # '00000001' => 'after_up', # Command 2, remote sends it after up
                '00000100' => 'down',
                hex_length => [14],
                Protocol   => 'P24',
                Typ        => 'remote'
              },
  'BeSmart_S4' => { '10001000' => 'level_up',     # was 'up'
                    '10000100' => 'level_down',   # was 'down'
                    '10010000' => 'light_toggle', # was 'left'
                    '10000001' => '5min_boost',   # was 'right'
                    hex_length => [5],
                    Protocol   => 'P78',
                    Typ        => 'remote'
                  },
  'TR401' =>  { '0'   => 'on',
                '1'   => 'off',
                'ch'  => {
                            '001' => '1',
                            '011' => '2',
                            '101' => '3',
                            '110' => '4',
                            '1'   => '001',
                            '2'   => '011',
                            '3'   => '101',
                            '4'   => '110',
                          },
                hex_length => [3],
                Protocol   => 'P114',
                Typ        => 'remote'
              },
  'TC6861' => { '0000' => 'off',
                '0011' => 'on',
                'ch'   => {
                            '01111110' => '1',
                            '01111111' => '2',
                            '10000000' => '3',
                            '1' => '01111110',
                            '2' => '01111111',
                            '3' => '10000000',
                          },
                hex_length => [6],
                Protocol   => 'P121',
                Typ        => 'remote'
              },
  'Meikee_24' => { '00000000' => 'learn',                 # 0x00
                   '00000001' => 'off',                   # 0x01
                   '00000010' => 'on',                    # 0x02
                   '00000011' => 'mode_flash',            # 0x03
                   '00000100' => 'brightness/speed_up',   # 0x04
                   '00000101' => 'brightness/speed_down', # 0x05
                   '00000110' => 'mode_strobe',           # 0x06
                   '00000111' => 'static_2000K',          # 0x07
                   '00001000' => 'static_4500K',          # 0x08
                   '00001001' => 'mode_fade',             # 0x09
                   '00001010' => 'switch_4500K/2000K',    # 0x0A
                   '00001011' => 'static_mixed_white',    # 0x0B
                   '00001100' => 'mode_smooth',           # 0x0C
                   '00001101' => 'time_4h',               # 0x0D
                   '00001110' => 'time_6h',               # 0x0E
                   '00001111' => 'time_12h',              # 0x0F
                   '00010000' => 'static_red',            # 0x10
                   '00010001' => 'static_green',          # 0x11
                   '00010010' => 'static_blue',           # 0x12
                   '00010011' => 'mixed_red',             # 0x13
                   '00010100' => 'mixed_cyan',            # 0x14
                   '00010101' => 'mixed_orange',          # 0x15
                   '00010110' => 'mixed_yellow',          # 0x16
                   '00010111' => 'mixed_green',           # 0x17
                   '00011000' => 'mixed_purple',          # 0x18
                   hex_length => [6,7],
                   Protocol   => 'P118',
                   Typ        => 'remote'
                 },
  'Meikee_21' => { '00000000' => 'learn',                 # 0x00
                   '00000001' => 'on',                    # 0x01
                   '00000010' => 'brightness_down',       # 0x02
                   '00000011' => 'brightness_up',         # 0x03
                   '00000100' => 'off',                   # 0x04
                   '00000101' => 'mode_flash',            # 0x05
                   '00000110' => 'mode_smooth',           # 0x06
                   '00000111' => 'time_2h',               # 0x07
                   '00001000' => 'time_4h',               # 0x08
                   '00001001' => 'time_6h',               # 0x09
                   '00001010' => 'static_red',            # 0x0A
                   '00001011' => 'static_green',          # 0x0B
                   '00001100' => 'static_blue',           # 0x0C
                   '00001101' => 'mixed_red',             # 0x0D
                   '00001110' => 'static_mixed_white',    # 0x0E
                   '00001111' => 'mixed_blue',            # 0x0F
                   '00010000' => 'mixed_orange',          # 0x10
                   '00010001' => 'mixed_light_blue',      # 0x11
                   '00010010' => 'mixed_dark_blue',       # 0x12
                   '00010011' => 'mixed_yellow',          # 0x13
                   '00010100' => 'mixed_turquoise',       # 0x14
                   '00010101' => 'mixed_purple',          # 0x15
                   hex_length => [6,7],
                   Protocol   => 'P118',
                   Typ        => 'remote'
                 },
  'unknown' =>  { Protocol   => 'any',
                  hex_length => [],
                  Typ        => 'not_exist'
                }
);

#############################
sub SD_UT_Initialize {
  my ($hash) = @_;
  $hash->{Match}      = '^P(?:14|20|24|26|29|30|34|46|56|68|69|76|78|81|83|86|90|91|91\.1|92|93|95|97|99|104|105|114|118|121|127|128)#.*';
  $hash->{DefFn}      = \&SD_UT_Define;
  $hash->{UndefFn}    = \&SD_UT_Undef;
  $hash->{ParseFn}    = \&SD_UT_Parse;
  $hash->{SetFn}      = \&SD_UT_Set;
  $hash->{AttrFn}     = \&SD_UT_Attr;
  $hash->{AttrList}   = 'repeats:1,2,3,4,5,6,7,8,9,12,15 IODev do_not_notify:1,0 '.
                        'ignore:0,1 showtime:1,0 model:'.join(',', sort keys %models).
                        " $readingFnAttributes UTclock UTfrequency";
  $hash->{AutoCreate} =
  {
    'AC114_01B.*'  => {ATTR => 'model:AC114_01B', FILTER => '%NAME', autocreateThreshold => '3:180', GPLOT => q{}},
    'BF_301.*'     => {ATTR => 'model:BF_301', FILTER => '%NAME', autocreateThreshold => '3:180', GPLOT => q{}},
    'MD_2003R.*'   => {ATTR => 'model:MD_2003R', FILTER => '%NAME', autocreateThreshold => '3:180', GPLOT => q{}},
    'MD_2018R.*'   => {ATTR => 'model:MD_2018R', FILTER => '%NAME', autocreateThreshold => '3:180', GPLOT => q{}},
    'MD_210R.*'    => {ATTR => 'model:MD_210R', FILTER => '%NAME', autocreateThreshold => '3:180', GPLOT => q{}},
    'Momento.*'    => {ATTR => 'model:Momento', FILTER => '%NAME', autocreateThreshold => '3:180', GPLOT => q{}},
    'OR28V.*'      => {ATTR => 'model:OR28V', FILTER => '%NAME', autocreateThreshold => '3:180', GPLOT => q{}},
    'RCnoName20.*' => {ATTR => 'model:RCnoName20', FILTER => '%NAME', autocreateThreshold => '3:180', GPLOT => q{}},
    'DC_1961_TG.*' => {ATTR => 'model:DC_1961_TG', FILTER => '%NAME', autocreateThreshold => '3:180', GPLOT => q{}},
    'TC6861.*'     => {ATTR => 'model:TR401', FILTER => '%NAME', autocreateThreshold => '3:180', GPLOT => q{}},
    'TR401.*'      => {ATTR => 'model:TR401', FILTER => '%NAME', autocreateThreshold => '3:180', GPLOT => q{}},
    'Techmar.*'    => {ATTR => 'model:Techmar', FILTER => '%NAME', autocreateThreshold => '3:180', GPLOT => q{}},
    'Visivo.*'     => {ATTR => 'model:Visivo', FILTER => '%NAME', autocreateThreshold => '3:180', GPLOT => q{}},
    'xavax.*'      => {ATTR => 'model:xavax', FILTER => '%NAME', autocreateThreshold => '3:180', GPLOT => q{}},
    'unknown_please_select_model' => {ATTR => 'model:unknown', FILTER => '%NAME', autocreateThreshold => '5:180', GPLOT => q{}},
  };
  return FHEM::Meta::InitMod( __FILE__, $hash );
}

#############################
sub SD_UT_Define {
  my ($hash, $def) = @_;
  my @a = split("[ \t][ \t]*", $def);
  my $iodevice;
  my $ioname;

  # Argument                    0     1      2       3           4
  return 'wrong syntax: define <name> SD_UT <model> <HEX-Value> <optional IODEV>' if(int(@a) < 3 || int(@a) > 5);
  return "wrong <model> $a[2]\n\n(allowed modelvalues: " . join(' | ', sort keys %models).')' if $a[2] && ( !grep { $_ eq $a[2] } %models );
  ### checks unknown ###
  return "wrong define: <model> $a[2] need no HEX-Value to define!" if($a[2] eq 'unknown' && $a[3] && length($a[3]) >= 1);

  ### checks Westinghouse_Delancey RH787T & Westinghouse Buttons_five & Buttons_six & TR60C-1 ###
  if ($a[2] eq 'RH787T' || $a[2] eq 'Buttons_five' || $a[2] eq 'Buttons_six' || $a[2] eq 'TR60C1') {
    if (length($a[3]) > 1) {
      return "wrong HEX-Value! $a[2] must have one HEX-Value";
    }
    if (not $a[3] =~ /^[0-9a-fA-F]{1}/xms) {
      return "wrong HEX-Value! ($a[3]) $a[2] HEX-Value are not (0-9 | a-f | A-F)";
    }
  }

  ### checks Medion OR28V ###
  if ($a[2] eq 'OR28V') {
    if (length($a[3]) > 2) {
      return "wrong Value! $a[2] must be an number between 1 - 16";
    }
    if ($a[3] < 1 || $a[3] > 16) {
      return "wrong address! ($a[3]) $a[2] must be an number between 1 - 16";
    }
  }

  ### [2] checks CAME_TOP_432EV & Novy_840029 & Novy_840039 & Unitec_47031 ###
  # uncoverable branch true 
  return "wrong HEX-Value! ($a[3]) $a[2] HEX-Value to short | long or not HEX (0-9 | a-f | A-F){2}" if (($a[2] eq 'CAME_TOP_432EV' || $a[2] eq 'Novy_840029' || $a[2] eq 'Novy_840039' || $a[2] eq 'Unitec_47031') && not $a[3] =~ /^[0-9a-fA-F]{2}/xms);
  ### [3] checks SA_434_1_mini | QUIGG_DMV | TR_502MSV | BeSmart_S4 ###
  # uncoverable branch true 
  return "wrong HEX-Value! ($a[3]) $a[2] HEX-Value to short or long (must be 3 chars) or not HEX (0-9 | a-f | A-F){3}" if (($a[2] eq 'SA_434_1_mini' || $a[2] eq 'QUIGG_DMV' || $a[2] eq 'TR_502MSV' || $a[2] eq 'BeSmart_S4') && not $a[3] =~ /^[0-9a-fA-F]{3}/xms);    
  ### [4 nibble] checks Neff SF01_01319004 & BOSCH SF01_01319004_Typ2 & Chilitec_22640 & ESTO KL_RF01 & RCnoName20 & RCnoName20_10 & RCnoName128 & DC-1961-TG & xavax & BF_301 & Meikee_xx ###
  # uncoverable branch true 
  return "Wrong HEX-Value! ($a[3]) $a[2] Hex-value to short or long (must be 4 chars) or not hex (0-9 | a-f | A-F) {4}" if (($a[2] eq 'SF01_01319004' || $a[2] eq 'SF01_01319004_Typ2' || $a[2] eq 'Chilitec_22640' || $a[2] eq 'KL_RF01' || $a[2] eq 'RCnoName20' || $a[2] eq 'RCnoName20_10' || $a[2] eq 'RCnoName128'  || $a[2] eq 'DC_1961_TG' || $a[2] eq 'xavax' || $a[2] eq 'BF_301' || $a[2] eq 'Meikee_21' || $a[2] eq 'Meikee_24') && not $a[3] =~ /^[0-9a-fA-F]{4}/xms);
  ### [5 nibble] checks RCnoName127
  # uncoverable branch true 
  return "Wrong HEX-Value! ($a[3]) $a[2] Hex-value to short or long (must be 5 chars) or not hex (0-9 | a-f | A-F) {5}" if ($a[2] eq 'RCnoName127' && not $a[3] =~ /^[0-9a-fA-F]{5}/xms);
  ### [6] checks Manax | mumbi ###
  # uncoverable branch true 
  return "wrong HEX-Value! ($a[3]) $a[2] HEX-Value to short | long or not HEX (0-9 | a-f | A-F){4}_[ABCD]|[all]" if ($a[2] eq 'RC_10' && not $a[3] =~ /^[0-9a-fA-F]{4}_([ABCD]|all)$/xms) ;
  ### [6] checks MD_2003R | MD_210R | MD_2018R | Navaris | AC114_01B | Visivo ###
  # uncoverable branch true 
  return "wrong HEX-Value! ($a[3]) $a[2] Hex-value to short or long (must be 6 chars) or not hex (0-9 | a-f | A-F){6}" if (($a[2] eq 'MD_2003R' || $a[2] eq 'MD_210R' || $a[2] eq 'MD_2018R' || $a[2] eq 'Navaris' || $a[2] eq 'AC114_01B' || $a[2] eq 'Visivo') && not $a[3] =~ /^[0-9a-fA-F]{6}/xms);
  ### [7] checks Hoermann HSM4 | Krinner_LUMIX | Momento ###
  # uncoverable branch true 
  return "wrong HEX-Value! ($a[3]) $a[2]  Hex-value to short or long (must be 7 chars) or not hex (0-9 | a-f | A-F){7}" if (($a[2] eq 'HSM4' || $a[2] eq 'Krinner_LUMIX' || $a[2] eq 'Momento') && not $a[3] =~ /^[0-9a-fA-F]{7}/xms);
  ### [7] checks Tedsen_SKX1xx, Tedsen_SKX2xx, Tedsen_SKX4xx, Tedsen_SKX6xx (tristate code)###
  # uncoverable branch true 
  return "wrong tristate code! ($a[3]) $a[2] code to short or long (must be 7 chars) or values not 0, 1 or F" if (($a[2] eq 'Tedsen_SKX1xx' || $a[2] eq 'Tedsen_SKX2xx' || $a[2] eq 'Tedsen_SKX4xx' || $a[2] eq 'Tedsen_SKX6xx') && not $a[3] =~ /^[01fF]{7}$/xms);
  ### [8 nibble] checks Techmar ###
  # uncoverable branch true 
  return "wrong HEX-Value! ($a[3]) $a[2] Hex-value to short or long (must be 8 chars) or not hex (0-9 | a-f | A-F)" if (($a[2] eq 'Techmar') && not $a[3] =~ /^[0-9a-fA-F]{8}$/xms);
  ### [9] checks Hoermann HS1-868-BS ###
  # uncoverable branch true 
  return "wrong HEX-Value! ($a[3]) $a[2] HEX-Value to short | long or not HEX (0-9 | a-f | A-F){9}" if ($a[2] eq 'HS1_868_BS' && not $a[3] =~ /^[0-9a-fA-F]{9}/xms);
  ### [14] checks LED_XM21_0 ###
  # uncoverable branch true 
  return "wrong HEX-Value! ($a[3]) $a[2] HEX-Value to short | long or not HEX (0-9 | a-f | A-F){14}" if ($a[2] eq 'LED_XM21_0' && not $a[3] =~ /^[0-9a-fA-F]{14}/xms);
  ### [3] checks TR401 (Well-Light) ###
  # uncoverable branch true 
  return "wrong devicecode! ($a[3]) $a[2] must be [0-9]_[1-4]" if ($a[2] eq 'TR401' && not $a[3] =~ /^[0-9]_[1-4]/xms);
  ### [3] checks TC6861 (Busch-Transcontrol HF) [P121] ###
  # uncoverable branch true 
  return "SD_UT model $a[2] wrong devicecode: ($a[3]) - must be 3 digit house code (hex 0-9 A-F) _ 1 digit channel (dec 1-3) - e.g. 3DC_1" if ($a[2] eq 'TC6861' && not $a[3] =~ /^[0-9A-F]{3}_[1-3]$/xms);  

  $hash->{versionModule} = $VERSION;
  $hash->{lastMSG} =  'no data';
  $hash->{bitMSG} =  'no data';
  $iodevice = $a[4] if($a[4]);
  my $name = $hash->{NAME};

  $modules{SD_UT}{defptr}{$hash->{DEF}} = $hash;
  $ioname = $modules{SD_UT}{defptr}{ioname} if (exists $modules{SD_UT}{defptr}{ioname} && not $iodevice);
  $iodevice = $ioname if not $iodevice;

  ### Attributes | model set after codesyntax ###
  my $devicetyp = $a[2];
  if ($devicetyp eq 'unknown') {
    $hash->{DEF} = $devicetyp; # model
    $attr{$name}{model} = 'unknown' if( not defined( $attr{$name}{model} ) );
  } else {
    $hash->{DEF} = $devicetyp . q{ } . $a[3]; # model HEX-Value
    $attr{$name}{model} = $devicetyp  if( not defined( $attr{$name}{model} ) );
  }

  AssignIoPort($hash, $iodevice);
  return;
}

###################################
sub SD_UT_Set {
  my ( $hash, $name, @a ) = @_;
  my $cmd = $a[0];
  my $ioname = $hash->{IODev}{NAME};
  my $model = AttrVal($name, 'model', 'unknown');
  my $ret = undef;
  my $msg = undef;
  my $msgEnd = undef;
  my $value = '';   # value from models cmd
  my $save = '';    # bits from models cmd
  my $repeats = AttrVal($name,'repeats', '5');
  my $UTclock = AttrVal($name,'UTclock', undef);

  if ($cmd ne '?') { Log3 $name, 4, "$ioname: SD_UT_Set attr_model=$model name=$name (before check)" };
  if ($defs{$name}->{DEF} eq 'unknown') { return $ret };  # no setlist

  my @definition = split(' ', $hash->{DEF});          # split adress from def
  if ($cmd ne '?') {
    ############ Westinghouse_Delancey RH787T ############
    if ($model eq 'RH787T') {
      my $adr = sprintf( "%04b", hex($definition[1]));  # argument 1 - adress to binary with 4 digits
      $msg = $models{$model}{Protocol} . '#0' . $adr .'1';
      $msgEnd = '#R' . $repeats;
    ############ Westinghouse TR60C-1 ############
    } elsif ($model eq 'TR60C1') {
      my $adr = sprintf( "%04b", hex($definition[1]));  # argument 1 - adress to binary with 4 digits
      $msg = $models{$model}{Protocol} . '#' . $adr;
      if (length($cmd) < 10) {
        my @oldstate = split('_',ReadingsVal($name, 'state', 'light_off_fan_off'));
        if (scalar(@oldstate) == 4) {
          if (length($cmd) < 8) { # fan
            $cmd = $oldstate[0] . '_' . $oldstate[1] . '_' . $cmd;
          } else { # light
            $cmd .= '_' . $oldstate[2] . '_' . $oldstate[3];
          }
          Log3 $name, 4, "$ioname: SD_UT_Set $name oldstate=$oldstate[0]_$oldstate[1]_$oldstate[2]_$oldstate[3] newcmd=$cmd";
        }
      }
      $msgEnd = '#R' . $repeats;
    ############ Westinghouse Buttons_five / Buttons_six ############
    } elsif ($model eq 'Buttons_five' || $model eq 'Buttons_six') {
      my $adr = sprintf( "%04b", hex($definition[1]));  # argument 1 - adress to binary with 4 digits
      $msg = $models{$model}{Protocol} . '#';
      $msgEnd .= '11'.$adr.'#R' . $repeats;
    ############ SA_434_1_mini only one button ############
    } elsif ($model eq 'SA_434_1_mini') {
      my $bitData = sprintf( "%012b", hex($definition[1])); # argument 1 - adress to binary with 12 digits
      $msg = $models{$model}{Protocol} . '#' . $bitData . '#R' . $repeats;
      $cmd = 'send';
    ############ Tedsen_SKX1xx, Tedsen_SKX2xx, Tedsen_SKX4xx, Tedsen_SKX6xx ############
    } elsif ($model eq 'Tedsen_SKX1xx' || $model eq 'Tedsen_SKX2xx' || $model eq 'Tedsen_SKX4xx' || $model eq 'Tedsen_SKX6xx') {
      my $adr = SD_UT_tristate2bin($definition[1]); # argument 1 - adress tristate to bin with 18 bits
      $msg = $models{$model}{Protocol} . '#' . $adr;
      $msgEnd = '#R' . $repeats;
    ############ QUIGG_DMV ############
    } elsif ($model eq 'QUIGG_DMV') {
      my $adr = sprintf( "%012b", hex($definition[1])); # argument 1 - adress to binary with 12 digits
      $msg = $models{$model}{Protocol} . '#' . $adr;
      $msgEnd = 'P#R' . $repeats;
    ############ TR_502MSV ############
    } elsif ($model eq 'TR_502MSV') {
      my $adr = sprintf( "%012b", hex($definition[1])); # argument 1 - adress to binary with 12 digits
      $msg = $models{$model}{Protocol} . '#' . $adr;
      $msgEnd = 'P#R' . $repeats;
    ############ Novy_840029 ############
    } elsif ($model eq 'Novy_840029') {
      my $adr = sprintf( "%08b", hex($definition[1]));  # argument 1 - adress to binary with 8 digits
      $msg = $models{$model}{Protocol} . '#' . $adr;
      $msgEnd = '#R' . $repeats;
    ############ Novy_840039 ############
    } elsif ($model eq 'Novy_840039' && $cmd ne '?') {
      my $adr = sprintf( "%08b", hex($definition[1]));  # argument 1 - adress to binary with 8 digits
      $msg = $models{$model}{Protocol} . '#' . $adr;
      $msgEnd = '#R' . $repeats;
      $UTclock = 375 if (not defined($UTclock));
    ############ CAME_TOP_432EV ############
    } elsif ($model eq 'CAME_TOP_432EV') {
      my $adr = sprintf( "%08b", hex($definition[1]));  # argument 1 - adress to binary with 8 digits
      $msg = $models{$model}{Protocol} . '#' . $adr;
      $msgEnd = '#R' . $repeats;
    ############ NEFF SF01_01319004 || BOSCH SF01_01319004_Typ2 ############
    } elsif ($model eq 'SF01_01319004' || $model eq 'SF01_01319004_Typ2') {
      my $adr = sprintf( "%016b", hex($definition[1])); # argument 1 - adress to binary with 16 digits
      $msg = $models{$model}{Protocol} . '#' . substr($adr,0,14);
      $msgEnd = '#R' . $repeats;
    ############ Hoermann HS1-868-BS only 1 button ############
    } elsif ($model eq 'HS1_868_BS') {
      my $bitData = '00000000';
      $bitData .= sprintf( "%036b", hex($definition[1])); # argument 1 - adress to binary with 36 digits
      $msg = $models{$model}{Protocol} . '#' . $bitData . '#R' . $repeats;
      $cmd = 'send';
    ############ Hoermann HSM4 ############
    } elsif ($model eq 'HSM4') {
      my $adr = sprintf( "%028b", hex($definition[1])); # argument 1 - adress to binary with 28 digits
      $msg = $models{$model}{Protocol} . '#00000000' . $adr;
      $msgEnd .= '1100#R' . $repeats;
    ############ Chilitec 22640 ############
    } elsif ($model eq 'Chilitec_22640') {
      my $adr = sprintf( "%016b", hex($definition[1])); # argument 1 - adress to binary with 16 digits
      $msg = $models{$model}{Protocol} . '#' . $adr;
      $msgEnd .= '#R' . $repeats;
    ############ LED_XM21_0 22640 ############
    } elsif ($model eq 'LED_XM21_0') {
      my $adr = sprintf( "%014b", hex($definition[1])); # argument 1 - adress to binary with 14 digits
      $msg = $models{$model}{Protocol} . '#' . $adr;
      $msgEnd .= '#R' . $repeats;
    ############ Krinner_LUMIX ############
    } elsif ($model eq 'Krinner_LUMIX') {
      my $adr = sprintf( "%028b", hex($definition[1])); # argument 1 - adress to binary with 28 digits
      $msg = $models{$model}{Protocol} . '#' . $adr;
      $msgEnd .= '#R' . $repeats;
    ############ Manax | mumbi ############
    } elsif ($model eq 'RC_10') {
      return "ERROR! $name: To send, please push button on and off again on remote." if ( (ReadingsVal($name, 'x_n5-8_on', '0') eq '0') || (ReadingsVal($name, 'x_n5-8_off', '0') eq '0') || (ReadingsVal($name, 'x_n4', '0') eq '0') );
      $definition[1] = substr($definition[1],0,4);
      my $adr = sprintf( "%016b", hex($definition[1])); # argument 1 - adress to binary with 16 digits
      my $unknown1 = ReadingsVal($name, 'x_n4', '0');
      my $unknown2_btn = 'x_n5-8_'.$cmd;
      my $unknown2 = ReadingsVal($name, $unknown2_btn, '0');
      $msg = $models{$model}{Protocol} . '#' . $adr . $unknown1 . $unknown2;
      $msgEnd .= '#R' . $repeats;
      ### if device _all, set A | B | C | D ### -> RC_10_7869_all (model_device_button)
      if ($hash->{DEF} =~ /_all$/xms) {  # send button all
        foreach my $d (keys %defs) {
          if(defined($defs{$d}) && $defs{$d}{TYPE} eq 'SD_UT' && $defs{$d}{DEF} =~ /$definition[1]/xms && $defs{$d}{DEF} =~ /[ABCD]$/xms && ReadingsVal($d, 'state', '') ne $cmd) {
            readingsSingleUpdate($defs{$d}, 'state' , $cmd , 1);  # set A | B | C | D
            Log3 $name, 3, "$ioname: $d set $cmd";
          }
        }
      }
    ############ ESTO KL_RF01############
    } elsif ($model eq 'KL_RF01') {
      my $adr = sprintf( "%016b", hex($definition[1])); # argument 1 - adress to binary with 16 digits
      $msg = $models{$model}{Protocol} . '#' . $adr;
      $msgEnd .= '11110'; # nibble7 every?
      $msgEnd .= '#R' . $repeats;
    ############ Techmar Garden Lights ############
    } elsif ($model eq 'Techmar') {
      my $adr = sprintf( "%032b", hex($definition[1])); # argument 1 - adress to binary with 32 bits
      $msg = $models{$model}{Protocol} . '#' . $adr;
      $msgEnd = '00#R' . $repeats;  # Last two bits alternately by transmitter 00, 01 or 02. Receiver also reacts to only 00.
    ############ Medion OR28V ############
    } elsif ($model eq 'OR28V') {
      $msg = $models{$model}{Protocol} . '#';
      $msgEnd .= '#R' . $repeats; # R1 wird vom SIGNALduino nicht als MS erkannt!
    ############ Momento ############
    } elsif ($model eq 'Momento') {
      my $adr = sprintf( "%028b", hex($definition[1])); # argument 1 - adress to binary with 28 bits
      $msg = $models{$model}{Protocol} . '#' . $adr;
      $msgEnd = '#R' . $repeats;
    ############ Navaris only one button ############
    } elsif ($model eq 'Navaris') {
      my $adr = sprintf( "%024b", hex($definition[1])); # argument 1 - adress to binary with 24 bits
      $msg = $models{$model}{Protocol} . '#' . $adr . '#R' . $repeats;
      $cmd = 'send';
    ############ xavax ############
    } elsif ($model eq 'xavax') {
      my $adr = sprintf( "%016b", hex($definition[1])); # argument 1 - adress to binary with 16 bits
      $msg = $models{$model}{Protocol} . '#' . $adr;
      $adr =~ tr/01/10/;            # invert adr
      $msg .= $adr;                 # nibble 5-8 is inverted to nibble 0-3
      $msgEnd = '0P#R' . $repeats;  # one pulse for end marker, pause, repeats
    ############ BF_301 ############
    } elsif ($model eq 'BF_301') {
      my $adr = sprintf '%016b' , hex $definition[1]; # argument 1 - adress to binary with 16 bits
      $msg = $models{$model}{Protocol} . q{#} . $adr;
      $msg .= '1000'; # channel
      $msgEnd = '#R' . $repeats;
    ############ AC114_01B ############
    } elsif ($model eq 'AC114_01B') {
      my $adr = sprintf '%024b' , hex $definition[1]; # argument 1 - adress to binary with 24 bits
      $msg = $models{$model}{Protocol} . q{#};
      $msg .= '10100011'; # fest ???
      $msg .= $adr;
      $msg .= '0000000100000000'; # fest ???
      $msgEnd = '1P#R' . $repeats; # EOT, Pause, Repeats
    ############ Visivo ############
    } elsif ($model eq 'Visivo') {
      my $adr = sprintf '%024b' , hex $definition[1]; # argument 1 - adress to binary with 24 bits
      $msg = $models{$model}{Protocol} . q{#};
      $msg .= '10011111'; # fest ???
      $msg .= $adr;
      $msgEnd = '00010000#R' . $repeats; # fest ???, Pause, Repeats
    ############ BeSmart_S4 ############
    } elsif ($model eq 'BeSmart_S4') {
      my $adr = sprintf '%012b' , hex $definition[1]; # argument 1 - adress to binary with 12 bits
      $msg = $models{$model}{Protocol} . q{#};
      $msg .= $adr;
      $msgEnd = '#R' . $repeats;
    ############ TR401 (Well-Light) ############
    } elsif ($model eq 'TR401') {
      $msg = $models{$model}{Protocol} . q{#};
      $msgEnd = '#R' . $repeats;
    ############ TC6861 (Busch-Transcontrol HF) [P121] ############
    } elsif ($model eq 'TC6861') {
      $msg = $models{$model}{Protocol} . q{#P};
      $msgEnd = '#R' . $repeats;
    ############ Meikee_21 | Meikee_24 | RCnoName128 | RCnoName20 | RCnoName20_10 | DC-1961-TG ############
    } elsif ($model eq 'Meikee_21' || $model eq 'Meikee_24' || $model eq 'RCnoName128' || $model eq 'RCnoName20' || $model eq 'RCnoName20_10' || $model eq 'DC_1961_TG') {
      my $adr = sprintf '%016b' , hex $definition[1]; # argument 1 - adress to binary with 16 bits
      $msg = $models{$model}{Protocol} . q{#} . $adr;
      $msgEnd = '#R' . $repeats;
    ############ RCnoName127 ############
    } elsif ($model eq 'RCnoName127') {
      my $adr = sprintf '%020b' , hex $definition[1]; # argument 1 - adress to binary with 20 bits
      $msg = $models{$model}{Protocol} . q{#} . $adr;
      $msgEnd = '#R' . $repeats;
    }
  }

  Log3 $name, 4, "$ioname: SD_UT_Set attr_model=$model msg=$msg msgEnd=$msgEnd" if(defined $msgEnd);

  if ($cmd eq '?') {
    ### create setlist ###
    foreach my $keys (keys %{ $models{$model}}) {
      if ( $keys =~ /^[0-1]{1,}/xms ) {
        $ret.= $models{$model}{$keys}.':noArg ';
      }
    }
  } else {
    if (defined $msgEnd) {
      ### if cmd, set bits ###
      foreach my $keys (keys %{ $models{$model}}) {
        if ( $keys =~ /^[0-1]{1,}/xms ) {
          $save = $keys;
          $value = $models{$model}{$keys};
          last if ($value eq $cmd);
        }
      }
      return "$name Unkown set command!" if ($value ne $cmd);

      ############ KL_RF01 ############
      if ($model eq 'KL_RF01') {
        my $save2 = $save;
        $save2 =~ tr/01/10/;                  # invert message (nibble6 invert = nibble4)
        $msg .= $save.'0000'.$save2.$msgEnd;  # 0000 = nibble5 every?
      ############ Momento ############
      } elsif ($model eq 'Momento') {
        $definition[1] .= sprintf('%X', oct("0b$save"));  # button
        my $sum = hex(substr($definition[1],0,2)) + hex(substr($definition[1],2,2)) + hex(substr($definition[1],4,2)) + hex(substr($definition[1],6,2));
        $msg .= $save . sprintf ("%08b",$sum) . $msgEnd;
        Log3 $name, 5, "$ioname: $name SD_UT_Set $definition[1] " . sprintf('%X', $sum);
      ############ Techmar ############
      } elsif ($model eq 'Techmar') {
        my $invert = $save;
        $invert =~ tr/01/10/;                 # invert byte 4 (byte5 = inverted byte 4)
        $msg .= $save.$invert.$msgEnd;
      ############ Medion OR28V ############
      } elsif ($model eq 'OR28V') {
        my $adr = $definition[1] - 1;                         # argument 1 - adress
        my $checksum = ($adr * 16 + oct("0b$save") + 85) & 0x7f;
        my $laststate = ReadingsVal($name, 'state', 'fehlt');
        my $lastbit0 = ReadingsVal($name, 'bit0', 'fehlt');
        Log3 $name, 5, "$ioname: SD_UT_Set $name ReadingsVal lastbit0=$lastbit0";
        my $bit0 = '0';                         # bit 0 first press a new button
        if ($cmd eq $laststate && $cmd ne 'power') {
          $bit0 = $lastbit0 eq '0' ? '1' : '0'; # toggle bit 0 when press the same button again
        }
        $bit0 = '1' if ($cmd eq 'power');       # bit 0 always 1 by button power
        Log3 $name, 5, "$ioname: SD_UT_Set $name ReadingsVal laststate=$laststate cmd=$cmd bit0=$bit0";
        $msg .= $bit0;                          # bit 0
        $msg .= sprintf ("%07b",$checksum);     # bit 1-7
        if (oct("0b$save") > 42) {  # button
          $msg .= $bit0;                        # bit 8 = bit 0
        } else {
          $msg .= $bit0 eq '0' ? '1' : '0';     # bit 8 = bit 0 inverted
        }
        $msg .= '0';                            # bit 9 always zero
        $msg .= $save;                          # bit 10-15
        $msg .= sprintf ("%04b",$adr);          # bit 16-19
        $msg .= $msgEnd;
        Log3 $name, 5, "$ioname: SD_UT_Set $name msg=$msg checksum=$checksum";
        readingsSingleUpdate($hash, 'bit0' , $bit0, 0);
      ############ BF_301 ############
      } elsif ($model eq 'BF_301') {
        $msg .= $save; # command
        $msg .= '10000011'; # model
        my @split = split /[#]/xms , $msg;
        my $sum = oct ('0b'.reverse substr $split[1],0,8) + oct ('0b'.reverse substr $split[1],8,8) + oct ('0b'.reverse substr $split[1],16,8) + oct ('0b'.reverse substr $split[1],24,8);
        Log3 $name, 5, "$ioname: SD_UT_Set $name bits=$split[1] sum=$sum";
        $sum = 257 - ($sum & 0xFF);
        $msg .= reverse sprintf '%08b' , $sum;
        $msg .= $msgEnd;
      ############ AC114_01B ############
      } elsif ($model eq 'AC114_01B') {
        $msg .= $save; # command
        my @split = split /[#]/xms , $msg;
        my $sum = oct ('0b'. substr $split[1],0,8) + oct ('0b'. substr $split[1],8,8) + oct ('0b'. substr $split[1],16,8) + oct ('0b'. substr $split[1],24,8) + oct ('0b'. substr $split[1],32,8) + oct ('0b'. substr $split[1],40,8) + oct ('0b'. substr $split[1],48,8);
        $sum = (93 + $sum) & 0xFF;
        Log3 $name, 5, "$ioname: SD_UT_Set $name bits=$split[1] sum=$sum";
        $msg .= sprintf '%08b' , $sum;
        $msg .= $msgEnd;
      ############ Visivo ############
      } elsif ($model eq 'Visivo') {
        $msg .= $save; # command
        my @split = split /[#]/xms , $msg;
        my $sum = oct ('0b'. substr $split[1],0,8) + oct ('0b'. substr $split[1],8,8) + oct ('0b'. substr $split[1],16,8) + oct ('0b'. substr $split[1],24,8) + oct ('0b'. substr $split[1],32,8);
        $sum = (97 + $sum) & 0xFF;
        Log3 $name, 5, "$ioname: SD_UT_Set $name bits=$split[1] sum=$sum";
        $msg .= sprintf '%08b' , $sum;
        $msg .= $msgEnd;
      ########### TR401 (Well-Light) #########
      } elsif ($model eq 'TR401') {
        my ($housecode, $ch) = split('_', $definition[1]);
        $msg .= $save . $models{$model}{ch}{$ch};
        $msg .= sprintf('%03b', $housecode);
        $msg .= '11111' . $msgEnd;
      ############ TC6861 (Busch-Transcontrol HF) [P121] ############
      } elsif ($model eq 'TC6861') {
        my ($housecode, $ch) = split('_', $definition[1]);
        $msg .= $save; # on/off
        $msg .= sprintf('%012b', hex $housecode);
        $msg .= $models{$model}{ch}{$ch} . $msgEnd;
        # $msg .= $models{$model}{ch}{$ch} . 'P' . $msgEnd;
      ############ RCnoName20_10 or DC-1961-TG [P20] ############
      } elsif ($model eq 'RCnoName20_10' || $model eq 'DC_1961_TG') {
        $msg .= $save; # button
        my $rollingCode = ReadingsVal($name, 'rollingCode', 0);
        $rollingCode += 1;
        if ($rollingCode > 7) {
          $rollingCode = 0;
        }
        readingsSingleUpdate($hash, 'rollingCode' , $rollingCode, 0);
        $msg .= sprintf('%04b', $rollingCode); # rolling code
        my $xor = 10;
        for (my $n = 4; $n < 32; $n += 4) { # without P20#
          $xor ^= oct('0b' . substr($msg, $n, 4));
        }
        $msg .= sprintf('%04b', $xor); # check
        $msg .= $msgEnd;
      ############ RCnoName127 [P127] ############
      } elsif ($model eq 'RCnoName127') {
        $msg .= $save; # button
        $msg .= substr($save,2,1) eq '0' ? '1' : '0'; # bit 22 inverted
        $msg .= substr($save,3,1) eq '0' ? '1' : '0'; # bit 23 inverted
        $msg .= $msgEnd;
      } else {
        $msg .= $save.$msgEnd;
      }
      Log3 $name, 5, "$ioname: SD_UT_Set attr_model=$model msg=$msg cmd=$cmd value=$value (cmd loop)";
    }

    $msg .= '#C' . $UTclock if (defined($UTclock));  # optional Clockpulse

    my $f = AttrVal($name,'UTfrequency',undef);
    if (defined($f)) {
      $f = $f / 26 * 65536;
      my $f2 = sprintf("%02x", $f / 65536);
      my $f1 = sprintf("%02x", int($f % 65536) / 256);
      my $f0 = sprintf("%02x", $f % 256);
      my $arg = sprintf("%.3f", (hex($f2)*65536+hex($f1)*256+hex($f0))/65536*26);
      Log3 $hash, 3, "$ioname: SD_UT_Set setting UTfrequency (0D,0E,0F) to $f2 $f1 $f0 = $arg MHz";
      $msg .="#F$f2$f1$f0";
    }

    readingsSingleUpdate($hash, 'LastAction', 'send', 0) if ($models{$model}{Typ} eq 'remote');
    readingsSingleUpdate($hash, 'state' , $cmd, 1);

    IOWrite($hash, 'sendMsg', $msg);
    Log3 $name, 3, "$ioname: $name set $cmd";
    Log3 $name, 4, "$ioname: $name SD_UT_Set sendMsg $msg";
  }
  return $ret;
}

#####################################
sub SD_UT_Undef {
  my ($hash, $name) = @_;
  if(defined($hash->{DEF}) && defined($modules{SD_UT}{defptr}{$hash->{DEF}})) {
    delete($modules{SD_UT}{defptr}{$hash->{DEF}})
  };
  return;
}


###################################
sub SD_UT_Parse {
  my ($iohash, $msg) = @_;
  my $ioname = $iohash->{NAME};
  my ($protocol,$rawData) = split('#',$msg);
  $protocol=~ s/^[u|U|P](\d+)/$1/; # extract protocol
  my $hlen = length($rawData);
  my $blen = $hlen * 4;
  my $bitData = unpack("B$blen", pack("H$hlen", $rawData));
  my $model = 'unknown';
  my $name = 'unknown_please_select_model';

  Log3 $iohash, 4, "$ioname: SD_UT protocol $protocol, bitData $bitData, hlen $hlen";

  my $def;
  my $deviceCode = '';
  my $devicedef;
  my $zone;             # Unitec_47031 - bits for zone
  my $zoneRead;         # Unitec_47031 - text for user of zone
  my $usersystem;       # Unitec_47031 - text for user of system
  my $deviceTyp;        # hash -> typ
  my $contact;          # MD_210R
  my $keepalive;        # MD_210R
  my $sabotage;         # MD_210R
  my $batteryState;
  my $state = 'unknown';
  my $tristateCode;
  my $unknown_bits;     # unknown bits to a reading

  my $deletecache = $modules{SD_UT}{defptr}{deletecache};
  Log3 $iohash, 5, "$ioname: SD_UT device in delete cache = $deletecache" if($deletecache && $deletecache ne '-');

  if ($deletecache && $deletecache ne '-') {
    CommandDelete( undef, "$deletecache" );           # delete device
    CommandDelete( undef, "FileLog_$deletecache" );   # delete filelog_device
    Log3 $iohash, 3, "SD_UT_Parse device $deletecache deleted" if($deletecache);
    $modules{SD_UT}{defptr}{deletecache} = '-';
    return '';
  }

  if ($hlen == 3) {
    ### Westinghouse Buttons_five [P29] ###
    if (!$def && ($protocol == 29 || $protocol == 30)) {
      $deviceCode = substr($rawData,2,1);
      $devicedef = 'Buttons_five ' . $deviceCode;
      $def = $modules{SD_UT}{defptr}{$devicedef};
    }
    ### Westinghouse Buttons_six [P29] ###
    if (!$def && ($protocol == 29 || $protocol == 30)) {
      $deviceCode = substr($rawData,2,1);
      $devicedef = 'Buttons_six ' . $deviceCode;
      $def = $modules{SD_UT}{defptr}{$devicedef};
    }
    ### Unitec_47031 [P30] ###
    if (!$def && ($protocol == 30 || $protocol == 83)) {
      $deviceCode = substr($rawData,0,2);
      $devicedef = 'Unitec_47031 ' . $deviceCode;
      $def = $modules{SD_UT}{defptr}{$devicedef};
    }
    ### Remote control SA_434_1_mini 923301 [P81] ###
    if (!$def && ($protocol == 81 || $protocol == 83 || $protocol == 86)) {
      $deviceCode = $rawData;
      $devicedef = 'SA_434_1_mini ' . $deviceCode;
      $def = $modules{SD_UT}{defptr}{$devicedef};
    }
    ### Westinghouse_Delancey RH787T [P83] ### no define
    if (!$def && ($protocol == 83 || $protocol == 30)) {
      $deviceCode = substr($bitData,1,4);
      $deviceCode = sprintf("%X", oct( "0b$deviceCode" ) );
      $devicedef = 'RH787T ' . $deviceCode;
      $def = $modules{SD_UT}{defptr}{$devicedef};
    }
    ### CAME_TOP_432EV [P86] ###  no define
    if (!$def && ($protocol == 86 || $protocol == 81)) {
      $deviceCode = substr($rawData,0,2);
      $devicedef = 'CAME_TOP_432EV ' . $deviceCode;
      $def = $modules{SD_UT}{defptr}{$devicedef};
    }
    ### TR401 (Well-Light) [P114] ###
    if (!$def && $protocol == 114 && substr($bitData,-5) eq '11111') {
      $model = 'TR401';
      my $housecode = substr($rawData,1,1) >> 1;
      my $ch = substr($bitData,1,3);
      if ( exists $models{$model}{ch}{$ch} ) {
        $ch = $models{$model}{ch}{$ch};
        $deviceCode = $housecode .'_'. $ch;
        $devicedef = $model .' '. $deviceCode;
        $def = $modules{SD_UT}{defptr}{$devicedef};
        $name = $model .'_'. $deviceCode;
        Log3 $iohash, 5, "$ioname: SD_UT_Parse device TR401 - housecode=$housecode ch=$ch";
      } else {
        return '';
      }
    }
  }

  if($hlen == 3 || $hlen == 5) {
    ### Novy_840029 [P86] ###
    if (!$def && ($protocol == 86 || $protocol == 81)) {
      $deviceCode = substr($rawData,0,2);
      $devicedef = 'Novy_840029 ' . $deviceCode;
      $def = $modules{SD_UT}{defptr}{$devicedef};
    }
    ### Novy_840039 [P86] ###
    if (!$def && ($protocol == 86 || $protocol == 81)) {
      $deviceCode = substr($rawData,0,2);
      $devicedef = 'Novy_840039 ' . $deviceCode;
      $def = $modules{SD_UT}{defptr}{$devicedef};
    }
  }

  if ($hlen == 4) {
    ### Westinghouse TR60C-1 [P104] ###
    if (!$def && $protocol == 104) {
      $deviceCode = substr($rawData,0,1);
      $devicedef = 'TR60C1 ' . $deviceCode;
      $def = $modules{SD_UT}{defptr}{$devicedef};
    }
  }

  if ($hlen == 5) {
    ### Chilitec_22640 [P14] ###
    if (!$def && $protocol == 14) {
      $deviceCode = substr($rawData,0,4);
      $devicedef = 'Chilitec_22640 ' . $deviceCode;
      $def = $modules{SD_UT}{defptr}{$devicedef};
    }
    ### QUIGG_DMV [P34] ###
    if (!$def && $protocol == 34) {
      $deviceCode = substr($rawData,0,3);
      $devicedef = 'QUIGG_DMV ' . $deviceCode;
      $def = $modules{SD_UT}{defptr}{$devicedef};
    }
    ### TR_502MSV [P34] ###
    if (!$def && $protocol == 34) {
      $deviceCode = substr($rawData,0,3);
      $devicedef = 'TR_502MSV ' . $deviceCode;
      $def = $modules{SD_UT}{defptr}{$devicedef};
    }
    ### Remote control Tedsen_SKX2xx [P46] ###
    if (!$def && $protocol == 46) {
      $deviceCode = SD_UT_bin2tristate(substr($bitData,0,14));    # only 14 bit from bitdata to tristate
      $devicedef = 'Tedsen_SKX1xx ' . $deviceCode if (!$def);
      $def = $modules{SD_UT}{defptr}{$devicedef} if (!$def);
      $devicedef = 'Tedsen_SKX2xx ' . $deviceCode if (!$def);
      $def = $modules{SD_UT}{defptr}{$devicedef} if (!$def);
      $devicedef = 'Tedsen_SKX4xx ' . $deviceCode if (!$def);
      $def = $modules{SD_UT}{defptr}{$devicedef} if (!$def);
      $devicedef = 'Tedsen_SKX6xx ' . $deviceCode if (!$def);
      $def = $modules{SD_UT}{defptr}{$devicedef} if (!$def);
    }
    ### OR28V [P68] ###
    if ($protocol == 68) {
      my $check = (oct( "0b".substr($bitData,9,7) ) + oct( "0b".substr($bitData,16,4)."0000" ) + 85) & 0x7f;
      if ($check != oct( "0b".substr($bitData,1,7))) {
        Log3 $iohash, 3, "$ioname: SD_UT_Parse device OR28V - checksum - ERROR (rawData:$rawData)";
        return '';
      } else {
        Log3 $iohash, 4, "$ioname: SD_UT_Parse device OR28V check length & Protocol OK";
        $deviceCode = oct(substr($rawData,4,1)) + 1;
        $devicedef = 'OR28V ' . $deviceCode;
        $def = $modules{SD_UT}{defptr}{$devicedef};
        $model = 'OR28V';
        $name = $model.'_' . $deviceCode;
      }
    }
    ### BeSmart_S4 [P78] ###
    if (!$def && $protocol == 78) {
      $deviceCode = substr($rawData,0,3);
      $devicedef = 'BeSmart_S4 ' . $deviceCode;
      $def = $modules{SD_UT}{defptr}{$devicedef};
    }
    ### NEFF SF01_01319004 || BOSCH SF01_01319004_Typ2 [P86] ###
    if (!$def && $protocol == 86) {
      $deviceCode = substr($bitData,0,14) . "00";
      $deviceCode = sprintf("%X", oct( "0b$deviceCode" ) );
      $devicedef = 'SF01_01319004 ' . $deviceCode if (!$def);
      $def = $modules{SD_UT}{defptr}{$devicedef} if (!$def);
      $devicedef = 'SF01_01319004_Typ2 ' . $deviceCode if (!$def);
      $def = $modules{SD_UT}{defptr}{$devicedef} if (!$def);
    }
  }

  if ($hlen == 6) {
    ### Remote control Navaris [P99] ###
    if (!$def && $protocol == 99) {
      $deviceCode = substr($rawData,0,6);
      $devicedef = 'Navaris ' . $deviceCode;
      $def = $modules{SD_UT}{defptr}{$devicedef};
    }
    ### TC6861 (Busch-Transcontrol HF) [P121] ###
    if (!$def && $protocol == 121) {
      $model = 'TC6861';
      my $housecode = substr($rawData,1,3);
      my $ch = substr($bitData,16,8);
      if ( exists $models{$model}{ch}{$ch} ) {
        $ch = $models{$model}{ch}{$ch};
        $deviceCode = $housecode .'_'. $ch;
        $devicedef = $model .' '. $deviceCode;
        $def = $modules{SD_UT}{defptr}{$devicedef};
        $name = $model .'_'. $deviceCode;
        Log3 $iohash, 5, "$ioname: SD_UT_Parse device TC6861 - housecode=$housecode ch=$ch";
      } else {
        return '';
      }
    }
    if (!$def && $protocol == 128) {
      ### Remote control RCnoName128 [P128] ###
      $deviceCode = substr($rawData,0,4);
      $devicedef = 'RCnoName128 ' . $deviceCode;
      $def = $modules{SD_UT}{defptr}{$devicedef};
    }
  }

  if ($hlen == 6 || $hlen == 7) {
    ### Remote control Meikee [P118] ###
    if (!$def && $protocol == 118) {
      $deviceCode = substr($rawData,0,4);
      $devicedef = 'Meikee_21 ' . $deviceCode if (!$def);
      $def = $modules{SD_UT}{defptr}{$devicedef} if (!$def);
      $devicedef = 'Meikee_24 ' . $deviceCode if (!$def);
      $def = $modules{SD_UT}{defptr}{$devicedef} if (!$def);
    }
  }

  if ($hlen == 8) {
    if (!$def && $protocol == 20) {
      ### Remote control RCnoName20 [P20] ###
      $deviceCode = substr($rawData,0,4);
      $devicedef = 'RCnoName20 ' . $deviceCode;
      $def = $modules{SD_UT}{defptr}{$devicedef};
      $model = 'RCnoName20';
      $name = 'RCnoName20_' . $deviceCode;
      ### Remote control RCnoName20_10 or DC-1961-TG [P20] ###
      my $xor = 0;
      for (my $n = 0; $n < 8; $n++) {
        $xor ^= hex(substr($rawData,$n,1));
      }
      if ($xor == 10) {
        my $button = substr($bitData,16,8);
        $model = 'RCnoName20_10' if exists $models{'RCnoName20_10'}{$button};
        $model = 'DC_1961_TG' if exists $models{'DC_1961_TG'}{$button};
        $devicedef = $model . ' ' . $deviceCode if (!$def);
        $def = $modules{SD_UT}{defptr}{$devicedef} if (!$def);
        $name = $model . '_' . $deviceCode;
      }
    }
    if (!$def && $protocol == 92) {
      ### Remote control Krinner_LUMIX [P92] ###
      $deviceCode = substr($rawData,0,7);
      $devicedef = 'Krinner_LUMIX ' . $deviceCode;
      $def = $modules{SD_UT}{defptr}{$devicedef};
    }
    if (!$def && $protocol == 127) {
      ### Remote control RCnoName127 [P127] ###
      $deviceCode = substr($rawData,0,5);
      $devicedef = 'RCnoName127 ' . $deviceCode;
      $def = $modules{SD_UT}{defptr}{$devicedef};
    }
  }

  if ($hlen == 9) {
    if ($protocol == 91 || $protocol == 91.1) {
      ### Atlantic Security with all models [P91] or [P91.1 ] with CHECK ###
      Log3 $iohash, 4, "$ioname: SD_UT device MD_210R check length & Protocol OK";
      my @array_rawData = split('',$rawData);
      my $xor_check = hex($array_rawData[0]);
      foreach my $nibble (1...8) {
        $xor_check = $xor_check ^ hex($array_rawData[$nibble]);
      }
      if ($xor_check != 0) {
        Log3 $iohash, 4, "$ioname: SD_UT device from Atlantic Security - check XOR ($xor_check) FAILED! rawData=$rawData";
        return '';
      } else {
        Log3 $iohash, 4, "$ioname: SD_UT device from Atlantic Security - check XOR OK";
      }

      $model = substr($rawData,7,1);
      if ($model eq 'E') {
        $model = 'MD_210R';
      } elsif ($model eq '4') {
        $model = 'MD_2018R';
      } elsif ($model eq 'C') {
        $model = 'MD_2003R';
      } else {
        Log3 $iohash, 1, "SD_UT Please report maintainer. Your model from Atlantic Security are unknown! rawData=$rawData";
        return '';
      }

      $deviceTyp = $models{$model}{Typ};
      $model = "$model";
      $deviceCode = substr($rawData,0,6);
      $devicedef = "$model " . $deviceCode if (!$def);
      $def = $modules{SD_UT}{defptr}{$devicedef} if (!$def);
      $name = $model.'_' . $deviceCode;

      Log3 $iohash, 4, "$ioname: SD_UT device $model from category $deviceTyp with code $deviceCode are ready to decode";
    }

    ### Manax MX-RCS250 | mumbi [P90] ###
    if (!$def && $protocol == 90) {
      my $button = $models{RC_10}{buttons}{substr($bitData,20,3)};
      if (!defined $button) {return ''}
      $deviceCode = substr($rawData,0,4);
      $devicedef = 'RC_10 '.$deviceCode.'_'.$button;
      $def = $modules{SD_UT}{defptr}{$devicedef};

      if ($button ne 'all') {
        $state = substr($bitData,23,1) eq '1' ? 'on' : 'off'
      } else {
        $state = substr($bitData,20,4);
        if ($state eq '0100') {
          $state = 'on';
        } elsif ($state eq '1000') {
          $state = 'off';
        } else {
          $state = 'unknown';
          $def = undef;
        }

        ### if received data from device _all, set channels A | B | C | D to state and trigger event ###
        for ( 'A' .. 'D' ) {
          my $defPtr = $modules{SD_UT}{defptr}{'RC_10 '.$deviceCode."_$_"};
          if (defined $defPtr) {
            readingsSingleUpdate($defPtr, 'state' , $state , 1);
            DoTrigger($defPtr->{NAME}, undef, 0);
            Log3 $iohash, 5, "$ioname: SD_UT device - RC_10 devicedef: $defPtr->{NAME}";
            Log3 $iohash, 5, "$ioname: SD_UT device - RC_10 button: $_ | state: $state";
          }
        }
      }
      Log3 $iohash, 4, "$ioname: SD_UT device - RC_10 devicedef: $devicedef";
      Log3 $iohash, 4, "$ioname: SD_UT device - RC_10 button: $button | state: $state";
    }

    ### ESTO KL_RF01 [P93] ###
    if (!$def && ($protocol == 93 || $protocol == 90)) {
      $deviceCode = substr($rawData,0,4);
      $devicedef = 'KL_RF01 ' . $deviceCode;
      $def = $modules{SD_UT}{defptr}{$devicedef};
    }
  }

  if ($hlen == 10) {
    if (!$def && $protocol == 26) {
      ### Remote control xavax [P26] ###
      my $check = hex(substr($rawData,0,4)) + hex(substr($rawData,4,4));  # Nibble 0-3 is inverted to nibble 5-8
      if ($check != 65535) {
        Log3 $iohash, 3, "$ioname: SD_UT_Parse device xavax - check nibble 0-3 and nibble 5-8 - ERROR";
        return '';
      }
      $check = hex(substr($rawData,8,1)) + hex(substr($rawData,9,1)); # Nibble 8 is inverted to nibble 9
      if ($check != 15) {
        Log3 $iohash, 3, "$ioname: SD_UT_Parse device xavax - check nibble 8 and nibble 9 - ERROR";
        return '';
      }
      $deviceCode = substr($rawData,0,4);
      $devicedef = 'xavax ' . $deviceCode;
      $def = $modules{SD_UT}{defptr}{$devicedef};
      $model = 'xavax';
      $name = 'xavax_' . $deviceCode;
    } elsif (!$def && $protocol == 97) {
      ### Remote control Momento [P97] ###
      my $sum = hex(substr($rawData,0,2)) + hex(substr($rawData,2,2)) + hex(substr($rawData,4,2)) + hex(substr($rawData,6,2));
      if ($sum != hex(substr($rawData,8,2))) {
        Log3 $iohash, 3, "$ioname: SD_UT_Parse device Momento - ERROR checksum $sum != " . hex(substr($rawData,8,2));
        return '';
      }
      $deviceCode = substr($rawData,0,7);
      $devicedef = 'Momento ' . $deviceCode;
      $def = $modules{SD_UT}{defptr}{$devicedef};
      $model = 'Momento';
      $name = 'Momento_' . $deviceCode;
    } elsif (!$def && $protocol == 105) {
      ### Remote control BF_301 [P105] ###
      my $sum = oct ('0b'.reverse substr $bitData,0,8) + oct ('0b'.reverse substr $bitData,8,8) + oct ('0b'.reverse substr $bitData,16,8) + oct ('0b'.reverse substr $bitData,24,8) + oct ('0b'.reverse substr $bitData,32,8);
      if (($sum & 0xFF) != 1) {
        Log3 $iohash, 3, "$ioname: SD_UT_Parse device BF_301 - ERROR checksum != 1";
        return q{};
      }
      if (substr($rawData,6,2) ne '83') { # 83 = BF-301
        Log3 $iohash, 3, "$ioname: SD_UT_Parse device BF_301 - ERROR model != 83";
        return q{};
      }
      $deviceCode = substr $rawData,0,4;
      $devicedef = 'BF_301 ' . $deviceCode;
      $def = $modules{SD_UT}{defptr}{$devicedef};
      $model = 'BF_301';
      $name = 'BF_301_' . $deviceCode;
    }
  }

  if ($hlen == 11 && $protocol == 69) {
    ### Remote control Hoermann HS1-868-BS [P69] ###
    $deviceCode = substr($rawData,2,9);
    $devicedef = 'HS1_868_BS ' . $deviceCode if (!$def);
    $def = $modules{SD_UT}{defptr}{$devicedef} if (!$def);
    ### Remote control Hoermann HSM4 [P69] ###
    $deviceCode = substr($rawData,2,7);
    $devicedef = 'HSM4 ' . $deviceCode if (!$def);
    $def = $modules{SD_UT}{defptr}{$devicedef} if (!$def);
  }

  if ($hlen == 13 && $protocol == 95) {
    ### Remote control Techmar Garden Lights [P95] ###
    Log3 $iohash, 4, "$ioname: SD_UT_Parse device Techmar - check length and protocol number - OK";

    my $check = hex(substr($rawData,8,2)) ^ hex(substr($rawData,10,2)); # byte 5 is inverted to byte 4
    if ($check != 255) {
      Log3 $iohash, 3, "$ioname: SD_UT_Parse device Techmar - check byte 4 and byte 5 - ERROR";
      return '';
    } else {
      Log3 $iohash, 4, "$ioname: SD_UT_Parse device Techmar - check byte 4 and byte 5 - OK";
      $deviceCode = substr($rawData,0,8);
      $devicedef = 'Techmar ' . $deviceCode;
      $def = $modules{SD_UT}{defptr}{$devicedef};
      $model = 'Techmar';
      $name = 'Techmar_' . $deviceCode;
    }
  }

  if ($hlen == 14 && $protocol == 24) {
    ### Remote control Visivo [P24] ###
    Log3 $iohash, 4, "$ioname: SD_UT_Parse device Visivo - check length and protocol number - OK";
    my $sum = (97 + hex(substr($rawData,0,2)) + hex(substr($rawData,2,2)) + hex(substr($rawData,4,2)) + hex(substr($rawData,6,2)) + hex(substr($rawData,8,2))) & 0xff;
    if ($sum != hex(substr($rawData,10,2))) {
      Log3 $iohash, 3, "$ioname: SD_UT_Parse device Visivo - ERROR checksum $sum != " . hex(substr($rawData,10,2));
      return '';
    }
    $deviceCode = substr($rawData,2,6);
    $devicedef = 'Visivo ' . $deviceCode if (!$def);
    $def = $modules{SD_UT}{defptr}{$devicedef} if (!$def);
    $model = 'Visivo';
    $name = 'Visivo_' . $deviceCode;
  }

  if (($hlen == 15 || $hlen == 16) &&  !$def && $protocol == 76) {
    ### Remote LED_XM21_0 [P76] ###
    $deviceCode = substr($rawData,0,14);
    $devicedef = 'LED_XM21_0 ' . $deviceCode;
    $def = $modules{SD_UT}{defptr}{$devicedef};
  }

  if ($hlen == 17 && $protocol == 56) {
    ### Remote control Celexon/Alphavision AC114-01B [P56] ###
    Log3 $iohash, 4, "$ioname: SD_UT_Parse device Celexon/Alphavision - check length and protocol number - OK";
    my $sum = (93 + hex(substr($rawData,0,2)) + hex(substr($rawData,2,2)) + hex(substr($rawData,4,2)) + hex(substr($rawData,6,2)) + hex(substr($rawData,8,2)) + hex(substr($rawData,10,2)) + hex(substr($rawData,12,2))) & 0xff;
    if ($sum != hex(substr($rawData,14,2))) {
      Log3 $iohash, 3, "$ioname: SD_UT_Parse device Celexon/Alphavision - ERROR checksum $sum != " . hex(substr($rawData,14,2));
      return '';
    }
    $deviceCode = substr($rawData,2,6);
    $devicedef = 'AC114_01B ' . $deviceCode if (!$def);
    $def = $modules{SD_UT}{defptr}{$devicedef} if (!$def);
    $model = 'AC114_01B';
    $name = 'AC114_01B_' . $deviceCode;
  }

  ### unknown ###
  $devicedef = 'unknown' if(!$def);
  $def = $modules{SD_UT}{defptr}{$devicedef} if(!$def);
  $modules{SD_UT}{defptr}{ioname} = $ioname;

  Log3 $iohash, 4, "$ioname: SD_UT device $devicedef found (delete cache = $deletecache)" if($def && $deletecache && $deletecache ne '-');

  if(!$def) {
    Log3 $iohash, 1, "$ioname: SD_UT_Parse UNDEFINED sensor $model detected, protocol $protocol, data $rawData, code $deviceCode";
    return "UNDEFINED $name SD_UT $model" if ($model eq 'unknown');                                   # model set user manual
    return "UNDEFINED $name SD_UT $model $deviceCode" if ($model ne 'unknown_please_select_model');   # model set automatically
  }

  my $hash = $def;
  $name = $hash->{NAME};
  $hash->{lastMSG} = $rawData;
  $hash->{bitMSG} = $bitData;
  $deviceCode = undef;        # reset

  $model = AttrVal($name, 'model', 'unknown');
  Log3 $name, 5, "$ioname: SD_UT_Parse devicedef=$devicedef attr_model=$model protocol=$protocol state=$state (before check)";

  readingsBeginUpdate($hash);

  ############ Westinghouse_Delancey RH787T ############ Protocol 83 or 30 ############
  if ($model eq 'RH787T' && ($protocol == 83 || $protocol == 30)) {
    $state = substr($bitData,6,6);
    $deviceCode = substr($bitData,1,4);

    ## Check fixed bits
    my $unknown1 = substr($bitData,0,1);  # every 0
    my $unknown2 = substr($bitData,5,1);  # every 1
    if ($unknown1 ne '0' || $unknown2 ne '1') {
      Log3 $name, 3, "$ioname: $model fixed bits wrong! always bit0=0 ($unknown1) and bit5=1 ($unknown2)";
      return '';
    }

    ## deviceCode conversion for User in ON or OFF ##
    my $deviceCodeUser = $deviceCode;
    $deviceCodeUser =~ s/1/off|/g;
    $deviceCodeUser =~ s/0/on|/g;
    $deviceCodeUser = substr($deviceCodeUser, 0 , length($deviceCodeUser)-1);
    $deviceCode = $deviceCode." ($deviceCodeUser)";

  ############ Westinghouse Buttons_five / Buttons_six############ Protocol 29 or 30 ############
  } elsif (($model eq 'Buttons_five' || $model eq 'Buttons_six') && ($protocol == 29 || $protocol == 30)) {
    $state = substr($bitData,0,6);
    $deviceCode = substr($bitData,8,4);

    ## Check fixed bits
    my $unknown1 = substr($bitData,6,1);  # every 1
    my $unknown2 = substr($bitData,7,1);  # every 1
    if ($unknown1 ne '1' || $unknown2 ne '1') {
      Log3 $name, 3, "$ioname: $model fixed bits wrong! always bit6=1 ($unknown1) and bit7=1 ($unknown2)";
      return '';
    }

    ## deviceCode conversion for User in ON or OFF ##
    my $deviceCodeUser = $deviceCode;
    $deviceCodeUser =~ s/1/off|/g;
    $deviceCodeUser =~ s/0/on|/g;
    $deviceCodeUser = substr($deviceCodeUser, 0 , length($deviceCodeUser)-1);
    $deviceCode = $deviceCode." ($deviceCodeUser)";
  ############ Unitec_47031 ############ Protocol 30 or 83 ############
  } elsif ($model eq 'Unitec_47031' && ($protocol == 30 || $protocol == 83)) {
    $state = substr($bitData,11,1);   # muss noch 100% verifiziert werden !!!

    ## deviceCode conversion for User in ON or OFF ##
    $deviceCode = substr($bitData,0,8);
    my $deviceCodeUser = $deviceCode;
    $deviceCodeUser =~ s/1/on|/g;
    $deviceCodeUser =~ s/0/off|/g;
    $deviceCodeUser = substr($deviceCodeUser, 0 , length($deviceCodeUser)-1);
    $deviceCode = $deviceCode." ($deviceCodeUser)";

    ## zone conversion for User in ON or OFF ##
    $zone = substr($bitData,8,3);
    my $zoneUser = $zone;
    $zoneUser =~ s/1/on|/g;
    $zoneUser =~ s/0/off|/g;
    $zoneUser = substr($zoneUser, 0 , length($zoneUser)-1);
    $zoneRead = $zone." ($zoneUser) - Zone ";

    # Anmeldung an Profi-Alarmanzentrale 47121
    if (oct("0b".$zone) < 6 ) {
      $zoneRead.= (oct("0b".$zone)+1);
      $usersystem = 'Unitec 47121';
    # other variants
    } else {
      $zoneRead.= (oct("0b".$zone)-5);
      # Anmeldung an Basis-Alarmanzentrale 47125 | Sirenen-System (z.B. ein System ohne separate Funk-Zentrale)
      $usersystem = 'Unitec 47125 or Friedland' if (oct("0b".$zone) == 6);
      # Anmeldung an Basis-Alarmanzentrale 47125
      $usersystem = 'Unitec 47125' if (oct("0b".$zone) == 7);
    }
    Log3 $name, 5, "$ioname: SD_UT_Parse devicedef=$devicedef attr_model=$model protocol=$protocol deviceCode=$deviceCode state=$state Zone=$zone";
  ############ Tedsen_SKX1xx, Tedsen_SKX2xx, Tedsen_SKX4xx, Tedsen_SKX6xx ############ Protocol 46 ############
  } elsif (($model eq 'Tedsen_SKX1xx' || $model eq 'Tedsen_SKX2xx' || $model eq 'Tedsen_SKX4xx' || $model eq 'Tedsen_SKX6xx') && $protocol == 46) {
    $state = substr($bitData,14,4);
    $tristateCode = SD_UT_bin2tristate(substr($bitData,0,-2));    # only 18 bit from bitdata
    Log3 $iohash, 4, "$ioname: SD_UT_Parse $model - converted to tristate $tristateCode";
  ############ SA_434_1_mini ############ Protocol 81 ############
  } elsif ($model eq 'SA_434_1_mini' && ($protocol == 81 || $protocol == 83 || $protocol == 86)) {
    $state = 'receive';
  ############ QUIGG_DMV ############ Protocol 34 ############
  } elsif ($model eq 'QUIGG_DMV' && $protocol == 34) {
    $state = substr($bitData,12,8);
    $deviceCode = substr($bitData,0,12);
  ############ TR_502MSV ############ Protocol 34 ############
  } elsif ($model eq 'TR_502MSV' && $protocol == 34) {
    $state = substr($bitData,12,8);
    $deviceCode = substr($bitData,0,12);
  ############ BeSmart_S4 ############ Protocol 78 ############
  } elsif ($model eq 'BeSmart_S4' && $protocol == 78) {
    $state = substr($bitData,12,8);
    $deviceCode = substr($bitData,0,12);
  ############ Novy_840029, Novy_840039 ############ Protocol 86 ############
  } elsif ($model eq 'Novy_840029' || $model eq 'Novy_840039' && ($protocol == 86 || $protocol == 81)) {
    if ($hlen == 3) {   # 12 Bit [3]
      $state = substr($bitData,8);      # 4 Bit
    } else {            # 20 Bit [5]
      $state = substr($bitData,8,10);   # 10 Bit (letzte 2 Bit entfernen)
    }
    $deviceCode = substr($bitData,0,8);
  ############ CAME_TOP_432EV ############ Protocol 86 ############
  } elsif ($model eq 'CAME_TOP_432EV' && ($protocol == 86 || $protocol == 81)) {
    $state = substr($bitData,8);
    $deviceCode = substr($bitData,0,8);
  ############ NEFF SF01_01319004 || BOSCH SF01_01319004_Typ2 ############ Protocol 86 ############
  } elsif (($model eq 'SF01_01319004' || $model eq 'SF01_01319004_Typ2') && $protocol == 86) {
    $state = substr($bitData,14,4);
    $deviceCode = substr($bitData,0,14) . '00' if ($blen >= 14);
    $deviceCode = sprintf("%X", oct( "0b$deviceCode" ) );
  ############ Medion OR28V ############ Protocol 68 ############
  } elsif ($model eq 'OR28V' && $protocol == 68) {
    $state = substr($bitData,10,6);
    $deviceCode = substr($rawData,4,1);
  ############ Hoermann HS1-868-BS ############ Protocol 69 ############
  } elsif ($model eq 'HS1_868_BS' && $protocol == 69) {
    $state = 'receive';
    $deviceCode = substr($bitData,8,28);
  ############ Hoermann HSM4 ############ Protocol 69 ############
  } elsif ($model eq 'HSM4' && $protocol == 69) {
    $state = substr($bitData,36,4);
    $deviceCode = substr($bitData,8,28);
  ############ Chilitec_22640 ############ Protocol 14 ############
  } elsif ($model eq 'Chilitec_22640' && $protocol == 14) {
    $state = substr($bitData,16,4);
    $deviceCode = substr($bitData,0,16);
  ############ LED_XM21_0 ############ Protocol 76 ############
  } elsif ($model eq 'LED_XM21_0' && $protocol == 76) {
    $deviceCode = substr($bitData,0,56);
    $state = substr($bitData,56,8);
  ############ Krinner_LUMIX ############ Protocol 92 ############
  } elsif ($model eq 'Krinner_LUMIX' && $protocol == 92) {
    $deviceCode = substr($bitData,0,28);
    $state = substr($bitData,28,4);
  ############ Atlantic Security ############ Protocol 91 or 91.1 ############
  } elsif ($protocol == 91 || $protocol == 91.1) {
    ############ MD_210R ############ switch ############
    $sabotage = substr($bitData,24,1);
    $contact = substr($bitData,25,1);
    $batteryState = substr($bitData,26,1);    # muss noch 100% verifiziert werden  bei all typs !!!
    $keepalive = substr($bitData,27,1);       # muss noch 100% verifiziert werden  bei all typs !!!

    ($batteryState) = @_ = ('ok', 'warning')[$batteryState];
    ($keepalive) = @_ = ('event', 'periodically')[$keepalive];
    ($sabotage) = @_ = ('closed', 'open')[$sabotage];

    if ($model eq 'MD_210R') {
      ($contact) = @_ = ('closed', 'open')[$contact];
      if ($sabotage eq 'closed' && $contact eq 'closed') {
        $state = 'normal';
      } else {
        $state = 'warning';
      }
    ############ MD_2018R ############ vibration ############ | ############ MD_2003R ############ gas ############
    } elsif ($model eq 'MD_2018R' || $model eq 'MD_2003R') {
      ($contact) = @_ = ('no Alarm', 'Alarm')[$contact];
      $sabotage = undef;

      if ($contact eq 'no Alarm') {
        $state = 'normal';
      } else {
        $state = 'warning';
      }
    }
  ############ Manax | mumbi ############ Protocol 90 ############
  } elsif ($model eq 'RC_10' && $protocol == 90) {
    ## Check fixed bits ## Workaround to send ##
    my $nibble4 = substr($bitData,16,4);      # evey 0000 ?
    my $nibble5 = substr($bitData,20,4);      # Button and State
    my $nibble6to8 = substr($bitData,24,9);   # unknown crc ? | SIGNALduino added to full nibble

    readingsBulkUpdate($hash, 'x_n4' , $nibble4, 0);
    readingsBulkUpdate($hash, 'x_n5-8_on' , $nibble5.$nibble6to8, 0) if ($state eq 'on');
    readingsBulkUpdate($hash, 'x_n5-8_off' , $nibble5.$nibble6to8, 0) if ($state eq 'off');

    $deviceCode = substr($bitData,0,16);
  ############ ESTO KL_RF01 ############ Protocol 90 ############
  } elsif ($model eq 'KL_RF01' && $protocol == 93) {
    ## Check fixed bits
    my $unknown1 = substr($bitData,20,4);   # ?
    my $unknown2 = substr($bitData,28,4);   # ?

    $state = substr($bitData,16,4);
    my $state_invers = substr($bitData,24,4);
    $deviceCode = substr($bitData,0,16);
    $state_invers =~ tr/01/10/;             # invert message
    if ($state eq $state_invers) {
      Log3 $name, 4, "$ioname: SD_UT_Parse - check $model OK, nibble4 ($state) = nibble6 ($state_invers)";
    } else {
      Log3 $name, 3, "$ioname: SD_UT_Parse - check $model FAILED, $state!=$state_invers, ERROR, nibble4 ($state) NOT nibble6 ($state_invers)!";
      return '';
    }
  ### Remote control Techmar Garden Lights [P95] ###
  } elsif ($model eq 'Techmar' && $protocol == 95) {
    $state = substr($bitData,32,8);
    $deviceCode = substr($rawData,0,8);
  ### Remote control RCnoName20 [P20] ###
  } elsif ($model eq 'RCnoName20' && $protocol == 20) {
    $state = substr($bitData,16,15);  # last bit is filled
    $deviceCode = substr($rawData,0,4);
  ### Remote control RCnoName20_10 or DC-1961-TG[P20] ###
  } elsif (($model eq 'RCnoName20_10' || $model eq 'DC_1961_TG') && $protocol == 20) {
    $state = substr($bitData,16,8);
    $deviceCode = substr($rawData,0,4);
    my $rollingCode = hex(substr($rawData,6,1));
    readingsBulkUpdate($hash, 'rollingCode', $rollingCode, 0);
  ### Remote control xavax [P26] ###
  } elsif ($model eq 'xavax' && $protocol == 26) {
    $state = substr($bitData,32,8);
    $deviceCode = substr($rawData,0,4);
  ### Remote control Momento [P97] ###
  } elsif ($model eq 'Momento' && $protocol == 97) {
    $state = substr($bitData,28,4);
    $deviceCode = substr($rawData,0,7);
  ############ Navaris ############ Protocol 99 ############
  } elsif ($model eq 'Navaris' && $protocol == 99) {
    $state = 'receive';
    ### Westinghouse TR60C-1 [P104] ###
  } elsif ($model eq 'TR60C1' && $protocol == 104) {
    $state = substr($bitData,4,12);
    $deviceCode = substr($rawData,0,1);
  ############ BF-301 [P105] ############
  } elsif ($model eq 'BF_301' && $protocol == 105) {
    $state = substr $bitData,20,4;
    $deviceCode = substr $rawData,0,4;
  ############ Remote control Celexon/Alphavision AC114-01B [P56] ############
  } elsif ($model eq 'AC114_01B' && $protocol == 56) {
    $state = substr $bitData,48,8;
    $deviceCode = substr $rawData,2,6;
    if ($state eq '00100100') { # Command 2, remote sends it after up or down
      Log3 $name, 4, "$ioname: SD_UT_Parse device $name - receive command 2, remote sends it after up or down";
      return $name;
    }
  ############ Remote control Visivo [P24] ############
  } elsif ($model eq 'Visivo' && $protocol == 24) {
    $state = substr $bitData,32,8;
    $deviceCode = substr $rawData,2,6;
    if ($state eq '00000001') { # Command 2, remote sends it after up
      Log3 $name, 4, "$ioname: SD_UT_Parse device $name - receive command 2, remote sends it after up or down";
      return $name;
    }
  ############ Remote TR401 (Well-Light) [P114] ############
  } elsif ($model eq 'TR401') {
    $state = substr($bitData,0,1);
    $deviceCode = substr($rawData,1,1) >> 1;
  ############ TC6861 (Busch-Transcontrol HF) [P121] ############
  } elsif ($model eq 'TC6861') {
    $state = substr($bitData,0,4);
    $deviceCode = substr($rawData,1,3);
  ############ Meikee [P118] ############
  } elsif (($model eq 'Meikee_21' || $model eq 'Meikee_24') && $protocol == 118) {
    $state = substr $bitData,16,8;
    $deviceCode = substr $rawData,0,4;
  ############ RCnoName127 [P127] ############
  } elsif ($model eq 'RCnoName127') {
    $state = substr($bitData,20,8);
    $deviceCode = substr($rawData,0,5);
  ############ RCnoName128 [P128] ############
  } elsif ($model eq 'RCnoName128') {
    $state = substr($bitData,16,8);
    $deviceCode = substr($rawData,0,4);

  ############ unknown ############
  } else {
    readingsBulkUpdate($hash, 'state', '???');
    readingsBulkUpdate($hash, 'unknownMSG', $bitData.'  (protocol: '.$protocol.')') if (AttrVal($name, 'model', 'unknown') eq 'unknown');
    Log3 $name, 5, "$ioname: SD_UT Please define your model of Device $name in Attributes!" if (AttrVal($name, 'model', 'unknown') eq 'unknown');
    Log3 $name, 5, "$ioname: SD_UT_Parse devicedef=$devicedef attr_model=$model protocol=$protocol rawData=$rawData, bitData=$bitData";
  }

  Log3 $name, 5, "$ioname: SD_UT_Parse devicedef=$devicedef attr_model=$model protocol=$protocol devicecode=$deviceCode state=$state" if($model ne 'unknown' && defined($deviceCode));
  Log3 $name, 5, "$ioname: SD_UT_Parse devicedef=$devicedef attr_model=$model typ=".$models{$model}{Typ}.' (after check)';

  # only models with more then one button
  if ($models{$model}{Typ} eq 'remote' && ($model ne 'SA_434_1_mini' || $model ne 'HS1_868_BS' || $model ne 'Navaris')) {
    ### identify state bits to value from hash ###
    foreach my $keys (sort keys %{ $models{$model}}) {
      if ($keys eq $state) {
        $state = $models{$model}{$keys};
        Log3 $name, 5, "$ioname: SD_UT_Parse devicedef=$devicedef attr_model=$model typ=".$models{$model}{Typ}.' key='.$models{$model}{$keys}.' (state loop)';
        last;
      }
    }

    if ($model eq 'Novy_840029' || $model eq 'Novy_840039') {
      $state = $state =~ /^[01]+$/x ? "Please check your model. The code $deviceCode is not supported." : $state;
    }
  }

  readingsBulkUpdate($hash, 'deviceCode', $deviceCode, 0) if (defined($deviceCode) && $models{$model}{Typ} eq 'remote');
  readingsBulkUpdate($hash, 'unknown_bits', $unknown_bits, 0) if (defined($unknown_bits) && $models{$model}{Typ} eq 'remote');
  readingsBulkUpdate($hash, 'contact', $contact) if (defined($contact) && ($model eq 'MD_210R' || $model eq 'MD_2018R' || $model eq 'MD_2003R'));
  readingsBulkUpdate($hash, 'batteryState', $batteryState) if (defined($batteryState));
  readingsBulkUpdate($hash, 'deviceTyp', $deviceTyp,0) if (defined($deviceTyp) && ($model eq 'MD_210R' || $model eq 'MD_2018R' || $model eq 'MD_2003R'));
  readingsBulkUpdate($hash, 'keepalive', $keepalive) if (defined($keepalive) && ($model eq 'MD_210R' || $model eq 'MD_2018R' || $model eq 'MD_2003R'));
  readingsBulkUpdate($hash, 'sabotage', $sabotage) if (defined($sabotage) && ($model eq 'MD_210R' || $model eq 'MD_2018R' || $model eq 'MD_2003R'));
  readingsBulkUpdate($hash, 'System-Housecode', $deviceCode, 0) if (defined($deviceCode) && $model eq 'Unitec_47031');
  readingsBulkUpdate($hash, 'Zone', $zoneRead, 0) if (defined($zoneRead) && $model eq 'Unitec_47031');
  readingsBulkUpdate($hash, 'Usersystem', $usersystem, 0) if (defined($zoneRead) && $model eq 'Unitec_47031');
  readingsBulkUpdate($hash, 'LastAction', 'receive', 0) if (defined($state) && $models{$model}{Typ} eq 'remote' && ($model ne 'SA_434_1_mini' || $model ne 'HS1_868_BS'));
  readingsBulkUpdate($hash, 'state', $state)  if (defined($state) && $state ne 'unknown');
  readingsBulkUpdate($hash, 'tristateCode', $tristateCode) if (defined($tristateCode));
  readingsEndUpdate($hash, 1);    # Notify is done by Dispatch

  return $name;
}

###################################
sub SD_UT_Attr {
  my ($cmd, $name, $attrName, $attrValue) = @_;
  my $hash = $defs{$name};
  my $typ = $hash->{TYPE};
  my $devicemodel;
  my $deviceCode;
  my $devicename;
  my $ioDev = InternalVal($name, 'LASTInputDev', undef);
  my $state;
  my $oldmodel = AttrVal($name, 'model', 'unknown');
  my $bitData;
  my $hex_length = length(InternalVal($name, 'lastMSG', '0'));

  if ($cmd eq 'set') {
    
    return qq[$name: Unallowed value $attrValue for the attribute repetition (must be 1 - 99)!] if ($attrName eq q[repeats] && $attrValue !~ m/^[1-9]{1}[0-9]{0,1}$/xms);
    return qq[$name: Invalid value $attrValue for the UTfrequency attribute. Values ​​such as: 433.92 (300.00-999.99 MHz) are permitted.] if ($attrName eq q[UTfrequency] && ($attrValue !~ m/^[3-9]{1}[\d]{2}$|^[3-9]{1}[\d]{2}\.{1}[\d]*$/xms));

    ############ change device models ############
    if ($attrName eq 'model' && $attrValue ne $oldmodel) {
      if (InternalVal($name, 'bitMSG', 'no data') ne 'no data') {
        ### ERROR for users when change attribute model (search allowed models with the same hex_length)
        my @all_models = keys %models;
        my @allowed_model_list;
        for my $i (0 .. @all_models - 1) {
          if ( grep {$_ == $hex_length } @{$models{$all_models[$i]}{hex_length}} ) {
            push @allowed_model_list, $all_models[$i];
          }
        }
        my $allowed_models = join(', ' , sort @allowed_model_list); # convert to sorted string for output
        Log3 $name, 4, "SD_UT_Attr Check for the change, $oldmodel hex_length=$hex_length, attrValue=$attrValue needed hex_length=@{$models{$attrValue}{hex_length}}";
        return "ERROR! $name: You want to choose the $oldmodel model to $attrValue.\nPlease check your selection.\nThe length of DMSG must be the same!\n\nAllowed models are:\n$allowed_models" if ( not grep {$_ eq $attrValue} @allowed_model_list );

        if ($attrValue eq 'unknown') {
          readingsSingleUpdate($hash, 'state', ' Please define your model with attributes! ', 0);
        }

        if ( exists $models{$attrValue} ) {
          $attr{$name}{model} = $attrValue;       # set new model
          $bitData = InternalVal($name, 'bitMSG', '-');
          $devicemodel = $attrValue;
          $state = 'Defined';
        }

        ############ Westinghouse_Delancey RH787T ############
        if ($attrValue eq 'RH787T') {
          $deviceCode = substr($bitData,1,4);
          $deviceCode = sprintf("%X", oct( "0b$deviceCode" ) );
          $devicename = $devicemodel.'_'.$deviceCode;
        ############ Westinghouse TR60C-1 ############
        } elsif ($attrValue eq 'TR60C1') {
          $deviceCode = substr($bitData,0,4);
          $deviceCode = sprintf("%X", oct( "0b$deviceCode" ) );
          $devicename = $devicemodel.'_'.$deviceCode;
        ############ Westinghouse Buttons_five ############
        } elsif ($attrValue eq 'Buttons_five') {
          $deviceCode = substr($bitData,8,4);
          $deviceCode = sprintf("%X", oct( "0b$deviceCode" ) );
          $devicename = $devicemodel.'_'.$deviceCode;
        ############ Westinghouse Buttons_six ############
        } elsif ($attrValue eq 'Buttons_six') {
          $deviceCode = substr($bitData,8,4);
          $deviceCode = sprintf("%X", oct( "0b$deviceCode" ) );
          $devicename = $devicemodel.'_'.$deviceCode;
        ############ SA_434_1_mini  ############
        } elsif ($attrValue eq 'SA_434_1_mini') {
          $deviceCode = sprintf("%03X", oct( "0b$bitData" ) );
          $devicename = $devicemodel.'_'.$deviceCode;
        ############ Tedsen_SKX1xx, Tedsen_SKX2xx, Tedsen_SKX4xx, Tedsen_SKX6xx ############
        } elsif ($attrValue eq 'Tedsen_SKX1xx' || $attrValue eq 'Tedsen_SKX2xx' || $attrValue eq 'Tedsen_SKX4xx' || $attrValue eq 'Tedsen_SKX6xx') {
          $deviceCode = SD_UT_bin2tristate(substr($bitData,0,14));          # only 14 bit from bitdata to tristate
          $devicename = $devicemodel.'_'.$deviceCode;
        ############ Unitec_47031 ############
        } elsif ($attrValue eq 'Unitec_47031') {
          $deviceCode = substr($bitData,0,8);                               # unklar derzeit! 10Dil auf Bild
          $deviceCode = sprintf("%02X", oct( "0b$deviceCode" ) );
          $devicename = $devicemodel.'_'.$deviceCode;
        ############ QUIGG_DMV ############
        } elsif ($attrValue eq 'QUIGG_DMV') {
          $deviceCode = substr($bitData,0,12);
          $deviceCode = sprintf("%03X", oct( "0b$deviceCode" ) );
          $devicename = $devicemodel.'_'.$deviceCode;
        ############ TR_502MSV ############
        } elsif ($attrValue eq 'TR_502MSV') {
          $deviceCode = substr($bitData,0,12);
          $deviceCode = sprintf("%03X", oct( "0b$deviceCode" ) );
          $devicename = $devicemodel.'_'.$deviceCode;
        ############ BeSmart_S4 ############
        } elsif ($attrValue eq 'BeSmart_S4') {
          $deviceCode = substr($bitData,0,12);
          $deviceCode = sprintf("%03X", oct( "0b$deviceCode" ) );
          $devicename = $devicemodel.'_'.$deviceCode;
        ############ Novy_840029 || Novy_840039 ############
        } elsif ($attrValue eq 'Novy_840029' || $attrValue eq 'Novy_840039') {
          $deviceCode = substr($bitData,0,8);
          $deviceCode = sprintf("%02X", oct( "0b$deviceCode" ) );
          $devicename = $devicemodel.'_'.$deviceCode;
        ############ CAME_TOP_432EV ############
        } elsif ($attrValue eq 'CAME_TOP_432EV') {
          $deviceCode = substr($bitData,0,8);
          $deviceCode = sprintf("%X", oct( "0b$deviceCode" ) );
          $devicename = $devicemodel.'_'.$deviceCode;
        ############ NEFF SF01_01319004 || BOSCH SF01_01319004_Typ2 || Refsta Topdraft (Tecnowind) ############
        } elsif ($attrValue eq 'SF01_01319004' || $attrValue eq 'SF01_01319004_Typ2') {
          $deviceCode = substr($bitData,0,14) . '00';
          $deviceCode = sprintf("%04X", oct( "0b$deviceCode" ) );
          $devicename = $devicemodel.'_'.$deviceCode;
        ############ Hoermann HS1-868-BS  ############
        } elsif ($attrValue eq 'HS1_868_BS') {
          $deviceCode = sprintf("%09X", oct( "0b$bitData" ) );
          $devicename = $devicemodel.'_'.$deviceCode;
        ############ Hoermann HSM4  ############
        } elsif ($attrValue eq 'HSM4') {
          $deviceCode = substr($bitData,8,28);
          $deviceCode = sprintf("%07X", oct( "0b$deviceCode" ) );
          $devicename = $devicemodel.'_'.$deviceCode;
        ############ Chilitec_22640 ############
        } elsif ($attrValue eq 'Chilitec_22640') {
          $deviceCode = substr($bitData,0,16);
          $deviceCode = sprintf("%04X", oct( "0b$deviceCode" ) );
          $devicename = $devicemodel.'_'.$deviceCode;
        ############ LED_XM21_0 ############
        } elsif ($attrValue eq 'LED_XM21_0') {
          $deviceCode = substr($bitData,0,56);
          $deviceCode = sprintf("%14X", oct( "0b$deviceCode" ) );
          $devicename = $devicemodel.'_'.$deviceCode;
        ############ Krinner_LUMIX  ############
        } elsif ($attrValue eq 'Krinner_LUMIX') {
          $deviceCode = substr($bitData,0,28);
          $deviceCode = sprintf("%07X", oct( "0b$deviceCode" ) );
          $devicename = $devicemodel.'_'.$deviceCode;
        ############ Manax | mumbi ############
        } elsif ($attrValue eq 'RC_10') {
          $deviceCode = substr($bitData,0,16);
          $deviceCode = sprintf("%04X", oct( "0b$deviceCode" ) );
          my $button = substr($bitData,20,3);
          if ( exists $models{RC_10}{buttons}{$button} ) {
            $deviceCode = $deviceCode.'_'.$models{RC_10}{buttons}{$button};
          }
          $devicename = $devicemodel.'_'.$deviceCode;
        ############ ESTO KL_RF01 ############
        } elsif ($attrValue eq 'KL_RF01') {
          $deviceCode = substr($bitData,0,16);
          $deviceCode = sprintf("%04X", oct( "0b$deviceCode" ) );
          $devicename = $devicemodel.'_'.$deviceCode;
        ############ Techmar Garden Lights ############
        } elsif ($attrValue eq 'Techmar') {
          $deviceCode = substr($bitData,0,32);
          $deviceCode = sprintf("%08X", oct( "0b$deviceCode" ) );
          $devicename = $devicemodel.'_'.$deviceCode;
        ############ Navaris  ############
        } elsif ($attrValue eq 'Navaris') {
          $deviceCode = sprintf("%06X", oct( "0b$bitData" ) );
          $devicename = $devicemodel.'_'.$deviceCode;
        ############ AC114_01B  ############
        } elsif ($attrValue eq 'AC114_01B') {
          $deviceCode = substr $bitData,8,24;
          $deviceCode = sprintf("%06X", oct( "0b$bitData" ) );
          $devicename = $devicemodel.'_'.$deviceCode;
        ############ Visivo  ############
        } elsif ($attrValue eq 'Visivo') {
          $deviceCode = substr $bitData,8,24;
          $deviceCode = sprintf("%06X", oct( "0b$bitData" ) );
          $devicename = $devicemodel.'_'.$deviceCode;
        ############ Meikee ############
        } elsif ($attrValue eq 'Meikee_21' || $attrValue eq 'Meikee_24') {
          $deviceCode = substr($bitData,0,16);
          $deviceCode = sprintf("%04X", oct( "0b$deviceCode" ) );
          $devicename = $devicemodel.'_'.$deviceCode;
        ############ RCnoName20 or RCnoName20_10 or RCnoName128 or DC_1961_TG ############
        } elsif ($attrValue eq 'RCnoName20' || $attrValue eq 'RCnoName20_10' || $attrValue eq 'RCnoName128' || $attrValue eq 'DC_1961_TG') {
          $deviceCode = substr($bitData,0,16);
          $deviceCode = sprintf("%04X", oct( "0b$deviceCode" ) );
          $devicename = $devicemodel.'_'.$deviceCode;
        ############ RCnoName127 ############
        } elsif ($attrValue eq 'RCnoName127') {
          $deviceCode = substr $bitData,0,20;
          $deviceCode = sprintf("%05X", oct( "0b$deviceCode" ) );
          $devicename = $devicemodel.'_'.$deviceCode;
        ############ unknown ############
        } else {
          $devicename = 'unknown_please_select_model';
          Log3 $name, 3, "SD_UT_Attr UNDEFINED sensor $attrValue (model=unknown)";
        }

        Log3 $name, 3, "SD_UT_Attr UNDEFINED sensor $attrValue detected, code $deviceCode (DoTrigger)" if ($devicemodel ne 'unknown');

        $modules{SD_UT}{defptr}{deletecache} = $name; # delete old device
        Log3 $name, 5, "SD_UT: Attr cmd=$cmd devicename=$name attrName=$attrName attrValue=$attrValue oldmodel=$oldmodel";

        readingsSingleUpdate($hash, 'state', $state, 0);

        DoTrigger ('global','UNDEFINED unknown_please_select_model SD_UT unknown') if ($devicename eq 'unknown_please_select_model');   # if user push attr return to unknown
        DoTrigger ('global',"UNDEFINED $devicename SD_UT $devicemodel $deviceCode") if ($devicename ne 'unknown_please_select_model');  # create new device

        $attr{$devicename}{model} = $attrValue; # set model

      } else {
        readingsSingleUpdate($hash, 'state', 'Please press button again!', 0);
        return "Please press button again or receive more messages!\nOnly with another message can the model be defined.\nWe need bitMSG from message.";
      }
    }
  }
  elsif ($cmd eq 'del' && $attrName eq 'model') {      ### delete readings
    for my $readingname (qw/Button deviceCode LastAction state unknownMSG/) {
      readingsDelete($hash,$readingname);
    }
  }

  ## return if fhem init
  if ($init_done) {
    Log3 $name, 3, "SD_UT_Attr set $attrName to $attrValue" if ($cmd eq 'set');
    return "Note: Your unknown_please_select_model device are deleted with the next receive.\nPlease use your new defined model device and do not forget to push -Save config-" if ($defs{$name}->{DEF} eq 'unknown' && $oldmodel eq 'unknown' && $attrValue ne "$oldmodel");
  }
  return;
}

###################################
sub SD_UT_bin2tristate {
  my $bitData = shift // return;
  my %bintotristate=(
     '00' => '0',
     '10' => 'F',
     '11' => '1'
  );
  my $tscode = '';
  for (my $n=0; $n < length($bitData); $n = $n + 2) {
    $tscode = $tscode . $bintotristate{substr($bitData,$n,2)};
  }
  return $tscode;
}

###################################
sub SD_UT_tristate2bin {
  my $tsData = shift // return;
  my %tristatetobin=(
     '0' => '00',
     'F' => '10',
     '1' => '11'
  );
  my $bitData = '';
  for (my $n=0; $n < length($tsData); $n++) {
    $bitData = $bitData . $tristatetobin{substr($tsData,$n,1)};
  }
  return $bitData;
}

###################################

1;

=pod
=item summary    module for some SIGNALduino devices
=item summary_DE Universalmodul f&uuml;r einige SIGNALduino Devices
=begin html

<a name="SD_UT"></a>
<h3>SD_UT</h3>
<ul>
  The module SD_UT is a universal module of SIGNALduino for devices or sensors.<br>
  After the first creation of the device <code><b>unknown_please_select_model</b></code>, the user must define the device himself via the <code>model</code> attribute.<br>
  If the device is not supported yet, bit data can be collected with the unknown_please_select_model device.
  <br><br>
  <i><u><b>Note:</b></u></i> As soon as the attribute model of a defined device is changed or deleted, the module re-creates a device of the selected type, and when a new message is run, the current device is deleted.
  Devices of <u>the same or different type with the same deviceCode will result in errors</u>. PLEASE use different <code>deviceCode</code>.
  <br><br>

  <u>The following devices are supported:</u><br>
  <ul>
    <li>AC114-01 remote control&nbsp;&nbsp;&nbsp;<small>(module model: AC114_01, protocol 56)</small></li>
    <li>Atlantic Security sensors&nbsp;&nbsp;&nbsp;<small>(module model: MD-2003R, MD-2018R,MD-210R, protocol 91|91.1)</small><br>
    <code>&nbsp;&nbsp;&nbsp;Note: The model MD_230R (water) is recognized as MD-2018R due to the same hardware ID!</code></li>
    <li>BeSmart S4 remote control&nbsp;&nbsp;&nbsp;<small>(module model: BeSmart_S4, protocol 78)</small></li>
    <li>BF-301 remote control&nbsp;&nbsp;&nbsp;<small>(module model: BF_301, protocol 105)</small></li>
    <li>BOSCH ceiling fan&nbsp;&nbsp;&nbsp;<small>(module model: SF01_01319004_Typ2, protocol 86)</small></li>
    <li>Busch-Transcontrol HF - remote control 6861&nbsp;&nbsp;&nbsp;<small>(module model: TC6861, protocol 121)</small></li>
    <li>CAME swing gate drive&nbsp;&nbsp;&nbsp;<small>(module model: CAME_TOP_432EV, protocol 86)</small></li>
    <li>ChiliTec LED X-Mas light&nbsp;&nbsp;&nbsp;<small>(module model: Chilitec_22640, protocol 14)</small></li>
    <li>DC-1961-TG - remote control with 12 buttons for ceiling fan with lighting&nbsp;&nbsp;&nbsp;<small>(module model: DC_1961_TG, protocol 20)</small></li>
    <li>ESTO ceiling lamp&nbsp;&nbsp;&nbsp;<small>(module model: KL_RF01, protocol 93)</small></li>
    <li>Remote control with 4 buttons for diesel heating&nbsp;&nbsp;&nbsp;<small>(module model: RCnoName20, protocol 20)</small></li>
    <li>Remote control with 10 buttons for Leroy ceiling fan&nbsp;&nbsp;&nbsp;<small>(module model: RCnoName20_10, protocol 20)</small></li>
    <li>Remote control with 12 buttons for ceiling fan&nbsp;&nbsp;&nbsp;<small>(module model: RCnoName128, protocol 128)</small></li>
    <li>Remote control with 14 buttons for ceiling fan&nbsp;&nbsp;&nbsp;<small>(module model: RCnoName127, protocol 127)</small></li>
    <li>Hoermann HS1-868-BS&nbsp;&nbsp;&nbsp;<small>(module model: HS1_868_BS, protocol 69)</small></li>
    <li>Hoermann HSM4&nbsp;&nbsp;&nbsp;<small>(module model: HSM4, protocol 69)</small></li>
    <li>Krinner LUMIX X-Mas light string&nbsp;&nbsp;&nbsp;<small>(module model: Krinner_LUMIX, protocol 92)</small></li>
    <li>LED_XM21_0 X-Mas light string&nbsp;&nbsp;&nbsp;<small>(module model: LED_XM21_0, protocol 76)</small></li>
    <li>TR401 (Well-Light, remote control with 4 buttons)&nbsp;&nbsp;&nbsp;<small>(module model: TR401, protocol 114)</small></li>
    <li>TR-502MSV (LIDL, LIBRA, MANDOLYN, QUIGG), compatible GT-7008BS, GT-FSI-04, DMV-7008S, Powerfix RCB-I 3600&nbsp;&nbsp;&nbsp;<small>(module model: TR_502MSV, protocol 34)</small></li>
    <li>Manax RCS250&nbsp;&nbsp;&nbsp;<small>(module model: RC_10, protocol 90)</small></li>
    <li>Medion OR28V&nbsp;&nbsp;&nbsp;<small>(module model: OR28V, protocol 68)</small></li>
    <li>Meikee remote controls <small>(Protokoll 118)</small>
      <ul><small>
        <li>Meikee, 21 buttons, e.g. for Solar Flood Lights - module model: Meikee_21</li>
        <li>Meikee, 24 buttons, e.g. for RGB LED Wallwasher Light - module model: Meikee_24</li>
    </small></ul></li>
    <li>mumbi AFS300-s (remote control RC-10, wireless socket RCS-22GS)&nbsp;&nbsp;&nbsp;<small>(module model: RC_10, protocol 90)</small></li>
    <li>Momento (remote control for wireless digital picture frame)&nbsp;&nbsp;&nbsp;<small>(module model: Momento, protocol 97)</small></li>
    <li>NAVARIS touch light switch Model No.: 44344.04&nbsp;&nbsp;&nbsp;<small>(module model: Navaris, protocol 99)</small></li>
    <li>NEFF or Refsta Topdraft (Tecnowind) kitchen hood&nbsp;&nbsp;&nbsp;<small>(module model: SF01_01319004, protocol 86)</small></li>
    <li>Novy Cloud 230 kitchen hood&nbsp;&nbsp;&nbsp;<small>(module model: Novy_840039, protocol 86)</small></li>
    <li>Novy Pureline 6830 kitchen hood&nbsp;&nbsp;&nbsp;<small>(module model: Novy_840029, protocol 86)</small></li>
    <li>QUIGG DMV-7000&nbsp;&nbsp;&nbsp;<small>(module model: QUIGG_DMV, protocol 34)</small></li>
    <li>SA-434-1 mini 923301&nbsp;&nbsp;&nbsp;<small>(module model: SA_434_1_mini, protocol 81)</small></li>
    <li>Techmar Garden Lights &nbsp;&nbsp;&nbsp;<small>(module model: Techmar, protocol 95)</small></li>
    <li>Tedsen Teletaster <small>(protocol 46)</small>:
    <ul><small>
      <li>SKX1xx, 1 button - module model: Tedsen_SKX1xx</li>
      <li>SKX2xx, 2 button (GEIGER_GF0x01) - module model: Tedsen_SKX2xx</li>
      <li>SKX4xx, 4 button (GEIGER_GF0x02) - module model: Tedsen_SKX4xx</li>
      <li>SKX6xx, 6 button (GEIGER_GF0x03) - module model: Tedsen_SKX6xx</li>
    </small></ul></li>
    <li>unitec magnetic contact 47031 (for alarm systems Unitec 47121, Unitec 47125, Friedland)&nbsp;&nbsp;&nbsp;<small>(module model: Unitec_47031, protocol 30)</small></li>
    <li>Visivo remote control for motorized screen&nbsp;&nbsp;&nbsp;<small>(module model: Visivo, protocol 24)</small></li>
    <li>Westinghouse ceiling fan (remote control, 5 buttons without SET)&nbsp;&nbsp;&nbsp;<small>(module model: Buttons_five, protocol 29)</small></li>
    <li>Westinghouse ceiling fan (remote control, 6 buttons with light dimmer)&nbsp;&nbsp;&nbsp;<small>(module model: Buttons_six, protocol 29)</small></li>
    <li>Westinghouse Delancey ceiling fan (remote control, 9 buttons with SET)&nbsp;&nbsp;&nbsp;<small>(module model: RH787T, protocol 83)</small></li>
    <li>Westinghouse ceiling fan Bendan (remote control TR60C-1, touch screen)&nbsp;&nbsp;&nbsp;<small>(module model: TR60C1, protocol 104)</small></li>
    <li>xavax 00111939 (remote control, 10 button)&nbsp;&nbsp;&nbsp;<small>(module model: xavax, protocol 26)</small></li>
  </ul>
  <br><br>

  <b>Define</b><br>
  <ul>
    <code>define &lt;NAME&gt; SD_UT &lt;model&gt; &lt;Hex-address&gt;</code><br><br>
    <u>examples:</u>
    <ul>
      define &lt;NAME&gt; SD_UT RH787T A<br>
      define &lt;NAME&gt; SD_UT SA_434_1_mini ffd<br>
      define &lt;NAME&gt; SD_UT unknown<br>
    </ul>
  </ul>
  <br><br>

  <b>Set</b><br>
  <ul>
    Different transmission commands are available.
    <br><br>

    <u>BOSCH (SF01_01319004_Typ2), NEFF / Refsta Topdraft (SF01_01319004)</u>
    <ul>
      <li>delay: button 1 on the remote</li>
      <li>interval: button 2 on the remote</li>
      <li>light_on_off: button 3 on the remote</li>
      <li>minus: button 4 on the remote</li>
      <li>plus: button 5 on the remote</li>
    </ul><br>

    <u>ChiliTec LED X-Mas light</u>
    <ul>
      <a name="power_on"></a><li>power_on: button ON on the remote</li>
      <a name="power_off"></a><li>power_off: button OFF on the remote</li>
      <a name="flickering_slowly"></a><li>flickering_slowly: button SL on the remote</li>
      <a name="flickering_fast"></a><li>flickering_fast: button SF on the remote</li>
      <a name="brightness_minus"></a><li>brightness_minus: button - on the remote</li>
      <a name="brightness_plus"></a><li>brightness_plus: button + on the remote</li>
    </ul><br>

    <u>ESTO KL_RF01</u>
    <ul>
      <a name="on"></a><li>on: button ON on the remote</li>
      <a name="off"></a><li>off: button OFF on the remote</li>
      <a name="alternating_full_luminosity"></a><li>alternating_full_luminosity: button alternating_full_luminosity on the remote</li>
      <a name="full_brightness"></a><li>full_brightness: button full_brightness on the remote</li>
      <a name="light_color_warm_white"></a><li>light_color_warm_white: button light_color_warm_white on the remote</li>
      <a name="light_color_cold_white"></a><li>light_color_cold_white: button light_color_cold_white on the remote</li>
      <a name="dimup"></a><li>dimup: button DIMUP on the remote</li>
      <a name="dimdown"></a><li>dimdown: button DIMDOWN on the remote</li>
      <a name="night_mode"></a><li>night_mode: button moon on the remote</li>
    </ul><br>

    <u>LED_XM21_0 light string</u>
    <ul>
      <a name="on"></a><li>on: button I on the remote</li>
      <a name="off"></a><li>off: button O on the remote</li>
    </ul><br>

    <u>Remote control SA-434-1 mini 923301, Hoermann HS1-868-BS, Tedsen_SKX1xx</u>
    <ul>
      <a name="send"></a><li>send: button <small>(Always send the same, even if the user sends another set command via console.)</small></li>
    </ul><br>

    <u>Hoermann HSM4 (Remote control with 4 button)</u>
    <ul>
      <a name="button_1"></a><li>button_1: button 1 on the remote</li>
      <a name="button_2"></a><li>button_2: button 2 on the remote</li>
      <a name="button_3"></a><li>button_3: button 3 on the remote</li>
      <a name="button_4"></a><li>button_4: button 4 on the remote</li>
    </ul><br>

    <u>Techmar Garden Lights (Remote control with 10 button)</u>
    <ul>
      <li>Group_1 ... Group_9: Group 1 to 9, on / off</li>
      <li>All_on / All_off: All Groups on / off</li>
    </ul><br>

    <u>Westinghouse ceiling fan (Remote control with 5 button)</u>
    <ul>
      <a name="1_fan_low_speed"></a><li>1_fan_low_speed: button 1/LOW on the remote</li>
      <a name="2_fan_medium_speed"></a><li>2_fan_medium_speed: button 2/MED on the remote</li>
      <a name="3_fan_high_speed"></a><li>3_fan_high_speed: button 3/HI on the remote</li>
      <a name="fan_off"></a><li>fan_off: turns off the fan</li>
      <a name="light_on_off"></a><li>light_on_off: switch light on or off</li>
      <a name="light_dimm"></a><li>light_dimm: light dimm</li>
    </ul><br>

    <u>Westinghouse Delancey ceiling fan (Remote control RH787T with 9 button + SET)</u>
    <ul>
      <a name="1_fan_minimum_speed"></a><li>1_fan_minimum_speed: button I on the remote</li>
      <a name="2_fan_low_speed"></a><li>2_fan_low_speed: button II on the remote</li>
      <a name="3_fan_medium_low_speed"></a><li>3_fan_medium_low_speed: button III on the remote</li>
      <a name="4_fan_medium_speed"></a><li>4_fan_medium_speed: button IV on the remote</li>
      <a name="5_fan_medium_high_speed"></a><li>5_fan_medium_high_speed: button V on the remote</li>
      <a name="6_fan_high_speed"></a><li>6_fan_high_speed: button VI on the remote</li>
      <a name="fan_off"></a><li>fan_off: turns off the fan</li>
      <a name="fan_direction"></a><li>fan_direction: defining the direction of rotation</li>
      <a name="light_on_off"></a><li>light_on_off: switch light on or off</li>
      <a name="set"></a><li>set: button SET on the remote</li><a name=" "></a>
    </ul>
  </ul>
  <br><br>

  <b>Get</b><br>
  <ul>N/A</ul>
  <br><br>

  <b>Attributes</b><br>
  <ul>
    <li><a href="#do_not_notify">do_not_notify</a></li>
    <li><a href="#ignore">ignore</a></li>
    <li><a href="#IODev">IODev</a></li>
    <li><a name="model"></a>model<br>
      The attribute indicates the model type of your device (AC114_01B, BeSmart_S4, Buttons_five, Buttons_six, CAME_TOP_432EV, Chilitec_22640, DC_1961_TG, HS1-868-BS, HSM4, KL_RF01, LED_XM21_0, Meikee_21, Meikee_24, Momento, Navaris, Novy_840029, Novy_840039, OR28V, QUIGG_DMV, RC_10, RH787T, SA_434_1_mini, SF01_01319004, TC6861, TR60C1, Tedsen_SKX1xx, Tedsen_SKX2xx, Tedsen_SKX4xx, Tedsen_SKX6xx, TR_502MSV, Unitec_47031, unknown).<br>
      If the attribute is changed, a new device is created using <a href="#autocreate">autocreate</a>. Autocreate must be activated for this.
    </li>
    <li><a name="repeats"></a>repeats<br>
      This attribute can be used to adjust how many repetitions are sent. Default is 5. Valid values are 1-99.
    </li>
    <li><a name="UTclock"></a>UTclock<br>
      This attribute set the base clock when sending. There is no standard value.<br>
      Exception: The model Novy_840039 has a preset base clock of 375. You can manually adjust this individually with this attribute.
    </li>
    <li><a name="UTfrequency"></a>UTfrequency<br>
      An individual transmission frequency can be set with this attribute. If this attribute is not set, the transmission frequency of the IO device (e.g. Signalduino) is used. Valid values 300.00-999.99 Mhz.
    </li>
  </ul>
  <br><br>

  <b>Generated readings of the models</b><br>
  <ul>
    <u>AC114-01, Buttons_five, Buttons_six, CAME_TOP_432EV, Chilitec_22640, HSM4, KL_RF01, LED_XM21_0, Meikee_xx, Momento, Novy_840029, Novy_840039, OR28V, QUIGG_DMV, RC_10, RH787T, SF01_01319004, SF01_01319004_Typ2, TR401, TR_502MSV, Visivo</u>
    <ul>
      <li>deviceCode: Device code of the system</li>
      <li>LastAction: Last executed action of the device (<code>receive</code> for command received | <code>send</code> for command send).</li>
      <li>state: Current state of the device</li>
    </ul><br>

    <u>MD_2003R (gas), MD_2018R (vibration), MD_210R (door/window switch), MD_230R (water)</u>
    <ul>
      <li>contact: State of the internal alarm contact.</li>
      <li>deviceTyp: Model type of the sensor.</li>
      <li>sabotage: State of sabotage contact.</li>
      <li>state: Current state of the device</li>
    </ul><br>

    <u>HS1-868-BS, SA_434_1_mini, Tedsen_SKX1, Tedsen_SKX2xx, Tedsen_SKX4xx, Tedsen_SKX6xx</u>
    <ul>
      <li>LastAction: Last executed action of the device (<code>receive</code> for command received | <code>send</code> for command send).</li>
      <li>state: Current state of the device</li>
    </ul><br>

    <u>Unitec_47031</u>
    <ul>
      <li>System-Housecode: System or house code of the device</li>
      <li>state: Condition of contact (prepared, unconfirmed)</li>
      <li>Zone: Zone of the device</li>
      <li>Usersystem: Group of the system</li>
    </ul>
  </ul>
</ul>

=end html
=begin html_DE

<a name="SD_UT"></a>
<h3>SD_UT</h3>
<ul>
  Das Modul SD_UT ist ein Universalmodul vom SIGNALduino f&uuml;r Ger&auml;te oder Sensoren.<br>
  Nach dem ersten Anlegen des Ger&auml;tes <code><b>unknown_please_select_model</b></code> muss der User das Ger&auml;t selbst definieren mittels des Attributes <code>model</code>.<br>
  Bei noch nicht unterst&uuml;tzen Ger&auml;ten k&ouml;nnen mit dem <code><b>unknown_please_select_model</b></code> Ger&auml;t Bitdaten gesammelt werden.
  <br><br>
  <i><u><b>Hinweis:</b></u></i> Sobald das Attribut model eines definierten Ger&auml;tes verstellt oder gel&ouml;scht wird, so legt das Modul ein Ger&auml;t des gew&auml;hlten Typs neu an und mit Durchlauf einer neuen Nachricht wird das aktuelle Ger&auml;t gel&ouml;scht.
  Das Betreiben von Ger&auml;ten des <u>gleichen oder unterschiedliches Typs mit gleichem <code>deviceCode</code> f&uuml;hrt zu Fehlern</u>. BITTE achte stets auf einen unterschiedlichen <code>deviceCode</code>.
  <br><br>

  <u>Es werden bisher folgende Ger&auml;te unterst&uuml;tzt:</u><br>
  <ul>
    <li>AC114-01 Fernbedienung&nbsp;&nbsp;&nbsp;<small>(Modulmodel: AC114_01, Protokoll 56)</small></li>
    <li>Atlantic Security Sensoren&nbsp;&nbsp;&nbsp;<small>(Modulmodel: MD-2003R, MD-2018R,MD-210R, Protokoll 91|91.1)</small><br>
    <code>&nbsp;&nbsp;&nbsp;Hinweis: Das Model MD_230R (water) wird aufgrund gleicher Hardwarekennung als MD-2018R erkannt!</code></li>
    <li>BeSmart S4 Fernbedienung&nbsp;&nbsp;&nbsp;<small>(Modulmodel: BeSmart_S4, Protokoll 78)</small></li>
    <li>BF-301 Fernbedienung&nbsp;&nbsp;&nbsp;<small>(Modulmodel: BF_301, Protokoll 105)</small></li>
    <li>BOSCH Deckenl&uuml;fter&nbsp;&nbsp;&nbsp;<small>(Modulmodel: SF01_01319004_Typ2, Protokoll 86)</small></li>
    <li>Busch-Transcontrol HF - Handsender 6861&nbsp;&nbsp;&nbsp;<small>(Modulmodel: TC6861, Protokoll 121)</small></li>
    <li>CAME Drehtor Antrieb&nbsp;&nbsp;&nbsp;<small>(Modulmodel: CAME_TOP_432EV, Protokoll 86)</small></li>
    <li>ChiliTec LED Christbaumkerzen&nbsp;&nbsp;&nbsp;<small>(Modulmodel: Chilitec_22640, Protokoll 14)</small></li>
    <li>DC-1961-TG - Fernbedienung mit 12 Tasten für Deckenventilator mit Beleuchtung&nbsp;&nbsp;&nbsp;<small>(Modulmodel: DC_1961_TG, Protokoll 20)</small></li>
    <li>ESTO Deckenlampe&nbsp;&nbsp;&nbsp;<small>(Modulmodel: KL_RF01, Protokoll 93)</small></li>
    <li>Fernbedienung mit 4 Tasten f&uuml;r Diesel-Heizung &nbsp;&nbsp;&nbsp;<small>(Modulmodel: RCnoName20, Protokoll 20)</small></li>
    <li>Fernbedienung mit 10 Tasten f&uuml;r Leroy Deckenventilator&nbsp;&nbsp;&nbsp;<small>(Modulmodel: RCnoName20_10, Protokoll 20)</small></li>
    <li>Fernbedienung mit 12 Tasten f&uuml;r Deckenventilator&nbsp;&nbsp;&nbsp;<small>(Modulmodel: RCnoName128, Protokoll 128)</small></li>
    <li>Fernbedienung mit 14 Tasten f&uuml;r Deckenventilator&nbsp;&nbsp;&nbsp;<small>(Modulmodel: RCnoName127, Protokoll 127)</small></li>
    <li>Hoermann HS1-868-BS&nbsp;&nbsp;&nbsp;<small>(Modulmodel: HS1_868_BS, Protokoll 69)</small></li>
    <li>Hoermann HSM4&nbsp;&nbsp;&nbsp;<small>(Modulmodel: HSM4, Protokoll 69)</small></li>
    <li>Krinner LUMIX Christbaumkerzen&nbsp;&nbsp;&nbsp;<small>(Modulmodel: Krinner_LUMIX, Protokol 92)</small></li>
    <li>LED_XM21_0 Christbaumkerzen&nbsp;&nbsp;&nbsp;<small>(Modulmodel: LED_XM21_0, Protokol 76)</small></li>
    <li>TR-502MSV (LIDL, LIBRA, MANDOLYN, QUIGG), kompatibel GT-7008BS, GT-FSI-04, DMV-7008S, Powerfix RCB-I 3600&nbsp;&nbsp;&nbsp;<small>(Modulmodel: TR_502MSV, Protokoll 34)</small></li>
    <li>TR401 (Well-Light, Fernbedienung 4 Tasten)&nbsp;&nbsp;&nbsp;<small>(Modulmodel: TR401, Protokoll 114)</small></li>
    <li>Manax RCS250&nbsp;&nbsp;&nbsp;<small>(Modulmodel: RC_10, Protokoll 90)</small></li>
    <li>Medion OR28V&nbsp;&nbsp;&nbsp;<small>(Modulmodel: OR28V, Protokoll 68)</small></li>
    <li>Meikee Fernbedienungen <small>(Protokoll 118)</small>
      <ul><small>
        <li>Meikee, 21 Tasten, z.B. für Solar Flood Lights - Modulmodel: Meikee_21</li>
        <li>Meikee, 24 Tasten, z.B. für RGB LED Wallwasher Light - Modulmodel: Meikee_24</li>
    </small></ul></li>
    <li>mumbi AFS300-s (Fernbedienung RC-10, Funksteckdose RCS-22GS)&nbsp;&nbsp;&nbsp;<small>(Modulmodel: RC_10, Protokoll 90)</small></li>
    <li>Momento (Fernbedienung f&uuml;r digitalen Bilderrahmen)&nbsp;&nbsp;&nbsp;<small>(Modulmodel: Momento, Protokoll 97)</small></li>
    <li>NAVARIS Funk-Licht-Schalter Model No.: 44344.04&nbsp;&nbsp;&nbsp;<small>(Modulmodel: Navaris, Protokoll 99)</small></li>
    <li>NEFF oder Refsta Topdraft (Tecnowind) Dunstabzugshaube&nbsp;&nbsp;&nbsp;<small>(Modulmodel: SF01_01319004, Protokoll 86)</small></li>
    <li>Novy Cloud 230 Dunstabzugshaube&nbsp;&nbsp;&nbsp;<small>(Modulmodel: Novy_840039, Protokoll 86)</small></li>
    <li>Novy Pureline 6830 Dunstabzugshaube&nbsp;&nbsp;&nbsp;<small>(Modulmodel: Novy_840029, Protokoll 86)</small></li>
    <li>QUIGG DMV-7000&nbsp;&nbsp;&nbsp;<small>(Modulmodel: QUIGG_DMV, Protokoll 34)</small></li>
    <li>SA-434-1 mini 923301&nbsp;&nbsp;&nbsp;<small>(Modulmodel: SA_434_1_mini, Protokoll 81)</small></li>
    <li>Techmar Garden Lights &nbsp;&nbsp;&nbsp;<small>(Modulmodel: Techmar, Protokoll 95)</small></li>
    <li>Tedsen Teletaster <small>(Protokoll 46)</small>:
    <ul><small>
      <li>SKX1xx, 1 Taste - Modulmodel: Tedsen_SKX1xx</li>
      <li>SKX2xx, 2 Tasten (GEIGER_GF0x01) - Modulmodel: Tedsen_SKX2xx</li>
      <li>SKX4xx, 4 Tasten (GEIGER_GF0x02) - Modulmodel: Tedsen_SKX4xx</li>
      <li>SKX6xx, 6 Tasten (GEIGER_GF0x03) - Modulmodel: Tedsen_SKX6xx</li>
    </small></ul></li>
    <li>unitec Magnetkontakt 47031 (f&uuml;r Alarmanlagen Unitec 47121, Unitec 47125, Friedland)&nbsp;&nbsp;&nbsp;<small>(Modulmodel: Unitec_47031, Protokoll 30)</small></li>
    <li>Visivo Fernbedienung f&uuml;r Motorleinwand&nbsp;&nbsp;&nbsp;<small>(Modulmodel: Visivo, Protokoll 24)</small></li>
    <li>Westinghouse Deckenventilator (Fernbedienung, 5 Tasten ohne SET)&nbsp;&nbsp;&nbsp;<small>(Modulmodel: Buttons_five, Protokoll 29)</small></li>
    <li>Westinghouse Deckenventilator (Fernbedienung, 6 Tasten mit Dimmer)&nbsp;&nbsp;&nbsp;<small>(Modulmodel: Buttons_six, Protokoll 29)</small></li>
    <li>Westinghouse Delancey Deckenventilator (Fernbedienung, 9 Tasten mit SET)&nbsp;&nbsp;&nbsp;<small>(Modulmodel: RH787T, Protokoll 83)</small></li>
    <li>Westinghouse Deckenventilator Bendan (Fernbedienung TR60C-1, Touch screen)&nbsp;&nbsp;&nbsp;<small>(Modulmodel: TR60C1, Protokoll 104)</small></li>
    <li>xavax 00111939 (Fernbedienung, 10 Tasten)&nbsp;&nbsp;&nbsp;<small>(Modulmodel: xavax, Protokoll 26)</small></li>
  </ul>
  <br><br>

  <b>Define</b><br>
  <ul>
    <code>define &lt;NAME&gt; SD_UT &lt;model&gt; &lt;Hex-Adresse&gt;</code><br><br>
    <u>Beispiele:</u>
    <ul>
      define &lt;NAME&gt; SD_UT RH787T A<br>
      define &lt;NAME&gt; SD_UT SA_434_1_mini ffd<br>
      define &lt;NAME&gt; SD_UT unknown<br>
    </ul>
  </ul>
  <br><br>

  <b>Set</b><br>
  <ul>
    Je nach Ger&auml;t sind unterschiedliche Sendebefehle verf&uuml;gbar.
    <br><br>

    <u>BOSCH (SF01_01319004_Typ2), NEFF / Refsta Topdraft (SF01_01319004)</u>
    <ul>
      <li>delay: Taste 1 auf der Fernbedienung</li>
      <li>interval: Taste 2 auf der Fernbedienung</li>
      <li>light_on_off: Taste 3 auf der Fernbedienung</li>
      <li>minus: Taste 4 auf der Fernbedienung</li>
      <li>plus: Taste 5 auf der Fernbedienung</li>
    </ul><br>

    <u>ChiliTec LED Christbaumkerzen</u>
    <ul>
      <a name="power_on"></a><li>power_on: Taste ON auf der Fernbedienung</li>
      <a name="power_off"></a><li>power_off: Taste OFF auf der Fernbedienung</li>
      <a name="flickering_slowly"></a><li>flickering_slowly: Taste SL auf der Fernbedienung</li>
      <a name="flickering_fast"></a><li>flickering_fast: Taste SF auf der Fernbedienung</li>
      <a name="brightness_minus"></a><li>brightness_minus: Taste - auf der Fernbedienung</li>
      <a name="brightness_plus"></a><li>brightness_plus: Taste + auf der Fernbedienung</li>
    </ul><br>

    <u>ESTO KL_RF01</u>
    <ul>
      <a name="on"></a><li>on: Taste ON auf der Fernbedienung</li>
      <a name="off"></a><li>off: Taste OFF auf der Fernbedienung</li>
      <a name="alternating_full_luminosity"></a><li>alternating_full_luminosity: Taste ABWECHSELNDE_LEUCHTKRAFT auf der Fernbedienung</li>
      <a name="full_brightness"></a><li>full_brightness: Taste VOLLE_HELLIGKEIT auf der Fernbedienung</li>
      <a name="light_color_warm_white"></a><li>light_color_warm_white: Taste LICHTFARBE_WARMWEIß auf der Fernbedienung</li>
      <a name="light_color_cold_white"></a><li>light_color_cold_white: Taste LICHTFARBE_KALTWEIß auf der Fernbedienung</li>
      <a name="dimup"></a><li>dimup: Taste DIMUP auf der Fernbedienung</li>
      <a name="dimdown"></a><li>dimdown: Taste DIMDOWN auf der Fernbedienung</li>
      <a name="night_mode"></a><li>night_mode: Taste MOND auf der Fernbedienung</li>
    </ul><br>

    <u>LED_XM21_0 Christbaumkerzen</u>
    <ul>
      <a name="on"></a><li>on: Taste I auf der Fernbedienung</li>
      <a name="off"></a><li>off: Taste O auf der Fernbedienung</li>
    </ul><br>

    <u>Fernbedienungen SA-434-1 mini 923301, Hoermann HS1-868-BS, Tedsen_SKX1xx</u>
    <ul>
      <a name="send"></a><li>send: Tastendruck <small>(Sendet immer den gleichen Befehl, auch wenn der Benutzer einen anderen Set-Befehl via Konsole sendet.)</small></li>
    </ul><br>

    <u>Hoermann HSM4 (Fernbedienung mit 4 Tasten)</u>
    <ul>
      <a name="button_1"></a><li>button_1: Taste 1 auf der Fernbedienung</li>
      <a name="button_2"></a><li>button_2: Taste 2 auf der Fernbedienung</li>
      <a name="button_3"></a><li>button_3: Taste 3 auf der Fernbedienung</li>
      <a name="button_4"></a><li>button_4: Taste 4 auf der Fernbedienung</li>
    </ul><br>

    <u>Techmar Garden Lights (Fernbedienung mit 10 Tasten)</u>
    <ul>
      <li>Group_1 ... Group_9: Gruppe 1 bis 9, jeweils ein und aus</li>
      <li>All_on / All_off: Alle Gruppen ein / aus</li>
    </ul><br>

    <u>Westinghouse Deckenventilator (Fernbedienung mit 5 oder 6 Tasten)</u>
    <ul>
      <a name="1_fan_low_speed"></a><li>1_fan_low_speed: Taste 1/LOW auf der Fernbedienung</li>
      <a name="2_fan_medium_speed"></a><li>2_fan_medium_speed: Taste 2/MED auf der Fernbedienung</li>
      <a name="3_fan_high_speed"></a><li>3_fan_high_speed: Taste 3/HI auf der Fernbedienung</li>
      <a name="fan_off"></a><li>fan_off: Ventilator ausschalten</li>
      <a name="light_on_off"></a><li>light_on_off: Licht ein-/ausschalten</li>
      <a name="light_dimm"></a><li>light_dimm: Licht dimmen</li>
    </ul><br>

    <u>Westinghouse Delancey Deckenventilator (Fernbedienung RH787T mit 9 Tasten + SET)</u>
    <ul>
      <a name="1_fan_minimum_speed"></a><li>1_fan_minimum_speed: Taste I auf der Fernbedienung</li>
      <a name="2_fan_low_speed"></a><li>2_fan_low_speed: Taste II auf der Fernbedienung</li>
      <a name="3_fan_medium_low_speed"></a><li>3_fan_medium_low_speed: Taste III auf der Fernbedienung</li>
      <a name="4_fan_medium_speed"></a><li>4_fan_medium_speed: Taste IV auf der Fernbedienung</li>
      <a name="5_fan_medium_high_speed"></a><li>5_fan_medium_high_speed: Taste V auf der Fernbedienung</li>
      <a name="6_fan_high_speed"></a><li>6_fan_high_speed: Taste VI auf der Fernbedienung</li>
      <a name="fan_off"></a><li>fan_off: Ventilator ausschalten</li>
      <a name="fan_direction"></a><li>fan_direction: Drehrichtung festlegen</li>
      <a name="light_on_off"></a><li>light_on_off: Licht ein-/ausschalten</li>
      <a name="set"></a><li>set: Taste SET in der Fernbedienung</li><a name=" "></a>
    </ul>
  </ul>
  <br><br>

  <b>Get</b><br>
  <ul>N/A</ul>
  <br><br>

  <b>Attribute</b><br>
  <ul>
    <li><a href="#do_not_notify">do_not_notify</a></li>
    <li><a href="#ignore">ignore</a></li>
    <li><a href="#IODev">IODev</a></li>
    <li><a name="model"></a>model<br>
      Diese Attribut bezeichnet den Modelltyp Ihres Ger&auml;tes (AC114_01B, BeSmart_S4, Buttons_five, Buttons_six, CAME_TOP_432EV, Chilitec_22640, DC_1961_TG, HS1-868-BS, HSM4, KL_RF01, LED_XM21_0, Meikee_21, Meikee_24, Momento, Navaris, Novy_840029, Novy_840039, OR28V, QUIGG_DMV, RC_10, RH787T, SA_434_1_mini, SF01_01319004, TC6861, TR60C1, Tedsen_SKX1xx, Tedsen_SKX2xx, Tedsen_SKX4xx, Tedsen_SKX6xx, TR_502MSV, Unitec_47031, unknown).<br>
      Bei &Auml;nderung des Attributes wird ein neues Gerät mittels <a href="#autocreate">autocreate</a> erzeugt. Autocreate muss dazu aktiviert sein.
    </li>
    <li><a name="repeats"></a>repeats<br>
      Mit diesem Attribut kann angepasst werden, wie viele Wiederholungen gesendet werden. Standard ist 5. Erlaubte Werte 1-99.
    </li>
    <li><a name="UTclock"></a>UTclock<br>
      Mit diesem Attribut kann der Basistakt beim Senden eingestellt werden. Einen Standardwert gibt es nicht.<br>
      Ausnahme: Das Model Novy_840039 hat einen voreingestellten Basistakt von 375. Auch diesen kann man mit dem Attribut individuell anpassen.
    </li>
    <li><a name="UTfrequency"></a>UTfrequency<br>
      Mit diesem Attribut kann eine individuelle Sendefrequenz eingestellt werden. Ist dieses Attribut nicht gesetzt, wird die Sendefrequenz des IO Devices (z.B. Signalduino) verwendet. Erlaubte Werte 300.00-999.99 Mhz.
    </li>
  </ul>
  <br><br>

  <b>Generierte Readings der Modelle</b><br>
  <ul>
    <u>AC114-01, BeSmart_S4, Buttons_five, Buttons_six, CAME_TOP_432EV, Chilitec_22640, HSM4, KL_RF01, LED_XM21_0, Meikee_xx, Momento, Novy_840029, Novy_840039, OR28V, QUIGG_DMV, RC_10, RH787T, SF01_01319004, SF01_01319004_Typ2, TR401, TR_502MSV, Visivo</u>
    <ul>
      <li>deviceCode: Ger&auml;teCode des Systemes</li>
      <li>LastAction: Zuletzt ausgef&uuml;hrte Aktion des Ger&auml;tes (<code>receive</code> f&uuml;r Kommando empfangen, <code>send</code> f&uuml;r Kommando gesendet).</li>
      <li>state: Aktueller Zustand des Ger&auml;tes</li>
    </ul><br>

    <u>MD_2003R (gas), MD_2018R (vibration), MD_210R (door/windows switch), MD_230R (water)</u>
    <ul>
      <li>contact: Zustand des internen Alarmkontaktes.</li>
      <li>deviceTyp: Modeltyp des Sensors.</li>
      <li>sabotage: Zustand des Sabotagekontaktes.</li>
      <li>state: Zustand des Ger&auml;tes.</li>
    </ul><br>

    <u>HS1-868-BS, SA_434_1_mini, Tedsen_SKX1, Tedsen_SKX2xx, Tedsen_SKX4xx, Tedsen_SKX6xx</u>
    <ul>
      <li>LastAction: Zuletzt ausgef&uuml;hrte Aktion des Ger&auml;tes (<code>receive</code> f&uuml;r Kommando empfangen, <code>send</code> f&uuml;r Kommando gesendet).</li>
      <li>state: Aktueller Zustand des Ger&auml;tes</li>
    </ul><br>

    <u>Unitec_47031</u>
    <ul>
      <li>System-Housecode: Eingestellter System- bzw. Hauscode des Ger&auml;tes</li>
      <li>state: Zustand des Kontaktes (vorbereitet, unbest&auml;tigt)</li>
      <li>Zone: Eingestellte Zone des Ger&auml;tes</li>
      <li>Usersystem: Bezeichnung Systemes</li>
    </ul>
  </ul>
</ul>

=end html_DE
=for :application/json;q=META.json 14_SD_UT.pm
{
  "author": [
    "HomeAuto_User <>",
    "elektron-bbs"
  ],
  "description": "module for some SIGNALduino devices",
  "dynamic_config": 1,
  "keywords": [
    "fhem-sonstige-systeme",
    "fhem-hausautomations-systeme",
    "fhem-mod",
    "signalduino"
  ],
  "license": [
    "GPL_2"
  ],
  "meta-spec": {
    "url": "https://metacpan.org/pod/CPAN::Meta::Spec",
    "version": 2
  },
  "name": "FHEM::SD_UT",
  "prereqs": {
    "runtime": {
      "requires": {
        "FHEM": 5.00918623,
        "lib::SD_Protocols": "0",
        "perl": 5.018,
        "strict": "0",
        "warnings": "0"
      }
    },
    "develop": {
      "requires": {
        "lib::SD_Protocols": "0",
        "strict": "0",
        "warnings": "0"
      }
    }
  },
  "release_status": "stable",
  "resources": {
    "bugtracker": {
      "web": "https://github.com/RFD-FHEM/RFFHEM/issues"
    },
    "x_testData": [
      {
        "url": "https://raw.githubusercontent.com/RFD-FHEM/RFFHEM/master/t/FHEM/14_SD_UT/testData.json",
        "testname": "Testdata with SD_UT sensors"
      }
    ],
    "repository": {
      "x_master": {
        "type": "git",
        "url": "https://github.com/RFD-FHEM/RFFHEM.git",
        "web": "https://github.com/RFD-FHEM/RFFHEM/blob/master/FHEM/14_SD_UT.pm"
      },
      "type": "svn",
      "url": "https://svn.fhem.de/fhem",
      "web": "https://svn.fhem.de/trac/browser/trunk/fhem/FHEM/14_SD_UT.pm",
      "x_branch": "trunk",
      "x_filepath": "fhem/FHEM/",
      "x_raw": "https://svn.fhem.de/trac/export/latest/trunk/fhem/FHEM/14_SD_UT.pm",
      "x_dev": {
        "type": "git",
        "url": "https://github.com/RFD-FHEM/RFFHEM.git",
        "web": "https://raw.githubusercontent.com/RFD-FHEM/RFFHEM/master/FHEM/14_SD_UT.pm",
        "x_branch": "master",
        "x_filepath": "FHEM/",
        "x_raw": "https://github.com/RFD-FHEM/RFFHEM/blob/master/FHEM/14_SD_UT.pm"
      }
    },
    "x_commandref": {
      "web": "https://commandref.fhem.de/#SD_UT"
    },
    "x_support_community": {
      "board": "Sonstige Systeme",
      "boardId": "29",
      "cat": "FHEM - Hausautomations-Systeme",
      "title": "FHEM - Hausautomations-Systeme >> Sonstige Systeme",
      "web": "https://forum.fhem.de/index.php/board,29.0.html"
    }
  },
  "x_fhem_maintainer": [
    "HomeAuto_User",
    "elektron-bbs"
  ],
  "x_fhem_maintainer_github": [
    "HomeAutoUser",
    "elektron-bbs"
  ]
}
=end :application/json;q=META.json
=cut
