
#ifndef _RGBLED_H
#define _RGBLED_H

#include "Arduino.h"
#include "config.h"

/**
 * Macros
 */
#define turnOff()   setColor(0, 0, 0, 0)

class RGBLED
{
  private:
    /**
     * Arduino pin connected to the red LED
     */
    int pRed;

    /**
     * Arduino pin connected to the green LED
     */
    int pGreen;

    /**
     * Arduino pin connected to the blue LED
     */
    int pBlue;

    /**
     * Arduino pin connected to the white LED
     */
    int pWhite;


    byte levels[5];
    //byte channels;

    unsigned long _timestamp;

  public:
    /**
     * Class constructor
     *
     * 'redPin'     Arduino pin connected to the red LED
     * 'greenPin'   Arduino pin connected to the green LED
     * 'bluePin'    Arduino pin connected to the blue LED
     * 'whitePin'   Arduino pin connected to the white LED
    */
    RGBLED(int redPin, int greenPin, int bluePin, int whitePin = -1);

    //inline byte nrChannels() const { return channels; };

    /**
     * setColor
     *
     * Set color levels on the RGB LED
     *
     * 'red'      Bright level of the red LED
     * 'green'    Bright level of the green LED
     * 'blue'     Bright level of the blue LED
     * 'white'    Bright level of the white LED
     */
    void setColor(byte values[]) { setColor( values[0], values[1], values[2], values[3] ); };
    void setColor(byte red, byte green, byte blue, byte white=0);
    const byte *getColors() const { return levels; };
    bool isOff() const { return levels[0] == 0 && levels[1] == 0 && levels[2] == 0 && levels[3] == 0; };

    void dimUp();
    void dimDown();

    typedef void (*fptr)();
    fptr begin(long hertz);

    unsigned long timestamp() const { return _timestamp; };
};

#endif
