#ifndef _HELP_h
#define _HELP_h
const char help[] PROGMEM = ""

"<body>\n"
"  <pre>\n"
"  <h3>Commands</h3>\n"
"  You can send commands from FHEM via the JeeLink module\n"
"  Example: <i>set myJeeLink raw 2,120b</i>\n"
"  or from the log page of the LGW frontend\n"
"\n"
"  <u><b>&lt;n&gt;a: Activity LED</b></u>\n"
"  n=0: LED disabled\n"
"  n=1: LED enabled\n"
"\n"
"  <u><b>&lt;n,d&gt;b: Alert using AddOn-buzzer</b></u>\n"
"  n: beep sequence\n"
"  d: duration\n"
"  Examples:\n"
"  1,60b   -> beep             60 seconds\n"
"  2,120b  -> beep beep       120 seconds\n"
"  3,300b  -> beep beep beep  300 seconds\n"
"  0b      -> stop beep\n"
"\n"
"  <u><b>&lt;n&gt;c: data rate for transmit on RFM #1</b></u>\n"
"  Used for CustomSensor\n"
"\n"
"  <u><b>&lt;n&gt;d: Debug-Messages</b></u>\n"
"  n=1 will send debug messages to the serial port\n"
"  Should never be used for normal operation\n"
"\n"
"  <u><b>8266e: Erase EEPROM</b></u>\n"
"  Will erase the configuration in the EEPROM\n"
"  Is a kind of factory reset\n"
"\n"
"  <u><b>8377e: Reboot</b></u>\n"
"  Will reboot the LGW\n"
"\n"
"  <u><b>&lt;n#r&gt;f: Set frequency</b></u>\n"
"  n: frequency in kHz\n"
"  r: radio number (1...5)\n"
"  Example: 868296#2f -> set Radio 2 to 868296 kHz\n"
"\n"
"  <u><b>1g: Get the settings</b></u>\n"
"  Send the current settigs to the serial port\n"
"\n"
"  <u><b>&lt;n&gt;h: Altitude</b></u>\n"
"  n: altitude in meters above sea level\n"
"  If a pressure transmitter is connected to the LGW the pressure will get normalized\n"
"  for the passed altitude\n"
"\n"
"  <u><b>&lt;n,f,p&gt;i: Initialize PCA301</b></u>\n"
"  n: Radio number that shall handle (exclusively) PCA301\n"
"  f: frequency\n"
"  p: poll interval\n"
"  Example: 3,868950,120i will initialize radio 3 for PCA301 with 868950 kHz and 120 seconds poll interval\n"
"\n"
"  <u><b>&lt;n#r&gt;m: Data rate toggle mode</b></u>\n"
"  n: toggle mode\n"
"     bits 1: 17.241 kbps\n"
"          2:  9.579 kbps\n"
"          4:  8.842 kbps\n"
"          8: 20.000 kbps\n"
"  r: radio number (1...5)\n"
"  Example: 5#2m -> Radio 2 toggle 17.241 / 8.842\n"
"\n"
"  <u><b>&lt;n&gt;o: Reserved</b></u>\n"
"\n"
"  <u><b>&lt;n&gt;p: Pass payload mode</b></u>\n"
"  Transmit the payload on the serial port\n"
"  n: 1 = all\n"
"     2 = only undecoded data\n"
"  Should never be used for normal operation\n"
"\n"
"  <u><b>&lt;n#r&gt;r: Set data rate</b></u>\n"
"  n: data rate\n"
"     20000: EC3000\n"
"     17241: TX29, TX25, WS 1080, ...\n"
"      9579: TX35, 30.3155, ...\n"
"      8842: WS 1600\n"
"  r: radio number (1...5)\n"
"  Example: 9579#2r -> set Radio 2 to 9579 kbps\n"
"\n"
"  <u><b>&lt;x,x,x,x&gt;s: Send to PCA301</b></u>\n"
"  Used by FHEM\n"
"\n"
"  <u><b>&lt;x,x,x,x&gt;S: Send to CustomSensor</b></u>\n"
"  Sends the passed bytes to a CustomSensor\n"
"\n"
"  <u><b>&lt;n#r&gt;t: Set toggle interval</b></u>\n"
"  n: interval in seconds\n"
"  r: radio number (1...5)\n"
"  Example: 30#2t -> set Radio 2 to 30 seconds toggle\n"
"\n"
"  <u><b>&lt;n&gt;u: ---</b></u>\n"
"  Reserved\n"
"\n"
"  <u><b>v: Show version</b></u>\n"
"  Shows version and configuration info\n"
"\n"
"  <u><b>0w: Disable WiFi</b></u>\n"
"  Switches the WiFi off.\n"
"  You can only switch it off, but not on.\n"
"\n"
"  <u><b>&lt;n&gt;x: ---</b></u>\n"
"  Reserved\n"
"\n"
"  <u><b>&lt;n&gt;z: Analyze frames</b></u>\n"
"  Shows raw sensor data and the decoded data in the frontend log\n"
"  &lt;n&gt; is bit coded\n"
"      1: LaCrosse\n"
"      2: WS 1600\n"
"      4: WS 1080\n"
"      8: EMT7110\n"
"     16: LevelSender\n"
"     32: CustomSensor\n"
"     64: EC3000\n"
"    128: PCA301\n"
"  Should never be used for normal operation\n"
"\n"
"  </pre>\n"
"</body>\n"
"\n"
"\n"
"\n"
"\n"
"\n"
;

#endif