/*
 * Decompiled with CFR 0.152.
 */
package com.jfrog.mavendeptree;

import com.jfrog.mavendeptree.Utils;
import com.jfrog.mavendeptree.dependenciesresults.MavenDepTreeResults;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;

@Mojo(name="tree", requiresDependencyCollection=ResolutionScope.TEST)
public class MavenDependencyTree
extends AbstractMojo {
    @Parameter(property="depsTreeOutputFile", readonly=true, required=true)
    private File depsTreeOutputFile;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Component(hint="default")
    private DependencyGraphBuilder dependencyGraphBuilder;

    public void execute() throws MojoExecutionException {
        try (FileWriter fileWriter = new FileWriter(this.depsTreeOutputFile, true);){
            MavenDepTreeResults results = Utils.createDependencyTree(this.dependencyGraphBuilder, this.session, this.project);
            File resultsPath = Utils.writeResultsToFile(this.project, results);
            fileWriter.append(resultsPath.getAbsolutePath()).append(System.lineSeparator());
        }
        catch (IOException | DependencyGraphBuilderException e) {
            throw new MojoExecutionException(ExceptionUtils.getRootCauseMessage((Throwable)e), (Exception)e);
        }
    }
}

