This document holds some useful information for developing Alex.

CI on GitHub Actions
====================

2021-06-15

The GHC workflow file `.github/workflows/haskell-ci.yml` is generated by:

    haskell-ci github alex.cabal
    patch --input=.github/haskell-ci.patch .github/workflows/haskell-ci.yml

The patch introduces alex specifics to the build and test process that
are not covered by a vanilla instance of the haskell-ci workflow.

When new GHC versions become available, CI can be updated by

 - adding these versions to the `tested-with` field in `alex.cabal`
   (possibly removing obsolete minor versions)

 - generate the `haskell-ci.yml` by the steps above.

This should work as long as `haskell-ci` does not change its generated
workflow too much.  Otherwise, the patch might not apply cleanly and
the workflow has to be patched manually.

Updating to a new version of Haskell-CI
---------------------------------------

2023-02-08

1. Install Haskell-CI from its source repo:

        pushd /tmp
        git clone https://github.com/haskell-CI/haskell-ci.git
        cd haskell-ci
        cabal install
        popd

2. Update the `tested-with` fields in the `.cabal` files.

3. Follow the instructions to regenerate the Haskell CI workflow, which are:

        haskell-ci regenerate
        patch --input=.github/haskell-ci.patch .github/workflows/haskell-ci.yml

If some hunks fail to apply in the last step, the patch as to be updated.

4. Apply the remaining hunks manually.

5. Save the patched workflow, regenerate the original workflow, regenerate the patch

        cp .github/workflows/haskell-ci.yml .github/workflows/haskell-ci.yml-patched
        haskell-ci regenerate
        diff -u .github/workflows/haskell-ci.yml .github/workflows/haskell-ci.yml-patched > .github/haskell-ci.patch

6. Now the patch will apply cleanly.

        patch --input=.github/haskell-ci.patch .github/workflows/haskell-ci.yml

7. Commit the updated files (no extra files need to be committed).
