/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.attributes;

import org.apache.commons.lang.WordUtils;
import org.gradle.api.Incubating;
import org.gradle.api.Named;

@Incubating
public class Attribute<T>
implements Named {
    private final String name;
    private final Class<T> type;
    private final int hashCode;

    public static <T> Attribute<T> of(String name, Class<T> type) {
        return new Attribute<T>(name, type);
    }

    public static <T> Attribute<T> of(Class<T> type) {
        return Attribute.of(WordUtils.uncapitalize((String)type.getCanonicalName()), type);
    }

    private Attribute(String name, Class<T> type) {
        this.name = name;
        this.type = type;
        int hashCode = name.hashCode();
        this.hashCode = hashCode = 31 * hashCode + type.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        if (!this.name.equals(attribute.name)) {
            return false;
        }
        return this.type.equals(attribute.type);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.name;
    }
}

