/*
 * Decompiled with CFR 0.152.
 */
package mapchecker;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import mapchecker.ArchExit;
import mapchecker.DaiEnv;
import mapchecker.DaiEvent;
import mapchecker.DaiExit;
import mapchecker.DaiWaypoint;
import mapchecker.EnvStack;

public class DaiMap {
    private File file;
    private String path;
    private String name;
    private int width = 0;
    private int height = 0;
    private int difficulty = 0;
    private int darkness = 0;
    private boolean outdoor = false;
    private String[] tilePaths = new String[8];
    private boolean[] tilePathAbs = new boolean[8];
    private Map<String, ArchExit> exitMap;
    private ArrayList<DaiExit> exits = new ArrayList();
    private ArrayList<DaiEvent> events = new ArrayList();
    private ArrayList<DaiWaypoint> waypoints = new ArrayList();
    private String mapRootDir;
    private File parentDir;
    private boolean valid = false;
    private int envLevel = 0;
    private DaiEnv curEnv;
    private String curArch = "";
    private EnvStack envDesc = new EnvStack();
    private String line;
    private BufferedReader in = null;

    public DaiMap(File fParam, String rootDir, Map<String, ArchExit> exMap) {
        int i;
        this.file = fParam;
        this.parentDir = this.file.getParentFile();
        this.mapRootDir = rootDir;
        this.exitMap = exMap;
        for (i = 0; i < 8; ++i) {
            this.tilePathAbs[i] = false;
        }
        try {
            this.in = new BufferedReader(new FileReader(this.file));
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        try {
            this.path = this.file.getCanonicalPath();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.line = this.getLine();
        if (this.line != null && this.line.equals("arch map")) {
            while (this.line != null) {
                this.line = this.getLine();
                if (this.line.startsWith("name ")) {
                    this.name = this.line.substring(5);
                    continue;
                }
                if (this.line.startsWith("width ")) {
                    this.width = Integer.parseInt(this.line.substring(6));
                    continue;
                }
                if (this.line.startsWith("height ")) {
                    this.height = Integer.parseInt(this.line.substring(7));
                    continue;
                }
                if (this.line.startsWith("difficulty ")) {
                    this.difficulty = Integer.parseInt(this.line.substring(11));
                    continue;
                }
                if (this.line.startsWith("outdoor ")) {
                    i = Integer.parseInt(this.line.substring(8));
                    if (i != 1) continue;
                    this.outdoor = true;
                    continue;
                }
                if (this.line.startsWith("darkness ")) {
                    this.darkness = Integer.parseInt(this.line.substring(9));
                    continue;
                }
                if (this.line.startsWith("tile_path_")) {
                    i = Integer.parseInt(this.line.substring(10, 11));
                    String relName = this.line.substring(12);
                    if (relName.substring(0, 1).equals("/")) {
                        this.tilePathAbs[i - 1] = true;
                    }
                    this.tilePaths[i - 1] = this.getNormalisedPath(relName);
                    continue;
                }
                if (!this.line.equals("end")) continue;
                this.valid = true;
                break;
            }
            if (this.valid) {
                this.line = this.getLine();
                while (this.line != null) {
                    String s = this.line.substring(5);
                    if (this.line.equals("end")) {
                        --this.envLevel;
                        assert (this.envLevel >= 0);
                        this.curEnv = this.envDesc.pop();
                    } else if (this.line.startsWith("arch ")) {
                        this.processArch(0, 0);
                    }
                    this.line = this.getLine();
                }
            }
        }
        try {
            this.in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void processArch(int curX, int curY) {
        int dstX = 0;
        int dstY = 0;
        int subType = 0;
        String slaying = "";
        String race = "";
        ArchExit archEx = null;
        ArchType curArchType = ArchType.NONE;
        boolean isAbs = false;
        String archName = this.line.substring(5);
        ++this.envLevel;
        this.curArch = archName;
        this.curEnv = new DaiEnv(curX, curY, archName);
        this.envDesc.push(this.curEnv);
        curArchType = ArchType.NONE;
        if (this.exitMap.containsKey(archName)) {
            curArchType = ArchType.EXIT;
            archEx = this.exitMap.get(archName);
        } else if (archName.equals("event_obj")) {
            curArchType = ArchType.EVENT;
        } else if (archName.equals("waypoint")) {
            curArchType = ArchType.WAYPOINT;
        }
        while (this.line != null) {
            this.line = this.getLine();
            if (this.line.startsWith("arch ")) {
                this.processArch(curX, curY);
                continue;
            }
            if (this.line.equals("end")) {
                String desc = this.envDesc.getDesc();
                switch (curArchType) {
                    case NONE: {
                        break;
                    }
                    case EXIT: {
                        this.exits.add(new DaiExit(this.envLevel, desc, this.curEnv.x, this.curEnv.y, slaying, isAbs, dstX, dstY, archEx.getWalkOn(), archEx.getFlyOn()));
                        break;
                    }
                    case EVENT: {
                        this.events.add(new DaiEvent(this.envLevel, desc, this.curEnv.x, this.curEnv.y, subType, race, isAbs));
                        break;
                    }
                    case WAYPOINT: {
                        this.waypoints.add(new DaiWaypoint(this.envLevel, desc, this.curEnv.x, this.curEnv.y, slaying, isAbs, dstX, dstY));
                    }
                }
                --this.envLevel;
                assert (this.envLevel >= 0);
                this.curEnv = this.envDesc.pop();
                return;
            }
            if (this.line.startsWith("x ")) {
                this.curEnv.x = curX = Integer.parseInt(this.line.substring(2));
                continue;
            }
            if (this.line.startsWith("y ")) {
                this.curEnv.y = curY = Integer.parseInt(this.line.substring(2));
                continue;
            }
            if (this.line.startsWith("name ")) {
                this.curEnv.name = this.line.substring(5);
                continue;
            }
            if (curArchType == ArchType.NONE) continue;
            if (this.line.startsWith("hp ")) {
                dstX = Integer.parseInt(this.line.substring(3));
                continue;
            }
            if (this.line.startsWith("sp ")) {
                dstY = Integer.parseInt(this.line.substring(3));
                continue;
            }
            if (this.line.startsWith("sub_type ")) {
                subType = Integer.parseInt(this.line.substring(9));
                continue;
            }
            if (this.line.startsWith("slaying ") && curArchType != ArchType.EVENT) {
                isAbs = this.isAbsPath(8);
                slaying = this.getNormalisedPath(this.line.substring(8));
                continue;
            }
            if (!this.line.startsWith("race ") || curArchType != ArchType.EVENT) continue;
            isAbs = this.isAbsPath(5);
            race = this.getNormalisedPath(this.line.substring(5));
        }
    }

    private String getLine() {
        String localLine = null;
        try {
            localLine = this.in.readLine();
            if (localLine != null && localLine.startsWith("msg")) {
                while (localLine != null && !localLine.startsWith("endmsg")) {
                    localLine = this.in.readLine();
                }
                localLine = this.in.readLine();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return localLine;
    }

    private boolean isAbsPath(int n) {
        return this.line.substring(n, n + 1).equals("/");
    }

    private String getNormalisedPath(String s) {
        String localPath = "";
        File f = s.substring(0, 1).equals("/") ? new File(this.mapRootDir, s.substring(1)) : new File(this.parentDir, s);
        try {
            localPath = f.getCanonicalPath();
        }
        catch (IOException ex) {
            localPath = s;
        }
        return localPath;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getPath() {
        return this.path;
    }

    public String getTilePath(int n) {
        return this.tilePaths[n];
    }

    public boolean getTilePathAbs(int n) {
        return this.tilePathAbs[n];
    }

    public File getFile() {
        return this.file;
    }

    public DaiExit getExit(int n) {
        return this.exits.get(n);
    }

    public int getNumExits() {
        return this.exits.size();
    }

    public DaiEvent getEvent(int n) {
        return this.events.get(n);
    }

    public int getNumEvents() {
        return this.events.size();
    }

    public DaiWaypoint getWaypoint(int n) {
        return this.waypoints.get(n);
    }

    public int getNumWaypoints() {
        return this.waypoints.size();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private static enum ArchType {
        NONE,
        EXIT,
        EVENT,
        WAYPOINT;

    }
}

