/*
 * Decompiled with CFR 0.152.
 */
package net.daimonin.client3d.editor.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.daimonin.client3d.editor.main.Editor3D;

public class GeneratePanel
extends JPanel
implements ActionListener,
ChangeListener {
    private Color defaultBorderColor;
    private JButton jButtonAll;
    private JButton jButtonBorderColor;
    private JButton jButtonStartingDir;
    public JCheckBox jCheckBoxBorderColor;
    public JCheckBox jCheckBoxBorderSize;
    public JCheckBox jCheckBoxStartingDir;
    private JLabel jLabelBorderColor;
    private JLabel jLabelBorderSize;
    private JLabel jLabelStartingDir;
    private JSlider jSliderBorderSize;
    private JTextField jTextFieldBorderColor;
    private JTextField jTextFieldStartingDir;

    public GeneratePanel() {
        this.initComponents();
        this.defaultBorderColor = new Color(Integer.valueOf(Editor3D.borderColorR), Integer.valueOf(Editor3D.borderColorG), Integer.valueOf(Editor3D.borderColorB));
        this.jTextFieldStartingDir.setText(Editor3D.startingDir);
        this.jSliderBorderSize.setValue(Integer.valueOf(Editor3D.borderSize));
        this.jSliderBorderSizeStateChanged(null);
    }

    private void initComponents() {
        this.jTextFieldStartingDir = new JTextField();
        this.jLabelStartingDir = new JLabel();
        this.jButtonStartingDir = new JButton();
        this.jCheckBoxStartingDir = new JCheckBox();
        this.jLabelBorderSize = new JLabel();
        this.jCheckBoxBorderSize = new JCheckBox();
        this.jLabelBorderColor = new JLabel();
        this.jTextFieldBorderColor = new JTextField();
        this.jButtonBorderColor = new JButton();
        this.jSliderBorderSize = new JSlider();
        this.jCheckBoxBorderColor = new JCheckBox();
        this.jButtonAll = new JButton();
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(550, 200));
        this.setMinimumSize(new Dimension(550, 200));
        this.setPreferredSize(new Dimension(550, 200));
        this.setRequestFocusEnabled(false);
        this.jTextFieldStartingDir.setEditable(false);
        this.jTextFieldStartingDir.setToolTipText("Directory to scan recursively for PNG images");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 8);
        this.add((Component)this.jTextFieldStartingDir, gridBagConstraints);
        this.jLabelStartingDir.setText("Starting directory");
        this.jLabelStartingDir.setToolTipText("Directory to scan recursively for PNG images");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 12, 16);
        this.add((Component)this.jLabelStartingDir, gridBagConstraints);
        this.jButtonStartingDir.setText("...");
        this.jButtonStartingDir.setToolTipText("chose a directory");
        this.jButtonStartingDir.setMaximumSize(new Dimension(16, 16));
        this.jButtonStartingDir.setMinimumSize(new Dimension(16, 16));
        this.jButtonStartingDir.setPreferredSize(new Dimension(16, 16));
        this.jButtonStartingDir.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 16);
        this.add((Component)this.jButtonStartingDir, gridBagConstraints);
        this.jCheckBoxStartingDir.setText("default");
        this.jCheckBoxStartingDir.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxStartingDir.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 16, 12, 8);
        this.add((Component)this.jCheckBoxStartingDir, gridBagConstraints);
        this.jLabelBorderSize.setText("Border size");
        this.jLabelBorderSize.setToolTipText("Border size for every image in pixel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 12, 16);
        this.add((Component)this.jLabelBorderSize, gridBagConstraints);
        this.jCheckBoxBorderSize.setText("default");
        this.jCheckBoxBorderSize.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxBorderSize.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 16, 12, 8);
        this.add((Component)this.jCheckBoxBorderSize, gridBagConstraints);
        this.jLabelBorderColor.setText("Border color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 12, 16);
        this.add((Component)this.jLabelBorderColor, gridBagConstraints);
        this.jTextFieldBorderColor.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 8);
        this.add((Component)this.jTextFieldBorderColor, gridBagConstraints);
        this.jButtonBorderColor.setText("...");
        this.jButtonBorderColor.setToolTipText("chose a border color");
        this.jButtonBorderColor.setMaximumSize(new Dimension(16, 16));
        this.jButtonBorderColor.setMinimumSize(new Dimension(16, 16));
        this.jButtonBorderColor.setPreferredSize(new Dimension(16, 16));
        this.jButtonBorderColor.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 12, 16);
        this.add((Component)this.jButtonBorderColor, gridBagConstraints);
        this.jSliderBorderSize.setMajorTickSpacing(1);
        this.jSliderBorderSize.setMaximum(3);
        this.jSliderBorderSize.setMinorTickSpacing(1);
        this.jSliderBorderSize.setPaintLabels(true);
        this.jSliderBorderSize.setPaintTicks(true);
        this.jSliderBorderSize.setSnapToTicks(true);
        this.jSliderBorderSize.setToolTipText("Border size for every image in pixel");
        this.jSliderBorderSize.setValue(0);
        this.jSliderBorderSize.setValueIsAdjusting(true);
        this.jSliderBorderSize.addChangeListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 8);
        this.add((Component)this.jSliderBorderSize, gridBagConstraints);
        this.jCheckBoxBorderColor.setText("default");
        this.jCheckBoxBorderColor.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxBorderColor.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 16, 12, 8);
        this.add((Component)this.jCheckBoxBorderColor, gridBagConstraints);
        this.jButtonAll.setText("Start");
        this.jButtonAll.setToolTipText("Start creation of the Imageset");
        this.jButtonAll.setMaximumSize(new Dimension(128, 25));
        this.jButtonAll.setMinimumSize(new Dimension(128, 25));
        this.jButtonAll.setPreferredSize(new Dimension(128, 25));
        this.jButtonAll.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(16, 0, 0, 0);
        this.add((Component)this.jButtonAll, gridBagConstraints);
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.jButtonStartingDir) {
            this.jButtonStartingDirActionPerformed(evt);
        } else if (evt.getSource() == this.jButtonBorderColor) {
            this.jButtonBorderColorActionPerformed(evt);
        } else if (evt.getSource() == this.jButtonAll) {
            this.jButtonAllActionPerformed(evt);
        }
    }

    public void stateChanged(ChangeEvent evt) {
        if (evt.getSource() == this.jSliderBorderSize) {
            this.jSliderBorderSizeStateChanged(evt);
        }
    }

    private void jSliderBorderSizeStateChanged(ChangeEvent evt) {
        if (this.jSliderBorderSize.getValueIsAdjusting()) {
            if (this.jSliderBorderSize.getValue() > 0) {
                this.jButtonBorderColor.setEnabled(true);
                this.jTextFieldBorderColor.setBackground(this.defaultBorderColor);
            } else {
                this.jButtonBorderColor.setEnabled(false);
                this.jCheckBoxBorderColor.setSelected(false);
                this.jTextFieldBorderColor.setBackground(null);
            }
        }
    }

    private void jButtonBorderColorActionPerformed(ActionEvent evt) {
        Color color = JColorChooser.showDialog(this, "Choose a border color", this.defaultBorderColor);
        if (color != null) {
            Editor3D.borderColorR = String.valueOf(color.getRed());
            Editor3D.borderColorG = String.valueOf(color.getGreen());
            Editor3D.borderColorB = String.valueOf(color.getBlue());
            this.defaultBorderColor = color;
            this.jTextFieldBorderColor.setBackground(color);
        }
    }

    private void jButtonAllActionPerformed(ActionEvent evt) {
        Editor3D.borderSize = String.valueOf(this.jSliderBorderSize.getValue());
        Editor3D.generate(this);
    }

    private void jButtonStartingDirActionPerformed(ActionEvent evt) {
        JFileChooser dirChooser = new JFileChooser();
        dirChooser.setDialogTitle("Choose a directory with PNG images");
        dirChooser.setFileHidingEnabled(false);
        dirChooser.setFileSelectionMode(1);
        int result = dirChooser.showOpenDialog(this);
        if (result == 0) {
            Editor3D.startingDir = dirChooser.getSelectedFile().getPath();
            this.jTextFieldStartingDir.setText(Editor3D.startingDir);
        }
    }
}

