// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package bcmdataexportsiface provides an interface to enable mocking the AWS Billing and Cost Management Data Exports service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package bcmdataexportsiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/bcmdataexports"
)

// BCMDataExportsAPI provides an interface to enable mocking the
// bcmdataexports.BCMDataExports service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// AWS Billing and Cost Management Data Exports.
//	func myFunc(svc bcmdataexportsiface.BCMDataExportsAPI) bool {
//	    // Make svc.CreateExport request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := bcmdataexports.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockBCMDataExportsClient struct {
//	    bcmdataexportsiface.BCMDataExportsAPI
//	}
//	func (m *mockBCMDataExportsClient) CreateExport(input *bcmdataexports.CreateExportInput) (*bcmdataexports.CreateExportOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockBCMDataExportsClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type BCMDataExportsAPI interface {
	CreateExport(*bcmdataexports.CreateExportInput) (*bcmdataexports.CreateExportOutput, error)
	CreateExportWithContext(aws.Context, *bcmdataexports.CreateExportInput, ...request.Option) (*bcmdataexports.CreateExportOutput, error)
	CreateExportRequest(*bcmdataexports.CreateExportInput) (*request.Request, *bcmdataexports.CreateExportOutput)

	DeleteExport(*bcmdataexports.DeleteExportInput) (*bcmdataexports.DeleteExportOutput, error)
	DeleteExportWithContext(aws.Context, *bcmdataexports.DeleteExportInput, ...request.Option) (*bcmdataexports.DeleteExportOutput, error)
	DeleteExportRequest(*bcmdataexports.DeleteExportInput) (*request.Request, *bcmdataexports.DeleteExportOutput)

	GetExecution(*bcmdataexports.GetExecutionInput) (*bcmdataexports.GetExecutionOutput, error)
	GetExecutionWithContext(aws.Context, *bcmdataexports.GetExecutionInput, ...request.Option) (*bcmdataexports.GetExecutionOutput, error)
	GetExecutionRequest(*bcmdataexports.GetExecutionInput) (*request.Request, *bcmdataexports.GetExecutionOutput)

	GetExport(*bcmdataexports.GetExportInput) (*bcmdataexports.GetExportOutput, error)
	GetExportWithContext(aws.Context, *bcmdataexports.GetExportInput, ...request.Option) (*bcmdataexports.GetExportOutput, error)
	GetExportRequest(*bcmdataexports.GetExportInput) (*request.Request, *bcmdataexports.GetExportOutput)

	GetTable(*bcmdataexports.GetTableInput) (*bcmdataexports.GetTableOutput, error)
	GetTableWithContext(aws.Context, *bcmdataexports.GetTableInput, ...request.Option) (*bcmdataexports.GetTableOutput, error)
	GetTableRequest(*bcmdataexports.GetTableInput) (*request.Request, *bcmdataexports.GetTableOutput)

	ListExecutions(*bcmdataexports.ListExecutionsInput) (*bcmdataexports.ListExecutionsOutput, error)
	ListExecutionsWithContext(aws.Context, *bcmdataexports.ListExecutionsInput, ...request.Option) (*bcmdataexports.ListExecutionsOutput, error)
	ListExecutionsRequest(*bcmdataexports.ListExecutionsInput) (*request.Request, *bcmdataexports.ListExecutionsOutput)

	ListExecutionsPages(*bcmdataexports.ListExecutionsInput, func(*bcmdataexports.ListExecutionsOutput, bool) bool) error
	ListExecutionsPagesWithContext(aws.Context, *bcmdataexports.ListExecutionsInput, func(*bcmdataexports.ListExecutionsOutput, bool) bool, ...request.Option) error

	ListExports(*bcmdataexports.ListExportsInput) (*bcmdataexports.ListExportsOutput, error)
	ListExportsWithContext(aws.Context, *bcmdataexports.ListExportsInput, ...request.Option) (*bcmdataexports.ListExportsOutput, error)
	ListExportsRequest(*bcmdataexports.ListExportsInput) (*request.Request, *bcmdataexports.ListExportsOutput)

	ListExportsPages(*bcmdataexports.ListExportsInput, func(*bcmdataexports.ListExportsOutput, bool) bool) error
	ListExportsPagesWithContext(aws.Context, *bcmdataexports.ListExportsInput, func(*bcmdataexports.ListExportsOutput, bool) bool, ...request.Option) error

	ListTables(*bcmdataexports.ListTablesInput) (*bcmdataexports.ListTablesOutput, error)
	ListTablesWithContext(aws.Context, *bcmdataexports.ListTablesInput, ...request.Option) (*bcmdataexports.ListTablesOutput, error)
	ListTablesRequest(*bcmdataexports.ListTablesInput) (*request.Request, *bcmdataexports.ListTablesOutput)

	ListTablesPages(*bcmdataexports.ListTablesInput, func(*bcmdataexports.ListTablesOutput, bool) bool) error
	ListTablesPagesWithContext(aws.Context, *bcmdataexports.ListTablesInput, func(*bcmdataexports.ListTablesOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*bcmdataexports.ListTagsForResourceInput) (*bcmdataexports.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *bcmdataexports.ListTagsForResourceInput, ...request.Option) (*bcmdataexports.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*bcmdataexports.ListTagsForResourceInput) (*request.Request, *bcmdataexports.ListTagsForResourceOutput)

	TagResource(*bcmdataexports.TagResourceInput) (*bcmdataexports.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *bcmdataexports.TagResourceInput, ...request.Option) (*bcmdataexports.TagResourceOutput, error)
	TagResourceRequest(*bcmdataexports.TagResourceInput) (*request.Request, *bcmdataexports.TagResourceOutput)

	UntagResource(*bcmdataexports.UntagResourceInput) (*bcmdataexports.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *bcmdataexports.UntagResourceInput, ...request.Option) (*bcmdataexports.UntagResourceOutput, error)
	UntagResourceRequest(*bcmdataexports.UntagResourceInput) (*request.Request, *bcmdataexports.UntagResourceOutput)

	UpdateExport(*bcmdataexports.UpdateExportInput) (*bcmdataexports.UpdateExportOutput, error)
	UpdateExportWithContext(aws.Context, *bcmdataexports.UpdateExportInput, ...request.Option) (*bcmdataexports.UpdateExportOutput, error)
	UpdateExportRequest(*bcmdataexports.UpdateExportInput) (*request.Request, *bcmdataexports.UpdateExportOutput)
}

var _ BCMDataExportsAPI = (*bcmdataexports.BCMDataExports)(nil)
