//#################################################
//#############       WARNING      ################
//#################################################
//# This file has been automatically generated.
//# Any changes you make here will get overridden.
//# Instead, make your changes in templates/*.dat
//#################################################

#include <Python.h>
#include <stdexcept>
#include <ios>
#include "YODA/Exceptions.h"

namespace YODA {

  PyObject *YodaExc_Exception;
  PyObject *YodaExc_BinningError;
  PyObject *YodaExc_RangeError;
  PyObject *YodaExc_LogicError;
  PyObject *YodaExc_WeightError;
  PyObject *YodaExc_AnnotationError;
  PyObject *YodaExc_ReadError;
  PyObject *YodaExc_WriteError;
  PyObject *YodaExc_UserError;

  void create_custom_exceptions() {
    YodaExc_Exception = PyErr_NewException("yoda.Exception", NULL, NULL);
    YodaExc_BinningError = PyErr_NewException("yoda.BinningError", YodaExc_Exception, NULL);
    YodaExc_RangeError = PyErr_NewException("yoda.RangeError", YodaExc_Exception, NULL);
    YodaExc_LogicError = PyErr_NewException("yoda.LogicError", YodaExc_Exception, NULL);
    YodaExc_WeightError = PyErr_NewException("yoda.WeightError", YodaExc_Exception, NULL);
    YodaExc_AnnotationError = PyErr_NewException("yoda.AnnotationError", YodaExc_Exception, NULL);
    YodaExc_ReadError = PyErr_NewException("yoda.ReadError", YodaExc_Exception, NULL);
    YodaExc_WriteError = PyErr_NewException("yoda.WriteError", YodaExc_Exception, NULL);
    YodaExc_UserError = PyErr_NewException("yoda.UserError", YodaExc_Exception, NULL);
  }

  void translate_yoda_error() {
    try {
      if (PyErr_Occurred())
        ; // let the latest Python exn pass through and ignore the current one
      else
        throw;
    } catch (const YODA::UserError& exn) {
      PyErr_SetString(YodaExc_UserError, exn.what());
    } catch (const YODA::WriteError& exn) {
      PyErr_SetString(YodaExc_WriteError, exn.what());
    } catch (const YODA::ReadError& exn) {
      PyErr_SetString(YodaExc_ReadError, exn.what());
    } catch (const YODA::AnnotationError& exn) {
      PyErr_SetString(YodaExc_AnnotationError, exn.what());
    } catch (const YODA::WeightError& exn) {
      PyErr_SetString(YodaExc_WeightError, exn.what());
    } catch (const YODA::LogicError& exn) {
      PyErr_SetString(YodaExc_LogicError, exn.what());
    } catch (const YODA::RangeError& exn) {
      PyErr_SetString(YodaExc_RangeError, exn.what());
    } catch (const YODA::BinningError& exn) {
      PyErr_SetString(YodaExc_BinningError, exn.what());
    } catch (const YODA::Exception& exn) {
      PyErr_SetString(YodaExc_Exception, exn.what());
    } catch (const std::out_of_range& exn) {
      PyErr_SetString(PyExc_IndexError, exn.what());
    } catch (const std::bad_cast& exn) {
      PyErr_SetString(PyExc_TypeError, exn.what());
    } catch (const std::domain_error& exn) {
      PyErr_SetString(PyExc_ValueError, exn.what());
    } catch (const std::invalid_argument& exn) {
      PyErr_SetString(PyExc_ValueError, exn.what());
    } catch (const std::ios_base::failure& exn) {
      PyErr_SetString(PyExc_IOError, exn.what());
    } catch (const std::overflow_error& exn) {
      PyErr_SetString(PyExc_OverflowError, exn.what());
    } catch (const std::range_error& exn) {
      PyErr_SetString(PyExc_ArithmeticError, exn.what());
    } catch (const std::underflow_error& exn) {
      PyErr_SetString(PyExc_ArithmeticError, exn.what());
    } catch (const std::bad_alloc& exn) {
      PyErr_SetString(PyExc_MemoryError, exn.what());
    } catch (...) {
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception");
    }
  }
}
