/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo.storage;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.CopyObjectRequest;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.PutObjectRequest;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.zeppelin.notebook.repo.storage.RemoteStorageOperator;

public class OSSOperator
implements RemoteStorageOperator {
    private OSS ossClient;

    public OSSOperator(String endpoint, String accessKeyId, String accessKeySecret) {
        this.ossClient = new OSSClientBuilder().build(endpoint, accessKeyId, accessKeySecret);
    }

    @Override
    public void createBucket(String bucketName) {
        this.ossClient.createBucket(bucketName);
    }

    @Override
    public void deleteBucket(String bucketName) {
        this.ossClient.deleteBucket(bucketName);
    }

    @Override
    public boolean doesObjectExist(String bucketName, String key) throws IOException {
        return this.ossClient.doesObjectExist(bucketName, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTextObject(String bucketName, String key) throws IOException {
        if (!this.doesObjectExist(bucketName, key)) {
            throw new IOException("Note or its revision not found");
        }
        OSSObject ossObject = this.ossClient.getObject(bucketName, key);
        try (InputStream in = null;){
            in = ossObject.getObjectContent();
            String string = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    @Override
    public void putTextObject(String bucketName, String key, InputStream inputStream) {
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key, inputStream);
        this.ossClient.putObject(putObjectRequest);
    }

    @Override
    public void moveObject(String bucketName, String sourceKey, String destKey) throws IOException {
        if (!this.doesObjectExist(bucketName, sourceKey)) {
            throw new IOException("Note or its revision not found");
        }
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(bucketName, sourceKey, bucketName, destKey);
        this.ossClient.copyObject(copyObjectRequest);
        this.ossClient.deleteObject(bucketName, sourceKey);
    }

    @Override
    public void moveDir(String bucketName, String sourceDir, String destDir) throws IOException {
        List<String> objectKeys = this.listDirObjects(bucketName, sourceDir);
        for (String key : objectKeys) {
            this.moveObject(bucketName, key, destDir + key.substring(sourceDir.length()));
        }
    }

    @Override
    public void deleteDir(String bucketName, String dirname) {
        List<String> keys = this.listDirObjects(bucketName, dirname);
        this.deleteFiles(bucketName, keys);
    }

    @Override
    public void deleteFile(String bucketName, String objectKey) throws IOException {
        this.deleteFiles(bucketName, Arrays.asList(objectKey));
    }

    @Override
    public void deleteFiles(String bucketName, List<String> objectKeys) {
        if (objectKeys != null && objectKeys.size() > 0) {
            DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(bucketName).withKeys(objectKeys);
            this.ossClient.deleteObjects(deleteObjectsRequest);
        }
    }

    @Override
    public List<String> listDirObjects(String bucketName, String dirname) {
        String nextMarker = null;
        ObjectListing objectListing = null;
        ArrayList<String> keys = new ArrayList<String>();
        do {
            ListObjectsRequest listObjectsRequest;
            if (!(objectListing = this.ossClient.listObjects(listObjectsRequest = new ListObjectsRequest(bucketName).withPrefix(dirname).withMarker(nextMarker))).getObjectSummaries().isEmpty()) {
                for (OSSObjectSummary s : objectListing.getObjectSummaries()) {
                    keys.add(s.getKey());
                }
            }
            nextMarker = objectListing.getNextMarker();
        } while (objectListing.isTruncated());
        return keys;
    }

    @Override
    public void shutdown() {
        this.ossClient.shutdown();
    }
}

