/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.collection;

import com.google.common.collect.Lists;
import io.atomix.core.collection.DistributedCollection;
import io.atomix.core.collection.DistributedCollectionConfig;
import io.atomix.primitive.PrimitiveBuilder;
import io.atomix.primitive.PrimitiveManagementService;
import io.atomix.primitive.PrimitiveType;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.NamespaceConfig;
import io.atomix.utils.serializer.Namespaces;
import io.atomix.utils.serializer.Serializer;

public abstract class DistributedCollectionBuilder<B extends DistributedCollectionBuilder<B, C, P, E>, C extends DistributedCollectionConfig<C>, P extends DistributedCollection<E>, E>
extends PrimitiveBuilder<B, C, P> {
    protected DistributedCollectionBuilder(PrimitiveType type, String name, C config, PrimitiveManagementService managementService) {
        super(type, name, config, managementService);
    }

    public B withElementType(Class<?> elementType) {
        ((DistributedCollectionConfig)this.config).setElementType(elementType);
        return (B)((Object)this);
    }

    public B withExtraTypes(Class<?> ... extraTypes) {
        ((DistributedCollectionConfig)this.config).setExtraTypes(Lists.newArrayList((Object[])extraTypes));
        return (B)((Object)this);
    }

    public B addExtraType(Class<?> extraType) {
        ((DistributedCollectionConfig)this.config).addExtraType(extraType);
        return (B)((Object)this);
    }

    public B withRegistrationRequired() {
        return this.withRegistrationRequired(true);
    }

    public B withRegistrationRequired(boolean registrationRequired) {
        ((DistributedCollectionConfig)this.config).setRegistrationRequired(registrationRequired);
        return (B)((Object)this);
    }

    public B withCompatibleSerialization() {
        return this.withCompatibleSerialization(true);
    }

    public B withCompatibleSerialization(boolean compatibleSerialization) {
        ((DistributedCollectionConfig)this.config).setCompatibleSerialization(compatibleSerialization);
        return (B)((Object)this);
    }

    protected Serializer serializer() {
        if (this.serializer == null) {
            NamespaceConfig namespaceConfig = ((DistributedCollectionConfig)this.config).getNamespaceConfig();
            if (namespaceConfig == null) {
                namespaceConfig = new NamespaceConfig();
            }
            Namespace.Builder namespaceBuilder = Namespace.builder().register(Namespaces.BASIC).nextId(500).register(new Namespace(namespaceConfig)).nextId(600);
            namespaceBuilder.setRegistrationRequired(((DistributedCollectionConfig)this.config).isRegistrationRequired());
            namespaceBuilder.setCompatible(((DistributedCollectionConfig)this.config).isCompatibleSerialization());
            if (((DistributedCollectionConfig)this.config).getElementType() != null) {
                namespaceBuilder.registerSubTypes(new Class[]{((DistributedCollectionConfig)this.config).getElementType()});
            }
            if (!((DistributedCollectionConfig)this.config).getExtraTypes().isEmpty()) {
                namespaceBuilder.register(((DistributedCollectionConfig)this.config).getExtraTypes().toArray(new Class[((DistributedCollectionConfig)this.config).getExtraTypes().size()]));
            }
            this.serializer = Serializer.using((Namespace)namespaceBuilder.build());
        }
        return this.serializer;
    }
}

