/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.collection.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.atomix.core.collection.CollectionEvent;
import io.atomix.core.collection.impl.CollectionUpdateResult;
import io.atomix.core.collection.impl.DistributedCollectionClient;
import io.atomix.core.collection.impl.DistributedCollectionService;
import io.atomix.core.iterator.impl.IteratorBatch;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.service.AbstractPrimitiveService;
import io.atomix.primitive.service.BackupInput;
import io.atomix.primitive.service.BackupOutput;
import io.atomix.primitive.session.Session;
import io.atomix.primitive.session.SessionId;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class DefaultDistributedCollectionService<T extends Collection<E>, E>
extends AbstractPrimitiveService<DistributedCollectionClient>
implements DistributedCollectionService<E> {
    protected static final int MAX_ITERATOR_BATCH_SIZE = 1000;
    private final Serializer serializer;
    private T collection;
    protected Map<Long, AbstractIteratorContext> iterators = Maps.newHashMap();
    private Set<SessionId> listeners = Sets.newHashSet();

    protected DefaultDistributedCollectionService(PrimitiveType primitiveType, T collection) {
        super(primitiveType, DistributedCollectionClient.class);
        this.collection = collection;
        this.serializer = Serializer.using((Namespace)Namespace.builder().register(primitiveType.namespace()).register(new Class[]{SessionId.class}).register(new Class[]{IteratorContext.class}).build());
    }

    public Serializer serializer() {
        return this.serializer;
    }

    protected T collection() {
        return this.collection;
    }

    public void backup(BackupOutput output) {
        output.writeObject(this.collection);
    }

    public void restore(BackupInput input) {
        this.collection = (Collection)input.readObject();
    }

    protected void added(E element) {
        this.listeners.forEach(l -> this.getSession((SessionId)l).accept(client -> client.onEvent(new CollectionEvent<Object>(CollectionEvent.Type.ADD, element))));
    }

    protected void removed(E element) {
        this.listeners.forEach(l -> this.getSession((SessionId)l).accept(client -> client.onEvent(new CollectionEvent<Object>(CollectionEvent.Type.REMOVE, element))));
    }

    @Override
    public int size() {
        return this.collection.size();
    }

    @Override
    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.collection.contains(o);
    }

    @Override
    public CollectionUpdateResult<Boolean> add(E element) {
        if (this.collection.add(element)) {
            this.added(element);
            return CollectionUpdateResult.ok(true);
        }
        return CollectionUpdateResult.noop(false);
    }

    @Override
    public CollectionUpdateResult<Boolean> remove(E element) {
        if (this.collection.remove(element)) {
            this.removed(element);
            return CollectionUpdateResult.ok(true);
        }
        return CollectionUpdateResult.noop(false);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.collection.containsAll(c);
    }

    @Override
    public CollectionUpdateResult<Boolean> addAll(Collection<? extends E> c) {
        boolean changed = false;
        for (E element : c) {
            if (this.add(element).status() != CollectionUpdateResult.Status.OK) continue;
            changed = true;
        }
        return CollectionUpdateResult.ok(changed);
    }

    @Override
    public CollectionUpdateResult<Boolean> retainAll(Collection<?> c) {
        boolean changed = false;
        for (Object element : this.collection) {
            if (c.contains(element) || this.remove(element).status() != CollectionUpdateResult.Status.OK) continue;
            changed = true;
        }
        return CollectionUpdateResult.ok(changed);
    }

    @Override
    public CollectionUpdateResult<Boolean> removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object element : c) {
            if (this.remove(element).status() != CollectionUpdateResult.Status.OK) continue;
            changed = true;
        }
        return CollectionUpdateResult.ok(changed);
    }

    @Override
    public CollectionUpdateResult<Void> clear() {
        this.collection.forEach(element -> this.removed(element));
        this.collection.clear();
        return CollectionUpdateResult.ok();
    }

    @Override
    public void listen() {
        this.listeners.add(this.getCurrentSession().sessionId());
    }

    @Override
    public void unlisten() {
        this.listeners.remove(this.getCurrentSession().sessionId());
    }

    @Override
    public long iterate() {
        this.iterators.put(this.getCurrentIndex(), new IteratorContext((Long)this.getCurrentSession().sessionId().id()));
        return this.getCurrentIndex();
    }

    @Override
    public IteratorBatch<E> next(long iteratorId, int position) {
        AbstractIteratorContext context = this.iterators.get(iteratorId);
        if (context == null) {
            return null;
        }
        ArrayList elements = new ArrayList();
        while (context.iterator().hasNext()) {
            context.incrementPosition();
            if (context.position() <= position) continue;
            Object element = context.iterator().next();
            elements.add(element);
            if (elements.size() < 1000) continue;
            break;
        }
        if (elements.isEmpty()) {
            return null;
        }
        return new IteratorBatch(context.position(), elements);
    }

    @Override
    public void close(long iteratorId) {
        this.iterators.remove(iteratorId);
    }

    public void onExpire(Session session) {
        this.listeners.remove(session.sessionId());
        this.iterators.entrySet().removeIf(entry -> ((AbstractIteratorContext)entry.getValue()).sessionId() == ((Long)session.sessionId().id()).longValue());
    }

    public void onClose(Session session) {
        this.listeners.remove(session.sessionId());
        this.iterators.entrySet().removeIf(entry -> ((AbstractIteratorContext)entry.getValue()).sessionId() == ((Long)session.sessionId().id()).longValue());
    }

    protected class IteratorContext
    extends AbstractIteratorContext {
        public IteratorContext(long sessionId) {
            super(sessionId);
        }

        @Override
        protected Iterator<E> create() {
            return DefaultDistributedCollectionService.this.collection().iterator();
        }
    }

    protected abstract class AbstractIteratorContext {
        private final long sessionId;
        private int position = 0;
        private transient Iterator<E> iterator;

        public AbstractIteratorContext(long sessionId) {
            this.sessionId = sessionId;
        }

        protected abstract Iterator<E> create();

        public long sessionId() {
            return this.sessionId;
        }

        public int position() {
            return this.position;
        }

        public void incrementPosition() {
            ++this.position;
        }

        public Iterator<E> iterator() {
            if (this.iterator == null) {
                this.iterator = this.create();
            }
            return this.iterator;
        }
    }
}

