/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.impl;

import com.google.common.base.Preconditions;
import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.atomix.cluster.messaging.ClusterEventService;
import io.atomix.core.AtomixRegistry;
import io.atomix.core.ManagedPrimitivesService;
import io.atomix.core.PrimitivesService;
import io.atomix.core.barrier.DistributedCyclicBarrier;
import io.atomix.core.barrier.DistributedCyclicBarrierType;
import io.atomix.core.counter.AtomicCounter;
import io.atomix.core.counter.AtomicCounterType;
import io.atomix.core.counter.DistributedCounter;
import io.atomix.core.counter.DistributedCounterType;
import io.atomix.core.election.LeaderElection;
import io.atomix.core.election.LeaderElectionType;
import io.atomix.core.election.LeaderElector;
import io.atomix.core.election.LeaderElectorType;
import io.atomix.core.idgenerator.AtomicIdGenerator;
import io.atomix.core.idgenerator.AtomicIdGeneratorType;
import io.atomix.core.impl.CorePrimitiveManagementService;
import io.atomix.core.impl.CorePrimitiveRegistry;
import io.atomix.core.impl.CoreTransactionService;
import io.atomix.core.list.DistributedList;
import io.atomix.core.list.DistributedListType;
import io.atomix.core.lock.AtomicLock;
import io.atomix.core.lock.AtomicLockType;
import io.atomix.core.lock.DistributedLock;
import io.atomix.core.lock.DistributedLockType;
import io.atomix.core.map.AtomicCounterMap;
import io.atomix.core.map.AtomicCounterMapType;
import io.atomix.core.map.AtomicMap;
import io.atomix.core.map.AtomicMapType;
import io.atomix.core.map.AtomicNavigableMap;
import io.atomix.core.map.AtomicNavigableMapType;
import io.atomix.core.map.AtomicSortedMap;
import io.atomix.core.map.AtomicSortedMapType;
import io.atomix.core.map.DistributedMap;
import io.atomix.core.map.DistributedMapType;
import io.atomix.core.map.DistributedNavigableMap;
import io.atomix.core.map.DistributedNavigableMapType;
import io.atomix.core.map.DistributedSortedMap;
import io.atomix.core.map.DistributedSortedMapType;
import io.atomix.core.multimap.AtomicMultimap;
import io.atomix.core.multimap.AtomicMultimapType;
import io.atomix.core.multimap.DistributedMultimap;
import io.atomix.core.multimap.DistributedMultimapType;
import io.atomix.core.multiset.DistributedMultiset;
import io.atomix.core.multiset.DistributedMultisetType;
import io.atomix.core.queue.DistributedQueue;
import io.atomix.core.queue.DistributedQueueType;
import io.atomix.core.semaphore.AtomicSemaphore;
import io.atomix.core.semaphore.AtomicSemaphoreType;
import io.atomix.core.semaphore.DistributedSemaphore;
import io.atomix.core.semaphore.DistributedSemaphoreType;
import io.atomix.core.set.DistributedNavigableSet;
import io.atomix.core.set.DistributedNavigableSetType;
import io.atomix.core.set.DistributedSet;
import io.atomix.core.set.DistributedSetType;
import io.atomix.core.set.DistributedSortedSet;
import io.atomix.core.set.DistributedSortedSetType;
import io.atomix.core.transaction.ManagedTransactionService;
import io.atomix.core.transaction.TransactionBuilder;
import io.atomix.core.transaction.TransactionConfig;
import io.atomix.core.transaction.TransactionService;
import io.atomix.core.transaction.impl.DefaultTransactionBuilder;
import io.atomix.core.tree.AtomicDocumentTree;
import io.atomix.core.tree.AtomicDocumentTreeType;
import io.atomix.core.value.AtomicValue;
import io.atomix.core.value.AtomicValueType;
import io.atomix.core.value.DistributedValue;
import io.atomix.core.value.DistributedValueType;
import io.atomix.core.workqueue.WorkQueue;
import io.atomix.core.workqueue.WorkQueueType;
import io.atomix.primitive.ManagedPrimitiveRegistry;
import io.atomix.primitive.PrimitiveBuilder;
import io.atomix.primitive.PrimitiveCache;
import io.atomix.primitive.PrimitiveInfo;
import io.atomix.primitive.PrimitiveManagementService;
import io.atomix.primitive.PrimitiveRegistry;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.PrimitiveTypeRegistry;
import io.atomix.primitive.SyncPrimitive;
import io.atomix.primitive.config.ConfigService;
import io.atomix.primitive.config.PrimitiveConfig;
import io.atomix.primitive.impl.DefaultPrimitiveTypeRegistry;
import io.atomix.primitive.partition.PartitionGroup;
import io.atomix.primitive.partition.PartitionGroupTypeRegistry;
import io.atomix.primitive.partition.PartitionService;
import io.atomix.primitive.partition.impl.DefaultPartitionGroupTypeRegistry;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.protocol.PrimitiveProtocolTypeRegistry;
import io.atomix.primitive.protocol.impl.DefaultPrimitiveProtocolTypeRegistry;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorePrimitivesService
implements ManagedPrimitivesService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CorePrimitivesService.class);
    private final PrimitiveManagementService managementService;
    private final ManagedPrimitiveRegistry primitiveRegistry;
    private final ManagedTransactionService transactionService;
    private final ConfigService configService;
    private final PrimitiveCache cache;
    private final AtomicBoolean started = new AtomicBoolean();

    public CorePrimitivesService(ScheduledExecutorService executorService, ClusterMembershipService membershipService, ClusterCommunicationService communicationService, ClusterEventService eventService, PartitionService partitionService, PrimitiveCache primitiveCache, AtomixRegistry registry, ConfigService configService) {
        this.cache = primitiveCache;
        this.primitiveRegistry = new CorePrimitiveRegistry(partitionService, (PrimitiveTypeRegistry)new DefaultPrimitiveTypeRegistry(registry.getTypes(PrimitiveType.class)));
        this.managementService = new CorePrimitiveManagementService(executorService, membershipService, communicationService, eventService, partitionService, primitiveCache, (PrimitiveRegistry)this.primitiveRegistry, (PrimitiveTypeRegistry)new DefaultPrimitiveTypeRegistry(registry.getTypes(PrimitiveType.class)), (PrimitiveProtocolTypeRegistry)new DefaultPrimitiveProtocolTypeRegistry(registry.getTypes(PrimitiveProtocol.Type.class)), (PartitionGroupTypeRegistry)new DefaultPartitionGroupTypeRegistry(registry.getTypes(PartitionGroup.Type.class)));
        this.transactionService = new CoreTransactionService(this.managementService);
        this.configService = (ConfigService)Preconditions.checkNotNull((Object)configService);
    }

    public TransactionService transactionService() {
        return this.transactionService;
    }

    @Override
    public TransactionBuilder transactionBuilder(String name) {
        return new DefaultTransactionBuilder(name, new TransactionConfig(), this.managementService, this.transactionService);
    }

    @Override
    public <K, V> DistributedMap<K, V> getMap(String name) {
        return (DistributedMap)this.getPrimitive(name, DistributedMapType.instance(), this.configService.getConfig(name));
    }

    @Override
    public <K extends Comparable<K>, V> DistributedSortedMap<K, V> getSortedMap(String name) {
        return (DistributedSortedMap)this.getPrimitive(name, DistributedSortedMapType.instance(), this.configService.getConfig(name));
    }

    @Override
    public <K extends Comparable<K>, V> DistributedNavigableMap<K, V> getNavigableMap(String name) {
        return (DistributedNavigableMap)this.getPrimitive(name, DistributedNavigableMapType.instance(), this.configService.getConfig(name));
    }

    @Override
    public <K, V> DistributedMultimap<K, V> getMultimap(String name) {
        return (DistributedMultimap)this.getPrimitive(name, DistributedMultimapType.instance(), this.configService.getConfig(name));
    }

    @Override
    public <K, V> AtomicMap<K, V> getAtomicMap(String name) {
        return (AtomicMap)this.getPrimitive(name, AtomicMapType.instance(), this.configService.getConfig(name));
    }

    @Override
    public <V> AtomicDocumentTree<V> getAtomicDocumentTree(String name) {
        return (AtomicDocumentTree)this.getPrimitive(name, AtomicDocumentTreeType.instance(), this.configService.getConfig(name));
    }

    @Override
    public <K extends Comparable<K>, V> AtomicSortedMap<K, V> getAtomicSortedMap(String name) {
        return (AtomicSortedMap)this.getPrimitive(name, AtomicSortedMapType.instance(), this.configService.getConfig(name));
    }

    @Override
    public <K extends Comparable<K>, V> AtomicNavigableMap<K, V> getAtomicNavigableMap(String name) {
        return (AtomicNavigableMap)this.getPrimitive(name, AtomicNavigableMapType.instance(), this.configService.getConfig(name));
    }

    @Override
    public <K, V> AtomicMultimap<K, V> getAtomicMultimap(String name) {
        return (AtomicMultimap)this.getPrimitive(name, AtomicMultimapType.instance(), this.configService.getConfig(name));
    }

    @Override
    public <K> AtomicCounterMap<K> getAtomicCounterMap(String name) {
        return (AtomicCounterMap)this.getPrimitive(name, AtomicCounterMapType.instance(), this.configService.getConfig(name));
    }

    @Override
    public <E> DistributedSet<E> getSet(String name) {
        return (DistributedSet)this.getPrimitive(name, DistributedSetType.instance(), this.configService.getConfig(name));
    }

    @Override
    public <E extends Comparable<E>> DistributedSortedSet<E> getSortedSet(String name) {
        return (DistributedSortedSet)this.getPrimitive(name, DistributedSortedSetType.instance(), this.configService.getConfig(name));
    }

    @Override
    public <E extends Comparable<E>> DistributedNavigableSet<E> getNavigableSet(String name) {
        return (DistributedNavigableSet)this.getPrimitive(name, DistributedNavigableSetType.instance(), this.configService.getConfig(name));
    }

    @Override
    public <E> DistributedQueue<E> getQueue(String name) {
        return (DistributedQueue)this.getPrimitive(name, DistributedQueueType.instance(), this.configService.getConfig(name));
    }

    @Override
    public <E> DistributedList<E> getList(String name) {
        return (DistributedList)this.getPrimitive(name, DistributedListType.instance(), this.configService.getConfig(name));
    }

    @Override
    public <E> DistributedMultiset<E> getMultiset(String name) {
        return (DistributedMultiset)this.getPrimitive(name, DistributedMultisetType.instance(), this.configService.getConfig(name));
    }

    @Override
    public DistributedCounter getCounter(String name) {
        return this.getPrimitive(name, DistributedCounterType.instance(), this.configService.getConfig(name));
    }

    @Override
    public AtomicCounter getAtomicCounter(String name) {
        return this.getPrimitive(name, AtomicCounterType.instance(), this.configService.getConfig(name));
    }

    @Override
    public AtomicIdGenerator getAtomicIdGenerator(String name) {
        return this.getPrimitive(name, AtomicIdGeneratorType.instance(), this.configService.getConfig(name));
    }

    @Override
    public <V> DistributedValue<V> getValue(String name) {
        return (DistributedValue)this.getPrimitive(name, DistributedValueType.instance(), this.configService.getConfig(name));
    }

    @Override
    public <V> AtomicValue<V> getAtomicValue(String name) {
        return (AtomicValue)this.getPrimitive(name, AtomicValueType.instance(), this.configService.getConfig(name));
    }

    @Override
    public <T> LeaderElection<T> getLeaderElection(String name) {
        return (LeaderElection)this.getPrimitive(name, LeaderElectionType.instance(), this.configService.getConfig(name));
    }

    @Override
    public <T> LeaderElector<T> getLeaderElector(String name) {
        return (LeaderElector)this.getPrimitive(name, LeaderElectorType.instance(), this.configService.getConfig(name));
    }

    @Override
    public DistributedLock getLock(String name) {
        return this.getPrimitive(name, DistributedLockType.instance(), this.configService.getConfig(name));
    }

    @Override
    public AtomicLock getAtomicLock(String name) {
        return this.getPrimitive(name, AtomicLockType.instance(), this.configService.getConfig(name));
    }

    @Override
    public DistributedCyclicBarrier getCyclicBarrier(String name) {
        return this.getPrimitive(name, DistributedCyclicBarrierType.instance(), this.configService.getConfig(name));
    }

    @Override
    public DistributedSemaphore getSemaphore(String name) {
        return this.getPrimitive(name, DistributedSemaphoreType.instance(), this.configService.getConfig(name));
    }

    @Override
    public AtomicSemaphore getAtomicSemaphore(String name) {
        return this.getPrimitive(name, AtomicSemaphoreType.instance(), this.configService.getConfig(name));
    }

    @Override
    public <E> WorkQueue<E> getWorkQueue(String name) {
        return (WorkQueue)this.getPrimitive(name, WorkQueueType.instance(), this.configService.getConfig(name));
    }

    @Override
    public <B extends PrimitiveBuilder<B, C, P>, C extends PrimitiveConfig<C>, P extends SyncPrimitive> B primitiveBuilder(String name, PrimitiveType<B, C, P> primitiveType) {
        return (B)primitiveType.newBuilder(name, primitiveType.newConfig(), this.managementService);
    }

    @Override
    public <P extends SyncPrimitive> CompletableFuture<P> getPrimitiveAsync(String name) {
        return this.cache.getPrimitive(name, () -> {
            PrimitiveInfo info = this.primitiveRegistry.getPrimitive(name);
            if (info == null) {
                PrimitiveConfig primitiveConfig = this.configService.getConfig(name);
                if (primitiveConfig == null) {
                    return CompletableFuture.completedFuture(null);
                }
                return ((PrimitiveType)primitiveConfig.getType()).newBuilder(name, primitiveConfig, this.managementService).buildAsync();
            }
            PrimitiveConfig primitiveConfig = this.configService.getConfig(name);
            if (primitiveConfig == null) {
                primitiveConfig = info.type().newConfig();
            }
            return info.type().newBuilder(name, primitiveConfig, this.managementService).buildAsync();
        });
    }

    @Override
    public <P extends SyncPrimitive> CompletableFuture<P> getPrimitiveAsync(String name, PrimitiveType<?, ?, P> primitiveType) {
        return this.getPrimitiveAsync(name, primitiveType, this.configService.getConfig(name));
    }

    @Override
    public <C extends PrimitiveConfig<C>, P extends SyncPrimitive> CompletableFuture<P> getPrimitiveAsync(String name, PrimitiveType<?, C, P> primitiveType, C primitiveConfig) {
        return this.cache.getPrimitive(name, () -> {
            PrimitiveConfig config = primitiveConfig;
            if (config == null && (config = this.configService.getConfig(name)) == null) {
                config = primitiveType.newConfig();
            }
            return primitiveType.newBuilder(name, config, this.managementService).buildAsync();
        });
    }

    @Override
    public Collection<PrimitiveInfo> getPrimitives() {
        return this.managementService.getPrimitiveRegistry().getPrimitives();
    }

    @Override
    public Collection<PrimitiveInfo> getPrimitives(PrimitiveType primitiveType) {
        return this.managementService.getPrimitiveRegistry().getPrimitives(primitiveType);
    }

    public CompletableFuture<PrimitivesService> start() {
        return ((CompletableFuture)((CompletableFuture)this.primitiveRegistry.start().thenCompose(v -> this.transactionService.start())).thenRun(() -> {
            LOGGER.info("Started");
            this.started.set(true);
        })).thenApply(v -> this);
    }

    public boolean isRunning() {
        return this.started.get();
    }

    public CompletableFuture<Void> stop() {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.transactionService.stop().exceptionally(throwable -> {
            LOGGER.error("Failed stopping transaction service", throwable);
            return null;
        })).thenCompose(v -> this.primitiveRegistry.stop())).exceptionally(throwable -> {
            LOGGER.error("Failed stopping primitive registry", throwable);
            return null;
        })).whenComplete((r, e) -> {
            this.started.set(false);
            LOGGER.info("Stopped");
        });
    }
}

