/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.file;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import javax.ws.rs.core.UriBuilder;
import org.slf4j.Logger;

public class HDFSCommand {
    String url = null;
    String user = null;
    int maxLength = 0;
    Logger logger;
    public Op getFileStatus = new Op("GETFILESTATUS", HttpType.GET, 0);
    public Op listStatus = new Op("LISTSTATUS", HttpType.GET, 0);

    public HDFSCommand(String url, String user, Logger logger, int maxLength) {
        this.url = url;
        this.user = user;
        this.maxLength = maxLength;
        this.logger = logger;
    }

    public String checkArgs(Op op, String path, Arg[] args) throws Exception {
        if (op == null || path == null || op.minArgs > 0 && (args == null || args.length != op.minArgs)) {
            String a = "";
            a = op != null ? a + op.op + "\n" : a;
            a = path != null ? a + path + "\n" : a;
            a = args != null ? a + args + "\n" : a;
            return a;
        }
        return null;
    }

    public String runCommand(Op op, String path, Arg[] args) throws Exception {
        String error = this.checkArgs(op, path, args);
        if (error != null) {
            this.logger.error("Bad arguments to command: " + error);
            return "ERROR: BAD ARGS";
        }
        UriBuilder builder = UriBuilder.fromPath(this.url).path(path).queryParam("op", op.op);
        if (args != null) {
            for (Arg a : args) {
                builder = builder.queryParam(a.key, a.value);
            }
        }
        URI uri = builder.build(new Object[0]);
        URL hdfsUrl = uri.toURL();
        HttpURLConnection con = (HttpURLConnection)hdfsUrl.openConnection();
        if (op.cmd == HttpType.GET) {
            con.setRequestMethod("GET");
            int responseCode = con.getResponseCode();
            this.logger.info("Sending 'GET' request to URL : " + hdfsUrl);
            this.logger.info("Response Code : " + responseCode);
            StringBuffer response = new StringBuffer();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                String inputLine;
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
            }
            return response.toString();
        }
        return null;
    }

    public class Arg {
        public String key;
        public String value;

        public Arg(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }

    public class Op {
        public String op;
        public HttpType cmd;
        public int minArgs;

        public Op(String op, HttpType cmd, int minArgs) {
            this.op = op;
            this.cmd = cmd;
            this.minArgs = minArgs;
        }
    }

    public static enum HttpType {
        GET,
        PUT;

    }
}

