/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis;

import com.google.api.client.util.SecurityUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class GoogleUtils {
    public static final String VERSION = "1.30.3".toString();
    public static final Integer MAJOR_VERSION;
    public static final Integer MINOR_VERSION;
    public static final Integer BUGFIX_VERSION;
    @VisibleForTesting
    static final Pattern VERSION_PATTERN;
    static KeyStore certTrustStore;

    public static synchronized KeyStore getCertificateTrustStore() throws IOException, GeneralSecurityException {
        if (certTrustStore == null) {
            certTrustStore = SecurityUtils.getJavaKeyStore();
            InputStream keyStoreStream = GoogleUtils.class.getResourceAsStream("google.jks");
            SecurityUtils.loadKeyStore(certTrustStore, keyStoreStream, "notasecret");
        }
        return certTrustStore;
    }

    private GoogleUtils() {
    }

    static {
        VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)(-SNAPSHOT)?");
        Matcher versionMatcher = VERSION_PATTERN.matcher(VERSION);
        versionMatcher.find();
        MAJOR_VERSION = Integer.parseInt(versionMatcher.group(1));
        MINOR_VERSION = Integer.parseInt(versionMatcher.group(2));
        BUGFIX_VERSION = Integer.parseInt(versionMatcher.group(3));
    }
}

