/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.math.big.internal;

import ch.obermuhlner.math.big.BigRational;
import ch.obermuhlner.math.big.internal.PowerIterator;
import ch.obermuhlner.math.big.internal.PowerTwoNIterator;
import ch.obermuhlner.math.big.internal.SeriesCalculator;
import java.math.BigDecimal;
import java.math.MathContext;

public class CoshCalculator
extends SeriesCalculator {
    public static final CoshCalculator INSTANCE = new CoshCalculator();
    private int n = 0;
    private BigRational factorial2n = BigRational.ONE;

    private CoshCalculator() {
        super(true);
    }

    @Override
    protected BigRational getCurrentFactor() {
        return this.factorial2n.reciprocal();
    }

    @Override
    protected void calculateNextFactor() {
        ++this.n;
        this.factorial2n = this.factorial2n.multiply(2 * this.n - 1).multiply(2 * this.n);
    }

    @Override
    protected PowerIterator createPowerIterator(BigDecimal x, MathContext mathContext) {
        return new PowerTwoNIterator(x, mathContext);
    }
}

