/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph.impl;

import java.util.function.Supplier;
import org.apache.jena.graph.TransactionHandler;
import org.apache.jena.shared.Command;
import org.apache.jena.shared.JenaException;

public abstract class TransactionHandlerBase
implements TransactionHandler {
    @Override
    public Object executeInTransaction(Command c) {
        return this.calculate(() -> c.execute());
    }

    private void abort(Throwable e2) {
        try {
            this.abort();
        }
        catch (Throwable th) {
            e2.addSuppressed(th);
        }
    }

    @Override
    public void execute(Runnable action) {
        this.begin();
        try {
            action.run();
            this.commit();
        }
        catch (JenaException e2) {
            this.abort(e2);
            throw e2;
        }
        catch (Throwable e3) {
            this.abort(e3);
            throw new JenaException(e3);
        }
    }

    @Override
    public <T> T calculate(Supplier<T> action) {
        this.begin();
        try {
            T result = action.get();
            this.commit();
            return result;
        }
        catch (JenaException e2) {
            this.abort(e2);
            throw e2;
        }
        catch (Throwable e3) {
            this.abort(e3);
            throw new JenaException(e3);
        }
    }
}

