/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.other;

import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.util.iterator.ExtendedIterator;

public class GLib {
    public static Node nullAsAny(Node x) {
        return GLib.nullAsDft(x, Node.ANY);
    }

    public static Node nullAsDft(Node x, Node dft) {
        return x == null ? dft : x;
    }

    public static Iterator<Node> listSubjects(Graph graph) {
        ExtendedIterator<Triple> iter = graph.find(Node.ANY, Node.ANY, Node.ANY);
        return Iter.iter(iter).map(Triple::getSubject).distinct();
    }

    public static Iterator<Node> listPredicates(Graph graph) {
        ExtendedIterator<Triple> iter = graph.find(Node.ANY, Node.ANY, Node.ANY);
        return Iter.iter(iter).map(Triple::getPredicate).distinct();
    }

    public static Iterator<Node> listObjects(Graph graph) {
        ExtendedIterator<Triple> iter = graph.find(Node.ANY, Node.ANY, Node.ANY);
        return Iter.iter(iter).map(Triple::getObject).distinct();
    }

    public static Iter<Triple> quads2triples(Iterator<Quad> iter) {
        return Iter.iter(iter).map(Quad::asTriple);
    }

    public static Iterator<Node> quad2graphName(Iterator<Quad> iter) {
        return Iter.map(iter, Quad::getGraph);
    }

    public static Iterator<Node> quad2subject(Iterator<Quad> iter) {
        return Iter.map(iter, Quad::getSubject);
    }

    public static Iterator<Node> quad2predicate(Iterator<Quad> iter) {
        return Iter.map(iter, Quad::getPredicate);
    }

    public static Iterator<Node> quad2object(Iterator<Quad> iter) {
        return Iter.map(iter, Quad::getObject);
    }

    public static Iterator<Node> triple2subject(Iterator<Triple> iter) {
        return Iter.map(iter, Triple::getSubject);
    }

    public static Iterator<Node> triple2predicate(Iterator<Triple> iter) {
        return Iter.map(iter, Triple::getPredicate);
    }

    public static Iterator<Node> triple2object(Iterator<Triple> iter) {
        return Iter.map(iter, Triple::getObject);
    }
}

