/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.util.Iterator;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.util.iterator.ExtendedIterator;

public class StreamOps {
    public static void datasetToStream(DatasetGraph datasetGraph, StreamRDF stream) {
        stream.start();
        StreamOps.sendDatasetToStream(datasetGraph, stream);
        stream.finish();
    }

    public static void graphToStream(Graph graph, StreamRDF stream) {
        stream.start();
        StreamOps.sendGraphToStream(graph, stream);
        stream.finish();
    }

    public static void sendPrefixesToStream(PrefixMap prefixMap, StreamRDF stream) {
        prefixMap.forEach((p, u) -> stream.prefix((String)p, u.toString()));
    }

    public static void sendPrefixesToStream(PrefixMapping prefixMap, StreamRDF stream) {
        prefixMap.getNsPrefixMap().forEach(stream::prefix);
    }

    public static void sendTriplesQuadsToStream(DatasetGraph datasetGraph, StreamRDF stream) {
        StreamOps.sendDatasetToStream(datasetGraph, stream, null);
    }

    public static void sendDatasetToStream(DatasetGraph datasetGraph, StreamRDF stream) {
        PrefixMap prefixMap = PrefixMapFactory.create(datasetGraph.getDefaultGraph().getPrefixMapping());
        StreamOps.sendDatasetToStream(datasetGraph, stream, prefixMap);
    }

    public static void sendDatasetToStream(DatasetGraph datasetGraph, StreamRDF stream, PrefixMap prefixMap) {
        if (prefixMap != null) {
            StreamOps.sendPrefixesToStream(prefixMap, stream);
        }
        ExtendedIterator<Triple> iter1 = datasetGraph.getDefaultGraph().find(null, null, null);
        StreamOps.sendTriplesToStream(iter1, stream);
        Iterator<Quad> iter2 = datasetGraph.findNG(null, null, null, null);
        StreamOps.sendQuadsToStream(iter2, stream);
    }

    public static void sendGraphToStream(Graph graph, StreamRDF stream) {
        PrefixMap prefixMap = PrefixMapFactory.create(graph.getPrefixMapping());
        StreamOps.sendGraphToStream(graph, stream, prefixMap);
    }

    public static void sendGraphToStream(Graph graph, StreamRDF stream, PrefixMap prefixMap) {
        if (prefixMap != null) {
            StreamOps.sendPrefixesToStream(prefixMap, stream);
        }
        ExtendedIterator<Triple> iter = graph.find(null, null, null);
        StreamOps.sendTriplesToStream(iter, stream);
    }

    public static void sendTriplesToStream(Graph graph, StreamRDF stream) {
        StreamOps.sendGraphToStream(graph, stream, null);
    }

    public static void sendTriplesToStream(Iterator<Triple> iter, StreamRDF dest) {
        while (iter.hasNext()) {
            Triple t = iter.next();
            dest.triple(t);
        }
    }

    public static void sendQuadsToStream(DatasetGraph datasetGraph, StreamRDF stream) {
        Iterator<Quad> iter2 = datasetGraph.find(null, null, null, null);
        StreamOps.sendQuadsToStream(iter2, stream);
    }

    public static void sendQuadsToStream(Iterator<Quad> iter, StreamRDF dest) {
        while (iter.hasNext()) {
            Quad q = iter.next();
            dest.quad(q);
        }
    }
}

