/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.walker;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.op.Op0;
import org.apache.jena.sparql.algebra.op.Op1;
import org.apache.jena.sparql.algebra.op.Op2;
import org.apache.jena.sparql.algebra.op.OpAssign;
import org.apache.jena.sparql.algebra.op.OpExt;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpGroup;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpN;
import org.apache.jena.sparql.algebra.op.OpOrder;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.algebra.walker.OpVisitorByTypeAndExpr;
import org.apache.jena.sparql.algebra.walker.Walker;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprFunction0;
import org.apache.jena.sparql.expr.ExprFunction1;
import org.apache.jena.sparql.expr.ExprFunction2;
import org.apache.jena.sparql.expr.ExprFunction3;
import org.apache.jena.sparql.expr.ExprFunctionN;
import org.apache.jena.sparql.expr.ExprFunctionOp;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprNone;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.ExprVisitor;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.Aggregator;

public class ApplyTransformVisitor
implements OpVisitorByTypeAndExpr,
ExprVisitor {
    private final Transform opTransform;
    private final ExprTransform exprTransform;
    protected final boolean visitService;
    private final Deque<Op> opStack = new ArrayDeque<Op>();
    private final Deque<Expr> exprStack = new ArrayDeque<Expr>();
    private final OpVisitor beforeVisitor;
    private final OpVisitor afterVisitor;

    public ApplyTransformVisitor(Transform opTransform, ExprTransform exprTransform, boolean visitService, OpVisitor before, OpVisitor after) {
        this.opTransform = opTransform;
        this.exprTransform = exprTransform;
        this.beforeVisitor = before;
        this.afterVisitor = after;
        this.visitService = visitService;
    }

    public final Op opResult() {
        return this.pop(this.opStack);
    }

    final Expr exprResult() {
        return this.pop(this.exprStack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expr transform(Expr expr) {
        int x1 = this.opStack.size();
        int x2 = this.exprStack.size();
        try {
            Expr expr2 = Walker.transform(expr, this, this.beforeVisitor, this.afterVisitor);
            return expr2;
        }
        finally {
            int y1 = this.opStack.size();
            int y2 = this.exprStack.size();
            if (x1 != y1) {
                System.err.println("Misaligned opStack");
            }
            if (x2 != y2) {
                System.err.println("Misaligned exprStack");
            }
        }
    }

    protected ExprList transform(ExprList exprList) {
        ExprList exprList2 = new ExprList();
        exprList.forEach(e2 -> exprList2.add(this.transform((Expr)e2)));
        return exprList2;
    }

    protected List<SortCondition> transform(List<SortCondition> conditions) {
        ArrayList<SortCondition> conditions2 = new ArrayList<SortCondition>();
        boolean changed = false;
        for (SortCondition sc : conditions) {
            Expr e2 = sc.getExpression();
            Expr e22 = this.transform(e2);
            conditions2.add(new SortCondition(e22, sc.getDirection()));
            if (e2 == e22) continue;
            changed = true;
        }
        if (changed) {
            return conditions2;
        }
        return conditions;
    }

    @Override
    public void visit(OpOrder opOrder) {
        List<SortCondition> conditions = opOrder.getConditions();
        ArrayList<SortCondition> conditions2 = new ArrayList<SortCondition>();
        boolean changed = false;
        for (SortCondition sc : conditions) {
            Expr e2 = sc.getExpression();
            Expr e22 = this.transform(e2);
            conditions2.add(new SortCondition(e22, sc.getDirection()));
            if (e2 == e22) continue;
            changed = true;
        }
        OpOrder x = opOrder;
        if (changed) {
            x = new OpOrder(opOrder.getSubOp(), conditions2);
        }
        this.visit1(x);
    }

    @Override
    public void visit(OpAssign opAssign) {
        VarExprList varExpr = opAssign.getVarExprList();
        VarExprList varExpr2 = this.collect(varExpr);
        OpAssign opAssign2 = opAssign;
        if (varExpr != varExpr2) {
            opAssign2 = OpAssign.create(opAssign.getSubOp(), varExpr2);
        }
        this.visit1(opAssign2);
    }

    @Override
    public void visit(OpExtend opExtend) {
        VarExprList varExpr = opExtend.getVarExprList();
        VarExprList varExpr2 = this.collect(varExpr);
        OpExtend opExtend2 = opExtend;
        if (varExpr != varExpr2) {
            opExtend2 = OpExtend.create(opExtend.getSubOp(), varExpr2);
        }
        this.visit1(opExtend2);
    }

    private VarExprList collect(VarExprList varExprList) {
        if (varExprList == null) {
            return varExprList;
        }
        List<Var> vars = varExprList.getVars();
        VarExprList varExpr2 = new VarExprList();
        List<Expr> x = this.collect(vars.size());
        boolean changed = false;
        for (int i = 0; i < vars.size(); ++i) {
            Var v = vars.get(i);
            Expr e2 = x.get(i);
            Expr e3 = varExpr2.getExpr(v);
            if (e3 != e2) {
                changed = true;
            }
            if (e2 == null) {
                varExpr2.add(v);
                continue;
            }
            varExpr2.add(v, e2);
        }
        return changed ? varExpr2 : varExprList;
    }

    private ExprList collect(ExprList exprList) {
        if (exprList == null) {
            return null;
        }
        List<Expr> x = this.collect(exprList.size());
        boolean changed = false;
        for (int i = 0; i < x.size(); ++i) {
            if (x.get(i) == exprList.get(i)) continue;
            changed = true;
            break;
        }
        if (!changed) {
            return exprList;
        }
        return new ExprList(x);
    }

    private ExprList collect(List<Expr> exprList) {
        if (exprList == null) {
            return null;
        }
        return new ExprList(this.collect(exprList.size()));
    }

    private List<Expr> collect(int N) {
        ArrayList<Expr> x = new ArrayList<Expr>(N);
        for (int i = N - 1; i >= 0; --i) {
            Expr e2 = this.pop(this.exprStack);
            if (e2 == Expr.NONE) {
                e2 = null;
            }
            x.add(0, e2);
        }
        return x;
    }

    @Override
    public void visit(OpGroup opGroup) {
        List<ExprAggregator> aggs;
        VarExprList varExpr2;
        boolean changed = false;
        VarExprList varExpr = opGroup.getGroupVars();
        if (varExpr != (varExpr2 = this.collect(varExpr))) {
            changed = true;
        }
        List<ExprAggregator> aggs2 = aggs = opGroup.getAggregators();
        aggs2 = new ArrayList<ExprAggregator>();
        for (ExprAggregator agg : aggs) {
            ExprList e2;
            Expr eVar2;
            Aggregator aggregator = agg.getAggregator();
            Var v = agg.getVar();
            ExprVar eVar = agg.getAggVar();
            if (eVar != (eVar2 = this.transform(eVar))) {
                changed = true;
            }
            ExprList e22 = e2 = aggregator.getExprList();
            if (e2 != null) {
                e22 = this.transform(e2);
            }
            if (e2 != e22) {
                changed = true;
            }
            Aggregator a2 = aggregator.copy(e22);
            aggs2.add(new ExprAggregator(eVar2.asVar(), a2));
        }
        OpGroup opGroup2 = opGroup;
        if (changed) {
            opGroup2 = OpGroup.create(opGroup.getSubOp(), varExpr2, aggs2);
        }
        this.visit1(opGroup2);
    }

    @Override
    public void visit0(Op0 op) {
        this.push(this.opStack, op.apply(this.opTransform));
    }

    @Override
    public void visit1(Op1 op) {
        Op subOp = null;
        if (op.getSubOp() != null) {
            subOp = this.pop(this.opStack);
        }
        this.push(this.opStack, op.apply(this.opTransform, subOp));
    }

    @Override
    public void visit2(Op2 op) {
        Op left = null;
        Op right = null;
        if (op.getRight() != null) {
            right = this.pop(this.opStack);
        }
        if (op.getLeft() != null) {
            left = this.pop(this.opStack);
        }
        Op opX = op.apply(this.opTransform, left, right);
        this.push(this.opStack, opX);
    }

    @Override
    public void visitN(OpN op) {
        ArrayList<Op> x = new ArrayList<Op>(op.size());
        Iterator<Op> iter = op.iterator();
        while (iter.hasNext()) {
            Op sub = iter.next();
            Op r = this.pop(this.opStack);
            if (r == null) continue;
            x.add(0, r);
        }
        Op opX = op.apply(this.opTransform, x);
        this.push(this.opStack, opX);
    }

    private void dump(String label) {
        System.out.println(label);
        String x = this.opStack.toString().replace('\n', ' ').replaceAll("  +", " ");
        String y = this.exprStack.toString().replace('\n', ' ').replaceAll("  +", " ");
        System.out.println("    O:" + x);
        System.out.println("    E:" + y);
    }

    @Override
    public void visit(OpFilter opFilter) {
        ExprList ex;
        Op subOp = null;
        if (opFilter.getSubOp() != null) {
            subOp = this.pop(this.opStack);
        }
        if ((ex = opFilter.getExprs()) == null || ex.isEmpty()) {
            this.push(this.opStack, opFilter.apply(this.opTransform, subOp));
            return;
        }
        ExprList ex2 = this.collect(ex);
        OpFilter f = opFilter;
        if (ex != ex2 || opFilter.getSubOp() != subOp) {
            f = OpFilter.filterAlways(ex2, subOp);
            subOp = f.getSubOp();
        }
        this.push(this.opStack, f.apply(this.opTransform, subOp));
    }

    @Override
    public void visit(OpLeftJoin op) {
        Op left = null;
        Op right = null;
        if (op.getRight() != null) {
            right = this.pop(this.opStack);
        }
        if (op.getLeft() != null) {
            left = this.pop(this.opStack);
        }
        ExprList exprs = op.getExprs();
        ExprList exprs2 = this.collect(exprs);
        OpLeftJoin x = op;
        if (exprs != exprs2) {
            x = OpLeftJoin.createLeftJoin(left, right, exprs2);
        }
        Op opX = x.apply(this.opTransform, left, right);
        this.push(this.opStack, opX);
    }

    @Override
    public void visit(OpService op) {
        if (!this.visitService) {
            this.push(this.opStack, op);
            return;
        }
        OpVisitorByTypeAndExpr.super.visit(op);
    }

    @Override
    public void visitExt(OpExt op) {
        this.push(this.opStack, this.opTransform.transform(op));
    }

    @Override
    public void visitExpr(ExprList exprs) {
        throw new InternalErrorException("Didn't expect as call to ApplyTransformVisit.visitExpr");
    }

    @Override
    public void visitVarExpr(VarExprList exprVarExprList) {
        throw new InternalErrorException("Didn't expect as call to ApplyTransformVisit.visitVarExpr");
    }

    @Override
    public void visit(ExprFunction0 func) {
        Expr e2 = func.apply(this.exprTransform);
        this.push(this.exprStack, e2);
    }

    @Override
    public void visit(ExprFunction1 func) {
        Expr e1 = this.pop(this.exprStack);
        Expr e2 = func.apply(this.exprTransform, e1);
        this.push(this.exprStack, e2);
    }

    @Override
    public void visit(ExprFunction2 func) {
        Expr e2 = this.pop(this.exprStack);
        Expr e1 = this.pop(this.exprStack);
        Expr e3 = func.apply(this.exprTransform, e1, e2);
        this.push(this.exprStack, e3);
    }

    @Override
    public void visit(ExprFunction3 func) {
        Expr e3 = this.pop(this.exprStack);
        Expr e2 = this.pop(this.exprStack);
        Expr e1 = this.pop(this.exprStack);
        Expr e4 = func.apply(this.exprTransform, e1, e2, e3);
        this.push(this.exprStack, e4);
    }

    @Override
    public void visit(ExprFunctionN func) {
        ExprList x = this.collect(func.getArgs());
        Expr e2 = func.apply(this.exprTransform, x);
        this.push(this.exprStack, e2);
    }

    @Override
    public void visit(ExprFunctionOp funcOp) {
        ExprList x = null;
        if (funcOp.getArgs() != null) {
            x = this.collect(funcOp.getArgs());
        }
        Op op = this.pop(this.opStack);
        Expr e2 = funcOp.apply(this.exprTransform, x, op);
        this.push(this.exprStack, e2);
    }

    @Override
    public void visit(NodeValue nv) {
        Expr e2 = nv.apply(this.exprTransform);
        this.push(this.exprStack, e2);
    }

    @Override
    public void visit(ExprVar var) {
        Expr e2 = var.apply(this.exprTransform);
        this.push(this.exprStack, e2);
    }

    @Override
    public void visit(ExprAggregator eAgg) {
        Expr e2 = eAgg.apply(this.exprTransform);
        this.push(this.exprStack, e2);
    }

    @Override
    public void visit(ExprNone e2) {
        this.push(this.exprStack, e2);
    }

    private <T> void push(Deque<T> stack, T value) {
        if (value == null) {
            Log.warn(ApplyTransformVisitor.class, "Pushing null onto the " + this.stackLabel(stack) + " stack");
        }
        stack.push(value);
    }

    private <T> T pop(Deque<T> stack) {
        try {
            T v = stack.pop();
            if (v == null) {
                Log.warn(ApplyTransformVisitor.class, "Pop null from the " + this.stackLabel(stack) + " stack");
            }
            return v;
        }
        catch (NoSuchElementException ex) {
            throw new RuntimeException();
        }
    }

    private String stackLabel(Deque<?> stack) {
        if (stack == this.opStack) {
            return "Op";
        }
        if (stack == this.exprStack) {
            return "Expr";
        }
        return "<other>";
    }
}

