/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.main;

import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.iterator.QueryIterBlockTriples;
import org.apache.jena.sparql.engine.main.StageGenerator;
import org.apache.jena.sparql.engine.main.StageGeneratorGeneric;
import org.apache.jena.sparql.util.Context;

public class StageBuilder {
    private static StageGenerator defaultStageGenerator = new StageGeneratorGeneric();
    public static StageGenerator executeInline = new StageGenerator(){

        @Override
        public QueryIterator execute(BasicPattern pattern, QueryIterator input, ExecutionContext execCxt) {
            return QueryIterBlockTriples.create(input, pattern, execCxt);
        }
    };

    public static void setGenerator(Context context, StageGenerator builder) {
        if (ARQ.stageGenerator == null) {
            Log.warn(StageBuilder.class, "ARQ.stageGenerator = null");
        }
        context.set(ARQ.stageGenerator, builder);
    }

    public static StageGenerator getGenerator(Context context) {
        if (context == null) {
            return null;
        }
        return (StageGenerator)context.get(ARQ.stageGenerator);
    }

    public static StageGenerator getGenerator() {
        return StageBuilder.getGenerator(ARQ.getContext());
    }

    public static StageGenerator standardGenerator() {
        return defaultStageGenerator;
    }

    public static StageGenerator chooseStageGenerator(Context context) {
        StageGenerator gen = StageBuilder.getGenerator(context);
        if (gen == null) {
            gen = new StageGeneratorGeneric();
        }
        return gen;
    }
}

