/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.helium;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.helium.ApplicationLoader;
import org.apache.zeppelin.helium.HeliumApplicationFactory;
import org.apache.zeppelin.helium.HeliumBundleFactory;
import org.apache.zeppelin.helium.HeliumConf;
import org.apache.zeppelin.helium.HeliumLocalRegistry;
import org.apache.zeppelin.helium.HeliumOnlineRegistry;
import org.apache.zeppelin.helium.HeliumPackage;
import org.apache.zeppelin.helium.HeliumPackageSearchResult;
import org.apache.zeppelin.helium.HeliumPackageSuggestion;
import org.apache.zeppelin.helium.HeliumRegistry;
import org.apache.zeppelin.helium.HeliumType;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterNotFoundException;
import org.apache.zeppelin.interpreter.InterpreterSettingManager;
import org.apache.zeppelin.interpreter.ManagedInterpreterGroup;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcess;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.resource.DistributedResourcePool;
import org.apache.zeppelin.resource.Resource;
import org.apache.zeppelin.resource.ResourcePool;
import org.apache.zeppelin.resource.ResourceSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Helium {
    private Logger logger = LoggerFactory.getLogger(Helium.class);
    private List<HeliumRegistry> registry = new LinkedList<HeliumRegistry>();
    private HeliumConf heliumConf;
    private Map<String, List<HeliumPackageSearchResult>> allPackages = new HashMap<String, List<HeliumPackageSearchResult>>();
    private final String heliumConfPath;
    private final String registryPaths;
    private final File registryCacheDir;
    private final HeliumBundleFactory bundleFactory;
    private final HeliumApplicationFactory applicationFactory;
    private final InterpreterSettingManager interpreterSettingManager;

    @Inject
    public Helium(ZeppelinConfiguration conf, HeliumBundleFactory heliumBundleFactory, HeliumApplicationFactory heliumApplicationFactory, InterpreterSettingManager interpreterSettingManager) throws IOException {
        this(conf.getHeliumConfPath(), conf.getHeliumRegistry(), new File(conf.getAbsoluteDir(ZeppelinConfiguration.ConfVars.ZEPPELIN_DEP_LOCALREPO), "helium-registry-cache"), heliumBundleFactory, heliumApplicationFactory, interpreterSettingManager);
    }

    @VisibleForTesting
    public Helium(String heliumConfPath, String registryPaths, File registryCacheDir, HeliumBundleFactory bundleFactory, HeliumApplicationFactory applicationFactory, InterpreterSettingManager interpreterSettingManager) throws IOException {
        this.heliumConfPath = heliumConfPath;
        this.registryPaths = registryPaths;
        this.registryCacheDir = registryCacheDir;
        this.bundleFactory = bundleFactory;
        this.applicationFactory = applicationFactory;
        this.interpreterSettingManager = interpreterSettingManager;
        this.heliumConf = this.loadConf(heliumConfPath);
        this.allPackages = this.getAllPackageInfo();
        try {
            bundleFactory.buildAllPackages(this.getBundlePackagesToBundle());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRegistry(HeliumRegistry registry) {
        List<HeliumRegistry> list = this.registry;
        synchronized (list) {
            this.registry.add(registry);
        }
    }

    public void clear() {
        this.registry.clear();
        this.heliumConf = new HeliumConf();
        this.allPackages = new HashMap<String, List<HeliumPackageSearchResult>>();
    }

    public HeliumApplicationFactory getApplicationFactory() {
        return this.applicationFactory;
    }

    private synchronized HeliumConf loadConf(String path) throws IOException {
        File heliumConfFile;
        if (this.registryPaths != null && !this.registryPaths.isEmpty()) {
            String[] paths;
            for (String uri : paths = this.registryPaths.split(",")) {
                if (uri.startsWith("http://") || uri.startsWith("https://")) {
                    this.logger.info("Add helium online registry {}", (Object)uri);
                    this.registry.add(new HeliumOnlineRegistry(uri, uri, this.registryCacheDir));
                    continue;
                }
                this.logger.info("Add helium local registry {}", (Object)uri);
                this.registry.add(new HeliumLocalRegistry(uri, uri));
            }
        }
        if (!(heliumConfFile = new File(path)).isFile()) {
            this.logger.warn("{} does not exists", (Object)path);
            return new HeliumConf();
        }
        String jsonString = FileUtils.readFileToString((File)heliumConfFile);
        return HeliumConf.fromJson(jsonString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveConfig() throws IOException {
        String jsonString;
        List<HeliumRegistry> list = this.registry;
        synchronized (list) {
            this.clearNotExistsPackages();
            jsonString = this.heliumConf.toJson();
        }
        File heliumConfFile = new File(this.heliumConfPath);
        if (!heliumConfFile.exists()) {
            heliumConfFile.createNewFile();
        }
        FileUtils.writeStringToFile((File)heliumConfFile, (String)jsonString);
    }

    private void clearNotExistsPackages() {
        List<String> packageOrder = this.heliumConf.getBundleDisplayOrder();
        LinkedList<String> clearedOrder = new LinkedList<String>();
        for (String pkgName : packageOrder) {
            if (!this.allPackages.containsKey(pkgName)) continue;
            clearedOrder.add(pkgName);
        }
        this.heliumConf.setBundleDisplayOrder(clearedOrder);
        Map<String, String> enabledPackages = this.heliumConf.getEnabledPackages();
        for (String pkgName : enabledPackages.keySet()) {
            if (this.allPackages.containsKey(pkgName)) continue;
            this.heliumConf.disablePackage(pkgName);
        }
    }

    public Map<String, List<HeliumPackageSearchResult>> getAllPackageInfo() {
        return this.getAllPackageInfo(true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<HeliumPackageSearchResult>> getAllPackageInfo(boolean refresh, String packageName) {
        Map<String, String> enabledPackageInfo = this.heliumConf.getEnabledPackages();
        List<HeliumRegistry> list = this.registry;
        synchronized (list) {
            if (refresh || !this.allPackages.containsKey(packageName)) {
                for (HeliumRegistry r : this.registry) {
                    try {
                        for (HeliumPackage pkg : r.getAll()) {
                            String name = pkg.getName();
                            if (!StringUtils.isEmpty((CharSequence)packageName) && !name.equals(packageName)) continue;
                            if (this.allPackages.containsKey(name)) {
                                this.allPackages.remove(name);
                            }
                            this.allPackages.put(name, new LinkedList());
                            boolean enabled = enabledPackageInfo.containsKey(pkg.getName());
                            this.allPackages.get(name).add(new HeliumPackageSearchResult(r.name(), pkg, enabled));
                        }
                    }
                    catch (IOException e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            } else {
                for (String name : this.allPackages.keySet()) {
                    if (!StringUtils.isEmpty((CharSequence)packageName) && !name.equals(packageName)) continue;
                    List<HeliumPackageSearchResult> pkgs = this.allPackages.get(name);
                    LinkedList<HeliumPackageSearchResult> newResults = new LinkedList<HeliumPackageSearchResult>();
                    for (HeliumPackageSearchResult pkg : pkgs) {
                        boolean enabled = enabledPackageInfo.containsKey(pkg.getPkg().getName());
                        newResults.add(new HeliumPackageSearchResult(pkg.getRegistry(), pkg.getPkg(), enabled));
                    }
                    this.allPackages.put(name, newResults);
                }
            }
            for (String name : this.allPackages.keySet()) {
                List<HeliumPackageSearchResult> packages = this.allPackages.get(name);
                Collections.sort(packages, new Comparator<HeliumPackageSearchResult>(){

                    @Override
                    public int compare(HeliumPackageSearchResult o1, HeliumPackageSearchResult o2) {
                        return o2.getPkg().getArtifact().compareTo(o1.getPkg().getArtifact());
                    }
                });
            }
            return this.allPackages;
        }
    }

    public List<HeliumPackageSearchResult> getAllEnabledPackages() {
        Map<String, String> enabledInfo = this.heliumConf.getEnabledPackages();
        ArrayList<HeliumPackageSearchResult> enabledPackages = new ArrayList<HeliumPackageSearchResult>();
        block0: for (List<HeliumPackageSearchResult> versionedPackages : this.allPackages.values()) {
            for (HeliumPackageSearchResult psr : versionedPackages) {
                if (!enabledInfo.containsKey(psr.getPkg().getName())) continue;
                enabledPackages.add(psr);
                continue block0;
            }
        }
        return enabledPackages;
    }

    public List<HeliumPackageSearchResult> getSinglePackageInfo(String packageName) {
        Map<String, List<HeliumPackageSearchResult>> result = this.getAllPackageInfo(true, packageName);
        if (!result.containsKey(packageName)) {
            return new ArrayList<HeliumPackageSearchResult>();
        }
        return result.get(packageName);
    }

    private HeliumPackageSearchResult getEnabledPackageInfo(String packageName) {
        List<HeliumPackageSearchResult> packages = this.allPackages.get(packageName);
        for (HeliumPackageSearchResult pkgSearchResult : packages) {
            if (!pkgSearchResult.isEnabled()) continue;
            return pkgSearchResult;
        }
        return null;
    }

    private HeliumPackageSearchResult getPackageInfo(String pkgName, String artifact) {
        Map<String, List<HeliumPackageSearchResult>> infos = this.getAllPackageInfo(false, pkgName);
        List<HeliumPackageSearchResult> packages = infos.get(pkgName);
        if (StringUtils.isBlank((CharSequence)artifact)) {
            return packages.get(0);
        }
        for (HeliumPackageSearchResult pkg : packages) {
            if (!pkg.getPkg().getArtifact().equals(artifact)) continue;
            return pkg;
        }
        return null;
    }

    public File getBundle(HeliumPackage pkg, boolean rebuild) throws IOException {
        return this.bundleFactory.buildPackage(pkg, rebuild, true);
    }

    public boolean enable(String name, String artifact) throws IOException {
        List<String> currentDisplayOrder;
        HeliumPackageSearchResult pkgInfo = this.getPackageInfo(name, artifact);
        if (pkgInfo == null) {
            this.logger.info("Package {} not found", (Object)name);
            return false;
        }
        if (HeliumPackage.isBundleType((HeliumType)pkgInfo.getPkg().getType())) {
            this.bundleFactory.buildPackage(pkgInfo.getPkg(), true, true);
        }
        this.heliumConf.enablePackage(name, artifact);
        if (pkgInfo.getPkg().getType() == HeliumType.VISUALIZATION && !(currentDisplayOrder = this.heliumConf.getBundleDisplayOrder()).contains(name)) {
            currentDisplayOrder.add(name);
        }
        this.saveConfig();
        return true;
    }

    public boolean disable(String name) throws IOException {
        List<String> currentDisplayOrder;
        String pkg = this.heliumConf.getEnabledPackages().get(name);
        if (pkg == null) {
            this.logger.info("Package {} not found", (Object)name);
            return false;
        }
        HeliumPackageSearchResult pkgInfo = this.getPackageInfo(name, pkg);
        this.heliumConf.disablePackage(name);
        if (pkgInfo.getPkg().getType() == HeliumType.VISUALIZATION && (currentDisplayOrder = this.heliumConf.getBundleDisplayOrder()).contains(name)) {
            currentDisplayOrder.remove(name);
        }
        this.saveConfig();
        return true;
    }

    public void updatePackageConfig(String artifact, Map<String, Object> pkgConfig) throws IOException {
        this.heliumConf.updatePackageConfig(artifact, pkgConfig);
        this.saveConfig();
    }

    public Map<String, Map<String, Object>> getAllPackageConfig() {
        return this.heliumConf.getAllPackageConfigs();
    }

    private Map<String, Object> getPackagePersistedConfig(String artifact) {
        return this.heliumConf.getPackagePersistedConfig(artifact);
    }

    public HeliumPackageSuggestion suggestApp(Paragraph paragraph) {
        HeliumPackageSuggestion suggestion = new HeliumPackageSuggestion();
        Interpreter intp = null;
        try {
            intp = paragraph.getBindedInterpreter();
        }
        catch (InterpreterNotFoundException e) {
            return suggestion;
        }
        ResourcePool resourcePool = intp.getInterpreterGroup().getResourcePool();
        ResourceSet allResources = resourcePool != null ? (resourcePool instanceof DistributedResourcePool ? ((DistributedResourcePool)resourcePool).getAll(true) : resourcePool.getAll()) : this.interpreterSettingManager.getAllResources();
        block2: for (List<HeliumPackageSearchResult> pkgs : this.allPackages.values()) {
            for (HeliumPackageSearchResult pkg : pkgs) {
                ResourceSet resources;
                if (pkg.getPkg().getType() != HeliumType.APPLICATION || !pkg.isEnabled() || (resources = ApplicationLoader.findRequiredResourceSet((String[][])pkg.getPkg().getResources(), (String)paragraph.getNote().getId(), (String)paragraph.getId(), (ResourceSet)allResources)) == null) continue;
                suggestion.addAvailablePackage(pkg);
                continue block2;
            }
        }
        suggestion.sort();
        return suggestion;
    }

    public List<HeliumPackage> getBundlePackagesToBundle() {
        List<String> visOrder = this.heliumConf.getBundleDisplayOrder();
        HashSet<HeliumPackage> orderedBundlePackages = new HashSet<HeliumPackage>();
        LinkedList<HeliumPackage> output = new LinkedList<HeliumPackage>();
        block0: for (String string : visOrder) {
            List<HeliumPackageSearchResult> versions = this.allPackages.get(string);
            if (versions == null) continue;
            for (HeliumPackageSearchResult pkgInfo : versions) {
                if (!this.canBundle(pkgInfo)) continue;
                orderedBundlePackages.add(pkgInfo.getPkg());
                continue block0;
            }
        }
        block2: for (List list : this.allPackages.values()) {
            for (HeliumPackageSearchResult pkgInfo : list) {
                if (!this.canBundle(pkgInfo)) continue;
                orderedBundlePackages.add(pkgInfo.getPkg());
                continue block2;
            }
        }
        output.addAll(orderedBundlePackages);
        return output;
    }

    private boolean canBundle(HeliumPackageSearchResult pkgInfo) {
        return pkgInfo.isEnabled() && HeliumPackage.isBundleType((HeliumType)pkgInfo.getPkg().getType());
    }

    public List<String> getVisualizationPackageOrder() {
        return this.heliumConf.getBundleDisplayOrder();
    }

    public void setVisualizationPackageOrder(List<String> orderedPackageList) throws IOException {
        this.heliumConf.setBundleDisplayOrder(orderedPackageList);
        this.saveConfig();
    }

    public Map<String, Map<String, Object>> getSpellConfig(String packageName) {
        HeliumPackageSearchResult result = this.getEnabledPackageInfo(packageName);
        if (result == null) {
            return null;
        }
        HeliumPackage enabledPackage = result.getPkg();
        Map configSpec = enabledPackage.getConfig();
        Map<String, Object> configPersisted = this.getPackagePersistedConfig(enabledPackage.getArtifact());
        return Helium.createMixedConfig(configPersisted, configSpec);
    }

    public Map<String, Map<String, Object>> getPackageConfig(String pkgName, String artifact) {
        HeliumPackageSearchResult result = this.getPackageInfo(pkgName, artifact);
        if (result == null) {
            return null;
        }
        HeliumPackage requestedPackage = result.getPkg();
        Map configSpec = requestedPackage.getConfig();
        Map<String, Object> configPersisted = this.getPackagePersistedConfig(artifact);
        return Helium.createMixedConfig(configPersisted, configSpec);
    }

    private static Map<String, Map<String, Object>> createMixedConfig(Map<String, Object> persisted, Map<String, Object> spec) {
        HashMap<String, Map<String, Object>> mixed = new HashMap<String, Map<String, Object>>();
        mixed.put("confPersisted", persisted);
        mixed.put("confSpec", spec);
        return mixed;
    }

    public ResourceSet getAllResources() {
        return this.getAllResourcesExcept(null);
    }

    private ResourceSet getAllResourcesExcept(String interpreterGroupExcludsion) {
        ResourceSet resourceSet = new ResourceSet();
        for (ManagedInterpreterGroup intpGroup : this.interpreterSettingManager.getAllInterpreterGroup()) {
            if (interpreterGroupExcludsion != null && intpGroup.getId().equals(interpreterGroupExcludsion)) continue;
            RemoteInterpreterProcess remoteInterpreterProcess = intpGroup.getRemoteInterpreterProcess();
            if (remoteInterpreterProcess == null) {
                ResourcePool localPool = intpGroup.getResourcePool();
                if (localPool == null) continue;
                resourceSet.addAll((Collection)localPool.getAll());
                continue;
            }
            if (!remoteInterpreterProcess.isRunning()) continue;
            List resourceList = (List)remoteInterpreterProcess.callRemoteFunction(client -> client.resourcePoolGetAll());
            Gson gson = new Gson();
            for (String res : resourceList) {
                resourceSet.add((Object)((Resource)gson.fromJson(res, Resource.class)));
            }
        }
        return resourceSet;
    }
}

