/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfInterpreter
extends Interpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfInterpreter.class);
    protected String sessionId;
    protected String interpreterGroupId;
    protected InterpreterSetting interpreterSetting;

    public ConfInterpreter(Properties properties, String sessionId, String interpreterGroupId, InterpreterSetting interpreterSetting) {
        super(properties);
        this.sessionId = sessionId;
        this.interpreterGroupId = interpreterGroupId;
        this.interpreterSetting = interpreterSetting;
    }

    public void open() throws InterpreterException {
    }

    public void close() throws InterpreterException {
    }

    public InterpreterResult interpret(String st, InterpreterContext context) throws InterpreterException {
        try {
            Properties finalProperties = new Properties();
            finalProperties.putAll((Map<?, ?>)this.getProperties());
            Properties newProperties = new Properties();
            newProperties.load(new StringReader(st));
            for (String key : newProperties.stringPropertyNames()) {
                finalProperties.put(key.trim(), newProperties.getProperty(key).trim());
            }
            LOGGER.debug("Properties for InterpreterGroup: {} is {}", (Object)this.interpreterGroupId, (Object)finalProperties);
            this.interpreterSetting.setInterpreterGroupProperties(this.interpreterGroupId, finalProperties);
            return new InterpreterResult(InterpreterResult.Code.SUCCESS);
        }
        catch (IOException e) {
            LOGGER.error("Fail to update interpreter setting", (Throwable)e);
            return new InterpreterResult(InterpreterResult.Code.ERROR, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public void cancel(InterpreterContext context) throws InterpreterException {
    }

    public Interpreter.FormType getFormType() throws InterpreterException {
        return Interpreter.FormType.NATIVE;
    }

    public int getProgress(InterpreterContext context) throws InterpreterException {
        return 0;
    }
}

