/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ParagraphRuntimeInfo {
    private String propertyName;
    private String label;
    private String tooltip;
    private String group;
    private List<Object> values;
    private String interpreterSettingId;

    public ParagraphRuntimeInfo(String propertyName, String label, String tooltip, String group, String intpSettingId) {
        if (intpSettingId == null) {
            throw new IllegalArgumentException("Interpreter setting Id cannot be null");
        }
        this.propertyName = propertyName;
        this.label = label;
        this.tooltip = tooltip;
        this.group = group;
        this.interpreterSettingId = intpSettingId;
        this.values = new ArrayList<Object>();
    }

    public void addValue(Map<String, String> mapValue) {
        this.values.add(mapValue);
    }

    @VisibleForTesting
    public List<Object> getValue() {
        return this.values;
    }

    public String getInterpreterSettingId() {
        return this.interpreterSettingId;
    }
}

