/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.scheduler;

import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.notebook.Notebook;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CronJob
implements Job {
    private static final Logger LOGGER = LoggerFactory.getLogger(CronJob.class);
    private static final String RESULT_SUCCEEDED = "succeeded";
    private static final String RESULT_FAILED = "failed";

    public void execute(JobExecutionContext context) {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        String noteId = jobDataMap.getString("noteId");
        Notebook notebook = (Notebook)jobDataMap.get((Object)"notebook");
        try {
            notebook.processNote(noteId, note -> {
                if (note == null) {
                    LOGGER.warn("Failed to run CronJob of note: {} because there's no such note", (Object)noteId);
                    context.setResult((Object)RESULT_FAILED);
                    return null;
                }
                String cronExecutingUser = (String)note.getConfig().get("cronExecutingUser");
                String cronExecutingRoles = (String)note.getConfig().get("cronExecutingRoles");
                if (null == cronExecutingUser) {
                    cronExecutingUser = "anonymous";
                }
                AuthenticationInfo authenticationInfo = new AuthenticationInfo(cronExecutingUser, StringUtils.isEmpty((CharSequence)cronExecutingRoles) ? null : cronExecutingRoles, null);
                try {
                    note.runAll(authenticationInfo, true, true, new HashMap<String, Object>());
                    context.setResult((Object)RESULT_SUCCEEDED);
                }
                catch (Exception e) {
                    context.setResult((Object)RESULT_FAILED);
                    LOGGER.warn("Fail to run note: {}", (Object)note.getName(), (Object)e);
                }
                return null;
            });
        }
        catch (IOException e) {
            LOGGER.warn("Failed to run CronJob of note: {} because fail to get it", (Object)noteId, (Object)e);
            context.setResult((Object)RESULT_FAILED);
        }
    }
}

