/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.search;

import java.util.List;
import java.util.Map;
import javax.annotation.PreDestroy;
import org.apache.zeppelin.notebook.NoteEventAsyncListener;

public abstract class SearchService
extends NoteEventAsyncListener {
    public SearchService(String name) {
        super(name);
    }

    public abstract List<Map<String, String>> query(String var1);

    public abstract void updateNoteIndex(String var1);

    public abstract void updateParagraphIndex(String var1, String var2);

    public abstract void addNoteIndex(String var1);

    public abstract void addParagraphIndex(String var1, String var2);

    public abstract void deleteNoteIndex(String var1);

    public abstract void deleteParagraphIndex(String var1, String var2);

    @Override
    @PreDestroy
    public void close() {
        super.close();
    }

    @Override
    public void handleNoteCreateEvent(NoteEventAsyncListener.NoteCreateEvent noteCreateEvent) {
        this.addNoteIndex(noteCreateEvent.getNoteId());
    }

    @Override
    public void handleNoteRemoveEvent(NoteEventAsyncListener.NoteRemoveEvent noteRemoveEvent) {
        this.deleteNoteIndex(noteRemoveEvent.getNoteId());
    }

    @Override
    public void handleNoteUpdateEvent(NoteEventAsyncListener.NoteUpdateEvent noteUpdateEvent) {
        this.updateNoteIndex(noteUpdateEvent.getNoteId());
    }

    @Override
    public void handleParagraphCreateEvent(NoteEventAsyncListener.ParagraphCreateEvent paragraphCreateEvent) {
        this.addParagraphIndex(paragraphCreateEvent.getNodeId(), paragraphCreateEvent.getParagraphId());
    }

    @Override
    public void handleParagraphRemoveEvent(NoteEventAsyncListener.ParagraphRemoveEvent paragraphRemoveEvent) {
        this.deleteParagraphIndex(paragraphRemoveEvent.getNodeId(), paragraphRemoveEvent.getParagraphId());
    }

    @Override
    public void handleParagraphUpdateEvent(NoteEventAsyncListener.ParagraphUpdateEvent paragraphUpdateEvent) {
        this.updateParagraphIndex(paragraphUpdateEvent.getNodeId(), paragraphUpdateEvent.getParagraphId());
    }
}

