/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.storage;

import java.io.File;
import java.io.IOException;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.InterpreterInfoSaving;
import org.apache.zeppelin.notebook.NotebookAuthorizationInfoSaving;
import org.apache.zeppelin.storage.ConfigStorage;
import org.apache.zeppelin.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalConfigStorage
extends ConfigStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalConfigStorage.class);
    private File interpreterSettingPath;
    private File authorizationPath;
    private File credentialPath;

    public LocalConfigStorage(ZeppelinConfiguration zConf) {
        super(zConf);
        this.interpreterSettingPath = new File(zConf.getInterpreterSettingPath(true));
        this.authorizationPath = new File(zConf.getNotebookAuthorizationPath(true));
        this.credentialPath = new File(zConf.getCredentialsPath(true));
    }

    @Override
    public void save(InterpreterInfoSaving settingInfos) throws IOException {
        LOGGER.info("Save Interpreter Setting to {}", (Object)this.interpreterSettingPath.getAbsolutePath());
        FileUtils.atomicWriteToFile(settingInfos.toJson(), this.interpreterSettingPath);
    }

    @Override
    public InterpreterInfoSaving loadInterpreterSettings() throws IOException {
        if (!this.interpreterSettingPath.exists()) {
            LOGGER.warn("Interpreter Setting file {} is not existed", (Object)this.interpreterSettingPath);
            return null;
        }
        LOGGER.info("Load Interpreter Setting from file: {}", (Object)this.interpreterSettingPath);
        String json = FileUtils.readFromFile(this.interpreterSettingPath);
        return this.buildInterpreterInfoSaving(json);
    }

    @Override
    public void save(NotebookAuthorizationInfoSaving authorizationInfoSaving) throws IOException {
        LOGGER.info("Save notebook authorization to file: {}", (Object)this.authorizationPath);
        FileUtils.atomicWriteToFile(authorizationInfoSaving.toJson(), this.authorizationPath);
    }

    @Override
    public NotebookAuthorizationInfoSaving loadNotebookAuthorization() throws IOException {
        if (!this.authorizationPath.exists()) {
            LOGGER.warn("NotebookAuthorization file {} is not existed", (Object)this.authorizationPath);
            return null;
        }
        LOGGER.info("Load notebook authorization from file: {}", (Object)this.authorizationPath);
        String json = FileUtils.readFromFile(this.authorizationPath);
        return NotebookAuthorizationInfoSaving.fromJson(json);
    }

    @Override
    public String loadCredentials() throws IOException {
        if (!this.credentialPath.exists()) {
            LOGGER.warn("Credential file {} is not existed", (Object)this.credentialPath);
            return null;
        }
        LOGGER.info("Load Credential from file: {}", (Object)this.credentialPath);
        return FileUtils.readFromFile(this.credentialPath);
    }

    @Override
    public void saveCredentials(String credentials) throws IOException {
        LOGGER.info("Save Credentials to file: {}", (Object)this.credentialPath);
        EnumSet<PosixFilePermission> permissions = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE);
        FileUtils.atomicWriteToFile(credentials, this.credentialPath, permissions);
    }
}

