/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.api.core.graph.BatchGraphStatement;
import com.datastax.dse.driver.internal.core.graph.GraphStatementBase;
import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;

@Immutable
public class DefaultBatchGraphStatement
extends GraphStatementBase<BatchGraphStatement>
implements BatchGraphStatement {
    private final List<GraphTraversal> traversals;

    public DefaultBatchGraphStatement(Iterable<GraphTraversal> traversals, Boolean isIdempotent, Duration timeout, Node node, long timestamp, DriverExecutionProfile executionProfile, String executionProfileName, Map<String, ByteBuffer> customPayload, String graphName, String traversalSource, String subProtocol, ConsistencyLevel consistencyLevel, ConsistencyLevel readConsistencyLevel, ConsistencyLevel writeConsistencyLevel) {
        super(isIdempotent, timeout, node, timestamp, executionProfile, executionProfileName, customPayload, graphName, traversalSource, subProtocol, consistencyLevel, readConsistencyLevel, writeConsistencyLevel);
        this.traversals = ImmutableList.copyOf(traversals);
    }

    @Override
    @NonNull
    public DefaultBatchGraphStatement addTraversal(@NonNull GraphTraversal newTraversal) {
        return new DefaultBatchGraphStatement(((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.traversals)).add(newTraversal)).build(), this.isIdempotent(), this.getTimeout(), this.getNode(), this.getTimestamp(), this.getExecutionProfile(), this.getExecutionProfileName(), this.getCustomPayload(), this.getGraphName(), this.getTraversalSource(), this.getSubProtocol(), this.getConsistencyLevel(), this.getReadConsistencyLevel(), this.getWriteConsistencyLevel());
    }

    @Override
    @NonNull
    public DefaultBatchGraphStatement addTraversals(@NonNull Iterable<GraphTraversal> newTraversals) {
        return new DefaultBatchGraphStatement(((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.traversals)).addAll(newTraversals)).build(), this.isIdempotent(), this.getTimeout(), this.getNode(), this.getTimestamp(), this.getExecutionProfile(), this.getExecutionProfileName(), this.getCustomPayload(), this.getGraphName(), this.getTraversalSource(), this.getSubProtocol(), this.getConsistencyLevel(), this.getReadConsistencyLevel(), this.getWriteConsistencyLevel());
    }

    @Override
    public int size() {
        return this.traversals.size();
    }

    @Override
    protected BatchGraphStatement newInstance(Boolean isIdempotent, Duration timeout, Node node, long timestamp, DriverExecutionProfile executionProfile, String executionProfileName, Map<String, ByteBuffer> customPayload, String graphName, String traversalSource, String subProtocol, ConsistencyLevel consistencyLevel, ConsistencyLevel readConsistencyLevel, ConsistencyLevel writeConsistencyLevel) {
        return new DefaultBatchGraphStatement(this.traversals, isIdempotent, timeout, node, timestamp, executionProfile, executionProfileName, customPayload, graphName, traversalSource, subProtocol, consistencyLevel, readConsistencyLevel, writeConsistencyLevel);
    }

    @Override
    @NonNull
    public Iterator<GraphTraversal> iterator() {
        return this.traversals.iterator();
    }
}

