/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core;

import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.internal.core.metadata.DefaultEndPoint;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.datastax.oss.driver.shaded.guava.common.collect.Sets;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContactPoints {
    private static final Logger LOG = LoggerFactory.getLogger(ContactPoints.class);

    public static Set<EndPoint> merge(Set<EndPoint> programmaticContactPoints, List<String> configContactPoints, boolean resolve) {
        HashSet<EndPoint> result2 = Sets.newHashSet(programmaticContactPoints);
        for (String spec : configContactPoints) {
            for (InetSocketAddress address : ContactPoints.extract(spec, resolve)) {
                DefaultEndPoint endPoint = new DefaultEndPoint(address);
                boolean wasNew = result2.add(endPoint);
                if (wasNew) continue;
                LOG.warn("Duplicate contact point {}", (Object)address);
            }
        }
        return ImmutableSet.copyOf(result2);
    }

    private static Set<InetSocketAddress> extract(String spec, boolean resolve) {
        int port;
        int separator = spec.lastIndexOf(58);
        if (separator < 0) {
            LOG.warn("Ignoring invalid contact point {} (expecting host:port)", (Object)spec);
            return Collections.emptySet();
        }
        String host = spec.substring(0, separator);
        String portSpec = spec.substring(separator + 1);
        try {
            port = Integer.parseInt(portSpec);
        }
        catch (NumberFormatException e) {
            LOG.warn("Ignoring invalid contact point {} (expecting a number, got {})", (Object)spec, (Object)portSpec);
            return Collections.emptySet();
        }
        if (!resolve) {
            return ImmutableSet.of(InetSocketAddress.createUnresolved(host, port));
        }
        try {
            Object[] inetAddresses = InetAddress.getAllByName(host);
            if (inetAddresses.length > 1) {
                LOG.info("Contact point {} resolves to multiple addresses, will use them all ({})", (Object)spec, (Object)Arrays.deepToString(inetAddresses));
            }
            HashSet<InetSocketAddress> result2 = new HashSet<InetSocketAddress>();
            for (Object inetAddress : inetAddresses) {
                result2.add(new InetSocketAddress((InetAddress)inetAddress, port));
            }
            return result2;
        }
        catch (UnknownHostException e) {
            LOG.warn("Ignoring invalid contact point {} (unknown host {})", (Object)spec, (Object)host);
            return Collections.emptySet();
        }
    }
}

