/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TextFormat {
    private static final Printer DEFAULT_PRINTER = new Printer();
    private static final Printer SINGLE_LINE_PRINTER = Printer.access$100(new Printer(), true);
    private static final Printer UNICODE_PRINTER = Printer.access$200(new Printer(), false);
    private static final int BUFFER_SIZE = 4096;

    private TextFormat() {
    }

    public static void print(MessageOrBuilder message2, Appendable output) throws IOException {
        TextFormat.DEFAULT_PRINTER.print(message2, new TextGenerator(output));
    }

    public static void print(UnknownFieldSet fields2, Appendable output) throws IOException {
        TextFormat.DEFAULT_PRINTER.printUnknownFields(fields2, new TextGenerator(output));
    }

    public static String shortDebugString(MessageOrBuilder message2) {
        try {
            StringBuilder sb = new StringBuilder();
            TextFormat.SINGLE_LINE_PRINTER.print(message2, new TextGenerator(sb));
            return sb.toString().trim();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String shortDebugString(UnknownFieldSet fields2) {
        try {
            StringBuilder sb = new StringBuilder();
            TextFormat.SINGLE_LINE_PRINTER.printUnknownFields(fields2, new TextGenerator(sb));
            return sb.toString().trim();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String printToString(MessageOrBuilder message2) {
        try {
            StringBuilder text = new StringBuilder();
            TextFormat.print(message2, (Appendable)text);
            return text.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String printToString(UnknownFieldSet fields2) {
        try {
            StringBuilder text = new StringBuilder();
            TextFormat.print(fields2, (Appendable)text);
            return text.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String printToUnicodeString(MessageOrBuilder message2) {
        try {
            StringBuilder text = new StringBuilder();
            TextFormat.UNICODE_PRINTER.print(message2, new TextGenerator(text));
            return text.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String printToUnicodeString(UnknownFieldSet fields2) {
        try {
            StringBuilder text = new StringBuilder();
            TextFormat.UNICODE_PRINTER.printUnknownFields(fields2, new TextGenerator(text));
            return text.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void printField(Descriptors.FieldDescriptor field2, Object value2, Appendable output) throws IOException {
        TextFormat.DEFAULT_PRINTER.printField(field2, value2, new TextGenerator(output));
    }

    public static String printFieldToString(Descriptors.FieldDescriptor field2, Object value2) {
        try {
            StringBuilder text = new StringBuilder();
            TextFormat.printField(field2, value2, text);
            return text.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void printFieldValue(Descriptors.FieldDescriptor field2, Object value2, Appendable output) throws IOException {
        TextFormat.DEFAULT_PRINTER.printFieldValue(field2, value2, new TextGenerator(output));
    }

    public static void printUnknownFieldValue(int tag2, Object value2, Appendable output) throws IOException {
        TextFormat.printUnknownFieldValue(tag2, value2, new TextGenerator(output));
    }

    private static void printUnknownFieldValue(int tag2, Object value2, TextGenerator generator) throws IOException {
        switch (WireFormat.getTagWireType(tag2)) {
            case 0: {
                generator.print(TextFormat.unsignedToString((Long)value2));
                break;
            }
            case 5: {
                generator.print(String.format((Locale)null, "0x%08x", (Integer)value2));
                break;
            }
            case 1: {
                generator.print(String.format((Locale)null, "0x%016x", (Long)value2));
                break;
            }
            case 2: {
                generator.print("\"");
                generator.print(TextFormat.escapeBytes((ByteString)value2));
                generator.print("\"");
                break;
            }
            case 3: {
                TextFormat.DEFAULT_PRINTER.printUnknownFields((UnknownFieldSet)value2, generator);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad tag: " + tag2);
            }
        }
    }

    private static String unsignedToString(int value2) {
        if (value2 >= 0) {
            return Integer.toString(value2);
        }
        return Long.toString((long)value2 & 0xFFFFFFFFL);
    }

    private static String unsignedToString(long value2) {
        if (value2 >= 0L) {
            return Long.toString(value2);
        }
        return BigInteger.valueOf(value2 & Long.MAX_VALUE).setBit(63).toString();
    }

    public static void merge(Readable input, Message.Builder builder) throws IOException {
        TextFormat.merge(input, ExtensionRegistry.getEmptyRegistry(), builder);
    }

    public static void merge(CharSequence input, Message.Builder builder) throws ParseException {
        TextFormat.merge(input, ExtensionRegistry.getEmptyRegistry(), builder);
    }

    public static void merge(Readable input, ExtensionRegistry extensionRegistry, Message.Builder builder) throws IOException {
        TextFormat.merge(TextFormat.toStringBuilder(input), extensionRegistry, builder);
    }

    private static StringBuilder toStringBuilder(Readable input) throws IOException {
        int n;
        StringBuilder text = new StringBuilder();
        CharBuffer buffer = CharBuffer.allocate(4096);
        while ((n = input.read(buffer)) != -1) {
            buffer.flip();
            text.append(buffer, 0, n);
        }
        return text;
    }

    public static void merge(CharSequence input, ExtensionRegistry extensionRegistry, Message.Builder builder) throws ParseException {
        Tokenizer tokenizer = new Tokenizer(input);
        while (!tokenizer.atEnd()) {
            TextFormat.mergeField(tokenizer, extensionRegistry, builder);
        }
    }

    private static void mergeField(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, Message.Builder builder) throws ParseException {
        Descriptors.FieldDescriptor field2;
        CharSequence name2;
        Descriptors.Descriptor type2 = builder.getDescriptorForType();
        ExtensionRegistry.ExtensionInfo extension = null;
        if (tokenizer.tryConsume("[")) {
            name2 = new StringBuilder(tokenizer.consumeIdentifier());
            while (tokenizer.tryConsume(".")) {
                ((StringBuilder)name2).append('.');
                ((StringBuilder)name2).append(tokenizer.consumeIdentifier());
            }
            extension = extensionRegistry.findExtensionByName(((StringBuilder)name2).toString());
            if (extension == null) {
                throw tokenizer.parseExceptionPreviousToken("Extension \"" + name2 + "\" not found in the ExtensionRegistry.");
            }
            if (extension.descriptor.getContainingType() != type2) {
                throw tokenizer.parseExceptionPreviousToken("Extension \"" + name2 + "\" does not extend message type \"" + type2.getFullName() + "\".");
            }
            tokenizer.consume("]");
            field2 = extension.descriptor;
        } else {
            String lowerName;
            name2 = tokenizer.consumeIdentifier();
            field2 = type2.findFieldByName((String)name2);
            if (field2 == null && (field2 = type2.findFieldByName(lowerName = ((String)name2).toLowerCase(Locale.US))) != null && field2.getType() != Descriptors.FieldDescriptor.Type.GROUP) {
                field2 = null;
            }
            if (field2 != null && field2.getType() == Descriptors.FieldDescriptor.Type.GROUP && !field2.getMessageType().getName().equals(name2)) {
                field2 = null;
            }
            if (field2 == null) {
                throw tokenizer.parseExceptionPreviousToken("Message type \"" + type2.getFullName() + "\" has no field named \"" + (String)name2 + "\".");
            }
        }
        Object value2 = null;
        if (field2.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            String endToken;
            tokenizer.tryConsume(":");
            if (tokenizer.tryConsume("<")) {
                endToken = ">";
            } else {
                tokenizer.consume("{");
                endToken = "}";
            }
            Message.Builder subBuilder = extension == null ? builder.newBuilderForField(field2) : extension.defaultInstance.newBuilderForType();
            while (!tokenizer.tryConsume(endToken)) {
                if (tokenizer.atEnd()) {
                    throw tokenizer.parseException("Expected \"" + endToken + "\".");
                }
                TextFormat.mergeField(tokenizer, extensionRegistry, subBuilder);
            }
            value2 = subBuilder.buildPartial();
        } else {
            tokenizer.consume(":");
            switch (field2.getType()) {
                case INT32: 
                case SINT32: 
                case SFIXED32: {
                    value2 = tokenizer.consumeInt32();
                    break;
                }
                case INT64: 
                case SINT64: 
                case SFIXED64: {
                    value2 = tokenizer.consumeInt64();
                    break;
                }
                case UINT32: 
                case FIXED32: {
                    value2 = tokenizer.consumeUInt32();
                    break;
                }
                case UINT64: 
                case FIXED64: {
                    value2 = tokenizer.consumeUInt64();
                    break;
                }
                case FLOAT: {
                    value2 = Float.valueOf(tokenizer.consumeFloat());
                    break;
                }
                case DOUBLE: {
                    value2 = tokenizer.consumeDouble();
                    break;
                }
                case BOOL: {
                    value2 = tokenizer.consumeBoolean();
                    break;
                }
                case STRING: {
                    value2 = tokenizer.consumeString();
                    break;
                }
                case BYTES: {
                    value2 = tokenizer.consumeByteString();
                    break;
                }
                case ENUM: {
                    Descriptors.EnumDescriptor enumType = field2.getEnumType();
                    if (tokenizer.lookingAtInteger()) {
                        int number = tokenizer.consumeInt32();
                        value2 = enumType.findValueByNumber(number);
                        if (value2 != null) break;
                        throw tokenizer.parseExceptionPreviousToken("Enum type \"" + enumType.getFullName() + "\" has no value with number " + number + '.');
                    }
                    String id2 = tokenizer.consumeIdentifier();
                    value2 = enumType.findValueByName(id2);
                    if (value2 != null) break;
                    throw tokenizer.parseExceptionPreviousToken("Enum type \"" + enumType.getFullName() + "\" has no value named \"" + id2 + "\".");
                }
                case MESSAGE: 
                case GROUP: {
                    throw new RuntimeException("Can't get here.");
                }
            }
        }
        if (field2.isRepeated()) {
            builder.addRepeatedField(field2, value2);
        } else {
            builder.setField(field2, value2);
        }
    }

    static String escapeBytes(ByteString input) {
        StringBuilder builder = new StringBuilder(input.size());
        block12: for (int i2 = 0; i2 < input.size(); ++i2) {
            byte b = input.byteAt(i2);
            switch (b) {
                case 7: {
                    builder.append("\\a");
                    continue block12;
                }
                case 8: {
                    builder.append("\\b");
                    continue block12;
                }
                case 12: {
                    builder.append("\\f");
                    continue block12;
                }
                case 10: {
                    builder.append("\\n");
                    continue block12;
                }
                case 13: {
                    builder.append("\\r");
                    continue block12;
                }
                case 9: {
                    builder.append("\\t");
                    continue block12;
                }
                case 11: {
                    builder.append("\\v");
                    continue block12;
                }
                case 92: {
                    builder.append("\\\\");
                    continue block12;
                }
                case 39: {
                    builder.append("\\'");
                    continue block12;
                }
                case 34: {
                    builder.append("\\\"");
                    continue block12;
                }
                default: {
                    if (b >= 32) {
                        builder.append((char)b);
                        continue block12;
                    }
                    builder.append('\\');
                    builder.append((char)(48 + (b >>> 6 & 3)));
                    builder.append((char)(48 + (b >>> 3 & 7)));
                    builder.append((char)(48 + (b & 7)));
                }
            }
        }
        return builder.toString();
    }

    static ByteString unescapeBytes(CharSequence charString) throws InvalidEscapeSequenceException {
        ByteString input = ByteString.copyFromUtf8(charString.toString());
        byte[] result2 = new byte[input.size()];
        int pos2 = 0;
        for (int i2 = 0; i2 < input.size(); ++i2) {
            byte c = input.byteAt(i2);
            if (c == 92) {
                if (i2 + 1 < input.size()) {
                    int code;
                    if (TextFormat.isOctal(c = input.byteAt(++i2))) {
                        code = TextFormat.digitValue(c);
                        if (i2 + 1 < input.size() && TextFormat.isOctal(input.byteAt(i2 + 1))) {
                            code = code * 8 + TextFormat.digitValue(input.byteAt(++i2));
                        }
                        if (i2 + 1 < input.size() && TextFormat.isOctal(input.byteAt(i2 + 1))) {
                            code = code * 8 + TextFormat.digitValue(input.byteAt(++i2));
                        }
                        result2[pos2++] = (byte)code;
                        continue;
                    }
                    switch (c) {
                        case 97: {
                            result2[pos2++] = 7;
                            break;
                        }
                        case 98: {
                            result2[pos2++] = 8;
                            break;
                        }
                        case 102: {
                            result2[pos2++] = 12;
                            break;
                        }
                        case 110: {
                            result2[pos2++] = 10;
                            break;
                        }
                        case 114: {
                            result2[pos2++] = 13;
                            break;
                        }
                        case 116: {
                            result2[pos2++] = 9;
                            break;
                        }
                        case 118: {
                            result2[pos2++] = 11;
                            break;
                        }
                        case 92: {
                            result2[pos2++] = 92;
                            break;
                        }
                        case 39: {
                            result2[pos2++] = 39;
                            break;
                        }
                        case 34: {
                            result2[pos2++] = 34;
                            break;
                        }
                        case 120: {
                            code = 0;
                            if (i2 + 1 >= input.size() || !TextFormat.isHex(input.byteAt(i2 + 1))) {
                                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\x' with no digits");
                            }
                            code = TextFormat.digitValue(input.byteAt(++i2));
                            if (i2 + 1 < input.size() && TextFormat.isHex(input.byteAt(i2 + 1))) {
                                code = code * 16 + TextFormat.digitValue(input.byteAt(++i2));
                            }
                            result2[pos2++] = (byte)code;
                            break;
                        }
                        default: {
                            throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\" + (char)c + '\'');
                        }
                    }
                    continue;
                }
                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\' at end of string.");
            }
            result2[pos2++] = c;
        }
        return ByteString.copyFrom(result2, 0, pos2);
    }

    static String escapeText(String input) {
        return TextFormat.escapeBytes(ByteString.copyFromUtf8(input));
    }

    static String unescapeText(String input) throws InvalidEscapeSequenceException {
        return TextFormat.unescapeBytes(input).toStringUtf8();
    }

    private static boolean isOctal(byte c) {
        return 48 <= c && c <= 55;
    }

    private static boolean isHex(byte c) {
        return 48 <= c && c <= 57 || 97 <= c && c <= 102 || 65 <= c && c <= 70;
    }

    private static int digitValue(byte c) {
        if (48 <= c && c <= 57) {
            return c - 48;
        }
        if (97 <= c && c <= 122) {
            return c - 97 + 10;
        }
        return c - 65 + 10;
    }

    static int parseInt32(String text) throws NumberFormatException {
        return (int)TextFormat.parseInteger(text, true, false);
    }

    static int parseUInt32(String text) throws NumberFormatException {
        return (int)TextFormat.parseInteger(text, false, false);
    }

    static long parseInt64(String text) throws NumberFormatException {
        return TextFormat.parseInteger(text, true, true);
    }

    static long parseUInt64(String text) throws NumberFormatException {
        return TextFormat.parseInteger(text, false, true);
    }

    private static long parseInteger(String text, boolean isSigned, boolean isLong) throws NumberFormatException {
        int pos2 = 0;
        boolean negative = false;
        if (text.startsWith("-", pos2)) {
            if (!isSigned) {
                throw new NumberFormatException("Number must be positive: " + text);
            }
            ++pos2;
            negative = true;
        }
        int radix = 10;
        if (text.startsWith("0x", pos2)) {
            pos2 += 2;
            radix = 16;
        } else if (text.startsWith("0", pos2)) {
            radix = 8;
        }
        String numberText = text.substring(pos2);
        long result2 = 0L;
        if (numberText.length() < 16) {
            result2 = Long.parseLong(numberText, radix);
            if (negative) {
                result2 = -result2;
            }
            if (!isLong) {
                if (isSigned) {
                    if (result2 > Integer.MAX_VALUE || result2 < Integer.MIN_VALUE) {
                        throw new NumberFormatException("Number out of range for 32-bit signed integer: " + text);
                    }
                } else if (result2 >= 0x100000000L || result2 < 0L) {
                    throw new NumberFormatException("Number out of range for 32-bit unsigned integer: " + text);
                }
            }
        } else {
            BigInteger bigValue = new BigInteger(numberText, radix);
            if (negative) {
                bigValue = bigValue.negate();
            }
            if (!isLong) {
                if (isSigned) {
                    if (bigValue.bitLength() > 31) {
                        throw new NumberFormatException("Number out of range for 32-bit signed integer: " + text);
                    }
                } else if (bigValue.bitLength() > 32) {
                    throw new NumberFormatException("Number out of range for 32-bit unsigned integer: " + text);
                }
            } else if (isSigned) {
                if (bigValue.bitLength() > 63) {
                    throw new NumberFormatException("Number out of range for 64-bit signed integer: " + text);
                }
            } else if (bigValue.bitLength() > 64) {
                throw new NumberFormatException("Number out of range for 64-bit unsigned integer: " + text);
            }
            result2 = bigValue.longValue();
        }
        return result2;
    }

    static class InvalidEscapeSequenceException
    extends IOException {
        private static final long serialVersionUID = -8164033650142593304L;

        InvalidEscapeSequenceException(String description) {
            super(description);
        }
    }

    public static class ParseException
    extends IOException {
        private static final long serialVersionUID = 3196188060225107702L;
        private final int line;
        private final int column;

        public ParseException(String message2) {
            this(-1, -1, message2);
        }

        public ParseException(int line, int column, String message2) {
            super(Integer.toString(line) + ":" + column + ": " + message2);
            this.line = line;
            this.column = column;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Tokenizer {
        private final CharSequence text;
        private final Matcher matcher;
        private String currentToken;
        private int pos = 0;
        private int line = 0;
        private int column = 0;
        private int previousLine = 0;
        private int previousColumn = 0;
        private static final Pattern WHITESPACE = Pattern.compile("(\\s|(#.*$))++", 8);
        private static final Pattern TOKEN = Pattern.compile("[a-zA-Z_][0-9a-zA-Z_+-]*+|[.]?[0-9+-][0-9a-zA-Z_.+-]*+|\"([^\"\n\\\\]|\\\\.)*+(\"|\\\\?$)|'([^'\n\\\\]|\\\\.)*+('|\\\\?$)", 8);
        private static final Pattern DOUBLE_INFINITY = Pattern.compile("-?inf(inity)?", 2);
        private static final Pattern FLOAT_INFINITY = Pattern.compile("-?inf(inity)?f?", 2);
        private static final Pattern FLOAT_NAN = Pattern.compile("nanf?", 2);

        private Tokenizer(CharSequence text) {
            this.text = text;
            this.matcher = WHITESPACE.matcher(text);
            this.skipWhitespace();
            this.nextToken();
        }

        public boolean atEnd() {
            return this.currentToken.length() == 0;
        }

        public void nextToken() {
            this.previousLine = this.line;
            this.previousColumn = this.column;
            while (this.pos < this.matcher.regionStart()) {
                if (this.text.charAt(this.pos) == '\n') {
                    ++this.line;
                    this.column = 0;
                } else {
                    ++this.column;
                }
                ++this.pos;
            }
            if (this.matcher.regionStart() == this.matcher.regionEnd()) {
                this.currentToken = "";
            } else {
                this.matcher.usePattern(TOKEN);
                if (this.matcher.lookingAt()) {
                    this.currentToken = this.matcher.group();
                    this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
                } else {
                    this.currentToken = String.valueOf(this.text.charAt(this.pos));
                    this.matcher.region(this.pos + 1, this.matcher.regionEnd());
                }
                this.skipWhitespace();
            }
        }

        private void skipWhitespace() {
            this.matcher.usePattern(WHITESPACE);
            if (this.matcher.lookingAt()) {
                this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
            }
        }

        public boolean tryConsume(String token) {
            if (this.currentToken.equals(token)) {
                this.nextToken();
                return true;
            }
            return false;
        }

        public void consume(String token) throws ParseException {
            if (!this.tryConsume(token)) {
                throw this.parseException("Expected \"" + token + "\".");
            }
        }

        public boolean lookingAtInteger() {
            if (this.currentToken.length() == 0) {
                return false;
            }
            char c = this.currentToken.charAt(0);
            return '0' <= c && c <= '9' || c == '-' || c == '+';
        }

        public String consumeIdentifier() throws ParseException {
            for (int i2 = 0; i2 < this.currentToken.length(); ++i2) {
                char c = this.currentToken.charAt(i2);
                if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_' || c == '.') continue;
                throw this.parseException("Expected identifier.");
            }
            String result2 = this.currentToken;
            this.nextToken();
            return result2;
        }

        public int consumeInt32() throws ParseException {
            try {
                int result2 = TextFormat.parseInt32(this.currentToken);
                this.nextToken();
                return result2;
            }
            catch (NumberFormatException e) {
                throw this.integerParseException(e);
            }
        }

        public int consumeUInt32() throws ParseException {
            try {
                int result2 = TextFormat.parseUInt32(this.currentToken);
                this.nextToken();
                return result2;
            }
            catch (NumberFormatException e) {
                throw this.integerParseException(e);
            }
        }

        public long consumeInt64() throws ParseException {
            try {
                long result2 = TextFormat.parseInt64(this.currentToken);
                this.nextToken();
                return result2;
            }
            catch (NumberFormatException e) {
                throw this.integerParseException(e);
            }
        }

        public long consumeUInt64() throws ParseException {
            try {
                long result2 = TextFormat.parseUInt64(this.currentToken);
                this.nextToken();
                return result2;
            }
            catch (NumberFormatException e) {
                throw this.integerParseException(e);
            }
        }

        public double consumeDouble() throws ParseException {
            if (DOUBLE_INFINITY.matcher(this.currentToken).matches()) {
                boolean negative = this.currentToken.startsWith("-");
                this.nextToken();
                return negative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if (this.currentToken.equalsIgnoreCase("nan")) {
                this.nextToken();
                return Double.NaN;
            }
            try {
                double result2 = Double.parseDouble(this.currentToken);
                this.nextToken();
                return result2;
            }
            catch (NumberFormatException e) {
                throw this.floatParseException(e);
            }
        }

        public float consumeFloat() throws ParseException {
            if (FLOAT_INFINITY.matcher(this.currentToken).matches()) {
                boolean negative = this.currentToken.startsWith("-");
                this.nextToken();
                return negative ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
            }
            if (FLOAT_NAN.matcher(this.currentToken).matches()) {
                this.nextToken();
                return Float.NaN;
            }
            try {
                float result2 = Float.parseFloat(this.currentToken);
                this.nextToken();
                return result2;
            }
            catch (NumberFormatException e) {
                throw this.floatParseException(e);
            }
        }

        public boolean consumeBoolean() throws ParseException {
            if (this.currentToken.equals("true") || this.currentToken.equals("t") || this.currentToken.equals("1")) {
                this.nextToken();
                return true;
            }
            if (this.currentToken.equals("false") || this.currentToken.equals("f") || this.currentToken.equals("0")) {
                this.nextToken();
                return false;
            }
            throw this.parseException("Expected \"true\" or \"false\".");
        }

        public String consumeString() throws ParseException {
            return this.consumeByteString().toStringUtf8();
        }

        public ByteString consumeByteString() throws ParseException {
            ArrayList<ByteString> list2 = new ArrayList<ByteString>();
            this.consumeByteString(list2);
            while (this.currentToken.startsWith("'") || this.currentToken.startsWith("\"")) {
                this.consumeByteString(list2);
            }
            return ByteString.copyFrom(list2);
        }

        private void consumeByteString(List<ByteString> list2) throws ParseException {
            char quote2;
            char c = quote2 = this.currentToken.length() > 0 ? this.currentToken.charAt(0) : (char)'\u0000';
            if (quote2 != '\"' && quote2 != '\'') {
                throw this.parseException("Expected string.");
            }
            if (this.currentToken.length() < 2 || this.currentToken.charAt(this.currentToken.length() - 1) != quote2) {
                throw this.parseException("String missing ending quote.");
            }
            try {
                String escaped = this.currentToken.substring(1, this.currentToken.length() - 1);
                ByteString result2 = TextFormat.unescapeBytes(escaped);
                this.nextToken();
                list2.add(result2);
            }
            catch (InvalidEscapeSequenceException e) {
                throw this.parseException(e.getMessage());
            }
        }

        public ParseException parseException(String description) {
            return new ParseException(this.line + 1, this.column + 1, description);
        }

        public ParseException parseExceptionPreviousToken(String description) {
            return new ParseException(this.previousLine + 1, this.previousColumn + 1, description);
        }

        private ParseException integerParseException(NumberFormatException e) {
            return this.parseException("Couldn't parse integer: " + e.getMessage());
        }

        private ParseException floatParseException(NumberFormatException e) {
            return this.parseException("Couldn't parse number: " + e.getMessage());
        }
    }

    private static final class TextGenerator {
        private final Appendable output;
        private final StringBuilder indent = new StringBuilder();
        private boolean atStartOfLine = true;

        private TextGenerator(Appendable output) {
            this.output = output;
        }

        public void indent() {
            this.indent.append("  ");
        }

        public void outdent() {
            int length2 = this.indent.length();
            if (length2 == 0) {
                throw new IllegalArgumentException(" Outdent() without matching Indent().");
            }
            this.indent.delete(length2 - 2, length2);
        }

        public void print(CharSequence text) throws IOException {
            int size2 = text.length();
            int pos2 = 0;
            for (int i2 = 0; i2 < size2; ++i2) {
                if (text.charAt(i2) != '\n') continue;
                this.write(text.subSequence(pos2, size2), i2 - pos2 + 1);
                pos2 = i2 + 1;
                this.atStartOfLine = true;
            }
            this.write(text.subSequence(pos2, size2), size2 - pos2);
        }

        private void write(CharSequence data, int size2) throws IOException {
            if (size2 == 0) {
                return;
            }
            if (this.atStartOfLine) {
                this.atStartOfLine = false;
                this.output.append(this.indent);
            }
            this.output.append(data);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Printer {
        boolean singleLineMode = false;
        boolean escapeNonAscii = true;

        private Printer() {
        }

        private Printer setSingleLineMode(boolean singleLineMode) {
            this.singleLineMode = singleLineMode;
            return this;
        }

        private Printer setEscapeNonAscii(boolean escapeNonAscii) {
            this.escapeNonAscii = escapeNonAscii;
            return this;
        }

        private void print(MessageOrBuilder message2, TextGenerator generator) throws IOException {
            for (Map.Entry<Descriptors.FieldDescriptor, Object> field2 : message2.getAllFields().entrySet()) {
                this.printField(field2.getKey(), field2.getValue(), generator);
            }
            this.printUnknownFields(message2.getUnknownFields(), generator);
        }

        private void printField(Descriptors.FieldDescriptor field2, Object value2, TextGenerator generator) throws IOException {
            if (field2.isRepeated()) {
                for (Object element : (List)value2) {
                    this.printSingleField(field2, element, generator);
                }
            } else {
                this.printSingleField(field2, value2, generator);
            }
        }

        private void printSingleField(Descriptors.FieldDescriptor field2, Object value2, TextGenerator generator) throws IOException {
            if (field2.isExtension()) {
                generator.print("[");
                if (field2.getContainingType().getOptions().getMessageSetWireFormat() && field2.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && field2.isOptional() && field2.getExtensionScope() == field2.getMessageType()) {
                    generator.print(field2.getMessageType().getFullName());
                } else {
                    generator.print(field2.getFullName());
                }
                generator.print("]");
            } else if (field2.getType() == Descriptors.FieldDescriptor.Type.GROUP) {
                generator.print(field2.getMessageType().getName());
            } else {
                generator.print(field2.getName());
            }
            if (field2.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                if (this.singleLineMode) {
                    generator.print(" { ");
                } else {
                    generator.print(" {\n");
                    generator.indent();
                }
            } else {
                generator.print(": ");
            }
            this.printFieldValue(field2, value2, generator);
            if (field2.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                if (this.singleLineMode) {
                    generator.print("} ");
                } else {
                    generator.outdent();
                    generator.print("}\n");
                }
            } else if (this.singleLineMode) {
                generator.print(" ");
            } else {
                generator.print("\n");
            }
        }

        private void printFieldValue(Descriptors.FieldDescriptor field2, Object value2, TextGenerator generator) throws IOException {
            switch (field2.getType()) {
                case INT32: 
                case SINT32: 
                case SFIXED32: {
                    generator.print(((Integer)value2).toString());
                    break;
                }
                case INT64: 
                case SINT64: 
                case SFIXED64: {
                    generator.print(((Long)value2).toString());
                    break;
                }
                case BOOL: {
                    generator.print(((Boolean)value2).toString());
                    break;
                }
                case FLOAT: {
                    generator.print(((Float)value2).toString());
                    break;
                }
                case DOUBLE: {
                    generator.print(((Double)value2).toString());
                    break;
                }
                case UINT32: 
                case FIXED32: {
                    generator.print(TextFormat.unsignedToString((Integer)value2));
                    break;
                }
                case UINT64: 
                case FIXED64: {
                    generator.print(TextFormat.unsignedToString((Long)value2));
                    break;
                }
                case STRING: {
                    generator.print("\"");
                    generator.print(this.escapeNonAscii ? TextFormat.escapeText((String)value2) : (String)value2);
                    generator.print("\"");
                    break;
                }
                case BYTES: {
                    generator.print("\"");
                    generator.print(TextFormat.escapeBytes((ByteString)value2));
                    generator.print("\"");
                    break;
                }
                case ENUM: {
                    generator.print(((Descriptors.EnumValueDescriptor)value2).getName());
                    break;
                }
                case MESSAGE: 
                case GROUP: {
                    this.print((Message)value2, generator);
                }
            }
        }

        private void printUnknownFields(UnknownFieldSet unknownFields, TextGenerator generator) throws IOException {
            for (Map.Entry<Integer, UnknownFieldSet.Field> entry : unknownFields.asMap().entrySet()) {
                int number = entry.getKey();
                UnknownFieldSet.Field field2 = entry.getValue();
                this.printUnknownField(number, 0, field2.getVarintList(), generator);
                this.printUnknownField(number, 5, field2.getFixed32List(), generator);
                this.printUnknownField(number, 1, field2.getFixed64List(), generator);
                this.printUnknownField(number, 2, field2.getLengthDelimitedList(), generator);
                for (UnknownFieldSet value2 : field2.getGroupList()) {
                    generator.print(entry.getKey().toString());
                    if (this.singleLineMode) {
                        generator.print(" { ");
                    } else {
                        generator.print(" {\n");
                        generator.indent();
                    }
                    this.printUnknownFields(value2, generator);
                    if (this.singleLineMode) {
                        generator.print("} ");
                        continue;
                    }
                    generator.outdent();
                    generator.print("}\n");
                }
            }
        }

        private void printUnknownField(int number, int wireType, List<?> values, TextGenerator generator) throws IOException {
            for (Object value2 : values) {
                generator.print(String.valueOf(number));
                generator.print(": ");
                TextFormat.printUnknownFieldValue(wireType, value2, generator);
                generator.print(this.singleLineMode ? " " : "\n");
            }
        }

        static /* synthetic */ Printer access$100(Printer x0, boolean x1) {
            return x0.setSingleLineMode(x1);
        }

        static /* synthetic */ Printer access$200(Printer x0, boolean x1) {
            return x0.setEscapeNonAscii(x1);
        }
    }
}

